# streamlit-tfx: TensorFlow Extended visualizers for Streamlit apps

`streamlit-tfx` provides utilities for visualizing [TensorFlow Extended](https://www.tensorflow.org/tfx)
artifacts in [Streamlit](https://streamlit.io) apps.

[![GitHub][github_badge]][github_link] [![PyPI][pypi_badge]][pypi_link]

> ### 🌱 Just sprouting!
> This project is in the very beginning stages of development. It's not well tested and is only intended to be used as a demo.

## Installation

``` shell
pip install streamlit-tfx
```

## Getting started

```python
import streamlit_tfx as st_tfx

st_tfx.display(item)
st_tfx.display_statistics(statistics)
st_tfx.display_schema(schema)
st_tfx.display_anomalies(anomalies)
st_tfx.display_eval_result_plot(eval_result)
st_tfx.display_eval_result_slicing_attributions(eval_result)
st_tfx.display_eval_result_slicing_metrics(eval_result)
st_tfx.display_eval_results_time_series(eval_results)
```

---

Most artifacts in `tests/artifacts/` were generated by running the [TFX Keras Component tutorial](https://www.tensorflow.org/tfx/tutorials/tfx/components_keras).
The anomalies artifact with anomalies was generated by running the [TensorFlow Model Analysis tutorial](https://www.tensorflow.org/tfx/tutorials/model_analysis/tfma_basic).

🚀 Inspired by [spacy-streamlit](https://github.com/explosion/spacy-streamlit)
and [streamlit-player](https://github.com/okld/streamlit-player).

[github_badge]: https://badgen.net/badge/icon/GitHub?icon=github&color=black&label
[github_link]: https://github.com/codesue/streamlit-tfx

[pypi_badge]: https://badgen.net/pypi/v/streamlit-tfx?icon=pypi&color=black&label
[pypi_link]: https://pypi.org/project/streamlit-tfx
