# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.fragments_derivations_creds import FragmentsDerivationsCreds  # noqa: F401,E501


class SecretAccessCredsReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'protection_key_derivation_creds': 'FragmentsDerivationsCreds',
        'secret_enc_val': 'str',
        'secret_id': 'int',
        'secret_name': 'str',
        'secret_type': 'str',
        'secret_version': 'int'
    }

    attribute_map = {
        'protection_key_derivation_creds': 'protection_key_derivation_creds',
        'secret_enc_val': 'secret_enc_val',
        'secret_id': 'secret_id',
        'secret_name': 'secret_name',
        'secret_type': 'secret_type',
        'secret_version': 'secret_version'
    }

    def __init__(self, protection_key_derivation_creds=None, secret_enc_val=None, secret_id=None, secret_name=None, secret_type=None, secret_version=None):  # noqa: E501
        """SecretAccessCredsReplyObj - a model defined in Swagger"""  # noqa: E501

        self._protection_key_derivation_creds = None
        self._secret_enc_val = None
        self._secret_id = None
        self._secret_name = None
        self._secret_type = None
        self._secret_version = None
        self.discriminator = None

        if protection_key_derivation_creds is not None:
            self.protection_key_derivation_creds = protection_key_derivation_creds
        if secret_enc_val is not None:
            self.secret_enc_val = secret_enc_val
        if secret_id is not None:
            self.secret_id = secret_id
        if secret_name is not None:
            self.secret_name = secret_name
        if secret_type is not None:
            self.secret_type = secret_type
        if secret_version is not None:
            self.secret_version = secret_version

    @property
    def protection_key_derivation_creds(self):
        """Gets the protection_key_derivation_creds of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The protection_key_derivation_creds of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: FragmentsDerivationsCreds
        """
        return self._protection_key_derivation_creds

    @protection_key_derivation_creds.setter
    def protection_key_derivation_creds(self, protection_key_derivation_creds):
        """Sets the protection_key_derivation_creds of this SecretAccessCredsReplyObj.


        :param protection_key_derivation_creds: The protection_key_derivation_creds of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: FragmentsDerivationsCreds
        """

        self._protection_key_derivation_creds = protection_key_derivation_creds

    @property
    def secret_enc_val(self):
        """Gets the secret_enc_val of this SecretAccessCredsReplyObj.  # noqa: E501

        The encrypted secret value.  # noqa: E501

        :return: The secret_enc_val of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._secret_enc_val

    @secret_enc_val.setter
    def secret_enc_val(self, secret_enc_val):
        """Sets the secret_enc_val of this SecretAccessCredsReplyObj.

        The encrypted secret value.  # noqa: E501

        :param secret_enc_val: The secret_enc_val of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._secret_enc_val = secret_enc_val

    @property
    def secret_id(self):
        """Gets the secret_id of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The secret_id of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """Sets the secret_id of this SecretAccessCredsReplyObj.


        :param secret_id: The secret_id of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._secret_id = secret_id

    @property
    def secret_name(self):
        """Gets the secret_name of this SecretAccessCredsReplyObj.  # noqa: E501

        The name, id, version and type of the secret item  # noqa: E501

        :return: The secret_name of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._secret_name

    @secret_name.setter
    def secret_name(self, secret_name):
        """Sets the secret_name of this SecretAccessCredsReplyObj.

        The name, id, version and type of the secret item  # noqa: E501

        :param secret_name: The secret_name of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._secret_name = secret_name

    @property
    def secret_type(self):
        """Gets the secret_type of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The secret_type of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._secret_type

    @secret_type.setter
    def secret_type(self, secret_type):
        """Sets the secret_type of this SecretAccessCredsReplyObj.


        :param secret_type: The secret_type of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._secret_type = secret_type

    @property
    def secret_version(self):
        """Gets the secret_version of this SecretAccessCredsReplyObj.  # noqa: E501


        :return: The secret_version of this SecretAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._secret_version

    @secret_version.setter
    def secret_version(self, secret_version):
        """Sets the secret_version of this SecretAccessCredsReplyObj.


        :param secret_version: The secret_version of this SecretAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._secret_version = secret_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SecretAccessCredsReplyObj, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecretAccessCredsReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
