# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class RSADecryptCreds(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'kf_ms_hosts_dns_map': 'dict(str, str)',
        'certificates': 'str',
        'credential': 'str',
        'customer_fragment_id': 'str',
        'expiry': 'int',
        'item_size': 'int',
        'item_type': 'str',
        'item_version': 'int',
        'public_value': 'str',
        'restricted_cipher': 'str'
    }

    attribute_map = {
        'kf_ms_hosts_dns_map': 'KFMsHostsDNSMap',
        'certificates': 'certificates',
        'credential': 'credential',
        'customer_fragment_id': 'customer_fragment_id',
        'expiry': 'expiry',
        'item_size': 'item_size',
        'item_type': 'item_type',
        'item_version': 'item_version',
        'public_value': 'public_value',
        'restricted_cipher': 'restricted_cipher'
    }

    def __init__(self, kf_ms_hosts_dns_map=None, certificates=None, credential=None, customer_fragment_id=None, expiry=None, item_size=None, item_type=None, item_version=None, public_value=None, restricted_cipher=None):  # noqa: E501
        """RSADecryptCreds - a model defined in Swagger"""  # noqa: E501

        self._kf_ms_hosts_dns_map = None
        self._certificates = None
        self._credential = None
        self._customer_fragment_id = None
        self._expiry = None
        self._item_size = None
        self._item_type = None
        self._item_version = None
        self._public_value = None
        self._restricted_cipher = None
        self.discriminator = None

        if kf_ms_hosts_dns_map is not None:
            self.kf_ms_hosts_dns_map = kf_ms_hosts_dns_map
        if certificates is not None:
            self.certificates = certificates
        if credential is not None:
            self.credential = credential
        if customer_fragment_id is not None:
            self.customer_fragment_id = customer_fragment_id
        if expiry is not None:
            self.expiry = expiry
        if item_size is not None:
            self.item_size = item_size
        if item_type is not None:
            self.item_type = item_type
        if item_version is not None:
            self.item_version = item_version
        if public_value is not None:
            self.public_value = public_value
        if restricted_cipher is not None:
            self.restricted_cipher = restricted_cipher

    @property
    def kf_ms_hosts_dns_map(self):
        """Gets the kf_ms_hosts_dns_map of this RSADecryptCreds.  # noqa: E501

        Mapping between the serial number of the item fragments and the KFMs hosts DNS in which they are stored.  # noqa: E501

        :return: The kf_ms_hosts_dns_map of this RSADecryptCreds.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._kf_ms_hosts_dns_map

    @kf_ms_hosts_dns_map.setter
    def kf_ms_hosts_dns_map(self, kf_ms_hosts_dns_map):
        """Sets the kf_ms_hosts_dns_map of this RSADecryptCreds.

        Mapping between the serial number of the item fragments and the KFMs hosts DNS in which they are stored.  # noqa: E501

        :param kf_ms_hosts_dns_map: The kf_ms_hosts_dns_map of this RSADecryptCreds.  # noqa: E501
        :type: dict(str, str)
        """

        self._kf_ms_hosts_dns_map = kf_ms_hosts_dns_map

    @property
    def certificates(self):
        """Gets the certificates of this RSADecryptCreds.  # noqa: E501


        :return: The certificates of this RSADecryptCreds.  # noqa: E501
        :rtype: str
        """
        return self._certificates

    @certificates.setter
    def certificates(self, certificates):
        """Sets the certificates of this RSADecryptCreds.


        :param certificates: The certificates of this RSADecryptCreds.  # noqa: E501
        :type: str
        """

        self._certificates = certificates

    @property
    def credential(self):
        """Gets the credential of this RSADecryptCreds.  # noqa: E501

        Temporary credentials string (JWT format)  # noqa: E501

        :return: The credential of this RSADecryptCreds.  # noqa: E501
        :rtype: str
        """
        return self._credential

    @credential.setter
    def credential(self, credential):
        """Sets the credential of this RSADecryptCreds.

        Temporary credentials string (JWT format)  # noqa: E501

        :param credential: The credential of this RSADecryptCreds.  # noqa: E501
        :type: str
        """

        self._credential = credential

    @property
    def customer_fragment_id(self):
        """Gets the customer_fragment_id of this RSADecryptCreds.  # noqa: E501

        The customer fragment ID associated with this item (if any).  # noqa: E501

        :return: The customer_fragment_id of this RSADecryptCreds.  # noqa: E501
        :rtype: str
        """
        return self._customer_fragment_id

    @customer_fragment_id.setter
    def customer_fragment_id(self, customer_fragment_id):
        """Sets the customer_fragment_id of this RSADecryptCreds.

        The customer fragment ID associated with this item (if any).  # noqa: E501

        :param customer_fragment_id: The customer_fragment_id of this RSADecryptCreds.  # noqa: E501
        :type: str
        """

        self._customer_fragment_id = customer_fragment_id

    @property
    def expiry(self):
        """Gets the expiry of this RSADecryptCreds.  # noqa: E501

        Credentials expiration date  # noqa: E501

        :return: The expiry of this RSADecryptCreds.  # noqa: E501
        :rtype: int
        """
        return self._expiry

    @expiry.setter
    def expiry(self, expiry):
        """Sets the expiry of this RSADecryptCreds.

        Credentials expiration date  # noqa: E501

        :param expiry: The expiry of this RSADecryptCreds.  # noqa: E501
        :type: int
        """

        self._expiry = expiry

    @property
    def item_size(self):
        """Gets the item_size of this RSADecryptCreds.  # noqa: E501


        :return: The item_size of this RSADecryptCreds.  # noqa: E501
        :rtype: int
        """
        return self._item_size

    @item_size.setter
    def item_size(self, item_size):
        """Sets the item_size of this RSADecryptCreds.


        :param item_size: The item_size of this RSADecryptCreds.  # noqa: E501
        :type: int
        """

        self._item_size = item_size

    @property
    def item_type(self):
        """Gets the item_type of this RSADecryptCreds.  # noqa: E501


        :return: The item_type of this RSADecryptCreds.  # noqa: E501
        :rtype: str
        """
        return self._item_type

    @item_type.setter
    def item_type(self, item_type):
        """Sets the item_type of this RSADecryptCreds.


        :param item_type: The item_type of this RSADecryptCreds.  # noqa: E501
        :type: str
        """

        self._item_type = item_type

    @property
    def item_version(self):
        """Gets the item_version of this RSADecryptCreds.  # noqa: E501

        The version, type, size and public key value of the item that the fragments belong to  # noqa: E501

        :return: The item_version of this RSADecryptCreds.  # noqa: E501
        :rtype: int
        """
        return self._item_version

    @item_version.setter
    def item_version(self, item_version):
        """Sets the item_version of this RSADecryptCreds.

        The version, type, size and public key value of the item that the fragments belong to  # noqa: E501

        :param item_version: The item_version of this RSADecryptCreds.  # noqa: E501
        :type: int
        """

        self._item_version = item_version

    @property
    def public_value(self):
        """Gets the public_value of this RSADecryptCreds.  # noqa: E501


        :return: The public_value of this RSADecryptCreds.  # noqa: E501
        :rtype: str
        """
        return self._public_value

    @public_value.setter
    def public_value(self, public_value):
        """Sets the public_value of this RSADecryptCreds.


        :param public_value: The public_value of this RSADecryptCreds.  # noqa: E501
        :type: str
        """

        self._public_value = public_value

    @property
    def restricted_cipher(self):
        """Gets the restricted_cipher of this RSADecryptCreds.  # noqa: E501

        In case not empty, the derivation operation will be restricted to this derivation data  # noqa: E501

        :return: The restricted_cipher of this RSADecryptCreds.  # noqa: E501
        :rtype: str
        """
        return self._restricted_cipher

    @restricted_cipher.setter
    def restricted_cipher(self, restricted_cipher):
        """Sets the restricted_cipher of this RSADecryptCreds.

        In case not empty, the derivation operation will be restricted to this derivation data  # noqa: E501

        :param restricted_cipher: The restricted_cipher of this RSADecryptCreds.  # noqa: E501
        :type: str
        """

        self._restricted_cipher = restricted_cipher

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RSADecryptCreds, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RSADecryptCreds):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
