# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.fragment_type import FragmentType  # noqa: F401,E501


class GetFragmentDetailsReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account_id': 'str',
        'fragment_id': 'str',
        'type': 'FragmentType'
    }

    attribute_map = {
        'account_id': 'AccountId',
        'fragment_id': 'FragmentId',
        'type': 'Type'
    }

    def __init__(self, account_id=None, fragment_id=None, type=None):  # noqa: E501
        """GetFragmentDetailsReplyObj - a model defined in Swagger"""  # noqa: E501

        self._account_id = None
        self._fragment_id = None
        self._type = None
        self.discriminator = None

        if account_id is not None:
            self.account_id = account_id
        if fragment_id is not None:
            self.fragment_id = fragment_id
        if type is not None:
            self.type = type

    @property
    def account_id(self):
        """Gets the account_id of this GetFragmentDetailsReplyObj.  # noqa: E501


        :return: The account_id of this GetFragmentDetailsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this GetFragmentDetailsReplyObj.


        :param account_id: The account_id of this GetFragmentDetailsReplyObj.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def fragment_id(self):
        """Gets the fragment_id of this GetFragmentDetailsReplyObj.  # noqa: E501


        :return: The fragment_id of this GetFragmentDetailsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._fragment_id

    @fragment_id.setter
    def fragment_id(self, fragment_id):
        """Sets the fragment_id of this GetFragmentDetailsReplyObj.


        :param fragment_id: The fragment_id of this GetFragmentDetailsReplyObj.  # noqa: E501
        :type: str
        """

        self._fragment_id = fragment_id

    @property
    def type(self):
        """Gets the type of this GetFragmentDetailsReplyObj.  # noqa: E501


        :return: The type of this GetFragmentDetailsReplyObj.  # noqa: E501
        :rtype: FragmentType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this GetFragmentDetailsReplyObj.


        :param type: The type of this GetFragmentDetailsReplyObj.  # noqa: E501
        :type: FragmentType
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetFragmentDetailsReplyObj, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetFragmentDetailsReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
