# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DynamicSecretProducerCredsReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'expiry': 'int',
        'producer_protection_key_derivation_creds': 'str'
    }

    attribute_map = {
        'expiry': 'expiry',
        'producer_protection_key_derivation_creds': 'producer_protection_key_derivation_creds'
    }

    def __init__(self, expiry=None, producer_protection_key_derivation_creds=None):  # noqa: E501
        """DynamicSecretProducerCredsReplyObj - a model defined in Swagger"""  # noqa: E501

        self._expiry = None
        self._producer_protection_key_derivation_creds = None
        self.discriminator = None

        if expiry is not None:
            self.expiry = expiry
        if producer_protection_key_derivation_creds is not None:
            self.producer_protection_key_derivation_creds = producer_protection_key_derivation_creds

    @property
    def expiry(self):
        """Gets the expiry of this DynamicSecretProducerCredsReplyObj.  # noqa: E501

        Credentials expiration date  # noqa: E501

        :return: The expiry of this DynamicSecretProducerCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._expiry

    @expiry.setter
    def expiry(self, expiry):
        """Sets the expiry of this DynamicSecretProducerCredsReplyObj.

        Credentials expiration date  # noqa: E501

        :param expiry: The expiry of this DynamicSecretProducerCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._expiry = expiry

    @property
    def producer_protection_key_derivation_creds(self):
        """Gets the producer_protection_key_derivation_creds of this DynamicSecretProducerCredsReplyObj.  # noqa: E501

        Temporary access credentials (JWT format) for the dynamic secret producer to get an access to the key fragments that protects the dynamic secret value from KFM instances together with the KFMs host names.  # noqa: E501

        :return: The producer_protection_key_derivation_creds of this DynamicSecretProducerCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._producer_protection_key_derivation_creds

    @producer_protection_key_derivation_creds.setter
    def producer_protection_key_derivation_creds(self, producer_protection_key_derivation_creds):
        """Sets the producer_protection_key_derivation_creds of this DynamicSecretProducerCredsReplyObj.

        Temporary access credentials (JWT format) for the dynamic secret producer to get an access to the key fragments that protects the dynamic secret value from KFM instances together with the KFMs host names.  # noqa: E501

        :param producer_protection_key_derivation_creds: The producer_protection_key_derivation_creds of this DynamicSecretProducerCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._producer_protection_key_derivation_creds = producer_protection_key_derivation_creds

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DynamicSecretProducerCredsReplyObj, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DynamicSecretProducerCredsReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
