"""
Test the TkZero.Radiobutton module
"""

import base64
import tkinter as tk
import unittest

from PIL.ImageTk import PhotoImage

from TkZero import Style
from TkZero.Radiobutton import Radiobutton, DisplayModes
from TkZeroUnitTest import TkTestCase


class RadiobuttonTest(TkTestCase):
    def test_no_params(self):
        with self.assertRaises(TypeError):
            Radiobutton()

    def test_bad_params(self):
        with self.assertRaises(TypeError):
            Radiobutton(parent=1)
        with self.assertRaises(TypeError):
            Radiobutton(self.root, text=2)
        with self.assertRaises(TypeError):
            Radiobutton(self.root, image=[])
        with self.assertRaises(TypeError):
            Radiobutton(self.root, variable="miyu")
        with self.assertRaises(TypeError):
            Radiobutton(self.root, value=[42])

    def test_good_params(self):
        image_data = base64.b64decode("""Qk02MAAAAAAAADYAAAAoAAAAQAAAAEAAAAABABgAAAAAAAAwAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AA//////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////r6+vMDAwAAAAAAAAAAAAGBgYaGhov7+///
        //////////////////////////////////////////////////////////////////////AAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
        //////////////////9/f3YGBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5+f//////////////////////////////////
        //////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
        //////////////////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5
        +f////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAA////////////////////////////////////////////////9/f3YGBgAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgcHBw5+fn////////z8/PcH
        BwICAgAAAAAAAAAAAAAAAAAAAAAAAASEhI9/f3//////////////////////////////////////
        //AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
        //////9/f3SEhIAAAAAAAAAAAAAAAAAAAAf39///////////////////////////////////////
        //////////////////////////////////////7+/vf39/EBAQAAAAAAAAAAAASEhI9/f3//////
        //////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
        //////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAICAgl5eX//////////////
        //////////////////////////////////////////////////////////////////////////7+
        /vcHBwAAAAAAAAAAAASEhI9/f3////////////////////////////////AAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAA////////////////////////////////////9/f3SEhIAAAAAAAAAAAAf3
        9///////////////////////////////////////////////////////////////////////////
        //////////////////////////////////f39/AAAAAAAAAAAASEhI9/f3//////////////////
        //////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
        //////YGBgAAAAAAAAAAAAf39///////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////f39/AAAAAA
        AAAAAASEhI9/f3////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
        //////////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////f39/AAAAAAAAAAAAWFhY////////////////////////AAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////////9/f3QEBAAAAAAAAAUFBQ//
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////f39/AAAAAAAAAAAA//////
        //////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
        //////YGBgAAAAAAAAAAAAz8/P//////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////GBgYAAAAAAAAr6+v////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAA////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////cHBwAAAAAAAAMDAw////////////////////AA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////WFhYAAAAAAAAUFBQ//
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////5+fnAAAAAA
        AAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
        //////9/f3CAgIAAAAAAAAz8/P//////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////AAAAAAAAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAA////////////////////aGhoAAAAAAAACAgI//////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////AAAAAAAAAAAA//////////////
        //////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////7+/vCAgIAAAAAAAAh4
        eH//////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //GBgYAAAAAAAAr6+v////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
        //////////n5+fAAAAAAAAQEBA//////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////cHBwAAAAAAAAMDAw////////////////AAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAA////////////9/f3ODg4AAAAAAAAl5eX//////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////5+fnAAAAAAAAAAAA//
        //////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////cHBwAAAAAAAAAA
        AA5+fn//////////////////////////////////////////////////////////////////////
        //////////////////h4eHAAAAaGho//////////////////////////////////////////////
        //////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AA////////////CAgIAAAAAAAAh4eH////////////////////h4eHAAAAaGho//////////////
        //////////////////////////////////////////////CAgIAAAAAAAA//////////////////
        //////////////////////////////////////////AAAAAAAAAAAA////////////////AAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////////////
        //CAgIAAAAAAAAaGho////////////////////////////////////////////////////////AA
        AAAAAAAAAAaGho////////////////////////////////////////////////////////AAAAAA
        AAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAA
        AAAAAA////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////
        //////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////////
        //////////////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////t7e3AAAAAAAAAAAA//
        //////////////////////////////////////////////////////t7e3AAAAAAAAAAAA//////
        //////////////////////////////////////////////////GBgYAAAACAgI//////////////
        //AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////
        //////////////AAAAAAAAAAAA//////////////////////////////////////////////////
        //////////GBgYAAAAAAAAr6+v//////////////////////////////////////////////////
        //t7e3QEBAn5+f////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
        //AAAAAAAAAAAA////////////////////////////AAAAAAAAAAAA//////////////////////
        //////////////////////////////////////cHBwAAAAAAAAMDAw//////////////////////
        //////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////////AAAAAA
        AAAAAA////////////////////////////////////////////////////////////5+fnAAAAAA
        AAAAAA//////////////////////////////////////////////////////////////////////
        //////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////GBgYAAAACAgI//////
        //////////////////////AAAAAAAAAAAA//////////////////////////////////////////
        //////////////////////AAAAAAAAAAAA//////////////////////////////////////////
        //////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
        //////////t7e3QEBAn5+f////////////////////////////AAAAAAAAAAAA//////////////
        //////////////////////////////////////////////////AAAAAAAAAAAA//////////////
        //////////////////////////////////////////////////////////////////AAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
        //AAAAAAAAAAAA//////////////////////////////////////////////////////////////
        //AAAAAAAAAAAA//////////////////////////////////////////////////////////////
        //////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
        //////////////////////////////AAAAAAAAAAAA//////////////////////////////////
        //////////////////////////////AAAAAAAAAAAA//////////////////////////////////
        //////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAA////////////////////////////////////////////////////AAAAAAAAAAAA//////
        //////////////////////////////////////////////////////////AAAAAAAAAAAA//////
        //////////////////////////////////////////////////////////////////////////AA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
        //////////AAAAAAAAAAAA//////////////////////////////////////////////////////
        //////////AAAAAAAAAAAA//////////////////////////////////////////////////////
        //////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
        //////////////////////////////////////GBgYAAAAAAAAr6+v//////////////////////
        //////////////////////////////////////AAAAAAAAAAAA//////////////////////////
        //////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAA////////////////////////////////////////////////////cHBwAAAAAA
        AAMDAw////////////////////////////////////////////////////////////AAAAAAAAAA
        AA//////////////////////////////////////////////////////////////////////////
        //////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////
        //////////////////5+fnAAAAAAAAAAAA//////////////////////////////////////////
        //////////////////AAAAAAAAAAAA//////////////////////////////////////////////
        //////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
        //////////////////////////////////////////////////AAAAAAAAAAAA//////////////
        //////////////////////////////////////////////AAAAAAAAAAAA//////////////////
        //////////////////////////////////////////////////////////////AAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
        //AAAAAAAAAAAA////////////////////////////////////////////////////////////AA
        AAAAAAAAAA//////////////////////////////////////////////////////////////////
        //////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
        //////////////////////////////AAAAAAAAAAAA//////////////////////////////////
        //////////////////////////AAAAAAAAAAAA//////////////////////////////////////
        //////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AA////////////////////////////////////////////////////////AAAAAAAAAAAA//////
        //////////////////////////////////////////////////////AAAAAAAAAAAA//////////
        //////////////////////////////////////////////////////////////////////AAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
        //////////AAAAAAAAAAAA//////////////////////////////////////////////////////
        //////AAAAAAAAAAAA//////////////////////////////////////////////////////////
        //////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
        //////////////////////////////////////AAAAAAAAAAAA//////////////////////////
        //////////////////////////////////AAAAAAAAAAAA//////////////////////////////
        //////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAA////////////////////////////////////////////////////////AAAAAAAAAA
        AA////////////////////////////////////////////////////////////AAAAAAAAAAAA//
        ////////////////////////////////////////////////////////////////////////////
        //AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
        //////////////////AAAAAAAAAAAA//////////////////////////////////////////////
        //////////////AAAAAAAAAAAA//////////////////////////////////////////////////
        //////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
        //////////////////////////////////////////////AAAAAAAAAAAA//////////////////
        //////////////////////////////////////z8/PAAAAAAAAAAAA//////////////////////
        //////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAA////////////////////////////////////////////////////////AA
        AAAAAAAAAA////////////////////////////////////////////////////////WFhYAAAAAA
        AAUFBQ//////////////////////////////////////////////////////////////////////
        //////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
        //////////////////////////AAAAAAAAAAAA//////////////////////////////////////
        //////////////////CAgIAAAAAAAAz8/P//////////////////////////////////////////
        //////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
        //////////////////////////////////////////////////////AAAAAAAAAAAA//////////
        //////////////////////////////////////////////AAAAAAAAAAAA//////////////////
        //////////////////////////////////////////////////////////////////AAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
        //////AAAAAAAAAAAA////////////////////////////////////////////////////////AA
        AAAAAAAAAA//////////////////////////////////////////////////////////////////
        //////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
        //////////////////////////////////GBgYAAAACAgI//////////////////////////////
        //////////////////////////AAAAAAAAAAAA//////////////////////////////////////
        //////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAA////////////////////////////////////////////////////////t7e3QEBAn5+f//
        //////////////////////////////////////////////////////GBgYAAAACAgI//////////
        //////////////////////////////////////////////////////////////////////////AA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////t7e3QEBAn5+f//////////////////////////////////////////////////////////
        //////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAA//////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////
        //////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA""")
        Radiobutton(self.root, text="hi", image=PhotoImage(data=image_data),
                    variable=tk.StringVar(), value="1").grid(row=0, column=0)

    def test_value(self):
        v = tk.StringVar(value="Foobar")
        c = Radiobutton(self.root, text="Foobar", variable=v, value="Foobar")
        c.grid(row=0, column=0)
        self.root.update()
        self.assertEqual(v.get(), "Foobar")

    def test_text(self):
        c = Radiobutton(self.root, text="Foobar")
        c.grid(row=0, column=0)
        c.text = "Test"
        self.root.update()
        self.assertEqual(c.text, "Test")
        with self.assertRaises(TypeError):
            c.text = 1023.99999999999999

    def test_image(self):
        c = Radiobutton(self.root)
        c.grid(row=0, column=0)
        self.assertTrue(c.image is None)
        image_data = base64.b64decode("""Qk02MAAAAAAAADYAAAAoAAAAQAAAAEAAAAABABgAAAAAAAAwAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////r6+vMDAwAAAAAAAAAAAAGBgYaGhov7+///
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////////////9/f3YGBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5+f//////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5
+f////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////9/f3YGBgAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgcHBw5+fn////////z8/PcH
BwICAgAAAAAAAAAAAAAAAAAAAAAAAASEhI9/f3//////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////9/f3SEhIAAAAAAAAAAAAAAAAAAAAf39///////////////////////////////////////
//////////////////////////////////////7+/vf39/EBAQAAAAAAAAAAAASEhI9/f3//////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAICAgl5eX//////////////
//////////////////////////////////////////////////////////////////////////7+
/vcHBwAAAAAAAAAAAASEhI9/f3////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////9/f3SEhIAAAAAAAAAAAAf3
9///////////////////////////////////////////////////////////////////////////
//////////////////////////////////f39/AAAAAAAAAAAASEhI9/f3//////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////YGBgAAAAAAAAAAAAf39///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////f39/AAAAAA
AAAAAASEhI9/f3////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////f39/AAAAAAAAAAAAWFhY////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////////9/f3QEBAAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////f39/AAAAAAAAAAAA//////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////YGBgAAAAAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////WFhYAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////9/f3CAgIAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////aGhoAAAAAAAACAgI//////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////7+/vCAgIAAAAAAAAh4
eH//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//GBgYAAAAAAAAr6+v////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////n5+fAAAAAAAAQEBA//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////cHBwAAAAAAAAMDAw////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA////////////9/f3ODg4AAAAAAAAl5eX//////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////5+fnAAAAAAAAAAAA//
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////cHBwAAAAAAAAAA
AA5+fn//////////////////////////////////////////////////////////////////////
//////////////////h4eHAAAAaGho//////////////////////////////////////////////
//////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////CAgIAAAAAAAAh4eH////////////////////h4eHAAAAaGho//////////////
//////////////////////////////////////////////CAgIAAAAAAAA//////////////////
//////////////////////////////////////////AAAAAAAAAAAA////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////////////
//CAgIAAAAAAAAaGho////////////////////////////////////////////////////////AA
AAAAAAAAAAaGho////////////////////////////////////////////////////////AAAAAA
AAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAA
AAAAAA////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////
//////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////t7e3AAAAAAAAAAAA//
//////////////////////////////////////////////////////t7e3AAAAAAAAAAAA//////
//////////////////////////////////////////////////GBgYAAAACAgI//////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v//////////////////////////////////////////////////
//t7e3QEBAn5+f////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//AAAAAAAAAAAA////////////////////////////AAAAAAAAAAAA//////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////////AAAAAA
AAAAAA////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////GBgYAAAACAgI//////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////t7e3QEBAn5+f////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////////////////////////////////////GBgYAAAAAAAAr6+v//////////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////////////////////////////////////cHBwAAAAAA
AAMDAw////////////////////////////////////////////////////////////AAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////
//////////////////5+fnAAAAAAAAAAAA//////////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
//AAAAAAAAAAAA////////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////AAAAAAAAAAAA//////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////AAAAAAAAAAAA//////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////////////AAAAAAAAAA
AA////////////////////////////////////////////////////////////AAAAAAAAAAAA//
////////////////////////////////////////////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////z8/PAAAAAAAAAAAA//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA////////////////////////////////////////////////////////WFhYAAAAAA
AAUFBQ//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////CAgIAAAAAAAAz8/P//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//////AAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////////GBgYAAAACAgI//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////////t7e3QEBAn5+f//
//////////////////////////////////////////////////////GBgYAAAACAgI//////////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////t7e3QEBAn5+f//////////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA//////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA""")
        c.image = PhotoImage(data=image_data)
        self.root.update()
        self.assertTrue(c.image is not None)
        with self.assertRaises(TypeError):
            c.image = "this isn't an image dummy"

    def test_text_and_image(self):
        c = Radiobutton(self.root, text="Click for smiles!")
        c.grid(row=0, column=0)
        self.root.update()
        self.assertEqual(c.text, "Click for smiles!")
        self.assertTrue(c.image is None)
        image_data = base64.b64decode("""Qk02MAAAAAAAADYAAAAoAAAAQAAAAEAAAAABABgAAAAAAAAwAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////r6+vMDAwAAAAAAAAAAAAGBgYaGhov7+///
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////////////9/f3YGBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5+f//////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgn5
+f////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////9/f3YGBgAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICAgcHBw5+fn////////z8/PcH
BwICAgAAAAAAAAAAAAAAAAAAAAAAAASEhI9/f3//////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////9/f3SEhIAAAAAAAAAAAAAAAAAAAAf39///////////////////////////////////////
//////////////////////////////////////7+/vf39/EBAQAAAAAAAAAAAASEhI9/f3//////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////9/f3SEhIAAAAAAAAAAAAAAAAICAgl5eX//////////////
//////////////////////////////////////////////////////////////////////////7+
/vcHBwAAAAAAAAAAAASEhI9/f3////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////9/f3SEhIAAAAAAAAAAAAf3
9///////////////////////////////////////////////////////////////////////////
//////////////////////////////////f39/AAAAAAAAAAAASEhI9/f3//////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////YGBgAAAAAAAAAAAAf39///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////f39/AAAAAA
AAAAAASEhI9/f3////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////f39/AAAAAAAAAAAAWFhY////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////////9/f3QEBAAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////f39/AAAAAAAAAAAA//////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////YGBgAAAAAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////z8/PAAAAAAAAAAAAf39///////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////WFhYAAAAAAAAUFBQ//
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////9/f3CAgIAAAAAAAAz8/P//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////aGhoAAAAAAAACAgI//////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////////7+/vCAgIAAAAAAAAh4
eH//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//GBgYAAAAAAAAr6+v////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////n5+fAAAAAAAAQEBA//////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////cHBwAAAAAAAAMDAw////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA////////////9/f3ODg4AAAAAAAAl5eX//////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////5+fnAAAAAAAAAAAA//
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////cHBwAAAAAAAAAA
AA5+fn//////////////////////////////////////////////////////////////////////
//////////////////h4eHAAAAaGho//////////////////////////////////////////////
//////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////CAgIAAAAAAAAh4eH////////////////////h4eHAAAAaGho//////////////
//////////////////////////////////////////////CAgIAAAAAAAA//////////////////
//////////////////////////////////////////AAAAAAAAAAAA////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////////////
//CAgIAAAAAAAAaGho////////////////////////////////////////////////////////AA
AAAAAAAAAAaGho////////////////////////////////////////////////////////AAAAAA
AAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAA
AAAAAA////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////
//////////////////////////GBgYAAAAAAAAAAAA//////////////////////////////////
//////////////////////AAAAAAAAAAAA////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////t7e3AAAAAAAAAAAA//
//////////////////////////////////////////////////////t7e3AAAAAAAAAAAA//////
//////////////////////////////////////////////////GBgYAAAACAgI//////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA//////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////GBgYAAAAAAAAr6+v//////////////////////////////////////////////////
//t7e3QEBAn5+f////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//AAAAAAAAAAAA////////////////////////////AAAAAAAAAAAA//////////////////////
//////////////////////////////////////cHBwAAAAAAAAMDAw//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////AAAAAAAAAAAA////////////////////////////AAAAAA
AAAAAA////////////////////////////////////////////////////////////5+fnAAAAAA
AAAAAA//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////////////GBgYAAAACAgI//////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////AAAAAAAAAAAA//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////t7e3QEBAn5+f////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//AAAAAAAAAAAA//////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
//////////////////////////////////////GBgYAAAAAAAAr6+v//////////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA////////////////////////////////////////////////////cHBwAAAAAA
AAMDAw////////////////////////////////////////////////////////////AAAAAAAAAA
AA//////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////
//////////////////5+fnAAAAAAAAAAAA//////////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////
//////////////////////////////////////////////////AAAAAAAAAAAA//////////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////AAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////
//AAAAAAAAAAAA////////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////
//////////////////////////////AAAAAAAAAAAA//////////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AA////////////////////////////////////////////////////////AAAAAAAAAAAA//////
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////////////////////////////AAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////
//////////AAAAAAAAAAAA//////////////////////////////////////////////////////
//////AAAAAAAAAAAA//////////////////////////////////////////////////////////
//////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////
//////////////////////////////////////AAAAAAAAAAAA//////////////////////////
//////////////////////////////////AAAAAAAAAAAA//////////////////////////////
//////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAA////////////////////////////////////////////////////////AAAAAAAAAA
AA////////////////////////////////////////////////////////////AAAAAAAAAAAA//
////////////////////////////////////////////////////////////////////////////
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////
//////////////////AAAAAAAAAAAA//////////////////////////////////////////////
//////////////AAAAAAAAAAAA//////////////////////////////////////////////////
//////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////z8/PAAAAAAAAAAAA//////////////////////
//////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA////////////////////////////////////////////////////////WFhYAAAAAA
AAUFBQ//////////////////////////////////////////////////////////////////////
//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////CAgIAAAAAAAAz8/P//////////////////////////////////////////
//////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//
//////////////////////////////////////////////////////AAAAAAAAAAAA//////////
//////////////////////////////////////////////AAAAAAAAAAAA//////////////////
//////////////////////////////////////////////////////////////////AAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////
//////AAAAAAAAAAAA////////////////////////////////////////////////////////AA
AAAAAAAAAA//////////////////////////////////////////////////////////////////
//////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////
//////////////////////////////////GBgYAAAACAgI//////////////////////////////
//////////////////////////AAAAAAAAAAAA//////////////////////////////////////
//////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAA////////////////////////////////////////////////////////t7e3QEBAn5+f//
//////////////////////////////////////////////////////GBgYAAAACAgI//////////
//////////////////////////////////////////////////////////////////////////AA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////t7e3QEBAn5+f//////////////////////////////////////////////////////////
//////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAA//////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA""")
        c.image = PhotoImage(data=image_data)
        self.root.update()
        self.assertTrue(c.image is not None)
        self.root.update()
        self.assertEqual(c.display_mode, DisplayModes.Original)
        c.display_mode = DisplayModes.ImageTopText
        self.root.update()
        self.assertEqual(c.display_mode, DisplayModes.ImageTopText)
        with self.assertRaises(TypeError):
            c.display_mode = {}

    def test_enabled(self):
        c = Radiobutton(self.root)
        c.grid(row=0, column=0)
        self.root.update()
        self.assertTrue(c.enabled)
        c.enabled = False
        self.assertFalse(c.enabled)
        with self.assertRaises(TypeError):
            c.enabled = "False"

    def test_execution(self):
        c = Radiobutton(self.root, command=lambda: None)
        c.grid(row=0, column=0)

    def test_style(self):
        c = Radiobutton(self.root)
        c.grid(row=0, column=0)
        Style.define_style(Style.WidgetStyleRoots.Button, "Test",
                           background="red")
        c.apply_style("Test")
        self.assertEqual(c.cget("style"), "Test.TRadiobutton")
        self.root.update()
        with self.assertRaises(TypeError):
            c.apply_style(123456789)


if __name__ == '__main__':
    unittest.main()
