# Terminal Chat Server

A lightweight, terminal-based chat server with room access codes. Perfect for secure team communications over TCP.

## Features

- 🚀 Terminal-based interface
- 🔐 Room access codes and passwords
- 👥 Multiple concurrent rooms
- 🌐 Real-time messaging
- 🔧 Zero dependencies

## Installation

```bash
pip install terminal-chat-server
Quick Start
Start the server:
bash
terminal-chat-server
Connect clients:
bash
# Using telnet
telnet localhost 9999

# Using netcat
nc localhost 9999
Usage
Default Rooms:
1234 - General Chat (no password)

5678 - Tech Talk (no password)

9999 - Secret Room (password: "secret")

Client Commands:
/help - Show help

/users - List online users

/quit - Exit chat

Advanced Usage
Custom Configuration:
python
from terminal_chat_server import TerminalChatServer

server = TerminalChatServer(
    host='0.0.0.0',
    port=8888,
    rooms={
        "1111": {"name": "Custom Room", "password": None},
        "2222": {"name": "Private", "password": "mypass"}
    }
)
server.start_server()
License
MIT License - See LICENSE file for details.

Author
Peter Gatitu (gatitu@evidflow.com)
