"""
Auto-generated on 2019-12-27T16:54:58.102186
"""

from .value_set import ValueSet


class UrologicalSurgery(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent urologic surgery procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients who have a urologic surgery procedure.
    Inclusion Criteria: Includes only relevant concepts associated with representing urologic surgery procedures.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.272'
    VALUE_SET_NAME = 'Urological Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '0T1307B', '0T130JB', '0T130KB', '0T130ZB', '0T1407B', '0T140JB', '0T140KB', '0T140ZB',
        '0T16076', '0T16077', '0T16078', '0T1607A', '0T1607B', '0T1607C', '0T160J6', '0T160J7',
        '0T160J8', '0T160JA', '0T160JB', '0T160JC', '0T160K6', '0T160K7', '0T160K8', '0T160KA',
        '0T160KB', '0T160KC', '0T160Z6', '0T160Z7', '0T160Z8', '0T160ZA', '0T160ZB', '0T160ZC',
        '0T17076', '0T17077', '0T17078', '0T1707A', '0T1707B', '0T1707C', '0T170J6', '0T170J7',
        '0T170J8', '0T170JA', '0T170JB', '0T170JC', '0T170K6', '0T170K7', '0T170K8', '0T170KA',
        '0T170KB', '0T170KC', '0T170Z6', '0T170Z7', '0T170Z8', '0T170ZA', '0T170ZB', '0T170ZC',
        '0T18076', '0T18077', '0T18078', '0T1807A', '0T1807B', '0T1807C', '0T180J6', '0T180J7',
        '0T180J8', '0T180JA', '0T180JB', '0T180JC', '0T180K6', '0T180K7', '0T180K8', '0T180KA',
        '0T180KB', '0T180KC', '0T180Z6', '0T180Z7', '0T180Z8', '0T180ZA', '0T180ZB', '0T180ZC',
        '0T1B079', '0T1B07C', '0T1B07D', '0T1B0J9', '0T1B0JC', '0T1B0JD', '0T1B0K9', '0T1B0KC',
        '0T1B0KD', '0T1B0Z9', '0T1B0ZC', '0T7B0DZ', '0T7B0ZZ', '0T7B7DZ', '0T7B7ZZ', '0T7B8DZ',
        '0T7B8ZZ', '0T9300Z', '0T930ZZ', '0T9400Z', '0T940ZZ', '0TB00ZZ', '0TB07ZZ', '0TB08ZZ',
        '0TB10ZZ', '0TB17ZZ', '0TB18ZZ', '0TB30ZZ', '0TB37ZZ', '0TB38ZZ', '0TB40ZZ', '0TB47ZZ',
        '0TB48ZZ', '0TBB0ZZ', '0TBC0ZZ', '0TJ50ZZ', '0TMB0ZZ', '0TMC0ZZ', '0TN00ZZ', '0TN07ZZ',
        '0TN08ZZ', '0TN10ZZ', '0TN17ZZ', '0TN18ZZ', '0TN30ZZ', '0TN37ZZ', '0TN38ZZ', '0TN40ZZ',
        '0TN47ZZ', '0TN48ZZ', '0TN60ZZ', '0TN70ZZ', '0TQ60ZZ', '0TQ67ZZ', '0TQ68ZZ', '0TQ70ZZ',
        '0TQ77ZZ', '0TQ78ZZ', '0TQB0ZZ', '0TQB7ZZ', '0TQB8ZZ', '0TQC0ZZ', '0TQC7ZZ', '0TQC8ZZ',
        '0TRB07Z', '0TRB0JZ', '0TRB0KZ', '0TRB77Z', '0TRB7JZ', '0TRB7KZ', '0TRB87Z', '0TRB8JZ',
        '0TRB8KZ', '0TRC07Z', '0TRC0JZ', '0TRC0KZ', '0TRC77Z', '0TRC7JZ', '0TRC7KZ', '0TRC87Z',
        '0TRC8JZ', '0TRC8KZ', '0TSB0ZZ', '0TT00ZZ', '0TT10ZZ', '0TT20ZZ', '0TT30ZZ', '0TT37ZZ',
        '0TT38ZZ', '0TT40ZZ', '0TT47ZZ', '0TT48ZZ', '0TTB0ZZ', '0TTB7ZZ', '0TTB8ZZ', '0TTC0ZZ',
        '0TTC7ZZ', '0TTC8ZZ', '0TTD0ZZ', '0TTD7ZZ', '0TTD8ZZ', '0TUB07Z', '0TUB0JZ', '0TUB0KZ',
        '0TUB77Z', '0TUB7JZ', '0TUB7KZ', '0TUB87Z', '0TUB8JZ', '0TUB8KZ', '0TVB0CZ', '0TVB0DZ',
        '0TVB0ZZ', '0TVB7DZ', '0TVB7ZZ', '0TVB8DZ', '0TVB8ZZ', '0TVC0CZ', '0TVC0DZ', '0TVC0ZZ',
        '0TVC7DZ', '0TVC7ZZ', '0TVC8DZ', '0TVC8ZZ', '0VT00ZZ', '0VT07ZZ', '0VT08ZZ', '0VT30ZZ',
        '0WBH0ZZ', '0WQF0ZZ', '0WQFXZ2', '0WQFXZZ'
    }

    SNOMEDCT = {
        '108022006', '108034003', '11050006', '112902005', '116033007', '116166009', '119991007',
        '12976005', '13246003', '13991004', '15044006', '15918009', '16068008', '175905003',
        '175907006', '175908001', '175911000', '175912007', '175913002', '175916005', '175917001',
        '175918006', '176004009', '176024008', '176106009', '176107000', '176108005', '176117005',
        '176118000', '176123000', '176132003', '176144000', '176165006', '176234008', '176260009',
        '176275001', '176722004', '18008000', '18280002', '1866009', '19149007', '21338008',
        '21482000', '22783008', '22829001', '2344008', '236139004', '236140002', '236165000',
        '236167008', '236209003', '236210008', '236211007', '236213005', '236214004', '236215003',
        '236216002', '236219009', '236247008', '236251005', '240325001', '24221008', '243306000',
        '24677003', '25466008', '277837003', '2813008', '281416002', '28579000', '28609005',
        '287716007', '287718008', '287720006', '287721005', '287722003', '287723008', '288013007',
        '288014001', '289754003', '290691008', '32417007', '33654003', '34006000', '361249003',
        '361256009', '361257000', '36253005', '36432003', '36586008', '36935008', '386652006',
        '387707007', '39214002', '41416003', '439110003', '439235001', '439497008', '439739008',
        '439964001', '440076006', '440446009', '442919002', '443869003', '444083005', '446296004',
        '446586007', '446894005', '446990000', '447307008', '447308003', '447527008', '447531002',
        '48007004', '4895001', '49780003', '49935007', '51870000', '52969004', '533005', '535003',
        '54033009', '56256008', '56614001', '57212002', '63016009', '63361002', '64063003',
        '65551008', '66633009', '67113002', '67212000', '67598001', '68960009', '69926006',
        '71550003', '73380001', '73953002', '73966002', '74146001', '76414006', '78062004',
        '80945002', '81232004', '81516001', '83444008', '83483005', '83588004', '83809000',
        '84575008', '85175006', '88930008', '89230009', '89528006', '90648000', '91531008'
    }


class Warfarin(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent warfarin medications that are administered to patients to reduce the risk of blood clot formation.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who are prescribed warfarin therapy at discharge following acute myocardial infarction.
    Inclusion Criteria: Includes only relevant concepts associated with drug forms that are consistent with oral administration, such as tablets. Only single ingredient.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.232'
    VALUE_SET_NAME = 'Warfarin'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '855288', '855296', '855302', '855312', '855318', '855324', '855332', '855338', '855344'
    }


class AtrialFibrillationflutter(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent diagnoses used to identify patients with a history of atrial fibrillation/flutter or a current finding of atrial fibrillation/flutter.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis. The intent of this data element is to identify patients with a diagnosis of atrial fibrillation or flutter.
    Inclusion Criteria: Includes only relevant concepts associated with codes that identify patients with a history of atrial fibrillation/flutter or a current finding of atrial fibrillation/flutter. This is a grouping of ICD-10-CM, ICD-9-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.202'
    VALUE_SET_NAME = 'Atrial Fibrillation/Flutter'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I480', 'I481', 'I482', 'I483', 'I484', 'I4891', 'I4892'}

    ICD9CM = {'42731', '42732'}

    SNOMEDCT = {
        '120041000119109', '15964901000119107', '195080001', '233910005', '233911009', '282825002',
        '300996004', '314208002', '425615007', '426749004', '426814001', '427665004', '440028005',
        '440059007', '49436004', '5370000', '706923002', '715395008', '720448006'
    }


class PreventiveCareServicesInitialOfficeVisit0To17(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent initial comprehensive preventive medical evaluation, including regular preventive care or care of small problem or preexisting condition that requires no extra work, to be associated with patients 0-17 years of age, that have no prior outpatient professional services from the physician practice in the last 3 years.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with ages 0-17, and that indicate initial comprehensive preventive medical evaluation, including regular preventive care or care of small problem or preexisting condition that requires no extra work, for a patient that has no prior outpatient professional services from the physician practice in the last 3 years. This is a grouping value set of CPT codes.
    Exclusion Criteria: Excludes codes that are not for comprehensive preventive medical evaluations and codes that are for patients who have been seen in the last 3 years.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1022'
    VALUE_SET_NAME = 'Preventive Care Services, Initial Office Visit, 0 to 17'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99381', '99382', '99383', '99384'}


class EsrdMonthlyOutpatientServices(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who had ESRD monthly outpatient services.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who had ESRD monthly outpatients services.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1014'
    VALUE_SET_NAME = 'ESRD Monthly Outpatient Services'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '90951', '90952', '90953', '90954', '90955', '90956', '90957', '90958', '90959', '90960',
        '90961', '90962', '90963', '90964', '90965', '90966', '90967', '90968', '90969', '90970',
        '90989', '90993', '90997', '90999', '99512'
    }


class ChronicKidneyDiseaseStage5(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of Stage 5 chronic kidney disease.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with Stage 5 of chronic kidney disease.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1002'
    VALUE_SET_NAME = 'Chronic Kidney Disease, Stage 5'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'N185'}

    ICD9CM = {'5855'}

    SNOMEDCT = {'433146000'}


class OralClindamycin(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent oral clindamycin medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Active.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; clindamycin. Includes only relevant concepts associated with only clindamycin taken orally, i.e., through an tablet, capsule, or oral solution.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable; clindamycin in combination with other drugs. Excludes all clindamycin taken non-orally, i.e., as a nasal inhalant or injectable solution.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1511'
    VALUE_SET_NAME = 'Oral Clindamycin'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197518', '205964', '284215', '309329', '562266'}


class NonbenzodiazepineHypnotics(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent nonbenzodiazepine hypnotic medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; nonbenzodiazepine hypnotic medications.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; benzodiazepine derivative medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1480'
    VALUE_SET_NAME = 'Nonbenzodiazepine hypnotics'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1232194', '1232202', '313761', '313762', '485440', '485442', '485465', '828692', '836641',
        '836647', '854873', '854876', '854880', '854894'
    }


class Cyproheptadine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent cyproheptadine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; cyproheptadine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; cyproheptadine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1277'
    VALUE_SET_NAME = 'Cyproheptadine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'866021', '866144'}


class OtherAndUnspecifiedFormsOfChorioretinitisAndRetinochoroiditis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of other and unspecified forms of chorioretinitis and retinochoroiditis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of posterior cyclitis, chorioretinal inflammation, other chorioretinitis or retinitis or retinochoroiditis.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1468'
    VALUE_SET_NAME = 'Other and Unspecified Forms of Chorioretinitis and Retinochoroiditis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H3021', 'H3022', 'H3023', 'H30811', 'H30812', 'H30813', 'H30891', 'H30892', 'H30893',
        'H3091', 'H3092', 'H3093'
    }

    ICD9CM = {'36320', '36321', '36322'}

    SNOMEDCT = {
        '14894002', '15847003', '186263000', '187039009', '187194004', '193434008', '193436005',
        '193438006', '193442009', '193443004', '193444005', '193497004', '22455005', '231981005',
        '231984002', '231988004', '231990003', '231992006', '231994007', '312491004', '312930008',
        '312934004', '312955002', '314031009', '314032002', '314428001', '359668007', '359698000',
        '359707007', '36535003', '371099005', '373667006', '399463004', '410470003', '414783007',
        '415218004', '416589006', '416877003', '417405005', '417547006', '42031001', '421029004',
        '441854007', '44674000', '46497009', '46627006', '48225000', '51579006', '51930008',
        '56787009', '61517002', '61922005', '6313001', '66281009', '69811008', '77628002',
        '77939001', '78769001', '88290000', '95682009', '95685006', '9941009'
    }


class Dimenhydrinate(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dimenhydrinate medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dimenhydrinate only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dimenhydrinate in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1500'
    VALUE_SET_NAME = 'Dimenhydrinate'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'198602', '198603', '309914'}


class HyoscyamineMethenamineMblueSodiumBiphosphate(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hyoscyamine / methenamine / mblue / sodium biphosphate combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; hyoscyamine / methenamine / mblue / sodium biphosphate (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; hyoscyamine / methenamine / mblue / sodium biphosphate in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1505'
    VALUE_SET_NAME = 'Hyoscyamine / Methenamine / Mblue / Sodium Biphosphate'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1050325', '1598634'}


class MajorDepressiveDisorderActive(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent major depressive disorders that are active.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with major depressive disorder diagnoses.
    Exclusion Criteria: Excludes major depressive disorders in remission.
    """

    OID = '2.16.840.1.113883.3.526.3.1491'
    VALUE_SET_NAME = 'Major Depressive Disorder-Active'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'F320', 'F321', 'F322', 'F323', 'F3289', 'F329', 'F330', 'F331', 'F332', 'F333', 'F339'
    }

    ICD9CM = {
        '29620', '29621', '29622', '29623', '29624', '29630', '29631', '29632', '29633', '29634'
    }

    SNOMEDCT = {
        '10811161000119107', '14183003', '15193003', '15639000', '16264621000119109',
        '16264821000119108', '16264901000119109', '16265951000119109', '16266831000119100',
        '16266991000119108', '18818009', '191610000', '191611001', '191613003', '20250007',
        '251000119105', '25922000', '2618002', '268621008', '281000119103', '28475009',
        '319768000', '320751009', '33078009', '33736005', '36474008', '36923009', '370143000',
        '38694004', '39809009', '40379007', '42925002', '430852001', '450714000', '60099002',
        '63778009', '66344007', '69392006', '71336009', '719592004', '720451004', '720452006',
        '720453001', '720454007', '720455008', '726772006', '73867007', '75084000', '76441001',
        '77911002', '79298009', '832007', '87512008'
    }


class AromataseInhibitors(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent aromatase inhibitor medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Active or Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; both steroidal and non-steroidal inhibitors; both non-selective and selective inhibitors; aromatase inhibitors only.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable; aromatase inhibitors in combination with other medications; selective inhibitors vorozole, formestane, and fadrozole.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1265'
    VALUE_SET_NAME = 'Aromatase Inhibitors'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1098617', '199224', '200064', '310261', '795141'}


class Imipramine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent imipramine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; imipramine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; imipramine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1359'
    VALUE_SET_NAME = 'Imipramine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'835564', '835568', '835572', '835577', '835589', '835591', '835593'}


class HeartRate(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent heart rate.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Physical Exam.
    Inclusion Criteria: Includes only relevant concepts associated with obtaining heart rate.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1176'
    VALUE_SET_NAME = 'Heart Rate'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'68999-2', '69000-8', '69001-6', '8867-4'}


class CardiacPacer(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a cardiac pacer device.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Device.
    Inclusion Criteria: Includes only relevant concepts associated with a cardiac pacer device.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1193'
    VALUE_SET_NAME = 'Cardiac Pacer'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'14106009', '360127006', '360128001', '424921004', '56961003'}


class Hemodialysis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the administration of hemodialysis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with the administration of hemodialysis.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1083'
    VALUE_SET_NAME = 'Hemodialysis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '90951', '90952', '90953', '90954', '90955', '90956', '90957', '90958', '90959', '90960',
        '90961', '90962', '90963', '90964', '90965', '90966', '90967', '90968', '90969', '90970',
        '99512'
    }

    SNOMEDCT = {'302497006'}


class Carisoprodol(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent carisoprodol medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; carisoprodol only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; carisoprodol in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1369'
    VALUE_SET_NAME = 'Carisoprodol'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197446', '730794'}


class EjectionFraction(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent ejection fraction.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnostic Study.
    Inclusion Criteria: Includes only relevant concepts associated with studies specific to obtaining left ventricular ejection fraction.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1134'
    VALUE_SET_NAME = 'Ejection Fraction'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '10230-1', '18043-0', '18044-8', '18045-5', '18046-3', '18047-1', '18048-9', '18049-7',
        '77889-4', '77890-2', '77891-0', '77892-8', '79990-8', '79991-6', '79992-4', '79993-2',
        '8806-2', '8807-0', '8808-8', '8809-6', '8810-4', '8811-2', '8812-0'
    }


class AnaphylacticReactionToDtapVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a history of an anaphylactic (extreme allergy) reaction to DTaP (diphtheria, tetanus, and acellular pertussis) vaccine.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with an anaphylactic reaction to DTaP vaccine.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1031'
    VALUE_SET_NAME = 'Anaphylactic Reaction to DTaP Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'219084006', '293108006', '428281000124107', '428291000124105'}


class DepressionDiagnosis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a current diagnosis of a depressed state or actual depressive disorder whether recurrent, chronic, or diagnosed as moderate, major, or severe.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with depression diagnoses as well as depression as indicated as depressed mood or features, a single episode, or type of psychosis, or a reaction as related to depression.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.145'
    VALUE_SET_NAME = 'Depression diagnosis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'F0151', 'F320', 'F321', 'F322', 'F323', 'F324', 'F325', 'F3289', 'F329', 'F330', 'F331',
        'F332', 'F333', 'F3340', 'F3341', 'F3342', 'F338', 'F339', 'F341', 'F3481', 'F3489',
        'F4321', 'F4323', 'F530', 'F531', 'O906', 'O99340', 'O99341', 'O99342', 'O99343', 'O99345'
    }

    ICD9CM = {
        '29013', '29021', '29043', '29620', '29621', '29622', '29623', '29624', '29625', '29626',
        '29630', '29631', '29632', '29633', '29634', '29636', '29682', '2980', '3004', '30112',
        '3090', '3091', '30928', '311'
    }

    SNOMEDCT = {
        '14183003', '15193003', '15639000', '18818009', '191610000', '191611001', '191613003',
        '191616006', '191659001', '192080009', '19527009', '19694002', '20250007', '231504006',
        '231542000', '2506003', '25922000', '2618002', '268621008', '28475009', '3109008',
        '319768000', '320751009', '33078009', '35489007', '36170009', '36474008', '36923009',
        '370143000', '38451003', '38694004', '39809009', '40379007', '40568001', '42925002',
        '430852001', '442057004', '48589009', '63778009', '66344007', '67711008', '69392006',
        '71336009', '73867007', '75084000', '75837004', '76441001', '77486005', '77911002',
        '78667006', '79298009', '81319007', '83176005', '832007', '84760002', '85080004',
        '87512008'
    }


class XRayStudyAllInclusive(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent any radiology study involving x-rays.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnostic Study.
    Inclusion Criteria: Includes only relevant concepts associated with tests such as computerized tomography, x-ray, magnetic resonance imaging or radiofrequency testing. This is a grouping of LOINC codes.
    Exclusion Criteria: Excludes codes that indicate that this test was ordered only, and not necessarily performed.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1034'
    VALUE_SET_NAME = 'X-Ray Study (all inclusive)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '24531-6', '24532-4', '24533-2', '24534-0', '24535-7', '24536-5', '24537-3', '24538-1',
        '24539-9', '24540-7', '24541-5', '24542-3', '24543-1', '24544-9', '24545-6', '24547-2',
        '24548-0', '24549-8', '24550-6', '24551-4', '24552-2', '24553-0', '24554-8', '24555-5',
        '24556-3', '24557-1', '24558-9', '24559-7', '24560-5', '24561-3', '24562-1', '24563-9',
        '24564-7', '24566-2', '24568-8', '24569-6', '24570-4', '24571-2', '24572-0', '24573-8',
        '24574-6', '24575-3', '24576-1', '24577-9', '24578-7', '24579-5', '24580-3', '24581-1',
        '24582-9', '24583-7', '24584-5', '24585-2', '24586-0', '24587-8', '24588-6', '24589-4',
        '24590-2', '24591-0', '24593-6', '24594-4', '24595-1', '24596-9', '24597-7', '24598-5',
        '24599-3', '24600-9', '24601-7', '24602-5', '24603-3', '24604-1', '24605-8', '24606-6',
        '24609-0', '24610-8', '24612-4', '24614-0', '24615-7', '24616-5', '24617-3', '24619-9',
        '24620-7', '24621-5', '24622-3', '24623-1', '24624-9', '24625-6', '24626-4', '24627-2',
        '24628-0', '24629-8', '24630-6', '24631-4', '24632-2', '24634-8', '24635-5', '24636-3',
        '24637-1', '24638-9', '24639-7', '24640-5', '24641-3', '24642-1', '24643-9', '24644-7',
        '24645-4', '24646-2', '24647-0', '24648-8', '24649-6', '24650-4', '24651-2', '24652-0',
        '24653-8', '24654-6', '24655-3', '24656-1', '24657-9', '24658-7', '24659-5', '24660-3',
        '24661-1', '24662-9', '24663-7', '24664-5', '24665-2', '24666-0', '24667-8', '24668-6',
        '24669-4', '24670-2', '24671-0', '24672-8', '24674-4', '24675-1', '24676-9', '24677-7',
        '24678-5', '24679-3', '24680-1', '24681-9', '24682-7', '24683-5', '24684-3', '24685-0',
        '24686-8', '24687-6', '24688-4', '24689-2', '24690-0', '24691-8', '24692-6', '24693-4',
        '24694-2', '24695-9', '24696-7', '24697-5', '24698-3', '24699-1', '24700-7', '24701-5',
        '24702-3', '24703-1', '24704-9', '24705-6', '24706-4', '24707-2', '24708-0', '24709-8',
        '24710-6', '24711-4', '24712-2', '24713-0', '24714-8', '24715-5', '24716-3', '24718-9',
        '24719-7', '24720-5', '24721-3', '24722-1', '24723-9', '24724-7', '24725-4', '24726-2',
        '24727-0', '24728-8', '24729-6', '24730-4', '24731-2', '24732-0', '24733-8', '24734-6',
        '24735-3', '24740-3', '24745-2', '24748-6', '24750-2', '24751-0', '24752-8', '24753-6',
        '24755-1', '24756-9', '24760-1', '24761-9', '24762-7', '24764-3', '24765-0', '24766-8',
        '24767-6', '24769-2', '24770-0', '24771-8', '24772-6', '24773-4', '24776-7', '24778-3',
        '24779-1', '24780-9', '24781-7', '24782-5', '24783-3', '24784-1', '24787-4', '24788-2',
        '24789-0', '24790-8', '24792-4', '24793-2', '24794-0', '24795-7', '24796-5', '24797-3',
        '24798-1', '24799-9', '24800-5', '24801-3', '24802-1', '24803-9', '24804-7', '24805-4',
        '24806-2', '24807-0', '24808-8', '24809-6', '24811-2', '24812-0', '24813-8', '24814-6',
        '24815-3', '24816-1', '24817-9', '24818-7', '24820-3', '24821-1', '24822-9', '24823-7',
        '24824-5', '24825-2', '24826-0', '24827-8', '24828-6', '24829-4', '24830-2', '24831-0',
        '24832-8', '24833-6', '24834-4', '24835-1', '24836-9', '24837-7', '24838-5', '24839-3',
        '24840-1', '24841-9', '24842-7', '24843-5', '24844-3', '24845-0', '24846-8', '24848-4',
        '24849-2', '24850-0', '24851-8', '24852-6', '24854-2', '24855-9', '24856-7', '24857-5',
        '24858-3', '24859-1', '24860-9', '24861-7', '24862-5', '24863-3', '24864-1', '24865-8',
        '24866-6', '24867-4', '24868-2', '24869-0', '24870-8', '24871-6', '24872-4', '24873-2',
        '24874-0', '24876-5', '24877-3', '24878-1', '24879-9', '24880-7', '24881-5', '24882-3',
        '24883-1', '24884-9', '24887-2', '24888-0', '24889-8', '24890-6', '24891-4', '24892-2',
        '24893-0', '24894-8', '24896-3', '24899-7', '24900-3', '24901-1', '24902-9', '24903-7',
        '24904-5', '24905-2', '24906-0', '24907-8', '24908-6', '24909-4', '24910-2', '24911-0',
        '24912-8', '24913-6', '24914-4', '24915-1', '24916-9', '24917-7', '24918-5', '24919-3',
        '24920-1', '24921-9', '24922-7', '24923-5', '24924-3', '24925-0', '24926-8', '24927-6',
        '24928-4', '24929-2', '24930-0', '24931-8', '24932-6', '24933-4', '24934-2', '24935-9',
        '24936-7', '24937-5', '24938-3', '24939-1', '24940-9', '24941-7', '24942-5', '24943-3',
        '24944-1', '24945-8', '24946-6', '24947-4', '24948-2', '24963-1', '24964-9', '24965-6',
        '24966-4', '24967-2', '24968-0', '24969-8', '24970-6', '24971-4', '24972-2', '24973-0',
        '24974-8', '24975-5', '24977-1', '24978-9', '24979-7', '24980-5', '24981-3', '24982-1',
        '24983-9', '24984-7', '24985-4', '24986-2', '24987-0', '24988-8', '24989-6', '24990-4',
        '24991-2', '24992-0', '24994-6', '24995-3', '24996-1', '24997-9', '24998-7', '24999-5',
        '25000-1', '25001-9', '25002-7', '25003-5', '25005-0', '25006-8', '25007-6', '25008-4',
        '25009-2', '25010-0', '25011-8', '25013-4', '25014-2', '25016-7', '25017-5', '25018-3',
        '25019-1', '25020-9', '25022-5', '25023-3', '25024-1', '25025-8', '25026-6', '25027-4',
        '25028-2', '25029-0', '25030-8', '25031-6', '25032-4', '25033-2', '25034-0', '25035-7',
        '25036-5', '25039-9', '25041-5', '25042-3', '25043-1', '25044-9', '25045-6', '25046-4',
        '25047-2', '25053-0', '25054-8', '25056-3', '25057-1', '25058-9', '25059-7', '25060-5',
        '25061-3', '25062-1', '25063-9', '25064-7', '25065-4', '25066-2', '25067-0', '25068-8',
        '25069-6', '25070-4', '25071-2', '25072-0', '25073-8', '25074-6', '25076-1', '25077-9',
        '25078-7', '25079-5', '25080-3', '25081-1', '26064-6', '26065-3', '26066-1', '26067-9',
        '26068-7', '26069-5', '26070-3', '26071-1', '26072-9', '26073-7', '26074-5', '26075-2',
        '26076-0', '26077-8', '26078-6', '26079-4', '26080-2', '26081-0', '26082-8', '26083-6',
        '26084-4', '26085-1', '26086-9', '26087-7', '26088-5', '26089-3', '26090-1', '26091-9',
        '26092-7', '26093-5', '26094-3', '26095-0', '26096-8', '26097-6', '26098-4', '26099-2',
        '26100-8', '26101-6', '26102-4', '26106-5', '26107-3', '26108-1', '26109-9', '26110-7',
        '26111-5', '26112-3', '26113-1', '26114-9', '26115-6', '26116-4', '26117-2', '26118-0',
        '26120-6', '26122-2', '26124-8', '26125-5', '26126-3', '26127-1', '26128-9', '26129-7',
        '26130-5', '26131-3', '26132-1', '26133-9', '26134-7', '26135-4', '26136-2', '26137-0',
        '26138-8', '26139-6', '26140-4', '26141-2', '26142-0', '26143-8', '26144-6', '26146-1',
        '26148-7', '26150-3', '26151-1', '26152-9', '26153-7', '26154-5', '26155-2', '26156-0',
        '26157-8', '26158-6', '26159-4', '26160-2', '26161-0', '26162-8', '26163-6', '26164-4',
        '26165-1', '26166-9', '26167-7', '26168-5', '26169-3', '26170-1', '26171-9', '26172-7',
        '26173-5', '26174-3', '26175-0', '26176-8', '26177-6', '26178-4', '26179-2', '26180-0',
        '26181-8', '26182-6', '26183-4', '26184-2', '26185-9', '26186-7', '26187-5', '26188-3',
        '26189-1', '26190-9', '26191-7', '26192-5', '26193-3', '26194-1', '26195-8', '26196-6',
        '26197-4', '26198-2', '26199-0', '26200-6', '26201-4', '26202-2', '26203-0', '26204-8',
        '26205-5', '26206-3', '26207-1', '26208-9', '26209-7', '26210-5', '26211-3', '26212-1',
        '26213-9', '26214-7', '26215-4', '26216-2', '26217-0', '26218-8', '26219-6', '26220-4',
        '26221-2', '26222-0', '26223-8', '26224-6', '26225-3', '26226-1', '26227-9', '26228-7',
        '26229-5', '26230-3', '26231-1', '26232-9', '26233-7', '26234-5', '26235-2', '26236-0',
        '26237-8', '26238-6', '26239-4', '26240-2', '26241-0', '26242-8', '26243-6', '26244-4',
        '26245-1', '26246-9', '26247-7', '26248-5', '26249-3', '26250-1', '26251-9', '26252-7',
        '26253-5', '26254-3', '26255-0', '26256-8', '26257-6', '26258-4', '26259-2', '26260-0',
        '26261-8', '26262-6', '26263-4', '26264-2', '26265-9', '26266-7', '26267-5', '26268-3',
        '26269-1', '26270-9', '26271-7', '26272-5', '26273-3', '26277-4', '26278-2', '26279-0',
        '26280-8', '26281-6', '26282-4', '26283-2', '26284-0', '26285-7', '26286-5', '26287-3',
        '26288-1', '26289-9', '26290-7', '26291-5', '26292-3', '26293-1', '26294-9', '26295-6',
        '26296-4', '26297-2', '26298-0', '26299-8', '26300-4', '26301-2', '26302-0', '26303-8',
        '26304-6', '26305-3', '26306-1', '26307-9', '26308-7', '26309-5', '26310-3', '26311-1',
        '26312-9', '26313-7', '26314-5', '26315-2', '26316-0', '26317-8', '26318-6', '26319-4',
        '26320-2', '26321-0', '26322-8', '26323-6', '26324-4', '26325-1', '26326-9', '26327-7',
        '26328-5', '26329-3', '26330-1', '26331-9', '26332-7', '26333-5', '26334-3', '26335-0',
        '26336-8', '26337-6', '26338-4', '26339-2', '26340-0', '26341-8', '26342-6', '26343-4',
        '26344-2', '26345-9', '26346-7', '26347-5', '26348-3', '26349-1', '26350-9', '26351-7',
        '26352-5', '26353-3', '26354-1', '26355-8', '26356-6', '26357-4', '26358-2', '26359-0',
        '26360-8', '26361-6', '26362-4', '26363-2', '26364-0', '26365-7', '26366-5', '26370-7',
        '26371-5', '26372-3', '26379-8', '26380-6', '26381-4', '26382-2', '26383-0', '26384-8',
        '26385-5', '26386-3', '26387-1', '26388-9', '26389-7', '26390-5', '26391-3', '26392-1',
        '26393-9', '26394-7', '26395-4', '26396-2', '26397-0', '26398-8', '26399-6', '26400-2',
        '26401-0', '26402-8', '28561-9', '28564-3', '28565-0', '28566-8', '28567-6', '28576-7',
        '28582-5', '28613-8', '28614-6', '29252-4', '30578-9', '30579-7', '30580-5', '30581-3',
        '30582-1', '30583-9', '30584-7', '30585-4', '30586-2', '30587-0', '30588-8', '30589-6',
        '30590-4', '30591-2', '30592-0', '30593-8', '30594-6', '30595-3', '30596-1', '30597-9',
        '30598-7', '30600-1', '30601-9', '30602-7', '30603-5', '30604-3', '30605-0', '30606-8',
        '30607-6', '30608-4', '30609-2', '30610-0', '30611-8', '30612-6', '30613-4', '30614-2',
        '30615-9', '30616-7', '30619-1', '30620-9', '30621-7', '30622-5', '30623-3', '30624-1',
        '30625-8', '30626-6', '30627-4', '30628-2', '30629-0', '30630-8', '30631-6', '30632-4',
        '30633-2', '30634-0', '30636-5', '30637-3', '30638-1', '30639-9', '30640-7', '30641-5',
        '30642-3', '30643-1', '30644-9', '30645-6', '30646-4', '30647-2', '30648-0', '30649-8',
        '30650-6', '30651-4', '30652-2', '30653-0', '30654-8', '30655-5', '30656-3', '30657-1',
        '30658-9', '30659-7', '30660-5', '30661-3', '30662-1', '30663-9', '30664-7', '30665-4',
        '30666-2', '30667-0', '30668-8', '30669-6', '30670-4', '30671-2', '30672-0', '30673-8',
        '30674-6', '30675-3', '30678-7', '30679-5', '30680-3', '30681-1', '30682-9', '30683-7',
        '30684-5', '30685-2', '30686-0', '30687-8', '30688-6', '30689-4', '30690-2', '30691-0',
        '30692-8', '30693-6', '30694-4', '30695-1', '30696-9', '30697-7', '30698-5', '30699-3',
        '30701-7', '30702-5', '30703-3', '30704-1', '30705-8', '30706-6', '30709-0', '30710-8',
        '30711-6', '30712-4', '30713-2', '30714-0', '30715-7', '30716-5', '30717-3', '30719-9',
        '30720-7', '30721-5', '30722-3', '30723-1', '30724-9', '30725-6', '30726-4', '30727-2',
        '30729-8', '30730-6', '30731-4', '30733-0', '30734-8', '30735-5', '30736-3', '30737-1',
        '30738-9', '30739-7', '30740-5', '30741-3', '30742-1', '30743-9', '30744-7', '30745-4',
        '30746-2', '30747-0', '30748-8', '30749-6', '30750-4', '30751-2', '30752-0', '30753-8',
        '30754-6', '30755-3', '30756-1', '30757-9', '30758-7', '30759-5', '30760-3', '30762-9',
        '30763-7', '30764-5', '30765-2', '30766-0', '30767-8', '30768-6', '30769-4', '30770-2',
        '30771-0', '30772-8', '30773-6', '30774-4', '30775-1', '30776-9', '30777-7', '30778-5',
        '30779-3', '30780-1', '30781-9', '30782-7', '30783-5', '30784-3', '30785-0', '30786-8',
        '30787-6', '30788-4', '30789-2', '30790-0', '30791-8', '30792-6', '30793-4', '30794-2',
        '30795-9', '30796-7', '30797-5', '30799-1', '30800-7', '30801-5', '30802-3', '30803-1',
        '30804-9', '30805-6', '30807-2', '30808-0', '30809-8', '30810-6', '30811-4', '30812-2',
        '30813-0', '30814-8', '30815-5', '30816-3', '30817-1', '30818-9', '30819-7', '30820-5',
        '30821-3', '30822-1', '30823-9', '30824-7', '30825-4', '30828-8', '30829-6', '30830-4',
        '30831-2', '30832-0', '30833-8', '30834-6', '30836-1', '30837-9', '30838-7', '30839-5',
        '30840-3', '30841-1', '30842-9', '30843-7', '30844-5', '30845-2', '30846-0', '30847-8',
        '30848-6', '30849-4', '30850-2', '30851-0', '30852-8', '30853-6', '30854-4', '30855-1',
        '30856-9', '30857-7', '30858-5', '30859-3', '30860-1', '30861-9', '30862-7', '30864-3',
        '30865-0', '30866-8', '30867-6', '30868-4', '30869-2', '30870-0', '30871-8', '30872-6',
        '30873-4', '30874-2', '30875-9', '30876-7', '30877-5', '30878-3', '30880-9', '30881-7',
        '30882-5', '30883-3', '30884-1', '30885-8', '30887-4', '30888-2', '30889-0', '30890-8',
        '30892-4', '35881-2', '35882-0', '35883-8', '35884-6', '35885-3', '35886-1', '35887-9',
        '35888-7', '35889-5', '35890-3', '35891-1', '35892-9', '35893-7', '35894-5', '35895-2',
        '35896-0', '35897-8', '35898-6', '35899-4', '35900-0', '35901-8', '35902-6', '35903-4',
        '35904-2', '35905-9', '35906-7', '35907-5', '35908-3', '35909-1', '35910-9', '35911-7',
        '35912-5', '35913-3', '35914-1', '35915-8', '35916-6', '35917-4', '35918-2', '35919-0',
        '35920-8', '35921-6', '35922-4', '35923-2', '35924-0', '35925-7', '35926-5', '35927-3',
        '35928-1', '35929-9', '35930-7', '35931-5', '35932-3', '35933-1', '35934-9', '35935-6',
        '35936-4', '35937-2', '35938-0', '35939-8', '35940-6', '35941-4', '35942-2', '35943-0',
        '35944-8', '35945-5', '35946-3', '35947-1', '35948-9', '35949-7', '35950-5', '35951-3',
        '35952-1', '35953-9', '35954-7', '35955-4', '35956-2', '35957-0', '35958-8', '35959-6',
        '35960-4', '35961-2', '35962-0', '35963-8', '35964-6', '35965-3', '35966-1', '35967-9',
        '35968-7', '35969-5', '35970-3', '35971-1', '35972-9', '35973-7', '35974-5', '35975-2',
        '35976-0', '35977-8', '35978-6', '35979-4', '35980-2', '35981-0', '35982-8', '35983-6',
        '35984-4', '35985-1', '35986-9', '35987-7', '35988-5', '35989-3', '35990-1', '35991-9',
        '35992-7', '35993-5', '35994-3', '35995-0', '35996-8', '35997-6', '35998-4', '35999-2',
        '36000-8', '36001-6', '36002-4', '36003-2', '36004-0', '36005-7', '36006-5', '36007-3',
        '36008-1', '36009-9', '36011-5', '36012-3', '36013-1', '36014-9', '36015-6', '36016-4',
        '36017-2', '36018-0', '36019-8', '36020-6', '36021-4', '36022-2', '36023-0', '36024-8',
        '36025-5', '36026-3', '36027-1', '36028-9', '36029-7', '36030-5', '36031-3', '36032-1',
        '36033-9', '36034-7', '36035-4', '36036-2', '36037-0', '36038-8', '36039-6', '36040-4',
        '36041-2', '36042-0', '36043-8', '36044-6', '36045-3', '36046-1', '36047-9', '36048-7',
        '36049-5', '36050-3', '36051-1', '36052-9', '36053-7', '36054-5', '36055-2', '36056-0',
        '36057-8', '36058-6', '36059-4', '36060-2', '36061-0', '36062-8', '36063-6', '36064-4',
        '36065-1', '36066-9', '36067-7', '36068-5', '36069-3', '36070-1', '36071-9', '36072-7',
        '36073-5', '36074-3', '36075-0', '36076-8', '36077-6', '36078-4', '36079-2', '36080-0',
        '36081-8', '36082-6', '36083-4', '36084-2', '36085-9', '36086-7', '36087-5', '36088-3',
        '36089-1', '36090-9', '36091-7', '36092-5', '36093-3', '36094-1', '36095-8', '36096-6',
        '36097-4', '36098-2', '36099-0', '36100-6', '36101-4', '36102-2', '36103-0', '36104-8',
        '36105-5', '36106-3', '36107-1', '36108-9', '36109-7', '36110-5', '36111-3', '36112-1',
        '36113-9', '36114-7', '36115-4', '36116-2', '36117-0', '36118-8', '36119-6', '36120-4',
        '36121-2', '36122-0', '36123-8', '36124-6', '36125-3', '36126-1', '36127-9', '36128-7',
        '36129-5', '36130-3', '36131-1', '36132-9', '36134-5', '36135-2', '36136-0', '36137-8',
        '36138-6', '36139-4', '36140-2', '36141-0', '36142-8', '36143-6', '36144-4', '36145-1',
        '36146-9', '36147-7', '36148-5', '36149-3', '36150-1', '36151-9', '36152-7', '36155-0',
        '36156-8', '36157-6', '36158-4', '36159-2', '36160-0', '36161-8', '36162-6', '36163-4',
        '36164-2', '36165-9', '36166-7', '36167-5', '36168-3', '36169-1', '36170-9', '36171-7',
        '36172-5', '36173-3', '36174-1', '36175-8', '36176-6', '36177-4', '36178-2', '36179-0',
        '36180-8', '36181-6', '36182-4', '36183-2', '36184-0', '36185-7', '36186-5', '36187-3',
        '36188-1', '36189-9', '36190-7', '36191-5', '36192-3', '36193-1', '36194-9', '36195-6',
        '36196-4', '36197-2', '36199-8', '36200-4', '36201-2', '36202-0', '36203-8', '36204-6',
        '36205-3', '36206-1', '36207-9', '36208-7', '36209-5', '36210-3', '36211-1', '36212-9',
        '36213-7', '36214-5', '36215-2', '36216-0', '36217-8', '36218-6', '36219-4', '36220-2',
        '36221-0', '36222-8', '36223-6', '36224-4', '36225-1', '36226-9', '36227-7', '36228-5',
        '36229-3', '36230-1', '36231-9', '36232-7', '36233-5', '36234-3', '36235-0', '36236-8',
        '36237-6', '36238-4', '36239-2', '36240-0', '36241-8', '36242-6', '36243-4', '36244-2',
        '36245-9', '36246-7', '36247-5', '36248-3', '36249-1', '36250-9', '36251-7', '36252-5',
        '36253-3', '36254-1', '36255-8', '36256-6', '36257-4', '36258-2', '36259-0', '36260-8',
        '36261-6', '36262-4', '36263-2', '36264-0', '36265-7', '36266-5', '36267-3', '36268-1',
        '36269-9', '36270-7', '36271-5', '36272-3', '36273-1', '36274-9', '36275-6', '36276-4',
        '36277-2', '36278-0', '36279-8', '36282-2', '36283-0', '36284-8', '36285-5', '36286-3',
        '36287-1', '36288-9', '36289-7', '36290-5', '36291-3', '36292-1', '36293-9', '36294-7',
        '36295-4', '36296-2', '36297-0', '36298-8', '36299-6', '36300-2', '36301-0', '36302-8',
        '36303-6', '36304-4', '36305-1', '36306-9', '36307-7', '36308-5', '36309-3', '36310-1',
        '36311-9', '36312-7', '36313-5', '36314-3', '36315-0', '36316-8', '36317-6', '36318-4',
        '36319-2', '36320-0', '36321-8', '36322-6', '36323-4', '36324-2', '36325-9', '36326-7',
        '36327-5', '36328-3', '36329-1', '36330-9', '36331-7', '36332-5', '36333-3', '36334-1',
        '36335-8', '36336-6', '36337-4', '36338-2', '36339-0', '36340-8', '36341-6', '36342-4',
        '36343-2', '36344-0', '36345-7', '36346-5', '36347-3', '36348-1', '36349-9', '36350-7',
        '36351-5', '36352-3', '36353-1', '36354-9', '36355-6', '36356-4', '36357-2', '36359-8',
        '36360-6', '36361-4', '36362-2', '36363-0', '36364-8', '36365-5', '36366-3', '36367-1',
        '36368-9', '36369-7', '36370-5', '36371-3', '36372-1', '36373-9', '36374-7', '36375-4',
        '36376-2', '36377-0', '36378-8', '36379-6', '36380-4', '36381-2', '36382-0', '36383-8',
        '36384-6', '36385-3', '36387-9', '36388-7', '36389-5', '36390-3', '36391-1', '36392-9',
        '36393-7', '36394-5', '36395-2', '36396-0', '36397-8', '36398-6', '36399-4', '36400-0',
        '36401-8', '36402-6', '36403-4', '36404-2', '36405-9', '36406-7', '36407-5', '36408-3',
        '36409-1', '36410-9', '36411-7', '36412-5', '36413-3', '36414-1', '36415-8', '36416-6',
        '36417-4', '36418-2', '36419-0', '36420-8', '36421-6', '36422-4', '36423-2', '36424-0',
        '36425-7', '36426-5', '36427-3', '36428-1', '36429-9', '36430-7', '36431-5', '36432-3',
        '36433-1', '36434-9', '36435-6', '36436-4', '36437-2', '36438-0', '36439-8', '36442-2',
        '36443-0', '36444-8', '36445-5', '36446-3', '36447-1', '36448-9', '36449-7', '36450-5',
        '36451-3', '36452-1', '36453-9', '36454-7', '36455-4', '36456-2', '36457-0', '36458-8',
        '36459-6', '36460-4', '36461-2', '36462-0', '36463-8', '36464-6', '36465-3', '36466-1',
        '36467-9', '36468-7', '36469-5', '36470-3', '36471-1', '36472-9', '36473-7', '36474-5',
        '36475-2', '36476-0', '36477-8', '36478-6', '36479-4', '36480-2', '36481-0', '36482-8',
        '36484-4', '36485-1', '36486-9', '36487-7', '36488-5', '36489-3', '36490-1', '36491-9',
        '36492-7', '36493-5', '36494-3', '36495-0', '36496-8', '36497-6', '36498-4', '36499-2',
        '36500-7', '36501-5', '36502-3', '36503-1', '36504-9', '36505-6', '36506-4', '36507-2',
        '36508-0', '36509-8', '36510-6', '36511-4', '36512-2', '36513-0', '36514-8', '36515-5',
        '36516-3', '36517-1', '36518-9', '36519-7', '36520-5', '36521-3', '36522-1', '36523-9',
        '36524-7', '36525-4', '36526-2', '36527-0', '36528-8', '36529-6', '36530-4', '36531-2',
        '36532-0', '36533-8', '36534-6', '36535-3', '36536-1', '36537-9', '36538-7', '36539-5',
        '36540-3', '36541-1', '36542-9', '36543-7', '36544-5', '36545-2', '36546-0', '36547-8',
        '36548-6', '36549-4', '36550-2', '36551-0', '36554-4', '36555-1', '36556-9', '36557-7',
        '36558-5', '36559-3', '36560-1', '36561-9', '36563-5', '36564-3', '36565-0', '36566-8',
        '36567-6', '36568-4', '36569-2', '36570-0', '36571-8', '36572-6', '36573-4', '36574-2',
        '36575-9', '36576-7', '36577-5', '36578-3', '36579-1', '36580-9', '36581-7', '36582-5',
        '36583-3', '36584-1', '36585-8', '36586-6', '36587-4', '36588-2', '36589-0', '36590-8',
        '36591-6', '36592-4', '36593-2', '36594-0', '36595-7', '36596-5', '36597-3', '36598-1',
        '36599-9', '36600-5', '36601-3', '36602-1', '36603-9', '36604-7', '36605-4', '36606-2',
        '36607-0', '36608-8', '36609-6', '36610-4', '36611-2', '36612-0', '36613-8', '36614-6',
        '36615-3', '36616-1', '36617-9', '36618-7', '36619-5', '36620-3', '36621-1', '36622-9',
        '36623-7', '36624-5', '36625-2', '36626-0', '36627-8', '36628-6', '36629-4', '36630-2',
        '36631-0', '36632-8', '36633-6', '36634-4', '36635-1', '36636-9', '36637-7', '36638-5',
        '36639-3', '36640-1', '36641-9', '36642-7', '36643-5', '36644-3', '36645-0', '36646-8',
        '36647-6', '36648-4', '36649-2', '36650-0', '36651-8', '36652-6', '36653-4', '36654-2',
        '36655-9', '36656-7', '36657-5', '36658-3', '36659-1', '36660-9', '36661-7', '36662-5',
        '36663-3', '36664-1', '36665-8', '36666-6', '36667-4', '36668-2', '36669-0', '36670-8',
        '36671-6', '36672-4', '36673-2', '36674-0', '36675-7', '36676-5', '36677-3', '36678-1',
        '36679-9', '36680-7', '36681-5', '36682-3', '36683-1', '36684-9', '36685-6', '36686-4',
        '36687-2', '36688-0', '36689-8', '36690-6', '36691-4', '36692-2', '36693-0', '36694-8',
        '36695-5', '36696-3', '36697-1', '36698-9', '36699-7', '36700-3', '36701-1', '36702-9',
        '36703-7', '36704-5', '36705-2', '36706-0', '36707-8', '36708-6', '36709-4', '36710-2',
        '36711-0', '36712-8', '36713-6', '36714-4', '36715-1', '36716-9', '36717-7', '36718-5',
        '36719-3', '36720-1', '36721-9', '36722-7', '36723-5', '36724-3', '36725-0', '36726-8',
        '36727-6', '36728-4', '36729-2', '36730-0', '36731-8', '36732-6', '36733-4', '36734-2',
        '36735-9', '36736-7', '36737-5', '36738-3', '36739-1', '36740-9', '36741-7', '36742-5',
        '36743-3', '36744-1', '36745-8', '36746-6', '36747-4', '36748-2', '36749-0', '36750-8',
        '36751-6', '36752-4', '36753-2', '36754-0', '36755-7', '36756-5', '36757-3', '36758-1',
        '36759-9', '36760-7', '36761-5', '36762-3', '36763-1', '36764-9', '36765-6', '36766-4',
        '36767-2', '36768-0', '36769-8', '36770-6', '36771-4', '36772-2', '36773-0', '36774-8',
        '36775-5', '36776-3', '36777-1', '36778-9', '36779-7', '36780-5', '36781-3', '36782-1',
        '36783-9', '36784-7', '36785-4', '36786-2', '36787-0', '36788-8', '36789-6', '36790-4',
        '36791-2', '36792-0', '36794-6', '36795-3', '36796-1', '36797-9', '36798-7', '36799-5',
        '36800-1', '36801-9', '36802-7', '36803-5', '36804-3', '36805-0', '36806-8', '36807-6',
        '36808-4', '36809-2', '36811-8', '36812-6', '36813-4', '36814-2', '36815-9', '36816-7',
        '36817-5', '36818-3', '36819-1', '36820-9', '36821-7', '36822-5', '36823-3', '36824-1',
        '36825-8', '36826-6', '36827-4', '36828-2', '36830-8', '36831-6', '36832-4', '36833-2',
        '36834-0', '36835-7', '36837-3', '36838-1', '36839-9', '36840-7', '36841-5', '36842-3',
        '36843-1', '36844-9', '36845-6', '36846-4', '36847-2', '36848-0', '36849-8', '36850-6',
        '36851-4', '36852-2', '36853-0', '36854-8', '36855-5', '36857-1', '36858-9', '36859-7',
        '36860-5', '36861-3', '36862-1', '36863-9', '36864-7', '36865-4', '36866-2', '36867-0',
        '36868-8', '36869-6', '36870-4', '36871-2', '36872-0', '36873-8', '36874-6', '36875-3',
        '36876-1', '36877-9', '36878-7', '36879-5', '36881-1', '36882-9', '36883-7', '36886-0',
        '36887-8', '36890-2', '36893-6', '36894-4', '36926-4', '36927-2', '36928-0', '36929-8',
        '36930-6', '36931-4', '36932-2', '36933-0', '36934-8', '36935-5', '36936-3', '36937-1',
        '36938-9', '36941-3', '36942-1', '36943-9', '36944-7', '36945-4', '36946-2', '36947-0',
        '36948-8', '36949-6', '36950-4', '36951-2', '36952-0', '36953-8', '36954-6', '36955-3',
        '36956-1', '36958-7', '36959-5', '36960-3', '36961-1', '36962-9', '36963-7', '36964-5',
        '36965-2', '36966-0', '36967-8', '36968-6', '36971-0', '36972-8', '36973-6', '36974-4',
        '36975-1', '36976-9', '36977-7', '36978-5', '36979-3', '36980-1', '36981-9', '36982-7',
        '36983-5', '36984-3', '36985-0', '36986-8', '36987-6', '36988-4', '36989-2', '36990-0',
        '36991-8', '36992-6', '36993-4', '36994-2', '36995-9', '36996-7', '36997-5', '36998-3',
        '36999-1', '37000-7', '37001-5', '37002-3', '37003-1', '37004-9', '37005-6', '37006-4',
        '37007-2', '37008-0', '37009-8', '37010-6', '37011-4', '37012-2', '37013-0', '37014-8',
        '37015-5', '37016-3', '37017-1', '37018-9', '37019-7', '37020-5', '37021-3', '37022-1',
        '37023-9', '37024-7', '37025-4', '37026-2', '37027-0', '37028-8', '37029-6', '37030-4',
        '37031-2', '37032-0', '37033-8', '37034-6', '37035-3', '37037-9', '37038-7', '37039-5',
        '37040-3', '37041-1', '37042-9', '37043-7', '37044-5', '37045-2', '37046-0', '37047-8',
        '37048-6', '37049-4', '37050-2', '37051-0', '37052-8', '37053-6', '37054-4', '37055-1',
        '37056-9', '37057-7', '37058-5', '37059-3', '37060-1', '37062-7', '37063-5', '37064-3',
        '37066-8', '37067-6', '37068-4', '37069-2', '37070-0', '37071-8', '37072-6', '37073-4',
        '37074-2', '37075-9', '37076-7', '37077-5', '37078-3', '37079-1', '37080-9', '37081-7',
        '37082-5', '37083-3', '37084-1', '37085-8', '37086-6', '37087-4', '37088-2', '37089-0',
        '37090-8', '37091-6', '37092-4', '37093-2', '37094-0', '37095-7', '37096-5', '37097-3',
        '37098-1', '37099-9', '37100-5', '37101-3', '37102-1', '37103-9', '37104-7', '37105-4',
        '37106-2', '37107-0', '37108-8', '37109-6', '37110-4', '37111-2', '37112-0', '37113-8',
        '37114-6', '37115-3', '37116-1', '37117-9', '37118-7', '37119-5', '37120-3', '37121-1',
        '37122-9', '37123-7', '37124-5', '37125-2', '37126-0', '37127-8', '37128-6', '37131-0',
        '37132-8', '37133-6', '37134-4', '37135-1', '37136-9', '37137-7', '37138-5', '37139-3',
        '37140-1', '37141-9', '37142-7', '37143-5', '37144-3', '37145-0', '37146-8', '37147-6',
        '37148-4', '37149-2', '37150-0', '37151-8', '37152-6', '37153-4', '37154-2', '37155-9',
        '37156-7', '37157-5', '37158-3', '37160-9', '37161-7', '37162-5', '37163-3', '37164-1',
        '37165-8', '37166-6', '37167-4', '37168-2', '37169-0', '37170-8', '37171-6', '37172-4',
        '37173-2', '37174-0', '37175-7', '37176-5', '37177-3', '37178-1', '37179-9', '37180-7',
        '37181-5', '37182-3', '37183-1', '37184-9', '37185-6', '37186-4', '37187-2', '37188-0',
        '37189-8', '37190-6', '37191-4', '37192-2', '37193-0', '37195-5', '37196-3', '37198-9',
        '37199-7', '37200-3', '37201-1', '37202-9', '37203-7', '37204-5', '37205-2', '37206-0',
        '37207-8', '37208-6', '37209-4', '37210-2', '37211-0', '37212-8', '37213-6', '37214-4',
        '37215-1', '37217-7', '37218-5', '37219-3', '37220-1', '37221-9', '37222-7', '37223-5',
        '37224-3', '37225-0', '37226-8', '37227-6', '37228-4', '37229-2', '37230-0', '37231-8',
        '37232-6', '37233-4', '37234-2', '37235-9', '37237-5', '37238-3', '37239-1', '37240-9',
        '37241-7', '37242-5', '37243-3', '37244-1', '37245-8', '37246-6', '37247-4', '37248-2',
        '37249-0', '37253-2', '37254-0', '37256-5', '37257-3', '37259-9', '37260-7', '37261-5',
        '37265-6', '37266-4', '37267-2', '37268-0', '37269-8', '37270-6', '37271-4', '37272-2',
        '37277-1', '37278-9', '37279-7', '37280-5', '37281-3', '37282-1', '37283-9', '37284-7',
        '37285-4', '37286-2', '37287-0', '37288-8', '37293-8', '37297-9', '37298-7', '37299-5',
        '37300-1', '37302-7', '37303-5', '37304-3', '37319-1', '37320-9', '37321-7', '37323-3',
        '37324-1', '37325-8', '37332-4', '37338-1', '37340-7', '37341-5', '37342-3', '37348-0',
        '37350-6', '37351-4', '37353-0', '37355-5', '37356-3', '37357-1', '37361-3', '37362-1',
        '37364-7', '37365-4', '37379-5', '37380-3', '37381-1', '37382-9', '37383-7', '37384-5',
        '37385-2', '37386-0', '37387-8', '37388-6', '37389-4', '37390-2', '37391-0', '37392-8',
        '37393-6', '37394-4', '37395-1', '37396-9', '37397-7', '37398-5', '37399-3', '37401-7',
        '37402-5', '37403-3', '37404-1', '37405-8', '37406-6', '37407-4', '37409-0', '37410-8',
        '37411-6', '37412-4', '37413-2', '37414-0', '37415-7', '37416-5', '37419-9', '37421-5',
        '37422-3', '37423-1', '37426-4', '37427-2', '37428-0', '37429-8', '37430-6', '37431-4',
        '37432-2', '37433-0', '37434-8', '37435-5', '37437-1', '37439-7', '37440-5', '37441-3',
        '37442-1', '37443-9', '37444-7', '37445-4', '37446-2', '37447-0', '37448-8', '37449-6',
        '37450-4', '37451-2', '37452-0', '37453-8', '37454-6', '37455-3', '37457-9', '37458-7',
        '37459-5', '37460-3', '37461-1', '37462-9', '37463-7', '37464-5', '37465-2', '37466-0',
        '37467-8', '37468-6', '37469-4', '37470-2', '37471-0', '37472-8', '37473-6', '37474-4',
        '37475-1', '37476-9', '37477-7', '37481-9', '37482-7', '37483-5', '37484-3', '37485-0',
        '37486-8', '37487-6', '37488-4', '37489-2', '37490-0', '37491-8', '37492-6', '37493-4',
        '37494-2', '37495-9', '37496-7', '37497-5', '37498-3', '37500-6', '37501-4', '37502-2',
        '37503-0', '37505-5', '37506-3', '37507-1', '37508-9', '37509-7', '37510-5', '37511-3',
        '37512-1', '37513-9', '37514-7', '37515-4', '37516-2', '37517-0', '37518-8', '37519-6',
        '37520-4', '37521-2', '37522-0', '37523-8', '37524-6', '37530-3', '37531-1', '37532-9',
        '37533-7', '37534-5', '37535-2', '37538-6', '37539-4', '37540-2', '37541-0', '37542-8',
        '37543-6', '37544-4', '37545-1', '37546-9', '37547-7', '37548-5', '37549-3', '37550-1',
        '37551-9', '37552-7', '37553-5', '37554-3', '37555-0', '37556-8', '37557-6', '37558-4',
        '37559-2', '37560-0', '37561-8', '37562-6', '37563-4', '37564-2', '37565-9', '37566-7',
        '37567-5', '37568-3', '37569-1', '37570-9', '37571-7', '37572-5', '37574-1', '37575-8',
        '37576-6', '37577-4', '37578-2', '37579-0', '37580-8', '37581-6', '37582-4', '37583-2',
        '37584-0', '37585-7', '37586-5', '37587-3', '37588-1', '37589-9', '37590-7', '37591-5',
        '37592-3', '37593-1', '37594-9', '37595-6', '37596-4', '37597-2', '37598-0', '37599-8',
        '37600-4', '37601-2', '37602-0', '37604-6', '37605-3', '37606-1', '37607-9', '37608-7',
        '37609-5', '37611-1', '37612-9', '37613-7', '37614-5', '37615-2', '37616-0', '37617-8',
        '37618-6', '37619-4', '37620-2', '37621-0', '37622-8', '37623-6', '37624-4', '37625-1',
        '37626-9', '37627-7', '37628-5', '37629-3', '37630-1', '37631-9', '37632-7', '37633-5',
        '37634-3', '37635-0', '37636-8', '37637-6', '37639-2', '37640-0', '37641-8', '37642-6',
        '37643-4', '37644-2', '37645-9', '37646-7', '37647-5', '37648-3', '37649-1', '37650-9',
        '37651-7', '37652-5', '37653-3', '37654-1', '37655-8', '37656-6', '37658-2', '37659-0',
        '37660-8', '37661-6', '37662-4', '37663-2', '37664-0', '37665-7', '37666-5', '37667-3',
        '37668-1', '37669-9', '37670-7', '37671-5', '37672-3', '37673-1', '37674-9', '37675-6',
        '37676-4', '37677-2', '37678-0', '37679-8', '37680-6', '37681-4', '37682-2', '37683-0',
        '37684-8', '37685-5', '37686-3', '37687-1', '37688-9', '37689-7', '37690-5', '37691-3',
        '37692-1', '37693-9', '37694-7', '37695-4', '37696-2', '37697-0', '37698-8', '37699-6',
        '37700-2', '37701-0', '37702-8', '37703-6', '37704-4', '37705-1', '37706-9', '37707-7',
        '37708-5', '37709-3', '37710-1', '37711-9', '37712-7', '37713-5', '37714-3', '37715-0',
        '37716-8', '37717-6', '37718-4', '37719-2', '37720-0', '37721-8', '37722-6', '37723-4',
        '37724-2', '37725-9', '37726-7', '37727-5', '37728-3', '37729-1', '37730-9', '37731-7',
        '37732-5', '37733-3', '37734-1', '37735-8', '37736-6', '37737-4', '37738-2', '37739-0',
        '37740-8', '37741-6', '37742-4', '37743-2', '37744-0', '37745-7', '37746-5', '37747-3',
        '37748-1', '37749-9', '37750-7', '37751-5', '37752-3', '37753-1', '37754-9', '37755-6',
        '37756-4', '37757-2', '37758-0', '37759-8', '37760-6', '37761-4', '37762-2', '37763-0',
        '37764-8', '37765-5', '37766-3', '37767-1', '37768-9', '37769-7', '37770-5', '37771-3',
        '37772-1', '37773-9', '37774-7', '37775-4', '37776-2', '37777-0', '37778-8', '37779-6',
        '37780-4', '37781-2', '37782-0', '37783-8', '37784-6', '37785-3', '37786-1', '37787-9',
        '37788-7', '37789-5', '37790-3', '37791-1', '37792-9', '37793-7', '37794-5', '37795-2',
        '37796-0', '37797-8', '37798-6', '37799-4', '37800-0', '37801-8', '37802-6', '37803-4',
        '37804-2', '37805-9', '37806-7', '37807-5', '37808-3', '37809-1', '37810-9', '37811-7',
        '37812-5', '37813-3', '37814-1', '37815-8', '37816-6', '37817-4', '37818-2', '37819-0',
        '37820-8', '37821-6', '37822-4', '37823-2', '37824-0', '37825-7', '37826-5', '37827-3',
        '37828-1', '37829-9', '37830-7', '37831-5', '37832-3', '37833-1', '37834-9', '37835-6',
        '37836-4', '37839-8', '37840-6', '37841-4', '37842-2', '37843-0', '37844-8', '37845-5',
        '37846-3', '37847-1', '37848-9', '37849-7', '37850-5', '37851-3', '37852-1', '37853-9',
        '37854-7', '37855-4', '37856-2', '37857-0', '37858-8', '37859-6', '37860-4', '37861-2',
        '37862-0', '37863-8', '37864-6', '37866-1', '37867-9', '37868-7', '37869-5', '37870-3',
        '37871-1', '37872-9', '37874-5', '37875-2', '37876-0', '37877-8', '37878-6', '37879-4',
        '37880-2', '37881-0', '37882-8', '37883-6', '37884-4', '37885-1', '37886-9', '37887-7',
        '37888-5', '37889-3', '37890-1', '37891-9', '37892-7', '37893-5', '37894-3', '37895-0',
        '37896-8', '37897-6', '37898-4', '37899-2', '37901-6', '37902-4', '37903-2', '37904-0',
        '37905-7', '37906-5', '37907-3', '37908-1', '37909-9', '37910-7', '37911-5', '37912-3',
        '37913-1', '37914-9', '37915-6', '37917-2', '37918-0', '37919-8', '37920-6', '37921-4',
        '37922-2', '37923-0', '37924-8', '37925-5', '37926-3', '37927-1', '37928-9', '37929-7',
        '37930-5', '37931-3', '37932-1', '37933-9', '37934-7', '37935-4', '37936-2', '37937-0',
        '37938-8', '37939-6', '37940-4', '37941-2', '37942-0', '37943-8', '37944-6', '37945-3',
        '37947-9', '37948-7', '37949-5', '37950-3', '37952-9', '37953-7', '37958-6', '37959-4',
        '37960-2', '37961-0', '37962-8', '37963-6', '37964-4', '37965-1', '37966-9', '37967-7',
        '37968-5', '37969-3', '37970-1', '37971-9', '37972-7', '37973-5', '37974-3', '37975-0',
        '37976-8', '37977-6', '37979-2', '37980-0', '37981-8', '37994-1', '37995-8', '37996-6',
        '37997-4', '37998-2', '37999-0', '38000-6', '38001-4', '38002-2', '38003-0', '38004-8',
        '38006-3', '38007-1', '38008-9', '38009-7', '38010-5', '38011-3', '38012-1', '38013-9',
        '38014-7', '38015-4', '38016-2', '38017-0', '38018-8', '38019-6', '38020-4', '38021-2',
        '38022-0', '38023-8', '38024-6', '38025-3', '38026-1', '38030-3', '38032-9', '38033-7',
        '38034-5', '38035-2', '38036-0', '38037-8', '38038-6', '38039-4', '38040-2', '38041-0',
        '38042-8', '38043-6', '38044-4', '38045-1', '38046-9', '38047-7', '38048-5', '38049-3',
        '38050-1', '38051-9', '38052-7', '38053-5', '38054-3', '38057-6', '38058-4', '38061-8',
        '38062-6', '38064-2', '38065-9', '38066-7', '38068-3', '38069-1', '38070-9', '38071-7',
        '38072-5', '38073-3', '38074-1', '38079-0', '38080-8', '38082-4', '38083-2', '38084-0',
        '38086-5', '38087-3', '38088-1', '38089-9', '38090-7', '38091-5', '38092-3', '38093-1',
        '38094-9', '38095-6', '38096-4', '38097-2', '38098-0', '38099-8', '38100-4', '38101-2',
        '38102-0', '38103-8', '38104-6', '38105-3', '38107-9', '38108-7', '38112-9', '38114-5',
        '38115-2', '38116-0', '38117-8', '38118-6', '38119-4', '38120-2', '38121-0', '38123-6',
        '38124-4', '38125-1', '38126-9', '38127-7', '38128-5', '38129-3', '38130-1', '38131-9',
        '38132-7', '38133-5', '38134-3', '38135-0', '38136-8', '38137-6', '38138-4', '38139-2',
        '38140-0', '38141-8', '38142-6', '38143-4', '38144-2', '38145-9', '38146-7', '38147-5',
        '38148-3', '38149-1', '38150-9', '38151-7', '38152-5', '38153-3', '38154-1', '38155-8',
        '38156-6', '38181-4', '38261-4', '38262-2', '38263-0', '38264-8', '38265-5', '38266-3',
        '38267-1', '38268-9', '38765-4', '38766-2', '38767-0', '38768-8', '38769-6', '38770-4',
        '38771-2', '38772-0', '38773-8', '38774-6', '38775-3', '38776-1', '38777-9', '38778-7',
        '38779-5', '38780-3', '38781-1', '38782-9', '38783-7', '38784-5', '38785-2', '38786-0',
        '38787-8', '38788-6', '38789-4', '38790-2', '38791-0', '38793-6', '38794-4', '38795-1',
        '38796-9', '38797-7', '38798-5', '38799-3', '38800-9', '38801-7', '38802-5', '38803-3',
        '38804-1', '38805-8', '38806-6', '38807-4', '38808-2', '38810-8', '38811-6', '38812-4',
        '38813-2', '38814-0', '38815-7', '38816-5', '38817-3', '38818-1', '38819-9', '38820-7',
        '38821-5', '38822-3', '38824-9', '38825-6', '38826-4', '38827-2', '38828-0', '38829-8',
        '38830-6', '38831-4', '38832-2', '38833-0', '38834-8', '38835-5', '38836-3', '38837-1',
        '38838-9', '38839-7', '38840-5', '38841-3', '38842-1', '38843-9', '38844-7', '38845-4',
        '38846-2', '38847-0', '38848-8', '38849-6', '38850-4', '38851-2', '38852-0', '38853-8',
        '38854-6', '38855-3', '38856-1', '38857-9', '38858-7', '38859-5', '38860-3', '38861-1',
        '38862-9', '38863-7', '38864-5', '38865-2', '38866-0', '38867-8', '38868-6', '38869-4',
        '38870-2', '38871-0', '38872-8', '38874-4', '39026-0', '39027-8', '39028-6', '39029-4',
        '39030-2', '39031-0', '39032-8', '39033-6', '39034-4', '39036-9', '39037-7', '39038-5',
        '39039-3', '39040-1', '39042-7', '39044-3', '39045-0', '39046-8', '39047-6', '39048-4',
        '39049-2', '39050-0', '39051-8', '39052-6', '39053-4', '39054-2', '39055-9', '39056-7',
        '39057-5', '39058-3', '39060-9', '39061-7', '39062-5', '39063-3', '39064-1', '39065-8',
        '39066-6', '39067-4', '39068-2', '39069-0', '39070-8', '39071-6', '39072-4', '39073-2',
        '39074-0', '39075-7', '39076-5', '39077-3', '39078-1', '39079-9', '39093-0', '39094-8',
        '39095-5', '39096-3', '39097-1', '39098-9', '39099-7', '39138-3', '39139-1', '39140-9',
        '39141-7', '39142-5', '39144-1', '39145-8', '39146-6', '39147-4', '39148-2', '39149-0',
        '39150-8', '39151-6', '39152-4', '39153-2', '39154-0', '39291-0', '39292-8', '39293-6',
        '39321-5', '39322-3', '39323-1', '39324-9', '39325-6', '39326-4', '39327-2', '39328-0',
        '39329-8', '39330-6', '39331-4', '39332-2', '39333-0', '39334-8', '39335-5', '39336-3',
        '39337-1', '39338-9', '39339-7', '39340-5', '39341-3', '39343-9', '39344-7', '39345-4',
        '39346-2', '39347-0', '39348-8', '39349-6', '39350-4', '39351-2', '39352-0', '39353-8',
        '39359-5', '39360-3', '39361-1', '39362-9', '39363-7', '39364-5', '39365-2', '39366-0',
        '39367-8', '39368-6', '39369-4', '39370-2', '39371-0', '39372-8', '39373-6', '39374-4',
        '39375-1', '39376-9', '39377-7', '39378-5', '39379-3', '39380-1', '39381-9', '39382-7',
        '39383-5', '39384-3', '39385-0', '39386-8', '39387-6', '39388-4', '39389-2', '39390-0',
        '39391-8', '39392-6', '39393-4', '39394-2', '39395-9', '39396-7', '39397-5', '39398-3',
        '39399-1', '39400-7', '39401-5', '39402-3', '39403-1', '39404-9', '39405-6', '39406-4',
        '39407-2', '39408-0', '39409-8', '39410-6', '39411-4', '39412-2', '39413-0', '39414-8',
        '39415-5', '39416-3', '39418-9', '39419-7', '39420-5', '39421-3', '39422-1', '39423-9',
        '39424-7', '39425-4', '39426-2', '39427-0', '39428-8', '39429-6', '39430-4', '39431-2',
        '39432-0', '39433-8', '39434-6', '39435-3', '39436-1', '39437-9', '39439-5', '39440-3',
        '39441-1', '39442-9', '39443-7', '39444-5', '39445-2', '39446-0', '39447-8', '39448-6',
        '39449-4', '39450-2', '39451-0', '39452-8', '39453-6', '39454-4', '39489-0', '39490-8',
        '39491-6', '39492-4', '39493-2', '39494-0', '39495-7', '39496-5', '39497-3', '39498-1',
        '39499-9', '39500-4', '39501-2', '39502-0', '39503-8', '39504-6', '39505-3', '39506-1',
        '39507-9', '39508-7', '39509-5', '39510-3', '39511-1', '39512-9', '39513-7', '39514-5',
        '39515-2', '39516-0', '39517-8', '39518-6', '39519-4', '39520-2', '39521-0', '39522-8',
        '39523-6', '39524-4', '39525-1', '39526-9', '39527-7', '39619-2', '39620-0', '39621-8',
        '39622-6', '39623-4', '39624-2', '39625-9', '39626-7', '39627-5', '39628-3', '39629-1',
        '39630-9', '39631-7', '39632-5', '39634-1', '39635-8', '39636-6', '39637-4', '39638-2',
        '39639-0', '39640-8', '39641-6', '39642-4', '39643-2', '39644-0', '39645-7', '39646-5',
        '39647-3', '39648-1', '39649-9', '39650-7', '39651-5', '39652-3', '39653-1', '39654-9',
        '39655-6', '39656-4', '39657-2', '39658-0', '39660-6', '39661-4', '39662-2', '39663-0',
        '39664-8', '39665-5', '39666-3', '39667-1', '39668-9', '39669-7', '39670-5', '39671-3',
        '39672-1', '39673-9', '39674-7', '39675-4', '39677-0', '39678-8', '39679-6', '39680-4',
        '39681-2', '39682-0', '39683-8', '39684-6', '39685-3', '39686-1', '39687-9', '39688-7',
        '39689-5', '39690-3', '39691-1', '39692-9', '39693-7', '39694-5', '39695-2', '39696-0',
        '39697-8', '39698-6', '39699-4', '39700-0', '39701-8', '39702-6', '39703-4', '39704-2',
        '39705-9', '39707-5', '39708-3', '39709-1', '39710-9', '39711-7', '39712-5', '39713-3',
        '39714-1', '39715-8', '39716-6', '39718-2', '39719-0', '39720-8', '39722-4', '39723-2',
        '39724-0', '39725-7', '39726-5', '39727-3', '39728-1', '39729-9', '39730-7', '39731-5',
        '39732-3', '39733-1', '39734-9', '39735-6', '39736-4', '39737-2', '39738-0', '39739-8',
        '39740-6', '39741-4', '39742-2', '39743-0', '39744-8', '39745-5', '39746-3', '39747-1',
        '39748-9', '39749-7', '39750-5', '39751-3', '39752-1', '39753-9', '39754-7', '39755-4',
        '39756-2', '39757-0', '39758-8', '39759-6', '39760-4', '39761-2', '39762-0', '39763-8',
        '39764-6', '39765-3', '39766-1', '39767-9', '39768-7', '39769-5', '39770-3', '39811-5',
        '39812-3', '39813-1', '39816-4', '39818-0', '39819-8', '39820-6', '39821-4', '39822-2',
        '39823-0', '39824-8', '39825-5', '39826-3', '39827-1', '39828-9', '39829-7', '39830-5',
        '39831-3', '39834-7', '39837-0', '39838-8', '39839-6', '39840-4', '39841-2', '39842-0',
        '39843-8', '39844-6', '39845-3', '39846-1', '39847-9', '39848-7', '39849-5', '39850-3',
        '39851-1', '39852-9', '39856-0', '39857-8', '39858-6', '39859-4', '39860-2', '39861-0',
        '39862-8', '39863-6', '39864-4', '39865-1', '39866-9', '39867-7', '39868-5', '39869-3',
        '39870-1', '39871-9', '39872-7', '39873-5', '39874-3', '39875-0', '39876-8', '39877-6',
        '39879-2', '39880-0', '39881-8', '39882-6', '39883-4', '39884-2', '39885-9', '39886-7',
        '39887-5', '39888-3', '39889-1', '39890-9', '39891-7', '39892-5', '39893-3', '39895-8',
        '39897-4', '39898-2', '39899-0', '39901-4', '39902-2', '39904-8', '39905-5', '39906-3',
        '39907-1', '39908-9', '39909-7', '39910-5', '39912-1', '39913-9', '39914-7', '39915-4',
        '39916-2', '39917-0', '39918-8', '39919-6', '39920-4', '39921-2', '39922-0', '39923-8',
        '39924-6', '39925-3', '39927-9', '39928-7', '39929-5', '39930-3', '39931-1', '39932-9',
        '39933-7', '39934-5', '39935-2', '39936-0', '39937-8', '39938-6', '39939-4', '39940-2',
        '39942-8', '39944-4', '39946-9', '39947-7', '39949-3', '39950-1', '39951-9', '39952-7',
        '39953-5', '39954-3', '41770-9', '41771-7', '41772-5', '41773-3', '41774-1', '41775-8',
        '41776-6', '41777-4', '41778-2', '41779-0', '41782-4', '41783-2', '41784-0', '41785-7',
        '41786-5', '41787-3', '41788-1', '41789-9', '41790-7', '41791-5', '41792-3', '41793-1',
        '41795-6', '41797-2', '41798-0', '41799-8', '41800-4', '41801-2', '41802-0', '41803-8',
        '41806-1', '41807-9', '41808-7', '41809-5', '41811-1', '41812-9', '41813-7', '41814-5',
        '41815-2', '41816-0', '41817-8', '41818-6', '41819-4', '41820-2', '41823-6', '41824-4',
        '41825-1', '41826-9', '41827-7', '41828-5', '41829-3', '41830-1', '41831-9', '41832-7',
        '41833-5', '41834-3', '41835-0', '41836-8', '41837-6', '41838-4', '42007-5', '42008-3',
        '42009-1', '42010-9', '42011-7', '42012-5', '42014-1', '42017-4', '42018-2', '42019-0',
        '42020-8', '42021-6', '42132-1', '42133-9', '42134-7', '42135-4', '42136-2', '42137-0',
        '42140-4', '42141-2', '42143-8', '42144-6', '42145-3', '42146-1', '42147-9', '42148-7',
        '42149-5', '42150-3', '42151-1', '42152-9', '42153-7', '42156-0', '42157-8', '42158-6',
        '42159-4', '42160-2', '42161-0', '42163-6', '42164-4', '42165-1', '42166-9', '42167-7',
        '42168-5', '42169-3', '42170-1', '42171-9', '42174-3', '42175-0', '42260-0', '42261-8',
        '42262-6', '42263-4', '42265-9', '42268-3', '42269-1', '42270-9', '42271-7', '42272-5',
        '42273-3', '42274-1', '42275-8', '42276-6', '42277-4', '42278-2', '42279-0', '42280-8',
        '42281-6', '42282-4', '42283-2', '42284-0', '42285-7', '42286-5', '42287-3', '42291-5',
        '42292-3', '42293-1', '42294-9', '42295-6', '42296-4', '42297-2', '42298-0', '42299-8',
        '42300-4', '42301-2', '42302-0', '42303-8', '42304-6', '42305-3', '42306-1', '42308-7',
        '42309-5', '42310-3', '42311-1', '42312-9', '42313-7', '42314-5', '42333-5', '42334-3',
        '42335-0', '42377-2', '42378-0', '42379-8', '42380-6', '42381-4', '42382-2', '42383-0',
        '42385-5', '42386-3', '42387-1', '42388-9', '42389-7', '42390-5', '42391-3', '42392-1',
        '42393-9', '42394-7', '42395-4', '42396-2', '42397-0', '42398-8', '42399-6', '42400-2',
        '42401-0', '42402-8', '42403-6', '42404-4', '42405-1', '42406-9', '42407-7', '42408-5',
        '42409-3', '42410-1', '42411-9', '42412-7', '42413-5', '42414-3', '42415-0', '42416-8',
        '42417-6', '42418-4', '42419-2', '42420-0', '42421-8', '42422-6', '42423-4', '42424-2',
        '42425-9', '42426-7', '42427-5', '42428-3', '42429-1', '42430-9', '42431-7', '42432-5',
        '42433-3', '42434-1', '42435-8', '42436-6', '42437-4', '42438-2', '42439-0', '42441-6',
        '42442-4', '42443-2', '42444-0', '42445-7', '42446-5', '42447-3', '42448-1', '42449-9',
        '42450-7', '42455-6', '42456-4', '42457-2', '42458-0', '42459-8', '42460-6', '42461-4',
        '42462-2', '42463-0', '42468-9', '42469-7', '42470-5', '42471-3', '42472-1', '42473-9',
        '42474-7', '42475-4', '42476-2', '42477-0', '42478-8', '42680-9', '42681-7', '42684-1',
        '42685-8', '42686-6', '42687-4', '42688-2', '42689-0', '42690-8', '42691-6', '42692-4',
        '42693-2', '42694-0', '42695-7', '42696-5', '42697-3', '42698-1', '42699-9', '42700-5',
        '42701-3', '42702-1', '42703-9', '42705-4', '42706-2', '42707-0', '42708-8', '42709-6',
        '42710-4', '42711-2', '42776-5', '42811-0', '42812-8', '42813-6', '42814-4', '43444-9',
        '43445-6', '43448-0', '43449-8', '43450-6', '43451-4', '43452-2', '43453-0', '43454-8',
        '43455-5', '43456-3', '43457-1', '43458-9', '43459-7', '43461-3', '43463-9', '43466-2',
        '43467-0', '43468-8', '43469-6', '43470-4', '43471-2', '43472-0', '43473-8', '43474-6',
        '43475-3', '43476-1', '43477-9', '43478-7', '43479-5', '43480-3', '43481-1', '43482-9',
        '43483-7', '43485-2', '43486-0', '43487-8', '43488-6', '43489-4', '43490-2', '43491-0',
        '43492-8', '43493-6', '43494-4', '43495-1', '43496-9', '43497-7', '43498-5', '43499-3',
        '43500-8', '43501-6', '43502-4', '43504-0', '43505-7', '43506-5', '43507-3', '43508-1',
        '43509-9', '43510-7', '43511-5', '43512-3', '43513-1', '43514-9', '43515-6', '43516-4',
        '43517-2', '43518-0', '43519-8', '43521-4', '43522-2', '43523-0', '43524-8', '43525-5',
        '43526-3', '43528-9', '43529-7', '43530-5', '43532-1', '43536-2', '43537-0', '43538-8',
        '43539-6', '43543-8', '43550-3', '43552-9', '43554-5', '43555-2', '43556-0', '43557-8',
        '43558-6', '43559-4', '43561-0', '43562-8', '43563-6', '43564-4', '43565-1', '43566-9',
        '43567-7', '43569-3', '43570-1', '43572-7', '43574-3', '43641-0', '43642-8', '43643-6',
        '43644-4', '43645-1', '43646-9', '43647-7', '43648-5', '43649-3', '43650-1', '43651-9',
        '43652-7', '43653-5', '43654-3', '43655-0', '43656-8', '43657-6', '43658-4', '43659-2',
        '43660-0', '43661-8', '43662-6', '43663-4', '43664-2', '43665-9', '43666-7', '43667-5',
        '43669-1', '43670-9', '43671-7', '43672-5', '43673-3', '43756-6', '43757-4', '43758-2',
        '43759-0', '43760-8', '43761-6', '43762-4', '43763-2', '43764-0', '43765-7', '43766-5',
        '43767-3', '43768-1', '43769-9', '43770-7', '43771-5', '43772-3', '43773-1', '43774-9',
        '43775-6', '43776-4', '43777-2', '43778-0', '43779-8', '43780-6', '43781-4', '43782-2',
        '43783-0', '43784-8', '43785-5', '43787-1', '43788-9', '43789-7', '43790-5', '43791-3',
        '43792-1', '43793-9', '43794-7', '43795-4', '43796-2', '43797-0', '44101-4', '44102-2',
        '44103-0', '44104-8', '44105-5', '44106-3', '44107-1', '44108-9', '44109-7', '44110-5',
        '44111-3', '44112-1', '44113-9', '44114-7', '44115-4', '44116-2', '44117-0', '44118-8',
        '44119-6', '44122-0', '44123-8', '44124-6', '44125-3', '44126-1', '44127-9', '44128-7',
        '44129-5', '44130-3', '44131-1', '44132-9', '44133-7', '44134-5', '44135-2', '44136-0',
        '44137-8', '44138-6', '44139-4', '44140-2', '44141-0', '44142-8', '44143-6', '44144-4',
        '44145-1', '44146-9', '44147-7', '44148-5', '44149-3', '44150-1', '44151-9', '44152-7',
        '44153-5', '44154-3', '44155-0', '44156-8', '44157-6', '44158-4', '44159-2', '44160-0',
        '44161-8', '44162-6', '44163-4', '44164-2', '44166-7', '44167-5', '44168-3', '44169-1',
        '44172-5', '44173-3', '44174-1', '44175-8', '44176-6', '44177-4', '44178-2', '44179-0',
        '44181-6', '44182-4', '44183-2', '44184-0', '44185-7', '44186-5', '44187-3', '44188-1',
        '44189-9', '44190-7', '44191-5', '44192-3', '44193-1', '44194-9', '44195-6', '44196-4',
        '44197-2', '44198-0', '44199-8', '44201-2', '44202-0', '44203-8', '44205-3', '44206-1',
        '44208-7', '44209-5', '44210-3', '44211-1', '44212-9', '44213-7', '44214-5', '44215-2',
        '44216-0', '44217-8', '44218-6', '44219-4', '44220-2', '44221-0', '44222-8', '44223-6',
        '44224-4', '44225-1', '44226-9', '44227-7', '44228-5', '44229-3', '44230-1', '44231-9',
        '44232-7', '44233-5', '44234-3', '44235-0', '44236-8', '44237-6', '44238-4', '44239-2',
        '44240-0', '46278-8', '46279-6', '46281-2', '46282-0', '46283-8', '46284-6', '46285-3',
        '46288-7', '46289-5', '46290-3', '46291-1', '46292-9', '46293-7', '46294-5', '46295-2',
        '46296-0', '46297-8', '46298-6', '46299-4', '46301-8', '46302-6', '46303-4', '46304-2',
        '46305-9', '46306-7', '46307-5', '46308-3', '46309-1', '46310-9', '46311-7', '46312-5',
        '46313-3', '46314-1', '46315-8', '46316-6', '46317-4', '46318-2', '46319-0', '46320-8',
        '46321-6', '46322-4', '46323-2', '46324-0', '46325-7', '46326-5', '46327-3', '46328-1',
        '46329-9', '46330-7', '46331-5', '46332-3', '46333-1', '46335-6', '46336-4', '46337-2',
        '46338-0', '46339-8', '46340-6', '46341-4', '46342-2', '46343-0', '46344-8', '46345-5',
        '46346-3', '46347-1', '46348-9', '46349-7', '46350-5', '46351-3', '46352-1', '46354-7',
        '46355-4', '46356-2', '46357-0', '46358-8', '46359-6', '46360-4', '46361-2', '46362-0',
        '46363-8', '46364-6', '46365-3', '46366-1', '46369-5', '46370-3', '46371-1', '46372-9',
        '46373-7', '46374-5', '46375-2', '46376-0', '46377-8', '46378-6', '46379-4', '46380-2',
        '46381-0', '46382-8', '46383-6', '46384-4', '46385-1', '46386-9', '46387-7', '46388-5',
        '46389-3', '46390-1', '46391-9', '46392-7', '46393-5', '46395-0', '46396-8', '47366-0',
        '47367-8', '47368-6', '47370-2', '47371-0', '47372-8', '47373-6', '47374-4', '47375-1',
        '47376-9', '47377-7', '47378-5', '47379-3', '47380-1', '47381-9', '47382-7', '47983-2',
        '47984-0', '47985-7', '47986-5', '47987-3', '48433-7', '48434-5', '48435-2', '48436-0',
        '48439-4', '48440-2', '48441-0', '48442-8', '48443-6', '48444-4', '48445-1', '48446-9',
        '48447-7', '48448-5', '48449-3', '48450-1', '48451-9', '48452-7', '48453-5', '48454-3',
        '48455-0', '48456-8', '48457-6', '48458-4', '48459-2', '48460-0', '48461-8', '48462-6',
        '48463-4', '48464-2', '48465-9', '48466-7', '48467-5', '48468-3', '48469-1', '48470-9',
        '48471-7', '48472-5', '48473-3', '48474-1', '48475-8', '48476-6', '48477-4', '48478-2',
        '48479-0', '48480-8', '48481-6', '48482-4', '48483-2', '48484-0', '48485-7', '48486-5',
        '48487-3', '48488-1', '48489-9', '48490-7', '48491-5', '48492-3', '48584-7', '48585-4',
        '48687-8', '48688-6', '48689-4', '48690-2', '48691-0', '48692-8', '48693-6', '48694-4',
        '48695-1', '48696-9', '48697-7', '48698-5', '48699-3', '48735-5', '48736-3', '48737-1',
        '48738-9', '48739-7', '48740-5', '48742-1', '48743-9', '48746-2', '48747-0', '48748-8',
        '48749-6', '49118-3', '49507-7', '49509-3', '49510-1', '49511-9', '49512-7', '49565-5',
        '49566-3', '49567-1', '49568-9', '49569-7', '49570-5', '49571-3', '50755-8', '51387-9',
        '51388-7', '51389-5', '51391-1', '51392-9', '51394-5', '51395-2', '52790-3', '52791-1',
        '53626-8', '57822-9', '57823-7', '58740-2', '58741-0', '58742-8', '58743-6', '58744-4',
        '58746-9', '58747-7', '58748-5', '58749-3', '58750-1', '60515-4', '60527-9', '62446-0',
        '62447-8', '62448-6', '62449-4', '62450-2', '62451-0', '62452-8', '62491-6', '62492-4',
        '62494-0', '64051-6', '64052-4', '64140-7', '64141-5', '64993-9', '64995-4', '64996-2',
        '64997-0', '64998-8', '64999-6', '65000-2', '65797-3', '65798-1', '65799-9', '65800-5',
        '65801-3', '67717-9', '69054-5', '69055-2', '69056-0', '69057-8', '69058-6', '69059-4',
        '69060-2', '69061-0', '69062-8', '69063-6', '69064-4', '69065-1', '69066-9', '69067-7',
        '69068-5', '69069-3', '69070-1', '69071-9', '69072-7', '69073-5', '69074-3', '69075-0',
        '69076-8', '69077-6', '69078-4', '69079-2', '69080-0', '69081-8', '69083-4', '69084-2',
        '69087-5', '69088-3', '69089-1', '69090-9', '69091-7', '69092-5', '69093-3', '69094-1',
        '69095-8', '69096-6', '69102-2', '69103-0', '69104-8', '69105-5', '69106-3', '69107-1',
        '69109-7', '69110-5', '69111-3', '69112-1', '69113-9', '69114-7', '69115-4', '69116-2',
        '69117-0', '69118-8', '69119-6', '69120-4', '69121-2', '69122-0', '69123-8', '69124-6',
        '69127-9', '69129-5', '69130-3', '69131-1', '69132-9', '69133-7', '69134-5', '69135-2',
        '69136-0', '69137-8', '69138-6', '69139-4', '69140-2', '69141-0', '69142-8', '69143-6',
        '69144-4', '69145-1', '69146-9', '69147-7', '69148-5', '69149-3', '69150-1', '69151-9',
        '69152-7', '69153-5', '69154-3', '69155-0', '69156-8', '69157-6', '69158-4', '69159-2',
        '69161-8', '69162-6', '69163-4', '69164-2', '69165-9', '69166-7', '69167-5', '69168-3',
        '69169-1', '69170-9', '69171-7', '69172-5', '69173-3', '69174-1', '69175-8', '69176-6',
        '69177-4', '69178-2', '69179-0', '69180-8', '69181-6', '69182-4', '69183-2', '69184-0',
        '69185-7', '69186-5', '69187-3', '69188-1', '69189-9', '69190-7', '69191-5', '69192-3',
        '69193-1', '69194-9', '69195-6', '69196-4', '69197-2', '69198-0', '69199-8', '69200-4',
        '69201-2', '69202-0', '69203-8', '69204-6', '69205-3', '69206-1', '69207-9', '69208-7',
        '69209-5', '69210-3', '69211-1', '69212-9', '69213-7', '69214-5', '69215-2', '69216-0',
        '69217-8', '69218-6', '69219-4', '69220-2', '69221-0', '69222-8', '69223-6', '69226-9',
        '69229-3', '69230-1', '69231-9', '69232-7', '69233-5', '69234-3', '69235-0', '69236-8',
        '69237-6', '69238-4', '69239-2', '69241-8', '69242-6', '69243-4', '69244-2', '69248-3',
        '69249-1', '69250-9', '69251-7', '69252-5', '69253-3', '69254-1', '69255-8', '69256-6',
        '69257-4', '69258-2', '69259-0', '69260-8', '69261-6', '69262-4', '69263-2', '69264-0',
        '69265-7', '69266-5', '69267-3', '69268-1', '69269-9', '69270-7', '69271-5', '69272-3',
        '69273-1', '69274-9', '69275-6', '69276-4', '69277-2', '69278-0', '69279-8', '69280-6',
        '69281-4', '69282-2', '69283-0', '69284-8', '69285-5', '69286-3', '69287-1', '69292-1',
        '69293-9', '69294-7', '69295-4', '69296-2', '69297-0', '69298-8', '69299-6', '69300-2',
        '69301-0', '69302-8', '69303-6', '69304-4', '69305-1', '69306-9', '69307-7', '69308-5',
        '69309-3', '69310-1', '69311-9', '69312-7', '69313-5', '69314-3', '69315-0', '69316-8',
        '69317-6', '69318-4', '69319-2', '69320-0', '69321-8', '69385-3', '69387-9', '69388-7',
        '69389-5', '69390-3', '69391-1', '69392-9', '69393-7', '69394-5', '69395-2', '69396-0',
        '69397-8', '69398-6', '69399-4', '69400-0', '69402-6', '69908-2', '70915-4', '70916-2',
        '70917-0', '70918-8', '70919-6', '70920-4', '70921-2', '70922-0', '70923-8', '70924-6',
        '70925-3', '70926-1', '70927-9', '70931-1', '70932-9', '70933-7', '72137-3', '72138-1',
        '72139-9', '72140-7', '72141-5', '72142-3', '72238-9', '72239-7', '72240-5', '72241-3',
        '72242-1', '72243-9', '72244-7', '72245-4', '72246-2', '72247-0', '72248-8', '72249-6',
        '72250-4', '72251-2', '72252-0', '72253-8', '72254-6', '72256-1', '72528-3', '72529-1',
        '72530-9', '72531-7', '72532-5', '72533-3', '72534-1', '72535-8', '72536-6', '72537-4',
        '72538-2', '72539-0', '72540-8', '72541-6', '72542-4', '72543-2', '72544-0', '72545-7',
        '72546-5', '72547-3', '72548-1', '72549-9', '72550-7', '72551-5', '72552-3', '72553-1',
        '72554-9', '72642-2', '72643-0', '72644-8', '72645-5', '72830-3', '72831-1', '72832-9',
        '72876-6', '75669-2', '75670-0', '75671-8', '75672-6', '75746-8', '75747-6', '75748-4',
        '75749-2', '75750-0', '75751-8', '75752-6', '75816-9', '75817-7', '75818-5', '75853-2',
        '77311-9', '77448-9', '77451-3', '77456-2', '77457-0', '77458-8', '77466-1', '77467-9',
        '77468-7', '77469-5', '77470-3', '77471-1', '77615-3', '78031-2', '78032-0', '78037-9',
        '78038-7', '78973-5', '79065-9', '79066-7', '79067-5', '79068-3', '79069-1', '79071-7',
        '79072-5', '79073-3', '79074-1', '79075-8', '79076-6', '79077-4', '79078-2', '79079-0',
        '79080-8', '79081-6', '79082-4', '79083-2', '79084-0', '79085-7', '79086-5', '79087-3',
        '79088-1', '79089-9', '79090-7', '79091-5', '79092-3', '79093-1', '79094-9', '79095-6',
        '79096-4', '79097-2', '79098-0', '79099-8', '79101-2', '79103-8', '79349-7', '79350-5',
        '79351-3', '79352-1', '79353-9', '79354-7', '79355-4', '79356-2', '79357-0', '79358-8',
        '79359-6', '79360-4', '79361-2', '79362-0', '79363-8', '79364-6', '79365-3', '79366-1',
        '79367-9', '79368-7', '79369-5', '79370-3', '79371-1', '79372-9', '79373-7', '79374-5',
        '80495-5', '80496-3', '80497-1', '80498-9', '80499-7', '80500-2', '80501-0', '80502-8',
        '80503-6', '80504-4', '80505-1', '80506-9', '80507-7', '80508-5', '80509-3', '80510-1',
        '80511-9', '80512-7', '80513-5', '80514-3', '80583-8', '80584-6', '80585-3', '80833-7',
        '80834-5', '80835-2', '80836-0', '80837-8', '80838-6', '80839-4', '80840-2', '80841-0',
        '80842-8', '80843-6', '80844-4', '80846-9', '80847-7', '80848-5', '80850-1', '80851-9',
        '80852-7', '80853-5', '80854-3', '80855-0', '80856-8', '80857-6', '80858-4', '80859-2',
        '80860-0', '80861-8', '80862-6', '80863-4', '80864-2', '80865-9', '80866-7', '80867-5',
        '80868-3', '80869-1', '80870-9', '80871-7', '80872-5', '80873-3', '80874-1', '80875-8',
        '80876-6', '80877-4', '80878-2', '80879-0', '80880-8', '80881-6', '80882-4', '80895-6',
        '80896-4', '80897-2', '80898-0', '80932-7', '80933-5', '80934-3', '80935-0', '80936-8',
        '80937-6', '80938-4', '80939-2', '80940-0', '80941-8', '80942-6', '80943-4', '80944-2',
        '80945-9', '80946-7', '80947-5', '80948-3', '80949-1', '80950-9', '80951-7', '80952-5',
        '80953-3', '80954-1', '80955-8', '80956-6', '80990-5', '80991-3', '81158-8', '81159-6',
        '81160-4', '81161-2', '81162-0', '81163-8', '81164-6', '81165-3', '81206-5', '81542-3',
        '81543-1', '81544-9', '81545-6', '81546-4', '81547-2', '81548-0', '81549-8', '81550-6',
        '81551-4', '81552-2', '81553-0', '81554-8', '81555-5', '81556-3', '81557-1', '81558-9',
        '81559-7', '81560-5', '81561-3', '81562-1', '81563-9', '81564-7', '81565-4', '81566-2',
        '81567-0', '81568-8', '81569-6', '81570-4', '81571-2', '81572-0', '81573-8', '81574-6',
        '81575-3', '81576-1', '81577-9', '81578-7', '81579-5', '81580-3', '81581-1', '81582-9',
        '81583-7', '81584-5', '81585-2', '81586-0', '81587-8', '81588-6', '81589-4', '81590-2',
        '81591-0', '81592-8', '81593-6', '81594-4', '81595-1', '81596-9', '81597-7', '81598-5',
        '81599-3', '81600-9', '81601-7', '81602-5', '81603-3', '81604-1', '81605-8', '81606-6',
        '81607-4', '81608-2', '81609-0', '81610-8', '81611-6', '81612-4', '81613-2', '81894-8',
        '82123-1', '82124-9', '82126-4', '82128-0', '82129-8', '82130-6', '82131-4', '82132-2',
        '82133-0', '82136-3', '82676-8', '82677-6', '82678-4', '82679-2', '82680-0', '82681-8',
        '82682-6', '82683-4', '82684-2', '82685-9', '82686-7', '82687-5', '82688-3', '82689-1',
        '82690-9', '82691-7', '82692-5', '82693-3', '82694-1', '82695-8', '82696-6', '82697-4',
        '82698-2', '82699-0', '82700-6', '82701-4', '82702-2', '82703-0', '82704-8', '82705-5',
        '82706-3', '82707-1', '82708-9', '82709-7', '82710-5', '82711-3', '82712-1', '82713-9',
        '82714-7', '82715-4', '82716-2', '82717-0', '82718-8', '82742-8', '82800-4', '82801-2',
        '82802-0', '82803-8', '82804-6', '82805-3', '82806-1', '82807-9', '82808-7', '82809-5',
        '8294-1', '8295-8', '8296-6', '83012-5', '83013-3', '83014-1', '83015-8', '83016-6',
        '83017-4', '83018-2', '83019-0', '83020-8', '83021-6', '83022-4', '83023-2', '83024-0',
        '83025-7', '83026-5', '83027-3', '83028-1', '83029-9', '83030-7', '83031-5', '83032-3',
        '83033-1', '83034-9', '83035-6', '83036-4', '83037-2', '83038-0', '83039-8', '83040-6',
        '83041-4', '83042-2', '83043-0', '83044-8', '83045-5', '83046-3', '83047-1', '83048-9',
        '83049-7', '83050-5', '83051-3', '83289-9', '83290-7', '83291-5', '83292-3', '83293-1',
        '83294-9', '83295-6', '83296-4', '83297-2', '83298-0', '83299-8', '83300-4', '83301-2',
        '83302-0', '83303-8', '83304-6', '83305-3', '83306-1', '83307-9', '83308-7', '83309-5',
        '83310-3', '85040-4', '85041-2', '85151-9', '85385-3', '85386-1', '85387-9', '85388-7',
        '85389-5', '85390-3', '85391-1', '85392-9', '85393-7', '85394-5', '86348-0', '86350-6',
        '86351-4', '86352-2', '86353-0', '86354-8', '86355-5', '86356-3', '86357-1', '86358-9',
        '86360-5', '86361-3', '86362-1', '86363-9', '86364-7', '86365-4', '86366-2', '86367-0',
        '86368-8', '86369-6', '86370-4', '86371-2', '86372-0', '86373-8', '86374-6', '86375-3',
        '86376-1', '86377-9', '86378-7', '86379-5', '86380-3', '86381-1', '86382-9', '86383-7',
        '86384-5', '86385-2', '86386-0', '86387-8', '86388-6', '86389-4', '86390-2', '86391-0',
        '86392-8', '86393-6', '86394-4', '86395-1', '86396-9', '86397-7', '86398-5', '86399-3',
        '86400-9', '86401-7', '86402-5', '86403-3', '86404-1', '86405-8', '86406-6', '86407-4',
        '86408-2', '86409-0', '86410-8', '86411-6', '86412-4', '86413-2', '86414-0', '86415-7',
        '86416-5', '86417-3', '86418-1', '86419-9', '86420-7', '86421-5', '86422-3', '86423-1',
        '86424-9', '86425-6', '86426-4', '86427-2', '86428-0', '86429-8', '86430-6', '86431-4',
        '86432-2', '86433-0', '86434-8', '86435-5', '86436-3', '86437-1', '86438-9', '86439-7',
        '86440-5', '86441-3', '86442-1', '86443-9', '86460-3', '86461-1', '86462-9', '86463-7',
        '86464-5', '86956-0', '86957-8', '86958-6', '86959-4', '86960-2', '86961-0', '86962-8',
        '86963-6', '86964-4', '86965-1', '86966-9', '86967-7', '86968-5', '86969-3', '86970-1',
        '86971-9', '86972-7', '86973-5', '86974-3', '86975-0', '86976-8', '86977-6', '86978-4',
        '86979-2', '86980-0', '86981-8', '86982-6', '86983-4', '86984-2', '86985-9', '86986-7',
        '86987-5', '86988-3', '86989-1', '86990-9', '86991-7', '86992-5', '86993-3', '86994-1',
        '86995-8', '86996-6', '86997-4', '86998-2', '86999-0', '87000-6', '87001-4', '87002-2',
        '87003-0', '87004-8', '87005-5', '87006-3', '87007-1', '87008-9', '87009-7', '87010-5',
        '87011-3', '87012-1', '87013-9', '87014-7', '87015-4', '87016-2', '87017-0', '87018-8',
        '87019-6', '87020-4', '87021-2', '87022-0', '87023-8', '87024-6', '87025-3', '87026-1',
        '87027-9', '87028-7', '87029-5', '87030-3', '87031-1', '87032-9', '87033-7', '87034-5',
        '87035-2', '87036-0', '87037-8', '87038-6', '87039-4', '87040-2', '87041-0', '87042-8',
        '87043-6', '87044-4', '87045-1', '87046-9', '87047-7', '87048-5', '87049-3', '87050-1',
        '87051-9', '87052-7', '87053-5', '87054-3', '87055-0', '87056-8', '87057-6', '87058-4',
        '87059-2', '87060-0', '87061-8', '87062-6', '87063-4', '87064-2', '87065-9', '87066-7',
        '87067-5', '87068-3', '87069-1', '87070-9', '87071-7', '87072-5', '87073-3', '87074-1',
        '87075-8', '87076-6', '87077-4', '87078-2', '87079-0', '87080-8', '87081-6', '87082-4',
        '87083-2', '87084-0', '87085-7', '87086-5', '87087-3', '87088-1', '87089-9', '87090-7',
        '87091-5', '87092-3', '87093-1', '87094-9', '87095-6', '87096-4', '87097-2', '87098-0',
        '87099-8', '87100-4', '87101-2', '87102-0', '87103-8', '87104-6', '87105-3', '87106-1',
        '87107-9', '87108-7', '87109-5', '87110-3', '87111-1', '87112-9', '87113-7', '87114-5',
        '87115-2', '87116-0', '87117-8', '87118-6', '87119-4', '87120-2', '87121-0', '87122-8',
        '87123-6', '87124-4', '87125-1', '87126-9', '87127-7', '87128-5', '87129-3', '87130-1',
        '87131-9', '87132-7', '87133-5', '87134-3', '87135-0', '87136-8', '87137-6', '87138-4',
        '87139-2', '87140-0', '87141-8', '87142-6', '87143-4', '87144-2', '87145-9', '87146-7',
        '87147-5', '87148-3', '87149-1', '87150-9', '87151-7', '87152-5', '87153-3', '87154-1',
        '87155-8', '87156-6', '87157-4', '87158-2', '87159-0', '87160-8', '87161-6', '87162-4',
        '87163-2', '87164-0', '87165-7', '87166-5', '87167-3', '87168-1', '87169-9', '87170-7',
        '87171-5', '87172-3', '87173-1', '87174-9', '87175-6', '87176-4', '87177-2', '87178-0',
        '87179-8', '87180-6', '87181-4', '87182-2', '87183-0', '87184-8', '87185-5', '87186-3',
        '87187-1', '87188-9', '87189-7', '87190-5', '87191-3', '87192-1', '87193-9', '87194-7',
        '87195-4', '87196-2', '87197-0', '87198-8', '87199-6', '87200-2', '87201-0', '87202-8',
        '87203-6', '87205-1', '87206-9', '87279-6', '87280-4', '87281-2', '87308-3', '87309-1',
        '87310-9', '87311-7', '87312-5', '87836-3', '87837-1', '87838-9', '87839-7', '87840-5',
        '87841-3', '87842-1', '87843-9', '87844-7', '87845-4', '87846-2', '87847-0', '87848-8',
        '87849-6', '87850-4', '87851-2', '87852-0', '87853-8', '87854-6', '87855-3', '87856-1',
        '87857-9', '87858-7', '87859-5', '87860-3', '87861-1', '87862-9', '87863-7', '87864-5',
        '87865-2', '87866-0', '87867-8', '87868-6', '87869-4', '87870-2', '87871-0', '87872-8',
        '87873-6', '87874-4', '87875-1', '87876-9', '87877-7', '87878-5', '87879-3', '87880-1',
        '87881-9', '87882-7', '87883-5', '87884-3', '87885-0', '87886-8', '87887-6', '87888-4',
        '87889-2', '87890-0', '87891-8', '87892-6', '87893-4', '87894-2', '87895-9', '87896-7',
        '87897-5', '87898-3', '87899-1', '87900-7', '87901-5', '87902-3', '87903-1', '87904-9',
        '87905-6', '87906-4', '87907-2', '87908-0', '87909-8', '87910-6', '87911-4', '87912-2',
        '87913-0', '87914-8', '87915-5', '87916-3', '87917-1', '87918-9', '87919-7', '87920-5',
        '87921-3', '87922-1', '88242-3', '88243-1', '88315-7', '88316-5', '88317-3', '88318-1',
        '88319-9', '88320-7', '88321-5', '88322-3', '88323-1', '88324-9', '88325-6', '88326-4',
        '88327-2', '88349-6', '88526-9', '88831-3', '88832-1', '88833-9', '88834-7', '88929-5',
        '88930-3', '88931-1', '88932-9', '88933-7', '88934-5', '88935-2', '88936-0', '88937-8',
        '88938-6', '88939-4', '88940-2', '88941-0', '88942-8', '88943-6', '88944-4', '89283-6',
        '89284-4'
    }


class AntiHypertensivePharmacologicTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent clinical medications prescribed for patients diagnosed with hypertension.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with oral and injectable drug forms that are prescribed for treatment of hypertension.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1476'
    VALUE_SET_NAME = 'Anti-Hypertensive Pharmacologic Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1000001', '1011710', '1011713', '1011736', '1011739', '1011750', '1011753', '1013930',
        '1013937', '104222', '1050798', '1050803', '1050806', '1050809', '1050812', '1091646',
        '1091652', '1092566', '1191185', '1233709', '1234256', '1235144', '1235151', '1297753',
        '1297757', '1299859', '1299871', '1299890', '1299896', '1299897', '152916', '153822',
        '153823', '1665057', '1719286', '1719290', '1729200', '1729205', '1729521', '1729527',
        '1736541', '1736546', '1790239', '1790245', '1791229', '1791232', '1791233', '1791240',
        '1923422', '1923424', '1923426', '197361', '197379', '197380', '197381', '197382',
        '197383', '197417', '197418', '197419', '197436', '197437', '197438', '197439', '197475',
        '197476', '197498', '197499', '197500', '197625', '197626', '197627', '197628', '197730',
        '197731', '197732', '197745', '197746', '197770', '197788', '197815', '197816', '197848',
        '197849', '197884', '197885', '197886', '197887', '197951', '197956', '197958', '197960',
        '197963', '197977', '197978', '197979', '197986', '197987', '198000', '198001', '198006',
        '198007', '198008', '198032', '198033', '198034', '198035', '198036', '198037', '198104',
        '198105', '198110', '198111', '198112', '198141', '198188', '198189', '198222', '198223',
        '198224', '198225', '198284', '198285', '198286', '198312', '198313', '198314', '198316',
        '198369', '198370', '198371', '198372', '199277', '199329', '199351', '199352', '199353',
        '199610', '199622', '199717', '199757', '199776', '199782', '199783', '199797', '199798',
        '199799', '199816', '199817', '199903', '200031', '200032', '200033', '200094', '200095',
        '200096', '200284', '200285', '205304', '205305', '205326', '245283', '245284', '245854',
        '245855', '249851', '260376', '261962', '282486', '282755', '283316', '283317', '308135',
        '308136', '308614', '308962', '308963', '308964', '309198', '310140', '310429', '310792',
        '310793', '310796', '310797', '310798', '310809', '310812', '310818', '311353', '311354',
        '311671', '311984', '311985', '312481', '312482', '312483', '312593', '312594', '312748',
        '312749', '312750', '313096', '313215', '313217', '313219', '313988', '314076', '314077',
        '314132', '314203', '317173', '349199', '349200', '349201', '349353', '349373', '349401',
        '349405', '349483', '351292', '351293', '353386', '353387', '360344', '387013', '402695',
        '402696', '402698', '403853', '403854', '403855', '404011', '404013', '411434', '429503',
        '477130', '484152', '485471', '562518', '562520', '577776', '578325', '578330', '597967',
        '597971', '597974', '597977', '597980', '597984', '597987', '597990', '597993', '636042',
        '636045', '636360', '636361', '639537', '686924', '722126', '722131', '722134', '722137',
        '727574', '727575', '730861', '730866', '730869', '730872', '751612', '751618', '763519',
        '763574', '763589', '790489', '802749', '827073', '830795', '830801', '830837', '830845',
        '830861', '830865', '830869', '830872', '830874', '830877', '830879', '830882', '830897',
        '830900', '831054', '831102', '831103', '831359', '833217', '845488', '848131', '848135',
        '848140', '848145', '848151', '854901', '854905', '854908', '854916', '854919', '854925',
        '854984', '854988', '856422', '856429', '856448', '856457', '856460', '856481', '856519',
        '856535', '856556', '856569', '856578', '856713', '856724', '856733', '857166', '857169',
        '857174', '857183', '857187', '858580', '858587', '858599', '858603', '858607', '858613',
        '858616', '858804', '858810', '858813', '858817', '858824', '858828', '858921', '860510',
        '860516', '860522', '860532', '861402', '862006', '862013', '862019', '862025', '866412',
        '866419', '866427', '866436', '866452', '866461', '866472', '866479', '866482', '866491',
        '866508', '866511', '866514', '866924', '876514', '876519', '876524', '876529', '884173',
        '884185', '884189', '884192', '884198', '884203', '884221', '884225', '892791', '896758',
        '896762', '896766', '896983', '896987', '897584', '897590', '897596', '897612', '897618',
        '897624', '897630', '897640', '897649', '897666', '897683', '897722', '897781', '897783',
        '897844', '897853', '898316', '898342', '898346', '898350', '898353', '898356', '898359',
        '898362', '898367', '898372', '898378', '898687', '898690', '898719', '898723', '901438',
        '904589', '904630', '905199', '905222', '905225', '905353', '905377', '905395', '966571',
        '977880', '977883', '977959', '979432', '979464', '979468', '979471', '979480', '979485',
        '979492', '998675', '998679', '998685', '998689', '998693', '998694', '998695', '999967',
        '999986', '999991', '999996'
    }


class AmitriptylinePerphenazine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent amitriptyline / perphenazine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; amitriptyline / perphenazine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; amitriptyline / perphenazine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1428'
    VALUE_SET_NAME = 'Amitriptyline / Perphenazine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'856706', '856720', '856797', '856825', '856840'}


class FocalChorioretinitisAndFocalRetinochoroiditis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of focal chorioretinitis and/or retinochoroiditis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of focal chorioretinitis, choroiditis, retinochoroiditis and retinitis.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1460'
    VALUE_SET_NAME = 'Focal Chorioretinitis and Focal Retinochoroiditis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H30001', 'H30002', 'H30003', 'H30011', 'H30012', 'H30013', 'H30021', 'H30022', 'H30023',
        'H30031', 'H30032', 'H30033', 'H30041', 'H30042', 'H30043'
    }

    ICD9CM = {'36300', '36301', '36303', '36304', '36305', '36306', '36307', '36308'}

    SNOMEDCT = {
        '15847003', '193434008', '193436005', '193438006', '36535003', '42031001', '44674000',
        '46497009', '56787009', '6313001', '88290000'
    }


class BehavioralneuropsychAssessment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent visits for assessments for neuropsychological assessments.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with applicable neuropsychological assessments for behavioral health.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1023'
    VALUE_SET_NAME = 'Behavioral/Neuropsych Assessment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'96116'}

    SNOMEDCT = {'307808008'}


class CupToDiscRatio(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent studies specific to obtaining cup to disc ratio by ophthalmoscopy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnostic Study.
    Inclusion Criteria: Includes only relevant concepts associated with studies using ophthalmoscopy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1333'
    VALUE_SET_NAME = 'Cup to Disc Ratio'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'71484-0', '71485-7'}


class PrimaryOpenAngleGlaucoma(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of primary open-angle glaucoma (POAG).
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of primary open-angle glaucoma (POAG).
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.326'
    VALUE_SET_NAME = 'Primary Open-Angle Glaucoma'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H4010X0', 'H4010X1', 'H4010X2', 'H4010X3', 'H4010X4', 'H401110', 'H401111', 'H401112',
        'H401113', 'H401114', 'H401120', 'H401121', 'H401122', 'H401123', 'H401124', 'H401130',
        'H401131', 'H401132', 'H401133', 'H401134', 'H401210', 'H401211', 'H401212', 'H401213',
        'H401214', 'H401220', 'H401221', 'H401222', 'H401223', 'H401224', 'H401230', 'H401231',
        'H401232', 'H401233', 'H401234', 'H40151', 'H40152', 'H40153'
    }

    ICD9CM = {'36510', '36511', '36512', '36515'}

    SNOMEDCT = {
        '111513000', '15633281000119103', '15633321000119108', '15640441000119104', '193533000',
        '50485007', '66990007', '77075001', '84494001'
    }


class Trimipramine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent trimipramine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; trimipramine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; trimipramine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1285'
    VALUE_SET_NAME = 'Trimipramine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'313496', '313498', '313499'}


class CornealOpacityAndOtherDisordersOfCornea(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of corneal opacity and other corneal disorders.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of opacity of the cornea, adherent or corneal leukoma, scarring of the cornea, and corneal haze.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1419'
    VALUE_SET_NAME = 'Corneal Opacity and Other Disorders of Cornea'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H1701', 'H1702', 'H1703', 'H1711', 'H1712', 'H1713', 'H1789', 'H179'}

    ICD9CM = {'37100', '37103', '37104'}

    SNOMEDCT = {
        '1099031000119105', '1099041000119101', '1099051000119104', '13282008', '16350000',
        '193795008', '204149000', '22135003', '268160006', '30337003', '314005007',
        '336501000119105', '342111000119101', '347271000119100', '413921009', '419496009',
        '422947009', '424353002', '425961009', '54359000', '55713007', '56530002', '64634000',
        '66104007', '72494008', '95479005', '95726001'
    }


class MumpsAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent test results for presence of mumps IgG antibody.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying positive antibody tests for mumps IgG.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1062'
    VALUE_SET_NAME = 'Mumps Antibody Test (IgG Antibody presence)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'22415-4', '39011-2', '40737-9', '6476-6', '74422-7'}


class MacularScarOfPosteriorPolar(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of macular scar of posterior polar.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes relevant concepts associated with a diagnosis of macular or posterior pole scarring.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1559'
    VALUE_SET_NAME = 'Macular Scar of Posterior Polar'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H31011', 'H31012', 'H31013'}

    ICD9CM = {'36332', '36333'}

    SNOMEDCT = {
        '15631531000119100', '15631571000119102', '15631611000119106', '15710081000119102',
        '15710121000119100', '15710161000119105', '18410006', '21939006', '246181000119100',
        '267611002', '425622004', '737273002'
    }


class AceInhibitorOrArbIngredient(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent angiotensin-converting enzyme (ACE) inhibitor and angiotensin-receptor blocker (ARB) ingredients.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Allergy/Intolerance.
    Inclusion Criteria: Includes only relevant concepts associated with prescribable angiotensin-converting enzyme (ACE) inhibitor and angiotensin-receptor blocker (ARB) ingredients only.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1489'
    VALUE_SET_NAME = 'ACE Inhibitor or ARB Ingredient'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '18867', '1998', '214354', '29046', '30131', '321064', '35208', '35296', '3827', '38454',
        '50166', '52175', '54552', '69749', '73494', '83515', '83818'
    }


class MedicationsEncounterCodeSet(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent multiple types of encounters that include documentation of current medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with identifying types of encounters associated with documentation of medications reviewed, updated or transcribed as the current medication list.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1834'
    VALUE_SET_NAME = 'Medications Encounter Code Set'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '59400', '59510', '59610', '59618', '90791', '90792', '90832', '90834', '90837', '90839',
        '92002', '92004', '92012', '92014', '92507', '92508', '92526', '92537', '92538', '92540',
        '92541', '92542', '92544', '92545', '92547', '92548', '92550', '92557', '92567', '92568',
        '92570', '92585', '92588', '92626', '96116', '96150', '96151', '96152', '97127', '97161',
        '97162', '97163', '97164', '97165', '97166', '97167', '97168', '97802', '97803', '97804',
        '98960', '98961', '98962', '99201', '99202', '99203', '99204', '99205', '99212', '99213',
        '99214', '99215', '99221', '99222', '99223', '99236', '99281', '99282', '99283', '99284',
        '99285', '99304', '99305', '99306', '99307', '99308', '99309', '99310', '99315', '99316',
        '99318', '99324', '99325', '99326', '99327', '99328', '99334', '99335', '99336', '99337',
        '99339', '99340', '99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349',
        '99350', '99385', '99386', '99387', '99395', '99396', '99397', '99495', '99496'
    }

    HCPCS = {'G0101', 'G0108', 'G0270', 'G0402', 'G0438', 'G0439', 'G0515'}

    SNOMEDCT = {
        '10197000', '108220007', '108221006', '108224003', '108311000', '13607009', '14736009',
        '165171009', '18091003', '18512000', '185349003', '185463005', '185465003', '209099002',
        '210098006', '225967005', '252592009', '252624005', '270427003', '270430005', '273643004',
        '274803000', '277404009', '284015009', '308335008', '32537008', '34651001', '35025007',
        '36228007', '370803007', '385973000', '386372009', '390906007', '405096004', '406547006',
        '408983003', '410155007', '410157004', '410158009', '410160006', '410170008', '439708006',
        '439952009', '440524004', '46662001', '48423005', '50357006', '53555003', '54290001',
        '63547008', '66902005', '78318003', '83607001', '8411005', '86013001', '90526000',
        '91573000'
    }


class PneumococcalConjugateVaccineAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedure codes for pneumococcal vaccine administration.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with all pneumococcal vaccine administration codes. This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1046'
    VALUE_SET_NAME = 'Pneumococcal Conjugate Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90670'}

    SNOMEDCT = {'434751000124102'}


class InfluenzaVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent influenza vaccine codes.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with influenza vaccine codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1218'
    VALUE_SET_NAME = 'Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'135', '140', '141', '150', '153', '155', '158', '161', '88'}


class PositiveDepressionScreening(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent situations in which a depression screen was performed by the health care professional and the finding or result was positive for depression.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Assessment.
    Inclusion Criteria: Includes only relevant concepts associated with screening for depression whereby the outcome is positive.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.2450'
    VALUE_SET_NAME = 'Positive Depression Screening'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'428181000124104'}


class GastricBypassSurgery(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent codes that can be used to identify patients who have undergone a partial or total removal of the stomach by either a laparoscopic or open method.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying procedures for repair or removal of digestive system organs that includes a partial or total removal of the stomach. This is a grouping of CT and SNOMED CT codes.
    Exclusion Criteria: Excludes endoscopic excision of tissue of stomach, excision/laparoscopic wedge resection of lesion of stomach and incisional biopsy of stomach.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1050'
    VALUE_SET_NAME = 'Gastric Bypass Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '43117', '43118', '43121', '43122', '43123', '43620', '43621', '43622', '43631', '43632',
        '43633', '43634', '43775', '43845', '48150', '48152'
    }

    SNOMEDCT = {
        '10002003', '10869008', '112860004', '116175006', '173560002', '173714001', '173715000',
        '173716004', '173720000', '173722008', '173794002', '21538007', '235165007', '235214008',
        '235215009', '235216005', '235217001', '235218006', '235219003', '24431004', '24506003',
        '24883002', '26452005', '265340005', '265459006', '26565004', '275007007', '275162000',
        '275194005', '287809004', '287816003', '287818002', '287819005', '287821000', '307303006',
        '307304000', '359575000', '359579006', '40234006', '427074001', '427980007', '430715008',
        '43344006', '438338008', '439878001', '445831005', '445983004', '446650001', '46936007',
        '49209004', '53442002', '68342003', '73206007', '83371007', '83857006', '83985009',
        '85217002', '87604009', '90063003', '90410003', '9102008', '91621005'
    }


class Hyperparathyroidism(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of hyperparathyroidism.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes associated with hyperparathyroidism, including primary, secondary, tertiary, and all other types of hyperparathyroidism. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes diagnoses of autonomous thyroid function, Iatrogenic thyrotoxicosis factitia, neonatal thyrotoxicosis and thyrotoxic crisis.
    """

    OID = '2.16.840.1.113883.3.464.1003.117.12.1016'
    VALUE_SET_NAME = 'Hyperparathyroidism'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'E210', 'E211', 'E212', 'E213'}

    ICD9CM = {'25200', '25201', '25202', '25208'}

    SNOMEDCT = {
        '19034001', '237653008', '361128007', '36348003', '363627009', '47445009', '66999008',
        '78200003', '78625002', '9092004', '91478007'
    }


class OncAdministrativeSex(ValueSet):
    """

    Clinical Focus: Gender identity restricted to only Male and Female used in administrative situations requiring a restriction to these two categories.
    Data Element Scope: Gender
    Inclusion Criteria: Male and Female only.
    Exclusion Criteria: Any gender identity that is not male or female.
    """

    OID = '2.16.840.1.113762.1.4.1'
    VALUE_SET_NAME = 'ONC Administrative Sex'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ADMINISTRATIVEGENDER = {'F', 'M'}


class VenousFootPumpsVfp(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a venous foot pump device applied for venous thromboembolism (VTE) prophylaxis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Device. The intent of this data element is to identify patients who have a venous foot pump device applied for VTE prophylaxis.
    Inclusion Criteria: Includes only relevant concepts associated with codes which represent venous foot pump devices which are used for VTE prophylaxis.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.230'
    VALUE_SET_NAME = 'Venous foot pumps (VFP)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'442023007'}


class SingleLiveBornNewbornBornInHospital(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent types of delivery that represent the single live birth.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying single live born newborn.
    Exclusion Criteria: Excludes codes indicating the birth took place outside of the hospital.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.26'
    VALUE_SET_NAME = 'Single Live Born Newborn Born in Hospital'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z3800', 'Z3801'}

    SNOMEDCT = {'17561000119102', '442423001', '717803002'}


class DischargedToHomeForHospiceCare(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures used to represent the discharge of a patient to home for hospice care.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Discharge Disposition. The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular inpatient encounter. This particular value set intends to identify patients who were discharged to home for hospice care.
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT codes representing discharge to home for hospice care.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.209'
    VALUE_SET_NAME = 'Discharged to Home for Hospice Care'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'428361000124107'}


class IntravenousOrIntraArterialThrombolyticTPaTherapy(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent intravenous or intra-arterial thrombolytic (t-PA) therapy procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify intravenous or intra-arterial thrombolytic (t-PA) therapy procedures.
    Inclusion Criteria: Includes only relevant concepts associated with identifying intravenous or intra-arterial thrombolytic (t-PA) therapy procedures.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1045.21'
    VALUE_SET_NAME = 'Intravenous or Intra-arterial Thrombolytic (t-PA) Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'307521008', '69245005'}


class OfficeVisit(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have had an office or other outpatient visit.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity. This is a grouping value set of CPT codes.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1001'
    VALUE_SET_NAME = 'Office Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215'}

    SNOMEDCT = {
        '185463005', '185464004', '185465003', '30346009', '3391000175108', '37894004', '439740005'
    }


class HereditaryChoroidalDystrophies(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of hereditary choroidal dystrophies.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of hereditary choroidal dystrophies, including choroideremia and atrophy.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1462'
    VALUE_SET_NAME = 'Hereditary Choroidal Dystrophies'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H3120', 'H3121', 'H3122', 'H3123', 'H3129'}

    ICD9CM = {'36350', '36351', '36352', '36353', '36354', '36355', '36356', '36357'}

    SNOMEDCT = {
        '193466003', '19871000', '231996009', '231997000', '247200005', '24950005', '312918002',
        '41250005', '59753003', '715417002', '715984007', '717761005', '720850008', '733110004',
        '74469006', '75241009', '92820007'
    }


class ModerateOrSevere(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent severe and moderate levels of severity.
    Data Element Scope: This value set may use Quality Data Model (QDM) attribute related to Severity.
    Inclusion Criteria: Includes only relevant concepts associated with specific to severe and moderate levels of severity.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1092'
    VALUE_SET_NAME = 'Moderate or Severe'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'24484000', '6736007'}


class Height(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a patient's height has been measured or observed.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Physical Exam, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying if a patient's height has been measured or observed. This is a grouping of LOINC codes.
    Exclusion Criteria: Excludes codes that are expressed as a percentile, stated by a patient, post-partum or estimated.
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1014'
    VALUE_SET_NAME = 'Height'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'3137-7', '8302-2', '8306-3', '8307-1', '8308-9'}


class OtherProliferativeRetinopathy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of other proliferative retinopathy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of premature retinopathy.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1480'
    VALUE_SET_NAME = 'Other Proliferative Retinopathy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H35101', 'H35102', 'H35103', 'H35111', 'H35112', 'H35113', 'H35121', 'H35122', 'H35123',
        'H35131', 'H35132', 'H35133', 'H35141', 'H35142', 'H35143', 'H35151', 'H35152', 'H35153',
        'H35161', 'H35162', 'H35163', 'H35171', 'H35172', 'H35173'
    }

    ICD9CM = {'36220', '36221', '36222', '36223', '36224', '36225', '36226', '36227'}

    SNOMEDCT = {'408847006', '408848001', '408849009', '408850009', '408851008', '415297005'}


class BrompheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent brompheniramine / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; brompheniramine / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; brompheniramine / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1332'
    VALUE_SET_NAME = 'Brompheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1098498', '1192477'}


class AcetaminophenChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / chlorpheniramine / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / chlorpheniramine / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / chlorpheniramine / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1328'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1046781', '1046799', '1052679', '1101555', '1193293', '1244951', '1313969', '1366653',
        '1372312', '1536931'
    }


class Chlorpropamide(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorpropamide medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorpropamide only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorpropamide in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1303'
    VALUE_SET_NAME = 'Chlorpropamide'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197495', '197496'}


class ProstateSpecificAntigenTest(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent prostate specific antigen (PSA) test.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Laboratory Test.
    Inclusion Criteria: Includes only relevant concepts associated with prostate specific antigen (PSA) tests.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.401'
    VALUE_SET_NAME = 'Prostate Specific Antigen Test'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '10508-0', '10886-0', '12841-3', '15323-9', '15324-7', '15325-4', '19195-7', '19201-3',
        '2857-1', '33667-7', '34611-4', '35741-8'
    }


class MeaslesAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent test results related to IgG antibodies and measles. A positive test conveys immunologic protection against measles.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying positive antibody tests for measles IgG In the serum, cerebrospinal fluid or body fluid.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1060'
    VALUE_SET_NAME = 'Measles Antibody Test (IgG Antibody presence)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'20479-2', '35275-7', '40648-8', '41132-2', '53536-9'}


class ReferralForDepressionAdolescent(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent appropriate referrals specific to the child and adolescent age group for depression management.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with appropriate referrals as specific to the child and adolescent age group for depression management.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.537'
    VALUE_SET_NAME = 'Referral for Depression Adolescent'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '183524004', '183583007', '183851006', '183866009', '305922005', '306136006', '306137002',
        '306226009', '306227000', '306252003', '306291008', '306294000', '308459004', '308477009',
        '309627007', '390866009', '401174001', '429387009', '61801003', '703978000', '710914003',
        '711281004'
    }


class Hyperthyroidism(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of hyperthyroidism.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with all diagnosis codes for thyrotoxicosis, both with and without thyrotoxic crisis or storm, and with and without presence of goiter. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes diagnosis codes for neonatal thyrotoxicosis.
    """

    OID = '2.16.840.1.113883.3.464.1003.117.12.1015'
    VALUE_SET_NAME = 'Hyperthyroidism'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'E0500', 'E0501', 'E0510', 'E0511', 'E0520', 'E0521', 'E0530', 'E0531', 'E0540', 'E0541',
        'E0580', 'E0581', 'E0590', 'E0591'
    }

    ICD9CM = {
        '24200', '24201', '24210', '24211', '24220', '24221', '24230', '24231', '24240', '24241',
        '24280', '24281', '24290', '24291'
    }

    SNOMEDCT = {
        '190255006', '190256007', '193214009', '22350004', '237499004', '237501007', '237503005',
        '237505003', '237506002', '237507006', '237508001', '237509009', '237510004', '237512007',
        '237538007', '25008002', '26389007', '267374005', '27538003', '286909009', '360353005',
        '360358001', '360361000', '431588009', '4997005', '62052002', '68437005', '73869005',
        '87232008', '88740003', '89719007', '90739004'
    }


class DiphenhydramineIbuprofen(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diphenhydramine / ibuprofen combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; diphenhydramine / ibuprofen (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; diphenhydramine / ibuprofen in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1293'
    VALUE_SET_NAME = 'Diphenhydramine / Ibuprofen'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'895664', '901814'}


class DextromethorphanDoxylamine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dextromethorphan / doxylamine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dextromethorphan / doxylamine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dextromethorphan / doxylamine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1452'
    VALUE_SET_NAME = 'Dextromethorphan / Doxylamine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1234386'}


class OtherBackgroundRetinopathyAndRetinalVascularChanges(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of other background retinopathy and retinal vascular changes.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of various retinal changes and retinopathies, including exudative retinopathy, retinal neovascularization, arteriolitis, arteritis, endarteritis, phlebitis, and vasculitis.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1469'
    VALUE_SET_NAME = 'Other Background Retinopathy and Retinal Vascular Changes'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H35021', 'H35022', 'H35023', 'H35051', 'H35052', 'H35053', 'H35061', 'H35062', 'H35063'
    }

    ICD9CM = {'36212', '36216', '36218'}

    SNOMEDCT = {
        '11255009', '247099009', '247100001', '25506007', '314265001', '414297000', '416703007',
        '417019000', '417303004', '417544004', '54122009', '61267008', '677651000119102',
        '677681000119109', '7089008', '71719003', '75971007', '77628002', '86191000'
    }


class ChoroidalHemorrhageAndRupture(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of choroidal hemorrhage and/or rupture.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with choroidal hemorrhage and rupture.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1452'
    VALUE_SET_NAME = 'Choroidal Hemorrhage and Rupture'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H31301', 'H31302', 'H31303', 'H31311', 'H31312', 'H31313', 'H31321', 'H31322', 'H31323'
    }

    ICD9CM = {'36361', '36362', '36363'}

    SNOMEDCT = {'11623000', '122003', '193474002', '2532009', '419596007'}


class ChoroidalDegenerations(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of choroidal degenerations.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of degenerations of the choroid, including choroid atrophy and dystrophy, angioid streaks, and choroideremia.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1450'
    VALUE_SET_NAME = 'Choroidal Degenerations'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H3533'}

    ICD9CM = {'36343'}

    SNOMEDCT = {
        '193463006', '193466003', '19871000', '231996009', '231997000', '24950005', '312927001',
        '38513001', '406446000', '41250005', '59753003', '74469006', '75241009', '86103006',
        '92820007'
    }


class UnilateralMastectomyUnspecifiedLaterality(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a unilateral mastectomy where the side was not specified.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a unilateral mastectomy performed, but the side was not specified. This is a grouping of SNOMED CT and ICD-10-CM codes.
    Exclusion Criteria: Excludes codes that indicate a bilateral mastectomy or a unilateral mastectomy where the side is specified.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1071'
    VALUE_SET_NAME = 'Unilateral Mastectomy, Unspecified Laterality'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z9010'}

    ICD9CM = {'V4571'}

    SNOMEDCT = {'22964006', '248802009', '72269009', '73359007', '8115005', '88764002'}


class Breastfeeding(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent active breastfeeding.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with lactation and the actual finding or intention of breastfeeding or nursing.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1047.73'
    VALUE_SET_NAME = 'Breastfeeding'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'O9103', 'O9113', 'O9123', 'O9203', 'O9213', 'O925', 'O9270', 'O9279', 'Z391'}

    SNOMEDCT = {
        '169643005', '169745008', '169750002', '199004', '200416006', '200418007', '200419004',
        '200420005', '200430001', '225604004', '247415009', '289084000', '290122005', '290124006',
        '290126008', '58219009', '69840006', '82374005'
    }


class EncephalopathyDueToChildhoodVaccination(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of encephalopathy due to childhood vaccination.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with encephalopathy (a brain injury) due to childhood vaccination.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.114.12.1007'
    VALUE_SET_NAME = 'Encephalopathy due to Childhood Vaccination'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'G0432'}

    SNOMEDCT = {
        '192704009', '192705005', '192706006', '192707002', '192708007', '192709004', '192710009',
        '192711008', '192712001', '192713006', '192714000', '192715004', '192716003', '192717007',
        '192718002', '192719005', '192720004', '192721000', '192722007', '192723002', '192724008'
    }


class FecalOccultBloodTestFobt(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a fecal occult blood test.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying tests for occult blood in stool. This is a grouping of LOINC codes.
    Exclusion Criteria: Excludes tests for occult blood in other parts of the body. Excludes codes that indicate that this test was ordered only, and not necessarily performed.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1011'
    VALUE_SET_NAME = 'Fecal Occult Blood Test (FOBT)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '12503-9', '12504-7', '14563-1', '14564-9', '14565-6', '2335-8', '27396-1', '27401-9',
        '27925-7', '27926-5', '29771-3', '56490-6', '56491-4', '57905-2', '58453-2', '80372-6'
    }


class MalignantNeoplasmOfColon(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent malignant neoplasms of the colon.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with indicating malignant neoplasms of the colon, rectum and anus. This is a grouping of ICD-10-CM, ICD-9-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1001'
    VALUE_SET_NAME = 'Malignant Neoplasm of Colon'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'C180', 'C181', 'C182', 'C183', 'C184', 'C185', 'C186', 'C187', 'C188', 'C189', 'C19',
        'C20', 'C212', 'C218', 'C785'
    }

    ICD9CM = {
        '1530', '1531', '1532', '1533', '1534', '1535', '1536', '1537', '1538', '1539', '1540',
        '1541', '1975'
    }

    SNOMEDCT = {
        '109838007', '130381000119103', '133751000119102', '1701000119104', '184881000119106',
        '187757001', '187758006', '269533000', '269544008', '285312008', '285611007', '301756000',
        '312111009', '312112002', '312113007', '312114001', '312115000', '314965007', '315058005',
        '363406005', '363407001', '363408006', '363409003', '363410008', '363412000', '363413005',
        '363414004', '363510005', '425178004', '449218003', '681601000119101', '716654007',
        '721695008', '721696009', '721699002', '737058005', '766981007', '93761005', '93771007',
        '93826009', '93980002', '94006002', '94072004', '94105000', '94179005', '94260004',
        '94271003', '94328005', '94509004', '94538001', '94604000', '94643001', '96281000119107',
        '96981000119102'
    }


class Isotretinoin(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent isotretinoin medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; isotretinoin only. This is a grouping of RxNorm codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1143'
    VALUE_SET_NAME = 'Isotretinoin'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1547561', '1547565', '197843', '197844', '197845', '403930'}


class TraumaticCataract(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of traumatic cataract.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of traumatic cataract, including concussion cataract.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1443'
    VALUE_SET_NAME = 'Traumatic Cataract'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H26101', 'H26102', 'H26103', 'H26111', 'H26112', 'H26113', 'H26121', 'H26122', 'H26123',
        'H26131', 'H26132', 'H26133'
    }

    ICD9CM = {'36620', '36621', '36622', '36623'}

    SNOMEDCT = {'193598007', '231967008', '231968003', '34361001', '8656007'}


class NystagmusAndOtherIrregularEyeMovements(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of nystagmus and other irregular eye movements.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of nystagmus.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1465'
    VALUE_SET_NAME = 'Nystagmus and Other Irregular Eye Movements'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H5500', 'H5501', 'H5502', 'H5503', 'H5504', 'H5509', 'H5581', 'H5589'}

    ICD9CM = {
        '37950', '37951', '37952', '37953', '37954', '37955', '37956', '37957', '37958', '37959'
    }

    SNOMEDCT = {
        '111533001', '232124002', '246761002', '246762009', '278468008', '278469000', '285765003',
        '29356006', '307670000', '307671001', '307672008', '307673003', '307674009', '307675005',
        '307676006', '307677002', '307678007', '307679004', '307680001', '307700006', '314935002',
        '3327002', '35743001', '359687001', '373590007', '39737009', '400948003', '400949006',
        '404676002', '404677006', '40782004', '414489005', '418472007', '431951000124101',
        '44526006', '45339001', '46888001', '563001', '64635004', '68610001', '6881000119109',
        '733334001', '733335000', '762438000', '762439008', '8134005', '81756001', '83655001',
        '9074007', '9520006', '95777008', '95778003', '95779006', '95780009', '95781008',
        '95782001', '95783006', '95784000', '95785004', '95786003', '95787007', '95788002',
        '95790001'
    }


class PrimaryThaProcedure(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent primary Total Hip Arthroplasty (THA) procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with codes that identify primary THA procedures. This is a grouping of CPT, HCPCS and SNOMED CT codes.
    Exclusion Criteria: Excludes codes for revision or partial hip arthroplasty procedures.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1006'
    VALUE_SET_NAME = 'Primary THA Procedure'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'27130'}

    HCPCS = {'S2118'}

    SNOMEDCT = {
        '15163009', '179294005', '179304004', '179305003', '19954002', '265157000', '265158005',
        '265160007', '314489006', '314491003', '33788003', '425443008', '426618001', '426904006',
        '427728006', '429156003', '443435007', '450813004', '52734007', '53081006', '57589001',
        '76915002'
    }


class HysterectomyWithNoResidualCervix(ValueSet):
    """

    Clinical Focus: This value set contains concepts that identify hysterectomy procedures that include removal of the patient's cervix.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with total or radical hysterectomies. This is a grouping of CPT, SNOMED CT, ICD-10-PCS and ICD-9-CM codes.
    Exclusion Criteria: Excludes partial hysterectomies and hysterectomies that leave the patient's cervix intact.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1014'
    VALUE_SET_NAME = 'Hysterectomy with No Residual Cervix'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '51925', '56308', '57540', '57545', '57550', '57555', '57556', '58150', '58152', '58200',
        '58210', '58240', '58260', '58262', '58263', '58267', '58270', '58275', '58280', '58285',
        '58290', '58291', '58292', '58293', '58294', '58548', '58550', '58552', '58553', '58554',
        '58570', '58571', '58572', '58573', '58575', '58951', '58953', '58954', '58956', '59135'
    }

    ICD10PCS = {
        '0UT90ZZ', '0UT94ZL', '0UT94ZZ', '0UT97ZL', '0UT97ZZ', '0UT98ZL', '0UT98ZZ', '0UT9FZL',
        '0UT9FZZ', '0UTC0ZZ', '0UTC4ZZ', '0UTC7ZZ', '0UTC8ZZ'
    }

    ICD9CM = {
        '6185', '6841', '6849', '6851', '6859', '6861', '6869', '6871', '6879', '688', '75243',
        'V8801', 'V8803'
    }

    SNOMEDCT = {
        '116140006', '116142003', '116143008', '116144002', '176697007', '236888001', '236891001',
        '24293001', '27950001', '28301000', '287924009', '307771009', '31545000', '35955002',
        '361222003', '361223008', '387626007', '414575003', '41566006', '440383008', '446446002',
        '446679008', '46226009', '59750000', '708877008', '708878003', '739671004', '739672006',
        '739673001', '739674007', '740514001', '740515000', '767610009', '767611008', '767612001',
        '82418001', '86477000', '88144003'
    }


class HighIntensityStatinTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent high intensity statin medications as defined by the 2013 American College of Cardiology (ACC) and the American Heart Association (AHA) guideline.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with high intensity statin therapy medications.
    Exclusion Criteria: Excludes any other intensity of statin therapy.
    """

    OID = '2.16.840.1.113762.1.4.1047.97'
    VALUE_SET_NAME = 'High intensity statin therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '259255', '404011', '404013', '476351', '597984', '597990', '597993', '617311', '757705',
        '859419', '859751'
    }


class ExcisionOfAdhesions(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures of excision of adhesions.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with procedures of severing or lysis of adhesions of the anterior segment of the eye.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1422'
    VALUE_SET_NAME = 'Excision of Adhesions'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'65860', '65880'}

    SNOMEDCT = {'438601000', '76240002'}


class ReferralForDepressionAdult(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent appropriate referrals specific to the adult age group for depression management.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with appropriate referrals as specific to the adult age group for depression management.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.538'
    VALUE_SET_NAME = 'Referral for Depression Adult'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '103696004', '14129001', '183524004', '183528001', '183583007', '183866009', '305922005',
        '306136006', '306137002', '306138007', '306204008', '306226009', '306227000', '306252003',
        '306294000', '308459004', '308477009', '390866009', '401174001', '429387009', '61801003',
        '703978000', '710914003', '711281004'
    }


class FallsScreening(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent assessment tools or instruments used to quantify fall risk.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Assessment, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with fall risk assessment tools and screening assessments used to evaluate fall risk such as the Get Up and Go Test, Morse falls risk assessment, multidisciplinary team falls assessment, and history of falls. This is a grouping of LOINC and SNOMED CT codes.
    Exclusion Criteria: Excludes codes that indicate falls for children or falls that take place in an inpatient setting.
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1028'
    VALUE_SET_NAME = 'Falls Screening'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'52552-7', '57254-5', '59454-9', '73830-2'}


class IntoleranceToInfluenzaVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of intolerance to influenza vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of intolerance to influenza vaccines.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1257'
    VALUE_SET_NAME = 'Intolerance to Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'293112000', '293113005', '390796006', '420113004'}


class CarrierOfPredominantlySexuallyTransmittedInfection(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent exposure to infections that are primarily transmitted through sexual contact.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with potential exposure to infection with a predominantly sexual mode of transmission.
    Exclusion Criteria: Excludes codes for specific sexually transmitted infections.
    """

    OID = '2.16.840.1.113883.3.464.1003.112.11.1023'
    VALUE_SET_NAME = 'Carrier of Predominantly Sexually Transmitted Infection'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z202', 'Z224'}


class Meprobamate(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent meprobamate medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; meprobamate only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; meprobamate in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1284'
    VALUE_SET_NAME = 'Meprobamate'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197928', '197929'}


class Clomipramine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent clomipramine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; clomipramine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; clomipramine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1336'
    VALUE_SET_NAME = 'Clomipramine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'857297', '857301', '857305'}


class RetinalOrDilatedEyeExam(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have received a retinal or dilated eye exam.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Physical Exam, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with procedural codes that indicate a retinal and dilated eye exam took place.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.115.12.1088'
    VALUE_SET_NAME = 'Retinal or Dilated Eye Exam'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '252779009', '252780007', '252781006', '252782004', '252783009', '252784003', '252788000',
        '252789008', '252790004', '274795007', '274798009', '308110009', '314971001', '314972008',
        '410451008', '410452001', '410453006', '410455004', '420213007', '425816006', '427478009',
        '6615001', '722161008'
    }


class OralFactorXaInhibitorForVteProphylaxisOrVteTreatment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent oral factor Xa inhibitors indicated for venous thromboembolism (VTE) prophylaxis and treatment.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who receive oral factor Xa inhibitors for VTE prophylaxis.
    Inclusion Criteria: Includes only relevant concepts associated with oral forms of factor Xa inhibitors.
    Exclusion Criteria: Excludes other dose forms of factor Xa inhibitors.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.134'
    VALUE_SET_NAME = 'Oral Factor Xa Inhibitor for VTE Prophylaxis or VTE Treatment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1114198', '1232082', '1232086', '1364435', '1364445', '1549682', '1599543', '1599551',
        '1599555', '1927856', '1927864', '1992427', '2059015'
    }


class StatinAllergen(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent an allergy to statin medications.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Allergy/Intolerance.
    Inclusion Criteria: Includes only relevant concepts associated with statins and statin allergens. This is a grouping value set of RXNORM and SNOMED codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1110.42'
    VALUE_SET_NAME = 'Statin Allergen'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'301542', '36567', '41127', '42463', '6472', '83367', '861634'}

    SNOMEDCT = {'372912004'}


class LowMolecularWeightHeparinForVteProphylaxis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent low molecular weight heparin medications used for Venous Thromboembolism (VTE) prophylaxis. The medications included in this value set are administered parenterally.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who are on low molecular weight heparin therapy as VTE prophylaxis.
    Inclusion Criteria: Includes only relevant concepts associated with RxNorm codes that specifically represent low molecular weight heparins that are administered parenterally.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.219'
    VALUE_SET_NAME = 'Low Molecular Weight Heparin for VTE Prophylaxis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '854228', '854235', '854238', '854241', '854245', '854248', '854252', '854255', '978713',
        '978725', '978733', '978736', '978740', '978744', '978746', '978755', '978759', '978777'
    }


class Obstetrics(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent a condition, problem, or diagnosis related to pregnancy or obstetrics.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis. The intent of this data element is to identify patients who have a condition, problem or diagnosis related to pregnancy or obstetrics.
    Inclusion Criteria: Includes only relevant concepts associated with a condition, problem or diagnosis related to pregnancy or obstetrics.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.263'
    VALUE_SET_NAME = 'Obstetrics'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'O0000', 'O0001', 'O00101', 'O00102', 'O00109', 'O00111', 'O00112', 'O00119', 'O00201',
        'O00202', 'O00209', 'O00211', 'O00212', 'O00219', 'O0080', 'O0081', 'O0090', 'O0091',
        'O010', 'O011', 'O019', 'O020', 'O021', 'O0281', 'O0289', 'O029', 'O030', 'O031', 'O032',
        'O0330', 'O0331', 'O0332', 'O0333', 'O0334', 'O0335', 'O0336', 'O0337', 'O0338', 'O0339',
        'O034', 'O035', 'O036', 'O037', 'O0380', 'O0381', 'O0382', 'O0383', 'O0384', 'O0385',
        'O0386', 'O0387', 'O0388', 'O0389', 'O039', 'O045', 'O046', 'O047', 'O0480', 'O0481',
        'O0482', 'O0483', 'O0484', 'O0485', 'O0486', 'O0487', 'O0488', 'O0489', 'O070', 'O071',
        'O072', 'O0730', 'O0731', 'O0732', 'O0733', 'O0734', 'O0735', 'O0736', 'O0737', 'O0738',
        'O0739', 'O074', 'O080', 'O081', 'O082', 'O083', 'O084', 'O085', 'O086', 'O087', 'O0881',
        'O0882', 'O0883', 'O0889', 'O089', 'O0900', 'O0901', 'O0902', 'O0903', 'O0910', 'O0911',
        'O0912', 'O0913', 'O09211', 'O09212', 'O09213', 'O09219', 'O09291', 'O09292', 'O09293',
        'O09299', 'O0930', 'O0931', 'O0932', 'O0933', 'O0940', 'O0941', 'O0942', 'O0943', 'O09511',
        'O09512', 'O09513', 'O09519', 'O09521', 'O09522', 'O09523', 'O09529', 'O09611', 'O09612',
        'O09613', 'O09619', 'O09621', 'O09622', 'O09623', 'O09629', 'O0970', 'O0971', 'O0972',
        'O0973', 'O09811', 'O09812', 'O09813', 'O09819', 'O09821', 'O09822', 'O09823', 'O09829',
        'O09891', 'O09892', 'O09893', 'O09899', 'O0990', 'O0991', 'O0992', 'O0993', 'O09A0',
        'O09A1', 'O09A2', 'O09A3', 'O10011', 'O10012', 'O10013', 'O10019', 'O1002', 'O1003',
        'O10111', 'O10112', 'O10113', 'O10119', 'O1012', 'O1013', 'O10211', 'O10212', 'O10213',
        'O10219', 'O1022', 'O1023', 'O10311', 'O10312', 'O10313', 'O10319', 'O1032', 'O1033',
        'O10411', 'O10412', 'O10413', 'O10419', 'O1042', 'O1043', 'O10911', 'O10912', 'O10913',
        'O10919', 'O1092', 'O1093', 'O111', 'O112', 'O113', 'O114', 'O115', 'O119', 'O1200',
        'O1201', 'O1202', 'O1203', 'O1204', 'O1205', 'O1210', 'O1211', 'O1212', 'O1213', 'O1214',
        'O1215', 'O1220', 'O1221', 'O1222', 'O1223', 'O1224', 'O1225', 'O131', 'O132', 'O133',
        'O134', 'O135', 'O139', 'O1400', 'O1402', 'O1403', 'O1404', 'O1405', 'O1410', 'O1412',
        'O1413', 'O1414', 'O1415', 'O1420', 'O1422', 'O1423', 'O1424', 'O1425', 'O1490', 'O1492',
        'O1493', 'O1494', 'O1495', 'O1500', 'O1502', 'O1503', 'O151', 'O152', 'O159', 'O161',
        'O162', 'O163', 'O164', 'O165', 'O169', 'O200', 'O208', 'O209', 'O210', 'O211', 'O212',
        'O218', 'O219', 'O2200', 'O2201', 'O2202', 'O2203', 'O2210', 'O2211', 'O2212', 'O2213',
        'O2220', 'O2221', 'O2222', 'O2223', 'O2230', 'O2231', 'O2232', 'O2233', 'O2240', 'O2241',
        'O2242', 'O2243', 'O2250', 'O2251', 'O2252', 'O2253', 'O228X1', 'O228X2', 'O228X3',
        'O228X9', 'O2290', 'O2291', 'O2292', 'O2293', 'O2300', 'O2301', 'O2302', 'O2303', 'O2310',
        'O2311', 'O2312', 'O2313', 'O2320', 'O2321', 'O2322', 'O2323', 'O2330', 'O2331', 'O2332',
        'O2333', 'O2340', 'O2341', 'O2342', 'O2343', 'O23511', 'O23512', 'O23513', 'O23519',
        'O23521', 'O23522', 'O23523', 'O23529', 'O23591', 'O23592', 'O23593', 'O23599', 'O2390',
        'O2391', 'O2392', 'O2393', 'O24011', 'O24012', 'O24013', 'O24019', 'O2402', 'O2403',
        'O24111', 'O24112', 'O24113', 'O24119', 'O2412', 'O2413', 'O24311', 'O24312', 'O24313',
        'O24319', 'O2432', 'O2433', 'O24410', 'O24414', 'O24415', 'O24419', 'O24420', 'O24424',
        'O24425', 'O24429', 'O24430', 'O24434', 'O24435', 'O24439', 'O24811', 'O24812', 'O24813',
        'O24819', 'O2482', 'O2483', 'O24911', 'O24912', 'O24913', 'O24919', 'O2492', 'O2493',
        'O2510', 'O2511', 'O2512', 'O2513', 'O252', 'O253', 'O2600', 'O2601', 'O2602', 'O2603',
        'O2610', 'O2611', 'O2612', 'O2613', 'O2620', 'O2621', 'O2622', 'O2623', 'O2630', 'O2631',
        'O2632', 'O2633', 'O2640', 'O2641', 'O2642', 'O2643', 'O2650', 'O2651', 'O2652', 'O2653',
        'O26611', 'O26612', 'O26613', 'O26619', 'O2662', 'O2663', 'O26711', 'O26712', 'O26713',
        'O26719', 'O2672', 'O2673', 'O26811', 'O26812', 'O26813', 'O26819', 'O26821', 'O26822',
        'O26823', 'O26829', 'O26831', 'O26832', 'O26833', 'O26839', 'O26841', 'O26842', 'O26843',
        'O26849', 'O26851', 'O26852', 'O26853', 'O26859', 'O2686', 'O26872', 'O26873', 'O26879',
        'O26891', 'O26892', 'O26893', 'O26899', 'O2690', 'O2691', 'O2692', 'O2693', 'O280', 'O281',
        'O282', 'O283', 'O284', 'O285', 'O288', 'O289', 'O29011', 'O29012', 'O29013', 'O29019',
        'O29021', 'O29022', 'O29023', 'O29029', 'O29091', 'O29092', 'O29093', 'O29099', 'O29111',
        'O29112', 'O29113', 'O29119', 'O29121', 'O29122', 'O29123', 'O29129', 'O29191', 'O29192',
        'O29193', 'O29199', 'O29211', 'O29212', 'O29213', 'O29219', 'O29291', 'O29292', 'O29293',
        'O29299', 'O293X1', 'O293X2', 'O293X3', 'O293X9', 'O2940', 'O2941', 'O2942', 'O2943',
        'O295X1', 'O295X2', 'O295X3', 'O295X9', 'O2960', 'O2961', 'O2962', 'O2963', 'O298X1',
        'O298X2', 'O298X3', 'O298X9', 'O2990', 'O2991', 'O2992', 'O2993', 'O30001', 'O30002',
        'O30003', 'O30009', 'O30011', 'O30012', 'O30013', 'O30019', 'O30021', 'O30022', 'O30023',
        'O30029', 'O30031', 'O30032', 'O30033', 'O30039', 'O30041', 'O30042', 'O30043', 'O30049',
        'O30091', 'O30092', 'O30093', 'O30099', 'O30101', 'O30102', 'O30103', 'O30109', 'O30111',
        'O30112', 'O30113', 'O30119', 'O30121', 'O30122', 'O30123', 'O30129', 'O30131', 'O30132',
        'O30133', 'O30139', 'O30191', 'O30192', 'O30193', 'O30199', 'O30201', 'O30202', 'O30203',
        'O30209', 'O30211', 'O30212', 'O30213', 'O30219', 'O30221', 'O30222', 'O30223', 'O30229',
        'O30231', 'O30232', 'O30233', 'O30239', 'O30291', 'O30292', 'O30293', 'O30299', 'O30801',
        'O30802', 'O30803', 'O30809', 'O30811', 'O30812', 'O30813', 'O30819', 'O30821', 'O30822',
        'O30823', 'O30829', 'O30831', 'O30832', 'O30833', 'O30839', 'O30891', 'O30892', 'O30893',
        'O30899', 'O3090', 'O3091', 'O3092', 'O3093', 'O3100X0', 'O3100X1', 'O3100X2', 'O3100X3',
        'O3100X4', 'O3100X5', 'O3100X9', 'O3101X0', 'O3101X1', 'O3101X2', 'O3101X3', 'O3101X4',
        'O3101X5', 'O3101X9', 'O3102X0', 'O3102X1', 'O3102X2', 'O3102X3', 'O3102X4', 'O3102X5',
        'O3102X9', 'O3103X0', 'O3103X1', 'O3103X2', 'O3103X3', 'O3103X4', 'O3103X5', 'O3103X9',
        'O3110X0', 'O3110X1', 'O3110X2', 'O3110X3', 'O3110X4', 'O3110X5', 'O3110X9', 'O3111X0',
        'O3111X1', 'O3111X2', 'O3111X3', 'O3111X4', 'O3111X5', 'O3111X9', 'O3112X0', 'O3112X1',
        'O3112X2', 'O3112X3', 'O3112X4', 'O3112X5', 'O3112X9', 'O3113X0', 'O3113X1', 'O3113X2',
        'O3113X3', 'O3113X4', 'O3113X5', 'O3113X9', 'O3120X0', 'O3120X1', 'O3120X2', 'O3120X3',
        'O3120X4', 'O3120X5', 'O3120X9', 'O3121X0', 'O3121X1', 'O3121X2', 'O3121X3', 'O3121X4',
        'O3121X5', 'O3121X9', 'O3122X0', 'O3122X1', 'O3122X2', 'O3122X3', 'O3122X4', 'O3122X5',
        'O3122X9', 'O3123X0', 'O3123X1', 'O3123X2', 'O3123X3', 'O3123X4', 'O3123X5', 'O3123X9',
        'O3130X0', 'O3130X1', 'O3130X2', 'O3130X3', 'O3130X4', 'O3130X5', 'O3130X9', 'O3131X0',
        'O3131X1', 'O3131X2', 'O3131X3', 'O3131X4', 'O3131X5', 'O3131X9', 'O3132X0', 'O3132X1',
        'O3132X2', 'O3132X3', 'O3132X4', 'O3132X5', 'O3132X9', 'O3133X0', 'O3133X1', 'O3133X2',
        'O3133X3', 'O3133X4', 'O3133X5', 'O3133X9', 'O318X10', 'O318X11', 'O318X12', 'O318X13',
        'O318X14', 'O318X15', 'O318X19', 'O318X20', 'O318X21', 'O318X22', 'O318X23', 'O318X24',
        'O318X25', 'O318X29', 'O318X30', 'O318X31', 'O318X32', 'O318X33', 'O318X34', 'O318X35',
        'O318X39', 'O318X90', 'O318X91', 'O318X92', 'O318X93', 'O318X94', 'O318X95', 'O318X99',
        'O320XX0', 'O320XX1', 'O320XX2', 'O320XX3', 'O320XX4', 'O320XX5', 'O320XX9', 'O321XX0',
        'O321XX1', 'O321XX2', 'O321XX3', 'O321XX4', 'O321XX5', 'O321XX9', 'O322XX0', 'O322XX1',
        'O322XX2', 'O322XX3', 'O322XX4', 'O322XX5', 'O322XX9', 'O323XX0', 'O323XX1', 'O323XX2',
        'O323XX3', 'O323XX4', 'O323XX5', 'O323XX9', 'O324XX0', 'O324XX1', 'O324XX2', 'O324XX3',
        'O324XX4', 'O324XX5', 'O324XX9', 'O326XX0', 'O326XX1', 'O326XX2', 'O326XX3', 'O326XX4',
        'O326XX5', 'O326XX9', 'O328XX0', 'O328XX1', 'O328XX2', 'O328XX3', 'O328XX4', 'O328XX5',
        'O328XX9', 'O329XX0', 'O329XX1', 'O329XX2', 'O329XX3', 'O329XX4', 'O329XX5', 'O329XX9',
        'O330', 'O331', 'O332', 'O333XX0', 'O333XX1', 'O333XX2', 'O333XX3', 'O333XX4', 'O333XX5',
        'O333XX9', 'O334XX0', 'O334XX1', 'O334XX2', 'O334XX3', 'O334XX4', 'O334XX5', 'O334XX9',
        'O335XX0', 'O335XX1', 'O335XX2', 'O335XX3', 'O335XX4', 'O335XX5', 'O335XX9', 'O336XX0',
        'O336XX1', 'O336XX2', 'O336XX3', 'O336XX4', 'O336XX5', 'O336XX9', 'O337XX0', 'O337XX1',
        'O337XX2', 'O337XX3', 'O337XX4', 'O337XX5', 'O337XX9', 'O338', 'O339', 'O3400', 'O3401',
        'O3402', 'O3403', 'O3410', 'O3411', 'O3412', 'O3413', 'O34211', 'O34212', 'O34219',
        'O3429', 'O3430', 'O3431', 'O3432', 'O3433', 'O3440', 'O3441', 'O3442', 'O3443', 'O34511',
        'O34512', 'O34513', 'O34519', 'O34521', 'O34522', 'O34523', 'O34529', 'O34531', 'O34532',
        'O34533', 'O34539', 'O34591', 'O34592', 'O34593', 'O34599', 'O3460', 'O3461', 'O3462',
        'O3463', 'O3470', 'O3471', 'O3472', 'O3473', 'O3480', 'O3481', 'O3482', 'O3483', 'O3490',
        'O3491', 'O3492', 'O3493', 'O350XX0', 'O350XX1', 'O350XX2', 'O350XX3', 'O350XX4',
        'O350XX5', 'O350XX9', 'O351XX0', 'O351XX1', 'O351XX2', 'O351XX3', 'O351XX4', 'O351XX5',
        'O351XX9', 'O352XX0', 'O352XX1', 'O352XX2', 'O352XX3', 'O352XX4', 'O352XX5', 'O352XX9',
        'O353XX0', 'O353XX1', 'O353XX2', 'O353XX3', 'O353XX4', 'O353XX5', 'O353XX9', 'O354XX0',
        'O354XX1', 'O354XX2', 'O354XX3', 'O354XX4', 'O354XX5', 'O354XX9', 'O355XX0', 'O355XX1',
        'O355XX2', 'O355XX3', 'O355XX4', 'O355XX5', 'O355XX9', 'O356XX0', 'O356XX1', 'O356XX2',
        'O356XX3', 'O356XX4', 'O356XX5', 'O356XX9', 'O357XX0', 'O357XX1', 'O357XX2', 'O357XX3',
        'O357XX4', 'O357XX5', 'O357XX9', 'O358XX0', 'O358XX1', 'O358XX2', 'O358XX3', 'O358XX4',
        'O358XX5', 'O358XX9', 'O359XX0', 'O359XX1', 'O359XX2', 'O359XX3', 'O359XX4', 'O359XX5',
        'O359XX9', 'O360110', 'O360111', 'O360112', 'O360113', 'O360114', 'O360115', 'O360119',
        'O360120', 'O360121', 'O360122', 'O360123', 'O360124', 'O360125', 'O360129', 'O360130',
        'O360131', 'O360132', 'O360133', 'O360134', 'O360135', 'O360139', 'O360190', 'O360191',
        'O360192', 'O360193', 'O360194', 'O360195', 'O360199', 'O360910', 'O360911', 'O360912',
        'O360913', 'O360914', 'O360915', 'O360919', 'O360920', 'O360921', 'O360922', 'O360923',
        'O360924', 'O360925', 'O360929', 'O360930', 'O360931', 'O360932', 'O360933', 'O360934',
        'O360935', 'O360939', 'O360990', 'O360991', 'O360992', 'O360993', 'O360994', 'O360995',
        'O360999', 'O361110', 'O361111', 'O361112', 'O361113', 'O361114', 'O361115', 'O361119',
        'O361120', 'O361121', 'O361122', 'O361123', 'O361124', 'O361125', 'O361129', 'O361130',
        'O361131', 'O361132', 'O361133', 'O361134', 'O361135', 'O361139', 'O361190', 'O361191',
        'O361192', 'O361193', 'O361194', 'O361195', 'O361199', 'O361910', 'O361911', 'O361912',
        'O361913', 'O361914', 'O361915', 'O361919', 'O361920', 'O361921', 'O361922', 'O361923',
        'O361924', 'O361925', 'O361929', 'O361930', 'O361931', 'O361932', 'O361933', 'O361934',
        'O361935', 'O361939', 'O361990', 'O361991', 'O361992', 'O361993', 'O361994', 'O361995',
        'O361999', 'O3620X0', 'O3620X1', 'O3620X2', 'O3620X3', 'O3620X4', 'O3620X5', 'O3620X9',
        'O3621X0', 'O3621X1', 'O3621X2', 'O3621X3', 'O3621X4', 'O3621X5', 'O3621X9', 'O3622X0',
        'O3622X1', 'O3622X2', 'O3622X3', 'O3622X4', 'O3622X5', 'O3622X9', 'O3623X0', 'O3623X1',
        'O3623X2', 'O3623X3', 'O3623X4', 'O3623X5', 'O3623X9', 'O364XX0', 'O364XX1', 'O364XX2',
        'O364XX3', 'O364XX4', 'O364XX5', 'O364XX9', 'O365110', 'O365111', 'O365112', 'O365113',
        'O365114', 'O365115', 'O365119', 'O365120', 'O365121', 'O365122', 'O365123', 'O365124',
        'O365125', 'O365129', 'O365130', 'O365131', 'O365132', 'O365133', 'O365134', 'O365135',
        'O365139', 'O365190', 'O365191', 'O365192', 'O365193', 'O365194', 'O365195', 'O365199',
        'O365910', 'O365911', 'O365912', 'O365913', 'O365914', 'O365915', 'O365919', 'O365920',
        'O365921', 'O365922', 'O365923', 'O365924', 'O365925', 'O365929', 'O365930', 'O365931',
        'O365932', 'O365933', 'O365934', 'O365935', 'O365939', 'O365990', 'O365991', 'O365992',
        'O365993', 'O365994', 'O365995', 'O365999', 'O3660X0', 'O3660X1', 'O3660X2', 'O3660X3',
        'O3660X4', 'O3660X5', 'O3660X9', 'O3661X0', 'O3661X1', 'O3661X2', 'O3661X3', 'O3661X4',
        'O3661X5', 'O3661X9', 'O3662X0', 'O3662X1', 'O3662X2', 'O3662X3', 'O3662X4', 'O3662X5',
        'O3662X9', 'O3663X0', 'O3663X1', 'O3663X2', 'O3663X3', 'O3663X4', 'O3663X5', 'O3663X9',
        'O3670X0', 'O3670X1', 'O3670X2', 'O3670X3', 'O3670X4', 'O3670X5', 'O3670X9', 'O3671X0',
        'O3671X1', 'O3671X2', 'O3671X3', 'O3671X4', 'O3671X5', 'O3671X9', 'O3672X0', 'O3672X1',
        'O3672X2', 'O3672X3', 'O3672X4', 'O3672X5', 'O3672X9', 'O3673X0', 'O3673X1', 'O3673X2',
        'O3673X3', 'O3673X4', 'O3673X5', 'O3673X9', 'O3680X0', 'O3680X1', 'O3680X2', 'O3680X3',
        'O3680X4', 'O3680X5', 'O3680X9', 'O368120', 'O368121', 'O368122', 'O368123', 'O368124',
        'O368125', 'O368129', 'O368130', 'O368131', 'O368132', 'O368133', 'O368134', 'O368135',
        'O368139', 'O368190', 'O368191', 'O368192', 'O368193', 'O368194', 'O368195', 'O368199',
        'O368210', 'O368211', 'O368212', 'O368213', 'O368214', 'O368215', 'O368219', 'O368220',
        'O368221', 'O368222', 'O368223', 'O368224', 'O368225', 'O368229', 'O368230', 'O368231',
        'O368232', 'O368233', 'O368234', 'O368235', 'O368239', 'O368290', 'O368291', 'O368292',
        'O368293', 'O368294', 'O368295', 'O368299', 'O368310', 'O368311', 'O368312', 'O368313',
        'O368314', 'O368315', 'O368319', 'O368320', 'O368321', 'O368322', 'O368323', 'O368324',
        'O368325', 'O368329', 'O368330', 'O368331', 'O368332', 'O368333', 'O368334', 'O368335',
        'O368339', 'O368390', 'O368391', 'O368392', 'O368393', 'O368394', 'O368395', 'O368399',
        'O368910', 'O368911', 'O368912', 'O368913', 'O368914', 'O368915', 'O368919', 'O368920',
        'O368921', 'O368922', 'O368923', 'O368924', 'O368925', 'O368929', 'O368930', 'O368931',
        'O368932', 'O368933', 'O368934', 'O368935', 'O368939', 'O368990', 'O368991', 'O368992',
        'O368993', 'O368994', 'O368995', 'O368999', 'O3690X0', 'O3690X1', 'O3690X2', 'O3690X3',
        'O3690X4', 'O3690X5', 'O3690X9', 'O3691X0', 'O3691X1', 'O3691X2', 'O3691X3', 'O3691X4',
        'O3691X5', 'O3691X9', 'O3692X0', 'O3692X1', 'O3692X2', 'O3692X3', 'O3692X4', 'O3692X5',
        'O3692X9', 'O3693X0', 'O3693X1', 'O3693X2', 'O3693X3', 'O3693X4', 'O3693X5', 'O3693X9',
        'O401XX0', 'O401XX1', 'O401XX2', 'O401XX3', 'O401XX4', 'O401XX5', 'O401XX9', 'O402XX0',
        'O402XX1', 'O402XX2', 'O402XX3', 'O402XX4', 'O402XX5', 'O402XX9', 'O403XX0', 'O403XX1',
        'O403XX2', 'O403XX3', 'O403XX4', 'O403XX5', 'O403XX9', 'O409XX0', 'O409XX1', 'O409XX2',
        'O409XX3', 'O409XX4', 'O409XX5', 'O409XX9', 'O4100X0', 'O4100X1', 'O4100X2', 'O4100X3',
        'O4100X4', 'O4100X5', 'O4100X9', 'O4101X0', 'O4101X1', 'O4101X2', 'O4101X3', 'O4101X4',
        'O4101X5', 'O4101X9', 'O4102X0', 'O4102X1', 'O4102X2', 'O4102X3', 'O4102X4', 'O4102X5',
        'O4102X9', 'O4103X0', 'O4103X1', 'O4103X2', 'O4103X3', 'O4103X4', 'O4103X5', 'O4103X9',
        'O411010', 'O411011', 'O411012', 'O411013', 'O411014', 'O411015', 'O411019', 'O411020',
        'O411021', 'O411022', 'O411023', 'O411024', 'O411025', 'O411029', 'O411030', 'O411031',
        'O411032', 'O411033', 'O411034', 'O411035', 'O411039', 'O411090', 'O411091', 'O411092',
        'O411093', 'O411094', 'O411095', 'O411099', 'O411210', 'O411211', 'O411212', 'O411213',
        'O411214', 'O411215', 'O411219', 'O411220', 'O411221', 'O411222', 'O411223', 'O411224',
        'O411225', 'O411229', 'O411230', 'O411231', 'O411232', 'O411233', 'O411234', 'O411235',
        'O411239', 'O411290', 'O411291', 'O411292', 'O411293', 'O411294', 'O411295', 'O411299',
        'O411410', 'O411411', 'O411412', 'O411413', 'O411414', 'O411415', 'O411419', 'O411420',
        'O411421', 'O411422', 'O411423', 'O411424', 'O411425', 'O411429', 'O411430', 'O411431',
        'O411432', 'O411433', 'O411434', 'O411435', 'O411439', 'O411490', 'O411491', 'O411492',
        'O411493', 'O411494', 'O411495', 'O411499', 'O418X10', 'O418X11', 'O418X12', 'O418X13',
        'O418X14', 'O418X15', 'O418X19', 'O418X20', 'O418X21', 'O418X22', 'O418X23', 'O418X24',
        'O418X25', 'O418X29', 'O418X30', 'O418X31', 'O418X32', 'O418X33', 'O418X34', 'O418X35',
        'O418X39', 'O418X90', 'O418X91', 'O418X92', 'O418X93', 'O418X94', 'O418X95', 'O418X99',
        'O4190X0', 'O4190X1', 'O4190X2', 'O4190X3', 'O4190X4', 'O4190X5', 'O4190X9', 'O4191X0',
        'O4191X1', 'O4191X2', 'O4191X3', 'O4191X4', 'O4191X5', 'O4191X9', 'O4192X0', 'O4192X1',
        'O4192X2', 'O4192X3', 'O4192X4', 'O4192X5', 'O4192X9', 'O4193X0', 'O4193X1', 'O4193X2',
        'O4193X3', 'O4193X4', 'O4193X5', 'O4193X9', 'O4200', 'O42011', 'O42012', 'O42013',
        'O42019', 'O4202', 'O4210', 'O42111', 'O42112', 'O42113', 'O42119', 'O4212', 'O4290',
        'O42911', 'O42912', 'O42913', 'O42919', 'O4292', 'O43011', 'O43012', 'O43013', 'O43019',
        'O43021', 'O43022', 'O43023', 'O43029', 'O43101', 'O43102', 'O43103', 'O43109', 'O43111',
        'O43112', 'O43113', 'O43119', 'O43121', 'O43122', 'O43123', 'O43129', 'O43191', 'O43192',
        'O43193', 'O43199', 'O43211', 'O43212', 'O43213', 'O43219', 'O43221', 'O43222', 'O43223',
        'O43229', 'O43231', 'O43232', 'O43233', 'O43239', 'O43811', 'O43812', 'O43813', 'O43819',
        'O43891', 'O43892', 'O43893', 'O43899', 'O4390', 'O4391', 'O4392', 'O4393', 'O4400',
        'O4401', 'O4402', 'O4403', 'O4410', 'O4411', 'O4412', 'O4413', 'O4420', 'O4421', 'O4422',
        'O4423', 'O4430', 'O4431', 'O4432', 'O4433', 'O4440', 'O4441', 'O4442', 'O4443', 'O4450',
        'O4451', 'O4452', 'O4453', 'O45001', 'O45002', 'O45003', 'O45009', 'O45011', 'O45012',
        'O45013', 'O45019', 'O45021', 'O45022', 'O45023', 'O45029', 'O45091', 'O45092', 'O45093',
        'O45099', 'O458X1', 'O458X2', 'O458X3', 'O458X9', 'O4590', 'O4591', 'O4592', 'O4593',
        'O46001', 'O46002', 'O46003', 'O46009', 'O46011', 'O46012', 'O46013', 'O46019', 'O46021',
        'O46022', 'O46023', 'O46029', 'O46091', 'O46092', 'O46093', 'O46099', 'O468X1', 'O468X2',
        'O468X3', 'O468X9', 'O4690', 'O4691', 'O4692', 'O4693', 'O4700', 'O4702', 'O4703', 'O471',
        'O479', 'O480', 'O481', 'O6000', 'O6002', 'O6003', 'O6010X0', 'O6010X1', 'O6010X2',
        'O6010X3', 'O6010X4', 'O6010X5', 'O6010X9', 'O6012X0', 'O6012X1', 'O6012X2', 'O6012X3',
        'O6012X4', 'O6012X5', 'O6012X9', 'O6013X0', 'O6013X1', 'O6013X2', 'O6013X3', 'O6013X4',
        'O6013X5', 'O6013X9', 'O6014X0', 'O6014X1', 'O6014X2', 'O6014X3', 'O6014X4', 'O6014X5',
        'O6014X9', 'O6020X0', 'O6020X1', 'O6020X2', 'O6020X3', 'O6020X4', 'O6020X5', 'O6020X9',
        'O6022X0', 'O6022X1', 'O6022X2', 'O6022X3', 'O6022X4', 'O6022X5', 'O6022X9', 'O6023X0',
        'O6023X1', 'O6023X2', 'O6023X3', 'O6023X4', 'O6023X5', 'O6023X9', 'O610', 'O611', 'O618',
        'O619', 'O620', 'O621', 'O622', 'O623', 'O624', 'O628', 'O629', 'O630', 'O631', 'O632',
        'O639', 'O640XX0', 'O640XX1', 'O640XX2', 'O640XX3', 'O640XX4', 'O640XX5', 'O640XX9',
        'O641XX0', 'O641XX1', 'O641XX2', 'O641XX3', 'O641XX4', 'O641XX5', 'O641XX9', 'O642XX0',
        'O642XX1', 'O642XX2', 'O642XX3', 'O642XX4', 'O642XX5', 'O642XX9', 'O643XX0', 'O643XX1',
        'O643XX2', 'O643XX3', 'O643XX4', 'O643XX5', 'O643XX9', 'O644XX0', 'O644XX1', 'O644XX2',
        'O644XX3', 'O644XX4', 'O644XX5', 'O644XX9', 'O645XX0', 'O645XX1', 'O645XX2', 'O645XX3',
        'O645XX4', 'O645XX5', 'O645XX9', 'O648XX0', 'O648XX1', 'O648XX2', 'O648XX3', 'O648XX4',
        'O648XX5', 'O648XX9', 'O649XX0', 'O649XX1', 'O649XX2', 'O649XX3', 'O649XX4', 'O649XX5',
        'O649XX9', 'O650', 'O651', 'O652', 'O653', 'O654', 'O655', 'O658', 'O659', 'O660', 'O661',
        'O662', 'O663', 'O6640', 'O6641', 'O665', 'O666', 'O668', 'O669', 'O670', 'O678', 'O679',
        'O68', 'O690XX0', 'O690XX1', 'O690XX2', 'O690XX3', 'O690XX4', 'O690XX5', 'O690XX9',
        'O691XX0', 'O691XX1', 'O691XX2', 'O691XX3', 'O691XX4', 'O691XX5', 'O691XX9', 'O692XX0',
        'O692XX1', 'O692XX2', 'O692XX3', 'O692XX4', 'O692XX5', 'O692XX9', 'O693XX0', 'O693XX1',
        'O693XX2', 'O693XX3', 'O693XX4', 'O693XX5', 'O693XX9', 'O694XX0', 'O694XX1', 'O694XX2',
        'O694XX3', 'O694XX4', 'O694XX5', 'O694XX9', 'O695XX0', 'O695XX1', 'O695XX2', 'O695XX3',
        'O695XX4', 'O695XX5', 'O695XX9', 'O6981X0', 'O6981X1', 'O6981X2', 'O6981X3', 'O6981X4',
        'O6981X5', 'O6981X9', 'O6982X0', 'O6982X1', 'O6982X2', 'O6982X3', 'O6982X4', 'O6982X5',
        'O6982X9', 'O6989X0', 'O6989X1', 'O6989X2', 'O6989X3', 'O6989X4', 'O6989X5', 'O6989X9',
        'O699XX0', 'O699XX1', 'O699XX2', 'O699XX3', 'O699XX4', 'O699XX5', 'O699XX9', 'O700',
        'O701', 'O7020', 'O7021', 'O7022', 'O7023', 'O703', 'O704', 'O709', 'O7100', 'O7102',
        'O7103', 'O711', 'O712', 'O713', 'O714', 'O715', 'O716', 'O717', 'O7181', 'O7182', 'O7189',
        'O719', 'O720', 'O721', 'O722', 'O723', 'O730', 'O731', 'O740', 'O741', 'O742', 'O743',
        'O744', 'O745', 'O746', 'O747', 'O748', 'O749', 'O750', 'O751', 'O752', 'O753', 'O754',
        'O755', 'O7581', 'O7582', 'O7589', 'O759', 'O76', 'O770', 'O771', 'O778', 'O779', 'O80',
        'O82', 'O85', 'O8600', 'O8601', 'O8602', 'O8603', 'O8604', 'O8609', 'O8611', 'O8612',
        'O8613', 'O8619', 'O8620', 'O8621', 'O8622', 'O8629', 'O864', 'O8681', 'O8689', 'O870',
        'O871', 'O872', 'O873', 'O874', 'O878', 'O879', 'O88011', 'O88012', 'O88013', 'O88019',
        'O8802', 'O8803', 'O88111', 'O88112', 'O88113', 'O88119', 'O8812', 'O8813', 'O88211',
        'O88212', 'O88213', 'O88219', 'O8822', 'O8823', 'O88311', 'O88312', 'O88313', 'O88319',
        'O8832', 'O8833', 'O88811', 'O88812', 'O88813', 'O88819', 'O8882', 'O8883', 'O8901',
        'O8909', 'O891', 'O892', 'O893', 'O894', 'O895', 'O896', 'O898', 'O899', 'O900', 'O901',
        'O902', 'O903', 'O904', 'O905', 'O906', 'O9081', 'O9089', 'O909', 'O91011', 'O91012',
        'O91013', 'O91019', 'O9102', 'O9103', 'O91111', 'O91112', 'O91113', 'O91119', 'O9112',
        'O9113', 'O91211', 'O91212', 'O91213', 'O91219', 'O9122', 'O9123', 'O92011', 'O92012',
        'O92013', 'O92019', 'O9202', 'O9203', 'O92111', 'O92112', 'O92113', 'O92119', 'O9212',
        'O9213', 'O9220', 'O9229', 'O923', 'O924', 'O925', 'O926', 'O9270', 'O9279', 'O94',
        'O98011', 'O98012', 'O98013', 'O98019', 'O9802', 'O9803', 'O98111', 'O98112', 'O98113',
        'O98119', 'O9812', 'O9813', 'O98211', 'O98212', 'O98213', 'O98219', 'O9822', 'O9823',
        'O98311', 'O98312', 'O98313', 'O98319', 'O9832', 'O9833', 'O98411', 'O98412', 'O98413',
        'O98419', 'O9842', 'O9843', 'O98511', 'O98512', 'O98513', 'O98519', 'O9852', 'O9853',
        'O98611', 'O98612', 'O98613', 'O98619', 'O9862', 'O9863', 'O98711', 'O98712', 'O98713',
        'O98719', 'O9872', 'O9873', 'O98811', 'O98812', 'O98813', 'O98819', 'O9882', 'O9883',
        'O98911', 'O98912', 'O98913', 'O98919', 'O9892', 'O9893', 'O99011', 'O99012', 'O99013',
        'O99019', 'O9902', 'O9903', 'O99111', 'O99112', 'O99113', 'O99119', 'O9912', 'O9913',
        'O99210', 'O99211', 'O99212', 'O99213', 'O99214', 'O99215', 'O99280', 'O99281', 'O99282',
        'O99283', 'O99284', 'O99285', 'O99310', 'O99311', 'O99312', 'O99313', 'O99314', 'O99315',
        'O99320', 'O99321', 'O99322', 'O99323', 'O99324', 'O99325', 'O99330', 'O99331', 'O99332',
        'O99333', 'O99334', 'O99335', 'O99340', 'O99341', 'O99342', 'O99343', 'O99344', 'O99345',
        'O99350', 'O99351', 'O99352', 'O99353', 'O99354', 'O99355', 'O99411', 'O99412', 'O99413',
        'O99419', 'O9942', 'O9943', 'O99511', 'O99512', 'O99513', 'O99519', 'O9952', 'O9953',
        'O99611', 'O99612', 'O99613', 'O99619', 'O9962', 'O9963', 'O99711', 'O99712', 'O99713',
        'O99719', 'O9972', 'O9973', 'O99810', 'O99814', 'O99815', 'O99820', 'O99824', 'O99825',
        'O99830', 'O99834', 'O99835', 'O99840', 'O99841', 'O99842', 'O99843', 'O99844', 'O99845',
        'O9989', 'O9A111', 'O9A112', 'O9A113', 'O9A119', 'O9A12', 'O9A13', 'O9A211', 'O9A212',
        'O9A213', 'O9A219', 'O9A22', 'O9A23', 'O9A311', 'O9A312', 'O9A313', 'O9A319', 'O9A32',
        'O9A33', 'O9A411', 'O9A412', 'O9A413', 'O9A419', 'O9A42', 'O9A43', 'O9A511', 'O9A512',
        'O9A513', 'O9A519', 'O9A52', 'O9A53', 'Z3400', 'Z3401', 'Z3402', 'Z3403', 'Z3480', 'Z3481',
        'Z3482', 'Z3483', 'Z3490', 'Z3491', 'Z3492', 'Z3493'
    }

    SNOMEDCT = {
        '10217006', '102882004', '102885002', '10562009', '10573002', '106004004', '106005003',
        '106007006', '106008001', '106009009', '106010004', '106011000', '10742471000119108',
        '10743831000119100', '10749641000119106', '10749691000119103', '10749811000119108',
        '10750551000119100', '10752771000119100', '10756101000119107', '10756301000119105',
        '10759231000119102', '10759841000119105', '10759961000119102', '10760341000119101',
        '10760981000119107', '10761061000119107', '10835971000119109', '10853001', '10884004',
        '109562007', '109891004', '109892006', '109893001', '109894007', '109895008', '111208003',
        '111425004', '111431001', '111432008', '111438007', '111440002', '111447004', '111451002',
        '111452009', '111453004', '111454005', '111458008', '111459000', '112073004', '11209007',
        '11246006', '1125006', '11454006', '11612004', '11618000', '11669000', '11687002',
        '11763009', '11914001', '11942004', '12095001', '123667006', '124736009', '125586008',
        '12729009', '128076000', '128077009', '12867002', '129597002', '129598007', '12983003',
        '130958001', '1343000', '13842006', '13866000', '13943000', '14022007', '14094001',
        '14331002', '1474004', '14918004', '15196006', '15230009', '1538006', '15394000',
        '15400003', '15406009', '15504009', '15539009', '15663008', '15692007', '1592005',
        '15938005', '16083003', '1621000119101', '163515002', '163516001', '1639007', '16574001',
        '16607004', '16756008', '16950007', '169581008', '169593004', '169958000', '171000119107',
        '17263003', '173300003', '17380002', '17382005', '17433009', '17532001', '17594002',
        '17787002', '178280004', '18237006', '18260003', '18416000', '18471004', '18559007',
        '18606002', '18656007', '19099008', '19117007', '19228003', '19236007', '19258009',
        '19363005', '19569008', '196040003', '19729005', '19773009', '198347000', '198609003',
        '198620003', '198644001', '198645000', '198646004', '198648003', '198655001', '198656000',
        '19866007', '198705001', '198706000', '198707009', '198708004', '198709007', '198710002',
        '198711003', '198718009', '198719001', '198720007', '198721006', '198722004', '198723009',
        '198724003', '198744009', '198745005', '198756005', '198757001', '198806007', '198807003',
        '198808008', '198809000', '198810005', '198811009', '198812002', '198832001', '198874006',
        '198875007', '198876008', '198878009', '198899007', '198900002', '198903000', '198905007',
        '198906008', '198910006', '198911005', '198912003', '198917009', '198918004', '198920001',
        '198922009', '198923004', '198925006', '198927003', '198928008', '198941007', '198942000',
        '198944004', '198945003', '198946002', '198947006', '198949009', '198951008', '198952001',
        '198953006', '198954000', '198965005', '198966006', '198967002', '198968007', '198983002',
        '198984008', '198985009', '198986005', '198990007', '198991006', '198992004', '198993009',
        '198997005', '198999008', '199000005', '199002002', '199003007', '199004', '199005000',
        '199006004', '199007008', '199008003', '199022003', '199023008', '199025001', '199027009',
        '199028004', '199047001', '199049003', '199050003', '199063009', '199064003', '199069008',
        '199070009', '199093003', '199095005', '199096006', '199099004', '199100007', '199101006',
        '199102004', '199106001', '199107005', '199108000', '199109008', '199110003', '199111004',
        '199112006', '199117000', '199118005', '199121007', '199122000', '199123005', '199124004',
        '199127006', '199128001', '199129009', '199130004', '199139003', '199141002', '199153003',
        '199154009', '199156006', '199157002', '199158007', '199159004', '199161008', '199163006',
        '199164000', '199165004', '199166003', '199175001', '199178004', '199179007', '199180005',
        '199181009', '199183007', '199185000', '199186004', '199187008', '199188003', '199192005',
        '199193000', '199194006', '199195007', '199203001', '199205008', '199206009', '199223000',
        '199225007', '199227004', '199244000', '199245004', '199257008', '199259006', '199261002',
        '199266007', '199267003', '199279003', '199281001', '199282008', '199283003', '199284009',
        '199293005', '199294004', '199295003', '199296002', '199297006', '199305006', '199306007',
        '199307003', '199308008', '199314001', '199318003', '199321001', '199322008', '199325005',
        '199326006', '199344003', '199345002', '199355003', '199358001', '199359009', '199362007',
        '199363002', '199373000', '199375007', '199376008', '199378009', '199380003', '199381004',
        '199384007', '199385008', '199397009', '199405005', '199406006', '199409004', '199410009',
        '199413006', '199414000', '199416003', '199418002', '199419005', '199422007', '199423002',
        '199425009', '199427001', '199428006', '199446000', '199461004', '199463001', '199464007',
        '199466009', '199468005', '199469002', '199470001', '199471002', '199482005', '199483000',
        '199484006', '199485007', '199511005', '199512003', '199513008', '199514002', '199531009',
        '199533007', '199534001', '199560000', '199561001', '199577000', '199578005', '199582007',
        '199583002', '199595002', '199596001', '199597005', '199607009', '199608004', '199646006',
        '199647002', '199653002', '199654008', '199658006', '199659003', '199660008', '199661007',
        '199662000', '199670005', '199672002', '199673007', '199677008', '199678003', '199694005',
        '199695006', '199710008', '199711007', '199714004', '199715003', '199718001', '199719009',
        '199741009', '199745000', '199746004', '199747008', '199749006', '199750006', '199751005',
        '199752003', '199753008', '199754002', '199755001', '199757009', '199759007', '199760002',
        '199761003', '199762005', '199763000', '199764006', '199765007', '199767004', '199769001',
        '199770000', '199774009', '199775005', '199783004', '199784005', '199806003', '199819004',
        '199821009', '199824001', '199825000', '199833004', '199834005', '199838008', '199839000',
        '199847000', '199848005', '199857004', '199858009', '199860006', '199862003', '199863008',
        '199869007', '199870008', '199874004', '199875003', '199880007', '199881006', '199889008',
        '199890004', '199895009', '199896005', '199900008', '199901007', '199916005', '199917001',
        '199925004', '199926003', '199930000', '199931001', '199934009', '199935005', '199958008',
        '199960005', '199961009', '199964001', '199965000', '199969006', '199970007', '199972004',
        '199974003', '199975002', '199977005', '199979008', '199980006', '199990003', '199991004',
        '199993001', '199997000', '200025008', '200030007', '200031006', '200038000', '200040005',
        '200043007', '200046004', '200049006', '200050006', '200051005', '200054002', '200056000',
        '200057009', '200058004', '200061003', '200063000', '200064006', '200065007', '200066008',
        '200068009', '200069001', '200070000', '200071001', '200072008', '200075005', '200077002',
        '200078007', '200099005', '200100002', '200101003', '200102005', '200105007', '200106008',
        '200111005', '200112003', '200113008', '200114002', '200125006', '200146002', '200164009',
        '200173001', '200204002', '200206000', '200207009', '200215007', '200216008', '200222004',
        '200224003', '200249004', '200251000', '200252007', '200253002', '200254008', '200277008',
        '200280009', '200284000', '200286003', '200288002', '200289005', '200294005', '200295006',
        '200299000', '200301007', '200302000', '200308001', '200309009', '200310004', '200311000',
        '200330000', '200331001', '200337002', '200338007', '200342005', '200343000', '200351002',
        '200367008', '200368003', '200369006', '200370007', '200374003', '200375002', '200376001',
        '200377005', '200381005', '200382003', '200383008', '200385001', '200402001', '200404000',
        '200405004', '200406003', '200407007', '200411001', '200412008', '200413003', '200414009',
        '200439000', '200440003', '200441004', '200442006', '200444007', '200446009', '200447000',
        '200448005', '200449002', '20391007', '204470001', '206079007', '206082002', '206089006',
        '206102001', '206148005', '206244002', '20625004', '206365006', '206366007', '20753005',
        '20845005', '20956009', '21280005', '2132004', '21334005', '21346009', '2138000',
        '21504004', '21737000', '21987001', '22033007', '22173004', '22271007', '22288000',
        '223003', '2261009', '22753004', '22846003', '22966008', '23001005', '23171006',
        '23332002', '234058009', '23431000119106', '23508005', '235888006', '23695007', '23717007',
        '237186006', '237188007', '237189004', '237190008', '237198001', '237201006', '237202004',
        '237205002', '237206001', '237208000', '237209008', '237227006', '237235009', '237236005',
        '237237001', '237245006', '237247003', '237249000', '237250000', '237254009', '237256006',
        '237257002', '237259004', '237260009', '237261008', '237266003', '237267007', '237270006',
        '237271005', '237272003', '237273008', '237274002', '237275001', '237276000', '237277009',
        '237279007', '237281009', '237282002', '237283007', '237284001', '237285000', '237286004',
        '237288003', '237292005', '237294006', '237296008', '237297004', '237300009', '237302001',
        '237303006', '237304000', '237305004', '237306003', '237307007', '237309005', '237310000',
        '237321009', '237325000', '237327008', '237328003', '237329006', '237336007', '237337003',
        '237338008', '237342006', '237343001', '237345008', '237346009', '237347000', '237348005',
        '237349002', '237350002', '237351003', '237352005', '237355007', '237357004', '237363008',
        '237627000', '23786008', '23885003', '239104000', '239105004', '23960006', '240167004',
        '240322003', '24042004', '24051007', '24082006', '24095001', '24258008', '24342007',
        '2437000', '24444009', '24536007', '24699006', '248996001', '249064003', '249065002',
        '249084004', '249085003', '249086002', '249087006', '249088001', '249089009', '249090000',
        '249091001', '249094009', '249095005', '249096006', '249098007', '249099004', '249100007',
        '249102004', '249103009', '249104003', '249105002', '249106001', '249107005', '249108000',
        '249109008', '249189006', '249196008', '249218000', '249219008', '249220002', '25032009',
        '25053000', '25113000', '25585008', '25691001', '25725007', '25749005', '25825004',
        '25922000', '26078007', '26158002', '26224003', '26358008', '26528001', '26623000',
        '26644000', '267197003', '267199000', '267204006', '267207004', '267219007', '267257007',
        '267262008', '267265005', '267266006', '267268007', '267271004', '267272006', '267273001',
        '267276009', '267280004', '267282007', '267283002', '267284008', '267289003', '267291006',
        '267317007', '267320004', '267322007', '267335003', '267340006', '267350007', '26741000',
        '26828006', '26840006', '26850007', '268585006', '268863005', '268864004', '268865003',
        '270498000', '270500004', '270502007', '27068000', '27075004', '271372000', '27152008',
        '27169005', '271954000', '27214003', '27215002', '27342004', '27388005', '273983009',
        '274117006', '274118001', '274119009', '274121004', '274126009', '275412000', '275426009',
        '275427000', '275429002', '275434003', '276369006', '276462003', '276479009', '276604007',
        '276879000', '276881003', '27696007', '2781009', '27921008', '280732008', '282020008',
        '28357009', '283963001', '284075002', '28608002', '286996009', '28735000', '28773001',
        '287979001', '288208001', '288250001', '288261009', '28911003', '289240005', '289254002',
        '289311005', '289312003', '289355004', '289356003', '289357007', '289358002', '289365005',
        '289366006', '289367002', '289368007', '289399008', '29057008', '291665000', '29171003',
        '29259002', '29399001', '29421008', '29847008', '29950007', '300927001', '302078000',
        '302644007', '302929008', '302945005', '303063000', '3033000', '30506002', '307333004',
        '307534009', '307632004', '307734007', '307735008', '307749004', '307752007', '308133005',
        '308134004', '308135003', '308136002', '308137006', '308140006', '308187004', '30850008',
        '31026002', '310592002', '310594001', '310650002', '312974005', '313017000', '313291009',
        '31383003', '31407004', '31481000', '31516002', '31563000', '31805001', '31821006',
        '32808002', '32999002', '33058001', '33128005', '33370009', '33490001', '33552005',
        '33627001', '34150001', '34165000', '34242002', '34262005', '34273003', '34327003',
        '34367002', '34430009', '34478009', '34530006', '34694006', '34801009', '34842007',
        '34981006', '35208003', '35255008', '35258005', '35303009', '35347003', '35381000119101',
        '35716006', '35746009', '35882009', '35999006', '361095003', '361096002', '36297009',
        '363093002', '36323001', '3634007', '364748006', '36497006', '36664002', '36697001',
        '367390009', '36801000119105', '36813001', '36854009', '36916008', '371374003',
        '371375002', '371380006', '37139009', '37141005', '371607000', '371614003', '373680009',
        '37618003', '37762002', '38010008', '38049006', '38099005', '38176009', '38451000119105',
        '38534008', '38720006', '3873005', '387692004', '387696001', '387699008', '387700009',
        '3885002', '388602007', '388604008', '388605009', '38951007', '39120007', '39208009',
        '392280004', '39246002', '39249009', '3944006', '39587000', '396544001', '39727004',
        '39763004', '397752008', '397949005', '397952002', '398019008', '39804004', '398254007',
        '398262004', '398276003', '399031001', '399363000', '4006006', '40096002', '40125005',
        '40193008', '4026005', '405736009', '40609001', '408812003', '41114007', '41215002',
        '413339006', '413567003', '415105001', '415810004', '416669000', '41679006', '417044008',
        '417150000', '417364008', '4174008', '417426005', '41962002', '41991004', '42070007',
        '42537006', '42553009', '425708006', '42571002', '42599006', '42686001', '426997005',
        '427139004', '428017002', '428165003', '428230005', '428252001', '428511009', '428707000',
        '429187001', '430881000', '430883002', '430933008', '43195002', '43293004', '43629001',
        '43651009', '43715006', '439107005', '43957006', '43970002', '43990006', '44216000',
        '44223004', '442478007', '443006', '443460007', '444661007', '44640004', '44772007',
        '44795003', '44918005', '449807005', '449808000', '449809008', '44992005', '45079001',
        '45759004', '45828008', '459166009', '459167000', '46273003', '46311005', '46365005',
        '46502006', '46764007', '46848006', '46894009', '47161002', '47200007', '472321009',
        '47236005', '4752007', '47780009', '47821001', '48194001', '48200009', '48287005',
        '48552006', '48782003', '48888007', '48906005', '4907004', '4910006', '49102001',
        '49168004', '49171007', '49177006', '49279000', '49342001', '49364005', '49416000',
        '49561003', '49815007', '50120008', '50557007', '50726009', '5074003', '50764006',
        '50844007', '51096002', '51154004', '51195001', '51495008', '51519001', '51920004',
        '52327008', '52700006', '52772002', '53024001', '53111003', '53419009', '53443007',
        '54048003', '54212005', '54213000', '54449002', '54486001', '54679003', '54844002',
        '55472006', '55565007', '55581002', '55613002', '55639004', '55704005', '5626004',
        '56313000', '56425003', '56451001', '56462001', '57220000', '57296000', '5740008',
        '57576007', '57734001', '57759005', '57873008', '58071009', '58123006', '58261003',
        '5852008', '58703003', '58881007', '58903006', '59136001', '5939002', '5945005',
        '59534005', '59566000', '5973007', '59733002', '59795007', '59919008', '60574005',
        '60601008', '60755004', '60810003', '60854009', '609447002', '609448007', '609449004',
        '609451000', '609452007', '609453002', '609455009', '609457001', '609458006', '609459003',
        '609460008', '609465003', '609472002', '609479006', '609480009', '609485004', '609486003',
        '609487007', '609489005', '609491002', '609506003', '609525000', '609563008', '609564002',
        '609566000', '609567009', '6096002', '61007003', '61452007', '61714007', '61951009',
        '62023000', '62129004', '62131008', '6234006', '62377009', '62410004', '62531004',
        '62612003', '62657007', '63040001', '63287004', '63637002', '63662002', '63750008',
        '6383007', '64171002', '64181003', '64229006', '64230001', '64254006', '64433002',
        '64646001', '64954002', '65147003', '65377004', '65402008', '65409004', '65483000',
        '65539006', '6594005', '66119008', '66294006', '663008', '6636004', '66709007', '66844003',
        '66892003', '66958002', '67042008', '67229002', '67359005', '67480003', '67802002',
        '67881007', '682004', '68214002', '6825008', '68635007', '6891008', '69018001', '69217004',
        '69270005', '698716002', '698717006', '69897008', '69909000', '699240001', '6995000',
        '699950009', '70068004', '70129008', '70137000', '702711004', '70603007', '71028008',
        '71151000119105', '713575004', '713576003', '71473008', '71531003', '71612002', '71639005',
        '71874008', '71901000', '72022006', '7245003', '7266006', '72860003', '73030000',
        '73161006', '73790007', '73837001', '73972002', '74955002', '75022004', '7504005',
        '75094005', '75150001', '75428007', '75798003', '75825001', '75836008', '75933004',
        '76037007', '76380008', '76751001', '76771005', '76871004', '76889003', '769087009',
        '77186001', '77259008', '77278008', '77285007', '77376005', '77563000', '7768008',
        '77854008', '77913004', '7792000', '7822001', '78381004', '78408007', '78697003',
        '78789000', '78808002', '79133008', '79179003', '79222000', '79255005', '79355007',
        '79414005', '79586000', '79643007', '79668009', '79748007', '79839005', '79884007',
        '79888005', '79986005', '80002007', '80113008', '80224003', '80256005', '8076000',
        '80818002', '80847009', '80997009', '81448000', '81521003', '81557008', '81626002',
        '81677009', '8218002', '82661006', '82664003', '83094001', '83243004', '83741001',
        '83787007', '83916000', '8393005', '84007008', '84235001', '84357006', '8445003',
        '84693004', '85076009', '85542007', '86041002', '86081009', '86196005', '86203003',
        '86256001', '86356004', '86687009', '86891002', '87043009', '871005', '87383005',
        '8762007', '87621000', '87814002', '87840008', '88697005', '8884000', '88887003',
        '88895004', '88992002', '89244003', '89550007', '89672000', '89700002', '90009001',
        '90127001', '90188009', '90325002', '90532005', '90645002', '90968009', '9107002',
        '91153002', '91162000', '91217009', '91484005', '91948008', '92297008', '9293002',
        '9297001', '9442009', '95605009', '95606005', '95607001', '95608006', '9720009', '9780006',
        '9864005', '9899009', '9901000'
    }


class GlycoproteinIibiiiaInhibitors(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent codes that identify glycoprotein Iib/IIIa inhibitors.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who are on a glycoprotein Iib/IIIa inhibitor.
    Inclusion Criteria: Includes only relevant concepts associated with a glycoprotein Iib/IIIa inhibitor. These are RxNorm codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1045.41'
    VALUE_SET_NAME = 'Glycoprotein IIb/IIIa Inhibitors'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1736470', '1736477', '1737466', '1737471', '1813035', '200349', '241162'}


class NonacuteInpatient(ValueSet):
    """

    Clinical Focus: This value set contains concepts related to nonacute inpatient visits.
    Data Element Scope: This value set may use Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive history, evaluation, and management of a patient in a nonacute inpatient setting. This is a grouping value set of CPT and SNOMED codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1084'
    VALUE_SET_NAME = 'Nonacute Inpatient'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '99304', '99305', '99306', '99307', '99308', '99309', '99310', '99315', '99316', '99318',
        '99324', '99325', '99326', '99327', '99328', '99334', '99335', '99336', '99337'
    }

    SNOMEDCT = {
        '112690009', '183430001', '183921001', '304567001', '304568006', '305336008', '305340004',
        '305381007', '306804001', '36723004', '449411000124106', '449421000124103',
        '449431000124100'
    }


class Diabetes(ValueSet):
    """

    Clinical Focus: This value set contains concepts that identify patients who have a diagnosis of diabetes.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who have type I or type II diabetes.
    Exclusion Criteria: Excludes patients who have gestational diabetes or steroid-induced diabetes.
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1001'
    VALUE_SET_NAME = 'Diabetes'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'E1010', 'E1011', 'E1021', 'E1022', 'E1029', 'E10311', 'E10319', 'E10321', 'E103211',
        'E103212', 'E103213', 'E103219', 'E10329', 'E103291', 'E103292', 'E103293', 'E103299',
        'E10331', 'E103311', 'E103312', 'E103313', 'E103319', 'E10339', 'E103391', 'E103392',
        'E103393', 'E103399', 'E10341', 'E103411', 'E103412', 'E103413', 'E103419', 'E10349',
        'E103491', 'E103492', 'E103493', 'E103499', 'E10351', 'E103511', 'E103512', 'E103513',
        'E103519', 'E103521', 'E103522', 'E103523', 'E103529', 'E103531', 'E103532', 'E103533',
        'E103539', 'E103541', 'E103542', 'E103543', 'E103549', 'E103551', 'E103552', 'E103553',
        'E103559', 'E10359', 'E103591', 'E103592', 'E103593', 'E103599', 'E1036', 'E1037X1',
        'E1037X2', 'E1037X3', 'E1037X9', 'E1039', 'E1040', 'E1041', 'E1042', 'E1043', 'E1044',
        'E1049', 'E1051', 'E1052', 'E1059', 'E10610', 'E10618', 'E10620', 'E10621', 'E10622',
        'E10628', 'E10630', 'E10638', 'E10641', 'E10649', 'E1065', 'E1069', 'E108', 'E109',
        'E1100', 'E1101', 'E1110', 'E1111', 'E1121', 'E1122', 'E1129', 'E11311', 'E11319',
        'E11321', 'E113211', 'E113212', 'E113213', 'E113219', 'E11329', 'E113291', 'E113292',
        'E113293', 'E113299', 'E11331', 'E113311', 'E113312', 'E113313', 'E113319', 'E11339',
        'E113391', 'E113392', 'E113393', 'E113399', 'E11341', 'E113411', 'E113412', 'E113413',
        'E113419', 'E11349', 'E113491', 'E113492', 'E113493', 'E113499', 'E11351', 'E113511',
        'E113512', 'E113513', 'E113519', 'E113521', 'E113522', 'E113523', 'E113529', 'E113531',
        'E113532', 'E113533', 'E113539', 'E113541', 'E113542', 'E113543', 'E113549', 'E113551',
        'E113552', 'E113553', 'E113559', 'E11359', 'E113591', 'E113592', 'E113593', 'E113599',
        'E1136', 'E1137X1', 'E1137X2', 'E1137X3', 'E1137X9', 'E1139', 'E1140', 'E1141', 'E1142',
        'E1143', 'E1144', 'E1149', 'E1151', 'E1152', 'E1159', 'E11610', 'E11618', 'E11620',
        'E11621', 'E11622', 'E11628', 'E11630', 'E11638', 'E11641', 'E11649', 'E1165', 'E1169',
        'E118', 'E119', 'E1300', 'E1301', 'E1310', 'E1311', 'E1321', 'E1322', 'E1329', 'E13311',
        'E13319', 'E13321', 'E133211', 'E133212', 'E133213', 'E133219', 'E13329', 'E133291',
        'E133292', 'E133293', 'E133299', 'E13331', 'E133311', 'E133312', 'E133313', 'E133319',
        'E13339', 'E133391', 'E133392', 'E133393', 'E133399', 'E13341', 'E133411', 'E133412',
        'E133413', 'E133419', 'E13349', 'E133491', 'E133492', 'E133493', 'E133499', 'E13351',
        'E133511', 'E133512', 'E133513', 'E133519', 'E133521', 'E133522', 'E133523', 'E133529',
        'E133531', 'E133532', 'E133533', 'E133539', 'E133541', 'E133542', 'E133543', 'E133549',
        'E133551', 'E133552', 'E133553', 'E133559', 'E13359', 'E133591', 'E133592', 'E133593',
        'E133599', 'E1336', 'E1337X1', 'E1337X2', 'E1337X3', 'E1337X9', 'E1339', 'E1340', 'E1341',
        'E1342', 'E1343', 'E1344', 'E1349', 'E1351', 'E1352', 'E1359', 'E13610', 'E13618',
        'E13620', 'E13621', 'E13622', 'E13628', 'E13630', 'E13638', 'E13641', 'E13649', 'E1365',
        'E1369', 'E138', 'E139', 'O24011', 'O24012', 'O24013', 'O24019', 'O2402', 'O2403',
        'O24111', 'O24112', 'O24113', 'O24119', 'O2412', 'O2413', 'O24311', 'O24312', 'O24313',
        'O24319', 'O2432', 'O2433', 'O24811', 'O24812', 'O24813', 'O24819', 'O2482', 'O2483'
    }

    ICD9CM = {
        '25000', '25001', '25002', '25003', '25010', '25011', '25012', '25013', '25020', '25021',
        '25022', '25023', '25030', '25031', '25032', '25033', '25040', '25041', '25042', '25043',
        '25050', '25051', '25052', '25053', '25060', '25061', '25062', '25063', '25070', '25071',
        '25072', '25073', '25080', '25081', '25082', '25083', '25090', '25091', '25092', '25093',
        '3572', '36201', '36202', '36203', '36204', '36205', '36206', '36207', '36641', '64800',
        '64801', '64802', '64803', '64804'
    }

    SNOMEDCT = {
        '102781000119107', '104941000119109', '109171000119104', '138881000119106',
        '138891000119109', '1481000119100', '190330002', '190331003', '190368000', '190369008',
        '190372001', '190388001', '190389009', '190390000', '199229001', '199230006', '23045005',
        '237599002', '237604008', '237618001', '28032008', '31211000119101', '31321000119102',
        '313435000', '313436004', '314771006', '314772004', '314893005', '314894004', '314902007',
        '314903002', '314904008', '359642000', '368521000119107', '395204000', '420486006',
        '420789003', '420918009', '421164006', '421468001', '421750000', '421847006', '421920002',
        '422014003', '427571000', '44054006', '46635009', '4783006', '609562003', '609564002',
        '609567009', '60961000119107', '60971000119101', '60991000119100', '691000119103',
        '703138006', '712882000', '713702000', '713705003', '71791000119104', '719216001',
        '739681000', '75682002', '76751001', '769219006', '770098001', '781000119106', '81531005',
        '82571000119107', '82581000119105', '9859006'
    }


class ProstateCancer(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent prostate cancer diagnosis.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with prostate cancer diagnoses.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.319'
    VALUE_SET_NAME = 'Prostate Cancer'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'C61'}

    ICD9CM = {'185'}

    SNOMEDCT = {
        '254900004', '278060005', '314969001', '369485004', '369486003', '396198006', '399068003',
        '399490008', '399590005', '427492003', '93974005', '94503003'
    }


class WeightReductionRecommended(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent management and maintenance of weight.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with interventions addressing healthy eating, goal setting, weight management and maintenance.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1510'
    VALUE_SET_NAME = 'Weight Reduction Recommended'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    HCPCS = {'S9449'}

    SNOMEDCT = {'170795002', '266724001', '268523001', '408289007', '410200000'}


class MedicalOrOtherReasonNotDone(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the reason not done.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Negation Rationale or Reason.
    Inclusion Criteria: Includes only relevant concepts associated with medical or other reason for procedure or treatment not done.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1502'
    VALUE_SET_NAME = 'Medical or Other reason not done'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'183932001', '397745006', '407563006', '428119001'}


class PreventiveCareServicesGroupCounseling(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent group counseling services.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying preventive medicine counseling and/or risk factor reduction intervention(s) provided to individuals in a group setting.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1027'
    VALUE_SET_NAME = 'Preventive Care Services - Group Counseling'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99411', '99412'}


class DtapVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diphtheria, tetanus, and whooping cough (pertussis) (DTaP) vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with diphtheria, tetanus, and whooping cough (pertussis) (DTaP) vaccine codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1214'
    VALUE_SET_NAME = 'DTaP Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'106', '107', '110', '120', '20', '50'}


class AtropineHyoscyaminePhenobarbitalScopolamine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent atropine / hyoscyamine / phenobarbital / scopolamine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; atropine / hyoscyamine / phenobarbital / scopolamine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; atropine / hyoscyamine / phenobarbital / scopolamine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1355'
    VALUE_SET_NAME = 'Atropine / Hyoscyamine / Phenobarbital / Scopolamine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1046815', '1048147'}


class BelowNormalFollowUp(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a follow-up with a BMI below normal measurement.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with a follow-up when BMI is below normal measurement.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1528'
    VALUE_SET_NAME = 'Below Normal Follow up'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    HCPCS = {
        '97802', '97803', '97804', '98960', '99078', '99401', '99402', 'S9449', 'S9452', 'S9470'
    }

    ICD10CM = {'Z713'}

    SNOMEDCT = {
        '386464006', '410177006', '413315001', '418995006', '424753004', '429095004', '443288003'
    }


class NegativeDepressionScreening(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent situations in which a depression screen was performed by the health care professional and the finding was negative for depression.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Assessment.
    Inclusion Criteria: Includes only relevant concepts associated with screening for depression whereby the outcome is negative.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.2451'
    VALUE_SET_NAME = 'Negative Depression Screening'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'428171000124102'}


class DischargeServicesObservationCare(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who received observational stay discharge day management.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with services provided to a patient on discharge from outpatient hospital observation status if the discharge is on other than the initial date of observation status.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1039'
    VALUE_SET_NAME = 'Discharge Services- Observation Care'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99217'}


class OpticAtrophy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of optic atrophy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of optic atrophy, which may include atrophy of the optic disc.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1466'
    VALUE_SET_NAME = 'Optic Atrophy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H4720', 'H47211', 'H47212', 'H47213', 'H4722', 'H47231', 'H47232', 'H47233', 'H47291',
        'H47292', 'H47293'
    }

    ICD9CM = {'37710', '37711', '37712', '37713', '37714', '37715', '37716'}

    SNOMEDCT = {
        '111527005', '1207009', '123615007', '128203003', '194043004', '19448008', '2065009',
        '21098003', '22386003', '230511003', '239028001', '24003004', '247219000', '26360005',
        '312944002', '359683002', '58610003', '70694009', '715374003', '717336005', '717975006',
        '718221007', '719517009', '76976005', '95774001', '95775000'
    }


class Bradycardia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of bradycardia.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of bradycardia.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.412'
    VALUE_SET_NAME = 'Bradycardia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I495', 'I498', 'R001'}

    ICD9CM = {'42781', '42789'}

    SNOMEDCT = {'251162005', '29894000', '397841007', '44602002', '49044005', '49710005'}


class DietaryRecommendations(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dietary management.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with dietary management and nutritional education.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1515'
    VALUE_SET_NAME = 'Dietary Recommendations'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    HCPCS = {'S9452', 'S9470'}

    ICD10CM = {'Z713'}

    ICD9CM = {'V653'}

    SNOMEDCT = {
        '103699006', '11816003', '182922004', '182954008', '182955009', '182956005', '182960008',
        '183061003', '183065007', '183070000', '183071001', '281085002', '284071006', '284352003',
        '289176001', '289177005', '304491008', '306163007', '361231003', '370847001', '386464006',
        '410114009', '410171007', '410177006', '410270001', '413315001', '418995006', '424753004',
        '437211000124103', '437231000124109', '437391000124102', '437421000124105',
        '438961000124108', '443288003', '61310001'
    }


class Trihexyphenidyl(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent trihexyphenidyl medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; trihexyphenidyl only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; trihexyphenidyl in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1334'
    VALUE_SET_NAME = 'Trihexyphenidyl'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'905269', '905283'}


class HibVaccine4DoseScheduleAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures for haemophilus influenzae type b (Hib) vaccine administration (4-dose schedule).
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with haemophilus influenzae type b (Hib) vaccine administration codes (4-dose schedule). This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1086'
    VALUE_SET_NAME = 'HiB Vaccine (4 dose schedule) Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90644', '90648', '90698', '90748'}

    SNOMEDCT = {
        '127787002', '170343007', '170344001', '170345000', '170346004', '310306005', '310307001',
        '310308006', '312869001', '312870000', '414001002', '414259000', '415507003', '415712004'
    }


class Chlamydia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlamydia infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with all relevant concepts associated with chlamydia infections. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1003'
    VALUE_SET_NAME = 'Chlamydia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'A5600', 'A5601', 'A5609'}

    SNOMEDCT = {
        '105629000', '179101003', '186729003', '186731007', '188463006', '189312004', '197172005',
        '198176005', '236683007', '237039009', '237043008', '237084006', '237097008', '237106009',
        '240589008', '312099009', '367504009', '420910002', '426165006', '426247003', '428015005',
        '446642005', '446752000', '447353001', '447372001', '447386002', '447402003'
    }


class Ecg12LeadOrStudyOrder(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent electrocardiogram (ECG) 12-lead studies.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with for ECG 12-lead or study order.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.2448'
    VALUE_SET_NAME = 'ECG 12 lead or study order'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'11524-6', '34534-8'}


class AntiInfectivesOther(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent nitrofurantion (anti-infective medications).
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (component, form and strength); generic; human only; prescribable; nitrofurantion medications.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; nitrofurantion in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1481'
    VALUE_SET_NAME = 'Anti Infectives, other'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1648755', '1648759', '311989', '311991', '311994', '311995'}


class Arrhythmia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of arrhythmia.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of arrhythmia.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.366'
    VALUE_SET_NAME = 'Arrhythmia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I498', 'I499'}

    ICD9CM = {'42789', '4279'}

    SNOMEDCT = {
        '10164001', '10626002', '11157007', '11849007', '13640000', '17338001', '17366009',
        '17869006', '184004', '195060002', '195069001', '195071001', '195072008', '195083004',
        '233891009', '233892002', '233893007', '233894001', '233895000', '233904005', '233915000',
        '233922008', '233923003', '234172002', '251161003', '251162005', '251163000', '251164006',
        '251165007', '251166008', '251167004', '251168009', '251170000', '251172008', '251173003',
        '251174009', '251175005', '251176006', '251177002', '251178007', '251179004', '251180001',
        '251181002', '251182009', '251186007', '251187003', '251188008', '26950008', '27337007',
        '276796006', '284470004', '287057009', '29320008', '309809007', '33413000', '36083008',
        '38274001', '39260000', '39357005', '40593004', '406461004', '418341009', '418818005',
        '419752005', '421869004', '422348008', '429243003', '44808001', '47830009', '49982000',
        '55475008', '59272004', '60423000', '61277005', '63232000', '63593006', '69730002',
        '71908006', '72654001', '74390002', '74615001', '75532003', '81681009', '81898007',
        '88412007'
    }


class Cd4Percentage(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the CD4  percentage laboratory tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with codes that identify CD4  percentages with CD3 CD4  (T4 helper) in the code name. This is a grouping of LOINC codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1005'
    VALUE_SET_NAME = 'CD4  Percentage'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'17822-8', '32516-7', '32533-2', '40623-1', '43970-3', '51300-2', '8123-2'}


class BrompheniramineCodeinePhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent brompheniramine / codeine / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; brompheniramine / codeine / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; brompheniramine / codeine / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1409'
    VALUE_SET_NAME = 'Brompheniramine / Codeine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1356797'}


class DiabeticRetinopathy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of diabetic retinopathy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diabetic retinopathy diagnoses.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.327'
    VALUE_SET_NAME = 'Diabetic Retinopathy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'E08311', 'E08319', 'E083211', 'E083212', 'E083213', 'E083291', 'E083292', 'E083293',
        'E083311', 'E083312', 'E083313', 'E083391', 'E083392', 'E083393', 'E083411', 'E083412',
        'E083413', 'E083491', 'E083492', 'E083493', 'E083511', 'E083512', 'E083513', 'E083521',
        'E083522', 'E083523', 'E083531', 'E083532', 'E083533', 'E083541', 'E083542', 'E083543',
        'E083551', 'E083552', 'E083553', 'E083591', 'E083592', 'E083593', 'E09311', 'E09319',
        'E093211', 'E093212', 'E093213', 'E093291', 'E093292', 'E093293', 'E093311', 'E093312',
        'E093313', 'E093391', 'E093392', 'E093393', 'E093411', 'E093412', 'E093413', 'E093491',
        'E093492', 'E093493', 'E093511', 'E093512', 'E093513', 'E093521', 'E093522', 'E093523',
        'E093531', 'E093532', 'E093533', 'E093541', 'E093542', 'E093543', 'E093551', 'E093552',
        'E093553', 'E093591', 'E093592', 'E093593', 'E10311', 'E10319', 'E103211', 'E103212',
        'E103213', 'E103291', 'E103292', 'E103293', 'E103311', 'E103312', 'E103313', 'E103391',
        'E103392', 'E103393', 'E103411', 'E103412', 'E103413', 'E103491', 'E103492', 'E103493',
        'E103511', 'E103512', 'E103513', 'E103521', 'E103522', 'E103523', 'E103531', 'E103532',
        'E103533', 'E103541', 'E103542', 'E103543', 'E103551', 'E103552', 'E103553', 'E103591',
        'E103592', 'E103593', 'E11311', 'E11319', 'E113211', 'E113212', 'E113213', 'E113291',
        'E113292', 'E113293', 'E113311', 'E113312', 'E113313', 'E113391', 'E113392', 'E113393',
        'E113411', 'E113412', 'E113413', 'E113491', 'E113492', 'E113493', 'E113511', 'E113512',
        'E113513', 'E113521', 'E113522', 'E113523', 'E113531', 'E113532', 'E113533', 'E113541',
        'E113542', 'E113543', 'E113551', 'E113552', 'E113553', 'E113591', 'E113592', 'E113593',
        'E13311', 'E13319', 'E133211', 'E133212', 'E133213', 'E133291', 'E133292', 'E133293',
        'E133311', 'E133312', 'E133313', 'E133391', 'E133392', 'E133393', 'E133411', 'E133412',
        'E133413', 'E133491', 'E133492', 'E133493', 'E133511', 'E133512', 'E133513', 'E133521',
        'E133522', 'E133523', 'E133531', 'E133532', 'E133533', 'E133541', 'E133542', 'E133543',
        'E133551', 'E133552', 'E133553', 'E133591', 'E133592', 'E133593'
    }

    ICD9CM = {'36201', '36202', '36203', '36204', '36205', '36206'}

    SNOMEDCT = {
        '193349004', '193350004', '232020009', '232021008', '232022001', '232023006', '25412000',
        '311782002', '312903003', '312904009', '312905005', '312906006', '312907002', '312908007',
        '312909004', '312912001', '314010006', '314011005', '314014002', '314015001', '390834004',
        '399862001', '399863006', '399864000', '399865004', '399866003', '399868002', '399869005',
        '399870006', '399871005', '399872003', '399873008', '399874002', '399875001', '399876000',
        '399877009', '420486006', '420789003', '421779007', '422034002', '4855003', '59276001'
    }


class BmiEncounterCodeSet(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent multiple types of encounters for body mass index (BMI) assessment.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with multiple types of encounters that enable BMI measurement.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1751'
    VALUE_SET_NAME = 'BMI Encounter Code Set'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CDT = {'D7111', 'D7140', 'D7210', 'D7220', 'D7230', 'D7240', 'D7241', 'D7250', 'D7251'}

    CPT = {
        '90791', '90792', '90832', '90834', '90837', '96150', '96151', '96152', '97161', '97162',
        '97163', '97165', '97166', '97167', '97802', '97803', '99201', '99202', '99203', '99204',
        '99205', '99212', '99213', '99214', '99215', '99236', '99304', '99305', '99306', '99307',
        '99308', '99309', '99310', '99315', '99316', '99318', '99324', '99325', '99326', '99327',
        '99328', '99334', '99335', '99336', '99337', '99339', '99340', '99385', '99386', '99387',
        '99395', '99396', '99397', '99401', '99402'
    }

    HCPCS = {'G0101', 'G0108', 'G0270', 'G0271', 'G0402', 'G0438', 'G0439', 'G0447', 'G0473'}

    SNOMEDCT = {
        '10197000', '108220007', '108221006', '108224003', '108311000', '13607009', '14736009',
        '165171009', '18512000', '185349003', '185463005', '185465003', '225967005', '270427003',
        '270430005', '308335008', '32537008', '35025007', '386372009', '390906007', '406547006',
        '410155007', '410157004', '410158009', '410160006', '410170008', '410172000', '46662001',
        '55162003', '68381003', '78318003', '83607001', '8411005', '86013001', '90526000'
    }


class Metaxalone(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent metaxalone medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; metaxalone only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; metaxalone in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1358'
    VALUE_SET_NAME = 'Metaxalone'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197935', '351254'}


class PromethazineHydrochloride(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent promethazine hydrochloride medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; promethazine hydrochloride only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; promethazine hydrochloride in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1367'
    VALUE_SET_NAME = 'Promethazine Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '992432', '992438', '992441', '992447', '992454', '992460', '992475', '992478', '992858'
    }


class AspirinCaffeineOrphenadrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent aspirin / caffeine / orphenadrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; aspirin / caffeine / orphenadrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; aspirin / caffeine / orphenadrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1302'
    VALUE_SET_NAME = 'Aspirin / Caffeine / Orphenadrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'994528', '994535'}


class ListOfSingleRxnormCodeConceptsForHighRiskDrugsForTheElderly(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent medication concepts considered as high risk for the elderly.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; medications considered high risk for the elderly.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1272'
    VALUE_SET_NAME = 'List of Single RxNorm Code Concepts for High Risk Drugs for the Elderly'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1012904', '1014331', '1042693', '1048124', '1052647', '1052928', '1094131', '1094350',
        '1094355', '1099659', '1101446', '1112864', '1116173', '1190580', '1190600', '1190738',
        '1190748', '1234386', '1234941', '1248057', '1250907', '1250983', '1293239', '1294557',
        '1297517', '1298433', '1356797', '1356807', '1363513', '1375948', '1440003', '1441376',
        '1441392', '1441831', '1492052', '1536840', '1550957', '1551286', '1593110', '1595631',
        '1661319', '1664543', '1666116', '1730190', '197447', '197930', '198165', '238090',
        '238133', '240826', '308170', '312289', '312914', '313406', '318179', '402250', '700851',
        '749850', '860771', '861578', '889614', '968670', '991042', '991486', '991528', '994226',
        '994237', '994521', '996757', '998726'
    }


class MeaslesMumpsAndRubellaMmrVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent measles, mumps and rubella (MMR) vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with all relevant measles, mumps and rubella (MMR) Vaccine codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1224'
    VALUE_SET_NAME = 'Measles, Mumps and Rubella (MMR) Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'03', '94'}


class DisseminatedChorioretinitisAndDisseminatedRetinochoroiditis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of disseminated chorioretinitis and/or retinochoroiditis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of disseminated chorioretinal inflammation, disseminated retinochoroiditis, and placoid pigment epitheliopathy.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1459'
    VALUE_SET_NAME = 'Disseminated Chorioretinitis and Disseminated Retinochoroiditis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A1853', 'H30101', 'H30102', 'H30103', 'H30111', 'H30112', 'H30113', 'H30121', 'H30122',
        'H30123', 'H30131', 'H30132', 'H30133', 'H30141', 'H30142', 'H30143'
    }

    ICD9CM = {'36310', '36311', '36312', '36313', '36314', '36315'}

    SNOMEDCT = {
        '14894002', '193442009', '193443004', '193444005', '371099005', '48225000', '51579006',
        '61517002', '69811008', '77939001', '78769001'
    }


class BoneScan(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent bone scan diagnostic imaging.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnostic Study.
    Inclusion Criteria: Includes only relevant concepts associated with conventional technetium-99m-MDP bone scan as well as 18F-NaF PET (or PET/CT) scan.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.320'
    VALUE_SET_NAME = 'Bone Scan'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '25031-6', '25032-4', '39627-5', '39812-3', '39813-1', '39816-4', '39818-0', '39819-8',
        '39820-6', '39858-6', '39879-2', '39880-0', '39881-8', '39882-6', '39883-4', '39884-2',
        '39901-4', '39902-2', '39904-8', '39905-5', '41772-5', '41836-8', '42700-5', '44142-8',
        '81551-4', '81552-2'
    }


class PeritonealDialysis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the administration of peritoneal dialysis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with the administration of peritoneal dialysis.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1084'
    VALUE_SET_NAME = 'Peritoneal Dialysis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '90945', '90947', '90951', '90952', '90953', '90954', '90955', '90956', '90957', '90958',
        '90959', '90960', '90961', '90962', '90963', '90964', '90965', '90966', '90967', '90968',
        '90969', '90970'
    }

    SNOMEDCT = {
        '14684005', '225230008', '238318009', '238319001', '238321006', '238322004', '238323009',
        '428648006', '676002', '71192002'
    }


class PregnancyTest(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent urine, serum, or plasma pregnancy tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Order.
    Inclusion Criteria: Includes only relevant concepts associated with conducting a pregnancy test. This is a grouping of LOINC codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1011'
    VALUE_SET_NAME = 'Pregnancy Test'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '19080-1', '19180-9', '20415-6', '20994-0', '2106-3', '2107-1', '2110-5', '2111-3',
        '2112-1', '2113-9', '2114-7', '2115-4', '2118-8', '2119-6', '21198-7', '25372-4',
        '25373-2', '34670-0', '45194-8', '55869-2', '55870-0', '56497-1', '80384-1', '83086-9'
    }


class KneeReplacementSurgery(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent total knee replacement procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients who have a total knee replacement procedure.
    Inclusion Criteria: Includes only relevant concepts associated with surgical procedure of a total knee replacement.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.261'
    VALUE_SET_NAME = 'Knee Replacement Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '0QPD0JZ', '0QPF0JZ', '0QRD0JZ', '0QRF0JZ', '0QUD0JZ', '0QUF0JZ', '0SPC09Z', '0SPC0JC',
        '0SPC0JZ', '0SPD09Z', '0SPD0JC', '0SPD0JZ', '0SPT0JZ', '0SPU0JZ', '0SPV0JZ', '0SPW0JZ',
        '0SRC07Z', '0SRC0J9', '0SRC0JA', '0SRC0JZ', '0SRC0KZ', '0SRC0L9', '0SRC0LA', '0SRC0LZ',
        '0SRD07Z', '0SRD0J9', '0SRD0JA', '0SRD0JZ', '0SRD0KZ', '0SRD0L9', '0SRD0LA', '0SRD0LZ',
        '0SRT07Z', '0SRT0J9', '0SRT0JA', '0SRT0JZ', '0SRT0KZ', '0SRU07Z', '0SRU0J9', '0SRU0JA',
        '0SRU0JZ', '0SRU0KZ', '0SRV07Z', '0SRV0J9', '0SRV0JA', '0SRV0JZ', '0SRV0KZ', '0SRW07Z',
        '0SRW0J9', '0SRW0JA', '0SRW0JZ', '0SRW0KZ', '0SUC07Z', '0SUC09C', '0SUC09Z', '0SUC0JZ',
        '0SUC0KZ', '0SUD07Z', '0SUD09C', '0SUD09Z', '0SUD0JZ', '0SUD0KZ', '0SUT09Z', '0SUU09Z',
        '0SUV09Z', '0SUW09Z', '0SWC09Z', '0SWC0JC', '0SWC0JZ', '0SWD09Z', '0SWD0JC', '0SWD0JZ',
        '0SWT0JZ', '0SWU0JZ', '0SWV0JZ', '0SWW0JZ'
    }

    SNOMEDCT = {
        '179344006', '179345007', '179351002', '179352009', '179406003', '179411001', '179416006',
        '265170009', '265172001', '27748003', '29712008', '430698003', '443543000', '443658004',
        '443681002', '443682009', '445091006', '88056004', '90827004'
    }


class GraduatedCompressionStockingsGcs(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent graduated compression stocking devices that are used to prevent VTEs in patients.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Device. The intent of this data element is to identify patients who have a graduated compression stocking device applied. It may also be used to identify patients who did not have a graduated compression stocking device applied for VTE prophylaxis for an allowable reason when used with a negation rationale attribute.
    Inclusion Criteria: Includes only relevant concepts associated with graduated compression stockings.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.256'
    VALUE_SET_NAME = 'Graduated compression stockings (GCS)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '348681001', '401621005', '401622003', '401623008', '401624002', '401625001', '401626000',
        '401627009', '401628004', '401629007', '401630002', '401631003', '401632005', '401633000',
        '401634006', '401635007', '401636008', '401637004', '401638009', '401639001', '401640004',
        '401641000', '401642007', '401643002', '401644008', '401645009', '401646005', '401647001',
        '401648006', '401649003', '401650003', '401651004', '401652006', '401653001', '401654007',
        '401655008', '401656009', '401657000', '401776005', '401777001', '401778006', '408127000',
        '408128005', '408129002', '408130007', '408131006', '408132004'
    }


class Principal(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the qualifier value used to identify the term principal.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Ordinality.
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT codes that define the principal qualifier value.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.14'
    VALUE_SET_NAME = 'Principal'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'63161005'}


class EncounterInfluenza(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent visits during which an influenza vaccine may be administered.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with face-to-face encounters during which an influenza vaccine may be administered.
    Exclusion Criteria: Excludes telehealth encounters.
    """

    OID = '2.16.840.1.113883.3.526.3.1252'
    VALUE_SET_NAME = 'Encounter-Influenza'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245', '99304', '99305', '99306', '99307', '99308', '99309',
        '99310', '99315', '99316', '99324', '99325', '99326', '99327', '99328', '99334', '99335',
        '99336', '99337', '99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349',
        '99350', '99381', '99382', '99383', '99384', '99385', '99386', '99387', '99391', '99392',
        '99393', '99394', '99395', '99396', '99397', '99401', '99402', '99403', '99404', '99411',
        '99412', '99429'
    }

    HCPCS = {'G0438', 'G0439'}

    SNOMEDCT = {
        '17436001', '18170008', '185460008', '185462000', '185463005', '185464004', '185465003',
        '185466002', '185467006', '185468001', '185470005', '207195004', '209099002', '210098006',
        '225929007', '281036007', '30346009', '315205008', '3391000175108', '37894004',
        '439708006', '439740005', '698704008', '704126008', '77406008'
    }


class ConsultantReport(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent consultant reports.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Communication.
    Inclusion Criteria: Includes only relevant concepts associated with written consultant reports.
    Exclusion Criteria: Excludes reports that are conducted via telephone calls or verbal communication.
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1006'
    VALUE_SET_NAME = 'Consultant Report'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '11488-4', '34099-2', '34100-8', '34101-6', '34102-4', '34103-2', '34104-0', '34749-2',
        '34756-7', '34758-3', '34760-9', '34761-7', '34764-1', '34776-5', '34777-3', '34779-9',
        '34781-5', '34783-1', '34785-6', '34788-0', '34791-4', '34795-5', '34797-1', '34798-9',
        '34800-3', '34803-7', '34805-2', '34807-8', '34810-2', '34812-8', '34814-4', '34816-9',
        '34820-1', '34822-7', '34824-3', '34826-8', '34828-4', '34831-8', '34833-4', '34837-5',
        '34839-1', '34841-7', '34845-8', '34847-4', '34849-0', '34851-6', '34853-2', '34855-7',
        '34879-7', '51845-6', '51846-4', '51854-8', '60570-9', '64056-5', '64068-0', '64072-2',
        '64076-3', '64080-5', '68469-6', '68486-0', '68551-1', '68566-9', '68570-1', '68575-0',
        '68586-7', '68590-9', '68597-4', '68619-6', '68633-7', '68639-4', '68648-5', '68651-9',
        '68661-8', '68670-9', '68681-6', '68685-7', '68694-9', '68705-3', '68716-0', '68727-7',
        '68746-7', '68757-4', '68765-7', '68787-1', '68802-8', '68812-7', '68821-8', '68837-4',
        '68846-5', '68852-3', '68864-8', '68869-7', '68874-7', '68879-6', '68892-9', '68897-8',
        '72555-6', '73575-3', '75424-2', '75465-5', '77403-4', '77429-9', '78250-8', '78251-6',
        '78252-4', '78253-2', '78254-0', '78405-8', '78406-6', '78496-7', '78498-3', '78567-5',
        '78568-3', '78726-7', '78732-5', '78738-2', '79428-9', '80396-5', '80575-4', '80664-6',
        '80666-1', '80673-7', '80736-2', '80801-4', '81191-9', '81192-7', '81193-5', '81196-8',
        '82356-7', '82359-1', '83570-2', '83578-5', '83609-8', '83621-3', '83653-6', '83685-8',
        '83720-3', '83722-9', '83868-0', '83873-0', '83888-8', '83909-2', '83912-6', '83926-6',
        '83931-6', '83941-5', '83960-5', '83967-0', '83984-5', '83992-8', '83996-9', '84035-5',
        '84071-0', '84115-5', '84126-2', '84131-2', '84142-9', '84145-2', '84152-8', '84173-4',
        '84190-8', '84213-8', '84231-0', '84241-9', '84280-7', '84292-2', '84303-7', '84312-8',
        '84324-3', '84349-0', '84352-4', '84358-1', '84394-6', '84398-7', '85174-1', '85208-7',
        '85222-8', '85232-7', '85237-6', '85238-4', '85517-1', '85519-7', '85866-2', '85871-2',
        '85882-9', '85884-5', '85886-0', '85890-2', '85899-3', '86451-2', '87233-3', '87254-9',
        '87627-6'
    }

    SNOMEDCT = {'371530004', '371531000', '371545006'}


class VascularAccessForDialysis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures related to accessing the vascular system for dialysis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with procedures related to accessing the vascular system for dialysis such as inserting a needle or catheter or creating a shunt. This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1011'
    VALUE_SET_NAME = 'Vascular Access for Dialysis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '36147', '36148', '36800', '36810', '36815', '36818', '36819', '36820', '36821', '36831',
        '36832', '36833'
    }

    SNOMEDCT = {
        '180272001', '180277007', '225892009', '22800003', '233468004', '233471007', '233472000',
        '233547003', '238314006', '238315007', '271418008', '34163007', '426340003', '427992007',
        '428118009', '431418000', '431440009', '431781000', '432509002', '432654009', '434435000',
        '438341004', '438342006', '439241008', '439322008', '439349008', '439534001', '443683004',
        '448591002', '449400003', '450865002', '54817007', '61160002', '61740001', '63421002',
        '676002', '69380006', '736919006', '736922008', '7459007', '79827002', '80634002'
    }


class BmiRatio(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a body mass index (BMI) ratio.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with or related to BMI ratio.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1490'
    VALUE_SET_NAME = 'BMI Ratio'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'39156-5'}


class TobaccoUser(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent tobacco user status.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute.
    Inclusion Criteria: Includes only relevant concepts associated with indicating a patient uses tobacco products, including smoking and smoke-less tobacco products such as chew, snuff, pipe, cigarette, cigar, etc.
    Exclusion Criteria: Excludes concepts that may indicate a current tobacco non-user status.
    """

    OID = '2.16.840.1.113883.3.526.3.1170'
    VALUE_SET_NAME = 'Tobacco User'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '110483000', '160603005', '160604004', '160605003', '160606002', '160619003', '228494002',
        '228499007', '228504007', '228514003', '228515002', '228516001', '228517005', '228518000',
        '230059006', '230060001', '230062009', '230063004', '230064005', '230065006', '266920004',
        '428041000124106', '428061000124105', '428071000124103', '43381005', '449867007',
        '449868002', '449869005', '450811000124104', '450821000124107', '56578002', '56771006',
        '59978006', '65568007', '713914004', '77176002', '81703003', '82302008'
    }


class Butabarbital(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent butabarbital medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; butabarbital only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; butabarbital in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1402'
    VALUE_SET_NAME = 'Butabarbital'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1251614', '1251621'}


class AcetaminophenDextromethorphanDoxylaminePhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / dextromethorphan / doxylamine / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / dextromethorphan / doxylamine / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / dextromethorphan / doxylamine / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1287'
    VALUE_SET_NAME = 'Acetaminophen / Dextromethorphan / Doxylamine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1233546', '1297288', '1297404', '1492380', '1536999', '1546881'}


class RenalFailureDueToAceInhibitor(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of renal failure due to Angiotensin converting enzyme (ACE) inhibitor.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of renal failure due to ACE inhibitor.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1151'
    VALUE_SET_NAME = 'Renal Failure Due to ACE Inhibitor'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'236429004', '422593004'}


class PreventiveCareServicesOther(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent unlisted preventive medicine services.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with unlisted preventive medicine services. This is a grouping of a CPT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1030'
    VALUE_SET_NAME = 'Preventive Care Services - Other'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99429'}


class Cd4Count(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent CD4  count laboratory tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with codes that identify CD4  counts with a count/vol observation or CD3 CD4  (T4 helper) cells [#/volume]. This is a grouping of LOINC codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1004'
    VALUE_SET_NAME = 'CD4  Count'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'24467-3', '32515-9', '32532-4', '40898-9', '63450-1'}


class AcetaminophenDiphenhydramine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / diphenhydramine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / diphenhydramine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / diphenhydramine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1350'
    VALUE_SET_NAME = 'Acetaminophen / Diphenhydramine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1052462', '1052467', '1087607', '1092189', '1092373', '1099872', '1117245', '1297947'
    }


class HereditaryRetinalDystrophies(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of hereditary retinal dystrophies.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of hereditary retinal or vitreoretinal dystrophies, including Usher syndrome.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1463'
    VALUE_SET_NAME = 'Hereditary Retinal Dystrophies'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H3550', 'H3551', 'H3552', 'H3553', 'H3554', 'H36'}

    ICD9CM = {'36270', '36271', '36272', '36273', '36274', '36275', '36276'}

    SNOMEDCT = {
        '15059000', '192788009', '193400007', '193409008', '193415008', '232052009', '232053004',
        '232056007', '232057003', '232058008', '267613004', '28835009', '312917007', '313003009',
        '41799005', '57838006', '764939004', '79556007', '80328002'
    }


class AceInhibitorOrArb(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent angiotensin-converting enzyme (ACE) inhibitor and angiotensin-receptor blocker (ARB) therapies.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs concepts associated with component, form and strength); generic; prescribable; ACE inhibitor, ARB therapy, combination drugs such as ACEI plus diuretic, ARB plus neprilysin inhibitor (ARNI
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable.
    """

    OID = '2.16.840.1.113883.3.526.3.1139'
    VALUE_SET_NAME = 'ACE Inhibitor or ARB'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1000001', '1091646', '1091652', '1235144', '1235151', '1299859', '1299871', '1299890',
        '1299896', '1299897', '1435624', '153822', '153823', '1600716', '1600724', '1600728',
        '1656340', '1656349', '1656354', '197436', '197437', '197438', '197439', '197884',
        '197885', '197886', '197887', '198188', '198189', '199351', '199352', '199353', '199622',
        '199707', '199708', '199709', '199816', '199817', '199937', '200094', '200095', '200096',
        '200284', '200285', '205304', '205305', '205326', '249851', '261962', '282755', '283316',
        '283317', '308962', '308963', '308964', '310140', '310792', '310793', '310796', '310797',
        '310809', '311353', '311354', '312748', '312749', '312750', '314076', '314077', '314203',
        '317173', '349199', '349200', '349201', '349353', '349373', '349401', '349405', '349483',
        '351292', '351293', '403853', '403854', '403855', '411434', '477130', '485471', '577776',
        '578325', '578330', '636042', '636045', '639537', '722126', '722131', '722134', '722137',
        '730861', '730866', '730869', '730872', '802749', '845488', '848131', '848135', '848140',
        '848145', '848151', '854925', '854984', '854988', '857166', '857169', '857174', '857183',
        '857187', '858804', '858810', '858813', '858817', '858824', '858828', '858921', '876514',
        '876519', '876524', '876529', '897781', '897783', '897844', '897853', '898342', '898346',
        '898350', '898353', '898356', '898359', '898362', '898367', '898372', '898378', '898687',
        '898690', '898719', '898723', '979464', '979468', '979471', '979480', '979485', '979492',
        '999967', '999986', '999991', '999996'
    }


class EmergencyDepartmentVisit(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have had an interaction with a member of their medical care team in the emergency department.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with care provided to new and established patients in the emergency department. This is a value set grouping that includes CPT and SNOMED CT codes.
    Exclusion Criteria: Excludes services not performed in the emergency department, including critical care and observation services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1010'
    VALUE_SET_NAME = 'Emergency Department Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99281', '99282', '99283', '99284', '99285'}

    SNOMEDCT = {'4525004'}


class DepressionMedicationsAdult(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent medications that are commonly used to treat adult depression.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with antidepressant medications as well as other recommended depressive management medications, specific to the adult age group, for depression management.
    Exclusion Criteria: Excludes medications that are not commonly used in the treatment of depression in the adult age group.
    """

    OID = '2.16.840.1.113883.3.600.470'
    VALUE_SET_NAME = 'Depression medications - adult'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1000048', '1000054', '1000058', '1000064', '1000070', '1000076', '1000097', '103968',
        '1086772', '1086778', '1086784', '1086789', '1098608', '1098649', '1098666', '1098670',
        '1098674', '1098678', '1099288', '1099292', '1099296', '1099300', '1099304', '1099316',
        '1146690', '1190110', '1232585', '1298857', '1298861', '1298870', '1738483', '1738495',
        '1738503', '1738511', '1738515', '1738519', '1738523', '1738527', '1738803', '1738805',
        '1738807', '197363', '197364', '197365', '197366', '198045', '198046', '198047', '198427',
        '198428', '198429', '198430', '199283', '200371', '248642', '251200', '252478', '252479',
        '282401', '283406', '283407', '283485', '283672', '309313', '309314', '310384', '310385',
        '310386', '311264', '311265', '311725', '311726', '312036', '312242', '312347', '312938',
        '312940', '312941', '313447', '313496', '313498', '313499', '313580', '313581', '313582',
        '313583', '313584', '313585', '313586', '313989', '313990', '313995', '314111', '314277',
        '317136', '349010', '349332', '351249', '351250', '351285', '410503', '476809', '485514',
        '596926', '596930', '596934', '751139', '751563', '753451', '790264', '790288', '794947',
        '808744', '808748', '808751', '808753', '835564', '835568', '835572', '835577', '835589',
        '835591', '835593', '850087', '850091', '851748', '851750', '851752', '856364', '856369',
        '856373', '856377', '856706', '856720', '856762', '856769', '856773', '856783', '856792',
        '856797', '856825', '856834', '856840', '856845', '856853', '857291', '857296', '857297',
        '857301', '857305', '857315', '859186', '859190', '859193', '861064', '865206', '865210',
        '865214', '898697', '898704', '900156', '900164', '900865', '900890', '900983', '903873',
        '903879', '903884', '903887', '903891', '905168', '905172', '966787', '966793', '993503',
        '993518', '993536', '993541', '993550', '993557', '993567', '993681', '993687', '993691'
    }


class GenitalHerpes(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent genital herpes infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with female genital herpes infections. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes codes that indicate male genital herpes infections.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1049'
    VALUE_SET_NAME = 'Genital Herpes'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'A6000', 'A6003', 'A6004', 'A6009'}

    SNOMEDCT = {
        '129670002', '27420004', '278068003', '33839006', '402888002', '402890001', '402894005',
        '402896007', '423391007', '427578006', '439912007', '439913002', '440714005', '59819007'
    }


class PsoriaticArthritis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of psoriatic arthritis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with psoriatic arthritis, arthritis mutilans, psoriatic spondylitis, and other unspecified psoriatic arthropathy. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes diagnosis codes for juvenile psoriatic arthritis and dactylitis.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1046'
    VALUE_SET_NAME = 'Psoriatic Arthritis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'L4050', 'L4051', 'L4052', 'L4053', 'L4059'}

    ICD9CM = {'6960'}

    SNOMEDCT = {'200956002', '239812005', '33339001', '410482007'}


class DienogestEstradiolMultiphasic(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dienogest / estradiol multiphasic combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dienogest / estradiol multiphasic (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dienogest / estradiol multiphasic in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1398'
    VALUE_SET_NAME = 'Dienogest / Estradiol Multiphasic'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'978944', '978946'}


class IntoleranceToAceInhibitorOrArb(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of intolerance to angiotensin-converting enzyme (ACE) inhibitor or angiotensin II receptor blockers (ARB).
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of intolerance to ACE inhibitor or ARB.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1212'
    VALUE_SET_NAME = 'Intolerance to ACE Inhibitor or ARB'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '293500009', '293501008', '293502001', '293503006', '293504000', '293505004', '293506003',
        '293507007', '293508002', '293509005', '293513003', '371627004', '407564000', '407565004',
        '407590002', '422593004'
    }


class PositiveFinding(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent positive test results. This is intended to be paired with other concepts that identify specific medical tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Result.
    Inclusion Criteria: Includes only relevant concepts associated with identifying a positive test result.
    Exclusion Criteria: Excludes concepts that identify a specific type of medical test.
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1016'
    VALUE_SET_NAME = 'Positive Finding'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'441773004'}


class TobaccoUseCessationCounseling(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent various tobacco cessation counseling interventions.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with various cessation interventions which may include referral to tobacco-related services or providers, education about the benefits of stopping tobacco use, education about the negative side effects of using tobacco, and monitoring for tobacco cessation.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.509'
    VALUE_SET_NAME = 'Tobacco Use Cessation Counseling'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99406', '99407'}

    SNOMEDCT = {
        '171055003', '185795007', '185796008', '225323000', '225324006', '310429001', '315232003',
        '384742004', '395700008', '449841000124108', '449851000124105', '449861000124107',
        '449871000124100', '702388001', '710081004', '711028002', '713700008'
    }


class SpeechAndHearingEvaluation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent visits for speech and hearing evaluation.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with evaluation of speech and/or hearing related abilities.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1530'
    VALUE_SET_NAME = 'Speech and Hearing Evaluation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'92521', '92522', '92523', '92524', '92540', '92557', '92625'}

    SNOMEDCT = {'26342005', '41375007', '77837000', '91515000'}


class BrompheniramineDextromethorphanPhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent brompheniramine / dextromethorphan / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; brompheniramine / codeine / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; brompheniramine / codeine / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1325'
    VALUE_SET_NAME = 'Brompheniramine / Dextromethorphan / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1090463', '1148155', '1304105', '1423702', '1486964'}


class InfluenzaVaccine_1254(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent influenza vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Immunization.
    Inclusion Criteria: Includes only relevant concepts associated with CVX concepts related to influenza vaccines.
    Exclusion Criteria: Excludes HCPCS, SNOMED CT and CPT influenza vaccine codes.
    """

    OID = '2.16.840.1.113883.3.526.3.1254'
    VALUE_SET_NAME = 'Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {
        '135', '140', '141', '144', '150', '155', '158', '161', '166', '168', '171', '185', '186',
        '88'
    }


class FluorideVarnishApplicationForChildren(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a fluoride varnish application.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who received a fluoride varnish application.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.125.12.1002'
    VALUE_SET_NAME = 'Fluoride Varnish Application for Children'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CDT = {'D1206', 'D1208'}

    CPT = {'99188'}

    SNOMEDCT = {'234723000', '313042009', '35889000', '70468009'}


class PervasiveDevelopmentalDisorder(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of autistic disorder, other childhood disintegrative disorder or other pervasive developmental disorder.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients with a diagnosis of autistic disorder, other childhood disintegrative disorder or other pervasive developmental disorder. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT concepts.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.105.12.1152'
    VALUE_SET_NAME = 'Pervasive Developmental Disorder'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'F840', 'F843', 'F848', 'F849'}

    ICD9CM = {'29900', '29901', '29910', '29911', '29980', '29981', '29990', '29991'}

    SNOMEDCT = {
        '191689008', '191690004', '231536004', '35919005', '373618009', '39951000119105',
        '408856003', '408857007', '43614003', '442314000', '71961003'
    }


class PurulentEndophthalmitis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of purulent endophthalmitis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of purulent endophthalmitis, panophthalmitis, vitreous abscess, and other types of endophthalmitis.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1477'
    VALUE_SET_NAME = 'Purulent Endophthalmitis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H44001', 'H44002', 'H44003', 'H44011', 'H44012', 'H44013', 'H44021', 'H44022', 'H44023'
    }

    ICD9CM = {'36000', '36001', '36002', '36003', '36004'}

    SNOMEDCT = {
        '13978000', '1493002', '15678441000119103', '15678481000119108', '1833005', '1847009',
        '314544008', '314545009', '314546005', '314547001', '314548006', '410495002', '410496001',
        '410497005', '413583003', '413626002', '413665004', '413746000', '414303007', '414491002',
        '415182001', '415584007', '415737009', '416296007', '41720003'
    }


class Right(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the right side of the body.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Anatomical Location Site.
    Inclusion Criteria: Includes only relevant concepts associated with the right side of the body. This is a grouping of SNOMED CT codes.
    Exclusion Criteria: Excludes concepts representing the left side of the body.
    """

    OID = '2.16.840.1.113883.3.464.1003.122.12.1035'
    VALUE_SET_NAME = 'Right'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'24028007', '419465000'}


class Cancer(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a cancer diagnosis.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with cancer diagnoses.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1010'
    VALUE_SET_NAME = 'Cancer'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'C000', 'C001', 'C002', 'C003', 'C004', 'C005', 'C006', 'C008', 'C009', 'C01', 'C020',
        'C021', 'C022', 'C023', 'C024', 'C028', 'C029', 'C030', 'C031', 'C039', 'C040', 'C041',
        'C048', 'C049', 'C050', 'C051', 'C052', 'C058', 'C059', 'C060', 'C061', 'C062', 'C0680',
        'C0689', 'C069', 'C07', 'C080', 'C081', 'C089', 'C090', 'C091', 'C098', 'C099', 'C100',
        'C101', 'C102', 'C103', 'C104', 'C108', 'C109', 'C110', 'C111', 'C112', 'C113', 'C118',
        'C119', 'C12', 'C130', 'C131', 'C132', 'C138', 'C139', 'C140', 'C142', 'C148', 'C153',
        'C154', 'C155', 'C158', 'C159', 'C160', 'C161', 'C162', 'C163', 'C164', 'C165', 'C166',
        'C168', 'C169', 'C170', 'C171', 'C172', 'C173', 'C178', 'C179', 'C180', 'C181', 'C182',
        'C183', 'C184', 'C185', 'C186', 'C187', 'C188', 'C189', 'C19', 'C20', 'C210', 'C211',
        'C212', 'C218', 'C220', 'C221', 'C222', 'C223', 'C224', 'C227', 'C228', 'C229', 'C23',
        'C240', 'C241', 'C248', 'C249', 'C250', 'C251', 'C252', 'C253', 'C254', 'C257', 'C258',
        'C259', 'C260', 'C261', 'C269', 'C300', 'C301', 'C310', 'C311', 'C312', 'C313', 'C318',
        'C319', 'C320', 'C321', 'C322', 'C323', 'C328', 'C329', 'C33', 'C3400', 'C3401', 'C3402',
        'C3410', 'C3411', 'C3412', 'C342', 'C3430', 'C3431', 'C3432', 'C3480', 'C3481', 'C3482',
        'C3490', 'C3491', 'C3492', 'C37', 'C380', 'C381', 'C382', 'C383', 'C384', 'C388', 'C390',
        'C399', 'C4000', 'C4001', 'C4002', 'C4010', 'C4011', 'C4012', 'C4020', 'C4021', 'C4022',
        'C4030', 'C4031', 'C4032', 'C4080', 'C4081', 'C4082', 'C4090', 'C4091', 'C4092', 'C410',
        'C411', 'C412', 'C413', 'C414', 'C419', 'C430', 'C4310', 'C4311', 'C43111', 'C43112',
        'C4312', 'C43121', 'C43122', 'C4320', 'C4321', 'C4322', 'C4330', 'C4331', 'C4339', 'C434',
        'C4351', 'C4352', 'C4359', 'C4360', 'C4361', 'C4362', 'C4370', 'C4371', 'C4372', 'C438',
        'C439', 'C4400', 'C4401', 'C4402', 'C4409', 'C44101', 'C44102', 'C441021', 'C441022',
        'C44109', 'C441091', 'C441092', 'C44111', 'C44112', 'C441121', 'C441122', 'C44119',
        'C441191', 'C441192', 'C44121', 'C44122', 'C441221', 'C441222', 'C44129', 'C441291',
        'C441292', 'C44131', 'C441321', 'C441322', 'C441391', 'C441392', 'C44191', 'C44192',
        'C441921', 'C441922', 'C44199', 'C441991', 'C441992', 'C44201', 'C44202', 'C44209',
        'C44211', 'C44212', 'C44219', 'C44221', 'C44222', 'C44229', 'C44291', 'C44292', 'C44299',
        'C44300', 'C44301', 'C44309', 'C44310', 'C44311', 'C44319', 'C44320', 'C44321', 'C44329',
        'C44390', 'C44391', 'C44399', 'C4440', 'C4441', 'C4442', 'C4449', 'C44500', 'C44501',
        'C44509', 'C44510', 'C44511', 'C44519', 'C44520', 'C44521', 'C44529', 'C44590', 'C44591',
        'C44599', 'C44601', 'C44602', 'C44609', 'C44611', 'C44612', 'C44619', 'C44621', 'C44622',
        'C44629', 'C44691', 'C44692', 'C44699', 'C44701', 'C44702', 'C44709', 'C44711', 'C44712',
        'C44719', 'C44721', 'C44722', 'C44729', 'C44791', 'C44792', 'C44799', 'C4480', 'C4481',
        'C4482', 'C4489', 'C4490', 'C4491', 'C4492', 'C4499', 'C450', 'C451', 'C452', 'C457',
        'C459', 'C460', 'C461', 'C462', 'C463', 'C464', 'C4650', 'C4651', 'C4652', 'C467', 'C469',
        'C470', 'C4710', 'C4711', 'C4712', 'C4720', 'C4721', 'C4722', 'C473', 'C474', 'C475',
        'C476', 'C478', 'C479', 'C480', 'C481', 'C482', 'C488', 'C490', 'C4910', 'C4911', 'C4912',
        'C4920', 'C4921', 'C4922', 'C493', 'C494', 'C495', 'C496', 'C498', 'C499', 'C49A0',
        'C49A1', 'C49A2', 'C49A3', 'C49A4', 'C49A5', 'C49A9', 'C4A0', 'C4A10', 'C4A11', 'C4A111',
        'C4A112', 'C4A12', 'C4A121', 'C4A122', 'C4A20', 'C4A21', 'C4A22', 'C4A30', 'C4A31',
        'C4A39', 'C4A4', 'C4A51', 'C4A52', 'C4A59', 'C4A60', 'C4A61', 'C4A62', 'C4A70', 'C4A71',
        'C4A72', 'C4A8', 'C4A9', 'C50011', 'C50012', 'C50019', 'C50021', 'C50022', 'C50029',
        'C50111', 'C50112', 'C50119', 'C50121', 'C50122', 'C50129', 'C50211', 'C50212', 'C50219',
        'C50221', 'C50222', 'C50229', 'C50311', 'C50312', 'C50319', 'C50321', 'C50322', 'C50329',
        'C50411', 'C50412', 'C50419', 'C50421', 'C50422', 'C50429', 'C50511', 'C50512', 'C50519',
        'C50521', 'C50522', 'C50529', 'C50611', 'C50612', 'C50619', 'C50621', 'C50622', 'C50629',
        'C50811', 'C50812', 'C50819', 'C50821', 'C50822', 'C50829', 'C50911', 'C50912', 'C50919',
        'C50921', 'C50922', 'C50929', 'C510', 'C511', 'C512', 'C518', 'C519', 'C52', 'C530',
        'C531', 'C538', 'C539', 'C540', 'C541', 'C542', 'C543', 'C548', 'C549', 'C55', 'C561',
        'C562', 'C569', 'C5700', 'C5701', 'C5702', 'C5710', 'C5711', 'C5712', 'C5720', 'C5721',
        'C5722', 'C573', 'C574', 'C577', 'C578', 'C579', 'C58', 'C600', 'C601', 'C602', 'C608',
        'C609', 'C61', 'C6200', 'C6201', 'C6202', 'C6210', 'C6211', 'C6212', 'C6290', 'C6291',
        'C6292', 'C6300', 'C6301', 'C6302', 'C6310', 'C6311', 'C6312', 'C632', 'C637', 'C638',
        'C639', 'C641', 'C642', 'C649', 'C651', 'C652', 'C659', 'C661', 'C662', 'C669', 'C670',
        'C671', 'C672', 'C673', 'C674', 'C675', 'C676', 'C677', 'C678', 'C679', 'C680', 'C681',
        'C688', 'C689', 'C6900', 'C6901', 'C6902', 'C6910', 'C6911', 'C6912', 'C6920', 'C6921',
        'C6922', 'C6930', 'C6931', 'C6932', 'C6940', 'C6941', 'C6942', 'C6950', 'C6951', 'C6952',
        'C6960', 'C6961', 'C6962', 'C6980', 'C6981', 'C6982', 'C6990', 'C6991', 'C6992', 'C700',
        'C701', 'C709', 'C710', 'C711', 'C712', 'C713', 'C714', 'C715', 'C716', 'C717', 'C718',
        'C719', 'C720', 'C721', 'C7220', 'C7221', 'C7222', 'C7230', 'C7231', 'C7232', 'C7240',
        'C7241', 'C7242', 'C7250', 'C7259', 'C729', 'C73', 'C7400', 'C7401', 'C7402', 'C7410',
        'C7411', 'C7412', 'C7490', 'C7491', 'C7492', 'C750', 'C751', 'C752', 'C753', 'C754',
        'C755', 'C758', 'C759', 'C760', 'C761', 'C762', 'C763', 'C7640', 'C7641', 'C7642', 'C7650',
        'C7651', 'C7652', 'C768', 'C770', 'C771', 'C772', 'C773', 'C774', 'C775', 'C778', 'C779',
        'C7800', 'C7801', 'C7802', 'C781', 'C782', 'C7830', 'C7839', 'C784', 'C785', 'C786',
        'C787', 'C7880', 'C7889', 'C7900', 'C7901', 'C7902', 'C7910', 'C7911', 'C7919', 'C792',
        'C7931', 'C7932', 'C7940', 'C7949', 'C7951', 'C7952', 'C7960', 'C7961', 'C7962', 'C7970',
        'C7971', 'C7972', 'C7981', 'C7982', 'C7989', 'C799', 'C7A00', 'C7A010', 'C7A011', 'C7A012',
        'C7A019', 'C7A020', 'C7A021', 'C7A022', 'C7A023', 'C7A024', 'C7A025', 'C7A026', 'C7A029',
        'C7A090', 'C7A091', 'C7A092', 'C7A093', 'C7A094', 'C7A095', 'C7A096', 'C7A098', 'C7A1',
        'C7A8', 'C7B00', 'C7B01', 'C7B02', 'C7B03', 'C7B04', 'C7B09', 'C7B1', 'C7B8', 'C800',
        'C801', 'C802', 'C8100', 'C8101', 'C8102', 'C8103', 'C8104', 'C8105', 'C8106', 'C8107',
        'C8108', 'C8109', 'C8110', 'C8111', 'C8112', 'C8113', 'C8114', 'C8115', 'C8116', 'C8117',
        'C8118', 'C8119', 'C8120', 'C8121', 'C8122', 'C8123', 'C8124', 'C8125', 'C8126', 'C8127',
        'C8128', 'C8129', 'C8130', 'C8131', 'C8132', 'C8133', 'C8134', 'C8135', 'C8136', 'C8137',
        'C8138', 'C8139', 'C8140', 'C8141', 'C8142', 'C8143', 'C8144', 'C8145', 'C8146', 'C8147',
        'C8148', 'C8149', 'C8170', 'C8171', 'C8172', 'C8173', 'C8174', 'C8175', 'C8176', 'C8177',
        'C8178', 'C8179', 'C8190', 'C8191', 'C8192', 'C8193', 'C8194', 'C8195', 'C8196', 'C8197',
        'C8198', 'C8199', 'C8200', 'C8201', 'C8202', 'C8203', 'C8204', 'C8205', 'C8206', 'C8207',
        'C8208', 'C8209', 'C8210', 'C8211', 'C8212', 'C8213', 'C8214', 'C8215', 'C8216', 'C8217',
        'C8218', 'C8219', 'C8220', 'C8221', 'C8222', 'C8223', 'C8224', 'C8225', 'C8226', 'C8227',
        'C8228', 'C8229', 'C8230', 'C8231', 'C8232', 'C8233', 'C8234', 'C8235', 'C8236', 'C8237',
        'C8238', 'C8239', 'C8240', 'C8241', 'C8242', 'C8243', 'C8244', 'C8245', 'C8246', 'C8247',
        'C8248', 'C8249', 'C8250', 'C8251', 'C8252', 'C8253', 'C8254', 'C8255', 'C8256', 'C8257',
        'C8258', 'C8259', 'C8260', 'C8261', 'C8262', 'C8263', 'C8264', 'C8265', 'C8266', 'C8267',
        'C8268', 'C8269', 'C8280', 'C8281', 'C8282', 'C8283', 'C8284', 'C8285', 'C8286', 'C8287',
        'C8288', 'C8289', 'C8290', 'C8291', 'C8292', 'C8293', 'C8294', 'C8295', 'C8296', 'C8297',
        'C8298', 'C8299', 'C8300', 'C8301', 'C8302', 'C8303', 'C8304', 'C8305', 'C8306', 'C8307',
        'C8308', 'C8309', 'C8310', 'C8311', 'C8312', 'C8313', 'C8314', 'C8315', 'C8316', 'C8317',
        'C8318', 'C8319', 'C8330', 'C8331', 'C8332', 'C8333', 'C8334', 'C8335', 'C8336', 'C8337',
        'C8338', 'C8339', 'C8350', 'C8351', 'C8352', 'C8353', 'C8354', 'C8355', 'C8356', 'C8357',
        'C8358', 'C8359', 'C8370', 'C8371', 'C8372', 'C8373', 'C8374', 'C8375', 'C8376', 'C8377',
        'C8378', 'C8379', 'C8380', 'C8381', 'C8382', 'C8383', 'C8384', 'C8385', 'C8386', 'C8387',
        'C8388', 'C8389', 'C8390', 'C8391', 'C8392', 'C8393', 'C8394', 'C8395', 'C8396', 'C8397',
        'C8398', 'C8399', 'C8400', 'C8401', 'C8402', 'C8403', 'C8404', 'C8405', 'C8406', 'C8407',
        'C8408', 'C8409', 'C8410', 'C8411', 'C8412', 'C8413', 'C8414', 'C8415', 'C8416', 'C8417',
        'C8418', 'C8419', 'C8440', 'C8441', 'C8442', 'C8443', 'C8444', 'C8445', 'C8446', 'C8447',
        'C8448', 'C8449', 'C8460', 'C8461', 'C8462', 'C8463', 'C8464', 'C8465', 'C8466', 'C8467',
        'C8468', 'C8469', 'C8470', 'C8471', 'C8472', 'C8473', 'C8474', 'C8475', 'C8476', 'C8477',
        'C8478', 'C8479', 'C8490', 'C8491', 'C8492', 'C8493', 'C8494', 'C8495', 'C8496', 'C8497',
        'C8498', 'C8499', 'C84A0', 'C84A1', 'C84A2', 'C84A3', 'C84A4', 'C84A5', 'C84A6', 'C84A7',
        'C84A8', 'C84A9', 'C84Z0', 'C84Z1', 'C84Z2', 'C84Z3', 'C84Z4', 'C84Z5', 'C84Z6', 'C84Z7',
        'C84Z8', 'C84Z9', 'C8510', 'C8511', 'C8512', 'C8513', 'C8514', 'C8515', 'C8516', 'C8517',
        'C8518', 'C8519', 'C8520', 'C8521', 'C8522', 'C8523', 'C8524', 'C8525', 'C8526', 'C8527',
        'C8528', 'C8529', 'C8580', 'C8581', 'C8582', 'C8583', 'C8584', 'C8585', 'C8586', 'C8587',
        'C8588', 'C8589', 'C8590', 'C8591', 'C8592', 'C8593', 'C8594', 'C8595', 'C8596', 'C8597',
        'C8598', 'C8599', 'C860', 'C861', 'C862', 'C863', 'C864', 'C865', 'C866', 'C880', 'C882',
        'C883', 'C884', 'C888', 'C889', 'C9000', 'C9001', 'C9002', 'C9010', 'C9011', 'C9012',
        'C9020', 'C9021', 'C9022', 'C9030', 'C9031', 'C9032', 'C9100', 'C9101', 'C9102', 'C9110',
        'C9111', 'C9112', 'C9130', 'C9131', 'C9132', 'C9140', 'C9141', 'C9142', 'C9150', 'C9151',
        'C9152', 'C9160', 'C9161', 'C9162', 'C9190', 'C9191', 'C9192', 'C91A0', 'C91A1', 'C91A2',
        'C91Z0', 'C91Z1', 'C91Z2', 'C9200', 'C9201', 'C9202', 'C9210', 'C9211', 'C9212', 'C9220',
        'C9221', 'C9222', 'C9230', 'C9231', 'C9232', 'C9240', 'C9241', 'C9242', 'C9250', 'C9251',
        'C9252', 'C9260', 'C9261', 'C9262', 'C9290', 'C9291', 'C9292', 'C92A0', 'C92A1', 'C92A2',
        'C92Z0', 'C92Z1', 'C92Z2', 'C9300', 'C9301', 'C9302', 'C9310', 'C9311', 'C9312', 'C9330',
        'C9331', 'C9332', 'C9390', 'C9391', 'C9392', 'C93Z0', 'C93Z1', 'C93Z2', 'C9400', 'C9401',
        'C9402', 'C9420', 'C9421', 'C9422', 'C9430', 'C9431', 'C9432', 'C9440', 'C9441', 'C9442',
        'C946', 'C9480', 'C9481', 'C9482', 'C9500', 'C9501', 'C9502', 'C9510', 'C9511', 'C9512',
        'C9590', 'C9591', 'C9592', 'C960', 'C962', 'C9620', 'C9621', 'C9622', 'C9629', 'C964',
        'C965', 'C966', 'C969', 'C96A', 'C96Z', 'D3701', 'D3702', 'D37030', 'D37031', 'D37032',
        'D37039', 'D3704', 'D3705', 'D3709', 'D371', 'D372', 'D373', 'D374', 'D375', 'D376',
        'D378', 'D379', 'D380', 'D381', 'D382', 'D383', 'D384', 'D385', 'D386', 'D390', 'D3910',
        'D3911', 'D3912', 'D392', 'D398', 'D399', 'D400', 'D4010', 'D4011', 'D4012', 'D408',
        'D409', 'D4100', 'D4101', 'D4102', 'D4110', 'D4111', 'D4112', 'D4120', 'D4121', 'D4122',
        'D413', 'D414', 'D418', 'D419', 'D420', 'D421', 'D429', 'D430', 'D431', 'D432', 'D433',
        'D434', 'D438', 'D439', 'D440', 'D4410', 'D4411', 'D4412', 'D442', 'D443', 'D444', 'D445',
        'D446', 'D447', 'D449', 'D45', 'D460', 'D461', 'D4620', 'D4621', 'D4622', 'D464', 'D469',
        'D46A', 'D46B', 'D46C', 'D46Z', 'D470', 'D471', 'D472', 'D473', 'D474', 'D479', 'D47Z1',
        'D47Z2', 'D47Z9', 'D480', 'D481', 'D482', 'D483', 'D484', 'D485', 'D4860', 'D4861',
        'D4862', 'D487', 'D489', 'D490', 'D491', 'D492', 'D493', 'D494', 'D495', 'D49511',
        'D49512', 'D49519', 'D4959', 'D496', 'D497', 'D4981', 'D4989', 'D499', 'Q8500', 'Q8501',
        'Q8502', 'Q8503', 'Q8509'
    }

    ICD9CM = {
        '1400', '1401', '1403', '1404', '1405', '1406', '1408', '1409', '1410', '1411', '1412',
        '1413', '1414', '1415', '1416', '1418', '1419', '1420', '1421', '1422', '1428', '1429',
        '1430', '1431', '1438', '1439', '1440', '1441', '1448', '1449', '1450', '1451', '1452',
        '1453', '1454', '1455', '1456', '1458', '1459', '1460', '1461', '1462', '1463', '1464',
        '1465', '1466', '1467', '1468', '1469', '1470', '1471', '1472', '1473', '1478', '1479',
        '1480', '1481', '1482', '1483', '1488', '1489', '1490', '1491', '1498', '1499', '1500',
        '1501', '1502', '1503', '1504', '1505', '1508', '1509', '1510', '1511', '1512', '1513',
        '1514', '1515', '1516', '1518', '1519', '1520', '1521', '1522', '1523', '1528', '1529',
        '1530', '1531', '1532', '1533', '1534', '1535', '1536', '1537', '1538', '1539', '1540',
        '1541', '1542', '1543', '1548', '1550', '1551', '1552', '1560', '1561', '1562', '1568',
        '1569', '1570', '1571', '1572', '1573', '1574', '1578', '1579', '1580', '1588', '1589',
        '1590', '1591', '1598', '1599', '1600', '1601', '1602', '1603', '1604', '1605', '1608',
        '1609', '1610', '1611', '1612', '1613', '1618', '1619', '1620', '1622', '1623', '1624',
        '1625', '1628', '1629', '1630', '1631', '1638', '1639', '1640', '1641', '1642', '1643',
        '1648', '1649', '1650', '1658', '1659', '1700', '1701', '1702', '1703', '1704', '1705',
        '1706', '1707', '1708', '1709', '1710', '1712', '1713', '1714', '1715', '1716', '1717',
        '1718', '1719', '1720', '1721', '1722', '1723', '1724', '1725', '1726', '1727', '1728',
        '1729', '17300', '17301', '17302', '17309', '17310', '17311', '17312', '17319', '17320',
        '17321', '17322', '17329', '17330', '17331', '17332', '17339', '17340', '17341', '17342',
        '17349', '17350', '17351', '17352', '17359', '17360', '17361', '17362', '17369', '17370',
        '17371', '17372', '17379', '17380', '17381', '17382', '17389', '17390', '17391', '17392',
        '17399', '1740', '1741', '1742', '1743', '1744', '1745', '1746', '1748', '1749', '1750',
        '1759', '1760', '1761', '1762', '1763', '1764', '1765', '1768', '1769', '179', '1800',
        '1801', '1808', '1809', '181', '1820', '1821', '1828', '1830', '1832', '1833', '1834',
        '1835', '1838', '1839', '1840', '1841', '1842', '1843', '1844', '1848', '1849', '185',
        '1860', '1869', '1871', '1872', '1873', '1874', '1875', '1876', '1877', '1878', '1879',
        '1880', '1881', '1882', '1883', '1884', '1885', '1886', '1887', '1888', '1889', '1890',
        '1891', '1892', '1893', '1894', '1898', '1899', '1900', '1901', '1902', '1903', '1904',
        '1905', '1906', '1907', '1908', '1909', '1910', '1911', '1912', '1913', '1914', '1915',
        '1916', '1917', '1918', '1919', '1920', '1921', '1922', '1923', '1928', '1929', '193',
        '1940', '1941', '1943', '1944', '1945', '1946', '1948', '1949', '1950', '1951', '1952',
        '1953', '1954', '1955', '1958', '1960', '1961', '1962', '1963', '1965', '1966', '1968',
        '1969', '1970', '1971', '1972', '1973', '1974', '1975', '1976', '1977', '1978', '1980',
        '1981', '1982', '1983', '1984', '1985', '1986', '1987', '19881', '19882', '19889', '1990',
        '1991', '1992', '20000', '20001', '20002', '20003', '20004', '20005', '20006', '20007',
        '20008', '20010', '20011', '20012', '20013', '20014', '20015', '20016', '20017', '20018',
        '20020', '20021', '20022', '20023', '20024', '20025', '20026', '20027', '20028', '20030',
        '20031', '20032', '20033', '20034', '20035', '20036', '20037', '20038', '20040', '20041',
        '20042', '20043', '20044', '20045', '20046', '20047', '20048', '20050', '20051', '20052',
        '20053', '20054', '20055', '20056', '20057', '20058', '20060', '20061', '20062', '20063',
        '20064', '20065', '20066', '20067', '20068', '20070', '20071', '20072', '20073', '20074',
        '20075', '20076', '20077', '20078', '20080', '20081', '20082', '20083', '20084', '20085',
        '20086', '20087', '20088', '20100', '20101', '20102', '20103', '20104', '20105', '20106',
        '20107', '20108', '20110', '20111', '20112', '20113', '20114', '20115', '20116', '20117',
        '20118', '20120', '20121', '20122', '20123', '20124', '20125', '20126', '20127', '20128',
        '20140', '20141', '20142', '20143', '20144', '20145', '20146', '20147', '20148', '20150',
        '20151', '20152', '20153', '20154', '20155', '20156', '20157', '20158', '20160', '20161',
        '20162', '20163', '20164', '20165', '20166', '20167', '20168', '20170', '20171', '20172',
        '20173', '20174', '20175', '20176', '20177', '20178', '20190', '20191', '20192', '20193',
        '20194', '20195', '20196', '20197', '20198', '20200', '20201', '20202', '20203', '20204',
        '20205', '20206', '20207', '20208', '20210', '20211', '20212', '20213', '20214', '20215',
        '20216', '20217', '20218', '20220', '20221', '20222', '20223', '20224', '20225', '20226',
        '20227', '20228', '20230', '20231', '20232', '20233', '20234', '20235', '20236', '20237',
        '20238', '20240', '20241', '20242', '20243', '20244', '20245', '20246', '20247', '20248',
        '20250', '20251', '20252', '20253', '20254', '20255', '20256', '20257', '20258', '20260',
        '20261', '20262', '20263', '20264', '20265', '20266', '20267', '20268', '20270', '20271',
        '20272', '20273', '20274', '20275', '20276', '20277', '20278', '20280', '20281', '20282',
        '20283', '20284', '20285', '20286', '20287', '20288', '20290', '20291', '20292', '20293',
        '20294', '20295', '20296', '20297', '20298', '20300', '20301', '20302', '20310', '20311',
        '20312', '20380', '20381', '20382', '20400', '20401', '20402', '20410', '20411', '20412',
        '20420', '20421', '20422', '20480', '20481', '20482', '20490', '20491', '20492', '20500',
        '20501', '20502', '20510', '20511', '20512', '20520', '20521', '20522', '20530', '20531',
        '20532', '20580', '20581', '20582', '20590', '20591', '20592', '20600', '20601', '20602',
        '20610', '20611', '20612', '20620', '20621', '20622', '20680', '20681', '20682', '20690',
        '20691', '20692', '20700', '20701', '20702', '20710', '20711', '20712', '20720', '20721',
        '20722', '20780', '20781', '20782', '20800', '20801', '20802', '20810', '20811', '20812',
        '20820', '20821', '20822', '20880', '20881', '20882', '20890', '20891', '20892', '20900',
        '20901', '20902', '20903', '20910', '20911', '20912', '20913', '20914', '20915', '20916',
        '20917', '20920', '20921', '20922', '20923', '20924', '20925', '20926', '20927', '20929',
        '20930', '20931', '20932', '20933', '20934', '20935', '20936', '20970', '20971', '20972',
        '20973', '20974', '20975', '20979', '2350', '2351', '2352', '2353', '2354', '2355', '2356',
        '2357', '2358', '2359', '2360', '2361', '2362', '2363', '2364', '2365', '2366', '2367',
        '23690', '23691', '23699', '2370', '2371', '2372', '2373', '2374', '2375', '2376', '23770',
        '23771', '23772', '23773', '23779', '2379', '2380', '2381', '2382', '2383', '2384', '2385',
        '2386', '23871', '23872', '23873', '23874', '23875', '23876', '23877', '23879', '2388',
        '2389', '2390', '2391', '2392', '2393', '2394', '2395', '2396', '2397', '23981', '23989',
        '2399'
    }

    SNOMEDCT = {
        '107691000119101', '109264009', '109267002', '109347009', '109348004', '109349007',
        '109356001', '109357005', '109358000', '109359008', '109366009', '109367000', '109368005',
        '109369002', '109370001', '109371002', '109374005', '109378008', '109383000', '109384006',
        '109385007', '109386008', '109388009', '109389001', '109390005', '109391009', '109392002',
        '109821008', '109822001', '109823006', '109824000', '109826003', '109828002', '109830000',
        '109831001', '109832008', '109833003', '109834009', '109835005', '109836006', '109837002',
        '109838007', '109839004', '109840002', '109841003', '109842005', '109843000', '109844006',
        '109847004', '109848009', '109851002', '109853004', '109854005', '109855006', '109856007',
        '109857003', '109858008', '109870007', '109874003', '109875002', '109876001', '109878000',
        '109879008', '109880006', '109882003', '109885001', '109886000', '109887009', '109911004',
        '109912006', '109914007', '109915008', '109917000', '109918005', '109919002', '109921007',
        '109923005', '109925003', '109927006', '109931000', '109933002', '109937001', '109939003',
        '109941002', '109943004', '109945006', '109947003', '109948008', '109951001', '109958007',
        '109962001', '109964000', '109965004', '109966003', '109967007', '109968002', '109969005',
        '109970006', '109971005', '109972003', '109975001', '109976000', '109977009', '109978004',
        '109979007', '109980005', '109982002', '109984001', '109985000', '109988003', '109989006',
        '109991003', '109994006', '109995007', '109996008', '109998009', '110000005', '110002002',
        '110004001', '110005000', '110006004', '110007008', '110013004', '118599009', '118600007',
        '118601006', '118602004', '118605002', '118606001', '118607005', '118608000', '118609008',
        '118610003', '118611004', '118612006', '118613001', '118614007', '118615008', '118616009',
        '118617000', '118618005', '123313007', '123842006', '123845008', '126667002', '127070008',
        '127220001', '127225006', '128462008', '128465005', '128466006', '128467002', '128874001',
        '128875000', '13048006', '134335004', '187601000', '187604008', '187606005', '187608006',
        '187613005', '187614004', '187622006', '187624007', '187631006', '187634003', '187635002',
        '187637005', '187640005', '187641009', '187644001', '187652003', '187653008', '187658004',
        '187659007', '187660002', '187661003', '187662005', '187666008', '187675005', '187681002',
        '187682009', '187683004', '187685006', '187688008', '187692001', '187693006', '187694000',
        '187697007', '187698002', '187700006', '187701005', '187702003', '187708004', '187709007',
        '187716008', '187722004', '187723009', '187724003', '187725002', '187726001', '187727005',
        '187732006', '187733001', '187734007', '187736009', '187738005', '187740000', '187741001',
        '187742008', '187752007', '187757001', '187760008', '187767006', '187769009', '187773007',
        '187776004', '187777008', '187784000', '187786003', '187791002', '187792009', '187793004',
        '187794005', '187798008', '187801002', '187803004', '187804005', '187807003', '187808008',
        '187809000', '187810005', '187811009', '187814001', '187821001', '187822008', '187824009',
        '187828007', '187829004', '187830009', '187831008', '187833006', '187834000', '187835004',
        '187836003', '187838002', '187841006', '187842004', '187843009', '187844003', '187845002',
        '187846001', '187853005', '187854004', '187857006', '187861000', '187862007', '187864008',
        '187865009', '187866005', '187868006', '187869003', '187870002', '187881004', '187900002',
        '187903000', '187906008', '187916000', '187917009', '187918004', '187920001', '187925006',
        '187926007', '187927003', '187929000', '187932002', '187937008', '187938003', '187939006',
        '187940008', '187941007', '187942000', '187943005', '187944004', '187945003', '187946002',
        '187947006', '187948001', '187949009', '187950009', '187952001', '187956003', '187957007',
        '187967002', '187968007', '187969004', '187970003', '187972006', '187973001', '187974007',
        '187975008', '187976009', '187977000', '187978005', '187987001', '187988006', '187989003',
        '187991006', '187992004', '187993009', '187994003', '187995002', '187996001', '187997005',
        '187999008', '188000002', '188001003', '188002005', '188003000', '188004006', '188005007',
        '188006008', '188010006', '188013008', '188015001', '188016000', '188017009', '188019007',
        '188020001', '188021002', '188022009', '188023004', '188029000', '188030005', '188032002',
        '188033007', '188034001', '188038003', '188040008', '188042000', '188044004', '188045003',
        '188046002', '188049009', '188050009', '188051008', '188052001', '188054000', '188055004',
        '188060000', '188061001', '188062008', '188063003', '188064009', '188065005', '188067002',
        '188068007', '188069004', '188070003', '188071004', '188072006', '188073001', '188074007',
        '188075008', '188076009', '188077000', '188089003', '188090007', '188091006', '188095002',
        '188099008', '188100000', '188102008', '188103003', '188107002', '188110009', '188119005',
        '188121000', '188122007', '188125009', '188127001', '188132000', '188133005', '188135003',
        '188138001', '188147009', '188151006', '188152004', '188153009', '188154003', '188155002',
        '188156001', '188157005', '188159008', '188163001', '188168005', '188176007', '188177003',
        '188180002', '188183000', '188184006', '188188009', '188189001', '188190005', '188191009',
        '188192002', '188193007', '188195000', '188196004', '188198003', '188204000', '188208002',
        '188209005', '188211001', '188219004', '188220005', '188230001', '188234005', '188235006',
        '188239000', '188240003', '188241004', '188242006', '188243001', '188244007', '188245008',
        '188247000', '188250002', '188251003', '188252005', '188253000', '188256008', '188261005',
        '188263008', '188264002', '188265001', '188266000', '188268004', '188269007', '188272000',
        '188273005', '188274004', '188280007', '188281006', '188282004', '188283009', '188285002',
        '188286001', '188287005', '188289008', '188290004', '188292007', '188293002', '188295009',
        '188296005', '188297001', '188298006', '188301005', '188302003', '188307009', '188308004',
        '188312005', '188313000', '188315007', '188317004', '188318009', '188319001', '188321006',
        '188322004', '188323009', '188324003', '188325002', '188326001', '188327005', '188339002',
        '188340000', '188353002', '188361007', '188366002', '188445006', '188454009', '188458007',
        '188459004', '188462001', '188469005', '188471005', '188478004', '188487008', '188489006',
        '188492005', '188493000', '188498009', '188500005', '188501009', '188502002', '188503007',
        '188504001', '188505000', '188506004', '188507008', '188510001', '188511002', '188512009',
        '188513004', '188514005', '188515006', '188516007', '188517003', '188524002', '188526000',
        '188529007', '188531003', '188534006', '188536008', '188537004', '188538009', '188541000',
        '188544008', '188547001', '188548006', '188551004', '188554007', '188558005', '188559002',
        '188562004', '188565002', '188566001', '188567005', '188568000', '188569008', '188570009',
        '188572001', '188575004', '188576003', '188577007', '188578002', '188579005', '188580008',
        '188582000', '188585003', '188586002', '188587006', '188589009', '188590000', '188591001',
        '188592008', '188593003', '188609000', '188612002', '188613007', '188627002', '188630009',
        '188631008', '188632001', '188633006', '188634000', '188635004', '188637007', '188640007',
        '188641006', '188642004', '188645002', '188648000', '188649008', '188660004', '188662007',
        '188663002', '188664008', '188665009', '188666005', '188667001', '188668006', '188669003',
        '188672005', '188674006', '188675007', '188676008', '188679001', '188691005', '188718006',
        '188725004', '188726003', '188728002', '188729005', '188732008', '188733003', '188734009',
        '188736006', '188737002', '188738007', '188741003', '188744006', '188745007', '188746008',
        '188748009', '188754005', '188768003', '188770007', '189179009', '189361002', '189362009',
        '189365006', '189371000', '189392000', '189397006', '189399009', '189401003', '189406008',
        '189410006', '189412003', '189414002', '189415001', '189416000', '189417009', '189432002',
        '189433007', '189435000', '189441007', '189473001', '189484008', '189487001', '189488006',
        '189494003', '190030009', '20224008', '230156002', '231829006', '231831002', '231832009',
        '231833004', '231834005', '231835006', '232075002', '233717003', '233719000', '235965006',
        '235966007', '236512004', '236513009', '237252008', '237833006', '237865009', '238476000',
        '238863004', '238864005', '238865006', '239147000', '240163000', '240531002', '241861008',
        '242862004', '25050002', '253000007', '253001006', '253003009', '253006001', '253008000',
        '253017000', '253018005', '253029009', '253030004', '253031000', '253042009', '253096008',
        '254146000', '254389005', '254390001', '254393004', '254398008', '254402004', '254404003',
        '254408000', '254412006', '254417000', '254423005', '254424004', '254425003', '254427006',
        '254431000', '254434008', '254435009', '254436005', '254437001', '254441002', '254445006',
        '254450000', '254454009', '254457002', '254459004', '254462001', '254465004', '254466003',
        '254474002', '254478004', '254481009', '254484001', '254503007', '254509006', '254513004',
        '254517003', '254520006', '254526000', '254530002', '254535007', '254539001', '254543002',
        '254547001', '254549003', '254551004', '254553001', '254555008', '254557000', '254559002',
        '254561006', '254563009', '254567005', '254570009', '254574000', '254582000', '254586002',
        '254601002', '254609000', '254611009', '254612002', '254619006', '254620000', '254622008',
        '254625005', '254626006', '254628007', '254629004', '254631008', '254632001', '254633006',
        '254634000', '254635004', '254637007', '254638002', '254643009', '254645002', '254650008',
        '254651007', '254652000', '254653005', '254654004', '254655003', '254662007', '254663002',
        '254664008', '254701007', '254702000', '254703005', '254707006', '254708001', '254709009',
        '254710004', '254711000', '254712007', '254713002', '254714008', '254726003', '254727007',
        '254729005', '254730000', '254731001', '254732008', '254733003', '254734009', '254748009',
        '254754005', '254764001', '254771006', '254792006', '254794007', '254796009', '254797000',
        '254798005', '254799002', '254800003', '254820002', '254824006', '254828009', '254829001',
        '254837009', '254838004', '254839007', '254840009', '254841008', '254843006', '254844000',
        '254849005', '254850005', '254851009', '254852002', '254854001', '254855000', '254856004',
        '254860001', '254861002', '254863004', '254867003', '254869000', '254870004', '254871000',
        '254872007', '254874008', '254876005', '254877001', '254878006', '254883003', '254886006',
        '254887002', '254888007', '254889004', '254893005', '254895003', '254896002', '254897006',
        '254898001', '254900004', '254904008', '254908006', '254909003', '254912000', '254915003',
        '254916002', '254917006', '254918001', '254934003', '254938000', '254939008', '254940005',
        '254945000', '254948003', '254949006', '254950006', '254954002', '254955001', '254969001',
        '254972008', '254973003', '254974009', '254975005', '254976006', '254980001', '254983004',
        '254986007', '254987003', '254988008', '254989000', '254990009', '254993006', '254994000',
        '254995004', '254996003', '255003007', '255004001', '255008003', '255012009', '255015006',
        '255016007', '255017003', '255021005', '255028004', '255029007', '255030002', '255031003',
        '255032005', '255035007', '255037004', '255044008', '255052006', '255056009', '255062004',
        '255064003', '255066001', '255067005', '255068000', '255069008', '255071008', '255072001',
        '255073006', '255074000', '255075004', '255077007', '255078002', '255081007', '255083005',
        '255084004', '255086002', '255087006', '255088001', '255090000', '255091001', '255093003',
        '255096006', '255101006', '255102004', '255107005', '255108000', '255109008', '255110003',
        '255111004', '255112006', '255114007', '255115008', '255116009', '255118005', '255119002',
        '255121007', '255123005', '255124004', '255128001', '255129009', '255191003', '269459004',
        '269460009', '269463006', '269464000', '269467007', '269469005', '269473008', '269475001',
        '269476000', '269496008', '269497004', '269515006', '269516007', '269533000', '269544008',
        '269578002', '269579005', '269580008', '269581007', '269616004', '269617008', '271323007',
        '271326004', '271467005', '271468000', '271482000', '271568003', '271943005', '274084007',
        '274085008', '274087000', '274088005', '274902006', '274905008', '275265005', '275266006',
        '275394001', '275395000', '275396004', '275397008', '275399006', '275419009', '275490009',
        '276419004', '276420005', '276738009', '276750003', '276751004', '276797002', '276799004',
        '276803003', '276804009', '276809004', '276810009', '276811008', '276815004', '276821000',
        '276822007', '276826005', '276827001', '276828006', '276829003', '276836002', '276860003',
        '276870001', '276876007', '276952000', '276953005', '276954004', '276962007', '276975007',
        '277156006', '277461004', '277473004', '277474005', '277505007', '277507004', '277530005',
        '277543005', '277545003', '277549009', '277550009', '277551008', '277567002', '277568007',
        '277569004', '277570003', '277571004', '277572006', '277573001', '277574007', '277575008',
        '277577000', '277579002', '277580004', '277587001', '277589003', '277597005', '277601005',
        '277602003', '277604002', '277609007', '277610002', '277611003', '277612005', '277613000',
        '277614006', '277615007', '277616008', '277617004', '277618009', '277619001', '277622004',
        '277623009', '277624003', '277625002', '277626001', '277627005', '277628000', '277629008',
        '277632006', '277637000', '277641001', '277642008', '277643003', '277651000', '277653002',
        '277654008', '277664004', '277782009', '278024000', '278042005', '278043000', '278044006',
        '278046008', '278050001', '278051002', '278052009', '278053004', '278054005', '278055006',
        '278057003', '278060005', '278189009', '278433008', '278453007', '278491007', '280959007',
        '281560004', '281561000', '281562007', '281563002', '281564008', '281565009', '281566005',
        '281702006', '285307007', '285308002', '285309005', '285310000', '285312008', '285420006',
        '285421005', '285422003', '285432005', '285598005', '285603002', '285604008', '285605009',
        '285606005', '285607001', '285608006', '285609003', '285610008', '285611007', '285612000',
        '285613005', '285614004', '285615003', '285616002', '285617006', '285618001', '285619009',
        '285631006', '285633009', '285634003', '285635002', '285637005', '285638000', '285639008',
        '285640005', '285641009', '285642002', '285643007', '285644001', '285645000', '285769009',
        '285776004', '285839005', '286887005', '286889008', '286890004', '286891000', '286893002',
        '286894008', '286895009', '286896005', '286897001', '286899003', '286900008', '286902000',
        '300988009', '301756000', '302815008', '302816009', '302817000', '302833002', '302834008',
        '302837001', '302841002', '302842009', '302845006', '302847003', '302848008', '302849000',
        '302851001', '302855005', '302856006', '303012000', '303017006', '303055001', '303056000',
        '303057009', '303194003', '303201005', '304545002', '30664006', '307216009', '307219002',
        '307226002', '307340003', '307341004', '307501007', '307502000', '307576001', '307592006',
        '307593001', '307599002', '307601000', '307603002', '307604008', '307608006', '307609003',
        '307610008', '307617006', '307622006', '307623001', '307624007', '307625008', '307633009',
        '307634003', '307635002', '307636001', '307637005', '307646004', '307647008', '307649006',
        '307650006', '307651005', '308121000', '309245001', '31047003', '310498001', '310504009',
        '310526005', '310599006', '311779007', '312104005', '312111009', '312112002', '312113007',
        '312114001', '312115000', '312949007', '313248004', '313249007', '313250007', '313353007',
        '313354001', '313355000', '313356004', '313357008', '313427003', '313428008', '313429000',
        '314191009', '314408000', '314418005', '314419002', '314951005', '314952003', '314953008',
        '314954002', '314955001', '314960002', '314961003', '314962005', '314963000', '314964006',
        '314965007', '314966008', '314967004', '314968009', '314969001', '314970000', '314973003',
        '314974009', '314975005', '314976006', '314987003', '314988008', '314989000', '314990009',
        '314991008', '314992001', '314993006', '314994000', '314995004', '314996003', '314997007',
        '314998002', '314999005', '315000005', '315001009', '315002002', '315003007', '315004001',
        '315005000', '315006004', '315007008', '315008003', '315009006', '315058005', '326072005',
        '35868009', '359619007', '359631009', '359640008', '359648001', '359780007', '359782004',
        '359785002', '359987004', '363346000', '363348004', '363349007', '363350007', '363351006',
        '363352004', '363353009', '363354003', '363355002', '363357005', '363358000', '363359008',
        '363360003', '363363001', '363364007', '363365008', '363366009', '363367000', '363368005',
        '363369002', '363370001', '363372009', '363373004', '363374005', '363375006', '363376007',
        '363377003', '363378008', '363379000', '363380002', '363381003', '363382005', '363383000',
        '363384006', '363385007', '363386008', '363387004', '363388009', '363389001', '363390005',
        '363391009', '363392002', '363393007', '363394001', '363395000', '363396004', '363397008',
        '363398003', '363399006', '363400004', '363401000', '363402007', '363403002', '363404008',
        '363405009', '363406005', '363407001', '363408006', '363409003', '363410008', '363411007',
        '363412000', '363413005', '363414004', '363415003', '363416002', '363417006', '363418001',
        '363419009', '363420003', '363421004', '363422006', '363423001', '363424007', '363425008',
        '363426009', '363427000', '363428005', '363429002', '363430007', '363431006', '363432004',
        '363433009', '363434003', '363435002', '363436001', '363437005', '363438000', '363439008',
        '363440005', '363441009', '363443007', '363444001', '363445000', '363446004', '363447008',
        '363449006', '363450006', '363451005', '363452003', '363453008', '363454002', '363456000',
        '363457009', '363458004', '363459007', '363460002', '363461003', '363462005', '363463000',
        '363464006', '363465007', '363466008', '363467004', '363468009', '363469001', '363470000',
        '363471001', '363473003', '363474009', '363475005', '363476006', '363477002', '363478007',
        '363481002', '363482009', '363483004', '363484005', '363485006', '363486007', '363487003',
        '363488008', '363489000', '363490009', '363491008', '363492001', '363493006', '363494000',
        '363495004', '363496003', '363497007', '363498002', '363499005', '363500001', '363501002',
        '363502009', '363503004', '363504005', '363505006', '363506007', '363507003', '363508008',
        '363509000', '363510005', '363514001', '363515000', '363516004', '363517008', '363518003',
        '363745004', '369448007', '369449004', '369450004', '369451000', '369452007', '369453002',
        '369454008', '369455009', '369456005', '369457001', '369458006', '369459003', '369460008',
        '369461007', '369463005', '369464004', '369465003', '369466002', '369467006', '369468001',
        '369469009', '369470005', '369471009', '369472002', '369473007', '369474001', '369475000',
        '369476004', '369477008', '369478003', '369479006', '369480009', '369481008', '369482001',
        '369483006', '369484000', '369485004', '369486003', '369487007', '369488002', '369489005',
        '369490001', '369491002', '369492009', '369493004', '369494005', '369495006', '369496007',
        '369497003', '369498008', '369499000', '369500009', '369501008', '369502001', '369503006',
        '369504000', '369505004', '369506003', '369507007', '369508002', '369509005', '369510000',
        '369511001', '369512008', '369513003', '369514009', '369515005', '369516006', '369517002',
        '369518007', '369519004', '369520005', '369521009', '369522002', '369523007', '369524001',
        '369525000', '369526004', '369527008', '369528003', '369529006', '369530001', '369531002',
        '369532009', '369533004', '369534005', '369535006', '369536007', '369538008', '369540003',
        '369541004', '369542006', '369543001', '369544007', '369545008', '369546009', '369547000',
        '369548005', '369549002', '369550002', '369551003', '369552005', '369553000', '369554006',
        '369555007', '369556008', '369557004', '369558009', '369559001', '369560006', '369561005',
        '369562003', '369563008', '369564002', '369565001', '369566000', '369567009', '369568004',
        '369569007', '369570008', '369571007', '369572000', '369573005', '369574004', '369575003',
        '369576002', '369577006', '369578001', '369579009', '369580007', '369581006', '369582004',
        '369583009', '369584003', '369585002', '369586001', '369587005', '369588000', '369589008',
        '369590004', '369591000', '369592007', '369593002', '369594008', '369595009', '369596005',
        '369597001', '369598006', '369599003', '369600000', '369601001', '369602008', '369603003',
        '369604009', '369605005', '369606006', '369607002', '369608007', '369609004', '369610009',
        '370511006', '370967009', '370987005', '371012000', '371134001', '371962007', '371963002',
        '371964008', '371965009', '371966005', '371967001', '371968006', '371969003', '371970002',
        '371971003', '371972005', '371973000', '371974006', '371975007', '371976008', '371977004',
        '371978009', '371979001', '371980003', '371981004', '371982006', '371983001', '371984007',
        '371986009', '371987000', '371988005', '371989002', '371990006', '371991005', '371992003',
        '371993008', '371994002', '371995001', '371996000', '371997009', '371998004', '371999007',
        '372000001', '372001002', '372002009', '372003004', '372004005', '372005006', '372006007',
        '372007003', '372008008', '372009000', '372010005', '372011009', '372012002', '372013007',
        '372014001', '372015000', '372016004', '372017008', '372018003', '372019006', '372020000',
        '372021001', '372022008', '372023003', '372024009', '372025005', '372026006', '372027002',
        '372028007', '372030009', '372062007', '372063002', '372064008', '372065009', '372087000',
        '372092003', '372093008', '372094002', '372095001', '372096000', '372097009', '372098004',
        '372099007', '372100004', '372101000', '372103002', '372104008', '372105009', '372106005',
        '372107001', '372108006', '372110008', '372111007', '372112000', '372113005', '372115003',
        '372116002', '372119009', '372120003', '372121004', '372122006', '372123001', '372124007',
        '372125008', '372126009', '372127000', '372128005', '372129002', '372130007', '372131006',
        '372133009', '372135002', '372136001', '372137005', '372138000', '372139008', '372140005',
        '372141009', '372142002', '372143007', '372244006', '373080008', '373081007', '373082000',
        '373083005', '373088001', '373089009', '373090000', '373091001', '373168002', '373627005',
        '373888000', '385478001', '389216001', '393563007', '396198006', '397008008', '397009000',
        '397011009', '397013007', '397015000', '398623004', '398670003', '398903003', '399068003',
        '399326009', '399490008', '399590005', '399660006', '399884001', '399897004', '399934007',
        '399954008', '399967006', '399969009', '399994005', '400001003', '400055004', '400057007',
        '400058002', '400074007', '400122007', '400129003', '400153009', '400173004', '400174005',
        '400175006', '402494003', '402495002', '402496001', '402497005', '402498000', '402499008',
        '402500004', '402501000', '402502007', '402503002', '402504008', '402505009', '402506005',
        '402507001', '402508006', '402509003', '402510008', '402511007', '402512000', '402513005',
        '402514004', '402515003', '402516002', '402517006', '402518001', '402519009', '402520003',
        '402521004', '402522006', '402523001', '402524007', '402525008', '402526009', '402527000',
        '402528005', '402529002', '402530007', '402531006', '402532004', '402533009', '402534003',
        '402536001', '402537005', '402538000', '402539008', '402540005', '402541009', '402542002',
        '402543007', '402544001', '402545000', '402546004', '402547008', '402558004', '402559007',
        '402560002', '402561003', '402562005', '402563000', '402564006', '402636006', '402652009',
        '402815007', '402816008', '402817004', '402818009', '402819001', '402820007', '402871009',
        '402873007', '402876004', '402879006', '402880009', '402881008', '402882001', '402910001',
        '402912009', '403409009', '403410004', '403411000', '403458008', '403468003', '403711001',
        '403712008', '403713003', '403714009', '403729006', '403742006', '403815003', '403816002',
        '403817006', '403889000', '403890009', '403891008', '403892001', '403893006', '403894000',
        '403895004', '403896003', '403897007', '403898002', '403899005', '403900000', '403901001',
        '403902008', '403903003', '403904009', '403905005', '403906006', '403907002', '403908007',
        '403909004', '403910009', '403911008', '403912001', '403913006', '403914000', '403915004',
        '403916003', '403917007', '403918002', '403919005', '403920004', '403921000', '403922007',
        '403923002', '403924008', '403925009', '403926005', '403927001', '403929003', '403939009',
        '403940006', '403941005', '403942003', '403943008', '403944002', '403946000', '403947009',
        '403949007', '403950007', '403951006', '403954003', '403955002', '403977003', '403978008',
        '403979000', '403980002', '403981003', '403982005', '403983000', '403984006', '403985007',
        '403986008', '403996004', '404008001', '404009009', '404010004', '404011000', '404012007',
        '404013002', '404014008', '404015009', '404016005', '404017001', '404037002', '404038007',
        '404039004', '404040002', '404041003', '404045007', '404046008', '404047004', '404051002',
        '404052009', '404053004', '404054005', '404055006', '404056007', '404067008', '404068003',
        '404069006', '404070007', '404071006', '404072004', '404073009', '404077005', '404079008',
        '404080006', '404083008', '404084002', '404085001', '404087009', '404088004', '404089007',
        '404090003', '404091004', '404092006', '404093001', '404094007', '404103007', '404104001',
        '404105000', '404106004', '404107008', '404108003', '404109006', '404110001', '404111002',
        '404112009', '404113004', '404114005', '404115006', '404116007', '404117003', '404118008',
        '404119000', '404120006', '404121005', '404122003', '404123008', '404124002', '404125001',
        '404126000', '404127009', '404128004', '404129007', '404130002', '404131003', '404132005',
        '404133000', '404134006', '404135007', '404136008', '404137004', '404138009', '404139001',
        '404140004', '404141000', '404142007', '404143002', '404144008', '404145009', '404146005',
        '404147001', '404148006', '404149003', '404150003', '404151004', '404152006', '404153001',
        '404154007', '404155008', '404156009', '404157000', '404169008', '404653000', '404664002',
        '405546008', '405822008', '405843009', '405945003', '408642003', '408643008', '408644002',
        '408645001', '408646000', '408647009', '408648004', '408649007', '413389003', '413441006',
        '413442004', '413445002', '413446001', '4135001', '413537009', '413587002', '413656006',
        '413842007', '413843002', '413847001', '414166008', '414553000', '414676007', '414780005',
        '414785000', '414791003', '414950005', '415110002', '415112005', '415177008', '415283002',
        '415284008', '415285009', '415286005', '415287001', '416274001', '416351002', '416669000',
        '416769008', '416842003', '416901002', '417181009', '417264005', '417417007', '417554000',
        '417570003', '417619001', '418040002', '418372008', '418529003', '419052002', '419240004',
        '419317000', '419842002', '420302007', '420519005', '420524008', '420788006', '420890002',
        '421246008', '421249001', '421283008', '421835000', '422052002', '422282000', '422378004',
        '422541001', '422572002', '422599000', '422676009', '422691006', '422736007', '422758009',
        '422782004', '422833009', '422853008', '422886007', '423005002', '423032007', '423038006',
        '423050000', '423106003', '423158009', '423189008', '423195009', '423280002', '423284006',
        '423294001', '423318000', '423325007', '423349005', '423384009', '423424005', '423425006',
        '423447006', '423463003', '423464009', '423494003', '423506005', '423535002', '423595004',
        '423600008', '423607006', '423610004', '423615009', '423627007', '423673009', '423691004',
        '423700001', '423708008', '423746001', '423793008', '423807009', '423812005', '423829008',
        '423896007', '423973006', '423987006', '424052001', '424151006', '424190005', '424260006',
        '424276002', '424302003', '424334007', '424408000', '424413001', '424440001', '424487008',
        '424549003', '424666005', '424779008', '424849005', '424887002', '424938000', '424952003',
        '424954002', '424970000', '425066001', '425127006', '425148008', '425178004', '425225007',
        '425231005', '425303004', '425607009', '425657001', '425688002', '425749006', '425869007',
        '425941003', '426071002', '426124006', '426217000', '426248008', '426336007', '426370008',
        '426642002', '426885008', '426964009', '427038005', '427056005', '427141003', '427285006',
        '427492003', '427642009', '427658007', '427685000', '427744002', '427942006', '428061005',
        '428100006', '428281000', '428322007', '428905002', '429033009', '429114002', '429176009',
        '429570006', '430338009', '430556008', '430621000', '431396003', '432082001', '432328008',
        '433067002', '438946002', '439478008', '440173001', '440397000', '440422002', '440501006',
        '440525003', '440527006', '441313008', '441535001', '441559006', '441962003', '442537007',
        '443042003', '443136000', '443144000', '443250000', '443261008', '443333004', '443439001',
        '443487006', '443488001', '443493003', '443520009', '443643007', '443648003', '443675005',
        '443679004', '443719001', '443936004', '443937008', '443961001', '444596001', '444597005',
        '444604002', '444712000', '444910004', '444911000', '445227008', '445269007', '445406001',
        '445448008', '446022000', '446189008', '446241005', '446807009', '446939001', '447100004',
        '447109003', '447266004', '447389009', '447390000', '447416008', '449628003', '449629006',
        '449630001', '449631002', '449632009', '449633004', '449634005', '449635006', '449636007',
        '449637003', '46724008', '4752007', '53132006', '58961005', '60620005', '609519004',
        '61493004', '61530001', '61808009', '62497000', '63175003', '68979007', '69408002',
        '702391001', '708921005', '70910003', '711414003', '712525007', '713718006', '713897006',
        '735332000', '763131005', '764791008', '767448007', '80914001', '82546001', '91854005',
        '91855006', '91856007', '91857003', '91858008', '91860005', '91861009', '92508006',
        '92509003', '92510008', '92511007', '92512000', '92513005', '92514004', '92515003',
        '92516002', '92811003', '92812005', '92813000', '92814006', '92817004', '92818009',
        '92824003', '93133006', '93134000', '93135004', '93136003', '93137007', '93138002',
        '93139005', '93140007', '93141006', '93142004', '93143009', '93144003', '93145002',
        '93146001', '93147005', '93148000', '93149008', '93150008', '93151007', '93152000',
        '93169003', '93182006', '93183001', '93184007', '93185008', '93186009', '93187000',
        '93188005', '93189002', '93190006', '93191005', '93192003', '93193008', '93194002',
        '93195001', '93196000', '93197009', '93198004', '93199007', '93200005', '93201009',
        '93202002', '93203007', '93204001', '93205000', '93206004', '93207008', '93208003',
        '93209006', '93210001', '93211002', '93213004', '93214005', '93215006', '93216007',
        '93217003', '93218008', '93219000', '93220006', '93221005', '93222003', '93223008',
        '93224002', '93225001', '93226000', '93227009', '93228004', '93229007', '93230002',
        '93450001', '93451002', '93487009', '93488004', '93489007', '93492006', '93493001',
        '93494007', '93495008', '93496009', '93497000', '93498005', '93500006', '93501005',
        '93505001', '93506000', '93507009', '93509007', '93510002', '93514006', '93515007',
        '93516008', '93518009', '93519001', '93520007', '93521006', '93522004', '93523009',
        '93524003', '93525002', '93526001', '93527005', '93528000', '93530003', '93531004',
        '93532006', '93533001', '93534007', '93536009', '93537000', '93541001', '93542008',
        '93543003', '93545005', '93546006', '93547002', '93548007', '93549004', '93550004',
        '93551000', '93552007', '93554008', '93555009', '93636004', '93637008', '93638003',
        '93640008', '93641007', '93642000', '93643005', '93644004', '93645003', '93646002',
        '93647006', '93648001', '93649009', '93650009', '93651008', '93652001', '93653006',
        '93654000', '93655004', '93657007', '93658002', '93659005', '93660000', '93661001',
        '93662008', '93663003', '93665005', '93667002', '93669004', '93670003', '93671004',
        '93672006', '93674007', '93676009', '93677000', '93679002', '93680004', '93681000',
        '93682007', '93683002', '93684008', '93686005', '93687001', '93689003', '93690007',
        '93692004', '93693009', '93694003', '93695002', '93696001', '93697005', '93698000',
        '93699008', '93700009', '93701008', '93703006', '93704000', '93705004', '93706003',
        '93707007', '93708002', '93709005', '93710000', '93711001', '93712008', '93713003',
        '93714009', '93715005', '93716006', '93717002', '93720005', '93721009', '93722002',
        '93723007', '93724001', '93725000', '93726004', '93727008', '93728003', '93729006',
        '93730001', '93731002', '93732009', '93733004', '93734005', '93737003', '93738008',
        '93739000', '93740003', '93741004', '93742006', '93743001', '93744007', '93745008',
        '93746009', '93747000', '93748005', '93749002', '93751003', '93753000', '93754006',
        '93755007', '93756008', '93757004', '93759001', '93760006', '93761005', '93763008',
        '93764002', '93766000', '93767009', '93768004', '93769007', '93770008', '93771007',
        '93772000', '93773005', '93775003', '93776002', '93777006', '93778001', '93779009',
        '93781006', '93782004', '93783009', '93784003', '93786001', '93787005', '93788000',
        '93789008', '93792007', '93793002', '93796005', '93797001', '93798006', '93799003',
        '93800004', '93801000', '93802007', '93803002', '93804008', '93806005', '93807001',
        '93808006', '93809003', '93812000', '93814004', '93815003', '93816002', '93817006',
        '93818001', '93820003', '93821004', '93824007', '93825008', '93826009', '93827000',
        '93828005', '93829002', '93830007', '93831006', '93832004', '93833009', '93834003',
        '93835002', '93836001', '93837005', '93839008', '93841009', '93842002', '93843007',
        '93844001', '93845000', '93846004', '93848003', '93849006', '93850006', '93851005',
        '93854002', '93857009', '93858004', '93860002', '93861003', '93862005', '93864006',
        '93865007', '93867004', '93868009', '93870000', '93871001', '93872008', '93874009',
        '93875005', '93876006', '93878007', '93879004', '93880001', '93882009', '93883004',
        '93884005', '93885006', '93886007', '93887003', '93888008', '93889000', '93890009',
        '93891008', '93892001', '93893006', '93894000', '93898002', '93899005', '93900000',
        '93901001', '93902008', '93903003', '93904009', '93905005', '93906006', '93907002',
        '93908007', '93909004', '93910009', '93911008', '93912001', '93913006', '93914000',
        '93915004', '93916003', '93917007', '93918002', '93920004', '93922007', '93923002',
        '93924008', '93925009', '93926005', '93927001', '93928006', '93929003', '93930008',
        '93931007', '93932000', '93933005', '93934004', '93936002', '93939009', '93940006',
        '93941005', '93942003', '93943008', '93944002', '93945001', '93946000', '93947009',
        '93948004', '93950007', '93951006', '93952004', '93953009', '93955002', '93956001',
        '93957005', '93958000', '93959008', '93960003', '93961004', '93962006', '93963001',
        '93964007', '93966009', '93967000', '93968005', '93969002', '93970001', '93971002',
        '93973004', '93974005', '93975006', '93976007', '93977003', '93978008', '93979000',
        '93980002', '93981003', '93982005', '93983000', '93984006', '93985007', '93986008',
        '93987004', '93989001', '93990005', '93991009', '93992002', '93993007', '93994001',
        '93995000', '93996004', '93997008', '93998003', '94000008', '94001007', '94002000',
        '94003005', '94004004', '94005003', '94006002', '94007006', '94008001', '94010004',
        '94011000', '94012007', '94013002', '94014008', '94015009', '94016005', '94017001',
        '94018006', '94019003', '94020009', '94021008', '94022001', '94023006', '94024000',
        '94025004', '94026003', '94027007', '94028002', '94029005', '94030000', '94032008',
        '94033003', '94034009', '94035005', '94036006', '94037002', '94038007', '94039004',
        '94040002', '94041003', '94042005', '94043000', '94044006', '94045007', '94046008',
        '94047004', '94048009', '94049001', '94050001', '94051002', '94052009', '94053004',
        '94054005', '94055006', '94056007', '94057003', '94058008', '94059000', '94060005',
        '94061009', '94062002', '94063007', '94066004', '94067008', '94068003', '94069006',
        '94071006', '94072004', '94073009', '94075002', '94076001', '94077005', '94078000',
        '94079008', '94080006', '94081005', '94082003', '94083008', '94084002', '94085001',
        '94086000', '94087009', '94089007', '94090003', '94092006', '94093001', '94094007',
        '94096009', '94097000', '94098005', '94099002', '94101009', '94102002', '94103007',
        '94104001', '94105000', '94107008', '94108003', '94109006', '94110001', '94111002',
        '94112009', '94113004', '94115006', '94116007', '94117003', '94118008', '94120006',
        '94121005', '94122003', '94123008', '94124002', '94125001', '94126000', '94128004',
        '94129007', '94131003', '94132005', '94133000', '94134006', '94135007', '94138009',
        '94139001', '94140004', '94142007', '94143002', '94144008', '94145009', '94148006',
        '94152006', '94153001', '94154007', '94155008', '94156009', '94157000', '94158005',
        '94159002', '94160007', '94161006', '94162004', '94163009', '94164003', '94165002',
        '94166001', '94167005', '94168000', '94169008', '94170009', '94171008', '94172001',
        '94173006', '94175004', '94176003', '94177007', '94179005', '94180008', '94181007',
        '94182000', '94183005', '94184004', '94185003', '94186002', '94187006', '94189009',
        '94190000', '94191001', '94192008', '94193003', '94194009', '94195005', '94196006',
        '94197002', '94198007', '94200001', '94201002', '94202009', '94203004', '94204005',
        '94205006', '94206007', '94207003', '94208008', '94209000', '94210005', '94211009',
        '94212002', '94213007', '94214001', '94215000', '94217008', '94218003', '94219006',
        '94220000', '94221001', '94222008', '94224009', '94225005', '94226006', '94227002',
        '94228007', '94229004', '94230009', '94231008', '94232001', '94233006', '94234000',
        '94235004', '94236003', '94237007', '94238002', '94239005', '94240007', '94241006',
        '94242004', '94243009', '94244003', '94245002', '94246001', '94247005', '94248000',
        '94249008', '94250008', '94252000', '94253005', '94254004', '94255003', '94256002',
        '94257006', '94258001', '94259009', '94260004', '94261000', '94262007', '94263002',
        '94264008', '94265009', '94266005', '94267001', '94268006', '94269003', '94270002',
        '94271003', '94272005', '94273000', '94274006', '94275007', '94276008', '94277004',
        '94278009', '94279001', '94280003', '94281004', '94282006', '94283001', '94284007',
        '94285008', '94286009', '94287000', '94288005', '94289002', '94290006', '94291005',
        '94292003', '94293008', '94294002', '94295001', '94296000', '94297009', '94298004',
        '94299007', '94300004', '94301000', '94302007', '94303002', '94304008', '94305009',
        '94306005', '94307001', '94308006', '94309003', '94310008', '94311007', '94312000',
        '94313005', '94314004', '94315003', '94316002', '94317006', '94318001', '94319009',
        '94320003', '94321004', '94322006', '94323001', '94324007', '94325008', '94326009',
        '94327000', '94328005', '94329002', '94330007', '94331006', '94332004', '94333009',
        '94334003', '94335002', '94336001', '94337005', '94338000', '94339008', '94340005',
        '94341009', '94342002', '94343007', '94344001', '94345000', '94346004', '94347008',
        '94348003', '94349006', '94350006', '94351005', '94352003', '94353008', '94354002',
        '94355001', '94356000', '94357009', '94358004', '94359007', '94360002', '94361003',
        '94362005', '94364006', '94365007', '94366008', '94367004', '94368009', '94369001',
        '94370000', '94371001', '94372008', '94373003', '94374009', '94375005', '94376006',
        '94378007', '94379004', '94380001', '94381002', '94382009', '94383004', '94384005',
        '94385006', '94386007', '94387003', '94388008', '94389000', '94390009', '94391008',
        '94392001', '94393006', '94394000', '94395004', '94396003', '94397007', '94398002',
        '94399005', '94400003', '94401004', '94402006', '94403001', '94404007', '94405008',
        '94406009', '94407000', '94408005', '94409002', '94410007', '94411006', '94412004',
        '94413009', '94414003', '94415002', '94416001', '94417005', '94418000', '94419008',
        '94420002', '94421003', '94422005', '94423000', '94424006', '94425007', '94426008',
        '94427004', '94428009', '94429001', '94430006', '94431005', '94432003', '94433008',
        '94434002', '94435001', '94436000', '94437009', '94439007', '94440009', '94441008',
        '94442001', '94443006', '94444000', '94445004', '94446003', '94447007', '94448002',
        '94449005', '94450005', '94451009', '94452002', '94453007', '94454001', '94455000',
        '94456004', '94457008', '94458003', '94459006', '94460001', '94461002', '94462009',
        '94463004', '94464005', '94465006', '94466007', '94467003', '94468008', '94469000',
        '94470004', '94471000', '94472007', '94473002', '94474008', '94475009', '94476005',
        '94477001', '94478006', '94479003', '94480000', '94481001', '94482008', '94483003',
        '94484009', '94485005', '94486006', '94487002', '94488007', '94489004', '94490008',
        '94491007', '94492000', '94493005', '94494004', '94495003', '94496002', '94497006',
        '94498001', '94499009', '94500000', '94501001', '94502008', '94503003', '94504009',
        '94505005', '94506006', '94507002', '94508007', '94509004', '94510009', '94511008',
        '94512001', '94513006', '94514000', '94515004', '94516003', '94517007', '94518002',
        '94519005', '94520004', '94521000', '94522007', '94523002', '94524008', '94525009',
        '94526005', '94527001', '94528006', '94529003', '94530008', '94531007', '94532000',
        '94533005', '94534004', '94535003', '94536002', '94537006', '94538001', '94539009',
        '94540006', '94542003', '94543008', '94544002', '94545001', '94546000', '94547009',
        '94548004', '94549007', '94550007', '94551006', '94552004', '94553009', '94554003',
        '94555002', '94556001', '94557005', '94558000', '94559008', '94560003', '94561004',
        '94562006', '94564007', '94565008', '94566009', '94567000', '94568005', '94569002',
        '94570001', '94571002', '94572009', '94573004', '94574005', '94575006', '94576007',
        '94577003', '94578008', '94579000', '94580002', '94581003', '94582005', '94583000',
        '94584006', '94585007', '94586008', '94587004', '94588009', '94589001', '94590005',
        '94591009', '94592002', '94593007', '94594001', '94595000', '94596004', '94597008',
        '94598003', '94599006', '94600009', '94601008', '94602001', '94603006', '94604000',
        '94605004', '94606003', '94607007', '94608002', '94609005', '94610000', '94611001',
        '94612008', '94613003', '94614009', '94615005', '94616006', '94617002', '94618007',
        '94619004', '94620005', '94621009', '94622002', '94623007', '94624001', '94625000',
        '94626004', '94627008', '94628003', '94629006', '94630001', '94631002', '94632009',
        '94633004', '94634005', '94635006', '94636007', '94637003', '94638008', '94639000',
        '94640003', '94641004', '94642006', '94643001', '94644007', '94645008', '94646009',
        '94647000', '94648005', '94649002', '94650002', '94651003', '94652005', '94653000',
        '94654006', '94655007', '94656008', '94657004', '94658009', '94659001', '94660006',
        '94661005', '94662003', '94663008', '94664002', '94665001', '94666000', '94667009',
        '94668004', '94669007', '94670008', '94671007', '94672000', '94673005', '94674004',
        '94675003', '94676002', '94677006', '94678001', '94679009', '94680007', '94681006',
        '94682004', '94683009', '94686001', '94687005', '94688000', '94690004', '94704006',
        '94707004', '94708009', '94709001', '94710006', '94711005', '94712003', '94714002',
        '94715001', '94716000', '94718004', '94719007', '94721002', '94722009', '94723004',
        '94724005', '94725006', '94726007', '94727003', '94728008', '94729000', '94730005',
        '94731009', '94732002', '94733007', '94734001', '94735000', '94736004', '94737008',
        '94738003', '94739006', '94740008', '94741007', '94742000', '94743005', '94744004',
        '94745003', '94746002', '94747006', '94748001', '94749009', '94750009', '94751008',
        '94752001', '94754000', '94755004', '94756003', '94757007', '94758002', '94759005',
        '94761001', '94762008', '94763003', '94764009', '94765005', '94766006', '94767002',
        '94768007', '94769004', '94770003', '94771004', '94772006', '94773001', '94774007',
        '94775008', '94776009', '94777000', '94778005', '94779002', '94780004', '94781000',
        '94782007', '94783002', '94784008', '94785009', '94786005', '94787001', '94788006',
        '94789003', '94790007', '94791006', '94792004', '94793009', '94794003', '94795002',
        '94796001', '94797005', '94798000', '94799008', '94800007', '94801006', '94802004',
        '94803009', '94804003', '94805002', '94806001', '94807005', '94808000', '94809008',
        '94810003', '94811004', '94812006', '94813001', '94814007', '94815008', '94816009',
        '94817000', '94818005', '94819002', '94820008', '94821007', '94822000', '94823005',
        '94824004', '94825003', '94826002', '94827006', '94828001', '94829009', '94830004',
        '94831000', '94832007', '94833002', '94834008', '94835009', '94836005', '94837001',
        '94838006', '94839003', '94840001', '94841002', '94842009', '94843004', '94844005',
        '94845006', '94846007', '94847003', '94848008', '94849000', '94850000', '94851001',
        '94852008', '94853003', '94854009', '94855005', '94856006', '94857002', '94858007',
        '94860009', '94861008', '94862001', '94863006', '94864000', '94865004', '94866003',
        '94867007', '94868002', '94869005', '94870006', '94871005', '94872003', '94873008',
        '94874002', '94875001', '94876000', '94877009', '94878004', '94879007', '94880005',
        '94881009', '94882002', '94883007', '94884001', '94885000', '94886004', '94887008',
        '94888003', '94889006', '94890002', '94891003', '94893000', '94894006', '94895007',
        '94896008', '94897004', '94898009', '94899001', '94900006', '94901005', '94902003',
        '94903008', '94904002', '94905001', '94907009', '94908004', '94909007', '94910002',
        '94911003', '94912005', '94913000', '94914006', '94915007', '94916008', '94917004',
        '94918009', '94919001', '94920007', '94921006', '94922004', '94924003', '94925002',
        '94926001', '94928000', '94929008', '94930003', '94931004', '94932006', '94933001',
        '94934007', '94935008', '94936009', '94937000', '94938005', '94939002', '94940000',
        '94941001', '94942008', '94943003', '94944009', '94945005', '94946006', '94947002',
        '94948007', '94949004', '94950004', '94951000', '94952007', '94953002', '94954008',
        '94955009', '94956005', '94957001', '94958006', '94959003', '94960008', '94961007',
        '94962000', '94963005', '94964004', '94965003', '94966002', '94967006', '94968001',
        '94969009', '94970005', '94971009', '94972002', '94973007', '94974001', '94975000',
        '94976004', '94977008', '94978003', '94979006', '94980009', '94982001', '94983006',
        '94984000', '94985004', '94986003', '94987007', '94988002', '94989005', '94990001',
        '94991002', '94992009', '94993004', '94994005', '94995006', '94996007', '94997003',
        '94998008', '94999000', '95000000', '95001001', '95002008', '95003003', '95004009',
        '95005005', '95006006', '95007002', '95008007', '95009004', '95010009', '95011008',
        '95012001', '95013006', '95014000', '95015004', '95016003', '95017007', '95018002',
        '95019005', '95020004', '95021000', '95022007', '95023002', '95024008', '95025009',
        '95026005', '95027001', '95028006', '95029003', '95030008', '95031007', '95032000',
        '95033005', '95034004', '95035003', '95036002', '95037006', '95038001', '95039009',
        '95040006', '95041005', '95042003', '95043008', '95044002', '95045001', '95046000',
        '95047009', '95048004', '95049007', '95050007', '95051006', '95052004', '95053009',
        '95054003', '95055002', '95056001', '95057005', '95058000', '95059008', '95060003',
        '95061004', '95062006', '95063001', '95064007', '95065008', '95066009', '95067000',
        '95068005', '95069002', '95070001', '95071002', '95072009', '95073004', '95074005',
        '95075006', '95076007', '95077003', '95078008', '95079000', '95080002', '95081003',
        '95082005', '95083000', '95084006', '95085007', '95086008', '95087004', '95088009',
        '95089001', '95090005', '95091009', '95092002', '95093007', '95094001', '95095000',
        '95096004', '95097008', '95098003', '95099006', '95100003', '95101004', '95102006',
        '95103001', '95104007', '95105008', '95106009', '95107000', '95108005', '95109002',
        '95110007', '95111006', '95112004', '95113009', '95115002', '95116001', '95118000',
        '95119008', '95120002', '95121003', '95122005', '95123000', '95124006', '95125007',
        '95126008', '95127004', '95128009', '95129001', '95130006', '95131005', '95132003',
        '95133008', '95134002', '95135001', '95136000', '95137009', '95138004', '95139007',
        '95140009', '95141008', '95142001', '95143006', '95144000', '95145004', '95146003',
        '95147007', '95148002', '95149005', '95150005', '95151009', '95152002', '95153007',
        '95154001', '95155000', '95156004', '95157008', '95158003', '95159006', '95160001',
        '95161002', '95162009', '95163004', '95164005', '95165006', '95166007', '95167003',
        '95168008', '95169000', '95170004', '95171000', '95172007', '95173002', '95174008',
        '95175009', '95176005', '95177001', '95178006', '95179003', '95180000', '95181001',
        '95182008', '95183003', '95184009', '95185005', '95186006', '95187002', '95188007',
        '95192000', '95193005', '95194004', '95209008', '95210003', '95214007', '95224004',
        '95225003', '95226002', '95230004', '95231000', '95260009', '95261008', '95263006',
        '95264000'
    }


class Benztropine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent benztropine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; benztropine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; benztropine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1361'
    VALUE_SET_NAME = 'Benztropine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'885209', '885213', '885219'}


class DentalCaries(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of dental caries.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who have had dental carries.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.125.12.1004'
    VALUE_SET_NAME = 'Dental Caries'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'K023', 'K0251', 'K0252', 'K0253', 'K0261', 'K0262', 'K0263', 'K027', 'K029'}

    ICD9CM = {
        '52100', '52101', '52102', '52103', '52104', '52105', '52106', '52107', '52108', '52109'
    }

    SNOMEDCT = {
        '109564008', '109566005', '109568006', '109569003', '109570002', '109571003', '109572005',
        '109573000', '109574006', '109575007', '109576008', '109577004', '109578009', '109580003',
        '109581004', '15733007', '163152009', '196298000', '196299008', '196301001', '196302008',
        '196305005', '234976000', '30512007', '442231009', '442551007', '699489009', '699490000',
        '699491001', '699492008', '699494009', '699495005', '700046006', '702402003', '733939000',
        '733940003', '733941004', '733942006', '733943001', '733944007', '733945008', '733946009',
        '733947000', '733948005', '733968004', '733970008', '733972000', '733974004', '733976002',
        '768639006', '768641007', '768643005', '768646002', '768649009', '768653006', '769017001',
        '769020009', '769021008', '80353004', '80967001', '95246007', '95247003', '95248008',
        '95249000', '95252008', '95253003', '95254009'
    }


class PneumococcalVaccineAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent administration of pneumococcal vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with administration of the pneumococcal vaccine. This is a grouping of CVX and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1034'
    VALUE_SET_NAME = 'Pneumococcal Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90670'}

    SNOMEDCT = {'12866006', '394678003'}


class AdditionalEvaluationForDepressionAdult(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent interventions and procedures where an adult patient received additional evaluation to determine the presence of depression.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with psychiatric interview and evaluation for testamentary capacity, rehabilitation, criminal responsibility, bipolar disorder and mental status.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1545'
    VALUE_SET_NAME = 'Additional evaluation for depression - adult'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '10197000', '10997001', '165171009', '165190001', '370803007', '38756009',
        '429441000124107', '45392008', '79094001', '90407005'
    }


class StatusPostLeftMastectomy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a history of a left mastectomy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with patients that have a history of a left mastectomy. This is a grouping of SNOMED CT and ICD-10-CM codes.
    Exclusion Criteria: Excludes codes that indicate a right or bilateral mastectomy or are unspecified.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1069'
    VALUE_SET_NAME = 'Status Post Left Mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z9012'}

    SNOMEDCT = {'137671000119105', '429009003'}


class AlcoholAndDrugDependenceTreatment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent treatment for alcohol and drug dependence.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with assessment, management, and both psychosocial and pharmacological treatment of alcohol and drug dependence. This is a grouping of SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1005'
    VALUE_SET_NAME = 'Alcohol and Drug Dependence Treatment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '171047005', '20093000', '23915005', '24165007', '266707007', '310653000', '313071005',
        '370881007', '370884004', '385989002', '386448003', '386449006', '386450006', '386451005',
        '408933008', '408934002', '408935001', '408936000', '408941008', '408942001', '408943006',
        '408944000', '408945004', '408947007', '408948002', '410419007', '413473000', '423416000',
        '424148004', '424407005', '424589009', '426928008', '429291000124102', '56876005',
        '60112009', '707166002', '720174008', '720175009', '720176005', '720177001', '737363002'
    }


class AverageNumberOfDrinksPerDrinkingDay(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a patient's number of alcoholic drinks per drinking day.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Assessment, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying a quantitative observation of the reported number of alcoholic drinks per drinking day. This is a grouping of a LOINC code.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1018'
    VALUE_SET_NAME = 'Average Number of Drinks per Drinking Day'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'11287-0'}


class TobaccoUseCessationPharmacotherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent medications that may be used to assist patients in decreasing or quitting tobacco use.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; bupropion hydrochloride, nicotine products (e.g., chewing gum, nasal spray, etc.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable.
    """

    OID = '2.16.840.1.113883.3.526.3.1190'
    VALUE_SET_NAME = 'Tobacco Use Cessation Pharmacotherapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1232585', '151226', '1551468', '1797886', '1801289', '198029', '198030', '198031',
        '198045', '198046', '198047', '199283', '199888', '199889', '199890', '205315', '205316',
        '250983', '311975', '312036', '314119', '317136', '359817', '359818', '636671', '636676',
        '749289', '749788', '892244', '993503', '993518', '993536', '993541', '993550', '993557',
        '993567', '993681', '993687', '993691', '998671', '998675', '998679'
    }


class Hypotension(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of hypotension.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of hypotension.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.370'
    VALUE_SET_NAME = 'Hypotension'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I950', 'I951', 'I952', 'I953', 'I9581', 'I9589', 'I959'}

    ICD9CM = {'4580', '4581', '45821', '45829', '4588', '4589'}

    SNOMEDCT = {
        '195506001', '200113008', '200114002', '230664009', '234171009', '271870002', '286963007',
        '371073003', '408667000', '408668005', '429561008', '45007003', '61933008', '70247006',
        '75181005', '77545000', '88887003'
    }


class HepatitisB(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hepatitis B infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with hepatitis B infections. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1025'
    VALUE_SET_NAME = 'Hepatitis B'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'B160', 'B161', 'B162', 'B169', 'B170', 'B180', 'B181', 'B1910', 'B1911'}

    SNOMEDCT = {
        '1116000', '111891008', '13265006', '153091000119109', '165806002', '186624004',
        '186626002', '186639003', '235864009', '235865005', '235869004', '235871004', '26206000',
        '271511000', '313234004', '38662009', '406117000', '424099008', '424340000', '442134007',
        '442374005', '446698005', '50167007', '53425008', '60498001', '61977001', '66071002',
        '76795007'
    }


class DementiaMentalDegenerations(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dementia diagnoses and mental degenerations diagnoses.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with dementia diagnoses and mental degeneration diagnoses.
    Exclusion Criteria: Excludes dementia and mental degeneration diagnoses in remission.
    """

    OID = '2.16.840.1.113883.3.526.3.1005'
    VALUE_SET_NAME = 'Dementia & Mental Degenerations'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A5217', 'F0150', 'F0151', 'F0280', 'F0281', 'F0390', 'F0391', 'F05', 'F068', 'G300',
        'G301', 'G308', 'G309', 'G3101', 'G3109', 'G3183'
    }

    ICD9CM = {
        '0941', '2900', '29010', '29011', '29012', '29013', '29020', '29021', '2903', '29040',
        '29041', '29042', '29043', '2908', '2909', '29410', '29411', '29420', '29421', '2948',
        '3310', '33111', '33119', '33182'
    }

    SNOMEDCT = {
        '10349009', '10532003', '111480006', '12348006', '14070001', '15662003', '191449005',
        '191451009', '191452002', '191454001', '191455000', '191457008', '191458003', '191459006',
        '191461002', '191463004', '191464005', '191465006', '191466007', '191493005',
        '22381000119105', '230258005', '230270009', '230282000', '230283005', '230285003',
        '230286002', '230287006', '230288001', '230289009', '25772007', '26852004', '278857002',
        '279982005', '281004', '31081000119101', '312991009', '32875003', '371024007', '371026009',
        '416780008', '420614009', '421023003', '421529006', '425390006', '429458009', '429998004',
        '430771000124100', '442344002', '4817008', '51928006', '52448006', '54502004', '55009008',
        '56267009', '59651006', '62239001', '6475002', '65096006', '66108005', '698624003',
        '698625002', '698626001', '698687007', '698725008', '698726009', '698781002', '702393003',
        '702426001', '702429008', '703544004', '70936005', '713488003', '713844000', '715737004',
        '716667005', '716994006', '722977005', '722978000', '722979008', '722980006', '723123001',
        '723390000', '724776007', '724777003', '724992007', '725898002', '733184002', '733185001',
        '733190003', '733191004', '733192006', '733193001', '733194007', '762350007', '762351006',
        '762707000', '79341000119107', '82959004', '90099008', '9345005'
    }


class DiabeticNephropathy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of diabetic nephropathy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with patients who have diabetic nephropathy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1004'
    VALUE_SET_NAME = 'Diabetic Nephropathy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'E0821', 'E0822', 'E0829', 'E0921', 'E0922', 'E0929', 'E1021', 'E1022', 'E1029', 'E1121',
        'E1122', 'E1129', 'E1321', 'E1322', 'E1329'
    }

    ICD9CM = {'25041', '25042', '25043'}

    SNOMEDCT = {
        '127013003', '236499007', '236500003', '38046004', '401110002', '420514000', '420715001',
        '421305000', '421986006', '445170001', '54181000'
    }


class HipFractureSurgery(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent procedures of hip fracture surgery.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients who have a hip fracture surgery procedure.
    Inclusion Criteria: Includes only relevant concepts associated with representing hip fracture surgery.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.258'
    VALUE_SET_NAME = 'Hip Fracture Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {'0SQ90ZZ', '0SQ9XZZ', '0SQB0ZZ', '0SQBXZZ'}

    SNOMEDCT = {
        '16174006', '239499008', '239500004', '265745003', '32972004', '44167006', '47458005',
        '61509005', '73764009', '83381006', '87618002'
    }


class PsychiatricmentalHealthDiagnosis(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent diagnoses commonly used in the inpatient setting for psychiatric and mental health disorders.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attributes related to Diagnosis. The intent of this data element is to identify patients who have an active diagnosis of a psychiatric or mental health disorder.
    Inclusion Criteria: Includes only relevant concepts associated with representing an active diagnosis for psychiatric and mental health disorders using ICD-10-CM and SNOMED CT codes systems.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.299'
    VALUE_SET_NAME = 'Psychiatric/Mental Health Diagnosis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'F0150', 'F0151', 'F0390', 'F0391', 'F04', 'F05', 'F060', 'F061', 'F062', 'F0630', 'F0631',
        'F0632', 'F0633', 'F0634', 'F064', 'F068', 'F070', 'F0781', 'F0789', 'F079', 'F09',
        'F1010', 'F1011', 'F10120', 'F10121', 'F10129', 'F1014', 'F10150', 'F10151', 'F10159',
        'F10180', 'F10181', 'F10182', 'F10188', 'F1019', 'F1020', 'F1021', 'F10220', 'F10221',
        'F10229', 'F10230', 'F10231', 'F10232', 'F10239', 'F1024', 'F10250', 'F10251', 'F10259',
        'F1026', 'F1027', 'F10280', 'F10281', 'F10282', 'F10288', 'F1029', 'F10920', 'F10921',
        'F10929', 'F1094', 'F10950', 'F10951', 'F10959', 'F1096', 'F1097', 'F10980', 'F10981',
        'F10982', 'F10988', 'F1099', 'F1110', 'F1111', 'F11120', 'F11121', 'F11122', 'F11129',
        'F1114', 'F11150', 'F11151', 'F11159', 'F11181', 'F11182', 'F11188', 'F1119', 'F1120',
        'F1121', 'F11220', 'F11221', 'F11222', 'F11229', 'F1123', 'F1124', 'F11250', 'F11251',
        'F11259', 'F11281', 'F11282', 'F11288', 'F1129', 'F1190', 'F11920', 'F11921', 'F11922',
        'F11929', 'F1193', 'F1194', 'F11950', 'F11951', 'F11959', 'F11981', 'F11982', 'F11988',
        'F1199', 'F1210', 'F1211', 'F12120', 'F12121', 'F12122', 'F12129', 'F12150', 'F12151',
        'F12159', 'F12180', 'F12188', 'F1219', 'F1220', 'F1221', 'F12220', 'F12221', 'F12222',
        'F12229', 'F1223', 'F12250', 'F12251', 'F12259', 'F12280', 'F12288', 'F1229', 'F1290',
        'F12920', 'F12921', 'F12922', 'F12929', 'F1293', 'F12950', 'F12951', 'F12959', 'F12980',
        'F12988', 'F1299', 'F1310', 'F1311', 'F13120', 'F13121', 'F13129', 'F1314', 'F13150',
        'F13151', 'F13159', 'F13180', 'F13181', 'F13182', 'F13188', 'F1319', 'F1320', 'F1321',
        'F13220', 'F13221', 'F13229', 'F13230', 'F13231', 'F13232', 'F13239', 'F1324', 'F13250',
        'F13251', 'F13259', 'F1326', 'F1327', 'F13280', 'F13281', 'F13282', 'F13288', 'F1329',
        'F1390', 'F13920', 'F13921', 'F13929', 'F13930', 'F13931', 'F13932', 'F13939', 'F1394',
        'F13950', 'F13951', 'F13959', 'F1396', 'F1397', 'F13980', 'F13981', 'F13982', 'F13988',
        'F1399', 'F1410', 'F1411', 'F14120', 'F14121', 'F14122', 'F14129', 'F1414', 'F14150',
        'F14151', 'F14159', 'F14180', 'F14181', 'F14182', 'F14188', 'F1419', 'F1420', 'F1421',
        'F14220', 'F14221', 'F14222', 'F14229', 'F1423', 'F1424', 'F14250', 'F14251', 'F14259',
        'F14280', 'F14281', 'F14282', 'F14288', 'F1429', 'F1490', 'F14920', 'F14921', 'F14922',
        'F14929', 'F1494', 'F14950', 'F14951', 'F14959', 'F14980', 'F14981', 'F14982', 'F14988',
        'F1499', 'F1510', 'F1511', 'F15120', 'F15121', 'F15122', 'F15129', 'F1514', 'F15150',
        'F15151', 'F15159', 'F15180', 'F15181', 'F15182', 'F15188', 'F1519', 'F1520', 'F1521',
        'F15220', 'F15221', 'F15222', 'F15229', 'F1523', 'F1524', 'F15250', 'F15251', 'F15259',
        'F15280', 'F15281', 'F15282', 'F15288', 'F1529', 'F1590', 'F15920', 'F15921', 'F15922',
        'F15929', 'F1593', 'F1594', 'F15950', 'F15951', 'F15959', 'F15980', 'F15981', 'F15982',
        'F15988', 'F1599', 'F1610', 'F1611', 'F16120', 'F16121', 'F16122', 'F16129', 'F1614',
        'F16150', 'F16151', 'F16159', 'F16180', 'F16183', 'F16188', 'F1619', 'F1620', 'F1621',
        'F16220', 'F16221', 'F16229', 'F1624', 'F16250', 'F16251', 'F16259', 'F16280', 'F16283',
        'F16288', 'F1629', 'F1690', 'F16920', 'F16921', 'F16929', 'F1694', 'F16950', 'F16951',
        'F16959', 'F16980', 'F16983', 'F16988', 'F1699', 'F1810', 'F1811', 'F18120', 'F18121',
        'F18129', 'F1814', 'F18150', 'F18151', 'F18159', 'F1817', 'F18180', 'F18188', 'F1819',
        'F1820', 'F1821', 'F18220', 'F18221', 'F18229', 'F1824', 'F18250', 'F18251', 'F18259',
        'F1827', 'F18280', 'F18288', 'F1829', 'F1890', 'F18920', 'F18921', 'F18929', 'F1894',
        'F18950', 'F18951', 'F18959', 'F1897', 'F18980', 'F18988', 'F1899', 'F1910', 'F1911',
        'F19120', 'F19121', 'F19122', 'F19129', 'F1914', 'F19150', 'F19151', 'F19159', 'F1916',
        'F1917', 'F19180', 'F19181', 'F19182', 'F19188', 'F1919', 'F1920', 'F1921', 'F19220',
        'F19221', 'F19222', 'F19229', 'F19230', 'F19231', 'F19232', 'F19239', 'F1924', 'F19250',
        'F19251', 'F19259', 'F1926', 'F1927', 'F19280', 'F19281', 'F19282', 'F19288', 'F1929',
        'F1990', 'F19920', 'F19921', 'F19922', 'F19929', 'F19930', 'F19931', 'F19932', 'F19939',
        'F1994', 'F19950', 'F19951', 'F19959', 'F1996', 'F1997', 'F19980', 'F19981', 'F19982',
        'F19988', 'F1999', 'F200', 'F201', 'F202', 'F203', 'F205', 'F2081', 'F2089', 'F209', 'F21',
        'F22', 'F23', 'F24', 'F250', 'F251', 'F258', 'F259', 'F28', 'F29', 'F3010', 'F3011',
        'F3012', 'F3013', 'F302', 'F303', 'F304', 'F308', 'F309', 'F310', 'F3110', 'F3111',
        'F3112', 'F3113', 'F312', 'F3130', 'F3131', 'F3132', 'F314', 'F315', 'F3160', 'F3161',
        'F3162', 'F3163', 'F3164', 'F3170', 'F3171', 'F3172', 'F3173', 'F3174', 'F3175', 'F3176',
        'F3177', 'F3178', 'F3181', 'F3189', 'F319', 'F320', 'F321', 'F322', 'F323', 'F324', 'F325',
        'F3281', 'F3289', 'F329', 'F330', 'F331', 'F332', 'F333', 'F3340', 'F3341', 'F3342',
        'F338', 'F339', 'F340', 'F341', 'F3481', 'F3489', 'F349', 'F39', 'F4000', 'F4001', 'F4002',
        'F4010', 'F4011', 'F40210', 'F40218', 'F40220', 'F40228', 'F40230', 'F40231', 'F40232',
        'F40233', 'F40240', 'F40241', 'F40242', 'F40243', 'F40248', 'F40290', 'F40291', 'F40298',
        'F408', 'F409', 'F410', 'F411', 'F413', 'F418', 'F419', 'F422', 'F423', 'F424', 'F428',
        'F429', 'F430', 'F4310', 'F4311', 'F4312', 'F4320', 'F4321', 'F4322', 'F4323', 'F4324',
        'F4325', 'F4329', 'F438', 'F439', 'F440', 'F441', 'F442', 'F444', 'F445', 'F446', 'F447',
        'F4481', 'F4489', 'F449', 'F450', 'F451', 'F4520', 'F4521', 'F4522', 'F4529', 'F4541',
        'F4542', 'F458', 'F459', 'F481', 'F482', 'F488', 'F489', 'F5000', 'F5001', 'F5002', 'F502',
        'F5081', 'F5082', 'F5089', 'F509', 'F5101', 'F5102', 'F5103', 'F5104', 'F5105', 'F5109',
        'F5111', 'F5112', 'F5113', 'F5119', 'F513', 'F514', 'F515', 'F518', 'F519', 'F520', 'F521',
        'F5221', 'F5222', 'F5231', 'F5232', 'F524', 'F525', 'F526', 'F528', 'F529', 'F530', 'F550',
        'F551', 'F552', 'F553', 'F554', 'F558', 'F59', 'F600', 'F601', 'F602', 'F603', 'F604',
        'F605', 'F606', 'F607', 'F6081', 'F6089', 'F609', 'F630', 'F631', 'F632', 'F633', 'F6381',
        'F6389', 'F639', 'F640', 'F641', 'F642', 'F648', 'F649', 'F650', 'F651', 'F652', 'F653',
        'F654', 'F6550', 'F6551', 'F6552', 'F6581', 'F6589', 'F659', 'F66', 'F6810', 'F6811',
        'F6812', 'F6813', 'F688', 'F68A', 'F69', 'F70', 'F71', 'F72', 'F73', 'F78', 'F79', 'F800',
        'F801', 'F802', 'F804', 'F8081', 'F8082', 'F8089', 'F809', 'F810', 'F812', 'F8181',
        'F8189', 'F819', 'F82', 'F840', 'F842', 'F843', 'F845', 'F848', 'F849', 'F88', 'F89',
        'F900', 'F901', 'F902', 'F908', 'F909', 'F910', 'F911', 'F912', 'F913', 'F918', 'F919',
        'F930', 'F938', 'F939', 'F940', 'F941', 'F942', 'F948', 'F949', 'F950', 'F951', 'F952',
        'F958', 'F959', 'F980', 'F981', 'F9821', 'F9829', 'F983', 'F984', 'F985', 'F988', 'F989',
        'F99', 'G2561', 'R37', 'R401', 'R404', 'R410', 'R411', 'R412', 'R413', 'R4182', 'R4189',
        'R440', 'R441', 'R442', 'R443', 'R448', 'R450', 'R451', 'R452', 'R453', 'R454', 'R455',
        'R456', 'R457', 'R4581', 'R4582', 'R4583', 'R4584', 'R45850', 'R45851', 'R4587', 'R4589',
        'R461', 'R462', 'R463', 'R465', 'R466', 'R467', 'R4681', 'R4689', 'Z554', 'Z563', 'Z564',
        'Z5681', 'Z592', 'Z600', 'Z603', 'Z604', 'Z605', 'Z620', 'Z621', 'Z6222', 'Z6229', 'Z623',
        'Z626', 'Z62810', 'Z62811', 'Z62812', 'Z62813', 'Z62819', 'Z62820', 'Z62821', 'Z62822',
        'Z62890', 'Z62891', 'Z62898', 'Z629', 'Z630', 'Z631', 'Z634', 'Z635', 'Z6371', 'Z6372',
        'Z6379', 'Z638', 'Z644', 'Z658', 'Z69010', 'Z69011', 'Z69020', 'Z69021', 'Z6911', 'Z6912',
        'Z6981', 'Z6982', 'Z700', 'Z701', 'Z702', 'Z703', 'Z708', 'Z709', 'Z7141', 'Z7142',
        'Z7151', 'Z7152', 'Z7189', 'Z7251', 'Z7252', 'Z7253', 'Z726', 'Z72810', 'Z72811', 'Z72820',
        'Z72821', 'Z7289', 'Z730', 'Z731', 'Z733', 'Z734', 'Z735', 'Z73810', 'Z73811', 'Z73812',
        'Z73819', 'Z7389', 'Z8651', 'Z8659', 'Z87820', 'Z87890', 'Z91410', 'Z91411', 'Z91412',
        'Z91419', 'Z9142', 'Z9149', 'Z915'
    }

    SNOMEDCT = {
        '10278007', '10327003', '10349009', '10532003', '105491000119107', '106013002',
        '106014008', '109006', '109805003', '109899002', '11003002', '110281001', '11061003',
        '111475002', '111476001', '111477005', '111479008', '111480006', '111482003', '111483008',
        '111484002', '111485001', '111487009', '111490003', '111491004', '111492006', '11387009',
        '1145003', '11806006', '11941006', '1196001', '12348006', '126943008', '128293007',
        '129104009', '12939007', '129562004', '129602009', '129604005', '12969000',
        '130121000119104', '13313007', '13438001', '13601005', '13670005', '13746004', '1376001',
        '1380006', '1383008', '14070001', '14077003', '14183003', '14291003', '14495005',
        '145841000119107', '1471000119103', '14784000', '1499003', '15193003', '15277004',
        '153501000119105', '15639000', '15662003', '1581000119101', '15945005', '15977008',
        '162004', '162204000', '162702000', '16295005', '16506000', '16805009', '1686006',
        '16966009', '16990005', '17226007', '17496003', '17782008', '17961008', '18003009',
        '18085000', '1816003', '18260003', '18393005', '18478005', '18541000119100', '18653004',
        '18689007', '18818009', '18941000', '191447007', '191449005', '191451009', '191452002',
        '191454001', '191455000', '191457008', '191458003', '191459006', '191461002', '191463004',
        '191464005', '191465006', '191466007', '191475009', '191476005', '191478006', '191480000',
        '191483003', '191484009', '191485005', '191486006', '191492000', '191493005', '191494004',
        '191495003', '191496002', '191499009', '191501001', '191502008', '191503003', '191504009',
        '191505005', '191507002', '191508007', '191509004', '191510009', '191511008', '191512001',
        '191519005', '191525009', '191526005', '191527001', '191531007', '191539009', '191542003',
        '191547009', '191548004', '191554003', '191555002', '191559008', '191561004', '191562006',
        '191563001', '191564007', '191567000', '191569002', '191570001', '191571002', '191572009',
        '191574005', '191577003', '191583000', '191584006', '191586008', '191588009', '191590005',
        '191592002', '191593007', '191595000', '191597008', '191604000', '191610000', '191611001',
        '191613003', '191616006', '191618007', '191620005', '191621009', '191623007', '191625000',
        '191627008', '191629006', '191630001', '191634005', '191636007', '191638008', '191639000',
        '191641004', '191643001', '191658009', '191659001', '191668004', '191670008', '191672000',
        '191676002', '191677006', '191680007', '191683009', '191687005', '191692007', '191693002',
        '191696005', '191697001', '191714002', '191722009', '191724005', '191725006', '191726007',
        '191736004', '191737008', '191738003', '191746002', '191753006', '191765005', '191772006',
        '191773001', '191774007', '191787001', '191804003', '191805002', '191811004', '191812006',
        '191813001', '191819002', '191820008', '191821007', '191825003', '191826002', '191831000',
        '191832007', '191833002', '191837001', '191838006', '191839003', '191843004', '191844005',
        '191845006', '191849000', '191853003', '191855005', '191865004', '191867007', '191868002',
        '191873008', '191874002', '191875001', '191887008', '191888003', '191889006', '191928000',
        '191952007', '191965003', '191970005', '191972002', '191973007', '191980009', '191990001',
        '191997003', '192003008', '192007009', '192014006', '192016008', '192017004', '192029008',
        '192037000', '192038005', '192041001', '192042008', '192044009', '192046006', '192049004',
        '192051000', '192056005', '192057001', '192058006', '192063005', '192064004', '192072002',
        '192073007', '192080009', '192082001', '192097003', '192099000', '192100008', '192108001',
        '192110004', '192118006', '192123006', '192127007', '192138007', '192147004', '192362008',
        '192527004', '192562009', '192575009', '192611004', '192616009', '192630004', '192631000',
        '19300006', '193462001', '193756007', '194437008', '19445006', '1973000', '197480006',
        '19766004', '19922006', '199257008', '199259006', '199260001', '199261002', '199262009',
        '20010003', '20250007', '20385005', '20871009', '20876004', '20960007', '21000000',
        '21586000', '21647008', '21897009', '21900002', '22121000', '22230001', '22381000119105',
        '22407005', '22419002', '22574000', '229621000', '229623002', '229629003', '229630008',
        '229632000', '229672009', '229683000', '229699006', '229700007', '229715008', '229729009',
        '229733002', '229734008', '229736005', '229740001', '229744005', '229745006', '229750000',
        '229751001', '230258005', '230282000', '230286002', '230287006', '230288001', '230289009',
        '230334008', '230335009', '230338006', '230455006', '230488004', '230497000', '2312009',
        '231437006', '231438001', '231439009', '231440006', '231442003', '231444002', '231445001',
        '231446000', '231449007', '231450007', '231451006', '231452004', '231454003', '231458000',
        '231459008', '231461004', '231467000', '231470001', '231472009', '231473004', '231474005',
        '231475006', '231485007', '231487004', '231489001', '231494001', '231495000', '231496004',
        '231500002', '231504006', '231517009', '231518004', '231519007', '231520001', '231522009',
        '231523004', '231524005', '231525006', '231526007', '231527003', '231528008', '231532002',
        '231536004', '231538003', '231539006', '231540008', '231541007', '231542000', '233690008',
        '23560001', '236074001', '23645006', '237349002', '237351003', '237352005', '23772009',
        '238959007', '238961003', '238967004', '238972008', '238973003', '238974009', '238975005',
        '238977002', '238979004', '2403008', '24121004', '24125008', '24315006', '247444006',
        '247803002', '247804008', '24781009', '248118000', '248290002', '249520001', '25501002',
        '25753007', '25766007', '25772007', '25922000', '25971005', '26025008', '2618002',
        '26203008', '26416006', '26453000', '26516009', '26665006', '26714005', '26852004',
        '268612007', '268617001', '268619003', '268621008', '268622001', '268624000', '268633003',
        '268640002', '268650001', '268651002', '268652009', '268654005', '268661009', '268664001',
        '268666004', '268667008', '268668003', '268669006', '268672004', '268715000', '268722008',
        '268727002', '268734000', '268957000', '270901009', '270902002', '270903007', '270905000',
        '271428004', '271952001', '27387000', '274948002', '274950005', '274952002', '274953007',
        '27544004', '275471001', '275474009', '276300008', '2776000', '278506006', '278508007',
        '278852008', '278853003', '278857002', '278919001', '27956007', '279982005', '280032002',
        '280982009', '280983004', '280984005', '280986007', '280994000', '281004', '2815001',
        '28357009', '28368009', '28475009', '28663008', '28676002', '286933003', '288081000119106',
        '288091000119109', '288101000119104', '288281000119100', '288511000119108', '28857002',
        '28864000', '28884001', '29212009', '29599000', '29733004', '29929003', '30059008',
        '300706003', '30077003', '300992002', '301643003', '30169000', '302507002', '30310000',
        '30336007', '30491001', '30509009', '30520009', '30605009', '30687003', '307417003',
        '30871003', '30935000', '310202009', '31027006', '310495003', '310496002', '310497006',
        '3109008', '311173003', '31177006', '312098001', '312936002', '312991009', '313182004',
        '31373002', '313915006', '31446002', '3158007', '31611000', '31658008', '31715000',
        '31781004', '317816007', '318784009', '319768000', '32009006', '320751009', '321717001',
        '32358001', '32388005', '32552001', '32721004', '32875003', '32880007', '3298001',
        '33078009', '33135002', '33323008', '33380008', '33449004', '33693007', '33736005',
        '33871004', '34116005', '34315001', '34938008', '3503000', '35218008', '35252006',
        '35253001', '35481005', '35489007', '35607004', '35722002', '35827000', '35846004',
        '35919005', '36124002', '361272001', '36158005', '36170009', '36217008', '36474008',
        '36583000', '36622002', '367515004', '36923009', '370143000', '371024007', '371026009',
        '371596008', '371599001', '371600003', '371604007', '371631005', '37224001', '37331004',
        '373618009', '37739004', '37746008', '37868008', '37872007', '38328002', '38368003',
        '38451003', '38547003', '386537007', '386805003', '386810004', '386821008', '386822001',
        '386823006', '386824000', '386825004', '38694004', '39003006', '3914008', '39465007',
        '3972004', '397923000', '398066007', '39807006', '39809009', '39951001', '40083003',
        '402732001', '402733006', '402735004', '402736003', '402737007', '403474003', '403582001',
        '403583006', '403586003', '403590001', '403593004', '403594005', '40379007', '40568001',
        '40571009', '406506008', '408856003', '408858002', '40926005', '40987004', '41083005',
        '41524005', '41526007', '41552001', '416073003', '416340002', '416714005', '416780008',
        '416975007', '417143004', '417360004', '41836007', '418475009', '420614009', '421023003',
        '421529006', '42344001', '425390006', '425476007', '425499006', '425533007', '425832009',
        '425881006', '425885002', '425914008', '425919003', '42594001', '426095000', '426174008',
        '426590003', '426824009', '426873000', '427205009', '427229002', '427327003', '427975003',
        '42868002', '428687006', '428703001', '42925002', '429458009', '429571005', '429672007',
        '429998004', '4306003', '430744005', '430751001', '430852001', '430909002', '43150009',
        '43497001', '43568002', '43614003', '43769008', '439960005', '44124003', '441527004',
        '441704009', '441711008', '441716003', '441833000', '442057004', '442059001', '442176004',
        '442243005', '442245003', '442344002', '442351006', '442406005', '443265004', '443735008',
        '44376007', '443919007', '4441000', '44433009', '444613000', '446175003', '446180007',
        '44966003', '45479006', '45677003', '45912004', '45924006', '46023009', '46206005',
        '46229002', '46244001', '46372006', '46432001', '46721000', '46762006', '46975003',
        '472981000', '47372000', '47447001', '47505003', '47664006', '47916000', '4817008',
        '48309007', '48500005', '48589009', '4863002', '48826008', '48937005', '4926007',
        '4932002', '49468007', '49512000', '49540005', '49564006', '5002000', '50026000',
        '50299009', '50320000', '50705009', '50722006', '50878001', '50933003', '5095008',
        '50983008', '51133006', '51443000', '51493001', '5158005', '51637008', '52448006',
        '52866005', '52910006', '52954000', '53049002', '53050002', '53333005', '53467004',
        '53607008', '53936005', '53956006', '54319003', '54417002', '5444000', '54502004',
        '54587008', '5464005', '54761006', '55009008', '5509004', '5510009', '55341008',
        '55516002', '55668003', '55728007', '55736003', '55967005', '56034001', '56267009',
        '56294008', '56573006', '56576003', '56627002', '5664002', '568005', '56882008', '5703000',
        '57194009', '57588009', '57715001', '58214004', '58329000', '58535001', '58647003',
        '58703003', '58727001', '59174009', '59216005', '59252009', '596004', '59617007',
        '59645001', '59651006', '59923000', '600009', '60099002', '60103007', '60123008',
        '609225004', '61104008', '61144001', '61180001', '61212007', '61403008', '61569007',
        '61901004', '62351001', '62491004', '62792007', '63181006', '63249007', '63393005',
        '6348008', '63649001', '63701002', '63778009', '63835008', '63909006', '63983005',
        '64060000', '64165008', '64731001', '6475002', '64905009', '65064003', '65096006',
        '65410009', '66108005', '66214007', '66307007', '66344007', '66347000', '66381006',
        '66590003', '66631006', '66936004', '67002003', '67123006', '67227000', '67711008',
        '68019004', '68569003', '68890003', '68963006', '68995007', '69322001', '69392006',
        '69479009', '698958008', '70043001', '7025000', '70328006', '70340006', '7052005',
        '70546001', '70691001', '7071007', '70747007', '70764005', '70814008', '70922000',
        '70932007', '70936005', '71103003', '71294008', '71328000', '71336009', '715924009',
        '71959007', '71961003', '71984005', '7200002', '72366004', '72861004', '7291006',
        '73097000', '73462009', '73867007', '7397008', '73972002', '74007000', '74010007',
        '74266001', '7461003', '74686005', '74732009', '74791000', '74850006', '74934004',
        '75084000', '75122001', '75360000', '75752004', '75837004', '76236006', '76441001',
        '765176007', '76566000', '766822004', '76812003', '76868007', '77355000', '77475008',
        '77486005', '77675002', '77815007', '77911002', '7794004', '78004001', '78269000',
        '78358001', '78640000', '78667006', '78689005', '79204003', '79298009', '79584002',
        '79842004', '79866005', '80711002', '80868005', '81319007', '8185002', '81903006',
        '82096005', '82339009', '82415003', '82494000', '82636008', '82738004', '82959004',
        '82998009', '83168008', '83176005', '83225003', '83367009', '83458005', '83501007',
        '83631006', '83746006', '83890006', '84002002', '84209002', '84466009', '84758004',
        '84760002', '84788008', '84984002', '85061001', '85080004', '8511007', '85248005',
        '85821003', '85861002', '8635005', '87132004', '87203005', '87414006', '87798009',
        '87950005', '87991007', '8837000', '88845000', '88939009', '88975006', '89415002',
        '89451009', '89618007', '89765005', '89948007', '90361000119105', '90755006', '90790003',
        '9083002', '91388009', '9167000', '92501000119101', '9340000', '9345005', '93461009',
        '95636001', '95637005', '95919007', '9674006'
    }


class ThrombolyticTPaTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent medications that are prescribed for thrombolytic (t-PA) therapy for treatment of ischemic stroke.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who are administered appropriate thrombolytic (t-PA) therapy for stroke.
    Inclusion Criteria: Includes only relevant concepts associated with RxNorm thrombolytic medications appropriate for stroke treatment consistent with administration by intravenous (IV) route.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.226'
    VALUE_SET_NAME = 'Thrombolytic (t-PA) Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1804799', '1804804'}


class HospiceCareAmbulatory(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients receiving hospice care outside of a hospital or long term care facility.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Order or Intervention, Order. The intent of this value set is to identify all patients receiving hospice care outside of a hospital or long term care facility.
    Inclusion Criteria: Includes only relevant concepts associated with hospice care concepts.
    Exclusion Criteria: Excludes concepts for palliative care or comfort measures.
    """

    OID = '2.16.840.1.113762.1.4.1108.15'
    VALUE_SET_NAME = 'Hospice care ambulatory'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'385763009', '385765002'}


class AcuteInpatient(ValueSet):
    """

    Clinical Focus: This value set contains concepts related to acute inpatient visits.
    Data Element Scope: This value set may use Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive history, evaluation, and management of a patient in an acute inpatient setting. This is a grouping value set of CPT and SNOMED codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1083'
    VALUE_SET_NAME = 'Acute Inpatient'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '99221', '99222', '99223', '99231', '99232', '99233', '99238', '99239', '99251', '99252',
        '99253', '99254', '99255', '99291'
    }

    SNOMEDCT = {
        '112689000', '1505002', '15584006', '183450002', '183481006', '183487005', '183488000',
        '183489008', '183491000', '183492007', '183493002', '183494008', '183495009', '183496005',
        '183497001', '183498006', '183499003', '183500007', '183501006', '183502004', '183503009',
        '183504003', '183505002', '183506001', '183507005', '183508000', '183509008', '183510003',
        '183511004', '183512006', '235313004', '25986004', '2876009', '287927002', '304566005',
        '305337004', '305338009', '305341000', '305342007', '305350003', '305354007', '305355008',
        '305356009', '305357000', '305358005', '305359002', '305360007', '305361006', '305362004',
        '305363009', '305364003', '305365002', '305366001', '305367005', '305368000', '305369008',
        '305370009', '305371008', '305372001', '305374000', '305375004', '305376003', '305377007',
        '305378002', '305379005', '305380008', '305382000', '305383005', '305384004', '305385003',
        '305386002', '305387006', '305388001', '305389009', '305390000', '305391001', '305392008',
        '305393003', '305394009', '305395005', '305396006', '305397002', '305399004', '305400006',
        '305401005', '305402003', '305403008', '305404002', '305405001', '305406000', '305407009',
        '305408004', '305409007', '305410002', '305411003', '305412005', '305413000', '305414006',
        '305415007', '305416008', '305417004', '305418009', '305419001', '305420007', '305421006',
        '305422004', '305423009', '305424003', '305425002', '305426001', '305427005', '305428000',
        '305429008', '305430003', '305431004', '305432006', '305433001', '305434007', '305435008',
        '306732000', '306803007', '306967009', '308251003', '308252005', '308253000', '310361003',
        '3241000175106', '32485007', '373113001', '397769005', '398162007', '405614004', '417005',
        '432621000124105', '442281000124108', '447941000124106', '448421000124105',
        '448431000124108', '448441000124103', '448851000124103', '4563007', '45702004', '47348005',
        '48183000', '51032003', '51501005', '5161006', '52748007', '60059000', '63551005',
        '699124006', '70755000', '71290004', '76193006', '76464004', '81672003', '82942009',
        '8715000'
    }


class HistoryOfBilateralMastectomy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a previous history of bilateral mastectomy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with patients that have ever had a bilateral mastectomy performed. This is a grouping of SNOMED CT and ICD-10-CM codes.
    Exclusion Criteria: Excludes codes that indicate a unilateral mastectomy or are unspecified.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1068'
    VALUE_SET_NAME = 'History of bilateral mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z9013'}

    SNOMEDCT = {'136071000119101', '428529004'}


class PalliativeCareEncounter(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent identifying patients receiving palliative, comfort or hospice care.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients receiving palliative, comfort or hospice care.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1575'
    VALUE_SET_NAME = 'Palliative care encounter'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z515'}


class VitreousProcedures(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent vitreous procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with vitreous procedures, including vitrectomy, aspiration or injection of vitreous.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1447'
    VALUE_SET_NAME = 'Vitreous Procedures'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '67005', '67010', '67015', '67025', '67030', '67031', '67036', '67039', '67041', '67042',
        '67043'
    }

    SNOMEDCT = {
        '12113005', '14190001000004109', '172555009', '231756000', '231780001', '23598001',
        '296867007', '3499006', '43582002', '48671003', '60177007', '72019009', '74220006',
        '75732000', '82382005', '82627009', '87021001'
    }


class OtherEndophthalmitis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of other endophthalmitis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of ophthalmia nodosa, parasitic cyst or endophthalmitis, panuveitis, sympathetic uveitis, or other endophthalmitis diagnoses.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1473'
    VALUE_SET_NAME = 'Other Endophthalmitis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H16241', 'H16242', 'H16243', 'H21331', 'H21332', 'H21333', 'H33121', 'H33122', 'H33123',
        'H44111', 'H44112', 'H44113', 'H44121', 'H44122', 'H44123', 'H44131', 'H44132', 'H44133',
        'H4419'
    }

    ICD9CM = {'36011', '36012', '36013', '36014', '36019'}

    SNOMEDCT = {'12371008', '240842000', '415737009', '57100005', '75315001', '75614007'}


class DischargeServicesHospitalInpatientSameDayDischarge(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent inpatient hospital same day discharge services.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying observation or inpatient care for the evaluation and management of a patient that results in discharge on the same date of admission. This is a grouping of CPT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1006'
    VALUE_SET_NAME = 'Discharge Services - Hospital Inpatient Same Day Discharge'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99234', '99235', '99236'}


class ClinicalOralEvaluation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who had a clinical oral evaluation.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with periodic, limited (problem focused
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.125.12.1003'
    VALUE_SET_NAME = 'Clinical Oral Evaluation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CDT = {'D0120', 'D0140', 'D0145', 'D0150', 'D0160', 'D0170', 'D0180'}


class Osteoporosis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of osteoporosis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes for idiopathic, senile, disuse, and other/unspecified osteoporosis. Includes only relevant concepts associated with localized, transient, and regional migrating osteoporosis. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes diagnosis codes for osteoporosis due to cystic fibrosis.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1038'
    VALUE_SET_NAME = 'Osteoporosis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'M810', 'M816', 'M818'}

    ICD9CM = {'73301', '73302', '73303', '73309'}

    SNOMEDCT = {
        '102447009', '109346000', '14651005', '1515008', '18040001', '203429007', '203433000',
        '203434006', '203435007', '203436008', '203437004', '203438009', '203444008', '203446005',
        '203657009', '240155001', '240157009', '240158004', '240159007', '240161003', '240162005',
        '240164006', '240198002', '268028001', '276661002', '281387004', '309745002', '311806008',
        '32369003', '3345002', '390833005', '53174001', '64859006', '699528002', '703264005',
        '735617003', '735618008', '739301006'
    }


class SystemReason(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent system-specific reasons for when a patient does not receive a therapy or service.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Negation Rationale.
    Inclusion Criteria: Includes only relevant concepts associated with system-specific reasons for not receiving a therapy or service.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1009'
    VALUE_SET_NAME = 'System Reason'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '107724000', '182856006', '182857002', '185335007', '224194003', '224198000', '224199008',
        '242990004', '266756008', '270459005', '309017000', '309846006', '419808006', '424553001'
    }


class AnaphylacticReactionToCommonBakersYeast(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a history of an anaphylactic (extreme allergy) reaction to baker's yeast.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with an anaphylactic reaction to baker's yeast.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1032'
    VALUE_SET_NAME = "Anaphylactic Reaction to Common Baker's Yeast"
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'34015007', '419447004'}


class FrailtySymptom(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent frailty symptoms.
    Data Element Scope: This value set may use Quality Data Model (QDM) datatype related to Symptom.
    Inclusion Criteria: Includes only relevant concepts associated with frailty symptoms. This is a grouping of ICD10CM and SNOMEDCT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1075'
    VALUE_SET_NAME = 'Frailty Symptom'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'R260', 'R261', 'R262', 'R2689', 'R269', 'R4181', 'R531', 'R5381', 'R5383', 'R54', 'R627',
        'R634', 'R636', 'R64'
    }

    SNOMEDCT = {
        '102492002', '102568007', '102891000', '102992006', '105501005', '105503008', '105504002',
        '11172006', '11237000', '126013009', '127378008', '129567005', '129568000', '129584004',
        '135834002', '13791008', '152921000119101', '15929301000119104', '160681005', '160683008',
        '160684002', '160685001', '160692006', '160693001', '160734000', '160737007', '161832001',
        '161873000', '161874006', '162236007', '162239000', '163600007', '163685000', '163686004',
        '163688003', '163689006', '163690002', '163691003', '163695007', '16419651000119103',
        '165243005', '165244004', '16973004', '18726006', '20940004', '22090007', '22325002',
        '224960004', '225612007', '22631008', '23042008', '238108007', '248269005', '248278004',
        '248279007', '249888000', '249937002', '249938007', '249939004', '249940002', '249941003',
        '249942005', '249943000', '249946008', '250002000', '250003005', '250004004', '250005003',
        '250006002', '250008001', '250009009', '250011000', '250012007', '250013002', '250014008',
        '250015009', '250016005', '250018006', '250019003', '250020009', '250021008', '250023006',
        '250024000', '250027007', '250028002', '250029005', '250032008', '250033003', '250034009',
        '250035005', '250036006', '250038007', '250040002', '250042005', '250043000', '250044006',
        '250045007', '250047004', '250048009', '250049001', '250050001', '250051002', '250052009',
        '250055006', '250056007', '250057003', '250991000119100', '25136009', '262285001',
        '26544005', '267024001', '267031002', '267032009', '268964003', '271706000', '271707009',
        '271795006', '271875007', '272036004', '272060000', '272062008', '27253007', '275313006',
        '284529003', '298283006', '300948004', '30767006', '309249007', '309257005', '312444006',
        '314109004', '31464009', '35136003', '365884000', '367391008', '371028005', '373931001',
        '394616008', '397776000', '398218008', '401211005', '40192003', '404904002', '413121008',
        '414562003', '41786007', '418073009', '422868009', '424429009', '426977000', '428116008',
        '428264009', '429091008', '429487005', '43005009', '431524008', '432559006', '442099003',
        '44227003', '443544006', '444042007', '444932008', '4468000', '448765001', '48304002',
        '50314001', '52751000', '53626000', '55791005', '60631000119109', '60651000119103',
        '62334008', '67141003', '69021004', '69161000119103', '713512009', '713514005',
        '713568000', '713655003', '73514000', '75742003', '78119002', '78691002', '79021000119104',
        '79031000119101', '84153003', '84229001', '8461001', '8510008', '85711000119103',
        '87242005', '88471006', '89201000119106', '89362005', '931000119107', '9447003', '95438009'
    }


class AntibioticMedicationsForPharyngitis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent antibiotic medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Active or Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; antibiotics only.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable; antibiotics in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1001'
    VALUE_SET_NAME = 'Antibiotic Medications for Pharyngitis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1013659', '1013662', '1013665', '1043022', '1043027', '1043030', '105171', '1088677',
        '1148107', '1302650', '1302659', '1302664', '1302669', '1302674', '1373014', '141963',
        '142118', '1423080', '1648755', '1648759', '1649401', '1649405', '1649425', '1649429',
        '1649988', '1649990', '1650030', '1650142', '1650143', '1650444', '1650446', '1652673',
        '1652674', '1653433', '1656313', '1656318', '1659131', '1659137', '1659149', '1659278',
        '1659283', '1659287', '1659592', '1659598', '1662285', '1664981', '1664986', '1665005',
        '1665021', '1665046', '1665050', '1665052', '1665060', '1665088', '1665093', '1665097',
        '1665102', '1665107', '1665210', '1665212', '1665227', '1665229', '1665444', '1665449',
        '1665497', '1665507', '1665515', '1665517', '1665519', '1668238', '1668264', '1721458',
        '1721460', '1721473', '1721474', '1721475', '1721476', '1722916', '1722919', '1722921',
        '1723156', '1723160', '1728082', '1728087', '1737244', '1737578', '1737581', '1739890',
        '1743547', '1743549', '1747115', '1747121', '1791505', '1801138', '1807508', '1807510',
        '1807511', '1807513', '1807516', '1807518', '1870631', '1870633', '1870650', '1870676',
        '1870681', '1870685', '1870686', '197449', '197451', '197452', '197453', '197454',
        '197511', '197512', '197516', '197517', '197518', '197595', '197596', '197650', '197984',
        '197985', '198044', '198048', '198049', '198050', '198201', '198202', '198250', '198252',
        '198332', '198334', '198335', '199055', '199327', '199332', '199370', '199497', '199620',
        '1996246', '199710', '199802', '1998483', '199884', '199885', '2000127', '2000134',
        '200346', '204466', '204844', '205964', '207362', '207364', '207390', '207391', '239189',
        '239191', '239204', '239209', '240637', '240741', '240984', '242800', '242825', '245240',
        '245837', '245838', '248656', '259290', '283535', '284215', '308177', '308181', '308182',
        '308188', '308189', '308191', '308192', '308194', '308207', '308210', '308212', '308459',
        '308460', '309040', '309043', '309044', '309045', '309047', '309048', '309049', '309054',
        '309058', '309065', '309068', '309072', '309076', '309077', '309078', '309079', '309080',
        '309081', '309085', '309086', '309087', '309090', '309092', '309095', '309096', '309097',
        '309098', '309101', '309110', '309112', '309113', '309114', '309115', '309308', '309309',
        '309310', '309322', '309329', '309335', '309336', '309339', '310026', '310027', '310028',
        '310154', '310155', '310157', '311296', '311681', '311787', '311989', '311991', '311994',
        '311995', '312127', '312128', '312447', '313115', '313134', '313137', '313416', '313570',
        '313571', '313572', '313797', '313799', '313800', '313850', '313888', '313920', '313926',
        '313996', '314106', '314108', '315090', '317127', '348869', '348870', '351127', '351156',
        '359383', '359385', '388510', '403840', '403920', '403921', '406524', '409823', '419849',
        '434018', '476576', '477391', '562251', '562266', '562508', '562707', '577378', '597455',
        '597761', '597823', '598006', '598025', '617296', '617302', '617309', '617316', '617322',
        '617423', '617430', '617993', '617995', '629695', '629697', '629699', '636559', '637173',
        '637560', '645617', '686355', '686383', '686400', '686405', '686406', '686418', '700408',
        '728207', '731538', '731564', '731567', '731570', '745302', '745462', '745560', '749780',
        '749783', '757460', '757464', '757466', '761979', '789980', '799048', '802550', '834040',
        '834046', '834061', '834102', '835700', '836306', '847360', '858062', '858372', '863538',
        '901399'
    }


class AcetaminophenChlorpheniramineDextromethorphanPhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / chlorpheniramine / dextromethorphan / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / chlorpheniramine / dextromethorphan / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / chlorpheniramine / dextromethorphan / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1310'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Dextromethorphan / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1042688', '1086991', '1113397', '1357553'}


class CataractMatureOrHypermature(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of mature or hypermature cataract.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of mature or hypermature cataract, including senile or intumescent cataract.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1413'
    VALUE_SET_NAME = 'Cataract, Mature or Hypermature'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H269'}

    ICD9CM = {'3669'}

    SNOMEDCT = {'193590000', '264443002', '267626000', '849000', '8656007', '95724003'}


class Glaucoma(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of glaucoma.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of glaucoma.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1423'
    VALUE_SET_NAME = 'Glaucoma'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H4010X0', 'H4010X1', 'H4010X2', 'H4010X3', 'H4010X4', 'H401110', 'H401111', 'H401112',
        'H401113', 'H401114', 'H401120', 'H401121', 'H401122', 'H401123', 'H401124', 'H401130',
        'H401131', 'H401132', 'H401133', 'H401134', 'H401210', 'H401211', 'H401212', 'H401213',
        'H401214', 'H401220', 'H401221', 'H401222', 'H401223', 'H401224', 'H401230', 'H401231',
        'H401232', 'H401233', 'H401234', 'H401310', 'H401311', 'H401312', 'H401313', 'H401314',
        'H401320', 'H401321', 'H401322', 'H401323', 'H401324', 'H401330', 'H401331', 'H401332',
        'H401333', 'H401334', 'H401410', 'H401411', 'H401412', 'H401413', 'H401414', 'H401420',
        'H401421', 'H401422', 'H401423', 'H401424', 'H401430', 'H401431', 'H401432', 'H401433',
        'H401434', 'H40151', 'H40152', 'H40153', 'H4020X0', 'H4020X1', 'H4020X2', 'H4020X3',
        'H4020X4', 'H40211', 'H40212', 'H40213', 'H402210', 'H402211', 'H402212', 'H402213',
        'H402214', 'H402220', 'H402221', 'H402222', 'H402223', 'H402224', 'H402230', 'H402231',
        'H402232', 'H402233', 'H402234', 'H40231', 'H40232', 'H40233', 'H40241', 'H40242',
        'H40243', 'H4031X0', 'H4031X1', 'H4031X2', 'H4031X3', 'H4031X4', 'H4032X0', 'H4032X1',
        'H4032X2', 'H4032X3', 'H4032X4', 'H4033X0', 'H4033X1', 'H4033X2', 'H4033X3', 'H4033X4',
        'H4041X0', 'H4041X1', 'H4041X2', 'H4041X3', 'H4041X4', 'H4042X0', 'H4042X1', 'H4042X2',
        'H4042X3', 'H4042X4', 'H4043X0', 'H4043X1', 'H4043X2', 'H4043X3', 'H4043X4', 'H4051X0',
        'H4051X1', 'H4051X2', 'H4051X3', 'H4051X4', 'H4052X0', 'H4052X1', 'H4052X2', 'H4052X3',
        'H4052X4', 'H4053X0', 'H4053X1', 'H4053X2', 'H4053X3', 'H4053X4', 'H4061X0', 'H4061X1',
        'H4061X2', 'H4061X3', 'H4061X4', 'H4062X0', 'H4062X1', 'H4062X2', 'H4062X3', 'H4062X4',
        'H4063X0', 'H4063X1', 'H4063X2', 'H4063X3', 'H4063X4', 'H40811', 'H40812', 'H40813',
        'H40821', 'H40822', 'H40823', 'H40831', 'H40832', 'H40833', 'H4089', 'Q150'
    }

    ICD9CM = {
        '36510', '36511', '36512', '36513', '36514', '36515', '36520', '36521', '36522', '36523',
        '36524', '36531', '36532', '36551', '36552', '36559', '36560', '36561', '36562', '36563',
        '36564', '36565', '36581', '36582', '36583', '36589'
    }

    SNOMEDCT = {
        '10100008', '111513000', '111514006', '12239301000119102', '12239341000119100',
        '12239381000119105', '12239421000119101', '12239461000119106', '12239501000119106',
        '15374009', '15633281000119103', '15633321000119108', '15640441000119104',
        '15673001000119103', '15673081000119106', '15736441000119108', '15736481000119103',
        '15736521000119103', '15736561000119108', '15736601000119108', '15736641000119105',
        '15736681000119100', '15736721000119106', '15736761000119101', '15738841000119105',
        '15738881000119100', '15738921000119107', '15739041000119106', '15739081000119101',
        '15739121000119104', '15739161000119109', '15739201000119104', '15739241000119102',
        '15739281000119107', '15739321000119102', '15739361000119107', '15739401000119103',
        '15739441000119101', '15739481000119106', '15739561000119101', '15739641000119104',
        '15739681000119109', '15739721000119103', '15739761000119108', '15993671000119108',
        '15993711000119107', '15993751000119108', '15996831000119101', '1654001', '19144002',
        '19309007', '193546005', '193548006', '193549003', '193552006', '193553001', '193555008',
        '193561006', '193562004', '204113001', '206248004', '21571006', '21928008', '232081005',
        '232082003', '232083008', '232086000', '232087009', '232088004', '232090003', '23986001',
        '24151000119106', '267625001', '275477002', '27735002', '29369005', '30041005',
        '314017009', '314033007', '314784002', '32893002', '33647009', '336611000119109',
        '336631000119104', '342221000119104', '342241000119105', '34623005', '347381000119106',
        '347401000119106', '367360002', '37155002', '392030001', '392288006', '392291006',
        '392300000', '392352004', '404634005', '404648005', '415176004', '41911000119107',
        '444863008', '45623002', '46168003', '50485007', '53667005', '55129006', '60981000119103',
        '65460003', '66725002', '66747002', '66990007', '68241007', '698840003', '713457002',
        '715144004', '716166002', '721898008', '722321001', '722329004', '77075001', '84333006',
        '84494001', '89215000', '92829008', '95213001', '95250000', '95717004'
    }


class Dipyridamole(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dipyridamole medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dipyridamole only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dipyridamole in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1349'
    VALUE_SET_NAME = 'Dipyridamole'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197622', '309952', '309955'}


class BetaBlockerTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent beta blocker therapy.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; penbutolol sulfate, betaxolol hydrochloride, propranolol hydrochloride, atenolol/chlorthalidone, sotalol hydrochloride, metoprolol tartrate, nebivolol/valsartan, atenolol, bendroflumethiazide, nadolol, pindolol, timolol, oxprenolol, clopamide/pindolol, carvedilol, hydrochlorothiazide/pindolol, nebivolol, bisoprolol, bisoprolol/hydrochlorothiazide, hydrochlorothiazide/propranolol hydrochloride, propranolol hydrochloride, metoprolol, hydrochlorothiazide/metoprolol succinate, hydrochlorothiazide/metoprolol tartrate, labetalol, sotalol, acebutolol.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable.
    """

    OID = '2.16.840.1.113883.3.526.3.1174'
    VALUE_SET_NAME = 'Beta Blocker Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1191185', '1297753', '1297757', '1495058', '152916', '1593725', '1606347', '1606349',
        '1798281', '1923422', '1923424', '1923426', '197379', '197380', '197381', '197382',
        '197383', '198000', '198001', '198006', '198007', '198008', '198104', '198105', '198284',
        '198285', '198286', '199277', '199494', '199495', '199717', '199786', '199787', '200031',
        '200032', '200033', '245854', '245855', '387013', '686924', '751612', '751618', '827073',
        '854901', '854905', '854908', '854916', '854919', '856422', '856429', '856448', '856457',
        '856460', '856481', '856519', '856535', '856556', '856569', '856578', '856713', '856724',
        '856733', '860510', '860516', '860522', '860532', '866412', '866419', '866427', '866436',
        '866452', '866461', '866472', '866479', '866482', '866491', '866511', '866514', '866924',
        '896758', '896762', '896766', '896983', '896987', '904589', '998685', '998689', '998693',
        '998694', '998695'
    }


class TobaccoNonUser(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent tobacco non-user status.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Result.
    Inclusion Criteria: Includes only relevant concepts associated with indicating a patient does not use tobacco products, including smoking and smoke-less tobacco products such as chew, snuff, pipe, cigarette, cigar, etc.
    Exclusion Criteria: Excludes concepts that may indicate a current tobacco user status.
    """

    OID = '2.16.840.1.113883.3.526.3.1189'
    VALUE_SET_NAME = 'Tobacco Non-User'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '105539002', '105540000', '105541001', '160618006', '160620009', '160621008', '228491005',
        '228492003', '228493008', '228501004', '228502006', '228503001', '228511006', '228512004',
        '228513009', '266919005', '266921000', '266922007', '266923002', '266924008', '266925009',
        '266928006', '281018007', '360890004', '360900008', '360918006', '360929005', '405746006',
        '428081000124100', '428091000124102', '451371000124109', '451381000124107',
        '456711000124105', '48031000119106', '53896009', '702975009', '702979003', '735128000',
        '8392000', '8517006', '87739003'
    }


class Estradiol(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent estradiol medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; estradiol only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; estradiol in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1365'
    VALUE_SET_NAME = 'Estradiol'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1149632', '197657', '197658', '197659', '205333', '238003', '238004', '241527', '241946',
        '242333', '242891', '242892', '248478', '403922', '403923', '577027', '577029'
    }


class HyoscyamineMethenamineMbluePhenylSalicylSodiumBiphosphate(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hyoscyamine / methenamine / mblue / phenyl salicyl / sodium biphosphate combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; hyoscyamine / methenamine / mblue / phenyl salicyl / sodium biphosphate (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; hyoscyamine / methenamine / mblue / phenyl salicyl / sodium biphosphate in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1504'
    VALUE_SET_NAME = 'Hyoscyamine / Methenamine / Mblue / Phenyl Salicyl / Sodium Biphosphate'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1047786', '1048307', '1048336', '1087365', '1440869'}


class EstradiolNorethindrone(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent estradiol / norethindrone combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; estradiol / norethindrone (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; estradiol / norethindrone in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1323'
    VALUE_SET_NAME = 'Estradiol / Norethindrone'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1359123', '1359124', '1359126', '1359127'}


class GlaucomaAssociatedWithCongenitalAnomaliesDystrophiesAndSystemicSyndromes(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of glaucoma that is associated with congenital anomalies, dystrophies, and systemic syndromes.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of glaucoma that may be due to congenital anomalies, dystrophies, or other systemic syndromes, including trauma, or a secondary diagnosis.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1461'
    VALUE_SET_NAME = 'Glaucoma Associated with Congenital Anomalies, Dystrophies, and Systemic Syndromes'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H4031X0', 'H4031X1', 'H4031X2', 'H4031X3', 'H4031X4', 'H4032X0', 'H4032X1', 'H4032X2',
        'H4032X3', 'H4032X4', 'H4033X0', 'H4033X1', 'H4033X2', 'H4033X3', 'H4033X4', 'H4041X0',
        'H4041X1', 'H4041X2', 'H4041X3', 'H4041X4', 'H4042X0', 'H4042X1', 'H4042X2', 'H4042X3',
        'H4042X4', 'H4043X0', 'H4043X1', 'H4043X2', 'H4043X3', 'H4043X4', 'H4051X0', 'H4051X1',
        'H4051X2', 'H4051X3', 'H4051X4', 'H4052X0', 'H4052X1', 'H4052X2', 'H4052X3', 'H4052X4',
        'H4053X0', 'H4053X1', 'H4053X2', 'H4053X3', 'H4053X4', 'H40811', 'H40812', 'H40813',
        'H40821', 'H40822', 'H40823', 'H40831', 'H40832', 'H40833', 'H4089', 'H409', 'H42'
    }

    ICD9CM = {
        '36541', '36542', '36543', '36544', '36560', '36561', '36562', '36563', '36564', '36565',
        '36581', '36582', '36583', '36589', '3659'
    }

    SNOMEDCT = {
        '15736561000119108', '15736601000119108', '15736641000119105', '15739041000119106',
        '15739081000119101', '15739121000119104', '15739161000119109', '15739321000119102',
        '15739361000119107', '15739401000119103', '15739441000119101', '15739481000119106',
        '15739561000119101', '15739681000119109', '15739721000119103', '15739761000119108',
        '19309007', '193552006', '193553001', '193555008', '193556009', '193561006', '206248004',
        '232083008', '232086000', '29538005', '314033007', '32893002', '37155002', '392300000',
        '392352004', '404634005', '404648005', '418435001', '45623002', '46168003', '66725002',
        '66747002', '68241007', '84333006', '95717004'
    }


class EsterifiedEstrogens(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent esterified estrogen medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; esterified estrogen medications.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; esterified estrogens in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1419'
    VALUE_SET_NAME = 'Esterified Estrogens'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197666', '197667', '197668', '197669'}


class Megestrol(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent megestrol medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; megestrol only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; megestrol in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1342'
    VALUE_SET_NAME = 'Megestrol'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'860215', '860221', '860225'}


class ConjugatedEstrogens(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent conjugated estrogen medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; conjugated estrogen medications.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; conjugated estrogens in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1357'
    VALUE_SET_NAME = 'Conjugated Estrogens'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '197660', '197661', '197662', '310197', '310204', '310206', '403849', '476540', '618368',
        '618370', '618376', '618378', '730878'
    }


class DiphenhydramineHydrochloride(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diphenhydramine hydrochloride medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; diphenhydramine hydrochloride only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; diphenhydramine hydrochloride in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1371'
    VALUE_SET_NAME = 'Diphenhydramine Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1020477', '1049289', '1049630', '1049633', '1049900', '1049904', '1049906', '1049909',
        '1085945', '1093098', '1248354', '1723740', '1723776', '882504'
    }


class PseudoephedrineTriprolidine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent pseudoephedrine / triprolidine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; pseudoephedrine / triprolidine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; pseudoephedrine / triprolidine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1345'
    VALUE_SET_NAME = 'Pseudoephedrine / Triprolidine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1099308', '1099446', '1099668'}


class HumanImmunodeficiencyVirusHivLaboratoryTestCodesAbAndAg(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests used for Human Immunodeficiency Virus screening.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test. Used for HIV screening.
    Inclusion Criteria: Includes only relevant concepts associated with laboratory tests for HIV-1 and HIV-2 antibodies or antigens.
    Exclusion Criteria: Excludes tests and procedures that might be associated with HIV infection that are not used for screening or testing to establish an HIV diagnosis, which would include home/self HIV testing, HIV genotyping tests, HIV RNA tests, HIV cultures, clinical codes used to document care provided to HIV-infected patients.
    """

    OID = '2.16.840.1.113762.1.4.1056.50'
    VALUE_SET_NAME = 'Human Immunodeficiency Virus (HIV) Laboratory Test Codes (Ab and Ag)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '10901-7', '10902-5', '11078-3', '11079-1', '11080-9', '11081-7', '11082-5', '12855-3',
        '12856-1', '12857-9', '12858-7', '12859-5', '12870-2', '12871-0', '12872-8', '12875-1',
        '12876-9', '12893-4', '12894-2', '12895-9', '13499-9', '13920-4', '14092-1', '14126-7',
        '16132-3', '16974-8', '16975-5', '16976-3', '16977-1', '16978-9', '16979-7', '18396-2',
        '19110-6', '21007-0', '21331-4', '21332-2', '21334-8', '21335-5', '21336-3', '21337-1',
        '21338-9', '21339-7', '21340-5', '22356-0', '22357-8', '22358-6', '24012-7', '28004-0',
        '28052-9', '29327-4', '29893-5', '30361-0', '31072-2', '31073-0', '31201-7', '31430-2',
        '32571-2', '32602-5', '32827-8', '32842-7', '33508-3', '33660-2', '33806-1', '33807-9',
        '33866-5', '34591-8', '34592-6', '35437-3', '35438-1', '35439-9', '35440-7', '35441-5',
        '35442-3', '35443-1', '35444-9', '35445-6', '35446-4', '35447-2', '35448-0', '35449-8',
        '35450-6', '35452-2', '35564-4', '35565-1', '40437-6', '40438-4', '40439-2', '40732-0',
        '40733-8', '41143-9', '41144-7', '41145-4', '41290-8', '42339-2', '42600-7', '42627-0',
        '42768-2', '43008-2', '43009-0', '43010-8', '43011-6', '43012-4', '43013-2', '43185-8',
        '43599-0', '44531-2', '44532-0', '44533-8', '44607-0', '44872-0', '44873-8', '45212-8',
        '47029-4', '48345-3', '48346-1', '49483-1', '49580-4', '49718-0', '49905-3', '49965-7',
        '51786-2', '51866-2', '5220-9', '5221-7', '5222-5', '5223-3', '5224-1', '5225-8',
        '53379-4', '53601-1', '54086-4', '56888-1', '57974-8', '57975-5', '57976-3', '57977-1',
        '57978-9', '58900-2', '62456-9', '68961-2', '69668-2', '73905-2', '73906-0', '75622-1',
        '75666-8', '77685-6', '7917-8', '7918-6', '7919-4', '80203-3', '80387-4', '81641-3',
        '83101-6', '85037-0', '85686-4', '86233-4', '86657-4', '89365-1', '89374-3', '9660-2',
        '9661-0', '9662-8', '9663-6', '9664-4', '9665-1', '9666-9', '9667-7', '9668-5', '9669-3',
        '9821-0'
    }


class GonococcalInfectionsAndVenerealDiseases(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent gonococcal infections and other venereal diseases.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with female gonococcal infections and other venereal disease. This is a grouping of ICD-10-CM, ICD-9-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes codes that indicate male gonococcal infections or male venereal disease.
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1001'
    VALUE_SET_NAME = 'Gonococcal Infections and Venereal Diseases'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A5001', 'A5002', 'A5003', 'A5004', 'A5005', 'A5006', 'A5007', 'A5008', 'A5030', 'A5032',
        'A5039', 'A5043', 'A5044', 'A5051', 'A5053', 'A5054', 'A5055', 'A5056', 'A5400', 'A5401',
        'A5402', 'A5403', 'A5409', 'A541', 'A5421', 'A5422', 'A5423', 'A5424', 'A5429', 'A5430',
        'A5431', 'A5432', 'A5433', 'A5439', 'A5440', 'A5441', 'A5442', 'A5443', 'A5449', 'A545',
        'A546', 'A5481', 'A5482', 'A5483', 'A5484', 'A5485', 'A5486', 'A5489', 'A549', 'A57',
        'A58', 'A630', 'A638', 'A64', 'A690', 'A691', 'A698', 'A699'
    }

    ICD9CM = {
        '0980', '09810', '09811', '09812', '09813', '09814', '09815', '09816', '09817', '09819',
        '0982', '09830', '09831', '09832', '09833', '09834', '09835', '09836', '09837', '09839',
        '09840', '09841', '09842', '09843', '09849', '09850', '09851', '09852', '09853', '09859',
        '0986', '0987', '09881', '09882', '09883', '09884', '09885', '09886', '09889', '0990',
        '0991', '0992', '0993', '09940', '09941', '09949', '09950', '09951', '09952', '09953',
        '09954', '09955', '09956', '09959', '0998', '0999'
    }

    SNOMEDCT = {
        '1087021000119101', '1087041000119107', '1087051000119109', '110041000119104', '111806005',
        '111807001', '114881000119108', '11906007', '12373006', '151004', '15628003',
        '16217981000119107', '17305005', '186915005', '186931002', '186939000', '186946009',
        '197848003', '197967000', '198242009', '199161008', '199163006', '199164000', '199165004',
        '199166003', '20943002', '231858009', '235861001', '235863003', '236682002', '236687008',
        '236766009', '236772009', '237038001', '237042003', '237046000', '237069002', '237083000',
        '237095000', '237096004', '238419002', '2390000', '23975003', '239785008', '239808004',
        '240039005', '240571007', '240572000', '240573005', '240574004', '240575003', '240576002',
        '240577006', '240578001', '240579009', '240581006', '240582004', '240583009', '240602008',
        '240603003', '240604009', '24868007', '266138002', '272006008', '272262003', '27681008',
        '28438004', '28572009', '29864006', '30168008', '301990003', '307423008', '31999004',
        '35255008', '35526001', '35876006', '40149008', '402956009', '402957000', '402958005',
        '406581000', '415141001', '42746002', '44412000', '444834005', '44743006', '45377007',
        '46699001', '5085001', '50970007', '53529004', '53664003', '54825009', '60335002',
        '60893000', '61048000', '65049003', '65295003', '67224007', '713261005', '719755001',
        '72225002', '74372003', '762257007', '76802005', '80388004', '80604007', '88813005',
        '9091006', '9241004'
    }


class InactivatedPolioVaccineIpv(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent inactivated polio vaccines (IPV).
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with all inactivated polio vaccine (IPV) codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1219'
    VALUE_SET_NAME = 'Inactivated Polio Vaccine (IPV)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'10', '110', '120', '89'}


class AntiHepatitisBVirusSurfaceAb(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests to detect anti hepatitis B surface antigen in the blood.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with test codes for anti-surface antibody in the blood related to hepatitis B virus.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1073'
    VALUE_SET_NAME = 'Anti Hepatitis B Virus Surface Ab'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'10900-9', '22322-2', '39535-0', '48070-7', '49177-9', '75409-3'}


class RetinalRepairProcedures(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent retinal repair procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with procedures for repairing the retina, including reattachment, scleroplasty and repositioning.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1437'
    VALUE_SET_NAME = 'Retinal Repair Procedures'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'67101', '67105', '67107', '67108', '67110', '67141', '67145'}

    SNOMEDCT = {
        '10006000', '12651006', '14707009', '172451002', '172574001', '22768003', '3938007',
        '4344007', '47470009', '57103007', '68999001', '77950003', '78917001', '85231002',
        '8920006'
    }


class OpticNeuritis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of optic neuritis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of optic neuritis, neuropathy, neuroretinitis, and papillitis.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1467'
    VALUE_SET_NAME = 'Optic Neuritis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H4601', 'H4602', 'H4603', 'H4611', 'H4612', 'H4613', 'H462', 'H463', 'H468', 'H469'
    }

    ICD9CM = {'37730', '37731', '37732', '37733', '37734', '37739'}

    SNOMEDCT = {
        '15631011000119102', '15631051000119101', '230507009', '25044007', '26125006',
        '2691000124105', '314537004', '314538009', '314539001', '314540004', '314787009',
        '36276008', '410471004', '410472006', '416913007', '420920007', '432521000124106',
        '51604006', '66760008', '73221001', '73431005', '82108004'
    }


class HypertensiveChronicKidneyDisease(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hypertensive kidney disease.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with hypertensive kidney disease.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1017'
    VALUE_SET_NAME = 'Hypertensive Chronic Kidney Disease'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I120', 'I129', 'I130', 'I1310', 'I1311', 'I132', 'I150', 'I151'}

    ICD9CM = {
        '40301', '40310', '40311', '40390', '40391', '40400', '40401', '40402', '40403', '40410',
        '40411', '40412', '40413', '40490', '40491', '40492', '40493'
    }

    SNOMEDCT = {
        '111438007', '123799005', '123800009', '14973001', '193003', '194774006', '194783001',
        '19769006', '23130000', '28119000', '285831000119108', '285841000119104',
        '286371000119107', '32916005', '38481006', '39018007', '397748008', '427889009',
        '428575007', '473392002', '49220004', '57684003', '62240004', '65443008', '66052004',
        '66610008', '73410007', '78544004', '81363003', '86234004', '90493000'
    }


class AmbulatoryStatus(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent assessment of gait or balance to identify risk factors for falls.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Assessment, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with all gait and balance assessment tools such as the Morse Fall Scale and the Parkinson's Unified Parkinson’s Disease Rating Scale. This is an extensional value set of LOINC codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.118.11.1219'
    VALUE_SET_NAME = 'Ambulatory Status'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'59458-0', '65705-6'}


class HibVaccine3DoseSchedule(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent haemophilus influenzae type b (Hib) vaccines (3-dose schedule).
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with haemophilus influenzae type b (Hib) vaccine codes (3-dose schedule). This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1083'
    VALUE_SET_NAME = 'HiB Vaccine (3 dose schedule)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'49'}


class IntravenousRoute(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the route by which a medication is administered, in this case an intravenous route.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Route. The intent of this data element is to identify the route by which a medication is administered, in this case an intravenous route.
    Inclusion Criteria: Includes only relevant concepts associated with identifying an intravenous route for giving a medication. Codes used are to be SNOMED CT codes only.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.222'
    VALUE_SET_NAME = 'Intravenous route'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'418114005', '419993007', '47625008'}


class DischargeToAcuteCareFacility(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the discharge of a patient to an acute care facility.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Discharge Disposition. The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular inpatient encounter. This particular value set intends to identify patients who were discharged to an acute care facility.
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT codes representing short-term acute care hospitals, including specialty hospitals.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.87'
    VALUE_SET_NAME = 'Discharge To Acute Care Facility'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'306701001', '306703003', '434781000124105'}


class IntracranialNeurosurgery(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent procedures of intracranial neurosurgery.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients who have an intracranial neurosurgery procedure.
    Inclusion Criteria: Includes only relevant concepts associated with representing intracranial neurosurgery.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.260'
    VALUE_SET_NAME = 'Intracranial Neurosurgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '00500ZZ', '00510ZZ', '00520ZZ', '00560ZZ', '00570ZZ', '00580ZZ', '00590ZZ', '005A0ZZ',
        '005B0ZZ', '005C0ZZ', '005D0ZZ', '00800ZZ', '00870ZZ', '00880ZZ', '009000Z', '00900ZZ',
        '009100Z', '00910ZZ', '009200Z', '00920ZZ', '009300Z', '00930ZZ', '009400Z', '00940ZZ',
        '009500Z', '00950ZZ', '009600Z', '00960ZZ', '009700Z', '00970ZZ', '009800Z', '00980ZZ',
        '009900Z', '00990ZZ', '009A00Z', '009A0ZZ', '009B00Z', '009B0ZZ', '009C00Z', '009C0ZZ',
        '009D00Z', '009D0ZZ', '00B00ZZ', '00B10ZZ', '00B20ZZ', '00B60ZZ', '00B70ZZ', '00B80ZZ',
        '00B90ZZ', '00BA0ZZ', '00BB0ZZ', '00BC0ZZ', '00BD0ZZ', '00C00ZZ', '00C10ZZ', '00C20ZZ',
        '00C30ZZ', '00C40ZZ', '00C50ZZ', '00C60ZZ', '00C70ZZ', '00C80ZZ', '00C90ZZ', '00CA0ZZ',
        '00CB0ZZ', '00CC0ZZ', '00CD0ZZ', '00D10ZZ', '00D20ZZ', '00H002Z', '00H003Z', '00H602Z',
        '00H603Z', '00J00ZZ', '00N90ZZ', '00NA0ZZ', '00P000Z', '00P002Z', '00P003Z', '00P007Z',
        '00P00JZ', '00P00KZ', '00P600Z', '00P602Z', '00P603Z', '00P6X2Z', '00Q90ZZ', '00QA0ZZ',
        '00T70ZZ', '00W000Z', '00W002Z', '00W003Z', '00W007Z', '00W00JZ', '00W00KZ', '00W00MZ',
        '00W600Z', '00W602Z', '00W603Z', '00W60MZ', '0N9000Z', '0N900ZZ', '0N9100Z', '0N910ZZ',
        '0N9300Z', '0N930ZZ', '0N9400Z', '0N940ZZ', '0N9500Z', '0N950ZZ', '0N9600Z', '0N960ZZ',
        '0N9700Z', '0N970ZZ', '0W9100Z', '0W910ZZ', '0WC10ZZ', '0WH10YZ', '0WJ10ZZ', '0WP100Z',
        '0WP101Z', '0WP10JZ', '0WP10YZ', '0WW100Z', '0WW101Z', '0WW103Z', '0WW10JZ', '0WW10YZ'
    }

    SNOMEDCT = {
        '10458001', '112929000', '13431007', '13433005', '13666002', '14247003', '14554005',
        '1583007', '171442008', '171443003', '171446006', '171447002', '171448007', '171449004',
        '171450004', '171451000', '171455009', '171471009', '171472002', '171473007', '171474001',
        '171479006', '171495006', '171540003', '171554006', '171692002', '171693007', '171694001',
        '171695000', '171696004', '171697008', '171698003', '171722000', '178373004', '178375006',
        '178376007', '178391009', '1868005', '1995001', '19994000', '21205002', '21551002',
        '22480005', '230810008', '230811007', '230814004', '230837005', '230838000', '230839008',
        '230840005', '230841009', '230859007', '230886007', '230888008', '230890009', '230892001',
        '230893006', '234064002', '234915008', '243570009', '244238001', '25353009', '2552005',
        '260643004', '260644005', '26096003', '27181009', '27190002', '2737001', '273991000',
        '27968003', '28264008', '287205001', '287208004', '29063004', '29114001', '2968008',
        '30195003', '304848009', '304849001', '307299001', '31746001', '32606000', '34097003',
        '34719005', '36910002', '37380009', '38512006', '39667005', '39704007', '4045001',
        '42699003', '427037000', '427599009', '429314008', '429510003', '438369007', '438614004',
        '439493007', '439499006', '440062005', '441832005', '442616007', '445746008', '44589002',
        '445926009', '445942002', '446103006', '446115005', '446209004', '446210009', '446440008',
        '446570000', '446571001', '446683008', '446705006', '446816008', '446848007', '446850004',
        '446865003', '446868001', '447107001', '447115003', '447156000', '447362004', '447363009',
        '447469009', '447518007', '447529006', '447594008', '45322003', '4570007', '51991009',
        '53423001', '5384005', '54872009', '54891009', '56143008', '56959007', '58337008',
        '58515002', '59696004', '59712006', '61327009', '61965006', '67402009', '67864003',
        '68346000', '68731005', '69086007', '69788001', '71722001', '73006002', '75626002',
        '76961002', '77697000', '789003', '79093007', '79272003', '80460006', '807005', '81259007',
        '8155007', '81849003', '82443007', '82678002', '82917000', '87060004', '87192001',
        '90287005', '91652006', '9257004', '9372002', '9580008', '9888007'
    }


class HomeHealthcareServices(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have had a home health visit by a provider for the evaluation or management of a new or existing patient.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with home visits for the evaluation and management of a new or established patient. This is a grouping value set of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1016'
    VALUE_SET_NAME = 'Home Healthcare Services'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349', '99350'}

    SNOMEDCT = {
        '185460008', '185462000', '185466002', '185467006', '185468001', '185470005', '225929007',
        '315205008', '439708006', '698704008', '704126008'
    }


class FrailtyDevice(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent durable medical equipment or devices used by frail patients.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Device.
    Inclusion Criteria: Includes only relevant concepts associated with patients that use durable medical equipment or devices for frailty. This is a grouping of HCPCS codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1300'
    VALUE_SET_NAME = 'Frailty Device'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    HCPCS = {
        'E0100', 'E0105', 'E0130', 'E0135', 'E0140', 'E0141', 'E0143', 'E0144', 'E0147', 'E0148',
        'E0149', 'E0163', 'E0165', 'E0167', 'E0168', 'E0170', 'E0171', 'E0250', 'E0251', 'E0255',
        'E0256', 'E0260', 'E0261', 'E0265', 'E0266', 'E0270', 'E0290', 'E0291', 'E0292', 'E0293',
        'E0294', 'E0295', 'E0296', 'E0297', 'E0301', 'E0302', 'E0303', 'E0304', 'E0424', 'E0425',
        'E0430', 'E0431', 'E0433', 'E0434', 'E0435', 'E0439', 'E0440', 'E0441', 'E0442', 'E0443',
        'E0444', 'E0462', 'E0465', 'E0466', 'E0470', 'E0471', 'E0472', 'E0561', 'E0562', 'E1130',
        'E1140', 'E1150', 'E1160', 'E1161', 'E1240', 'E1250', 'E1260', 'E1270', 'E1280', 'E1285',
        'E1290', 'E1295', 'E1296', 'E1297', 'E1298'
    }


class Observation(ValueSet):
    """

    Clinical Focus: This value set contains concepts related to observation visits.
    Data Element Scope: This value set may use Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive history, evaluation, and management of a patient in an observation care setting. This is a grouping value set of CPT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1086'
    VALUE_SET_NAME = 'Observation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99217', '99218', '99219', '99220'}


class PreventiveCareServicesInitialOfficeVisit18AndUp(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients over the age of 18 who have had an initial preventive care office visit.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive preventive medicine reevaluation and management of an individual the age of 18 years or over. This is a grouping value set of CPT codes.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1023'
    VALUE_SET_NAME = 'Preventive Care Services-Initial Office Visit, 18 and Up'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99385', '99386', '99387'}


class PreventiveCareServicesEstablishedOfficeVisit18AndUp(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients over the age of 18 who have had an established preventive care office visit.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive preventive medicine reevaluation and management of an individual the age of 18 years or over. This is an extensional value set of CPT codes.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1125'
    VALUE_SET_NAME = 'Preventive Care Services - Established Office Visit, 18 and Up'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99395', '99396', '99397'}


class BmiPercentile(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent BMI percentile.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Physical Exam, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying BMI percentile as a result. This is a grouping of LOINC codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1012'
    VALUE_SET_NAME = 'BMI percentile'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'59574-4', '59575-1', '59576-9'}


class ChlorpheniramineDextromethorphanPseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorpheniramine / dextromethorphan / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorpheniramine / dextromethorphan / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorpheniramine / dextromethorphan / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1337'
    VALUE_SET_NAME = 'Chlorpheniramine / Dextromethorphan / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1117392', '1245291', '1423711'}


class AudiologyVisit(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent assessment tools or instruments used to quantify hearing.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with hearing assessment tools and instruments used to quantify hearing such as basic vestibular evaluation, spontaneous and positional nystagmus testing, and computerized dynamic posturography. This is a grouping of CPT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1066'
    VALUE_SET_NAME = 'Audiology Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'92540', '92541', '92542', '92548'}


class BetaBlockerTherapyForLvsd(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent beta blocker therapy for left ventricular systolic dysfunction (LVSD).
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; bisoprolol, carvedilol, or sustained release metoprolol succinate.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable.
    """

    OID = '2.16.840.1.113883.3.526.3.1184'
    VALUE_SET_NAME = 'Beta Blocker Therapy for LVSD'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '200031', '200032', '200033', '686924', '854901', '854905', '854908', '854916', '854919',
        '860510', '860516', '860522', '860532', '866412', '866419', '866427', '866436', '866452',
        '866461', '866472'
    }


class CataractSurgery(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent cataract surgical procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with cataract surgery.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1411'
    VALUE_SET_NAME = 'Cataract Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'66840', '66850', '66852', '66920', '66930', '66940', '66982', '66983', '66984'}

    SNOMEDCT = {
        '10178000', '110473004', '112963003', '112964009', '12163000', '231744001', '308694002',
        '308695001', '313999004', '31705006', '335636001', '336651000', '35717002', '361191005',
        '385468004', '39243005', '397544007', '404628003', '415089008', '417493007', '418430006',
        '419767009', '420260004', '420526005', '424945000', '446548003', '46309001', '46426006',
        '46562009', '50538003', '5130002', '51839008', '54885007', '65812008', '67760003',
        '69360005', '74490003', '75814005', '79611007', '82155009', '84149000', '85622008',
        '88282000', '89153001', '9137006'
    }


class MorgagnianCataract(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent morgagnian cataract.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with morgagnian cataract.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1558'
    VALUE_SET_NAME = 'Morgagnian Cataract'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H2521', 'H2522', 'H2523'}

    ICD9CM = {'36618'}

    SNOMEDCT = {'264443002'}


class UseOfSystemicSympatheticAlpha1AAntagonistMedicationForTreatmentOfProstaticHypertrophy(
        ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent systemic sympathetic alpha-1a antagonist medications for treatment of prostatic hypertrophy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; oral administrations of alfuzosin hydrochloride, doxazosin, prazosin, and terazosin.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable.
    """

    OID = '2.16.840.1.113883.3.526.3.1442'
    VALUE_SET_NAME = 'Use of Systemic Sympathetic alpha-1a Antagonist Medication for Treatment of Prostatic Hypertrophy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '197625', '197626', '197627', '197628', '198141', '199797', '199798', '199799', '260376',
        '312481', '312482', '312483', '312593', '312594', '313215', '313217', '313219', '636360',
        '636361', '861132', '861402', '863669', '996097'
    }


class DisordersOfOpticChiasm(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of disorders of optic chiasm.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of optic chiasm disorders or injuries or optic glioma.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1457'
    VALUE_SET_NAME = 'Disorders of Optic Chiasm'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H4741', 'H4742', 'H4743', 'H4749'}

    ICD9CM = {'37751', '37752', '37753', '37754'}

    SNOMEDCT = {
        '194057002', '194058007', '194059004', '194060009', '230517004', '302902003', '404653000',
        '404664002', '431769004', '50595002', '64246009', '69820004', '70476006', '89654006'
    }


class ContactOrOfficeVisit(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent contact and office visits for new and established patients, and includes in-person, telephone, online, and other visit types related to depression encounters.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with outpatient contact and office visits in which a patient may be evaluated for depression. This groups CPT and HCPCS codes.
    Exclusion Criteria: Excludes inpatients for purposes of the index event. The majority of CPT codes are specified for outpatient visit types; however psychiatry and psychotherapy visits can be used in the inpatient setting.
    """

    OID = '2.16.840.1.113762.1.4.1080.5'
    VALUE_SET_NAME = 'Contact or Office Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '90791', '90792', '90832', '90834', '90837', '99201', '99202', '99203', '99204', '99205',
        '99211', '99212', '99213', '99214', '99215', '99441', '99442', '99443', '99444'
    }

    HCPCS = {'G0402', 'G0438', 'G0439'}


class AmitriptylineChlordiazepoxide(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent amitriptyline / chlordiazepoxide combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; amitriptyline / chlordiazepoxide (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; amitriptyline / chlordiazepoxide in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1286'
    VALUE_SET_NAME = 'Amitriptyline  /  Chlordiazepoxide'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'856769', '856792'}


class VaricellaZosterVaccineVzvAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedure codes for varicella zoster vaccine administration.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with all varicella zoster vaccine administration codes. This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1040'
    VALUE_SET_NAME = 'Varicella Zoster Vaccine (VZV) Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90710', '90716'}

    SNOMEDCT = {'425897001', '428502009', '473164004', '571611000119101'}


class CardiacPacerInSitu(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of cardiac pacer in situ.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of cardiac pacer in situ.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.368'
    VALUE_SET_NAME = 'Cardiac Pacer in Situ'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z950'}

    ICD9CM = {'V4501'}

    SNOMEDCT = {'441509002'}


class InactivatedPolioVaccineIpvAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures for inactivated polio vaccine (IPV) administration.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with all inactivated polio vaccine (IPV) administration codes. This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1045'
    VALUE_SET_NAME = 'Inactivated Polio Vaccine (IPV) Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90698', '90713', '90723'}

    SNOMEDCT = {
        '396456003', '412762002', '414001002', '414259000', '414619005', '414620004', '415507003',
        '415712004', '416144004', '416591003', '417211006', '417384007', '417615007'
    }


class PhysicalActivityRecommendation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent exercise, education and nutrition.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with promoting exercise and nutrition regimens.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1518'
    VALUE_SET_NAME = 'Physical Activity Recommendation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    HCPCS = {'S9451'}

    SNOMEDCT = {
        '281090004', '304507003', '304549008', '386291006', '386292004', '386373004', '386463000',
        '410289001'
    }


class RheumatoidArthritis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of rheumatoid arthritis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with rheumatoid arthritis and Felty's syndrome. Includes only relevant concepts associated with comorbidities occurring with rheumatoid arthritis, such as rheumatoid polyneuropathy, rheumatoid myopathy, rheumatoid heart disease, rheumatoid vasculitis, and rheumatoid lung disease. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes codes for juvenile chronic polyarthritis, chronic post rheumatic arthropathy, and inflammatory polyarthropathy.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1005'
    VALUE_SET_NAME = 'Rheumatoid Arthritis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'M0500', 'M05011', 'M05012', 'M05019', 'M05021', 'M05022', 'M05029', 'M05031', 'M05032',
        'M05039', 'M05041', 'M05042', 'M05049', 'M05051', 'M05052', 'M05059', 'M05061', 'M05062',
        'M05069', 'M05071', 'M05072', 'M05079', 'M0509', 'M0510', 'M05111', 'M05112', 'M05119',
        'M05121', 'M05122', 'M05129', 'M05131', 'M05132', 'M05139', 'M05141', 'M05142', 'M05149',
        'M05151', 'M05152', 'M05159', 'M05161', 'M05162', 'M05169', 'M05171', 'M05172', 'M05179',
        'M0519', 'M0520', 'M05211', 'M05212', 'M05219', 'M05221', 'M05222', 'M05229', 'M05231',
        'M05232', 'M05239', 'M05241', 'M05242', 'M05249', 'M05251', 'M05252', 'M05259', 'M05261',
        'M05262', 'M05269', 'M05271', 'M05272', 'M05279', 'M0529', 'M0530', 'M05311', 'M05312',
        'M05319', 'M05321', 'M05322', 'M05329', 'M05331', 'M05332', 'M05339', 'M05341', 'M05342',
        'M05349', 'M05351', 'M05352', 'M05359', 'M05361', 'M05362', 'M05369', 'M05371', 'M05372',
        'M05379', 'M0539', 'M0540', 'M05411', 'M05412', 'M05419', 'M05421', 'M05422', 'M05429',
        'M05431', 'M05432', 'M05439', 'M05441', 'M05442', 'M05449', 'M05451', 'M05452', 'M05459',
        'M05461', 'M05462', 'M05469', 'M05471', 'M05472', 'M05479', 'M0549', 'M0550', 'M05511',
        'M05512', 'M05519', 'M05521', 'M05522', 'M05529', 'M05531', 'M05532', 'M05539', 'M05541',
        'M05542', 'M05549', 'M05551', 'M05552', 'M05559', 'M05561', 'M05562', 'M05569', 'M05571',
        'M05572', 'M05579', 'M0559', 'M0560', 'M05611', 'M05612', 'M05619', 'M05621', 'M05622',
        'M05629', 'M05631', 'M05632', 'M05639', 'M05641', 'M05642', 'M05649', 'M05651', 'M05652',
        'M05659', 'M05661', 'M05662', 'M05669', 'M05671', 'M05672', 'M05679', 'M0569', 'M0570',
        'M05711', 'M05712', 'M05719', 'M05721', 'M05722', 'M05729', 'M05731', 'M05732', 'M05739',
        'M05741', 'M05742', 'M05749', 'M05751', 'M05752', 'M05759', 'M05761', 'M05762', 'M05769',
        'M05771', 'M05772', 'M05779', 'M0579', 'M0580', 'M05811', 'M05812', 'M05819', 'M05821',
        'M05822', 'M05829', 'M05831', 'M05832', 'M05839', 'M05841', 'M05842', 'M05849', 'M05851',
        'M05852', 'M05859', 'M05861', 'M05862', 'M05869', 'M05871', 'M05872', 'M05879', 'M0589',
        'M059', 'M0600', 'M06011', 'M06012', 'M06019', 'M06021', 'M06022', 'M06029', 'M06031',
        'M06032', 'M06039', 'M06041', 'M06042', 'M06049', 'M06051', 'M06052', 'M06059', 'M06061',
        'M06062', 'M06069', 'M06071', 'M06072', 'M06079', 'M0608', 'M0609', 'M061', 'M0620',
        'M06211', 'M06212', 'M06219', 'M06221', 'M06222', 'M06229', 'M06231', 'M06232', 'M06239',
        'M06241', 'M06242', 'M06249', 'M06251', 'M06252', 'M06259', 'M06261', 'M06262', 'M06269',
        'M06271', 'M06272', 'M06279', 'M0628', 'M0629', 'M0630', 'M06311', 'M06312', 'M06319',
        'M06321', 'M06322', 'M06329', 'M06331', 'M06332', 'M06339', 'M06341', 'M06342', 'M06349',
        'M06351', 'M06352', 'M06359', 'M06361', 'M06362', 'M06369', 'M06371', 'M06372', 'M06379',
        'M0638', 'M0639', 'M0680', 'M06811', 'M06812', 'M06819', 'M06821', 'M06822', 'M06829',
        'M06831', 'M06832', 'M06839', 'M06841', 'M06842', 'M06849', 'M06851', 'M06852', 'M06859',
        'M06861', 'M06862', 'M06869', 'M06871', 'M06872', 'M06879', 'M0688', 'M0689', 'M069'
    }

    ICD9CM = {'7140', '7141', '7142', '71481'}

    SNOMEDCT = {
        '1073711000119105', '1073721000119103', '1073731000119100', '1073791000119101',
        '1073801000119100', '1073811000119102', '11055151000119108', '143441000119108',
        '201764007', '201766009', '201767000', '201768005', '201769002', '201770001', '201771002',
        '201772009', '201773004', '201774005', '201775006', '201776007', '201777003', '201778008',
        '201779000', '201780002', '201781003', '201783000', '201784006', '201785007', '201791009',
        '239791005', '239792003', '239793008', '239795001', '239941000', '239942007', '239943002',
        '287006005', '287007001', '287008006', '28880005', '308143008', '319841000119107',
        '398640008', '399923009', '400054000', '402433007', '427770001', '429192004', '433228003',
        '52661003', '57160007', '69896004', '735599007', '735600005', '7607008', '86219005'
    }


class HibVaccine4DoseSchedule(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent haemophilus influenzae type b (Hib) vaccines (4-dose schedule).
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with haemophilus influenzae type b (Hib) vaccine codes (4-dose schedule). This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1085'
    VALUE_SET_NAME = 'HiB Vaccine (4 dose schedule)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'120', '148', '48', '50', '51'}


class LowIntensityStatinTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent low intensity statin medications as defined by the 2013 American College of Cardiology (ACC) and the American Heart Association (AHA) guideline.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with low intensity statin therapy medications.
    Exclusion Criteria: Excludes any other intensity of statin therapy.
    """

    OID = '2.16.840.1.113762.1.4.1047.107'
    VALUE_SET_NAME = 'Low intensity statin therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1790679', '1944264', '197903', '197904', '2001254', '310404', '310405', '312962',
        '314231', '433849', '476345', '757702', '861643', '904458', '904467'
    }


class EssentialHypertension(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent essential hypertension.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who are diagnosed with essential hypertension.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1011'
    VALUE_SET_NAME = 'Essential Hypertension'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I10'}

    ICD9CM = {'4010', '4011', '4019'}

    SNOMEDCT = {
        '10725009', '1201005', '276789009', '371125006', '429457004', '46481004', '48146000',
        '56218007', '59621000', '59720008', '65518004', '762463000', '78975002'
    }


class Syphilis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a syphilis diagnosis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients with syphilis. This is a grouping of ICD-10-CM, ICD-9-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1002'
    VALUE_SET_NAME = 'Syphilis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A5009', 'A501', 'A502', 'A5031', 'A5040', 'A5041', 'A5042', 'A5045', 'A5049', 'A5052',
        'A5057', 'A5059', 'A506', 'A507', 'A509', 'A510', 'A511', 'A512', 'A5131', 'A5132',
        'A5139', 'A5141', 'A5142', 'A5143', 'A5144', 'A5145', 'A5146', 'A5149', 'A515', 'A519',
        'A5200', 'A5201', 'A5202', 'A5203', 'A5204', 'A5205', 'A5206', 'A5209', 'A5210', 'A5211',
        'A5212', 'A5213', 'A5214', 'A5215', 'A5216', 'A5217', 'A5219', 'A522', 'A523', 'A5271',
        'A5272', 'A5273', 'A5274', 'A5275', 'A5276', 'A5277', 'A5278', 'A5279', 'A528', 'A529',
        'A530', 'A539'
    }

    ICD9CM = {
        '0900', '0901', '0902', '0903', '09040', '09041', '09042', '09049', '0905', '0906', '0907',
        '0909', '0910', '0911', '0912', '0913', '0914', '09150', '09151', '09152', '09161',
        '09162', '09169', '0917', '09181', '09182', '09189', '0919', '0920', '0929', '0930',
        '0931', '09320', '09321', '09322', '09323', '09324', '09381', '09382', '09389', '0939',
        '0940', '0941', '0942', '0943', '09481', '09482', '09483', '09484', '09485', '09486',
        '09487', '09489', '0949', '0950', '0951', '0952', '0953', '0954', '0955', '0956', '0957',
        '0958', '0959', '096', '0970', '0971', '0979'
    }

    SNOMEDCT = {
        '10345003', '1107004', '11338007', '12232008', '13095005', '13310005', '13731006',
        '16070004', '186833000', '186842007', '186846005', '186847001', '186850003', '186854007',
        '186861006', '186863009', '186867005', '186868000', '186875004', '186877007', '186878002',
        '186899004', '186903006', '192008', '19206003', '192647003', '19290004', '193786000',
        '194907008', '194947001', '197305002', '197347003', '197348008', '197757004', '197966009',
        '198175009', '199154009', '199156006', '199157002', '199158007', '199159004', '202933002',
        '20735004', '21523006', '22386003', '230152000', '230182006', '230563005', '230735006',
        '232313005', '232367004', '233849007', '234017002', '235032001', '235062007', '235064008',
        '235065009', '23550005', '237446005', '237447001', '240552005', '240553000', '240554006',
        '240555007', '240556008', '240557004', '240558009', '240560006', '240562003', '240563008',
        '240564002', '240565001', '240566000', '240567009', '240568004', '240569007', '26039008',
        '26135000', '266125005', '266126006', '266127002', '266128007', '266130009', '266133006',
        '266136003', '27460003', '275376007', '27648007', '276700005', '278480000', '278481001',
        '28198007', '30080002', '302813001', '31015008', '31137003', '312934004', '312955002',
        '314840009', '315826004', '316841006', '32735002', '34242002', '35742006', '3589003',
        '36276008', '37028008', '371237000', '37430004', '37754005', '38523005', '39085002',
        '402940004', '402941000', '402942007', '402943002', '402944008', '402945009', '402946005',
        '402947001', '402949003', '402950003', '402951004', '405635002', '4082005', '410470003',
        '410478005', '42770003', '4359001', '444150000', '44568006', '4483005', '45058001',
        '46235002', '49923008', '50528008', '51928006', '51960003', '52414005', '54069001',
        '54274001', '55768006', '56118002', '58056005', '58227000', '58392004', '59233003',
        '59307008', '59530001', '59721007', '59934002', '60528006', '61612001', '62207008',
        '6267005', '62861003', '63751007', '64102008', '66281009', '66887000', '67125004',
        '67391006', '68764005', '69595007', '713251003', '72083004', '735515000', '736686006',
        '75299005', '76272004', '77028001', '77939001', '80770009', '81339006', '82323002',
        '82355002', '827006', '82959004', '83883001', '8555001', '85857008', '86028001',
        '86443005', '87318008', '88943008', '91554004', '9941009'
    }


class PrimaryTkaProcedure(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent primary Total Knee Arthroplasty (TKA) procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with codes that identify primary TKA procedures. This is a grouping of CPT, HCPCS and SNOMED CT codes.
    Exclusion Criteria: Excludes codes for revision or partial knee arthroplasty procedures.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1007'
    VALUE_SET_NAME = 'Primary TKA Procedure'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'27447'}

    SNOMEDCT = {
        '179344006', '179345007', '179351002', '179352009', '265170009', '265172001', '392237008',
        '430698003', '443681002', '443682009'
    }


class DiagnosisOfHypertension(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses and disorders to identify recent onset or evolving hypertension.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients represented by recent onset or evolving diagnosis of hypertension.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.263'
    VALUE_SET_NAME = 'Diagnosis of hypertension'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H35039', 'I10', 'I110', 'I119', 'I120', 'I129', 'I130', 'I1310', 'I1311', 'I132', 'I150',
        'I160', 'I161', 'I169', 'I674'
    }

    ICD9CM = {
        '4011', '4019', '40201', '40211', '40291', '40301', '40311', '40391', '40401', '40402',
        '40403', '40411', '40412', '40413', '40491', '40492', '40493', '40501', '40511', '40519',
        '40591', '40599'
    }

    SNOMEDCT = {
        '102932008', '10725009', '10964002', '1201005', '123799005', '123800009', '14973001',
        '170577003', '170578008', '170579000', '170586008', '185264001', '185716009', '194783001',
        '194785008', '194788005', '194791005', '19769006', '23130000', '233815004', '233941006',
        '233942004', '233943009', '233944003', '233945002', '233946001', '234072000', '234073005',
        '234075003', '237279007', '270440008', '28119000', '288250001', '31992008', '34742003',
        '371125006', '371622005', '38341003', '39018007', '395050009', '397748008', '398254007',
        '401117004', '402832006', '4210003', '423674003', '428575007', '429198000', '429457004',
        '44772007', '46481004', '46764007', '48146000', '48194001', '52698002', '56218007',
        '57684003', '59621000', '59720008', '59997006', '65518004', '68267002', '70272006',
        '73410007', '74451002', '78975002', '81626002', '84094009', '8762007', '89242004'
    }


class AcetaminophenButalbitalCaffeineCodeine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / butalbital / caffeine / codeine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / butalbital / caffeine / codeine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / butalbital / caffeine / codeine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1326'
    VALUE_SET_NAME = 'Acetaminophen / Butalbital / Caffeine / Codeine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1431286', '993943'}


class Hyoscyamine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hyoscyamine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; hyoscyamine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; hyoscyamine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1501'
    VALUE_SET_NAME = 'Hyoscyamine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1046770', '1046982', '1046985', '1047881', '1047895', '1047905', '1047916', '1807886'
    }


class HipReplacementSurgery(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent total hip replacement procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients who have a total hip replacement procedure.
    Inclusion Criteria: Includes only relevant concepts associated with representing the surgical procedure of a total hip replacement.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.259'
    VALUE_SET_NAME = 'Hip Replacement Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '0SP909Z', '0SP90JZ', '0SPA0JZ', '0SPB09Z', '0SPB0JZ', '0SPE0JZ', '0SPR0JZ', '0SPS0JZ',
        '0SR9019', '0SR901A', '0SR901Z', '0SR9029', '0SR902A', '0SR902Z', '0SR9039', '0SR903A',
        '0SR903Z', '0SR9049', '0SR904A', '0SR904Z', '0SR907Z', '0SR90J9', '0SR90JA', '0SR90JZ',
        '0SR90KZ', '0SRA009', '0SRA00A', '0SRA00Z', '0SRA019', '0SRA01A', '0SRA01Z', '0SRA039',
        '0SRA03A', '0SRA03Z', '0SRA07Z', '0SRA0J9', '0SRA0JA', '0SRA0JZ', '0SRA0KZ', '0SRB019',
        '0SRB01A', '0SRB01Z', '0SRB029', '0SRB02A', '0SRB02Z', '0SRB039', '0SRB03A', '0SRB03Z',
        '0SRB049', '0SRB04A', '0SRB04Z', '0SRB07Z', '0SRB0J9', '0SRB0JA', '0SRB0JZ', '0SRB0KZ',
        '0SRE009', '0SRE00A', '0SRE00Z', '0SRE019', '0SRE01A', '0SRE01Z', '0SRE039', '0SRE03A',
        '0SRE03Z', '0SRE07Z', '0SRE0J9', '0SRE0JA', '0SRE0JZ', '0SRE0KZ', '0SRR019', '0SRR01A',
        '0SRR01Z', '0SRR039', '0SRR03A', '0SRR03Z', '0SRR07Z', '0SRR0J9', '0SRR0JA', '0SRR0JZ',
        '0SRR0KZ', '0SRS019', '0SRS01A', '0SRS01Z', '0SRS039', '0SRS03A', '0SRS03Z', '0SRS07Z',
        '0SRS0J9', '0SRS0JA', '0SRS0JZ', '0SRS0KZ', '0SU907Z', '0SU909Z', '0SU90BZ', '0SU90JZ',
        '0SU90KZ', '0SUA09Z', '0SUA0BZ', '0SUB07Z', '0SUB09Z', '0SUB0BZ', '0SUB0JZ', '0SUB0KZ',
        '0SUE09Z', '0SUE0BZ', '0SUR09Z', '0SUR0BZ', '0SUS09Z', '0SUS0BZ', '0SW907Z', '0SW909Z',
        '0SW90JZ', '0SW90KZ', '0SWA0JZ', '0SWB07Z', '0SWB09Z', '0SWB0JZ', '0SWB0KZ', '0SWE0JZ',
        '0SWR0JZ', '0SWS0JZ'
    }

    SNOMEDCT = {
        '112727005', '112728000', '15036006', '179294005', '179295006', '179304004', '179305003',
        '179306002', '179326003', '19954002', '265157000', '265158005', '265160007', '265161006',
        '276178005', '29969002', '307814001', '307815000', '309853002', '314489006', '314491003',
        '32581000', '33788003', '340922009', '386649003', '397956004', '425443008', '426618001',
        '426904006', '427728006', '428622003', '429156003', '430688009', '430694001', '443435007',
        '444051004', '445185007', '447947007', '447992000', '449039004', '450813004', '47596009',
        '52734007', '53081006', '57589001', '62402000', '68491008', '76116002', '76915002',
        '7989006'
    }


class InjectableFactorXaInhibitorForVteProphylaxis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent codes which identify injectable factor Xa inhibitors, which are used for venous thromboembolism (VTE) prophylaxis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who are on a select injectable factor Xa inhibitor as prophylaxis for VTE.
    Inclusion Criteria: Includes only relevant concepts associated with injectable factor Xa inhibitor medications. These are RxNorm codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.211'
    VALUE_SET_NAME = 'Injectable Factor Xa Inhibitor for VTE Prophylaxis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'861356', '861360', '861363', '861365'}


class DementiaMedications(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dementia medications.
    Data Element Scope: This value set may use Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes semantic clinical drugs (includes component, form and strength); generic; prescribable. Includes dementia medications. This is a grouping of RXNORM codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1510'
    VALUE_SET_NAME = 'Dementia Medications'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1100184', '1308569', '1858970', '310436', '310437', '312835', '312836', '314214',
        '314215', '579148', '725021', '725023', '860695', '860707', '860715', '860901', '996561',
        '996571', '996572', '996594', '996603', '996609', '996615', '996624', '996740', '997220',
        '997223', '997226', '997229'
    }


class StatusPostRightMastectomy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a history of a right mastectomy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with patients that have a history of a right mastectomy. This is a grouping of SNOMED CT and ICD-10-CM codes.
    Exclusion Criteria: Excludes codes that indicate a left or bilateral mastectomy or are unspecified.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1070'
    VALUE_SET_NAME = 'Status Post Right Mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z9011'}

    SNOMEDCT = {'137681000119108', '429242008'}


class RubellaAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests for the presence of rubella IgG antibody in serum.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with testing the presence of rubella IgG antibody.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1064'
    VALUE_SET_NAME = 'Rubella Antibody Test (IgG Antibody presence)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'25514-1', '39013-8', '40667-8', '40668-6', '63462-6', '74415-1'}


class HepatitisBVaccineAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures for hepatitis B vaccine administration.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with all relevant hepatitis B vaccine administration codes. This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1042'
    VALUE_SET_NAME = 'Hepatitis B Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90723', '90740', '90744', '90747', '90748'}

    ICD10PCS = {'3E0234Z'}

    ICD9CM = {'9955'}

    SNOMEDCT = {
        '116802006', '16584000', '170370000', '170371001', '170372008', '170373003', '170434002',
        '170435001', '170436000', '170437009', '312868009', '396456003'
    }


class White(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a patient's race as white.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Patient Characteristic Race.
    Inclusion Criteria: Includes only relevant concepts associated with a code to identify a patient's race as white. This is a grouping of a CDCREC code.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.123.12.1007'
    VALUE_SET_NAME = 'White'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CDCREC = {'2106-3'}


class MarfansSyndrome(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of Marfan's syndrome.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes for Marfan's syndrome with or without cardiovascular, ocular, skeletal, or epithelial manifestations. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1048'
    VALUE_SET_NAME = "Marfan's Syndrome"
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Q8740', 'Q87410', 'Q87418', 'Q8742', 'Q8743'}

    ICD9CM = {'75982'}

    SNOMEDCT = {
        '15960021000119107', '15993551000119100', '16055631000119106', '19346006', '234035006',
        '57201002', '763839005'
    }


class Lupus(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of lupus (lupus erythematosus).
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes for systemic, discoid, and drug-induced systemic lupus erythematosus. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.117.12.1010'
    VALUE_SET_NAME = 'Lupus'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'M320', 'M3210', 'M3211', 'M3212', 'M3213', 'M3214', 'M3215', 'M3219', 'M328', 'M329'
    }

    ICD9CM = {'7100'}

    SNOMEDCT = {
        '11013005', '196138005', '19682006', '200936003', '201436003', '22888007', '239886003',
        '239887007', '239888002', '239889005', '239890001', '25380002', '309762007', '36402006',
        '403486000', '403487009', '4676006', '52042003', '54072008', '54912002', '55464009',
        '61458006', '68815009', '73286009', '76521009', '77753005', '80258006', '95332009',
        '95408003', '95644001'
    }


class FrailtyDiagnosis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses of frailty.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnoses that represent frailty. This is a grouping of ICD10CM and SNOMEDCT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1074'
    VALUE_SET_NAME = 'Frailty Diagnosis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'L89119', 'L89139', 'L89149', 'L89159', 'L89209', 'L89309', 'L89899', 'L8990', 'M6250',
        'M6281', 'M6284', 'W010XXA', 'W010XXD', 'W010XXS', 'W0110XA', 'W0110XD', 'W0110XS',
        'W01110A', 'W01110D', 'W01110S', 'W01111A', 'W01111D', 'W01111S', 'W01118A', 'W01118D',
        'W01118S', 'W01119A', 'W01119D', 'W01119S', 'W01190A', 'W01190D', 'W01190S', 'W01198A',
        'W01198D', 'W01198S', 'W06XXXA', 'W06XXXD', 'W06XXXS', 'W07XXXA', 'W07XXXD', 'W07XXXS',
        'W08XXXA', 'W08XXXD', 'W08XXXS', 'W100XXA', 'W100XXD', 'W100XXS', 'W101XXA', 'W101XXD',
        'W101XXS', 'W102XXA', 'W102XXD', 'W102XXS', 'W108XXA', 'W108XXD', 'W108XXS', 'W109XXA',
        'W109XXD', 'W109XXS', 'W1800XA', 'W1800XD', 'W1800XS', 'W1802XA', 'W1802XD', 'W1802XS',
        'W1809XA', 'W1809XD', 'W1809XS', 'W1811XA', 'W1811XD', 'W1811XS', 'W1812XA', 'W1812XD',
        'W1812XS', 'W182XXA', 'W182XXD', 'W182XXS', 'W1830XA', 'W1830XD', 'W1830XS', 'W1831XA',
        'W1831XD', 'W1831XS', 'W1839XA', 'W1839XD', 'W1839XS', 'W19XXXA', 'W19XXXD', 'W19XXXS',
        'Y92199', 'Z593', 'Z736', 'Z7401', 'Z7409', 'Z741', 'Z742', 'Z743', 'Z748', 'Z749',
        'Z9181', 'Z9911', 'Z993', 'Z9981', 'Z9989'
    }

    SNOMEDCT = {
        '10637031000119106', '10637071000119109', '10637111000119102', '10637151000119101',
        '129588001', '138371000119104', '162845004', '17886000', '20902002', '217082002',
        '217083007', '217084001', '217086004', '217088003', '217090002', '217092005', '217093000',
        '217094006', '217142006', '217154006', '217155007', '217156008', '217157004', '217158009',
        '217173005', '225558004', '225562005', '225563000', '242388006', '242389003', '242390007',
        '242391006', '242392004', '242393009', '242394003', '242395002', '242396001', '242402009',
        '242404005', '242405006', '242406007', '242407003', '242413007', '242414001', '242419006',
        '250054005', '269699007', '274918000', '274919008', '288296009', '33036003', '40104005',
        '414188008', '414189000', '414190009', '427849003', '428484005', '429621003', '44188002',
        '54840006', '56307009', '67223001', '699214007', '699215008', '699216009', '699218005',
        '715504003', '736313002', '74541001', '83468000', '8960001000004106', '90619006',
        '92341000119107'
    }


class FollowupWithinOneYear(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent capturing the follow-up encounter within one year of the initial encounter.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter. Intention to represent follow-up visits within a one-year period.
    Inclusion Criteria: Includes only relevant concepts associated with capturing the follow-up between 1 day to 12 month of the initial finding.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1474'
    VALUE_SET_NAME = 'Followup within one year'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '183617005', '183618000', '183619008', '183620002', '183621003', '183622005', '183623000',
        '183624006', '183625007', '183626008', '183627004', '183628009', '300042001'
    }


class ChlorpheniramineDextromethorphanPhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorpheniramine / dextromethorphan / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorpheniramine / dextromethorphan / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorpheniramine / dextromethorphan / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1312'
    VALUE_SET_NAME = 'Chlorpheniramine / Dextromethorphan / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1535923', '1536862'}


class GroupPsychotherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent visits during which group psychotherapy is performed.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with group psychotherapy.
    Exclusion Criteria: Excludes family psychotherapy or individual psychotherapy.
    """

    OID = '2.16.840.1.113883.3.526.3.1187'
    VALUE_SET_NAME = 'Group Psychotherapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90853'}

    SNOMEDCT = {'76168009'}


class OtherDisordersOfOpticNerve(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of other disorders of optic nerve.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of ischemic optic neuropathy.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1471'
    VALUE_SET_NAME = 'Other Disorders of Optic Nerve'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H47011', 'H47012', 'H47013'}

    ICD9CM = {'37741'}

    SNOMEDCT = {
        '14357004', '15731601000119100', '15731641000119103', '230508004', '230509007',
        '404659001', '415147002', '733506009'
    }


class CardiacSurgery(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent cardiac surgery.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with cardiac surgery.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.371'
    VALUE_SET_NAME = 'Cardiac Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '33140', '33510', '33511', '33512', '33513', '33514', '33516', '33517', '33518', '33519',
        '33521', '33522', '33523', '33533', '33534', '33535', '33536', '92920', '92924', '92928',
        '92933', '92937', '92941', '92943', '92980', '92981', '92982', '92984', '92995', '92996'
    }

    SNOMEDCT = {
        '10326007', '119564002', '119565001', '15256002', '174911007', '175007008', '175008003',
        '175009006', '175011002', '175021005', '175022003', '175024002', '175025001', '175026000',
        '175036008', '175037004', '175038009', '175039001', '175040004', '175041000', '175045009',
        '175047001', '175048006', '175050003', '232717009', '232719007', '232720001', '232721002',
        '232722009', '232723004', '232724005', '265481001', '275215001', '275216000', '275227003',
        '275252001', '275253006', '287277008', '30670000', '309814006', '3546002', '359597003',
        '359601003', '39202005', '39724006', '414088005', '418551006', '418824004', '419132001',
        '48431000', '736966005', '736967001', '736968006', '736969003', '736970002', '736971003',
        '736972005', '736973000', '74371005', '81266008', '82247006', '90205004'
    }


class MalignantNeoplasmOfLymphaticAndHematopoieticTissue(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent lymphoma, leukemia and other malignant cancers of the lymphatic and hematologic systems.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnoses of lymphoma and other cancers of the lymph and hematologic systems.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1009'
    VALUE_SET_NAME = 'Malignant Neoplasm of Lymphatic and Hematopoietic Tissue'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'C8100', 'C8101', 'C8102', 'C8103', 'C8104', 'C8105', 'C8106', 'C8107', 'C8108', 'C8109',
        'C8110', 'C8111', 'C8112', 'C8113', 'C8114', 'C8115', 'C8116', 'C8117', 'C8118', 'C8119',
        'C8120', 'C8121', 'C8122', 'C8123', 'C8124', 'C8125', 'C8126', 'C8127', 'C8128', 'C8129',
        'C8130', 'C8131', 'C8132', 'C8133', 'C8134', 'C8135', 'C8136', 'C8137', 'C8138', 'C8139',
        'C8140', 'C8141', 'C8142', 'C8143', 'C8144', 'C8145', 'C8146', 'C8147', 'C8148', 'C8149',
        'C8170', 'C8171', 'C8172', 'C8173', 'C8174', 'C8175', 'C8176', 'C8177', 'C8178', 'C8179',
        'C8190', 'C8191', 'C8192', 'C8193', 'C8194', 'C8195', 'C8196', 'C8197', 'C8198', 'C8199',
        'C8200', 'C8201', 'C8202', 'C8203', 'C8204', 'C8205', 'C8206', 'C8207', 'C8208', 'C8209',
        'C8210', 'C8211', 'C8212', 'C8213', 'C8214', 'C8215', 'C8216', 'C8217', 'C8218', 'C8219',
        'C8220', 'C8221', 'C8222', 'C8223', 'C8224', 'C8225', 'C8226', 'C8227', 'C8228', 'C8229',
        'C8230', 'C8231', 'C8232', 'C8233', 'C8234', 'C8235', 'C8236', 'C8237', 'C8238', 'C8239',
        'C8240', 'C8241', 'C8242', 'C8243', 'C8244', 'C8245', 'C8246', 'C8247', 'C8248', 'C8249',
        'C8250', 'C8251', 'C8252', 'C8253', 'C8254', 'C8255', 'C8256', 'C8257', 'C8258', 'C8259',
        'C8260', 'C8261', 'C8262', 'C8263', 'C8264', 'C8265', 'C8266', 'C8267', 'C8268', 'C8269',
        'C8280', 'C8281', 'C8282', 'C8283', 'C8284', 'C8285', 'C8286', 'C8287', 'C8288', 'C8289',
        'C8290', 'C8291', 'C8292', 'C8293', 'C8294', 'C8295', 'C8296', 'C8297', 'C8298', 'C8299',
        'C8300', 'C8301', 'C8302', 'C8303', 'C8304', 'C8305', 'C8306', 'C8307', 'C8308', 'C8309',
        'C8310', 'C8311', 'C8312', 'C8313', 'C8314', 'C8315', 'C8316', 'C8317', 'C8318', 'C8319',
        'C8330', 'C8331', 'C8332', 'C8333', 'C8334', 'C8335', 'C8336', 'C8337', 'C8338', 'C8339',
        'C8350', 'C8351', 'C8352', 'C8353', 'C8354', 'C8355', 'C8356', 'C8357', 'C8358', 'C8359',
        'C8370', 'C8371', 'C8372', 'C8373', 'C8374', 'C8375', 'C8376', 'C8377', 'C8378', 'C8379',
        'C8380', 'C8381', 'C8382', 'C8383', 'C8384', 'C8385', 'C8386', 'C8387', 'C8388', 'C8389',
        'C8390', 'C8391', 'C8392', 'C8393', 'C8394', 'C8395', 'C8396', 'C8397', 'C8398', 'C8399',
        'C8400', 'C8401', 'C8402', 'C8403', 'C8404', 'C8405', 'C8406', 'C8407', 'C8408', 'C8409',
        'C8410', 'C8411', 'C8412', 'C8413', 'C8414', 'C8415', 'C8416', 'C8417', 'C8418', 'C8419',
        'C8440', 'C8441', 'C8442', 'C8443', 'C8444', 'C8445', 'C8446', 'C8447', 'C8448', 'C8449',
        'C8460', 'C8461', 'C8462', 'C8463', 'C8464', 'C8465', 'C8466', 'C8467', 'C8468', 'C8469',
        'C8470', 'C8471', 'C8472', 'C8473', 'C8474', 'C8475', 'C8476', 'C8477', 'C8478', 'C8479',
        'C8490', 'C8491', 'C8492', 'C8493', 'C8494', 'C8495', 'C8496', 'C8497', 'C8498', 'C8499',
        'C84A0', 'C84A1', 'C84A2', 'C84A3', 'C84A4', 'C84A5', 'C84A6', 'C84A7', 'C84A8', 'C84A9',
        'C84Z0', 'C84Z1', 'C84Z2', 'C84Z3', 'C84Z4', 'C84Z5', 'C84Z6', 'C84Z7', 'C84Z8', 'C84Z9',
        'C8510', 'C8511', 'C8512', 'C8513', 'C8514', 'C8515', 'C8516', 'C8517', 'C8518', 'C8519',
        'C8520', 'C8521', 'C8522', 'C8523', 'C8524', 'C8525', 'C8526', 'C8527', 'C8528', 'C8529',
        'C8580', 'C8581', 'C8582', 'C8583', 'C8584', 'C8585', 'C8586', 'C8587', 'C8588', 'C8589',
        'C8590', 'C8591', 'C8592', 'C8593', 'C8594', 'C8595', 'C8596', 'C8597', 'C8598', 'C8599',
        'C860', 'C861', 'C862', 'C863', 'C864', 'C865', 'C866', 'C882', 'C883', 'C884', 'C888',
        'C889', 'C9000', 'C9001', 'C9002', 'C9010', 'C9011', 'C9012', 'C9020', 'C9021', 'C9022',
        'C9030', 'C9031', 'C9032', 'C9100', 'C9101', 'C9102', 'C9110', 'C9111', 'C9112', 'C9130',
        'C9131', 'C9132', 'C9140', 'C9141', 'C9142', 'C9150', 'C9151', 'C9152', 'C9160', 'C9161',
        'C9162', 'C9190', 'C9191', 'C9192', 'C91A0', 'C91A1', 'C91A2', 'C91Z0', 'C91Z1', 'C91Z2',
        'C9200', 'C9201', 'C9202', 'C9210', 'C9211', 'C9212', 'C9220', 'C9221', 'C9222', 'C9230',
        'C9231', 'C9232', 'C9240', 'C9241', 'C9242', 'C9250', 'C9251', 'C9252', 'C9260', 'C9261',
        'C9262', 'C9290', 'C9291', 'C9292', 'C92A0', 'C92A1', 'C92A2', 'C92Z0', 'C92Z1', 'C92Z2',
        'C9300', 'C9301', 'C9302', 'C9310', 'C9311', 'C9312', 'C9330', 'C9331', 'C9332', 'C9390',
        'C9391', 'C9392', 'C93Z0', 'C93Z1', 'C93Z2', 'C9400', 'C9401', 'C9402', 'C9420', 'C9421',
        'C9422', 'C9430', 'C9431', 'C9432', 'C9480', 'C9481', 'C9482', 'C9500', 'C9501', 'C9502',
        'C9510', 'C9511', 'C9512', 'C9590', 'C9591', 'C9592', 'C960', 'C962', 'C9620', 'C9621',
        'C9622', 'C9629', 'C964', 'C969', 'C96A', 'C96Z'
    }

    SNOMEDCT = {
        '109962001', '109964000', '109965004', '109966003', '109967007', '109968002', '109969005',
        '109970006', '109971005', '109972003', '109975001', '109976000', '109977009', '109978004',
        '109979007', '109980005', '109988003', '109991003', '109994006', '109995007', '109996008',
        '109998009', '110000005', '110002002', '110004001', '110005000', '110006004', '110007008',
        '116711000119103', '116741000119104', '116811000119106', '116821000119104',
        '117061000119101', '117091000119108', '117111000119100', '118599009', '118600007',
        '118601006', '118602004', '118605002', '118606001', '118607005', '118608000', '118609008',
        '118610003', '118611004', '118612006', '118613001', '118614007', '118615008', '118617000',
        '118618005', '122881000119107', '122901000119109', '122951000119108', '122961000119105',
        '122981000119101', '12301000132103', '12311000132101', '123781000119107', '127070008',
        '127220001', '127225006', '127961000119108', '128874001', '128875000', '13048006',
        '133751000119102', '187822008', '188487008', '188489006', '188492005', '188493000',
        '188498009', '188500005', '188501009', '188502002', '188503007', '188504001', '188505000',
        '188506004', '188507008', '188510001', '188511002', '188512009', '188513004', '188514005',
        '188515006', '188516007', '188517003', '188524002', '188526000', '188529007', '188531003',
        '188534006', '188536008', '188537004', '188538009', '188541000', '188544008', '188547001',
        '188548006', '188551004', '188554007', '188558005', '188559002', '188562004', '188565002',
        '188566001', '188567005', '188568000', '188569008', '188570009', '188572001', '188575004',
        '188576003', '188577007', '188578002', '188579005', '188580008', '188582000', '188585003',
        '188586002', '188587006', '188589009', '188590000', '188591001', '188592008', '188593003',
        '188609000', '188612002', '188613007', '188627002', '188630009', '188631008', '188632001',
        '188633006', '188634000', '188635004', '188637007', '188640007', '188641006', '188642004',
        '188645002', '188648000', '188649008', '188660004', '188662007', '188663002', '188664008',
        '188665009', '188666005', '188667001', '188668006', '188669003', '188672005', '188674006',
        '188675007', '188676008', '188679001', '188718006', '188725004', '188726003', '188728002',
        '188729005', '188732008', '188733003', '188734009', '188736006', '188737002', '188738007',
        '188741003', '188744006', '188745007', '188746008', '188748009', '188754005', '188768003',
        '188770007', '189509003', '190030009', '232075002', '236512004', '236513009', '240531002',
        '254792006', '255101006', '255102004', '269475001', '269476000', '274905008', '276811008',
        '276815004', '276836002', '277473004', '277474005', '277545003', '277549009', '277550009',
        '277551008', '277567002', '277568007', '277569004', '277570003', '277571004', '277572006',
        '277573001', '277574007', '277575008', '277587001', '277589003', '277597005', '277601005',
        '277602003', '277604002', '277609007', '277610002', '277611003', '277612005', '277613000',
        '277614006', '277615007', '277616008', '277617004', '277618009', '277619001', '277622004',
        '277623009', '277624003', '277625002', '277626001', '277627005', '277628000', '277629008',
        '277632006', '277637000', '277641001', '277642008', '277643003', '277651000', '277653002',
        '277654008', '277664004', '278051002', '278052009', '278189009', '278453007', '285769009',
        '285776004', '285839005', '302841002', '302842009', '302845006', '302848008', '302855005',
        '302856006', '303017006', '303055001', '303056000', '303057009', '307340003', '307341004',
        '307592006', '307617006', '307622006', '307623001', '307624007', '307625008', '307633009',
        '307634003', '307635002', '307636001', '307637005', '307646004', '307647008', '307649006',
        '307650006', '308121000', '31047003', '359631009', '359640008', '359648001', '371012000',
        '371134001', '373168002', '397008008', '397009000', '397011009', '397015000', '398623004',
        '400001003', '400122007', '402880009', '402881008', '402882001', '404103007', '404104001',
        '404105000', '404106004', '404107008', '404108003', '404109006', '404110001', '404111002',
        '404112009', '404113004', '404114005', '404115006', '404116007', '404117003', '404118008',
        '404119000', '404120006', '404121005', '404122003', '404123008', '404124002', '404125001',
        '404126000', '404127009', '404128004', '404129007', '404130002', '404131003', '404132005',
        '404133000', '404134006', '404135007', '404136008', '404137004', '404138009', '404139001',
        '404140004', '404141000', '404142007', '404143002', '404144008', '404145009', '404146005',
        '404147001', '404148006', '404149003', '404150003', '404151004', '404152006', '404153001',
        '404154007', '404155008', '404157000', '404169008', '404172001', '413389003', '413441006',
        '413442004', '413537009', '413656006', '413842007', '413843002', '413847001', '414166008',
        '414780005', '414785000', '414791003', '415112005', '415283002', '415284008', '415285009',
        '415286005', '415287001', '420302007', '420519005', '420788006', '421246008', '421283008',
        '421835000', '422052002', '422853008', '425688002', '425749006', '425869007', '425941003',
        '426071002', '426124006', '426217000', '426248008', '426336007', '426370008', '426642002',
        '426885008', '427056005', '427141003', '427642009', '427658007', '430338009', '441559006',
        '441962003', '442537007', '443487006', '444597005', '444910004', '444911000', '445227008',
        '445269007', '445406001', '445448008', '447100004', '447656001', '447658000', '447766003',
        '447805007', '447806008', '447989004', '448212009', '448213004', '448217003', '448220006',
        '448231003', '448254007', '448269008', '448317000', '448319002', '448354009', '448371005',
        '448372003', '448376000', '448384001', '448386004', '448387008', '448447004', '448465000',
        '448468003', '448553002', '448555009', '448560008', '448561007', '448607004', '448609001',
        '448663003', '448666006', '448672006', '448709005', '448738008', '448774004', '448865007',
        '448867004', '448995000', '449053004', '449058008', '449059000', '449063007', '449065000',
        '449072004', '449074003', '449075002', '449108003', '449173006', '449176003', '449177007',
        '449216004', '449217008', '449218003', '449219006', '449220000', '449221001', '449222008',
        '449292003', '449307001', '449318001', '449386007', '449418000', '449419008',
        '450521000124109', '58961005', '61291000119103', '61301000119102', '61311000119104',
        '61321000119106', '698646006', '699657009', '699818003', '702446006', '702476004',
        '702785000', '702786004', '702977001', '703387000', '703626001', '705061009', '709471005',
        '713325002', '713483007', '713516007', '713718006', '713897006', '714251006', '714463003',
        '715664005', '715950008', '716788007', '718195003', '718200007', '721302006', '721303001',
        '721304007', '721305008', '721306009', '721308005', '721310007', '721313009', '721314003',
        '721555001', '721762007', '722795004', '722953004', '722954005', '723889003', '724644005',
        '724645006', '724647003', '724648008', '724649000', '724650000', '725390002', '725437002',
        '726721002', '733598001', '733627006', '734066005', '84811000119107', '84831000119102',
        '91854005', '91855006', '91856007', '91857003', '91858008', '91860005', '91861009',
        '92508006', '92509003', '92510008', '92511007', '92512000', '92513005', '92514004',
        '92515003', '92516002', '92811003', '92812005', '92813000', '92814006', '92817004',
        '92818009', '93133006', '93134000', '93135004', '93136003', '93137007', '93138002',
        '93139005', '93140007', '93141006', '93142004', '93143009', '93144003', '93145002',
        '93146001', '93147005', '93148000', '93149008', '93150008', '93151007', '93152000',
        '93169003', '93182006', '93183001', '93184007', '93185008', '93186009', '93187000',
        '93188005', '93189002', '93190006', '93191005', '93192003', '93193008', '93194002',
        '93195001', '93196000', '93197009', '93198004', '93199007', '93200005', '93201009',
        '93202002', '93203007', '93204001', '93205000', '93206004', '93207008', '93208003',
        '93450001', '93451002', '93487009', '93488004', '93489007', '93492006', '93493001',
        '93494007', '93495008', '93496009', '93497000', '93498005', '93500006', '93501005',
        '93505001', '93506000', '93507009', '93509007', '93510002', '93514006', '93515007',
        '93516008', '93518009', '93519001', '93520007', '93521006', '93522004', '93523009',
        '93524003', '93525002', '93526001', '93527005', '93528000', '93530003', '93531004',
        '93532006', '93533001', '93534007', '93536009', '93537000', '93541001', '93542008',
        '93543003', '93545005', '93546006', '93547002', '93548007', '93549004', '93550004',
        '93551000', '93552007', '93554008', '93555009', '94071006', '94148006', '94686001',
        '94687005', '94688000', '94690004', '94707004', '94708009', '94709001', '94710006',
        '94711005', '94712003', '94714002', '94715001', '94716000', '94718004', '94719007',
        '95186006', '95187002', '95188007', '95192000', '95193005', '95194004', '95209008',
        '95210003', '95224004', '95225003', '95226002', '95230004', '95231000', '95260009',
        '95261008', '95263006', '95264000'
    }


class CarotidIntervention(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent carotid intervention surgical procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with representing carotid intervention surgical procedures.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.204'
    VALUE_SET_NAME = 'Carotid Intervention'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '031H09G', '031H09J', '031H09K', '031H09Y', '031H0AG', '031H0AJ', '031H0AK', '031H0AY',
        '031H0JG', '031H0JJ', '031H0JK', '031H0JY', '031H0KG', '031H0KJ', '031H0KK', '031H0KY',
        '031H0ZG', '031H0ZJ', '031H0ZK', '031H0ZY', '031J09G', '031J09J', '031J09K', '031J09Y',
        '031J0AG', '031J0AJ', '031J0AK', '031J0AY', '031J0JG', '031J0JJ', '031J0JK', '031J0JY',
        '031J0KG', '031J0KJ', '031J0KK', '031J0KY', '031J0ZG', '031J0ZJ', '031J0ZK', '031J0ZY',
        '031K09J', '031K09K', '031K0AJ', '031K0AK', '031K0JJ', '031K0JK', '031K0KJ', '031K0KK',
        '031K0ZJ', '031K0ZK', '031L09J', '031L09K', '031L0AJ', '031L0AK', '031L0JJ', '031L0JK',
        '031L0KJ', '031L0KK', '031L0ZJ', '031L0ZK', '031M09J', '031M09K', '031M0AJ', '031M0AK',
        '031M0JJ', '031M0JK', '031M0KJ', '031M0KK', '031M0ZJ', '031M0ZK', '031N09J', '031N09K',
        '031N0AJ', '031N0AK', '031N0JJ', '031N0JK', '031N0KJ', '031N0KK', '031N0ZJ', '031N0ZK',
        '035H0ZZ', '035H3ZZ', '035H4ZZ', '035J0ZZ', '035J3ZZ', '035J4ZZ', '035K0ZZ', '035K3ZZ',
        '035K4ZZ', '035L0ZZ', '035L3ZZ', '035L4ZZ', '035M0ZZ', '035M3ZZ', '035M4ZZ', '035N0ZZ',
        '035N3ZZ', '035N4ZZ', '037H046', '037H04Z', '037H056', '037H05Z', '037H066', '037H06Z',
        '037H076', '037H07Z', '037H0D6', '037H0DZ', '037H0E6', '037H0EZ', '037H0F6', '037H0FZ',
        '037H0G6', '037H0GZ', '037H0Z6', '037H0ZZ', '037H346', '037H34Z', '037H356', '037H35Z',
        '037H366', '037H36Z', '037H376', '037H37Z', '037H3D6', '037H3DZ', '037H3E6', '037H3EZ',
        '037H3F6', '037H3FZ', '037H3G6', '037H3GZ', '037H3Z6', '037H3ZZ', '037H446', '037H44Z',
        '037H456', '037H45Z', '037H466', '037H46Z', '037H476', '037H47Z', '037H4D6', '037H4DZ',
        '037H4E6', '037H4EZ', '037H4F6', '037H4FZ', '037H4G6', '037H4GZ', '037H4Z6', '037H4ZZ',
        '037J046', '037J04Z', '037J056', '037J05Z', '037J066', '037J06Z', '037J076', '037J07Z',
        '037J0D6', '037J0DZ', '037J0E6', '037J0EZ', '037J0F6', '037J0FZ', '037J0G6', '037J0GZ',
        '037J0Z6', '037J0ZZ', '037J346', '037J34Z', '037J356', '037J35Z', '037J366', '037J36Z',
        '037J376', '037J37Z', '037J3D6', '037J3DZ', '037J3E6', '037J3EZ', '037J3F6', '037J3FZ',
        '037J3G6', '037J3GZ', '037J3Z6', '037J3ZZ', '037J446', '037J44Z', '037J456', '037J45Z',
        '037J466', '037J46Z', '037J476', '037J47Z', '037J4D6', '037J4DZ', '037J4E6', '037J4EZ',
        '037J4F6', '037J4FZ', '037J4G6', '037J4GZ', '037J4Z6', '037J4ZZ', '037K046', '037K04Z',
        '037K056', '037K05Z', '037K066', '037K06Z', '037K076', '037K07Z', '037K0D6', '037K0DZ',
        '037K0E6', '037K0EZ', '037K0F6', '037K0FZ', '037K0G6', '037K0GZ', '037K0Z6', '037K0ZZ',
        '037K346', '037K34Z', '037K356', '037K35Z', '037K366', '037K36Z', '037K376', '037K37Z',
        '037K3D6', '037K3DZ', '037K3E6', '037K3EZ', '037K3F6', '037K3FZ', '037K3G6', '037K3GZ',
        '037K3Z6', '037K3ZZ', '037K446', '037K44Z', '037K456', '037K45Z', '037K466', '037K46Z',
        '037K476', '037K47Z', '037K4D6', '037K4DZ', '037K4E6', '037K4EZ', '037K4F6', '037K4FZ',
        '037K4G6', '037K4GZ', '037K4Z6', '037K4ZZ', '037L046', '037L04Z', '037L056', '037L05Z',
        '037L066', '037L06Z', '037L076', '037L07Z', '037L0D6', '037L0DZ', '037L0E6', '037L0EZ',
        '037L0F6', '037L0FZ', '037L0G6', '037L0GZ', '037L0Z6', '037L0ZZ', '037L346', '037L34Z',
        '037L356', '037L35Z', '037L366', '037L36Z', '037L376', '037L37Z', '037L3D6', '037L3DZ',
        '037L3E6', '037L3EZ', '037L3F6', '037L3FZ', '037L3G6', '037L3GZ', '037L3Z6', '037L3ZZ',
        '037L446', '037L44Z', '037L456', '037L45Z', '037L466', '037L46Z', '037L476', '037L47Z',
        '037L4D6', '037L4DZ', '037L4E6', '037L4EZ', '037L4F6', '037L4FZ', '037L4G6', '037L4GZ',
        '037L4Z6', '037L4ZZ', '037M046', '037M04Z', '037M056', '037M05Z', '037M066', '037M06Z',
        '037M076', '037M07Z', '037M0D6', '037M0DZ', '037M0E6', '037M0EZ', '037M0F6', '037M0FZ',
        '037M0G6', '037M0GZ', '037M0Z6', '037M0ZZ', '037M346', '037M34Z', '037M356', '037M35Z',
        '037M366', '037M36Z', '037M376', '037M37Z', '037M3D6', '037M3DZ', '037M3E6', '037M3EZ',
        '037M3F6', '037M3FZ', '037M3G6', '037M3GZ', '037M3Z6', '037M3ZZ', '037M446', '037M44Z',
        '037M456', '037M45Z', '037M466', '037M46Z', '037M476', '037M47Z', '037M4D6', '037M4DZ',
        '037M4E6', '037M4EZ', '037M4F6', '037M4FZ', '037M4G6', '037M4GZ', '037M4Z6', '037M4ZZ',
        '037N046', '037N04Z', '037N056', '037N05Z', '037N066', '037N06Z', '037N076', '037N07Z',
        '037N0D6', '037N0DZ', '037N0E6', '037N0EZ', '037N0F6', '037N0FZ', '037N0G6', '037N0GZ',
        '037N0Z6', '037N0ZZ', '037N346', '037N34Z', '037N356', '037N35Z', '037N366', '037N36Z',
        '037N376', '037N37Z', '037N3D6', '037N3DZ', '037N3E6', '037N3EZ', '037N3F6', '037N3FZ',
        '037N3G6', '037N3GZ', '037N3Z6', '037N3ZZ', '037N446', '037N44Z', '037N456', '037N45Z',
        '037N466', '037N46Z', '037N476', '037N47Z', '037N4D6', '037N4DZ', '037N4E6', '037N4EZ',
        '037N4F6', '037N4FZ', '037N4G6', '037N4GZ', '037N4Z6', '037N4ZZ', '039H00Z', '039H0ZX',
        '039H0ZZ', '039H30Z', '039H3ZX', '039H3ZZ', '039H40Z', '039H4ZX', '039H4ZZ', '039J00Z',
        '039J0ZX', '039J0ZZ', '039J30Z', '039J3ZX', '039J3ZZ', '039J40Z', '039J4ZX', '039J4ZZ',
        '039K00Z', '039K0ZX', '039K0ZZ', '039K30Z', '039K3ZX', '039K3ZZ', '039K40Z', '039K4ZX',
        '039K4ZZ', '039L00Z', '039L0ZX', '039L0ZZ', '039L30Z', '039L3ZX', '039L3ZZ', '039L40Z',
        '039L4ZX', '039L4ZZ', '039M00Z', '039M0ZX', '039M0ZZ', '039M30Z', '039M3ZX', '039M3ZZ',
        '039M40Z', '039M4ZX', '039M4ZZ', '039N00Z', '039N0ZX', '039N0ZZ', '039N30Z', '039N3ZX',
        '039N3ZZ', '039N40Z', '039N4ZX', '039N4ZZ', '03BH0ZX', '03BH0ZZ', '03BH3ZX', '03BH3ZZ',
        '03BH4ZX', '03BH4ZZ', '03BJ0ZX', '03BJ0ZZ', '03BJ3ZX', '03BJ3ZZ', '03BJ4ZX', '03BJ4ZZ',
        '03BK0ZX', '03BK0ZZ', '03BK3ZX', '03BK3ZZ', '03BK4ZX', '03BK4ZZ', '03BL0ZX', '03BL0ZZ',
        '03BL3ZX', '03BL3ZZ', '03BL4ZX', '03BL4ZZ', '03BM0ZX', '03BM0ZZ', '03BM3ZX', '03BM3ZZ',
        '03BM4ZX', '03BM4ZZ', '03BN0ZX', '03BN0ZZ', '03BN3ZX', '03BN3ZZ', '03BN4ZX', '03BN4ZZ',
        '03CH0Z6', '03CH0ZZ', '03CH3Z6', '03CH3Z7', '03CH3ZZ', '03CH4Z6', '03CH4ZZ', '03CJ0Z6',
        '03CJ0ZZ', '03CJ3Z6', '03CJ3Z7', '03CJ3ZZ', '03CJ4Z6', '03CJ4ZZ', '03CK0Z6', '03CK0ZZ',
        '03CK3Z6', '03CK3Z7', '03CK3ZZ', '03CK4Z6', '03CK4ZZ', '03CL0Z6', '03CL0ZZ', '03CL3Z6',
        '03CL3Z7', '03CL3ZZ', '03CL4Z6', '03CL4ZZ', '03CM0Z6', '03CM0ZZ', '03CM3Z6', '03CM3Z7',
        '03CM3ZZ', '03CM4Z6', '03CM4ZZ', '03CN0Z6', '03CN0ZZ', '03CN3Z6', '03CN3Z7', '03CN3ZZ',
        '03CN4Z6', '03CN4ZZ', '03HH03Z', '03HH0DZ', '03HH33Z', '03HH3DZ', '03HH43Z', '03HH4DZ',
        '03HJ03Z', '03HJ0DZ', '03HJ33Z', '03HJ3DZ', '03HJ43Z', '03HJ4DZ', '03HK03Z', '03HK0DZ',
        '03HK0MZ', '03HK33Z', '03HK3DZ', '03HK3MZ', '03HK43Z', '03HK4DZ', '03HK4MZ', '03HL03Z',
        '03HL0DZ', '03HL0MZ', '03HL33Z', '03HL3DZ', '03HL3MZ', '03HL43Z', '03HL4DZ', '03HL4MZ',
        '03HM03Z', '03HM0DZ', '03HM33Z', '03HM3DZ', '03HM43Z', '03HM4DZ', '03HN03Z', '03HN0DZ',
        '03HN33Z', '03HN3DZ', '03HN43Z', '03HN4DZ', '03LH0BZ', '03LH0CZ', '03LH0DZ', '03LH0ZZ',
        '03LH3BZ', '03LH3CZ', '03LH3DZ', '03LH3ZZ', '03LH4BZ', '03LH4CZ', '03LH4DZ', '03LH4ZZ',
        '03LJ0BZ', '03LJ0CZ', '03LJ0DZ', '03LJ0ZZ', '03LJ3BZ', '03LJ3CZ', '03LJ3DZ', '03LJ3ZZ',
        '03LJ4BZ', '03LJ4CZ', '03LJ4DZ', '03LJ4ZZ', '03LK0BZ', '03LK0CZ', '03LK0DZ', '03LK0ZZ',
        '03LK3BZ', '03LK3CZ', '03LK3DZ', '03LK3ZZ', '03LK4BZ', '03LK4CZ', '03LK4DZ', '03LK4ZZ',
        '03LL0BZ', '03LL0CZ', '03LL0DZ', '03LL0ZZ', '03LL3BZ', '03LL3CZ', '03LL3DZ', '03LL3ZZ',
        '03LL4BZ', '03LL4CZ', '03LL4DZ', '03LL4ZZ', '03LM0BZ', '03LM0CZ', '03LM0DZ', '03LM0ZZ',
        '03LM3BZ', '03LM3CZ', '03LM3DZ', '03LM3ZZ', '03LM4BZ', '03LM4CZ', '03LM4DZ', '03LM4ZZ',
        '03LN0BZ', '03LN0CZ', '03LN0DZ', '03LN0ZZ', '03LN3BZ', '03LN3CZ', '03LN3DZ', '03LN3ZZ',
        '03LN4BZ', '03LN4CZ', '03LN4DZ', '03LN4ZZ', '03NH0ZZ', '03NH3ZZ', '03NH4ZZ', '03NJ0ZZ',
        '03NJ3ZZ', '03NJ4ZZ', '03NK0ZZ', '03NK3ZZ', '03NK4ZZ', '03NL0ZZ', '03NL3ZZ', '03NL4ZZ',
        '03NM0ZZ', '03NM3ZZ', '03NM4ZZ', '03NN0ZZ', '03NN3ZZ', '03NN4ZZ', '03QH0ZZ', '03QH3ZZ',
        '03QH4ZZ', '03QJ0ZZ', '03QJ3ZZ', '03QJ4ZZ', '03QK0ZZ', '03QK3ZZ', '03QK4ZZ', '03QL0ZZ',
        '03QL3ZZ', '03QL4ZZ', '03QM0ZZ', '03QM3ZZ', '03QM4ZZ', '03QN0ZZ', '03QN3ZZ', '03QN4ZZ',
        '03RH07Z', '03RH0JZ', '03RH0KZ', '03RH47Z', '03RH4JZ', '03RH4KZ', '03RJ07Z', '03RJ0JZ',
        '03RJ0KZ', '03RJ47Z', '03RJ4JZ', '03RJ4KZ', '03RK07Z', '03RK0JZ', '03RK0KZ', '03RK47Z',
        '03RK4JZ', '03RK4KZ', '03RL07Z', '03RL0JZ', '03RL0KZ', '03RL47Z', '03RL4JZ', '03RL4KZ',
        '03RM07Z', '03RM0JZ', '03RM0KZ', '03RM47Z', '03RM4JZ', '03RM4KZ', '03RN07Z', '03RN0JZ',
        '03RN0KZ', '03RN47Z', '03RN4JZ', '03RN4KZ', '03SH0ZZ', '03SH3ZZ', '03SH4ZZ', '03SJ0ZZ',
        '03SJ3ZZ', '03SJ4ZZ', '03SK0ZZ', '03SK3ZZ', '03SK4ZZ', '03SL0ZZ', '03SL3ZZ', '03SL4ZZ',
        '03SM0ZZ', '03SM3ZZ', '03SM4ZZ', '03SN0ZZ', '03SN3ZZ', '03SN4ZZ', '03UH07Z', '03UH0JZ',
        '03UH0KZ', '03UH37Z', '03UH3JZ', '03UH3KZ', '03UH47Z', '03UH4JZ', '03UH4KZ', '03UJ07Z',
        '03UJ0JZ', '03UJ0KZ', '03UJ37Z', '03UJ3JZ', '03UJ3KZ', '03UJ47Z', '03UJ4JZ', '03UJ4KZ',
        '03UK07Z', '03UK0JZ', '03UK0KZ', '03UK37Z', '03UK3JZ', '03UK3KZ', '03UK47Z', '03UK4JZ',
        '03UK4KZ', '03UL07Z', '03UL0JZ', '03UL0KZ', '03UL37Z', '03UL3JZ', '03UL3KZ', '03UL47Z',
        '03UL4JZ', '03UL4KZ', '03UM07Z', '03UM0JZ', '03UM0KZ', '03UM37Z', '03UM3JZ', '03UM3KZ',
        '03UM47Z', '03UM4JZ', '03UM4KZ', '03UN07Z', '03UN0JZ', '03UN0KZ', '03UN37Z', '03UN3JZ',
        '03UN3KZ', '03UN47Z', '03UN4JZ', '03UN4KZ', '03VH0BZ', '03VH0CZ', '03VH0DZ', '03VH0ZZ',
        '03VH3BZ', '03VH3CZ', '03VH3DZ', '03VH3ZZ', '03VH4BZ', '03VH4CZ', '03VH4DZ', '03VH4ZZ',
        '03VJ0BZ', '03VJ0CZ', '03VJ0DZ', '03VJ0ZZ', '03VJ3BZ', '03VJ3CZ', '03VJ3DZ', '03VJ3ZZ',
        '03VJ4BZ', '03VJ4CZ', '03VJ4DZ', '03VJ4ZZ', '03VK0BZ', '03VK0CZ', '03VK0DZ', '03VK0ZZ',
        '03VK3BZ', '03VK3CZ', '03VK3DZ', '03VK3ZZ', '03VK4BZ', '03VK4CZ', '03VK4DZ', '03VK4ZZ',
        '03VL0BZ', '03VL0CZ', '03VL0DZ', '03VL0ZZ', '03VL3BZ', '03VL3CZ', '03VL3DZ', '03VL3ZZ',
        '03VL4BZ', '03VL4CZ', '03VL4DZ', '03VL4ZZ', '03VM0BZ', '03VM0CZ', '03VM0DZ', '03VM0ZZ',
        '03VM3BZ', '03VM3CZ', '03VM3DZ', '03VM3ZZ', '03VM4BZ', '03VM4CZ', '03VM4DZ', '03VM4ZZ',
        '03VN0BZ', '03VN0CZ', '03VN0DZ', '03VN0ZZ', '03VN3BZ', '03VN3CZ', '03VN3DZ', '03VN3ZZ',
        '03VN4BZ', '03VN4CZ', '03VN4DZ', '03VN4ZZ', '0G560ZZ', '0G563ZZ', '0G564ZZ', '0G570ZZ',
        '0G573ZZ', '0G574ZZ', '0G580ZZ', '0G583ZZ', '0G584ZZ', '0G9600Z', '0G960ZX', '0G960ZZ',
        '0G9630Z', '0G963ZX', '0G963ZZ', '0G9640Z', '0G964ZX', '0G964ZZ', '0G9700Z', '0G970ZX',
        '0G970ZZ', '0G9730Z', '0G973ZX', '0G973ZZ', '0G9740Z', '0G974ZX', '0G974ZZ', '0G9800Z',
        '0G980ZX', '0G980ZZ', '0G9830Z', '0G983ZX', '0G983ZZ', '0G9840Z', '0G984ZX', '0G984ZZ',
        '0GB60ZX', '0GB60ZZ', '0GB63ZX', '0GB63ZZ', '0GB64ZX', '0GB64ZZ', '0GB70ZX', '0GB70ZZ',
        '0GB73ZX', '0GB73ZZ', '0GB74ZX', '0GB74ZZ', '0GB80ZX', '0GB80ZZ', '0GB83ZX', '0GB83ZZ',
        '0GB84ZX', '0GB84ZZ', '0GC60ZZ', '0GC63ZZ', '0GC64ZZ', '0GC70ZZ', '0GC73ZZ', '0GC74ZZ',
        '0GC80ZZ', '0GC83ZZ', '0GC84ZZ', '0GN60ZZ', '0GN63ZZ', '0GN64ZZ', '0GN70ZZ', '0GN73ZZ',
        '0GN74ZZ', '0GN80ZZ', '0GN83ZZ', '0GN84ZZ', '0GQ60ZZ', '0GQ63ZZ', '0GQ64ZZ', '0GQ70ZZ',
        '0GQ73ZZ', '0GQ74ZZ', '0GQ80ZZ', '0GQ83ZZ', '0GQ84ZZ', '0GT60ZZ', '0GT64ZZ', '0GT70ZZ',
        '0GT74ZZ', '0GT80ZZ', '0GT84ZZ', 'B3060ZZ', 'B3061ZZ', 'B306YZZ', 'B3070ZZ', 'B3071ZZ',
        'B307YZZ', 'B3080ZZ', 'B3081ZZ', 'B308YZZ', 'B3160ZZ', 'B3161ZZ', 'B316YZZ', 'B3170ZZ',
        'B3171ZZ', 'B317YZZ', 'B3180ZZ', 'B3181ZZ', 'B318YZZ'
    }

    ICD9CM = {
        '0061', '0062', '0063', '0064', '0065', '3802', '3812', '3822', '3830', '3831', '3832',
        '3842', '3922', '3928', '8841'
    }

    SNOMEDCT = {
        '112823003', '15023006', '175363002', '175364008', '175365009', '175367001', '175373000',
        '175374006', '175376008', '175379001', '175380003', '175398004', '18674003', '22928005',
        '233259003', '233260008', '233296007', '233297003', '233298008', '233405004', '241219006',
        '276949008', '276950008', '276951007', '287606009', '302053004', '303161001', '31573003',
        '34214004', '39887009', '405326004', '405379009', '405407008', '405408003', '405409006',
        '405411002', '405412009', '405415006', '417884003', '418405008', '418838006', '419014003',
        '420026003', '420046008', '420171008', '425611003', '427486009', '428802000', '429287007',
        '431515004', '431519005', '431535003', '431659001', '432039002', '432785007', '433056003',
        '433061001', '433591001', '433683001', '433690006', '433711000', '433734009', '434159001',
        '434378006', '434433007', '43628009', '438615003', '440221006', '440453000', '440518005',
        '449242004', '46912008', '51382002', '53412000', '59012002', '59109003', '66951008',
        '74720005', '79507006', '80102005', '80104006', '87314005', '90931006', '9339002'
    }


class Hypercholesterolemia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis, past or present, of hypercholesterolemia.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attributes related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnoses of hypercholesterolemia.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1047.100'
    VALUE_SET_NAME = 'Hypercholesterolemia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'E7800', 'E7801'}

    ICD9CM = {'2720'}

    SNOMEDCT = {
        '13644009', '238076009', '238077000', '238078005', '238079002', '238082007', '267432004',
        '398036000', '398796005', '403829002', '403830007', '403831006', '414416008'
    }


class CataractPosteriorPolar(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of posterior polar cataract.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of posterior polar cataract, including capsular or subcapsular cataract.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1414'
    VALUE_SET_NAME = 'Cataract, Posterior Polar'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H25041', 'H25042', 'H25043'}

    ICD9CM = {'74331'}

    SNOMEDCT = {
        '15639401000119105', '15639441000119107', '15639481000119102', '15737881000119104',
        '15737921000119106', '15737961000119101', '253225009', '315353005', '342821000119103',
        '34533008', '5318001'
    }


class BipolarDisorder(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses related to bipolar disorder.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with all relevant diagnoses associated with bipolar disorder. This is a grouping of SNOMED CT, ICD-9-CM, and ICD-10-CM codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.67.1.101.1.128'
    VALUE_SET_NAME = 'Bipolar Disorder'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'F3010', 'F3011', 'F3012', 'F3013', 'F302', 'F303', 'F304', 'F308', 'F309', 'F310',
        'F3110', 'F3111', 'F3112', 'F3113', 'F312', 'F3130', 'F3131', 'F3132', 'F314', 'F315',
        'F3160', 'F3161', 'F3162', 'F3163', 'F3164', 'F3170', 'F3171', 'F3172', 'F3173', 'F3174',
        'F3175', 'F3176', 'F3177', 'F3178', 'F3181', 'F3189', 'F319'
    }

    ICD9CM = {
        '29600', '29601', '29602', '29603', '29604', '29605', '29606', '29610', '29611', '29612',
        '29613', '29614', '29615', '29616', '29640', '29641', '29642', '29643', '29644', '29645',
        '29646', '29650', '29651', '29652', '29653', '29654', '29655', '29656', '29660', '29661',
        '29662', '29663', '29664', '29665', '29666', '2967', '29680', '29681', '29682', '29689'
    }

    SNOMEDCT = {
        '10875004', '10981006', '111485001', '1196001', '12969000', '133091000119105', '13313007',
        '13581000', '13746004', '14495005', '1499003', '162004', '16295005', '16506000',
        '17782008', '191618007', '191620005', '191621009', '191623007', '191625000', '191627008',
        '191629006', '191630001', '191632009', '191634005', '191636007', '191638008', '191639000',
        '191641004', '191643001', '192362008', '19300006', '20960007', '21900002', '22121000',
        '22407005', '261000119107', '26203008', '26530004', '28663008', '28884001', '29929003',
        '30520009', '30687003', '30935000', '31446002', '33380008', '34315001', '3530005',
        '35481005', '35722002', '35846004', '36583000', '371596008', '371599001', '371600003',
        '371604007', '40926005', '41552001', '41832009', '41836007', '43568002', '43769008',
        '4441000', '45479006', '46229002', '48937005', '49468007', '49512000', '51637008',
        '53049002', '53607008', '54761006', '55516002', '5703000', '59617007', '61403008',
        '63249007', '64731001', '65042007', '66631006', '67002003', '68569003', '70546001',
        '71294008', '71984005', '723903001', '723905008', '73471000', '74686005', '75360000',
        '75752004', '765176007', '767631007', '767635003', '767636002', '78269000', '78640000',
        '79584002', '81319007', '82998009', '83225003', '85248005', '86058007', '87203005',
        '87950005', '9340000'
    }


class Hiv1(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of human immunodeficiency virus (HIV
    AIDS).
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with that identify patients with a diagnosis of HIV, type; HIV; or AIDS. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes codes for HIV, type 2.
    """

    OID = '2.16.840.1.113883.3.464.1003.120.12.1004'
    VALUE_SET_NAME = 'HIV 1'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'B20', 'Z21'}

    ICD9CM = {'042', 'V08'}

    SNOMEDCT = {
        '10746341000119109', '111880001', '165816005', '186706006', '186707002', '186708007',
        '186709004', '186717007', '186718002', '186719005', '186721000', '186723002', '186725009',
        '186726005', '230180003', '230201009', '230202002', '230598008', '235009000', '235726002',
        '236406007', '240103002', '276665006', '276666007', '315019000', '359791000', '397763006',
        '398329009', '402901009', '402915006', '402916007', '405631006', '406109008', '40780007',
        '414604009', '416729007', '420244003', '420281004', '420302007', '420308006', '420321004',
        '420384005', '420395004', '420403001', '420452002', '420524008', '420543008', '420544002',
        '420549007', '420554003', '420614009', '420658009', '420687005', '420691000', '420718004',
        '420721002', '420764009', '420774007', '420787001', '420801006', '420818005', '420877009',
        '420900006', '420938005', '420945005', '421020000', '421023003', '421047005', '421077004',
        '421102007', '421230000', '421272004', '421283008', '421312009', '421315006', '421394009',
        '421403008', '421415007', '421431004', '421454008', '421460008', '421508002', '421510000',
        '421529006', '421571007', '421597001', '421660003', '421666009', '421671002', '421695000',
        '421706001', '421708000', '421710003', '421766003', '421827003', '421851008', '421874007',
        '421883002', '421929001', '421983003', '421998001', '422003001', '422012004', '422074008',
        '422089004', '422127002', '422136003', '422177004', '422189002', '422194002', '422282000',
        '422337001', '432218001', '442537007', '442662004', '445945000', '48794007', '52079000',
        '5810003', '62246005', '62479008', '697904001', '697965002', '699433000', '700053002',
        '713260006', '713275003', '713278001', '713297001', '713298006', '713299003', '713300006',
        '713316008', '713318009', '713320007', '713325002', '713339002', '713340000', '713341001',
        '713342008', '713349004', '713444005', '713445006', '713446007', '713483007', '713484001',
        '713487008', '713488003', '713489006', '713490002', '713491003', '713497004', '713503007',
        '713504001', '713505000', '713506004', '713507008', '713508003', '713510001', '713511002',
        '713523008', '713526000', '713527009', '713530002', '713531003', '713532005', '713533000',
        '713543002', '713544008', '713545009', '713546005', '713570009', '713571008', '713572001',
        '713695001', '713696000', '713718006', '713722001', '713729005', '713730000', '713731001',
        '713732008', '713733003', '713734009', '713742005', '713844000', '713845004', '713880000',
        '713881001', '713887002', '713897006', '713964006', '713967004', '714083007', '714464009',
        '719522009', '721166000', '722557007', '733834006', '733835007', '735521001', '735522008',
        '735523003', '735524009', '735525005', '735526006', '735527002', '735528007',
        '76981000119106', '76991000119109', '77070006', '80191000119101', '81000119104',
        '86406008', '87117006', '90681000119107', '90691000119105', '91923005', '91947003',
        '91948008'
    }


class AspirinButalbitalCaffeine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent aspirin / butalbital / caffeine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; aspirin / butalbital / caffeine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; aspirin / butalbital / caffeine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1347'
    VALUE_SET_NAME = 'Aspirin / Butalbital / Caffeine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'238134', '238135'}


class Nortriptyline(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent nortriptyline medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; nortriptyline only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; nortriptyline in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1507'
    VALUE_SET_NAME = 'Nortriptyline'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'198045', '198046', '198047', '312036', '317136'}


class PreventiveCareEstablishedOfficeVisit0To17(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have had an office or other outpatient visit for preventive care.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity. This is an extensional value set of CPT codes.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1120'
    VALUE_SET_NAME = 'Preventive Care - Established Office Visit, 0 to 17'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99391', '99392', '99393', '99394'}


class AboveNormalMedications(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent clinical medications prescribed for weight loss to patients with an above normal BMI measurement.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with oral drug forms prescribed for weight loss in patients with an above normal BMI measurement.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1498'
    VALUE_SET_NAME = 'Above Normal Medications'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1112982', '1112987', '1249083', '1300706', '1302827', '1302839', '1302850', '1313059',
        '1808549', '314153', '692876', '803348', '803353', '826131', '826919', '900038', '968766',
        '978654', '978668'
    }


class CognitiveAssessment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent assessments performed for the evaluation of cognition.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with general concepts for assessments used to evaluate cognition.
    Exclusion Criteria: Excludes standardized tools used to evaluate cognition.
    """

    OID = '2.16.840.1.113883.3.526.3.1332'
    VALUE_SET_NAME = 'Cognitive Assessment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'113024001', '4719001'}


class HepatitisB_269(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acute or chronic hepatitis B infection.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Diagnosis, Active. The intent of this data element is identify patients with acute or chronic hepatitis B infection.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients with acute or chronic hepatitis B infection.
    Exclusion Criteria: Excludes patients with evidence of current or past acute or chronic hepatitis B infection.
    """

    OID = '2.16.840.1.113883.3.67.1.101.1.269'
    VALUE_SET_NAME = 'Hepatitis B'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'B160', 'B161', 'B162', 'B169', 'B180', 'B181', 'B1910', 'B1911'}

    SNOMEDCT = {
        '1116000', '111891008', '13265006', '186624004', '186626002', '186639003', '235864009',
        '235865005', '235869004', '235871004', '26206000', '38662009', '424099008', '424340000',
        '442134007', '442374005', '446698005', '50167007', '53425008', '60498001', '61977001',
        '66071002', '76795007'
    }


class AnkylosingSpondylitis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of ankylosing spondylitis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with ankylosing spondylitis with comorbidities and associated system involvement. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes all diagnosis codes associated with juvenile ankylosing spondylitis.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1045'
    VALUE_SET_NAME = 'Ankylosing Spondylitis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'M450', 'M451', 'M452', 'M453', 'M454', 'M455', 'M456', 'M457', 'M458', 'M459'}

    ICD9CM = {'7200'}

    SNOMEDCT = {'129564003', '162930007', '239810002', '239811003', '9631008'}


class BrompheniramineDextromethorphanPseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent brompheniramine / dextromethorphan / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; brompheniramine / dextromethorphan / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; brompheniramine / dextromethorphan / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1339'
    VALUE_SET_NAME = 'Brompheniramine / Dextromethorphan / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1098497', '1356812', '1356838', '1357010'}


class PneumococcalVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent conjugate and polysaccharide pneumococcal vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable. Includes only relevant concepts associated with the pneumococcal conjugate 13-valent and the pneumococcal polysaccharide 23-valent vaccine. This is a grouping of CVX codes.
    Exclusion Criteria: Excludes codes that represent the pneumococcal conjugate 7-valent vaccine.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1027'
    VALUE_SET_NAME = 'Pneumococcal Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'109', '133', '152', '33'}


class SevereDementia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of severe dementia.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of severe dementia.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1025'
    VALUE_SET_NAME = 'Severe Dementia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'428351000124105'}


class AcutePharyngitis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses of bacterial or viral acute pharyngitis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of either bacterial and viral acute pharyngitis. This is a value set grouping that includes ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1011'
    VALUE_SET_NAME = 'Acute Pharyngitis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'J020', 'J028', 'J029'}

    SNOMEDCT = {
        '1532007', '195655000', '195656004', '195657008', '195658003', '195659006', '195660001',
        '195662009', '232399005', '232400003', '363746003', '40766000', '43878008', '58031004'
    }


class ChlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorpheniramine / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorpheniramine / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorpheniramine / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1315'
    VALUE_SET_NAME = 'Chlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1053624', '1090699', '1363780', '998254'}


class DexbrompheniramineMaleatePseudoephedrineHydrochloride(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dexbrompheniramine maleate / pseudoephedrine hydrochloride combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dexbrompheniramine maleate / pseudoephedrine hydrochloride (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dexbrompheniramine maleate / pseudoephedrine hydrochloride in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1429'
    VALUE_SET_NAME = 'Dexbrompheniramine Maleate / Pseudoephedrine Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1363513'}


class ModerationOfEtohConsumptionRecommendation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the type of interventions relevant to alcohol use.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure or Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with indicating the type of education provided, referral to community service or rehabilitation center for alcohol use.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.823'
    VALUE_SET_NAME = 'Moderation of ETOH Consumption Recommendation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '24165007', '38670004', '390857005', '408947007', '413473000', '417096006', '431260004'
    }


class HighRiskMedicationsWithDaysSupplyCriteria(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent high risk medications at any dose with greater than a 90-day supply for the elderly.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human only; prescribable; high risk drugs at any dose with greater than a 90-day supply for the elderly.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1254'
    VALUE_SET_NAME = 'High-Risk Medications With Days Supply Criteria'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1232194', '1232202', '1648755', '1648759', '311989', '311991', '311994', '311995',
        '313761', '313762', '485440', '485442', '485465', '828692', '836641', '836647', '854873',
        '854876', '854880', '854894'
    }


class Proteinuria(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of proteinuria.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of proteinuria.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1003'
    VALUE_SET_NAME = 'Proteinuria'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'R801', 'R808', 'R809'}

    ICD9CM = {'7910'}

    SNOMEDCT = {
        '12178007', '167582007', '263808002', '264867001', '274769005', '29738008', '312975006',
        '34993002'
    }


class UpperRespiratoryInfection(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have been diagnosed with an acute upper respiratory infection.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of acute upper respiratory infections. This is a value set grouping the contains ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1022'
    VALUE_SET_NAME = 'Upper Respiratory Infection'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'J00', 'J060', 'J069'}

    SNOMEDCT = {'43692000', '54398005', '78337007', '82272006'}


class FlexibleSigmoidoscopy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a flexible sigmoidoscopy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying a flexible sigmoidoscopy. This is a grouping of CPT, HCPCS and SNOMED CT codes.
    Exclusion Criteria: Excludes codes that indicate that this test was ordered only, and not necessarily performed.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1010'
    VALUE_SET_NAME = 'Flexible Sigmoidoscopy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '45330', '45331', '45332', '45333', '45334', '45335', '45337', '45338', '45339', '45340',
        '45341', '45342', '45345', '45346', '45347', '45349', '45350'
    }

    HCPCS = {'G0104'}

    SNOMEDCT = {'396226005', '425634007', '44441009', '841000119107'}


class UnfractionatedHeparin(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent heparin formulations that could reasonably be used to treat venous thromboembolism as a continuous infusion.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who receive unfractionated heparin as an intravenous infusion.
    Inclusion Criteria: Includes only relevant concepts associated with injectable products that could reasonably be used for continuous infusion of heparin and achieve therapeutic levels.
    Exclusion Criteria: Excludes concentrations < 250 UNT/ML (except those representing premixed heparin infusion bags, per inclusion criteria).
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.218'
    VALUE_SET_NAME = 'Unfractionated Heparin'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1361607', '1658717', '1658720', '1659195', '1659197'}


class PsychVisitDiagnosticEvaluation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent visits during which a psychiatric diagnostic evaluation is completed.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with visits with the completion of psychiatric diagnostic evaluations.
    Exclusion Criteria: Excludes group psychotherapy or family psychotherapy.
    """

    OID = '2.16.840.1.113883.3.526.3.1492'
    VALUE_SET_NAME = 'Psych Visit - Diagnostic Evaluation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90791', '90792'}

    SNOMEDCT = {'10197000', '165172002', '32537008', '68338001', '79094001'}


class Colonoscopy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent colonoscopy procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts that identify patients who have had a screening or diagnostic colonoscopy. This is a grouping of CPT, HCPCS, and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1020'
    VALUE_SET_NAME = 'Colonoscopy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '44388', '44389', '44390', '44391', '44392', '44393', '44394', '44397', '44401', '44402',
        '44403', '44404', '44405', '44406', '44407', '44408', '45355', '45378', '45379', '45380',
        '45381', '45382', '45383', '45384', '45385', '45386', '45387', '45388', '45389', '45390',
        '45391', '45392', '45393', '45398'
    }

    HCPCS = {'G0105', 'G0121'}

    SNOMEDCT = {
        '12350003', '174158000', '235150006', '235151005', '25732003', '310634005', '34264006',
        '367535003', '425672002', '425937002', '427459009', '443998000', '444783004', '446521004',
        '446745002', '447021001', '709421007', '710293001', '711307001', '713154003', '73761001',
        '8180007', '851000119109'
    }


class IntoleranceToBetaBlockerTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of intolerance to beta blocker therapy.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of intolerance to beta blocker therapy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1178'
    VALUE_SET_NAME = 'Intolerance to Beta Blocker Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '292419005', '292420004', '292421000', '292424008', '292425009', '292426005', '292427001',
        '292428006', '292429003', '292430008', '292431007', '292432000', '292433005', '292434004',
        '292435003', '292436002', '292437006', '292438001', '292439009', '292440006', '292441005',
        '292442003', '418370000'
    }


class AllergyToInfluenzaVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of an allergy to influenza vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of allergy to influenza vaccines.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1256'
    VALUE_SET_NAME = 'Allergy to Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'294647003', '294648008', '294649000'}


class DischargeServicesNursingFacility(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have been discharged from a nursing facility.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with discharge from a nursing facility, including a final examination, instructions for continuing care and preparation of discharge records, prescriptions, and referral forms. Discharge services encounters can be less than or over 30 minutes. This is a grouping of CPT codes.
    Exclusion Criteria: Excludes discharges from settings other than a nursing facility.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1065'
    VALUE_SET_NAME = 'Discharge Services - Nursing Facility'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99315', '99316'}


class HighRiskMedicationsForTheElderly(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent high risk medications at any dose and for any duration for the elderly.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human only; prescribable; medications considered high risk for the elderly.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1253'
    VALUE_SET_NAME = 'High Risk Medications for the Elderly'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1000351', '1000352', '1000355', '1000356', '1012904', '1013619', '1020477', '1038876',
        '1041814', '1042684', '1042688', '1043400', '1046751', '1046770', '1046781', '1046799',
        '1046815', '1046982', '1046985', '1047786', '1047881', '1047895', '1047905', '1047916',
        '1048147', '1048307', '1048336', '1049289', '1049630', '1049633', '1049900', '1049904',
        '1049906', '1049909', '1050325', '1052462', '1052467', '1052679', '1052928', '1053624',
        '1085945', '1086463', '1086750', '1086991', '1087365', '1087459', '1087607', '1088934',
        '1088936', '1089968', '1090443', '1090463', '1090699', '1092189', '1092373', '1093098',
        '1094549', '1098496', '1098497', '1098498', '1099288', '1099292', '1099296', '1099300',
        '1099304', '1099308', '1099316', '1099446', '1099668', '1099872', '1099948', '1101555',
        '1111440', '1112220', '1113397', '1113522', '1114361', '1117245', '1117392', '1147619',
        '1147795', '1148155', '1149632', '1190568', '1190572', '1190600', '1190738', '1190748',
        '1190931', '1192477', '1193293', '1233546', '1233575', '1234386', '1234941', '1244523',
        '1244951', '1245291', '1245706', '1248354', '1248750', '1249617', '1251614', '1251621',
        '1251802', '1251811', '1293239', '1293344', '1293487', '1294201', '1297288', '1297390',
        '1297404', '1297947', '1298433', '1298799', '1298834', '1299143', '1299646', '1299662',
        '1300164', '1300195', '1303797', '1304105', '1313969', '1356797', '1356807', '1356812',
        '1356815', '1356838', '1356841', '1357010', '1357553', '1359123', '1359124', '1359126',
        '1359127', '1363288', '1363309', '1363513', '1363780', '1366653', '1366825', '1367227',
        '1368963', '1369403', '1369424', '1369971', '1369972', '1370125', '1370963', '1372265',
        '1372312', '1421985', '1423702', '1423711', '1424872', '1428880', '1428927', '1429345',
        '1430122', '1431286', '1440869', '1483549', '1483550', '1483552', '1483553', '1486964',
        '1490727', '1491529', '1491649', '1492052', '1492380', '1535923', '1536862', '1536931',
        '1536999', '1537767', '1537803', '1537807', '1537811', '1546700', '1546881', '1551286',
        '1598634', '1659960', '1661319', '1664543', '1665697', '1666116', '1723740', '1723776',
        '1724446', '1730190', '1738483', '1738495', '1738503', '1738511', '1738515', '1738519',
        '1738523', '1738527', '1738803', '1738805', '1738807', '1797855', '1804449', '1807886',
        '1812101', '1946979', '197363', '197364', '197365', '197366', '197426', '197446', '197495',
        '197496', '197502', '197622', '197657', '197658', '197659', '197660', '197661', '197662',
        '197666', '197667', '197668', '197669', '197670', '197737', '197745', '197746', '197817',
        '197818', '197928', '197929', '197935', '197943', '197944', '197956', '197958', '197960',
        '197963', '198032', '198033', '198045', '198046', '198047', '198083', '198085', '198086',
        '198089', '198165', '198277', '198278', '198368', '198602', '198603', '199164', '199167',
        '199168', '199407', '205333', '208545', '238003', '238004', '238006', '238134', '238135',
        '238153', '238154', '239981', '240826', '241527', '241946', '242333', '242891', '242892',
        '245385', '247069', '248478', '309249', '309914', '309952', '309955', '309958', '309960',
        '310197', '310204', '310206', '310212', '310213', '310215', '310534', '310536', '310537',
        '310539', '310991', '310992', '312036', '312242', '312357', '312362', '312370', '313385',
        '313386', '313387', '313389', '313391', '313393', '313396', '313496', '313498', '313499',
        '314000', '314267', '315234', '315235', '317136', '347151', '351254', '402250', '403849',
        '403922', '403923', '476540', '477045', '577027', '577029', '618368', '618370', '618376',
        '618378', '636568', '636793', '636794', '700851', '728581', '730794', '730878', '749850',
        '828299', '828320', '828348', '828353', '828358', '834022', '835564', '835568', '835572',
        '835577', '835589', '835591', '835593', '856706', '856720', '856762', '856769', '856773',
        '856783', '856792', '856797', '856825', '856834', '856840', '856845', '856853', '857297',
        '857301', '857305', '857416', '857461', '857510', '857512', '860092', '860096', '860215',
        '860221', '860225', '860792', '861447', '861455', '861459', '861463', '861467', '861476',
        '861743', '861748', '861753', '862006', '862013', '862019', '862025', '866021', '866144',
        '882504', '885209', '885213', '885219', '889520', '889614', '895664', '901814', '905168',
        '905172', '905269', '905283', '978944', '978946', '991061', '991065', '991082', '991086',
        '992432', '992438', '992441', '992447', '992454', '992460', '992475', '992478', '992858',
        '993943', '994289', '994402', '995218', '995232', '995235', '995253', '995258', '995278',
        '995281', '995285', '995624', '995632', '995666', '995686', '998254', '998726'
    }


class HydrochlorothiazideMethyldopa(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent glyburide / metformin combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; hydrochlorothiazide / methyldopa (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; hydrochlorothiazide / methyldopa in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1414'
    VALUE_SET_NAME = 'Hydrochlorothiazide / Methyldopa'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197960', '197963'}


class HepatitisA(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hepatitis A infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with hepatitis A infections. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1024'
    VALUE_SET_NAME = 'Hepatitis A'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'B150', 'B159'}

    SNOMEDCT = {
        '105801000119103', '111879004', '16060001', '165997004', '18917003', '206373002',
        '25102003', '278971009', '310875001', '40468003', '424758008', '428030001', '43634002',
        '79031007'
    }


class RubellaAntibodyTestIggAntibodyTiter(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests for the titre (amount) of rubella IgG antibody in serum.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with testing to identify titres for rubella IgG antibody.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1063'
    VALUE_SET_NAME = 'Rubella Antibody Test (IgG Antibody Titer)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'41763-4', '46110-3'}


class PatientProviderInteraction(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent provider interactions with patients that include both face-to-face and virtual types of encounters.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with provider interactions with patients that are conducted in an office or care setting, as well as interactions which may occur via virtual methods, such as telephone calls, emails, and letters.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1012'
    VALUE_SET_NAME = 'Patient Provider Interaction'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '11797002', '185316007', '185317003', '185318008', '185320006', '185321005', '185349003',
        '185463005', '185465003', '270424005', '270427003', '270430005', '308335008', '308720009',
        '386473003', '390906007', '401267002', '401271004', '406547006', '438515009', '438516005',
        '445450000', '448337001', '87790002', '90526000'
    }


class InjuryToOpticNerveAndPathways(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of injury to optic nerve and optic pathways.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of injuries to optic nerve, optic chiasm, optic tract, optic pathways and optic visual cortex.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1427'
    VALUE_SET_NAME = 'Injury to Optic Nerve and Pathways'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'S04011A', 'S04012A', 'S0402XA', 'S04031A', 'S04032A', 'S04041A', 'S04042A'}

    ICD9CM = {'9500', '9501', '9502', '9503', '9509'}

    SNOMEDCT = {
        '212141007', '212142000', '230513000', '230514006', '230515007', '230519001', '48233004',
        '69820004', '80499003'
    }


class DexbrompheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dexbrompheniramine / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dexbrompheniramine / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dexbrompheniramine / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1430'
    VALUE_SET_NAME = 'Dexbrompheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1299143', '1363513', '1370963'}


class AtherosclerosisAndPeripheralArterialDisease(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis, condition, or disorder of atherosclerosis or peripheral arterial disease (PAD).
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with conditions that indicate arterial blood flow is restricted putting patients at higher risk for heart disease.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1047.21'
    VALUE_SET_NAME = 'Atherosclerosis and Peripheral Arterial Disease'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'E0851', 'E0852', 'E0951', 'E0952', 'I2510', 'I25110', 'I25111', 'I25118', 'I25119',
        'I25700', 'I25701', 'I25708', 'I25709', 'I25710', 'I25711', 'I25718', 'I25719', 'I25720',
        'I25721', 'I25728', 'I25729', 'I25730', 'I25731', 'I25738', 'I25739', 'I25750', 'I25751',
        'I25758', 'I25759', 'I25760', 'I25761', 'I25768', 'I25769', 'I25790', 'I25791', 'I25798',
        'I25799', 'I25810', 'I25811', 'I25812', 'I2583', 'I2584', 'I2589', 'I672', 'I700', 'I701',
        'I70201', 'I70202', 'I70203', 'I70208', 'I70209', 'I70211', 'I70212', 'I70213', 'I70218',
        'I70219', 'I70221', 'I70222', 'I70223', 'I70228', 'I70229', 'I70231', 'I70232', 'I70233',
        'I70234', 'I70235', 'I70238', 'I70239', 'I70241', 'I70242', 'I70243', 'I70244', 'I70245',
        'I70248', 'I70249', 'I7025', 'I70261', 'I70262', 'I70263', 'I70268', 'I70269', 'I70291',
        'I70292', 'I70293', 'I70298', 'I70299', 'I70301', 'I70302', 'I70303', 'I70308', 'I70309',
        'I70311', 'I70312', 'I70313', 'I70318', 'I70319', 'I70321', 'I70322', 'I70323', 'I70328',
        'I70329', 'I70331', 'I70332', 'I70333', 'I70334', 'I70335', 'I70338', 'I70339', 'I70341',
        'I70342', 'I70343', 'I70344', 'I70345', 'I70348', 'I70349', 'I7035', 'I70361', 'I70362',
        'I70363', 'I70368', 'I70369', 'I70391', 'I70392', 'I70393', 'I70398', 'I70399', 'I70401',
        'I70402', 'I70403', 'I70408', 'I70409', 'I70411', 'I70412', 'I70413', 'I70418', 'I70419',
        'I70421', 'I70422', 'I70423', 'I70428', 'I70429', 'I70431', 'I70432', 'I70433', 'I70434',
        'I70435', 'I70438', 'I70439', 'I70441', 'I70442', 'I70443', 'I70444', 'I70445', 'I70448',
        'I70449', 'I7045', 'I70461', 'I70462', 'I70463', 'I70468', 'I70469', 'I70491', 'I70492',
        'I70493', 'I70498', 'I70499', 'I70501', 'I70502', 'I70503', 'I70508', 'I70509', 'I70511',
        'I70512', 'I70513', 'I70518', 'I70519', 'I70521', 'I70522', 'I70523', 'I70528', 'I70529',
        'I70531', 'I70532', 'I70533', 'I70534', 'I70535', 'I70538', 'I70539', 'I70541', 'I70542',
        'I70543', 'I70544', 'I70545', 'I70548', 'I70549', 'I7055', 'I70561', 'I70562', 'I70563',
        'I70568', 'I70569', 'I70591', 'I70592', 'I70593', 'I70598', 'I70599', 'I70601', 'I70602',
        'I70603', 'I70608', 'I70609', 'I70611', 'I70612', 'I70613', 'I70618', 'I70619', 'I70621',
        'I70622', 'I70623', 'I70628', 'I70629', 'I70631', 'I70632', 'I70633', 'I70634', 'I70635',
        'I70638', 'I70639', 'I70641', 'I70642', 'I70643', 'I70644', 'I70645', 'I70648', 'I70649',
        'I7065', 'I70661', 'I70662', 'I70663', 'I70668', 'I70669', 'I70691', 'I70692', 'I70693',
        'I70698', 'I70699', 'I70701', 'I70702', 'I70703', 'I70708', 'I70709', 'I70711', 'I70712',
        'I70713', 'I70718', 'I70719', 'I70721', 'I70722', 'I70723', 'I70728', 'I70729', 'I70731',
        'I70732', 'I70733', 'I70734', 'I70735', 'I70738', 'I70739', 'I70741', 'I70742', 'I70743',
        'I70744', 'I70745', 'I70748', 'I70749', 'I7075', 'I70761', 'I70762', 'I70763', 'I70768',
        'I70769', 'I70791', 'I70792', 'I70793', 'I70798', 'I70799', 'I708', 'I7090', 'I7091',
        'I7092'
    }

    ICD9CM = {
        '41400', '41401', '41402', '41403', '41404', '41405', '41406', '41407', '4143', '4144',
        '4370', '4400', '4401', '44020', '44021', '44022', '44023', '44024', '44029', '44030',
        '44031', '44032', '4404', '4408', '4409'
    }

    SNOMEDCT = {
        '127014009', '13954005', '145891000119104', '149841000119109', '233955003', '233956002',
        '238793001', '238794007', '284871000119105', '284881000119108', '300920004', '39823006',
        '399957001', '413838009', '421365002', '421895002', '422166005', '429768000', '441574008',
        '442439008', '442693003', '442701004', '442735001', '443502000', '45281005',
        '5111000119102', '51274000', '55382008', '5561000119107', '63491006', '709584004',
        '709585003', '8001000119106', '81817003'
    }


class CataractSecondaryToOcularDisorders(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of cataract that is a secondary diagnosis to other ocular conditions.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of cataract secondary to degenerative or inflammatory ocular disorders, cataract with neovascularization, or subcapsular glaucomatous flecks.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1410'
    VALUE_SET_NAME = 'Cataract Secondary to Ocular Disorders'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H26211', 'H26212', 'H26213', 'H26221', 'H26222', 'H26223'}

    ICD9CM = {'36632', '36633'}

    SNOMEDCT = {
        '15738161000119104', '15738201000119109', '193600001', '193602009', '23273003', '67733005',
        '76309006', '766837000'
    }


class HospitalInpatientVisitInitial(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent inpatient hospital visits.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with initial hospital care for the evaluation and management of a patient. This is a grouping of CPT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1004'
    VALUE_SET_NAME = 'Hospital Inpatient Visit - Initial'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99221', '99222', '99223'}


class PatientReason(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patient-specific reasons for when a patient does not receive a therapy or service.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Negation Rationale.
    Inclusion Criteria: Includes only relevant concepts associated with patient-specific reasons for not receiving a therapy or service.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1008'
    VALUE_SET_NAME = 'Patient Reason'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '105480006', '160932005', '160934006', '182890002', '182895007', '182897004', '182900006',
        '182902003', '183944003', '183945002', '184081006', '185479006', '185481008', '224187001',
        '225928004', '266710000', '266966009', '275694009', '275936005', '281399006', '310343007',
        '373787003', '406149000', '408367005', '413310006', '413311005', '413312003', '416432009',
        '423656007', '424739004', '443390004', '713247000'
    }


class AdhdMedications(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent attention deficit hyperactivity disorder (ADHD) medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Active and Medication, Dispensed.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable; ADHD medications only.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1171'
    VALUE_SET_NAME = 'ADHD Medications'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1006608', '1009145', '1013930', '1013937', '1091133', '1091145', '1091150', '1091152',
        '1091155', '1091170', '1091185', '1091210', '1091225', '1091322', '1091341', '1091389',
        '1091392', '1091497', '1092566', '1101926', '1101932', '1233709', '1312583', '1425847',
        '1425854', '1535454', '1535470', '1593856', '1648183', '1727443', '1734928', '1734951',
        '1806177', '1806179', '1806181', '1806183', '1806185', '1806187', '1806189', '1806191',
        '1806193', '1806195', '1806197', '1806200', '1806202', '1806204', '1806206', '1806208',
        '1806210', '1871456', '1871460', '1871462', '1871464', '1871466', '1871468', '1926840',
        '1926849', '1926853', '1927610', '1927617', '1927630', '1927637', '197745', '197746',
        '1995461', '2001564', '2001565', '2001566', '2001568', '349591', '349592', '349593',
        '349594', '349595', '541363', '541878', '541892', '577957', '577961', '608139', '608143',
        '687043', '753436', '753438', '753440', '753441', '854830', '854834', '854838', '854842',
        '854846', '854850', '861221', '861223', '861225', '861227', '861232', '861237', '862006',
        '862013', '862019', '862025', '884173', '884185', '884189', '884221', '884225', '884385',
        '884386', '884520', '884522', '884532', '884535', '884684', '892791', '899439', '899461',
        '899485', '899495', '899511', '899518', '899548', '899557', '977860', '998671', '998675',
        '998679'
    }


class EndStageRenalDisease(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of end stage renal disease.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of end stage renal disease.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.353'
    VALUE_SET_NAME = 'End Stage Renal Disease'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'N186'}

    ICD9CM = {'5856'}

    SNOMEDCT = {'236434000', '236435004', '236436003', '46177005'}


class BetaBlockerTherapyIngredient(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent beta blocker therapy ingredients.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Allergy/Intolerance.
    Inclusion Criteria: Includes only relevant concepts associated with prescribable ingredient only.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1493'
    VALUE_SET_NAME = 'Beta Blocker Therapy Ingredient'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '10600', '1202', '149', '1520', '19484', '20352', '2116', '6185', '6918', '7226', '8332',
        '8787'
    }


class DexchlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dexbrompheniramine / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dexchlorpheniramine / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dexchlorpheniramine / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1425'
    VALUE_SET_NAME = 'Dexchlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1293239'}


class DeliveryLiveBirths(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent single or multiple live births.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with delivery of one or multiple newborns. This is a grouping of CPT, SNOMED CT and ICD-10-PCS codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1015'
    VALUE_SET_NAME = 'Delivery Live Births'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '59400', '59409', '59410', '59510', '59514', '59515', '59610', '59612', '59614', '59618',
        '59620', '59622'
    }

    ICD10PCS = {
        '10D00Z0', '10D00Z1', '10D00Z2', '10D07Z3', '10D07Z4', '10D07Z5', '10D07Z6', '10D07Z7',
        '10D07Z8', '10E0XZZ'
    }

    SNOMEDCT = {
        '10745001', '11466000', '14119008', '15413009', '16819009', '177141003', '177142005',
        '177143000', '177152009', '177157003', '177158008', '177161009', '177162002', '177164001',
        '177167008', '177168003', '177170007', '177173009', '177174003', '177175002', '177176001',
        '177179008', '177180006', '177181005', '177184002', '177185001', '17860005', '18625004',
        '19390001', '22633006', '236974004', '236975003', '236976002', '236977006', '236978001',
        '236980007', '236981006', '236982004', '236983009', '236984003', '236985002', '236986001',
        '236987005', '236988000', '236989008', '236990004', '237311001', '25296001', '25828002',
        '26313002', '265639000', '274130007', '275168001', '275169009', '28542003', '287976008',
        '288042004', '288193006', '28860009', '29613008', '302382009', '302383004', '30476003',
        '306727001', '33807004', '359940006', '359943008', '384729004', '384730009', '38479009',
        '398307005', '40219000', '40704000', '40792007', '41059002', '416055001', '417121007',
        '4504004', '450483001', '450484007', '450798003', '45718005', '48204000', '54973000',
        '5556001', '57271003', '58705005', '61586001', '62508004', '65243006', '69422002',
        '699999008', '700000006', '709004006', '71166009', '72492007', '734275002', '734276001',
        '736018001', '736020003', '736026009', '736118004', '75928003', '84195007', '85403009',
        '89053004', '89346004', '89849000', '90438006'
    }


class PsychVisitFamilyPsychotherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent visits during which family psychotherapy is performed.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with family psychotherapy.
    Exclusion Criteria: Excludes group psychotherapy or individual psychotherapy visits.
    """

    OID = '2.16.840.1.113883.3.526.3.1018'
    VALUE_SET_NAME = 'Psych Visit - Family Psychotherapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90846', '90847'}

    SNOMEDCT = {'108313002'}


class HepatitisAVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hepatitis A vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with all relevant hepatitis A vaccine codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1215'
    VALUE_SET_NAME = 'Hepatitis A Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'31', '83', '85'}


class LabTestsForSexuallyTransmittedInfections(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests for sexually transmitted infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Laboratory Test, Order.
    Inclusion Criteria: Includes only relevant concepts associated with laboratory tests for sexually transmitted infections in females. This is a grouping of LOINC codes.
    Exclusion Criteria: Excludes codes that indicate lab tests for sexually transmitted infections in male patients.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1051'
    VALUE_SET_NAME = 'Lab Tests for Sexually Transmitted Infections'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '10705-2', '11083-3', '11084-1', '11481-9', '11597-2', '12222-6', '12223-4', '14499-8',
        '14500-3', '14502-9', '14503-7', '14504-5', '14506-0', '16280-0', '17398-9', '17399-7',
        '17400-3', '17401-1', '17402-9', '17403-7', '17404-5', '17405-2', '17406-0', '17407-8',
        '17408-6', '17409-4', '17410-2', '17411-0', '17412-8', '17723-8', '17724-6', '17725-3',
        '17726-1', '17727-9', '17728-7', '17729-5', '20507-0', '20508-8', '21414-8', '21415-5',
        '21416-3', '21440-3', '21441-1', '22461-8', '22462-6', '22587-0', '22590-4', '22592-0',
        '22594-6', '24110-9', '24111-7', '24312-1', '26009-1', '29311-8', '30167-1', '31147-2',
        '31905-3', '31906-1', '32198-4', '32199-2', '32705-6', '34147-9', '34382-2', '38372-9',
        '40679-3', '40680-1', '42481-2', '43305-2', '43403-5', '44543-7', '44544-5', '44546-0',
        '44547-8', '44549-4', '44550-2', '47236-5', '47237-3', '47238-1', '47387-6', '48560-7',
        '49891-5', '49896-4', '5028-6', '50388-8', '50690-7', '51838-1', '51839-9', '5291-0',
        '5292-8', '53605-2', '53762-1', '53879-3', '5392-6', '53927-0', '5393-4', '5394-2',
        '55299-2', '57032-5', '59263-4', '59264-2', '59420-0', '61372-9', '61373-7', '61374-5',
        '61375-2', '61376-0', '61377-8', '61378-6', '61379-4', '61380-2', '61381-0', '61382-8',
        '61383-6', '61384-4', '61385-1', '61386-9', '61387-7', '61388-5', '61389-3', '61390-1',
        '61391-9', '61392-7', '61393-5', '61394-3', '61395-0', '61396-8', '63464-2', '6487-3',
        '6488-1', '6489-9', '6510-2', '6511-0', '6514-4', '6516-9', '6561-5', '6562-3', '660-1',
        '688-2', '690-8', '69002-4', '691-6', '692-4', '693-2', '698-1', '71431-1', '71793-4',
        '73732-0', '73752-8', '73959-9', '7975-6', '8041-6'
    }


class PneumocystisJiroveciPneumoniaPcpProphylaxis(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent Pneumocystis jiroveci pneumonia (PCP) prophylaxis medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Order.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable. Includes only relevant concepts associated with trimethoprim-sulfamethoxazole, dapsone, atovaquone, and pentamidine isethionate.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable; PCP prophylaxis medications in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1076'
    VALUE_SET_NAME = 'Pneumocystis Jiroveci Pneumonia (PCP) Prophylaxis'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '142118', '197557', '197558', '198334', '198335', '308429', '313134', '313137', '607295',
        '861597', '861601'
    }


class HealthBehavioralAssessmentIndividual(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent visits for health and behavior intervention for an individual patient.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with encounter codes specific to intervention for health and/or behavioral factors, which involve an individual patient.
    Exclusion Criteria: Excludes encounters for group settings.
    """

    OID = '2.16.840.1.113883.3.526.3.1020'
    VALUE_SET_NAME = 'Health & Behavioral Assessment - Individual'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'96152'}


class ChlophedianolChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlophedianol / chlorpheniramine / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlophedianol / chlorpheniramine / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlophedianol / chlorpheniramine / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1412'
    VALUE_SET_NAME = 'Chlophedianol / Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1245706', '1248750', '1368963', '1424872'}


class RotavirusVaccine3DoseSchedule(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent rotavirus (3-dose schedule) vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with all rotavirus (3-dose schedule) vaccine codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1223'
    VALUE_SET_NAME = 'Rotavirus Vaccine (3 dose schedule)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'116', '122'}


class MeaslesAntibodyTestIggAntibodyTiter(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests for the  titre (or amount) of IgG antibodies to measles.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with test codes for measles IgG antibody titres in the serum, or cerebrospinal fluid.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1059'
    VALUE_SET_NAME = 'Measles Antibody Test (IgG Antibody Titer)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'21500-4', '21501-2', '22501-1', '22502-9'}


class AdditionalEvaluationForDepressionAdolescent(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent interventions and procedures where an adolescent patient received additional evaluation to determine the presence of depression.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with psychiatric interview and evaluations used to determine the presence of depression, bipolar, or other mental health diagnoses.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1542'
    VALUE_SET_NAME = 'Additional evaluation for depression - adolescent'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '10197000', '10997001', '165171009', '165190001', '370803007', '38756009',
        '429441000124107', '45392008', '79094001', '90407005'
    }


class RetinalVascularOcclusion(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of retinal vascular occlusion.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of retinal vein or artery occlusion.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1479'
    VALUE_SET_NAME = 'Retinal Vascular Occlusion'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H3411', 'H3412', 'H3413', 'H34231', 'H34232', 'H34233', 'H348110', 'H348111', 'H348112',
        'H348120', 'H348121', 'H348122', 'H348130', 'H348131', 'H348132', 'H348310', 'H348311',
        'H348312', 'H348320', 'H348321', 'H348322', 'H348330', 'H348331', 'H348332'
    }

    ICD9CM = {'36231', '36232', '36235', '36236'}

    SNOMEDCT = {
        '232035005', '232037002', '232038007', '232039004', '232040002', '232041003', '232042005',
        '232043000', '232044006', '232045007', '232046008', '232048009', '24596005', '247121001',
        '312997008', '312998003', '314000002', '38742007', '50821009', '65593009', '68478007',
        '73757007', '776009', '87224000'
    }


class VaricellaZosterAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests measuring the presence of IgG antibody to varicella zoster in serum, cerebrospinal fluid (CSF
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with tests measuring the presence of IgG antibody to varicella zoster in serum, CSF and body fluids.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1067'
    VALUE_SET_NAME = 'Varicella Zoster Antibody Test (IgG Antibody Presence)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'15410-4', '19162-7', '41512-5', '42537-1', '53534-4'}


class SexuallyActive(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent vaginal intercourse.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Assessment, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with concepts that indicate whether a patient has had vaginal intercourse.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1040'
    VALUE_SET_NAME = 'Sexually Active'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'64728-9'}


class DiagnosticStudiesDuringPregnancy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnostic studies that would be performed during pregnancy on a fetus (e.g., fetal ultrasound).
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnostic Study, Order.
    Inclusion Criteria: Includes only relevant concepts associated with diagnostic studies conducted on a fetus. This is a grouping of LOINC codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1008'
    VALUE_SET_NAME = 'Diagnostic Studies During Pregnancy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '11615-2', '11616-0', '11617-8', '11618-6', '11619-4', '11620-2', '11621-0', '11622-8',
        '11623-6', '11624-4', '11625-1', '11626-9', '11627-7', '11628-5', '11629-3', '11630-1',
        '11631-9', '11632-7', '11633-5', '11634-3', '11635-0', '11641-8', '11643-4', '11645-9',
        '11647-5', '11649-1', '11651-7', '11654-1', '11656-6', '11660-8', '11661-6', '11662-4',
        '11666-5', '11668-1', '11670-7', '11672-3', '11675-6', '11677-2', '11679-8', '11681-4',
        '11685-5', '11687-1', '11688-9', '11689-7', '11693-9', '11695-4', '11697-0', '11699-6',
        '11701-0', '11703-6', '11705-1', '11707-7', '11709-3', '11711-9', '11713-5', '11715-0',
        '11719-2', '11721-8', '11722-6', '11723-4', '11727-5', '11728-3', '11729-1', '11730-9',
        '11731-7', '11732-5', '11733-3', '11734-1', '11735-8', '11736-6', '11737-4', '11738-2',
        '11739-0', '11740-8', '11741-6', '11742-4', '11743-2', '11744-0', '11745-7', '11746-5',
        '11747-3', '11748-1', '11749-9', '11750-7', '11751-5', '11752-3', '11753-1', '11754-9',
        '11755-6', '11756-4', '11757-2', '11758-0', '11759-8', '11760-6', '11761-4', '11762-2',
        '11763-0', '11764-8', '11765-5', '11766-3', '11767-1', '11768-9', '11775-4', '11777-0',
        '11782-0', '11790-3', '11792-9', '11794-5', '11796-0', '11798-6', '11800-0', '11802-6',
        '11804-2', '11806-7', '11808-3', '11810-9', '11812-5', '11814-1', '11815-8', '11816-6',
        '11817-4', '11818-2', '11819-0', '11820-8', '11821-6', '11822-4', '11823-2', '11824-0',
        '11825-7', '11827-3', '11831-5', '11832-3', '11833-1', '11834-9', '11836-4', '11838-0',
        '11843-0', '11844-8', '11845-5', '11849-7', '11851-3', '11852-1', '11853-9', '11855-4',
        '11860-4', '11861-2', '11862-0', '11863-8', '11864-6', '11866-1', '11868-7', '11871-1',
        '11872-9', '11873-7', '11874-5', '11875-2', '11876-0', '11877-8', '11878-6', '11882-8',
        '11883-6', '11884-4', '11885-1', '11886-9', '11887-7', '11888-5', '11889-3', '11890-1',
        '11891-9', '11892-7', '11893-5', '11894-3', '11895-0', '11896-8', '11897-6', '11898-4',
        '11899-2', '11900-8', '11901-6', '11902-4', '11903-2', '11904-0', '11905-7', '11906-5',
        '11907-3', '11908-1', '11909-9', '11910-7', '11911-5', '11912-3', '11913-1', '11914-9',
        '11915-6', '11916-4', '11917-2', '11918-0', '11919-8', '11920-6', '11921-4', '11922-2',
        '11923-0', '11924-8', '11925-5', '11926-3', '11927-1', '11928-9', '11929-7', '11930-5',
        '11931-3', '11932-1', '11933-9', '11934-7', '11935-4', '11936-2', '11937-0', '11938-8',
        '11939-6', '11940-4', '11941-2', '11942-0', '11943-8', '11944-6', '11945-3', '11946-1',
        '11947-9', '11948-7', '11949-5', '11950-3', '11951-1', '11952-9', '11954-5', '11956-0',
        '11957-8', '11962-8', '11963-6', '11964-4', '11965-1', '11966-9', '11967-7', '11968-5',
        '11969-3', '11970-1', '11971-9', '11972-7', '11973-5', '11974-3', '11975-0', '11978-4',
        '11979-2', '11980-0', '11981-8', '11982-6', '11983-4', '11984-2', '11985-9', '11986-7',
        '11987-5', '11988-3', '11989-1', '11990-9', '11991-7', '11992-5', '11993-3', '11997-4',
        '11999-0', '12003-0', '12004-8', '12005-5', '12009-7', '12012-1', '12018-8', '12019-6',
        '12020-4', '12028-7', '12029-5', '12030-3', '12031-1', '12032-9', '12033-7', '12034-5',
        '12035-2', '12036-0', '12037-8', '12038-6', '12039-4', '12040-2', '12041-0', '12042-8',
        '12043-6', '12047-7', '12048-5', '12049-3', '12050-1', '12051-9', '12052-7', '12053-5',
        '12054-3', '12055-0', '12056-8', '12057-6', '12058-4', '12059-2', '12060-0', '12061-8',
        '12062-6', '12063-4', '12064-2', '12065-9', '12066-7', '12067-5', '12068-3', '12069-1',
        '12070-9', '12071-7', '12072-5', '12073-3', '12074-1', '12075-8', '12076-6', '12077-4',
        '12078-2', '12079-0', '12080-8', '12081-6', '12082-4', '12083-2', '12084-0', '12085-7',
        '12086-5', '12087-3', '12088-1', '12089-9', '12090-7', '12091-5', '12092-3', '12093-1',
        '12094-9', '12095-6', '12096-4', '12097-2', '12098-0', '12099-8', '12100-4', '12101-2',
        '12102-0', '12103-8', '12104-6', '12105-3', '12106-1', '12107-9', '12108-7', '12109-5',
        '12110-3', '12111-1', '12112-9', '12113-7', '12114-5', '12115-2', '12116-0', '12117-8',
        '12118-6', '12119-4', '12120-2', '12121-0', '12122-8', '12123-6', '12124-4', '12125-1',
        '12128-5', '12129-3', '12130-1', '12133-5', '12135-0', '12139-2', '12140-0', '12141-8',
        '12146-7', '12147-5', '12148-3', '12149-1', '12150-9', '12151-7', '12152-5', '12153-3',
        '12154-1', '12155-8', '12162-4', '12163-2', '12166-5', '12167-3', '12168-1', '12169-9',
        '12170-7', '12171-5', '18185-9', '18847-4', '18848-2', '18849-0', '18850-8', '18851-6',
        '21299-3', '24537-3', '30707-4', '30708-2', '33068-8', '33069-6', '33070-4', '33071-2',
        '33072-0', '33073-8', '33074-6', '33075-3', '33076-1', '33077-9', '33078-7', '33079-5',
        '33080-3', '33081-1', '33082-9', '33083-7', '33084-5', '33085-2', '33086-0', '33087-8',
        '33088-6', '33089-4', '33090-2', '33091-0', '33092-8', '33093-6', '33094-4', '33095-1',
        '33096-9', '33097-7', '33098-5', '33099-3', '33100-9', '33101-7', '33102-5', '33103-3',
        '33104-1', '33105-8', '33106-6', '33107-4', '33108-2', '33109-0', '33110-8', '33111-6',
        '33112-4', '33113-2', '33114-0', '33115-7', '33116-5', '33117-3', '33118-1', '33119-9',
        '33120-7', '33121-5', '33122-3', '33123-1', '33124-9', '33125-6', '33126-4', '33127-2',
        '33128-0', '33129-8', '33130-6', '33131-4', '33132-2', '33133-0', '33134-8', '33135-5',
        '33136-3', '33137-1', '33138-9', '33139-7', '33140-5', '33141-3', '33142-1', '33143-9',
        '33144-7', '33145-4', '33146-2', '33147-0', '33148-8', '33149-6', '33150-4', '33151-2',
        '33152-0', '33153-8', '33154-6', '33155-3', '33156-1', '33157-9', '33158-7', '33159-5',
        '33160-3', '33161-1', '33162-9', '33163-7', '33164-5', '33165-2', '33166-0', '33167-8',
        '33168-6', '33169-4', '33170-2', '33172-8', '33173-6', '33174-4', '33175-1', '33176-9',
        '33177-7', '33178-5', '33179-3', '33180-1', '33181-9', '33184-3', '33185-0', '33186-8',
        '33187-6', '33188-4', '33189-2', '33190-0', '33191-8', '33196-7', '33197-5', '33198-3',
        '33199-1', '33537-2', '33538-0', '33539-8', '33540-6', '33541-4', '33542-2', '33543-0',
        '33544-8', '33545-5', '33546-3', '33556-2', '42451-5', '42452-3', '42454-9', '42464-8',
        '42465-5', '42466-3', '42467-1', '42479-6', '49035-9', '49051-6', '49052-4', '49508-5',
        '49513-5', '53655-7', '53656-5', '53657-3', '53658-1', '53659-9', '53660-7', '53667-2',
        '53668-0', '53669-8', '53670-6', '53671-4', '53672-2', '53673-0', '53674-8', '53675-5',
        '53676-3', '53677-1', '53678-9', '53679-7', '53680-5', '53681-3', '53682-1', '53683-9',
        '53684-7', '53685-4', '53686-2', '53687-0', '53688-8', '53689-6', '53690-4', '53691-2',
        '53693-8', '53695-3', '53696-1', '53697-9', '53698-7', '53699-5', '53700-1', '53701-9',
        '57067-1', '60477-7', '69391-1', '69400-0', '72221-5'
    }


class HemorrhagicStroke(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent patients who have had a hemorrhagic stroke, or stroke caused by hemorrhage.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Principal Diagnosis. The intent of this data element is to identify patients who have a diagnosis of hemorrhagic stroke, or stroke caused by a hemorrhage.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of hemorrhagic stroke, or stroke caused by hemorrhage. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.212'
    VALUE_SET_NAME = 'Hemorrhagic Stroke'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'I6000', 'I6001', 'I6002', 'I6010', 'I6011', 'I6012', 'I602', 'I6030', 'I6031', 'I6032',
        'I604', 'I6050', 'I6051', 'I6052', 'I606', 'I607', 'I608', 'I609', 'I610', 'I611', 'I612',
        'I613', 'I614', 'I615', 'I616', 'I618', 'I619'
    }

    SNOMEDCT = {
        '195155004', '195160000', '195165005', '195167002', '195168007', '195169004', '20908003',
        '230706003', '230707007', '230708002', '230709005', '230710000', '230711001', '230712008',
        '23276006', '270907008', '274100004', '276277008', '276278003', '276280009', '276281008',
        '276282001', '276283006', '276284000', '276285004', '276286003', '276722003', '28318001',
        '42429001', '425957003', '449020009', '49422009', '52201006', '73020009', '75038005',
        '7713009', '95454007'
    }


class EmergencyDepartmentVisit_292(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures representing an emergency department encounter.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter. The intent of this data element is to identify patients who have had an emergency department encounter.
    Inclusion Criteria: Includes only relevant concepts associated with an emergency department visit encounter using the SNOMED CT code system.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.292'
    VALUE_SET_NAME = 'Emergency Department Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'4525004'}


class DischargedToHealthCareFacilityForHospiceCare(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures used to represent the discharge of a patient to a health care facility for hospice care.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Discharge Disposition. The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular inpatient encounter. This particular value set intends to identify patients who were discharged to a health care facility for hospice care.
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT codes representing health care facilities.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.207'
    VALUE_SET_NAME = 'Discharged to Health Care Facility for Hospice Care'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'428371000124100'}


class DecisionToAdmitToHospitalInpatient(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures that are commonly used for capturing an emergency decision to admit a patient to an inpatient hospital setting.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter. The intent of this data element is to identify an emergency decision to admit a patient to an inpatient hospital setting.
    Inclusion Criteria: Includes only relevant concepts associated with codes representing an emergency decision to admit a patient to an inpatient hospital setting using the SNOMED CT system.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.295'
    VALUE_SET_NAME = 'Decision to Admit to Hospital Inpatient'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'10378005', '19951005', '73607007', '76464004'}


class GeneralOrNeuraxialAnesthesia(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent a surgical procedure where a general and/or neuraxial anesthesia is used.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients who have a surgical procedure where general and/or neuraxial anesthesia is used.
    Inclusion Criteria: Includes only relevant concepts associated with representing general and/or neuraxial anesthesia. Codes used are to be ICD-10-PCS, ICD-9 or SNOMED CT codes only.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.666.5.1743'
    VALUE_SET_NAME = 'General or Neuraxial Anesthesia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '3E030FZ', '3E033FZ', '3E040FZ', '3E043FZ', '3E050FZ', '3E053FZ', '3E060FZ', '3E063FZ'
    }

    SNOMEDCT = {
        '112943005', '112987001', '180878007', '180885006', '180886007', '18946005', '231249005',
        '231251009', '231252002', '231253007', '231255000', '231256004', '231257008', '231258003',
        '231261002', '231262009', '231263004', '241696005', '241717009', '24277005', '266802007',
        '27653002', '288185006', '30050007', '302335002', '302336001', '303356007', '303358008',
        '35597003', '398044000', '405650006', '426309005', '427060008', '44812007', '448585004',
        '449126000', '50697003', '58611004', '64287005', '67716003', '74527005', '82776005'
    }


class DirectThrombinInhibitor(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent direct thrombin inhibitor medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who are on a direct thrombin inhibitor.
    Inclusion Criteria: Includes only relevant concepts associated with representing direct thrombin inhibitors. These are RxNorm codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.205'
    VALUE_SET_NAME = 'Direct Thrombin Inhibitor'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1037045', '1037179', '1723476', '1804735', '1804737', '1804738', '1997015', '1997017',
        '308351', '308769'
    }


class NeonatalIntensiveCareUnitNicu(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent neonatal intensive care units (NICU).
    Data Element Scope: This value set may use Quality Data Model (QDM) datatype related to Encounter, Performed, or attribute related to Location. The intent of this data element is to identify patients in intensive care units.
    Inclusion Criteria: Includes only relevant concepts associated with neonatal intensive care units (NICU). This is a grouping of HSLOC and SNOMEDCT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1029.205'
    VALUE_SET_NAME = 'Neonatal Intensive Care Unit (NICU)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    HSLOC = {'1039-7', '1040-5'}

    SNOMEDCT = {'405269005'}


class AtrialAblation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent atrial ablation procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients with a history of atrial ablation procedure.
    Inclusion Criteria: Includes only relevant concepts associated with codes that identify patients with a history of atrial ablation procedure. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.203'
    VALUE_SET_NAME = 'Atrial Ablation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {'02560ZZ', '02563ZZ', '02564ZZ', '02580ZZ', '02583ZZ', '02584ZZ'}

    SNOMEDCT = {
        '175095005', '175125003', '233159005', '233160000', '233161001', '233162008', '233163003',
        '428290007', '428663009', '429211003', '440619008', '473229000', '707832008'
    }


class AdvancedIllness(ValueSet):
    """

    Clinical Focus: This value set contains concepts related to Advanced Illnesses.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who have an advanced illness diagnosis.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1082'
    VALUE_SET_NAME = 'Advanced Illness'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A8100', 'A8101', 'A8109', 'C250', 'C251', 'C252', 'C253', 'C254', 'C257', 'C258', 'C259',
        'C719', 'C770', 'C771', 'C772', 'C773', 'C774', 'C775', 'C778', 'C779', 'C7800', 'C781',
        'C782', 'C7839', 'C784', 'C785', 'C786', 'C787', 'C7889', 'C7900', 'C7911', 'C7919',
        'C792', 'C7931', 'C7932', 'C7949', 'C9100', 'C9102', 'C9200', 'C9202', 'C9300', 'C9302',
        'C9390', 'C9392', 'C93Z0', 'C93Z2', 'C9430', 'C9432', 'F0150', 'F0151', 'F0280', 'F0281',
        'F0390', 'F0391', 'F04', 'F1027', 'F1096', 'F1097', 'G10', 'G1221', 'G20', 'G300', 'G301',
        'G308', 'G309', 'G3101', 'G3109', 'G3183', 'I0981', 'I110', 'I120', 'I130', 'I1311',
        'I132', 'I501', 'I5020', 'I5021', 'I5022', 'I5023', 'I5030', 'I5031', 'I5032', 'I5033',
        'I5040', 'I5041', 'I5042', 'I5043', 'I50810', 'I50811', 'I50812', 'I50813', 'I50814',
        'I5082', 'I5083', 'I5084', 'I5089', 'I509', 'J430', 'J431', 'J432', 'J438', 'J439', 'J684',
        'J8410', 'J84112', 'J8417', 'J9610', 'J9611', 'J9612', 'J9620', 'J9621', 'J9622', 'J9690',
        'J9691', 'J9692', 'J982', 'J983', 'K7010', 'K7011', 'K702', 'K7030', 'K7031', 'K7040',
        'K7041', 'K709', 'K740', 'K741', 'K742', 'K744', 'K745', 'K7460', 'K7469', 'N185', 'N186'
    }

    SNOMEDCT = {
        '10091002', '101281000119107', '101301000119106', '101421000119107', '10335000',
        '10349009', '103511000119103', '103611000119102', '10532003', '105421000119105',
        '105451000119102', '106021000119105', '10633002', '10672271000119100', '10676831000119101',
        '107571000119101', '107581000119103', '10762071000119109', '108101000119101',
        '108131000119108', '108201000119105', '108211000119108', '109819003', '109848009',
        '109912006', '111283005', '111411000119103', '111480006', '116811000119106',
        '116821000119104', '120851000119104', '120861000119102', '120871000119108',
        '120881000119106', '120891000119109', '120901000119108', '12246561000119101',
        '12246601000119101', '12348006', '123604002', '123605001', '123606000', '12368000',
        '123716002', '123717006', '127991000119101', '128001000119105', '128404006', '128462008',
        '128465005', '130121000119104', '13092008', '13274008', '13351431000119102',
        '135091000119106', '13839000', '14070001', '141991000119109', '142001000119106',
        '142011000119109', '143401000119106', '14700006', '153931000119109', '153941000119100',
        '153951000119103', '15629541000119106', '15629591000119103', '15629641000119107',
        '15629741000119102', '15662003', '15781000119107', '1581000119101', '1591000119103',
        '15956181000119102', '15999000', '16003001', '16055271000119107', '16070004',
        '16219201000119101', '16260631000119101', '162711000', '162712007', '16276361000119109',
        '162974009', '1651000119109', '1661000119106', '1671000119100', '1681000119102',
        '16846004', '1691000119104', '17262008', '17385007', '1761006', '1801000119106',
        '181869007', '187786003', '187791002', '187792009', '187793004', '187794005', '187798008',
        '188280007', '188281006', '188282004', '188283009', '188285002', '188286001', '188287005',
        '188289008', '188290004', '188292007', '188293002', '188295009', '188296005', '188297001',
        '188298006', '188301005', '188302003', '188308004', '188339002', '188340000', '188445006',
        '188454009', '188458007', '188459004', '188462001', '188469005', '188471005', '188645002',
        '188648000', '188649008', '19090001000004101', '191449005', '191451009', '191452002',
        '191454001', '191455000', '191457008', '191458003', '191459006', '191461002', '191463004',
        '191464005', '191465006', '191466007', '191471000', '191493005', '191494004', '191519005',
        '192926004', '192927008', '192928003', '192929006', '194767001', '194779001', '194781004',
        '195111005', '195112003', '195114002', '195957006', '195958001', '195959009', '195963002',
        '196026004', '196028003', '196125002', '197279005', '197291001', '197293003', '197294009',
        '197296006', '197299004', '197301006', '197303009', '197305002', '197310003', '19943007',
        '206586007', '213215000', '21861000', '21921000119103', '22381000119105', '230156002',
        '230258005', '230265002', '230266001', '230267005', '230268000', '230269008', '230271008',
        '230272001', '230280008', '230282000', '230283005', '230285003', '230286002', '230287006',
        '230288001', '230289009', '230299004', '230300007', '230301006', '230372003', '230373008',
        '230499002', '23341000119109', '233674008', '233675009', '233677001', '233713004',
        '233724002', '233725001', '233726000', '233758005', '233761006', '233765002', '233924009',
        '233940007', '235875008', '235881000', '235895002', '235896001', '235897005', '235899008',
        '235901004', '235902006', '235965006', '235966007', '236433006', '236434000', '236435004',
        '236436003', '236512004', '236513009', '23958009', '241861008', '2421000119107',
        '242862004', '24700007', '254609000', '254611009', '254612002', '254938000', '254940005',
        '254955001', '254969001', '255044008', '255088001', '255112006', '255118005', '255119002',
        '255121007', '255123005', '255124004', '25544003', '25772007', '266355005', '266356006',
        '266368002', '266468003', '266469006', '266470007', '266471006', '26852004', '268612007',
        '26929004', '269473008', '269616004', '269617008', '271440004', '27156006', '274088005',
        '274282003', '275266006', '276259003', '276514007', '276826005', '276828006', '276836002',
        '277461004', '277505007', '277638005', '277639002', '278051002', '278433008', '278857002',
        '281004', '281560004', '285211000119102', '285221000119109', '285598005', '285603002',
        '285604008', '285605009', '285606005', '285607001', '285608006', '285609003', '285610008',
        '285611007', '285612000', '285613005', '285614004', '285615003', '285616002', '285617006',
        '285618001', '285619009', '285631006', '285633009', '285634003', '285635002', '285637005',
        '285638000', '285639008', '285640005', '285641009', '285642002', '285643007', '285644001',
        '285645000', '285841000119104', '286371000119107', '286902000', '288631000119104',
        '2912004', '30042003', '301643003', '302507002', '303194003', '303201005', '304603007',
        '307226002', '307593001', '307601000', '307757001', '309775007', '31081000119101',
        '312991009', '314206003', '314408000', '314418005', '314964006', '314987003', '314988008',
        '314989000', '314990009', '314991008', '314992001', '314993006', '314994000', '314995004',
        '314996003', '314997007', '314998002', '314999005', '315000005', '315001009', '315002002',
        '315003007', '315004001', '315005000', '315006004', '315007008', '315008003', '315009006',
        '31712002', '31898008', '326072005', '32875003', '3298001', '33144001', '33325001',
        '33644002', '3514002', '353561000119103', '353741000119106', '359617009', '359780007',
        '359782004', '359785002', '359987004', '363368005', '363369002', '363417006', '363418001',
        '363419009', '363467004', '363468009', '363469001', '363470000', '363471001', '363473003',
        '363482009', '363483004', '364006', '36599006', '367363000', '369455009', '369456005',
        '369457001', '369458006', '369459003', '369460008', '369461007', '369464004', '369467006',
        '369468001', '369476004', '369477008', '369478003', '369479006', '369480009', '369481008',
        '369482001', '369484000', '369486003', '369500009', '369501008', '369502001', '369514009',
        '369521009', '369523007', '369530001', '369535006', '369536007', '369538008', '369540003',
        '369542006', '369543001', '369544007', '369545008', '369546009', '369553000', '369554006',
        '369555007', '369556008', '369557004', '369558009', '369560006', '369561005', '369562003',
        '369563008', '369564002', '369565001', '369568004', '369569007', '369570008', '369571007',
        '369572000', '369573005', '369574004', '369575003', '369576002', '369577006', '369578001',
        '369581006', '369582004', '369583009', '369584003', '369585002', '369586001', '369588000',
        '369589008', '369590004', '369591000', '369592007', '369593002', '369602008', '369603003',
        '369604009', '369605005', '369606006', '369607002', '369608007', '369609004', '369610009',
        '371024007', '371026009', '371139006', '371967001', '372003004', '372093008', '372119009',
        '372142002', '37688005', '397767007', '39871006', '399969009', '400058002', '402563000',
        '402879006', '403906006', '404090003', '404091004', '404092006', '404093001', '404094007',
        '404122003', '404123008', '404124002', '404156009', '40425004', '405570007', '405843009',
        '40640008', '409622000', '410430005', '410431009', '41309000', '414676007', '416780008',
        '416975007', '417996009', '418304008', '418529003', '419728003', '420054005', '420614009',
        '421023003', '421283008', '421529006', '422782004', '423032007', '423384009', '42343007',
        '423595004', '423987006', '424052001', '424151006', '424276002', '424404003', '424887002',
        '424954002', '425303004', '425369003', '425390006', '425413006', '425500002', '426012001',
        '426263006', '426373005', '426437004', '426611007', '426896000', '428051000124108',
        '428061005', '428173007', '428351000124105', '428700003', '429033009', '429161000124103',
        '429458009', '429998004', '430771000124100', '433146000', '434431000124103', '43736008',
        '438511000', '43904005', '439567002', '44047000', '44088000', '441481004', '441530006',
        '442344002', '44274007', '44313006', '443144000', '443253003', '443254009', '443343001',
        '443344007', '443493003', '445236007', '446221000', '448218008', '448248006', '448250003',
        '448863000', '448989001', '449253005', '449420002', '449630001', '449631002', '449632009',
        '449633004', '45256007', '46113002', '46177005', '462172006', '462174007', '462175008',
        '471880001', '473419009', '4817008', '48447003', '49049000', '49584005', '49708008',
        '4981000', '50196008', '50325005', '5053004', '5148006', '51615001', '51928006',
        '52448006', '536002', '5375005', '54502004', '54867000', '55009008', '55565007',
        '56267009', '56675007', '56841008', '57488007', '57557005', '57686001', '58756001',
        '59651006', '59773008', '60805002', '60856006', '609507007', '6183001', '62239001',
        '6475002', '65096006', '65710008', '66108005', '66110007', '66989003', '67431000119105',
        '67441000119101', '67905004', '681621000119105', '681721000119103', '68328006',
        '684911000119105', '69482004', '698296002', '698504006', '698594003', '698624003',
        '698625002', '698626001', '698687007', '698725008', '698726009', '698781002', '698948009',
        '698949001', '698954005', '698955006', '699318007', '699748007', '700250006', '700251005',
        '700252003', '700423003', '702373006', '702392008', '703272007', '703273002', '703274008',
        '703275009', '703276005', '704152002', '704242009', '704667004', '705176003', '707324008',
        '707434003', '708030004', '708537005', '709109004', '709110009', '709111008', '709285002',
        '70936005', '71193007', '712487000', '712849003', '713060000', '713181003', '713189001',
        '713244007', '713325002', '713370005', '713419002', '713488003', '713844000', '715345007',
        '715401008', '715414009', '715662009', '715737004', '715807002', '715864007', '715904005',
        '716107009', '716203000', '716662004', '717840005', '718089001', '718555006', '718685006',
        '71892000', '719218000', '720587009', '721718003', '721977007', '722095005', '722600006',
        '722671009', '722707001', '722919003', '722962002', '722977005', '722978000', '722979008',
        '722980006', '722987009', '723123001', '723390000', '723829000', '724550005', '724685000',
        '724686004', '724687008', '724747009', '724761004', '724776007', '724777003', '724778008',
        '72481000119103', '724992007', '725146001', '725416005', '725898002', '725938001',
        '725939009', '725940006', '73097000', '733028000', '733184002', '733190003', '733191004',
        '733192006', '733193001', '733194007', '733351008', '7361000175106', '7371000175103',
        '7381000175100', '7391000175102', '7401000175100', '7411000175102', '7421000175106',
        '74669004', '74960003', '76301009', '77690003', '78208005', '78862003', '792004',
        '79341000119107', '79955004', '80479009', '80614003', '82351000119105', '82361000119107',
        '82371000119101', '82381000119103', '82523003', '82959004', '831000119103', '83105008',
        '83168008', '83291003', '84114007', '85232009', '86044005', '86454000', '86680006',
        '87091000119101', '87101000119106', '87111000119109', '87121000119102', '87317003',
        '87433001', '88805009', '89580002', '89819002', '90099008', '90117007', '90610005',
        '90688005', '90771000119100', '90791000119104', '91181000119105', '91251000119105',
        '91281000119103', '92506005', '93145002', '9345005', '93715005', '93726004', '93727008',
        '93746009', '93748005', '93749002', '93768004', '93807001', '93843007', '93928006',
        '93930008', '93939009', '93946000', '93962006', '93964007', '94082003', '94086000',
        '94152006', '94153001', '94154007', '94155008', '94156009', '94157000', '94158005',
        '94159002', '94160007', '94161006', '94162004', '94163009', '94164003', '94165002',
        '94166001', '94167005', '94168000', '94169008', '94170009', '94171008', '94172001',
        '94173006', '94175004', '94176003', '94177007', '94179005', '94180008', '94181007',
        '94182000', '94183005', '94184004', '94185003', '94186002', '94187006', '94189009',
        '94190000', '94191001', '94192008', '94193003', '94194009', '94195005', '94196006',
        '94197002', '94198007', '94200001', '94201002', '94202009', '94203004', '94204005',
        '94205006', '94206007', '94207003', '94208008', '94209000', '94210005', '94211009',
        '94212002', '94213007', '94214001', '94215000', '94217008', '94218003', '94219006',
        '94220000', '94221001', '94222008', '94224009', '94225005', '94226006', '94227002',
        '94228007', '94229004', '94230009', '94231008', '94232001', '94233006', '94234000',
        '94235004', '94236003', '94237007', '94238002', '94239005', '94240007', '94241006',
        '94242004', '94243009', '94244003', '94245002', '94246001', '94247005', '94248000',
        '94249008', '94250008', '94252000', '94253005', '94254004', '94255003', '94256002',
        '94257006', '94258001', '94259009', '94260004', '94261000', '94262007', '94263002',
        '94264008', '94265009', '94266005', '94267001', '94268006', '94269003', '94270002',
        '94271003', '94272005', '94273000', '94274006', '94275007', '94276008', '94277004',
        '94278009', '94279001', '94280003', '94281004', '94282006', '94283001', '94284007',
        '94285008', '94286009', '94287000', '94288005', '94289002', '94290006', '94291005',
        '94292003', '94293008', '94294002', '94295001', '94296000', '94297009', '94298004',
        '94299007', '94300004', '94301000', '94302007', '94303002', '94304008', '94305009',
        '94306005', '94307001', '94308006', '94309003', '94310008', '94311007', '94312000',
        '94313005', '94314004', '94315003', '94316002', '94317006', '94318001', '94319009',
        '94320003', '94321004', '94322006', '94323001', '94324007', '94325008', '94326009',
        '94327000', '94328005', '94329002', '94330007', '94331006', '94332004', '94333009',
        '94334003', '94335002', '94336001', '94337005', '94338000', '94339008', '94340005',
        '94341009', '94342002', '94343007', '94344001', '94345000', '94346004', '94347008',
        '94348003', '94349006', '94350006', '94351005', '94352003', '94353008', '94354002',
        '94355001', '94356000', '94357009', '94358004', '94359007', '94360002', '94361003',
        '94362005', '94364006', '94365007', '94366008', '94367004', '94368009', '94369001',
        '94370000', '94371001', '94372008', '94373003', '94374009', '94375005', '94376006',
        '94378007', '94379004', '94380001', '94381002', '94382009', '94383004', '94384005',
        '94385006', '94386007', '94387003', '94388008', '94389000', '94390009', '94391008',
        '94392001', '94393006', '94394000', '94395004', '94396003', '94397007', '94398002',
        '94399005', '94400003', '94401004', '94402006', '94403001', '94404007', '94405008',
        '94406009', '94407000', '94408005', '94409002', '94410007', '94411006', '94412004',
        '94413009', '94414003', '94415002', '94416001', '94417005', '94418000', '94419008',
        '94420002', '94421003', '94422005', '94423000', '94424006', '94425007', '94426008',
        '94427004', '94428009', '94429001', '94430006', '94431005', '94432003', '94433008',
        '94434002', '94435001', '94436000', '94437009', '94439007', '94440009', '94441008',
        '94442001', '94443006', '94444000', '94445004', '94446003', '94447007', '94448002',
        '94449005', '94450005', '94451009', '94452002', '94453007', '94454001', '94455000',
        '94456004', '94457008', '94458003', '94459006', '94460001', '94461002', '94462009',
        '94463004', '94464005', '94465006', '94466007', '94467003', '94468008', '94469000',
        '94470004', '94471000', '94472007', '94473002', '94474008', '94475009', '94476005',
        '94477001', '94478006', '94479003', '94480000', '94481001', '94482008', '94483003',
        '94484009', '94485005', '94486006', '94487002', '94488007', '94489004', '94490008',
        '94491007', '94492000', '94493005', '94494004', '94495003', '94496002', '94497006',
        '94498001', '94499009', '94500000', '94501001', '94502008', '94503003', '94504009',
        '94505005', '94506006', '94507002', '94508007', '94509004', '94510009', '94511008',
        '94512001', '94513006', '94514000', '94515004', '94516003', '94517007', '94518002',
        '94519005', '94520004', '94521000', '94522007', '94523002', '94524008', '94525009',
        '94526005', '94527001', '94528006', '94529003', '94530008', '94531007', '94532000',
        '94533005', '94534004', '94535003', '94536002', '94537006', '94538001', '94539009',
        '94540006', '94542003', '94543008', '94544002', '94545001', '94546000', '94547009',
        '94548004', '94549007', '94550007', '94551006', '94552004', '94553009', '94554003',
        '94555002', '94556001', '94557005', '94558000', '94559008', '94560003', '94561004',
        '94562006', '94564007', '94565008', '94566009', '94567000', '94568005', '94569002',
        '94570001', '94571002', '94572009', '94573004', '94574005', '94575006', '94576007',
        '94577003', '94578008', '94579000', '94580002', '94581003', '94582005', '94583000',
        '94584006', '94585007', '94586008', '94587004', '94588009', '94589001', '94590005',
        '94591009', '94592002', '94593007', '94594001', '94595000', '94596004', '94597008',
        '94598003', '94599006', '94600009', '94601008', '94602001', '94603006', '94604000',
        '94605004', '94606003', '94607007', '94608002', '94609005', '94610000', '94611001',
        '94612008', '94613003', '94614009', '94615005', '94616006', '94617002', '94618007',
        '94619004', '94620005', '94621009', '94622002', '94623007', '94624001', '94625000',
        '94626004', '94627008', '94628003', '94629006', '94630001', '94631002', '94632009',
        '94633004', '94634005', '94635006', '94636007', '94637003', '94638008', '94639000',
        '94640003', '94641004', '94642006', '94643001', '94644007', '94645008', '94646009',
        '94647000', '94648005', '94649002', '94650002', '94651003', '94652005', '94653000',
        '94654006', '94655007', '94656008', '94657004', '94658009', '94659001', '94660006',
        '94661005', '94662003', '94663008', '94664002', '94665001', '94666000', '94667009',
        '94668004', '94669007', '94670008', '94671007', '94672000', '94673005', '94674004',
        '94675003', '94676002', '94677006', '94678001', '94679009', '94680007', '94681006',
        '94682004', '94683009', '95634003', '96311000119109', '96901000119105', '96981000119102',
        '97051000119105', '97751000119108', '99131000119108', '9953008'
    }


class OutpatientConsultation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have had an outpatient interaction at an office with a member of their medical care team.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity. This is a grouping value set of CPT and SNOMED CT codes.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1008'
    VALUE_SET_NAME = 'Outpatient Consultation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99241', '99242', '99243', '99244', '99245'}

    SNOMEDCT = {'17436001', '281036007', '77406008'}


class UrinaryRetention(ValueSet):
    """

    Clinical Focus: This set of values focuses on urinary retention related to drugs or other causes.
    Data Element Scope: The intent of this data element is to define urinary retention.
    Inclusion Criteria: Urinary retention related to drugs or other causes
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1164.52'
    VALUE_SET_NAME = 'Urinary retention'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'R330', 'R338', 'R339'}

    SNOMEDCT = {'12245681000119103', '236648008', '267064002'}


class HyoscyamineMethenamineMbluePhenylSalicyl(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hyoscyamine / methenamine / mblue / phenyl salicyl combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; hyoscyamine / methenamine / mblue / phenyl salicyl (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; hyoscyamine / methenamine / mblue / phenyl salicyl in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1503'
    VALUE_SET_NAME = 'Hyoscyamine / Methenamine / Mblue / Phenyl Salicyl'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1047786', '1048307'}


class Methyldopa(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent methyldopa medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; methyldopa only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; methyldopa in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1331'
    VALUE_SET_NAME = 'Methyldopa'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197956', '197958'}


class ProstateCancerTreatment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent prostate cancer treatments.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with interstitial prostate brachytherapy, external beam radiotherapy to the prostate and radical prostatectomy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.398'
    VALUE_SET_NAME = 'Prostate Cancer Treatment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '55810', '55812', '55815', '55840', '55842', '55845', '55866', '55875', '77427', '77435',
        '77772', '77778', '77799'
    }

    SNOMEDCT = {
        '10492003', '113120007', '116244007', '118161009', '118162002', '118163007', '14473006',
        '168922004', '169327006', '169328001', '169329009', '169340001', '169349000', '169359004',
        '176106009', '176258007', '176260009', '176261008', '176262001', '176263006', '176267007',
        '176286004', '176288003', '19149007', '21190008', '21372000', '228677009', '228684001',
        '228688003', '228690002', '228692005', '228693000', '228694006', '228695007', '228697004',
        '228698009', '228699001', '228701001', '228702008', '236252003', '24242005', '26294005',
        '271291003', '27877006', '28579000', '30426000', '312235007', '314202001', '359922007',
        '359926005', '36253005', '37851009', '384691004', '384692006', '38915000', '394902000',
        '394918006', '399124002', '399180008', '399315003', '41371003', '41416003',
        '427541000119103', '427985002', '433224001', '440093006', '440094000', '57525009',
        '62867004', '65381004', '65551008', '67598001', '68986004', '72388004', '764675000',
        '77613002', '81232004', '83154001', '84755001', '85768003', '87795007', '8782006',
        '90199006', '90470006', '91531008'
    }


class Male(ValueSet):
    """

    Clinical Focus: Concepts that represent Male when assessing quality measures
    Data Element Scope: Gender
    Inclusion Criteria: Appropriate male gender concepts
    Exclusion Criteria: concepts representing Female gender
    """

    OID = '2.16.840.1.113883.3.560.100.1'
    VALUE_SET_NAME = 'Male'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ADMINISTRATIVEGENDER = {'M'}


class CataractCongenital(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of congenital cataract.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of congenital cataract.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1412'
    VALUE_SET_NAME = 'Cataract, Congenital'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Q120'}

    ICD9CM = {'74330'}

    SNOMEDCT = {
        '204128001', '204130004', '204138006', '204139003', '21590003', '253223002', '253224008',
        '253225009', '253226005', '253227001', '268159001', '28550007', '29590001', '63912009',
        '66499004', '76562003', '79410001'
    }


class CompetingConditionsForRespiratoryConditions(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis for an acute bacterial infection that may warrant treatment with an antibiotic medication.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with the diagnosis of acute bacterial infections that may warrant treatment with an antibiotic medication. This is a value set grouping that includes ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes acute diagnoses that do not warrant treatment with an antibiotic medication.
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1017'
    VALUE_SET_NAME = 'Competing Conditions for Respiratory Conditions'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A000', 'A001', 'A009', 'A0100', 'A0101', 'A0102', 'A0103', 'A0104', 'A0105', 'A0109',
        'A011', 'A012', 'A013', 'A014', 'A020', 'A021', 'A0220', 'A0221', 'A0222', 'A0223',
        'A0224', 'A0225', 'A0229', 'A028', 'A029', 'A030', 'A031', 'A032', 'A033', 'A038', 'A039',
        'A040', 'A041', 'A042', 'A043', 'A044', 'A045', 'A046', 'A047', 'A0471', 'A0472', 'A048',
        'A049', 'A050', 'A051', 'A052', 'A053', 'A054', 'A055', 'A058', 'A059', 'A060', 'A061',
        'A062', 'A063', 'A064', 'A065', 'A066', 'A067', 'A0681', 'A0682', 'A0689', 'A069', 'A070',
        'A071', 'A072', 'A073', 'A074', 'A078', 'A079', 'A080', 'A0811', 'A0819', 'A082', 'A0831',
        'A0832', 'A0839', 'A084', 'A088', 'A09', 'A3700', 'A3701', 'A3710', 'A3711', 'A3780',
        'A3781', 'A3790', 'A3791', 'A440', 'A441', 'A448', 'A449', 'A499', 'A5001', 'A5002',
        'A5003', 'A5004', 'A5005', 'A5006', 'A5007', 'A5008', 'A5009', 'A501', 'A502', 'A5030',
        'A5031', 'A5032', 'A5039', 'A5040', 'A5041', 'A5042', 'A5043', 'A5044', 'A5045', 'A5049',
        'A5051', 'A5052', 'A5053', 'A5054', 'A5055', 'A5056', 'A5057', 'A5059', 'A506', 'A507',
        'A509', 'A510', 'A511', 'A512', 'A5131', 'A5132', 'A5139', 'A5141', 'A5142', 'A5143',
        'A5144', 'A5145', 'A5146', 'A5149', 'A515', 'A519', 'A5200', 'A5201', 'A5202', 'A5203',
        'A5204', 'A5205', 'A5206', 'A5209', 'A5210', 'A5211', 'A5212', 'A5213', 'A5214', 'A5215',
        'A5216', 'A5217', 'A5219', 'A522', 'A523', 'A5271', 'A5272', 'A5273', 'A5274', 'A5275',
        'A5276', 'A5277', 'A5278', 'A5279', 'A528', 'A529', 'A530', 'A539', 'A5400', 'A5401',
        'A5402', 'A5403', 'A5409', 'A541', 'A5421', 'A5422', 'A5423', 'A5424', 'A5429', 'A5430',
        'A5431', 'A5432', 'A5433', 'A5439', 'A5440', 'A5441', 'A5442', 'A5443', 'A5449', 'A545',
        'A546', 'A5481', 'A5482', 'A5483', 'A5484', 'A5485', 'A5486', 'A5489', 'A549', 'A55',
        'A5600', 'A5601', 'A5602', 'A5609', 'A5611', 'A5619', 'A562', 'A563', 'A564', 'A568',
        'A57', 'A58', 'A5900', 'A5901', 'A5902', 'A5903', 'A5909', 'A598', 'A599', 'A630', 'A638',
        'A64', 'A690', 'A691', 'A6920', 'A6921', 'A6922', 'A6923', 'A6929', 'A698', 'A699', 'B600',
        'B6010', 'B6011', 'B6012', 'B6013', 'B6019', 'B602', 'B608', 'B64', 'B781', 'B9689',
        'E832', 'H66001', 'H66002', 'H66003', 'H66004', 'H66005', 'H66006', 'H66007', 'H66009',
        'H66011', 'H66012', 'H66013', 'H66014', 'H66015', 'H66016', 'H66017', 'H66019', 'H6610',
        'H6611', 'H6612', 'H6613', 'H6620', 'H6621', 'H6622', 'H6623', 'H663X1', 'H663X2',
        'H663X3', 'H663X9', 'H6640', 'H6641', 'H6642', 'H6643', 'H6690', 'H6691', 'H6692', 'H6693',
        'H671', 'H672', 'H673', 'H679', 'H70001', 'H70002', 'H70003', 'H70009', 'H70011', 'H70012',
        'H70013', 'H70019', 'H70091', 'H70092', 'H70093', 'H70099', 'H7010', 'H7011', 'H7012',
        'H7013', 'H70201', 'H70202', 'H70203', 'H70209', 'H70211', 'H70212', 'H70213', 'H70219',
        'H70221', 'H70222', 'H70223', 'H70229', 'H70811', 'H70812', 'H70813', 'H70819', 'H70891',
        'H70892', 'H70893', 'H70899', 'H7090', 'H7091', 'H7092', 'H7093', 'H9500', 'H9501',
        'H9502', 'H9503', 'H95111', 'H95112', 'H95113', 'H95119', 'H95121', 'H95122', 'H95123',
        'H95129', 'H95131', 'H95132', 'H95133', 'H95139', 'H95191', 'H95192', 'H95193', 'H95199',
        'H9521', 'H9522', 'H9531', 'H9532', 'H9541', 'H9542', 'H9551', 'H9552', 'H9553', 'H9554',
        'H95811', 'H95812', 'H95813', 'H95819', 'H9588', 'H9589', 'J0100', 'J0101', 'J0110',
        'J0111', 'J0120', 'J0121', 'J0130', 'J0131', 'J0140', 'J0141', 'J0180', 'J0181', 'J0190',
        'J0191', 'J020', 'J028', 'J029', 'J0300', 'J0301', 'J0380', 'J0381', 'J0390', 'J0391',
        'J0410', 'J0411', 'J042', 'J050', 'J0510', 'J0511', 'J13', 'J14', 'J150', 'J151', 'J1520',
        'J15211', 'J15212', 'J1529', 'J153', 'J154', 'J155', 'J156', 'J157', 'J158', 'J159',
        'J160', 'J168', 'J17', 'J180', 'J181', 'J188', 'J189', 'J200', 'J201', 'J202', 'J320',
        'J321', 'J322', 'J323', 'J324', 'J328', 'J329', 'J3501', 'J3502', 'J3503', 'J351', 'J352',
        'J353', 'J358', 'J359', 'J387', 'J390', 'J391', 'J392', 'J398', 'J399', 'K122', 'L0100',
        'L0101', 'L0102', 'L0103', 'L0109', 'L011', 'L03011', 'L03012', 'L03019', 'L03021',
        'L03022', 'L03029', 'L03031', 'L03032', 'L03039', 'L03041', 'L03042', 'L03049', 'L03111',
        'L03112', 'L03113', 'L03114', 'L03115', 'L03116', 'L03119', 'L03121', 'L03122', 'L03123',
        'L03124', 'L03125', 'L03126', 'L03129', 'L03211', 'L03212', 'L03213', 'L03221', 'L03222',
        'L03311', 'L03312', 'L03313', 'L03314', 'L03315', 'L03316', 'L03317', 'L03319', 'L03321',
        'L03322', 'L03323', 'L03324', 'L03325', 'L03326', 'L03327', 'L03329', 'L03811', 'L03818',
        'L03891', 'L03898', 'L0390', 'L0391', 'L040', 'L041', 'L042', 'L043', 'L048', 'L049',
        'L081', 'L0881', 'L0882', 'L0889', 'L089', 'L88', 'L928', 'L980', 'L983', 'M4620', 'M4621',
        'M4622', 'M4623', 'M4624', 'M4625', 'M4626', 'M4627', 'M4628', 'M4630', 'M4631', 'M4632',
        'M4633', 'M4634', 'M4635', 'M4636', 'M4637', 'M4638', 'M4639', 'M8900', 'M89011', 'M89012',
        'M89019', 'M89021', 'M89022', 'M89029', 'M89031', 'M89032', 'M89039', 'M89041', 'M89042',
        'M89049', 'M89051', 'M89052', 'M89059', 'M89061', 'M89062', 'M89069', 'M89071', 'M89072',
        'M89079', 'M8908', 'M8909', 'M89121', 'M89122', 'M89123', 'M89124', 'M89125', 'M89126',
        'M89127', 'M89128', 'M89129', 'M89131', 'M89132', 'M89133', 'M89134', 'M89138', 'M89139',
        'M89151', 'M89152', 'M89153', 'M89154', 'M89155', 'M89156', 'M89157', 'M89158', 'M89159',
        'M89160', 'M89161', 'M89162', 'M89163', 'M89164', 'M89165', 'M89166', 'M89167', 'M89168',
        'M89169', 'M8918', 'M8920', 'M89211', 'M89212', 'M89219', 'M89221', 'M89222', 'M89229',
        'M89231', 'M89232', 'M89233', 'M89234', 'M89239', 'M89241', 'M89242', 'M89249', 'M89251',
        'M89252', 'M89259', 'M89261', 'M89262', 'M89263', 'M89264', 'M89269', 'M89271', 'M89272',
        'M89279', 'M8928', 'M8929', 'M8930', 'M89311', 'M89312', 'M89319', 'M89321', 'M89322',
        'M89329', 'M89331', 'M89332', 'M89333', 'M89334', 'M89339', 'M89341', 'M89342', 'M89349',
        'M89351', 'M89352', 'M89359', 'M89361', 'M89362', 'M89363', 'M89364', 'M89369', 'M89371',
        'M89372', 'M89379', 'M8938', 'M8939', 'M8940', 'M89411', 'M89412', 'M89419', 'M89421',
        'M89422', 'M89429', 'M89431', 'M89432', 'M89439', 'M89441', 'M89442', 'M89449', 'M89451',
        'M89452', 'M89459', 'M89461', 'M89462', 'M89469', 'M89471', 'M89472', 'M89479', 'M8948',
        'M8949', 'M8950', 'M89511', 'M89512', 'M89519', 'M89521', 'M89522', 'M89529', 'M89531',
        'M89532', 'M89539', 'M89541', 'M89542', 'M89549', 'M89551', 'M89552', 'M89559', 'M89561',
        'M89562', 'M89569', 'M89571', 'M89572', 'M89579', 'M8958', 'M8959', 'M8960', 'M89611',
        'M89612', 'M89619', 'M89621', 'M89622', 'M89629', 'M89631', 'M89632', 'M89639', 'M89641',
        'M89642', 'M89649', 'M89651', 'M89652', 'M89659', 'M89661', 'M89662', 'M89669', 'M89671',
        'M89672', 'M89679', 'M8968', 'M8969', 'M8970', 'M89711', 'M89712', 'M89719', 'M89721',
        'M89722', 'M89729', 'M89731', 'M89732', 'M89739', 'M89741', 'M89742', 'M89749', 'M89751',
        'M89752', 'M89759', 'M89761', 'M89762', 'M89769', 'M89771', 'M89772', 'M89779', 'M8978',
        'M8979', 'M898X0', 'M898X1', 'M898X2', 'M898X3', 'M898X4', 'M898X5', 'M898X6', 'M898X7',
        'M898X8', 'M898X9', 'M899', 'M9080', 'M90811', 'M90812', 'M90819', 'M90821', 'M90822',
        'M90829', 'M90831', 'M90832', 'M90839', 'M90841', 'M90842', 'M90849', 'M90851', 'M90852',
        'M90859', 'M90861', 'M90862', 'M90869', 'M90871', 'M90872', 'M90879', 'M9088', 'M9089',
        'N10', 'N110', 'N111', 'N118', 'N119', 'N12', 'N130', 'N136', 'N151', 'N16', 'N2884',
        'N2885', 'N2886', 'N3000', 'N3001', 'N3010', 'N3011', 'N3020', 'N3021', 'N3030', 'N3031',
        'N3040', 'N3041', 'N3080', 'N3081', 'N3090', 'N3091', 'N390', 'N410', 'N411', 'N412',
        'N413', 'N414', 'N418', 'N419', 'N7001', 'N7002', 'N7003', 'N7011', 'N7012', 'N7013',
        'N7091', 'N7092', 'N7093', 'N710', 'N711', 'N719', 'N72', 'N730', 'N731', 'N732', 'N733',
        'N734', 'N735', 'N736', 'N738', 'N739', 'N74', 'N750', 'N751', 'N758', 'N759', 'N760',
        'N761', 'N762', 'N763', 'N764', 'N765', 'N766', 'N7681', 'N7689', 'N770', 'N771', 'Z202',
        'Z224'
    }

    SNOMEDCT = {
        '10188004', '102452004', '102453009', '102455002', '10271000175107', '10281000175105',
        '10291000175108', '10301000175109', '10311000175107', '10321002', '10345003', '10351008',
        '105628008', '105629000', '105977003', '10625271000119109', '10625431000119105',
        '10625551000119103', '10625711000119105', '10628231000119100', '10628271000119102',
        '10628311000119102', '10628351000119101', '10629231000119109', '10629271000119107',
        '10631151000119107', '10631191000119102', '10631911000119108', '10631951000119109',
        '10632591000119103', '10632631000119103', '10633111000119105', '10633151000119106',
        '10633351000119109', '10633391000119104', '10633671000119105', '10633791000119100',
        '10633831000119106', '10633871000119109', '10633911000119107', '10633951000119108',
        '10679007', '1077351000119104', '1077371000119108', '1077531000119100', '1077541000119109',
        '1077551000119106', '1077561000119108', '1077571000119102', '1077591000119101',
        '1077611000119106', '1077621000119104', '1077631000119101', '1077641000119105',
        '1077651000119107', '1077661000119109', '1077711000119104', '1077721000119106',
        '1077731000119109', '1077741000119100', '1077751000119103', '1077761000119101',
        '1077791000119108', '1077801000119109', '1077811000119107', '1077821000119100', '10809006',
        '1082721000119101', '1082931000119101', '1082981000119100', '1083101000119102',
        '1083111000119104', '1083641000119106', '1083691000119103', '1083991000119106',
        '1084271000119103', '1086191000119101', '1086241000119101', '1087021000119101',
        '1087041000119107', '1087051000119109', '1088221000119108', '1088231000119106',
        '1088821000119109', '1089041000119102', '1089661000119108', '1090401000119104',
        '1090731000119101', '1090831000119108', '1091431000119103', '1091651000119106',
        '1092271000119106', '1092371000119103', '109242000', '109243005', '109244004', '109245003',
        '109246002', '109247006', '1092951000119106', '109302008', '109303003', '109304009',
        '109305005', '109306006', '109307002', '109308007', '109309004', '109310009', '109311008',
        '109312001', '109313006', '109314000', '109316003', '109317007', '109318002', '109319005',
        '109320004', '109321000', '109322007', '109323002', '109324008', '109325009', '109326005',
        '109327001', '109328006', '109329003', '109330008', '109331007', '109332000', '109362006',
        '109602002', '109603007', '109604001', '109611002', '109612009', '109631003', '109686002',
        '109687006', '109688001', '109689009', '109690000', '109691001', '109692008', '109693003',
        '109694009', '109695005', '109696006', '109697002', '109781001', '109782008', '109783003',
        '109784009', '109792000', '109802000', '109810004', '109811000', '10982004', '109867008',
        '109909008', '109910003', '110041000119104', '110091000119107', '1107004', '111183001',
        '111184007', '111274000', '111275004', '11134001', '111367007', '111409009', '111414008',
        '111418006', '111538005', '111806005', '111807001', '111816002', '111839008', '111843007',
        '111900000', '111911008', '111912001', '111938001', '111939009', '11251000', '11338007',
        '11461005', '114881000119108', '11648002', '11840006', '11906007', '119371000119100',
        '12062007', '12115003', '12232008', '12243301000119100', '12243431000119101', '123587001',
        '123588006', '123589003', '123590007', '123591006', '123611003', '123613000', '12373006',
        '123754002', '123755001', '123951002', '12463005', '124691000119101', '12713001',
        '127217009', '128045006', '1282001', '128220004', '128222007', '128276007', '128277003',
        '128278008', '128279000', '128280002', '128281003', '128282005', '128711000119106',
        '12890007', '129128006', '129452008', '129563009', '129670002', '13095005', '13125003',
        '13177009', '13272007', '13285005', '13301002', '13310005', '13325005', '13386009',
        '13680009', '13731006', '13802001', '14053009', '1415005', '14248008', '14343001',
        '14405000', '14488001', '14800001', '14948001', '15033003', '151004', '15170009',
        '1532007', '15363000', '1551001', '15607007', '15628003', '15694521000119107',
        '15694561000119102', '15696921000119108', '15696961000119103', '15697121000119108',
        '15697161000119103', '15697361000119100', '15697441000119106', '15697481000119101',
        '15697521000119101', '15805002', '15865061000119102', '15866491000119109',
        '15866531000119109', '15916831000119102', '15981911000119105', '15981951000119106',
        '15981991000119101', '16005551000119105', '16005591000119100', '16030311000119102',
        '16030511000119107', '16036000', '16070004', '16077211000119109', '16077291000119100',
        '16119006', '16217981000119107', '16271000119108', '16300007', '16311000119108',
        '16486000', '16594005', '16688081000119109', '16751003', '17028003', '17133001', '172001',
        '1723008', '17305005', '17354003', '17357005', '17716001', '17732003', '17741008',
        '179101003', '18081009', '18099001', '181007', '186090001', '186105003', '186116005',
        '186150001', '186342000', '186431008', '186537009', '186675001', '186729003', '186731007',
        '186825001', '186826000', '186833000', '186842007', '186846005', '186847001', '186850003',
        '186854007', '186861006', '186863009', '186867005', '186868000', '186875004', '186877007',
        '186878002', '186899004', '186903006', '186915005', '186931002', '186939000', '186946009',
        '187017007', '188463006', '18900005', '189312004', '192008', '19206003', '19213003',
        '19240003', '192647003', '19272000', '19284003', '19290004', '19360008', '193786000',
        '194005002', '194281003', '194282005', '194286008', '194287004', '194288009', '194289001',
        '194290005', '194339007', '19457002', '19471005', '194907008', '194947001', '195655000',
        '195656004', '195657008', '195658003', '195659006', '195660001', '195662009', '195666007',
        '195668008', '195669000', '195670004', '195671000', '195672007', '195673002', '195676005',
        '195677001', '195717003', '195719000', '195720006', '195721005', '195722003', '195725001',
        '195726000', '195727009', '195728004', '195729007', '195739001', '195756009', '195798007',
        '195811008', '195812001', '195813006', '195836002', '195878008', '195881003', '195886008',
        '195888009', '195889001', '195896004', '195902009', '196067009', '196107009', '196108004',
        '196109007', '196112005', '196339009', '196341005', '196538002', '19670002', '197162007',
        '197163002', '197172005', '197176008', '197177004', '197178009', '197179001', '197180003',
        '197305002', '197324004', '197326002', '197327006', '197328001', '197329009', '197330004',
        '197347003', '197348008', '197757004', '197760006', '197761005', '197762003', '197763008',
        '197764002', '197768004', '197769007', '197770008', '197782004', '197834003', '197837005',
        '197845000', '197848003', '197849006', '197850006', '197853008', '197926005', '197927001',
        '197928006', '197963001', '197964007', '197965008', '197966009', '197967000', '197968005',
        '198130006', '198133008', '198135001', '198136000', '198137009', '198138004', '198141008',
        '198142001', '198143006', '198156004', '198159006', '198160001', '198161002', '198175009',
        '198176005', '198179003', '198180000', '198182008', '198183003', '198184009', '198185005',
        '198186006', '198188007', '198189004', '198199009', '198203009', '198206001', '198216009',
        '198217000', '198218005', '198219002', '198227006', '198230004', '198231000', '198235009',
        '198236005', '198241002', '198242009', '198824009', '19905009', '199111004', '199154009',
        '199156006', '199157002', '199158007', '199159004', '199161008', '199163006', '199164000',
        '199165004', '199166003', '199205008', '199206009', '19956000', '200181000', '200182007',
        '200185009', '200187001', '20025003', '200628009', '200630006', '200638004', '200645004',
        '200648002', '200649005', '200650005', '200651009', '200652002', '200655000', '200656004',
        '200657008', '200658003', '200659006', '200660001', '200661002', '200662009', '200663004',
        '200666007', '200667003', '200668008', '200669000', '200670004', '200674008', '200676005',
        '200678006', '200679003', '200680000', '200681001', '200682008', '200686006', '200687002',
        '200697006', '200698001', '200699009', '200704001', '200706004', '200707008', '200708003',
        '200709006', '200718008', '200722003', '200744008', '200751004', '200755008', '201517005',
        '202933002', '203153007', '203157008', '203158003', '203159006', '203160001', '203161002',
        '203162009', '203163004', '203164005', '203165006', '203166007', '203167003', '203168008',
        '203169000', '203170004', '203171000', '203172007', '203173002', '203174008', '203175009',
        '203177001', '203178006', '203179003', '203184009', '203185005', '203186006', '203189004',
        '203193005', '203194004', '203195003', '203196002', '203197006', '203198001', '203199009',
        '203200007', '203201006', '203202004', '203221007', '203222000', '203241002', '203245006',
        '203249000', '203250000', '203251001', '203256006', '203257002', '203258007', '203259004',
        '203260009', '203296008', '203297004', '203298009', '203299001', '203300009', '20547008',
        '205717001', '206358003', '20735004', '207615004', '208545005', '20932005', '20943002',
        '21060003', '21061004', '21092002', '21120002', '21186006', '212438008', '21523006',
        '21711003', '21780009', '21955004', '220145006', '222008', '22352007', '22386003',
        '22399000', '22475001', '22557000', '22754005', '22775002', '230150008', '230152000',
        '230182006', '230194002', '230216007', '230402000', '230563005', '230605007', '230735006',
        '23160005', '23166004', '231796003', '231802001', '231858009', '232212002', '232214001',
        '232215000', '232251007', '232260004', '232268006', '232269003', '232270002', '232271003',
        '232313005', '232314004', '232363000', '232367004', '232391008', '232393006', '232394000',
        '232395004', '232397007', '232399005', '232400003', '232420002', '232432003', '232433008',
        '23259007', '233598009', '233599001', '233600003', '233601004', '233602006', '233603001',
        '233604007', '233606009', '233607000', '233608005', '233609002', '233613009', '233617005',
        '233618000', '233620002', '233621003', '233622005', '233623000', '233624006', '233625007',
        '233728004', '233730002', '233731003', '233785003', '233849007', '234017002', '234091000',
        '234093002', '234096005', '235002009', '23502006', '235032001', '235062007', '235064008',
        '235065009', '23550005', '235726002', '235747003', '235748008', '235749000', '235774002',
        '235795007', '235861001', '235863003', '235984009', '235994004', '235996002', '235997006',
        '236063005', '236066002', '236302005', '236373001', '236376009', '236377000', '236378005',
        '236379002', '23640001', '236599009', '236600007', '236620008', '236622000', '236623005',
        '236624004', '236625003', '236626002', '236627006', '236628001', '236629009', '236630004',
        '236672003', '236673008', '236682002', '236683007', '236687008', '236689006', '236702008',
        '236703003', '236706006', '236766009', '236772009', '237037006', '237038001', '237039009',
        '237040006', '237042003', '237043008', '237044002', '237045001', '237046000', '237051006',
        '237069002', '237083000', '237084006', '237085007', '237091009', '237093007', '237094001',
        '237095000', '237096004', '237097008', '237103001', '237104007', '237106009', '237124006',
        '237446005', '237447001', '23754003', '238374001', '238375000', '238376004', '238377008',
        '238381008', '238386003', '238387007', '238388002', '238391002', '238395006', '238396007',
        '238398008', '238401006', '238404003', '238405002', '238406001', '238419002', '2385003',
        '238669003', '23874000', '23884004', '238921004', '238931006', '238985006', '2390000',
        '239162003', '2396006', '23975003', '239785008', '239808004', '240039005', '240142002',
        '240143007', '240147008', '240148003', '240149006', '240150006', '240151005', '240152003',
        '240349003', '240350003', '240351004', '240357000', '240365002', '240367005', '240368000',
        '240369008', '240370009', '240371008', '240372001', '240374000', '240375004', '240414006',
        '240444009', '240452007', '240453002', '240455009', '240456005', '240457001', '240458006',
        '240547000', '240552005', '240553000', '240554006', '240555007', '240556008', '240557004',
        '240558009', '240560006', '240562003', '240563008', '240564002', '240565001', '240566000',
        '240567009', '240568004', '240569007', '240571007', '240572000', '240573005', '240574004',
        '240575003', '240576002', '240577006', '240578001', '240579009', '240581006', '240582004',
        '240583009', '240584003', '240589008', '240602008', '240603003', '240604009', '240635003',
        '240668005', '240669002', '240670001', '240671002', '240721007', '240736005', '240780005',
        '240802005', '24232008', '24288004', '24347001', '24520005', '24557004', '246956006',
        '24738006', '247517004', '24789006', '24868007', '249458000', '249463001', '251331003',
        '2523007', '25764005', '26039008', '26135000', '262461007', '26249004', '26330000',
        '26466000', '26535009', '266071000', '266077001', '266123003', '266125005', '266126006',
        '266127002', '266128007', '266130009', '266133006', '266136003', '266138002', '266160004',
        '266162007', '266337001', '266350000', '266439004', '266463007', '26650005', '266564004',
        '266581008', '267759006', '267777001', '267778006', '267779003', '267780000', '267783003',
        '268016009', '268017000', '268018005', '268019002', '26883000', '270490007', '27174002',
        '272006008', '272262003', '27278006', '274081004', '274109003', '27420004', '27438001',
        '27460003', '275376007', '275412000', '275433009', '275495004', '27561001', '27648007',
        '276677001', '276679003', '276700005', '27681008', '276877003', '27767004', '277678003',
        '277869007', '27787003', '278037002', '278068003', '27810000', '27836007', '278480000',
        '278481001', '278486006', '278516003', '27858009', '27916005', '279499002', '280483007',
        '280486004', '281801000009108', '28198007', '283876006', '283877002', '28438004',
        '28572009', '28593007', '28653000', '286870008', '286977005', '286985001', '287000004',
        '287001000', '287002007', '287050006', '287052003', '287053008', '287055001', '287056000',
        '28709001', '28769004', '28783002', '288242005', '289510007', '29500006', '29608009',
        '297139009', '29864006', '29909004', '30080002', '300999006', '301000005', '301001009',
        '301002002', '301003007', '301004001', '301010001', '301011002', '301012009', '301013004',
        '30168008', '301706005', '301710008', '301711007', '301769001', '301771001', '301802001',
        '301824001', '301990003', '30239003', '302813001', '302911003', '3038009', '30406004',
        '30493003', '30584002', '3059002', '30635002', '307230004', '307231000', '307310000',
        '307423008', '307424002', '307425001', '307426000', '307534009', '30800001', '30806007',
        '308119005', '30833006', '308660004', '308661000', '308906005', '309083007', '309254003',
        '31015008', '3110003', '31137003', '312088007', '312099009', '312108008', '312109000',
        '312124009', '31218002', '312221005', '312342009', '312371005', '312400008', '312422001',
        '312934004', '312955002', '31302006', '31309002', '313352002', '31354001', '31412003',
        '314213003', '314214009', '314630009', '31474007', '314840009', '314978007', '315596001',
        '315597005', '31561003', '315826004', '316841006', '31999004', '32021005', '32038009',
        '32141002', '32263004', '32286006', '32298001', '32392003', '32527003', '32580004',
        '32582007', '32636009', '32701000', '32735002', '32801008', '328488009', '32923006',
        '329489009', '33028007', '33134003', '3321001', '33261009', '333501000119103', '335846001',
        '33655002', '33781009', '339111000119109', '33924006', '33937009', '34020007', '34242002',
        '344861000119102', '34543006', '347641000119105', '347671000119103', '34790005',
        '348111000119104', '348561000119109', '348571000119103', '349001000119106',
        '349011000119109', '349021000119102', '349031000119104', '349041000119108',
        '349051000119105', '349141000119107', '34997001', '3502005', '35037009', '3507004',
        '35168006', '35246005', '35255008', '35339003', '35377009', '35526001', '35542008',
        '35585004', '35708002', '35742006', '35876006', '3589003', '35923002', '35958000',
        '359613008', '359662008', '35974005', '359749002', '359751003', '360425009', '360595002',
        '36139001', '36188001', '36276008', '36281004', '3633001', '363746003', '36529003',
        '36616006', '36689008', '366941000119107', '36699003', '367171000119100', '36742000',
        '367504009', '367661000119102', '367671000119108', '36789003', '368371000119102',
        '36857002', '368971000119101', '368991000119100', '369001000119100', '369011000119102',
        '37028008', '370518000', '37098000', '371061003', '371237000', '371318006', '37133005',
        '371423007', '371551001', '37223007', '373135009', '373611003', '37430004', '37610005',
        '37649008', '37754005', '37830006', '37936001', '37948003', '38099005', '38176009',
        '38217004', '38297003', '385093006', '38523005', '38541002', '386034005', '38699009',
        '387665005', '387681000', '387682007', '387754006', '38822007', '388602007', '388604008',
        '38898003', '388982007', '388983002', '38961000', '38976008', '39085002', '390897008',
        '39120007', '39172002', '39341005', '396285007', '396286008', '39747007', '397810006',
        '398319002', '398570005', '399102002', '399183005', '3999002', '40055000', '4009004',
        '40113007', '40149008', '4016003', '4022007', '402201001', '402314003', '402338004',
        '402375009', '402437008', '402715000', '402797009', '402825002', '402828000', '402890001',
        '402896007', '402927009', '402928004', '402929007', '402930002', '402931003', '402935007',
        '402939001', '402940004', '402941000', '402942007', '402943002', '402944008', '402945009',
        '402946005', '402947001', '402949003', '402950003', '402951004', '402956009', '402957000',
        '402958005', '403475002', '403477005', '403478000', '403479008', '403480006', '403565003',
        '403702001', '403961004', '404174000', '40458008', '405547004', '405548009', '405554005',
        '405562002', '405635002', '405950009', '405951008', '40635000', '406563003', '406581000',
        '406617004', '406618009', '407523005', '40766000', '407671000', '4082005', '408386002',
        '408679000', '408680002', '408682005', '409557008', '409648008', '409662001', '409664000',
        '409665004', '40970001', '409778008', '409780002', '410470003', '410472006', '410473001',
        '410474007', '410475008', '410478005', '41174002', '41207000', '41269000', '41381004',
        '414529006', '414530001', '415125002', '415141001', '41545003', '415724006', '41582007',
        '415822001', '416205001', '41700004', '417484006', '41789000', '4181000119109',
        '418103007', '41910004', '419468003', '41954005', '419760006', '420544002', '420687005',
        '420787001', '420910002', '421047005', '421224000', '421454008', '421508002', '421671002',
        '42231000009109', '422747000', '4232007', '423322005', '423590009', '424551004',
        '42522007', '425464007', '425548001', '425562008', '425996009', '426121003', '426135001',
        '426137009', '426165006', '426247003', '426507006', '426637005', '426696003', '42680007',
        '426836003', '426874006', '427307004', '42746002', '427537009', '42770003', '427786008',
        '427787004', '427788009', '427909005', '428015005', '428091000', '428193004', '428230005',
        '428252001', '428783003', '428874003', '429437003', '429767005', '430065009', '430395005',
        '430402003', '430404002', '430616003', '43114002', '431189009', '431231008', '431238002',
        '431261000', '431262007', '431308006', '431309003', '431467003', '4316006', '431709001',
        '431737008', '4324001', '432481004', '432992007', '435141000124102', '435201000124109',
        '43522000', '4359001', '43636000', '43830008', '43878008', '441590008', '441658007',
        '441942006', '442094008', '442506007', '44323002', '443769009', '44412000', '444150000',
        '44428005', '444646006', '444760002', '444820005', '444834005', '445063003', '445096001',
        '445102008', '445130008', '445152004', '445323009', '445408000', '445470006', '445506004',
        '44568006', '445918001', '446122002', '446292002', '446328009', '446543007', '446642005',
        '446672004', '446752000', '446754004', '446755003', '446756002', '446926000', '446988001',
        '447044003', '447045002', '447102007', '447222001', '447282003', '447353001', '447354007',
        '447372001', '447386002', '447399004', '447402003', '44743006', '4483005', '44897000',
        '449671007', '449702005', '449710006', '449711005', '449717009', '449825003', '45022008',
        '450331000124101', '450341000124106', '45058001', '450761000124106', '450991000124101',
        '45312009', '45377007', '45629003', '45816000', '46235002', '46442004', '46536000',
        '46689006', '46699001', '46799006', '46876003', '46970008', '47132003', '47493003',
        '47756005', '47941007', '48036004', '48142003', '48153009', '48277006', '48278001',
        '4834000', '48503007', '48573006', '48631008', '48982009', '49249007', '49258000',
        '49298003', '49308005', '49558004', '49736003', '49810002', '49908003', '49923008',
        '5028002', '50528008', '50675000', '5075002', '50804000', '5085001', '5093001', '50970007',
        '51030006', '51036000', '51152000', '51209006', '51211002', '51254007', '51530003',
        '51707007', '51928006', '51960003', '52123000', '52190008', '52404001', '52414005',
        '52441000', '52478002', '52979002', '53084003', '53098006', '53116008', '53200002',
        '53277000', '53396004', '53453008', '53502009', '53529004', '53664003', '53991003',
        '54026009', '54069001', '54084005', '54138003', '54274001', '54287007', '54389007',
        '54672007', '54825009', '55023005', '55069005', '55083007', '55184003', '55399009',
        '55551005', '55679008', '55768006', '56118002', '56321006', '56351000', '56644003',
        '56728002', '56937005', '57027007', '57468008', '57540006', '57593007', '57702005',
        '57725006', '58031004', '58056005', '58196009', '58227000', '58392004', '58763001',
        '58764007', '58890000', '5891000119102', '58945008', '58949002', '58964002', '59211000',
        '59221008', '59233003', '59307008', '59475000', '59530001', '59532009', '59707005',
        '59721007', '59867002', '59883002', '59934002', '59967003', '60130002', '60165002',
        '60168000', '6033008', '60335002', '60350006', '60485005', '60528006', '60540006',
        '60684003', '60777000', '60867007', '60893000', '60967006', '61011009', '61048000',
        '61500009', '61585002', '61612001', '61711004', '61884008', '6212009', '62199007',
        '62207008', '62224002', '62394006', '6267005', '62819009', '62837005', '6284004',
        '62861003', '63064000', '63140003', '63144007', '63302006', '63375009', '63475008',
        '63627007', '63650001', '63751007', '63870005', '63922003', '64102008', '64150007',
        '64366002', '64369009', '64375000', '64479007', '64532005', '64576003', '64667001',
        '64703005', '64740002', '64880000', '64917006', '64956000', '65049003', '65095005',
        '65295003', '65363002', '65875003', '65967008', '65974003', '65984002', '66011008',
        '66160001', '66281009', '66429007', '66622006', '66634003', '66887000', '66918004',
        '66993009', '67125004', '67167008', '67224007', '67277002', '67322009', '67391006',
        '67525007', '67624004', '67667007', '67685000', '67832005', '67878002', '67915005',
        '6803002', '6815003', '68226007', '68272006', '68389001', '68409003', '68566005',
        '68640004', '68764005', '68843000', '6887003', '69430001', '69588003', '69595007',
        '69643006', '69651009', '69810009', '70036007', '700372006', '70120007', '702715008',
        '70385007', '7063008', '70637004', '7066000', '70718000', '707208009', '70759006',
        '7079009', '708031000', '70880006', '71085009', '71186008', '71255007', '712861006',
        '712867005', '713084008', '713249002', '713251003', '713261005', '71332006', '713453003',
        '713454009', '713544008', '713546005', '713570009', '7138005', '713886006', '71392009',
        '714985003', '715065007', '715507005', '716860005', '71746008', '717697005', '717723007',
        '718373005', '71906005', '719218000', '71926009', '719376008', '719755001', '720751000',
        '72083004', '72102005', '721102001', '721250007', '721269002', '721591008', '721592001',
        '721657003', '721658008', '721659000', '721681005', '721682003', '721683008', '721684002',
        '721745002', '721771003', '721807009', '721808004', '721817004', '72222004', '72225002',
        '72249004', '722541007', '722830001', '722855007', '72369006', '723736005', '723880004',
        '723884008', '724015007', '724498004', '724499007', '724500003', '724533008', '724534002',
        '7253006', '725916003', '725917007', '72605008', '72656004', '7272006', '72815004',
        '72899006', '72934000', '72940007', '73237007', '7329003', '733051000', '733148009',
        '733150001', '733153004', '733154005', '733161009', '733165000', '733166004', '733172004',
        '73345000', '73414003', '73452002', '735425008', '735486007', '735487003', '735488008',
        '735489000', '735490009', '735491008', '735514001', '735515000', '735520000', '735554004',
        '735591005', '735619000', '735620006', '735740009', '736004', '736524004', '736686006',
        '736909000', '737147003', '737166003', '737167007', '737206009', '737345002', '73806001',
        '73962000', '73970005', '7415003', '74181004', '74372003', '74445007', '7448003',
        '74578003', '74598008', '74945001', '75100008', '75119003', '75286007', '75299005',
        '75375008', '7548000', '75498004', '75530006', '75548002', '75570004', '75585005',
        '75632007', '75817003', '7587000', '75886002', '75947000', '75993002', '76035004',
        '76047005', '76090006', '76126009', '76151005', '762257007', '762259005', '762276009',
        '762283002', '762284008', '762530009', '762693003', '762694009', '76272004', '76366001',
        '763888005', '7640004', '76549002', '76623002', '76653009', '7678002', '76782002',
        '76802005', '77028001', '77054009', '77106003', '77116006', '77360001', '77863005',
        '77919000', '77939001', '78182002', '78420004', '78620007', '78623009', '78973009',
        '78996009', '7910003', '79216009', '79411002', '79560005', '80375002', '80388004',
        '80437003', '80507005', '80600003', '80604007', '80640009', '80645004', '80770009',
        '81020007', '8107007', '81096007', '81125004', '81164001', '81339006', '81521003',
        '81598001', '82053000', '82126001', '82127005', '82323002', '82355002', '8258000',
        '82670009', '827006', '82770004', '82930004', '82959004', '83271005', '83412009',
        '83707009', '83774001', '83883001', '8414002', '84194006', '84224006', '84233008',
        '84261000119106', '84414000', '84490005', '84681008', '84724007', '84753008', '84889008',
        '85051008', '8519009', '85224001', '8549006', '85495007', '8555001', '85857008',
        '85884009', '85904008', '86028001', '86070006', '86279000', '8628002', '86443005',
        '86479002', '86615009', '86709000', '87073000', '87117006', '8725005', '87282003',
        '87318008', '87415007', '87665008', '87696004', '8771003', '87728001', '8776008',
        '87815001', '88027004', '88157006', '88220006', '88361008', '8838005', '88547002',
        '8872002', '88813005', '88850006', '88943008', '88981003', '8912009', '89194009',
        '8954007', '89637003', '89933001', '90206003', '90271007', '9091006', '90979004',
        '91038008', '91155009', '91195006', '91538002', '91541006', '91554004', '91669008',
        '91862002', '9241004', '9516007', '95220008', '95423008', '95424002', '95425001',
        '9557000', '95593001', '95679004', '95746006', '95811009', '95886009', '95889002',
        '96171000119103', '9713002', '987007', '9941009'
    }


class AntidepressantMedication(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent antidepressant medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Active or Medication, Dispensed.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; prescribable. Includes only relevant concepts associated with antidepressant medication. This is a grouping of RxNorm codes.
    Exclusion Criteria: Excludes branded drugs; components or ingredients only; non-prescribable.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1213'
    VALUE_SET_NAME = 'Antidepressant Medication'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1000048', '1000054', '1000058', '1000064', '1000070', '1000076', '1000097', '104837',
        '1086772', '1086778', '1086784', '1098649', '1098666', '1098670', '1098674', '1098678',
        '1099288', '1099292', '1099296', '1099300', '1099304', '1099316', '1190110', '1232585',
        '1298803', '1298857', '1298861', '1298870', '1430122', '1433217', '1433227', '1433233',
        '1433239', '1439808', '1439810', '1439812', '1439840', '1607617', '1738483', '1738495',
        '1738503', '1738511', '1738515', '1738519', '1738523', '1738527', '1738803', '1738805',
        '1738807', '1801289', '1874553', '1874559', '197363', '197364', '197365', '197366',
        '198045', '198046', '198047', '199283', '199820', '200371', '248642', '251200', '283406',
        '283407', '283485', '283672', '309313', '309314', '310384', '310385', '310386', '311725',
        '311726', '312036', '312242', '312347', '312938', '312940', '312941', '313447', '313496',
        '313497', '313498', '313499', '313580', '313581', '313582', '313583', '313584', '313585',
        '313586', '313989', '313990', '313995', '314111', '314277', '317136', '349332', '351249',
        '351250', '351285', '403969', '403970', '403971', '403972', '476809', '596926', '596930',
        '596934', '616402', '721787', '790264', '790288', '794947', '808744', '808748', '808751',
        '808753', '835564', '835568', '835572', '835577', '835589', '835591', '835593', '856364',
        '856369', '856373', '856377', '856706', '856720', '856762', '856769', '856773', '856783',
        '856792', '856797', '856825', '856834', '856840', '856845', '856853', '857291', '857296',
        '857297', '857301', '857305', '857315', '859186', '859190', '859193', '861064', '865206',
        '865210', '865214', '898697', '898704', '903873', '903879', '903884', '903887', '903891',
        '905168', '905172', '993503', '993518', '993536', '993541', '993550', '993557', '993567',
        '993681', '993687', '993691'
    }


class VascularDisordersOfIrisAndCiliaryBody(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of vascular disorders of iris and ciliary body.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of a vascular disorder or the iris and/or ciliary body, including rubeosis iridis.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1445'
    VALUE_SET_NAME = 'Vascular Disorders of Iris and Ciliary Body'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H211X1', 'H211X2', 'H211X3'}

    ICD9CM = {'36442'}

    SNOMEDCT = {'193501009', '51995000'}


class HibVaccine3DoseScheduleAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures for haemophilus influenzae type b (Hib) vaccine administration (3-dose schedule).
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with haemophilus influenzae type b (Hib) vaccine administration codes (3-dose schedule). This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1084'
    VALUE_SET_NAME = 'HiB Vaccine (3 dose schedule) Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90647'}

    SNOMEDCT = {'127787002', '170343007', '170344001', '170345000', '170346004'}


class DialysisServices(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dialysis services.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with patients who had dialysis services.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1013'
    VALUE_SET_NAME = 'Dialysis Services'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '1019320', '90920', '90921', '90924', '90925', '90935', '90937', '90940', '90945', '90947',
        '90957', '90958', '90959'
    }

    HCPCS = {'G0257'}

    SNOMEDCT = {
        '108241001', '10848006', '11932001', '14684005', '180273006', '225230008', '225231007',
        '233575001', '233576000', '233577009', '233578004', '233579007', '233580005', '233581009',
        '233582002', '233583007', '233584001', '233585000', '233586004', '233587008', '233588003',
        '233589006', '233590002', '238316008', '238317004', '238318009', '238319001', '238321006',
        '238322004', '238323009', '265764009', '288182009', '302497006', '34897002', '427053002',
        '428648006', '439278006', '439976001', '57274006', '676002', '67970008', '68341005',
        '71192002', '714749008'
    }


class MorbidObesity(ValueSet):
    """

    Clinical Focus: This set of values focuses on morbid obesity codes.
    Data Element Scope: The intent of this data element is to identify morbid obesity and BMI's reflective of morbid obesity.
    Inclusion Criteria: Morbid obesity
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1164.65'
    VALUE_SET_NAME = 'Morbid Obesity'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'E6601', 'E662', 'Z6841', 'Z6842', 'Z6843', 'Z6844', 'Z6845'}


class DisordersOfTheImmuneSystem(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses affecting the working of the immune system, including disorders of the immunoglobulins and the complement system.
    Data Element Scope: This value set may use the Quality Data Model (QDM)category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnoses that indicate disorders of the immune system that can interfere with the bodies immune function.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.120.12.1001'
    VALUE_SET_NAME = 'Disorders of the Immune System'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'D800', 'D801', 'D802', 'D803', 'D804', 'D805', 'D806', 'D807', 'D808', 'D809', 'D810',
        'D811', 'D812', 'D814', 'D816', 'D817', 'D8189', 'D819', 'D820', 'D821', 'D822', 'D823',
        'D824', 'D828', 'D829', 'D830', 'D831', 'D832', 'D838', 'D839', 'D840', 'D841', 'D848',
        'D849', 'D893', 'D89810', 'D89811', 'D89812', 'D89813', 'D8982', 'D8989', 'D899'
    }

    SNOMEDCT = {
        '121121000119106', '121131000119109', '128631000119109', '18827005', '190979003',
        '190980000', '190981001', '190996002', '190997006', '190998001', '191001007', '191002000',
        '191011000', '191012007', '191013002', '191018006', '23238000', '234416002', '234532001',
        '234562007', '234593008', '234594002', '234595001', '234596000', '234597009', '234598004',
        '234599007', '234600005', '234601009', '234602002', '234603007', '234604001', '234605000',
        '234607008', '234608003', '234609006', '234611002', '234612009', '234613004', '234614005',
        '234615006', '234616007', '234617003', '234618008', '234619000', '234620006', '234621005',
        '234622003', '234623008', '234624002', '234625001', '234626000', '234627009', '234628004',
        '234629007', '234630002', '234631003', '234646005', '24419001', '24743004', '25109007',
        '263661007', '36070007', '39674000', '402355000', '402356004', '402357008', '402358003',
        '402360001', '403835002', '403836001', '403837005', '414029004', '426202004', '427167008',
        '442459007', '444547006', '449187006', '55602000', '702444009', '719156006', '720853005',
        '722067005', '81166004', '82286005', '82966003', '88714009'
    }


class Protriptyline(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent protriptyline medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; protriptyline only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; protriptyline in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1509'
    VALUE_SET_NAME = 'Protriptyline'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'905168', '905172'}


class TelephoneEvaluation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent telephone evaluations.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying evaluation and management services to a patient by telephone. This is a grouping of CPT codes.
    Exclusion Criteria: Excludes telephone evaluation and management services that last for less than five minutes.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1082'
    VALUE_SET_NAME = 'Telephone Evaluation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99441', '99442', '99443'}


class ChronicMalnutrition(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of chronic malnutrition.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes for specified and unspecified eating disorders. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes all diagnosis codes for feeding disorders of infancy or childhood. These include feeding disturbances, developmental delays, loss of appetite and rumination. Also excludes restrictive food intake disorders and pica.
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1036'
    VALUE_SET_NAME = 'Chronic Malnutrition'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'F5000', 'F5001', 'F5002', 'F502', 'F5082', 'F509', 'R630'}

    ICD9CM = {'3071', '30750', '30751', '30754', '30759', '7830'}

    SNOMEDCT = {
        '231522009', '231523004', '32721004', '427469003', '439960005', '56882008', '59645001',
        '63393005', '72366004', '77675002', '78004001'
    }


class ChlophedianolDexchlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlophedianol / dexchlorpheniramine / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlophedianol / dexchlorpheniramine / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlophedianol / dexchlorpheniramine / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1447'
    VALUE_SET_NAME = 'Chlophedianol / Dexchlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1369424', '1369971', '1369972'}


class DisordersOfVisualCortex(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of disorders of visual cortex.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of a disorder of visual cortex, including inflammatory disorders, neoplasm, and cortical blindness.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1458'
    VALUE_SET_NAME = 'Disorders of Visual Cortex'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H47611', 'H47612'}

    ICD9CM = {'37775'}

    SNOMEDCT = {
        '128329001', '194068002', '194069005', '194070006', '230526001', '302904002',
        '342741000119103', '342751000119101', '43727009', '55456003', '57441008', '68574006',
        '732251003'
    }


class AllergyToAceInhibitorOrArb(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of allergy to angiotensin-converting enzyme (ACE) inhibitor and angiotensin-receptor blocker (ARB).
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of allergy to ACE inhibitor or ARB.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1211'
    VALUE_SET_NAME = 'Allergy to ACE Inhibitor or ARB'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '609534005', '609537003', '609538008', '609539000', '609540003', '609541004', '609542006',
        '609543001', '609544007', '609545008', '609546009', '609549002', '609550002'
    }


class BelowNormalMedications(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent clinical medications prescribed for weight gain to patients with a below normal BMI measurement.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with oral drug forms prescribed for weight gain in patients with a below normal BMI measurement.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1499'
    VALUE_SET_NAME = 'Below Normal Medications'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197634', '197635', '197636', '577154', '860215', '860221', '860225', '860231'}


class ProceduresDuringPregnancy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures conducted during pregnancy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with procedures conducted on a patient during pregnancy. This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1009'
    VALUE_SET_NAME = 'Procedures During Pregnancy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '57022', '58600', '58605', '58970', '58974', '58976', '59000', '59001', '59012', '59015',
        '59020', '59025', '59030', '59050', '59051', '59070', '59072', '59074', '59076', '59100',
        '59120', '59121', '59130', '59135', '59136', '59140', '59150', '59151', '59160', '59200',
        '59300', '59320', '59325', '59350', '59412', '59414', '59430', '59525', '59812', '59820',
        '59821', '59830', '59840', '59841', '59850', '59851', '59852', '59855', '59856', '59857',
        '59866', '59870', '59871', '59897', '59898', '59899'
    }

    SNOMEDCT = {
        '10455003', '10763001', '133875007', '176833006', '176850008', '176852000', '176854004',
        '176928008', '176929000', '176996001', '177037000', '177038005', '177039002', '177042008',
        '177091002', '177100008', '177101007', '177102000', '177106002', '177107006', '177112007',
        '177122001', '177136006', '177212000', '177222006', '17744000', '18302006', '18489003',
        '215192006', '216209009', '233560009', '233561008', '236894009', '236912008', '236913003',
        '236914009', '236915005', '236952005', '236953000', '236954006', '236955007', '236956008',
        '236966000', '236987005', '236988000', '236992007', '236993002', '236994008', '237017007',
        '237025009', '240278000', '240284002', '240285001', '240286000', '240288004', '240289007',
        '240290003', '240291004', '240292006', '24068006', '243773009', '243774003', '259863001',
        '265082003', '265635006', '265642006', '26578004', '274973002', '275222009', '275223004',
        '28107008', '281568006', '281570002', '28379004', '285409006', '285416007', '285417003',
        '285434006', '287954004', '288045002', '288194000', '29682007', '302375005', '302384005',
        '303720006', '309877008', '315308008', '36708009', '386276009', '386277000', '386639001',
        '386641000', '387615001', '387616000', '387673001', '387678005', '387708002', '387709005',
        '387710000', '391896006', '391897002', '391899004', '391998006', '392000009', '398221005',
        '40704000', '408804006', '408805007', '408806008', '408807004', '408808009', '408819007',
        '408840008', '408845003', '41058005', '41059002', '41780001', '425707001', '425939004',
        '426287008', '426737000', '427230007', '427320001', '429613009', '429737004', '43096003',
        '433153009', '440148001', '443005005', '445865006', '445912000', '446135006', '446341008',
        '446934006', '447214008', '447771005', '447972007', '448543003', '450563004', '45460008',
        '46681009', '480571000119102', '5048009', '5191001', '52660002', '56620000', '61893009',
        '62688006', '63407004', '63596003', '65378009', '6708002', '69621003', '700041001',
        '713117007', '713120004', '714812005', '716100006', '725927001', '726556001', '732970000',
        '73341009', '737099004', '75456002', '81130000', '81855008', '82688001', '84275009',
        '85179000', '85548006', '87431004', '87663001', '88144003', '88362001', '90442009',
        '9221009', '9724000'
    }


class AnnualWellnessVisit(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent annual wellness visits.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter. The intent of this data element is to identify patients who have had an annual wellness visit.
    Inclusion Criteria: Includes only relevant concepts associated with encounters specific to annual wellness visits.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.2.1363'
    VALUE_SET_NAME = 'Annual Wellness Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    HCPCS = {'G0438', 'G0439'}


class Desipramine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent desipramine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; desipramine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; desipramine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1278'
    VALUE_SET_NAME = 'Desipramine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1099288', '1099292', '1099296', '1099300', '1099304', '1099316'}


class Indomethacin(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent indomethacin medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; indomethacin only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; indomethacin in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1366'
    VALUE_SET_NAME = 'Indomethacin'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1490727', '1491529', '197817', '197818', '247069', '310991', '310992'}


class Hydroxyzine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hydroxyzine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; hydroxyzine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; hydroxyzine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1374'
    VALUE_SET_NAME = 'Hydroxyzine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'995218', '995232', '995235', '995253', '995258', '995278', '995281', '995285'}


class Amoxapine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent amoxapine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; amoxapine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; amoxapine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1273'
    VALUE_SET_NAME = 'Amoxapine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197363', '197364', '197365', '197366'}


class Asthma(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnosis of asthma.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of asthma.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.362'
    VALUE_SET_NAME = 'Asthma'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'J4520', 'J4521', 'J4522', 'J4530', 'J4531', 'J4532', 'J4540', 'J4541', 'J4542', 'J4550',
        'J4551', 'J4552', 'J45901', 'J45902', 'J45909', 'J45990', 'J45991', 'J45998'
    }

    ICD9CM = {
        '49300', '49301', '49302', '49310', '49311', '49312', '49320', '49321', '49322', '49381',
        '49382', '49390', '49391', '49392'
    }

    SNOMEDCT = {
        '11641008', '12428000', '13151001', '195949008', '195967001', '195977004', '225057002',
        '233672007', '233678006', '233679003', '233683003', '233688007', '266361008', '281239006',
        '30352005', '304527002', '31387002', '370218001', '370219009', '370220003', '370221004',
        '389145006', '405944004', '407674008', '409663006', '423889005', '424199006', '424643009',
        '425969006', '426656000', '426979002', '427295004', '427603009', '427679007', '442025000',
        '55570000', '56968009', '59786004', '63088003', '707445000', '707446004', '707447008',
        '708038006', '708090002', '708093000', '708094006', '708095007', '708096008', '85761009',
        '92807009', '93432008'
    }


class AtrioventricularBlock(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of atrioventricular block.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of atrioventricular block.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.367'
    VALUE_SET_NAME = 'Atrioventricular Block'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I441', 'I442'}

    ICD9CM = {'4260', '42612', '42613'}

    SNOMEDCT = {
        '195042002', '233917008', '233918003', '251114004', '27885002', '28189009', '283645003',
        '54016002'
    }


class RotavirusVaccine3DoseScheduleAdministered(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent rotavirus (3-dose schedule) vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with all rotavirus (3-dose schedule) vaccine codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1047'
    VALUE_SET_NAME = 'Rotavirus Vaccine (3 dose schedule) Administered'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'90680'}

    SNOMEDCT = {'434731000124109'}


class Mumps(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent mumps infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with mumps infections. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1032'
    VALUE_SET_NAME = 'Mumps'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'B260', 'B261', 'B262', 'B263', 'B2681', 'B2682', 'B2683', 'B2684', 'B2685', 'B2689',
        'B269'
    }

    SNOMEDCT = {
        '105821000119107', '10665004', '111870000', '161420006', '17121006', '235123001',
        '236771002', '237443002', '240526004', '240527008', '240529006', '31524007', '31646008',
        '36989005', '371112003', '40099009', '44201003', '63462008', '72071001', '74717002',
        '75548002', '78580004', '89231008', '89764009'
    }


class FitDna(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a fecal immunochemical (FIT) DNA test.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying a FIT DNA laboratory test. This is a grouping of LOINC codes.
    Exclusion Criteria: Excludes codes that indicate that this test was ordered only, and not necessarily performed.
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1039'
    VALUE_SET_NAME = 'FIT DNA'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'77353-1', '77354-9'}


class Left(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the left side of the body.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Anatomical Location Site.
    Inclusion Criteria: Includes only relevant concepts associated with the left side of the body. This is a grouping of SNOMED CT codes.
    Exclusion Criteria: Excludes concepts representing the right side of the body.
    """

    OID = '2.16.840.1.113883.3.464.1003.122.12.1036'
    VALUE_SET_NAME = 'Left'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'419161000', '7771000'}


class Pci(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent procedures used to define percutaneous coronary intervention (PCI).
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Procedure, Performed. The intent of this data element is to identify patients who had percutaneous coronary intervention (PCI) during an episode of acute myocardial infarction.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients receiving percutaneous coronary intervention (PCI). This is a grouping of ICD-10-PCS and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1045.67'
    VALUE_SET_NAME = 'PCI'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '0270346', '027034Z', '0270356', '027035Z', '0270366', '027036Z', '0270376', '027037Z',
        '02703D6', '02703DZ', '02703E6', '02703EZ', '02703F6', '02703FZ', '02703G6', '02703GZ',
        '02703T6', '02703TZ', '02703Z6', '02703ZZ', '0270446', '027044Z', '0270456', '027045Z',
        '0270466', '027046Z', '0270476', '027047Z', '02704D6', '02704DZ', '02704E6', '02704EZ',
        '02704F6', '02704FZ', '02704G6', '02704GZ', '02704T6', '02704TZ', '02704Z6', '02704ZZ',
        '0271346', '027134Z', '0271356', '027135Z', '0271366', '027136Z', '0271376', '027137Z',
        '02713D6', '02713DZ', '02713E6', '02713EZ', '02713F6', '02713FZ', '02713G6', '02713GZ',
        '02713T6', '02713TZ', '02713Z6', '02713ZZ', '0271446', '027144Z', '0271456', '027145Z',
        '0271466', '027146Z', '0271476', '027147Z', '02714D6', '02714DZ', '02714E6', '02714EZ',
        '02714F6', '02714FZ', '02714G6', '02714GZ', '02714T6', '02714TZ', '02714Z6', '02714ZZ',
        '0272346', '027234Z', '0272356', '027235Z', '0272366', '027236Z', '0272376', '027237Z',
        '02723D6', '02723DZ', '02723E6', '02723EZ', '02723F6', '02723FZ', '02723G6', '02723GZ',
        '02723T6', '02723TZ', '02723Z6', '02723ZZ', '0272446', '027244Z', '0272456', '027245Z',
        '0272466', '027246Z', '0272476', '027247Z', '02724D6', '02724DZ', '02724E6', '02724EZ',
        '02724F6', '02724FZ', '02724G6', '02724GZ', '02724T6', '02724TZ', '02724Z6', '02724ZZ',
        '0273346', '027334Z', '0273356', '027335Z', '0273366', '027336Z', '0273376', '027337Z',
        '02733D6', '02733DZ', '02733E6', '02733EZ', '02733F6', '02733FZ', '02733G6', '02733GZ',
        '02733T6', '02733TZ', '02733Z6', '02733ZZ', '0273446', '027344Z', '0273456', '027345Z',
        '0273466', '027346Z', '0273476', '027347Z', '02734D6', '02734DZ', '02734E6', '02734EZ',
        '02734F6', '02734FZ', '02734G6', '02734GZ', '02734T6', '02734TZ', '02734Z6', '02734ZZ'
    }

    SNOMEDCT = {
        '11101003', '175066001', '36969009', '397193006', '397431004', '414089002', '415070008',
        '428488008', '429499003', '429639007', '429809004', '609153008', '609154002', '68466008',
        '698740005', '707828002', '737085003', '85053006'
    }


class AnaphylacticReactionToHepatitisAVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a history of an anaphylactic (extreme allergy) reaction to hepatitis A vaccine.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with an anaphylactic reaction to hepatitis A vaccine.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1026'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Hepatitis A Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'293126009'}


class SuicideRiskAssessment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent suicide risk assessments and the Beck depression inventory.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Assessment or Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with suicide risk assessment and the Beck depression inventory.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.559'
    VALUE_SET_NAME = 'Suicide Risk Assessment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'225337009', '446765009', '454331000124109', '717317000'}


class PapTest(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent identify cervical cytology tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Order or Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with cervical cytology tests. This is a grouping of LOINC codes.
    Exclusion Criteria: Excludes cytology performed on non-cervical samples. Excludes codes that indicate that this test was ordered only, and not necessarily performed.
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1017'
    VALUE_SET_NAME = 'Pap Test'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '10524-7', '18500-9', '19762-4', '19764-0', '19765-7', '19766-5', '19774-9', '33717-0',
        '47527-7', '47528-5'
    }


class ComplicationsOfPregnancyChildbirthAndThePuerperium(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent complications related to pregnancy or childbirth.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with complications of pregnancy or childbirth. This is a grouping of ICD-10-CM, ICD-9-CM, and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1012'
    VALUE_SET_NAME = 'Complications of Pregnancy, Childbirth and the Puerperium'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'N96', 'O000', 'O0000', 'O0001', 'O001', 'O0010', 'O00101', 'O00102', 'O00109', 'O0011',
        'O00111', 'O00112', 'O00119', 'O002', 'O0020', 'O00201', 'O00202', 'O00209', 'O0021',
        'O00211', 'O00212', 'O00219', 'O008', 'O0080', 'O0081', 'O009', 'O0090', 'O0091', 'O010',
        'O011', 'O019', 'O020', 'O021', 'O0281', 'O0289', 'O029', 'O030', 'O031', 'O032', 'O0330',
        'O0331', 'O0332', 'O0333', 'O0334', 'O0335', 'O0336', 'O0337', 'O0338', 'O0339', 'O034',
        'O035', 'O036', 'O037', 'O0380', 'O0381', 'O0382', 'O0383', 'O0384', 'O0385', 'O0386',
        'O0387', 'O0388', 'O0389', 'O039', 'O045', 'O046', 'O047', 'O0480', 'O0481', 'O0482',
        'O0483', 'O0484', 'O0485', 'O0486', 'O0487', 'O0488', 'O0489', 'O070', 'O071', 'O072',
        'O0730', 'O0731', 'O0732', 'O0733', 'O0734', 'O0735', 'O0736', 'O0737', 'O0738', 'O0739',
        'O074', 'O080', 'O081', 'O082', 'O083', 'O084', 'O085', 'O086', 'O087', 'O0881', 'O0882',
        'O0883', 'O0889', 'O089', 'O0900', 'O0901', 'O0902', 'O0903', 'O0910', 'O0911', 'O0912',
        'O0913', 'O09211', 'O09212', 'O09213', 'O09219', 'O09291', 'O09292', 'O09293', 'O09299',
        'O0930', 'O0931', 'O0932', 'O0933', 'O0940', 'O0941', 'O0942', 'O0943', 'O09511', 'O09512',
        'O09513', 'O09519', 'O09521', 'O09522', 'O09523', 'O09529', 'O09611', 'O09612', 'O09613',
        'O09619', 'O09621', 'O09622', 'O09623', 'O09629', 'O0970', 'O0971', 'O0972', 'O0973',
        'O09811', 'O09812', 'O09813', 'O09819', 'O09821', 'O09822', 'O09823', 'O09829', 'O09891',
        'O09892', 'O09893', 'O09899', 'O0990', 'O0991', 'O0992', 'O0993', 'O09A', 'O09A0', 'O09A1',
        'O09A2', 'O09A3', 'O10011', 'O10012', 'O10013', 'O10019', 'O1002', 'O1003', 'O10111',
        'O10112', 'O10113', 'O10119', 'O1012', 'O1013', 'O10211', 'O10212', 'O10213', 'O10219',
        'O1022', 'O1023', 'O10311', 'O10312', 'O10313', 'O10319', 'O1032', 'O1033', 'O10411',
        'O10412', 'O10413', 'O10419', 'O1042', 'O1043', 'O10911', 'O10912', 'O10913', 'O10919',
        'O1092', 'O1093', 'O111', 'O112', 'O113', 'O114', 'O115', 'O119', 'O1200', 'O1201',
        'O1202', 'O1203', 'O1204', 'O1205', 'O1210', 'O1211', 'O1212', 'O1213', 'O1214', 'O1215',
        'O1220', 'O1221', 'O1222', 'O1223', 'O1224', 'O1225', 'O131', 'O132', 'O133', 'O134',
        'O135', 'O139', 'O1400', 'O1402', 'O1403', 'O1404', 'O1405', 'O1410', 'O1412', 'O1413',
        'O1414', 'O1415', 'O1420', 'O1422', 'O1423', 'O1424', 'O1425', 'O1490', 'O1492', 'O1493',
        'O1494', 'O1495', 'O1500', 'O1502', 'O1503', 'O151', 'O152', 'O159', 'O161', 'O162',
        'O163', 'O164', 'O165', 'O169', 'O200', 'O208', 'O209', 'O210', 'O211', 'O212', 'O218',
        'O219', 'O2200', 'O2201', 'O2202', 'O2203', 'O2210', 'O2211', 'O2212', 'O2213', 'O2220',
        'O2221', 'O2222', 'O2223', 'O2230', 'O2231', 'O2232', 'O2233', 'O2240', 'O2241', 'O2242',
        'O2243', 'O2250', 'O2251', 'O2252', 'O2253', 'O228X1', 'O228X2', 'O228X3', 'O228X9',
        'O2290', 'O2291', 'O2292', 'O2293', 'O2300', 'O2301', 'O2302', 'O2303', 'O2310', 'O2311',
        'O2312', 'O2313', 'O2320', 'O2321', 'O2322', 'O2323', 'O2330', 'O2331', 'O2332', 'O2333',
        'O2340', 'O2341', 'O2342', 'O2343', 'O23511', 'O23512', 'O23513', 'O23519', 'O23521',
        'O23522', 'O23523', 'O23529', 'O23591', 'O23592', 'O23593', 'O23599', 'O2390', 'O2391',
        'O2392', 'O2393', 'O24011', 'O24012', 'O24013', 'O24019', 'O2402', 'O2403', 'O24111',
        'O24112', 'O24113', 'O24119', 'O2412', 'O2413', 'O24311', 'O24312', 'O24313', 'O24319',
        'O2432', 'O2433', 'O24410', 'O24414', 'O24415', 'O24419', 'O24420', 'O24424', 'O24425',
        'O24429', 'O24430', 'O24434', 'O24435', 'O24439', 'O24811', 'O24812', 'O24813', 'O24819',
        'O2482', 'O2483', 'O24911', 'O24912', 'O24913', 'O24919', 'O2492', 'O2493', 'O2510',
        'O2511', 'O2512', 'O2513', 'O252', 'O253', 'O2600', 'O2601', 'O2602', 'O2603', 'O2610',
        'O2611', 'O2612', 'O2613', 'O2620', 'O2621', 'O2622', 'O2623', 'O2630', 'O2631', 'O2632',
        'O2633', 'O2640', 'O2641', 'O2642', 'O2643', 'O2650', 'O2651', 'O2652', 'O2653', 'O26611',
        'O26612', 'O26613', 'O26619', 'O2662', 'O2663', 'O26711', 'O26712', 'O26713', 'O26719',
        'O2672', 'O2673', 'O26811', 'O26812', 'O26813', 'O26819', 'O26821', 'O26822', 'O26823',
        'O26829', 'O26831', 'O26832', 'O26833', 'O26839', 'O26841', 'O26842', 'O26843', 'O26849',
        'O26851', 'O26852', 'O26853', 'O26859', 'O2686', 'O26872', 'O26873', 'O26879', 'O26891',
        'O26892', 'O26893', 'O26899', 'O2690', 'O2691', 'O2692', 'O2693', 'O280', 'O281', 'O282',
        'O283', 'O284', 'O285', 'O288', 'O289', 'O29011', 'O29012', 'O29013', 'O29019', 'O29021',
        'O29022', 'O29023', 'O29029', 'O29091', 'O29092', 'O29093', 'O29099', 'O29111', 'O29112',
        'O29113', 'O29119', 'O29121', 'O29122', 'O29123', 'O29129', 'O29191', 'O29192', 'O29193',
        'O29199', 'O29211', 'O29212', 'O29213', 'O29219', 'O29291', 'O29292', 'O29293', 'O29299',
        'O293X1', 'O293X2', 'O293X3', 'O293X9', 'O2940', 'O2941', 'O2942', 'O2943', 'O295X1',
        'O295X2', 'O295X3', 'O295X9', 'O2960', 'O2961', 'O2962', 'O2963', 'O298X1', 'O298X2',
        'O298X3', 'O298X9', 'O2990', 'O2991', 'O2992', 'O2993', 'O30001', 'O30002', 'O30003',
        'O30009', 'O30011', 'O30012', 'O30013', 'O30019', 'O30021', 'O30022', 'O30023', 'O30029',
        'O30031', 'O30032', 'O30033', 'O30039', 'O30041', 'O30042', 'O30043', 'O30049', 'O30091',
        'O30092', 'O30093', 'O30099', 'O30101', 'O30102', 'O30103', 'O30109', 'O30111', 'O30112',
        'O30113', 'O30119', 'O30121', 'O30122', 'O30123', 'O30129', 'O30191', 'O30192', 'O30193',
        'O30199', 'O30201', 'O30202', 'O30203', 'O30209', 'O30211', 'O30212', 'O30213', 'O30219',
        'O30221', 'O30222', 'O30223', 'O30229', 'O30231', 'O30232', 'O30233', 'O30239', 'O30291',
        'O30292', 'O30293', 'O30299', 'O30801', 'O30802', 'O30803', 'O30809', 'O30811', 'O30812',
        'O30813', 'O30819', 'O30821', 'O30822', 'O30823', 'O30829', 'O30831', 'O30832', 'O30833',
        'O30839', 'O30891', 'O30892', 'O30893', 'O30899', 'O3090', 'O3091', 'O3092', 'O3093',
        'O3100X0', 'O3100X1', 'O3100X2', 'O3100X3', 'O3100X4', 'O3100X5', 'O3100X9', 'O3101X0',
        'O3101X1', 'O3101X2', 'O3101X3', 'O3101X4', 'O3101X5', 'O3101X9', 'O3102X0', 'O3102X1',
        'O3102X2', 'O3102X3', 'O3102X4', 'O3102X5', 'O3102X9', 'O3103X0', 'O3103X1', 'O3103X2',
        'O3103X3', 'O3103X4', 'O3103X5', 'O3103X9', 'O3110X0', 'O3110X1', 'O3110X2', 'O3110X3',
        'O3110X4', 'O3110X5', 'O3110X9', 'O3111X0', 'O3111X1', 'O3111X2', 'O3111X3', 'O3111X4',
        'O3111X5', 'O3111X9', 'O3112X0', 'O3112X1', 'O3112X2', 'O3112X3', 'O3112X4', 'O3112X5',
        'O3112X9', 'O3113X0', 'O3113X1', 'O3113X2', 'O3113X3', 'O3113X4', 'O3113X5', 'O3113X9',
        'O3120X0', 'O3120X1', 'O3120X2', 'O3120X3', 'O3120X4', 'O3120X5', 'O3120X9', 'O3121X0',
        'O3121X1', 'O3121X2', 'O3121X3', 'O3121X4', 'O3121X5', 'O3121X9', 'O3122X0', 'O3122X1',
        'O3122X2', 'O3122X3', 'O3122X4', 'O3122X5', 'O3122X9', 'O3123X0', 'O3123X1', 'O3123X2',
        'O3123X3', 'O3123X4', 'O3123X5', 'O3123X9', 'O3130X0', 'O3130X1', 'O3130X2', 'O3130X3',
        'O3130X4', 'O3130X5', 'O3130X9', 'O3131X0', 'O3131X1', 'O3131X2', 'O3131X3', 'O3131X4',
        'O3131X5', 'O3131X9', 'O3132X0', 'O3132X1', 'O3132X2', 'O3132X3', 'O3132X4', 'O3132X5',
        'O3132X9', 'O3133X0', 'O3133X1', 'O3133X2', 'O3133X3', 'O3133X4', 'O3133X5', 'O3133X9',
        'O318X10', 'O318X11', 'O318X12', 'O318X13', 'O318X14', 'O318X15', 'O318X19', 'O318X20',
        'O318X21', 'O318X22', 'O318X23', 'O318X24', 'O318X25', 'O318X29', 'O318X30', 'O318X31',
        'O318X32', 'O318X33', 'O318X34', 'O318X35', 'O318X39', 'O318X90', 'O318X91', 'O318X92',
        'O318X93', 'O318X94', 'O318X95', 'O318X99', 'O320XX0', 'O320XX1', 'O320XX2', 'O320XX3',
        'O320XX4', 'O320XX5', 'O320XX9', 'O321XX0', 'O321XX1', 'O321XX2', 'O321XX3', 'O321XX4',
        'O321XX5', 'O321XX9', 'O322XX0', 'O322XX1', 'O322XX2', 'O322XX3', 'O322XX4', 'O322XX5',
        'O322XX9', 'O323XX0', 'O323XX1', 'O323XX2', 'O323XX3', 'O323XX4', 'O323XX5', 'O323XX9',
        'O324XX0', 'O324XX1', 'O324XX2', 'O324XX3', 'O324XX4', 'O324XX5', 'O324XX9', 'O326XX0',
        'O326XX1', 'O326XX2', 'O326XX3', 'O326XX4', 'O326XX5', 'O326XX9', 'O328XX0', 'O328XX1',
        'O328XX2', 'O328XX3', 'O328XX4', 'O328XX5', 'O328XX9', 'O329XX0', 'O329XX1', 'O329XX2',
        'O329XX3', 'O329XX4', 'O329XX5', 'O329XX9', 'O330', 'O331', 'O332', 'O333XX0', 'O333XX1',
        'O333XX2', 'O333XX3', 'O333XX4', 'O333XX5', 'O333XX9', 'O334XX0', 'O334XX1', 'O334XX2',
        'O334XX3', 'O334XX4', 'O334XX5', 'O334XX9', 'O335XX0', 'O335XX1', 'O335XX2', 'O335XX3',
        'O335XX4', 'O335XX5', 'O335XX9', 'O336XX0', 'O336XX1', 'O336XX2', 'O336XX3', 'O336XX4',
        'O336XX5', 'O336XX9', 'O337', 'O337XX0', 'O337XX1', 'O337XX2', 'O337XX3', 'O337XX4',
        'O337XX5', 'O337XX9', 'O338', 'O339', 'O3400', 'O3401', 'O3402', 'O3403', 'O3410', 'O3411',
        'O3412', 'O3413', 'O3421', 'O34211', 'O34212', 'O34219', 'O3429', 'O3430', 'O3431',
        'O3432', 'O3433', 'O3440', 'O3441', 'O3442', 'O3443', 'O34511', 'O34512', 'O34513',
        'O34519', 'O34521', 'O34522', 'O34523', 'O34529', 'O34531', 'O34532', 'O34533', 'O34539',
        'O34591', 'O34592', 'O34593', 'O34599', 'O3460', 'O3461', 'O3462', 'O3463', 'O3470',
        'O3471', 'O3472', 'O3473', 'O3480', 'O3481', 'O3482', 'O3483', 'O3490', 'O3491', 'O3492',
        'O3493', 'O350XX0', 'O350XX1', 'O350XX2', 'O350XX3', 'O350XX4', 'O350XX5', 'O350XX9',
        'O351XX0', 'O351XX1', 'O351XX2', 'O351XX3', 'O351XX4', 'O351XX5', 'O351XX9', 'O352XX0',
        'O352XX1', 'O352XX2', 'O352XX3', 'O352XX4', 'O352XX5', 'O352XX9', 'O353XX0', 'O353XX1',
        'O353XX2', 'O353XX3', 'O353XX4', 'O353XX5', 'O353XX9', 'O354XX0', 'O354XX1', 'O354XX2',
        'O354XX3', 'O354XX4', 'O354XX5', 'O354XX9', 'O355XX0', 'O355XX1', 'O355XX2', 'O355XX3',
        'O355XX4', 'O355XX5', 'O355XX9', 'O356XX0', 'O356XX1', 'O356XX2', 'O356XX3', 'O356XX4',
        'O356XX5', 'O356XX9', 'O357XX0', 'O357XX1', 'O357XX2', 'O357XX3', 'O357XX4', 'O357XX5',
        'O357XX9', 'O358XX0', 'O358XX1', 'O358XX2', 'O358XX3', 'O358XX4', 'O358XX5', 'O358XX9',
        'O359XX0', 'O359XX1', 'O359XX2', 'O359XX3', 'O359XX4', 'O359XX5', 'O359XX9', 'O360110',
        'O360111', 'O360112', 'O360113', 'O360114', 'O360115', 'O360119', 'O360120', 'O360121',
        'O360122', 'O360123', 'O360124', 'O360125', 'O360129', 'O360130', 'O360131', 'O360132',
        'O360133', 'O360134', 'O360135', 'O360139', 'O360190', 'O360191', 'O360192', 'O360193',
        'O360194', 'O360195', 'O360199', 'O360910', 'O360911', 'O360912', 'O360913', 'O360914',
        'O360915', 'O360919', 'O360920', 'O360921', 'O360922', 'O360923', 'O360924', 'O360925',
        'O360929', 'O360930', 'O360931', 'O360932', 'O360933', 'O360934', 'O360935', 'O360939',
        'O360990', 'O360991', 'O360992', 'O360993', 'O360994', 'O360995', 'O360999', 'O361110',
        'O361111', 'O361112', 'O361113', 'O361114', 'O361115', 'O361119', 'O361120', 'O361121',
        'O361122', 'O361123', 'O361124', 'O361125', 'O361129', 'O361130', 'O361131', 'O361132',
        'O361133', 'O361134', 'O361135', 'O361139', 'O361190', 'O361191', 'O361192', 'O361193',
        'O361194', 'O361195', 'O361199', 'O361910', 'O361911', 'O361912', 'O361913', 'O361914',
        'O361915', 'O361919', 'O361920', 'O361921', 'O361922', 'O361923', 'O361924', 'O361925',
        'O361929', 'O361930', 'O361931', 'O361932', 'O361933', 'O361934', 'O361935', 'O361939',
        'O361990', 'O361991', 'O361992', 'O361993', 'O361994', 'O361995', 'O361999', 'O3620X0',
        'O3620X1', 'O3620X2', 'O3620X3', 'O3620X4', 'O3620X5', 'O3620X9', 'O3621X0', 'O3621X1',
        'O3621X2', 'O3621X3', 'O3621X4', 'O3621X5', 'O3621X9', 'O3622X0', 'O3622X1', 'O3622X2',
        'O3622X3', 'O3622X4', 'O3622X5', 'O3622X9', 'O3623X0', 'O3623X1', 'O3623X2', 'O3623X3',
        'O3623X4', 'O3623X5', 'O3623X9', 'O364XX0', 'O364XX1', 'O364XX2', 'O364XX3', 'O364XX4',
        'O364XX5', 'O364XX9', 'O365110', 'O365111', 'O365112', 'O365113', 'O365114', 'O365115',
        'O365119', 'O365120', 'O365121', 'O365122', 'O365123', 'O365124', 'O365125', 'O365129',
        'O365130', 'O365131', 'O365132', 'O365133', 'O365134', 'O365135', 'O365139', 'O365190',
        'O365191', 'O365192', 'O365193', 'O365194', 'O365195', 'O365199', 'O365910', 'O365911',
        'O365912', 'O365913', 'O365914', 'O365915', 'O365919', 'O365920', 'O365921', 'O365922',
        'O365923', 'O365924', 'O365925', 'O365929', 'O365930', 'O365931', 'O365932', 'O365933',
        'O365934', 'O365935', 'O365939', 'O365990', 'O365991', 'O365992', 'O365993', 'O365994',
        'O365995', 'O365999', 'O3660X0', 'O3660X1', 'O3660X2', 'O3660X3', 'O3660X4', 'O3660X5',
        'O3660X9', 'O3661X0', 'O3661X1', 'O3661X2', 'O3661X3', 'O3661X4', 'O3661X5', 'O3661X9',
        'O3662X0', 'O3662X1', 'O3662X2', 'O3662X3', 'O3662X4', 'O3662X5', 'O3662X9', 'O3663X0',
        'O3663X1', 'O3663X2', 'O3663X3', 'O3663X4', 'O3663X5', 'O3663X9', 'O3670X0', 'O3670X1',
        'O3670X2', 'O3670X3', 'O3670X4', 'O3670X5', 'O3670X9', 'O3671X0', 'O3671X1', 'O3671X2',
        'O3671X3', 'O3671X4', 'O3671X5', 'O3671X9', 'O3672X0', 'O3672X1', 'O3672X2', 'O3672X3',
        'O3672X4', 'O3672X5', 'O3672X9', 'O3673X0', 'O3673X1', 'O3673X2', 'O3673X3', 'O3673X4',
        'O3673X5', 'O3673X9', 'O3680X0', 'O3680X1', 'O3680X2', 'O3680X3', 'O3680X4', 'O3680X5',
        'O3680X9', 'O368120', 'O368121', 'O368122', 'O368123', 'O368124', 'O368125', 'O368129',
        'O368130', 'O368131', 'O368132', 'O368133', 'O368134', 'O368135', 'O368139', 'O368190',
        'O368191', 'O368192', 'O368193', 'O368194', 'O368195', 'O368199', 'O368210', 'O368211',
        'O368212', 'O368213', 'O368214', 'O368215', 'O368219', 'O368220', 'O368221', 'O368222',
        'O368223', 'O368224', 'O368225', 'O368229', 'O368230', 'O368231', 'O368232', 'O368233',
        'O368234', 'O368235', 'O368239', 'O368290', 'O368291', 'O368292', 'O368293', 'O368294',
        'O368295', 'O368299', 'O368310', 'O368311', 'O368312', 'O368313', 'O368314', 'O368315',
        'O368319', 'O368320', 'O368321', 'O368322', 'O368323', 'O368324', 'O368325', 'O368329',
        'O368330', 'O368331', 'O368332', 'O368333', 'O368334', 'O368335', 'O368339', 'O368390',
        'O368391', 'O368392', 'O368393', 'O368394', 'O368395', 'O368399', 'O368910', 'O368911',
        'O368912', 'O368913', 'O368914', 'O368915', 'O368919', 'O368920', 'O368921', 'O368922',
        'O368923', 'O368924', 'O368925', 'O368929', 'O368930', 'O368931', 'O368932', 'O368933',
        'O368934', 'O368935', 'O368939', 'O368990', 'O368991', 'O368992', 'O368993', 'O368994',
        'O368995', 'O368999', 'O3690X0', 'O3690X1', 'O3690X2', 'O3690X3', 'O3690X4', 'O3690X5',
        'O3690X9', 'O3691X0', 'O3691X1', 'O3691X2', 'O3691X3', 'O3691X4', 'O3691X5', 'O3691X9',
        'O3692X0', 'O3692X1', 'O3692X2', 'O3692X3', 'O3692X4', 'O3692X5', 'O3692X9', 'O3693X0',
        'O3693X1', 'O3693X2', 'O3693X3', 'O3693X4', 'O3693X5', 'O3693X9', 'O401XX0', 'O401XX1',
        'O401XX2', 'O401XX3', 'O401XX4', 'O401XX5', 'O401XX9', 'O402XX0', 'O402XX1', 'O402XX2',
        'O402XX3', 'O402XX4', 'O402XX5', 'O402XX9', 'O403XX0', 'O403XX1', 'O403XX2', 'O403XX3',
        'O403XX4', 'O403XX5', 'O403XX9', 'O409XX0', 'O409XX1', 'O409XX2', 'O409XX3', 'O409XX4',
        'O409XX5', 'O409XX9', 'O4100X0', 'O4100X1', 'O4100X2', 'O4100X3', 'O4100X4', 'O4100X5',
        'O4100X9', 'O4101X0', 'O4101X1', 'O4101X2', 'O4101X3', 'O4101X4', 'O4101X5', 'O4101X9',
        'O4102X0', 'O4102X1', 'O4102X2', 'O4102X3', 'O4102X4', 'O4102X5', 'O4102X9', 'O4103X0',
        'O4103X1', 'O4103X2', 'O4103X3', 'O4103X4', 'O4103X5', 'O4103X9', 'O411010', 'O411011',
        'O411012', 'O411013', 'O411014', 'O411015', 'O411019', 'O411020', 'O411021', 'O411022',
        'O411023', 'O411024', 'O411025', 'O411029', 'O411030', 'O411031', 'O411032', 'O411033',
        'O411034', 'O411035', 'O411039', 'O411090', 'O411091', 'O411092', 'O411093', 'O411094',
        'O411095', 'O411099', 'O411210', 'O411211', 'O411212', 'O411213', 'O411214', 'O411215',
        'O411219', 'O411220', 'O411221', 'O411222', 'O411223', 'O411224', 'O411225', 'O411229',
        'O411230', 'O411231', 'O411232', 'O411233', 'O411234', 'O411235', 'O411239', 'O411290',
        'O411291', 'O411292', 'O411293', 'O411294', 'O411295', 'O411299', 'O411410', 'O411411',
        'O411412', 'O411413', 'O411414', 'O411415', 'O411419', 'O411420', 'O411421', 'O411422',
        'O411423', 'O411424', 'O411425', 'O411429', 'O411430', 'O411431', 'O411432', 'O411433',
        'O411434', 'O411435', 'O411439', 'O411490', 'O411491', 'O411492', 'O411493', 'O411494',
        'O411495', 'O411499', 'O418X10', 'O418X11', 'O418X12', 'O418X13', 'O418X14', 'O418X15',
        'O418X19', 'O418X20', 'O418X21', 'O418X22', 'O418X23', 'O418X24', 'O418X25', 'O418X29',
        'O418X30', 'O418X31', 'O418X32', 'O418X33', 'O418X34', 'O418X35', 'O418X39', 'O418X90',
        'O418X91', 'O418X92', 'O418X93', 'O418X94', 'O418X95', 'O418X99', 'O4190X0', 'O4190X1',
        'O4190X2', 'O4190X3', 'O4190X4', 'O4190X5', 'O4190X9', 'O4191X0', 'O4191X1', 'O4191X2',
        'O4191X3', 'O4191X4', 'O4191X5', 'O4191X9', 'O4192X0', 'O4192X1', 'O4192X2', 'O4192X3',
        'O4192X4', 'O4192X5', 'O4192X9', 'O4193X0', 'O4193X1', 'O4193X2', 'O4193X3', 'O4193X4',
        'O4193X5', 'O4193X9', 'O4200', 'O42011', 'O42012', 'O42013', 'O42019', 'O4202', 'O4210',
        'O42111', 'O42112', 'O42113', 'O42119', 'O4212', 'O4290', 'O42911', 'O42912', 'O42913',
        'O42919', 'O4292', 'O43011', 'O43012', 'O43013', 'O43019', 'O43021', 'O43022', 'O43023',
        'O43029', 'O43101', 'O43102', 'O43103', 'O43109', 'O43111', 'O43112', 'O43113', 'O43119',
        'O43121', 'O43122', 'O43123', 'O43129', 'O43191', 'O43192', 'O43193', 'O43199', 'O43211',
        'O43212', 'O43213', 'O43219', 'O43221', 'O43222', 'O43223', 'O43229', 'O43231', 'O43232',
        'O43233', 'O43239', 'O43811', 'O43812', 'O43813', 'O43819', 'O43891', 'O43892', 'O43893',
        'O43899', 'O4390', 'O4391', 'O4392', 'O4393', 'O4400', 'O4401', 'O4402', 'O4403', 'O4410',
        'O4411', 'O4412', 'O4413', 'O4420', 'O4421', 'O4422', 'O4423', 'O4430', 'O4431', 'O4432',
        'O4433', 'O4440', 'O4441', 'O4442', 'O4443', 'O4450', 'O4451', 'O4452', 'O4453', 'O45001',
        'O45002', 'O45003', 'O45009', 'O45011', 'O45012', 'O45013', 'O45019', 'O45021', 'O45022',
        'O45023', 'O45029', 'O45091', 'O45092', 'O45093', 'O45099', 'O458X1', 'O458X2', 'O458X3',
        'O458X9', 'O4590', 'O4591', 'O4592', 'O4593', 'O46001', 'O46002', 'O46003', 'O46009',
        'O46011', 'O46012', 'O46013', 'O46019', 'O46021', 'O46022', 'O46023', 'O46029', 'O46091',
        'O46092', 'O46093', 'O46099', 'O468X1', 'O468X2', 'O468X3', 'O468X9', 'O4690', 'O4691',
        'O4692', 'O4693', 'O4700', 'O4702', 'O4703', 'O471', 'O479', 'O480', 'O481', 'O6000',
        'O6002', 'O6003', 'O6010X0', 'O6010X1', 'O6010X2', 'O6010X3', 'O6010X4', 'O6010X5',
        'O6010X9', 'O6012X0', 'O6012X1', 'O6012X2', 'O6012X3', 'O6012X4', 'O6012X5', 'O6012X9',
        'O6013X0', 'O6013X1', 'O6013X2', 'O6013X3', 'O6013X4', 'O6013X5', 'O6013X9', 'O6014X0',
        'O6014X1', 'O6014X2', 'O6014X3', 'O6014X4', 'O6014X5', 'O6014X9', 'O6020X0', 'O6020X1',
        'O6020X2', 'O6020X3', 'O6020X4', 'O6020X5', 'O6020X9', 'O6022X0', 'O6022X1', 'O6022X2',
        'O6022X3', 'O6022X4', 'O6022X5', 'O6022X9', 'O6023X0', 'O6023X1', 'O6023X2', 'O6023X3',
        'O6023X4', 'O6023X5', 'O6023X9', 'O610', 'O611', 'O618', 'O619', 'O620', 'O621', 'O622',
        'O623', 'O624', 'O628', 'O629', 'O630', 'O631', 'O632', 'O639', 'O640XX0', 'O640XX1',
        'O640XX2', 'O640XX3', 'O640XX4', 'O640XX5', 'O640XX9', 'O641XX0', 'O641XX1', 'O641XX2',
        'O641XX3', 'O641XX4', 'O641XX5', 'O641XX9', 'O642XX0', 'O642XX1', 'O642XX2', 'O642XX3',
        'O642XX4', 'O642XX5', 'O642XX9', 'O643XX0', 'O643XX1', 'O643XX2', 'O643XX3', 'O643XX4',
        'O643XX5', 'O643XX9', 'O644XX0', 'O644XX1', 'O644XX2', 'O644XX3', 'O644XX4', 'O644XX5',
        'O644XX9', 'O645XX0', 'O645XX1', 'O645XX2', 'O645XX3', 'O645XX4', 'O645XX5', 'O645XX9',
        'O648XX0', 'O648XX1', 'O648XX2', 'O648XX3', 'O648XX4', 'O648XX5', 'O648XX9', 'O649XX0',
        'O649XX1', 'O649XX2', 'O649XX3', 'O649XX4', 'O649XX5', 'O649XX9', 'O650', 'O651', 'O652',
        'O653', 'O654', 'O655', 'O658', 'O659', 'O660', 'O661', 'O662', 'O663', 'O6640', 'O6641',
        'O665', 'O666', 'O668', 'O669', 'O670', 'O678', 'O679', 'O68', 'O690XX0', 'O690XX1',
        'O690XX2', 'O690XX3', 'O690XX4', 'O690XX5', 'O690XX9', 'O691XX0', 'O691XX1', 'O691XX2',
        'O691XX3', 'O691XX4', 'O691XX5', 'O691XX9', 'O692XX0', 'O692XX1', 'O692XX2', 'O692XX3',
        'O692XX4', 'O692XX5', 'O692XX9', 'O693XX0', 'O693XX1', 'O693XX2', 'O693XX3', 'O693XX4',
        'O693XX5', 'O693XX9', 'O694XX0', 'O694XX1', 'O694XX2', 'O694XX3', 'O694XX4', 'O694XX5',
        'O694XX9', 'O695XX0', 'O695XX1', 'O695XX2', 'O695XX3', 'O695XX4', 'O695XX5', 'O695XX9',
        'O6981X0', 'O6981X1', 'O6981X2', 'O6981X3', 'O6981X4', 'O6981X5', 'O6981X9', 'O6982X0',
        'O6982X1', 'O6982X2', 'O6982X3', 'O6982X4', 'O6982X5', 'O6982X9', 'O6989X0', 'O6989X1',
        'O6989X2', 'O6989X3', 'O6989X4', 'O6989X5', 'O6989X9', 'O699XX0', 'O699XX1', 'O699XX2',
        'O699XX3', 'O699XX4', 'O699XX5', 'O699XX9', 'O700', 'O701', 'O702', 'O7020', 'O7021',
        'O7022', 'O7023', 'O703', 'O704', 'O709', 'O7100', 'O7102', 'O7103', 'O711', 'O712',
        'O713', 'O714', 'O715', 'O716', 'O717', 'O7181', 'O7182', 'O7189', 'O719', 'O720', 'O721',
        'O722', 'O723', 'O730', 'O731', 'O740', 'O741', 'O742', 'O743', 'O744', 'O745', 'O746',
        'O747', 'O748', 'O749', 'O750', 'O751', 'O752', 'O753', 'O754', 'O755', 'O7581', 'O7582',
        'O7589', 'O759', 'O76', 'O770', 'O771', 'O778', 'O779', 'O80', 'O82', 'O85', 'O8600',
        'O8601', 'O8602', 'O8603', 'O8604', 'O8609', 'O8611', 'O8612', 'O8613', 'O8619', 'O8620',
        'O8621', 'O8622', 'O8629', 'O864', 'O8681', 'O8689', 'O870', 'O871', 'O872', 'O873',
        'O874', 'O878', 'O879', 'O88011', 'O88012', 'O88013', 'O88019', 'O8802', 'O8803', 'O88111',
        'O88112', 'O88113', 'O88119', 'O8812', 'O8813', 'O88211', 'O88212', 'O88213', 'O88219',
        'O8822', 'O8823', 'O88311', 'O88312', 'O88313', 'O88319', 'O8832', 'O8833', 'O88811',
        'O88812', 'O88813', 'O88819', 'O8882', 'O8883', 'O8901', 'O8909', 'O891', 'O892', 'O893',
        'O894', 'O895', 'O896', 'O898', 'O899', 'O900', 'O901', 'O902', 'O903', 'O904', 'O905',
        'O906', 'O9081', 'O9089', 'O909', 'O91011', 'O91012', 'O91013', 'O91019', 'O9102', 'O9103',
        'O91111', 'O91112', 'O91113', 'O91119', 'O9112', 'O9113', 'O91211', 'O91212', 'O91213',
        'O91219', 'O9122', 'O9123', 'O92011', 'O92012', 'O92013', 'O92019', 'O9202', 'O9203',
        'O92111', 'O92112', 'O92113', 'O92119', 'O9212', 'O9213', 'O9220', 'O9229', 'O923', 'O924',
        'O925', 'O926', 'O9270', 'O9279', 'O98011', 'O98012', 'O98013', 'O98019', 'O9802', 'O9803',
        'O98111', 'O98112', 'O98113', 'O98119', 'O9812', 'O9813', 'O98211', 'O98212', 'O98213',
        'O98219', 'O9822', 'O9823', 'O98311', 'O98312', 'O98313', 'O98319', 'O9832', 'O9833',
        'O98411', 'O98412', 'O98413', 'O98419', 'O9842', 'O9843', 'O98511', 'O98512', 'O98513',
        'O98519', 'O9852', 'O9853', 'O98611', 'O98612', 'O98613', 'O98619', 'O9862', 'O9863',
        'O98711', 'O98712', 'O98713', 'O98719', 'O9872', 'O9873', 'O98811', 'O98812', 'O98813',
        'O98819', 'O9882', 'O9883', 'O98911', 'O98912', 'O98913', 'O98919', 'O9892', 'O9893',
        'O99011', 'O99012', 'O99013', 'O99019', 'O9902', 'O9903', 'O99111', 'O99112', 'O99113',
        'O99119', 'O9912', 'O9913', 'O99210', 'O99211', 'O99212', 'O99213', 'O99214', 'O99215',
        'O99280', 'O99281', 'O99282', 'O99283', 'O99284', 'O99285', 'O99310', 'O99311', 'O99312',
        'O99313', 'O99314', 'O99315', 'O99320', 'O99321', 'O99322', 'O99323', 'O99324', 'O99325',
        'O99330', 'O99331', 'O99332', 'O99333', 'O99334', 'O99335', 'O99340', 'O99341', 'O99342',
        'O99343', 'O99344', 'O99345', 'O99350', 'O99351', 'O99352', 'O99353', 'O99354', 'O99355',
        'O99411', 'O99412', 'O99413', 'O99419', 'O9942', 'O9943', 'O99511', 'O99512', 'O99513',
        'O99519', 'O9952', 'O9953', 'O99611', 'O99612', 'O99613', 'O99619', 'O9962', 'O9963',
        'O99711', 'O99712', 'O99713', 'O99719', 'O9972', 'O9973', 'O99810', 'O99814', 'O99815',
        'O99820', 'O99824', 'O99825', 'O99830', 'O99834', 'O99835', 'O99840', 'O99841', 'O99842',
        'O99843', 'O99844', 'O99845', 'O9989', 'O9A111', 'O9A112', 'O9A113', 'O9A119', 'O9A12',
        'O9A13', 'O9A211', 'O9A212', 'O9A213', 'O9A219', 'O9A22', 'O9A23', 'O9A311', 'O9A312',
        'O9A313', 'O9A319', 'O9A32', 'O9A33', 'O9A411', 'O9A412', 'O9A413', 'O9A419', 'O9A42',
        'O9A43', 'O9A511', 'O9A512', 'O9A513', 'O9A519', 'O9A52', 'O9A53', 'Z0371', 'Z0372',
        'Z0373', 'Z0374', 'Z0375', 'Z0379', 'Z331', 'Z332', 'Z333', 'Z3400', 'Z3401', 'Z3402',
        'Z3403', 'Z3480', 'Z3481', 'Z3482', 'Z3483', 'Z3490', 'Z3491', 'Z3492', 'Z3493', 'Z36',
        'Z640', 'Z641'
    }

    ICD9CM = {
        '630', '6310', '6318', '632', '63300', '63301', '63310', '63311', '63320', '63321',
        '63380', '63381', '63390', '63391', '63400', '63401', '63402', '63410', '63411', '63412',
        '63420', '63421', '63422', '63430', '63431', '63432', '63440', '63441', '63442', '63450',
        '63451', '63452', '63460', '63461', '63462', '63470', '63471', '63472', '63480', '63481',
        '63482', '63490', '63491', '63492', '63500', '63501', '63502', '63510', '63511', '63512',
        '63520', '63521', '63522', '63530', '63531', '63532', '63540', '63541', '63542', '63550',
        '63551', '63552', '63560', '63561', '63562', '63570', '63571', '63572', '63580', '63581',
        '63582', '63590', '63591', '63592', '63600', '63601', '63602', '63610', '63611', '63612',
        '63620', '63621', '63622', '63630', '63631', '63632', '63640', '63641', '63642', '63650',
        '63651', '63652', '63660', '63661', '63662', '63670', '63671', '63672', '63680', '63681',
        '63682', '63690', '63691', '63692', '63700', '63701', '63702', '63710', '63711', '63712',
        '63720', '63721', '63722', '63730', '63731', '63732', '63740', '63741', '63742', '63750',
        '63751', '63752', '63760', '63761', '63762', '63770', '63771', '63772', '63780', '63781',
        '63782', '63790', '63791', '63792', '6380', '6381', '6382', '6383', '6384', '6385', '6386',
        '6387', '6388', '6389', '6390', '6391', '6392', '6393', '6394', '6395', '6396', '6398',
        '6399', '64000', '64001', '64003', '64080', '64081', '64083', '64090', '64091', '64093',
        '64100', '64101', '64103', '64110', '64111', '64113', '64120', '64121', '64123', '64130',
        '64131', '64133', '64180', '64181', '64183', '64190', '64191', '64193', '64200', '64201',
        '64202', '64203', '64204', '64210', '64211', '64212', '64213', '64214', '64220', '64221',
        '64222', '64223', '64224', '64230', '64231', '64232', '64233', '64234', '64240', '64241',
        '64242', '64243', '64244', '64250', '64251', '64252', '64253', '64254', '64260', '64261',
        '64262', '64263', '64264', '64270', '64271', '64272', '64273', '64274', '64290', '64291',
        '64292', '64293', '64294', '64300', '64301', '64303', '64310', '64311', '64313', '64320',
        '64321', '64323', '64380', '64381', '64383', '64390', '64391', '64393', '64400', '64403',
        '64410', '64413', '64420', '64421', '64510', '64511', '64513', '64520', '64521', '64523',
        '64600', '64601', '64603', '64610', '64611', '64612', '64613', '64614', '64620', '64621',
        '64622', '64623', '64624', '64630', '64631', '64633', '64640', '64641', '64642', '64643',
        '64644', '64650', '64651', '64652', '64653', '64654', '64660', '64661', '64662', '64663',
        '64664', '64670', '64671', '64673', '64680', '64681', '64682', '64683', '64684', '64690',
        '64691', '64693', '64700', '64701', '64702', '64703', '64704', '64710', '64711', '64712',
        '64713', '64714', '64720', '64721', '64722', '64723', '64724', '64730', '64731', '64732',
        '64733', '64734', '64740', '64741', '64742', '64743', '64744', '64750', '64751', '64752',
        '64753', '64754', '64760', '64761', '64762', '64763', '64764', '64780', '64781', '64782',
        '64783', '64784', '64790', '64791', '64792', '64793', '64794', '64800', '64801', '64802',
        '64803', '64804', '64810', '64811', '64812', '64813', '64814', '64820', '64821', '64822',
        '64823', '64824', '64830', '64831', '64832', '64833', '64834', '64840', '64841', '64842',
        '64843', '64844', '64850', '64851', '64852', '64853', '64854', '64860', '64861', '64862',
        '64863', '64864', '64870', '64871', '64872', '64873', '64874', '64880', '64881', '64882',
        '64883', '64884', '64890', '64891', '64892', '64893', '64894', '64900', '64901', '64902',
        '64903', '64904', '64910', '64911', '64912', '64913', '64914', '64920', '64921', '64922',
        '64923', '64924', '64930', '64931', '64932', '64933', '64934', '64940', '64941', '64942',
        '64943', '64944', '64950', '64951', '64953', '64960', '64961', '64962', '64963', '64964',
        '64970', '64971', '64973', '64981', '64982', '650', '65100', '65101', '65103', '65110',
        '65111', '65113', '65120', '65121', '65123', '65130', '65131', '65133', '65140', '65141',
        '65143', '65150', '65151', '65153', '65160', '65161', '65163', '65170', '65171', '65173',
        '65180', '65181', '65183', '65190', '65191', '65193', '65200', '65201', '65203', '65210',
        '65211', '65213', '65220', '65221', '65223', '65230', '65231', '65233', '65240', '65241',
        '65243', '65250', '65251', '65253', '65260', '65261', '65263', '65270', '65271', '65273',
        '65280', '65281', '65283', '65290', '65291', '65293', '65300', '65301', '65303', '65310',
        '65311', '65313', '65320', '65321', '65323', '65330', '65331', '65333', '65340', '65341',
        '65343', '65350', '65351', '65353', '65360', '65361', '65363', '65370', '65371', '65373',
        '65380', '65381', '65383', '65390', '65391', '65393', '65400', '65401', '65402', '65403',
        '65404', '65410', '65411', '65412', '65413', '65414', '65420', '65421', '65423', '65430',
        '65431', '65432', '65433', '65434', '65440', '65441', '65442', '65443', '65444', '65450',
        '65451', '65452', '65453', '65454', '65460', '65461', '65462', '65463', '65464', '65470',
        '65471', '65472', '65473', '65474', '65480', '65481', '65482', '65483', '65484', '65490',
        '65491', '65492', '65493', '65494', '65500', '65501', '65503', '65510', '65511', '65513',
        '65520', '65521', '65523', '65530', '65531', '65533', '65540', '65541', '65543', '65550',
        '65551', '65553', '65560', '65561', '65563', '65570', '65571', '65573', '65580', '65581',
        '65583', '65590', '65591', '65593', '65600', '65601', '65603', '65610', '65611', '65613',
        '65620', '65621', '65623', '65630', '65631', '65633', '65640', '65641', '65643', '65650',
        '65651', '65653', '65660', '65661', '65663', '65670', '65671', '65673', '65680', '65681',
        '65683', '65690', '65691', '65693', '65700', '65701', '65703', '65800', '65801', '65803',
        '65810', '65811', '65813', '65820', '65821', '65823', '65830', '65831', '65833', '65840',
        '65841', '65843', '65880', '65881', '65883', '65890', '65891', '65893', '65900', '65901',
        '65903', '65910', '65911', '65913', '65920', '65921', '65923', '65930', '65931', '65933',
        '65940', '65941', '65943', '65950', '65951', '65953', '65960', '65961', '65963', '65970',
        '65971', '65973', '65980', '65981', '65983', '65990', '65991', '65993', '66000', '66001',
        '66003', '66010', '66011', '66013', '66020', '66021', '66023', '66030', '66031', '66033',
        '66040', '66041', '66043', '66050', '66051', '66053', '66060', '66061', '66063', '66070',
        '66071', '66073', '66080', '66081', '66083', '66090', '66091', '66093', '66100', '66101',
        '66103', '66110', '66111', '66113', '66120', '66121', '66123', '66130', '66131', '66133',
        '66140', '66141', '66143', '66190', '66191', '66193', '66200', '66201', '66203', '66210',
        '66211', '66213', '66220', '66221', '66223', '66230', '66231', '66233', '66300', '66301',
        '66303', '66310', '66311', '66313', '66320', '66321', '66323', '66330', '66331', '66333',
        '66340', '66341', '66343', '66350', '66351', '66353', '66360', '66361', '66363', '66380',
        '66381', '66383', '66390', '66391', '66393', '66400', '66401', '66404', '66410', '66411',
        '66414', '66420', '66421', '66424', '66430', '66431', '66434', '66440', '66441', '66444',
        '66450', '66451', '66454', '66460', '66461', '66464', '66480', '66481', '66484', '66490',
        '66491', '66494', '66500', '66501', '66503', '66510', '66511', '66520', '66522', '66524',
        '66530', '66531', '66534', '66540', '66541', '66544', '66550', '66551', '66554', '66560',
        '66561', '66564', '66570', '66571', '66572', '66574', '66580', '66581', '66582', '66583',
        '66584', '66590', '66591', '66592', '66593', '66594', '66600', '66602', '66604', '66610',
        '66612', '66614', '66620', '66622', '66624', '66630', '66632', '66634', '66700', '66702',
        '66704', '66710', '66712', '66714', '66800', '66801', '66802', '66803', '66804', '66810',
        '66811', '66812', '66813', '66814', '66820', '66821', '66822', '66823', '66824', '66880',
        '66881', '66882', '66883', '66884', '66890', '66891', '66892', '66893', '66894', '66900',
        '66901', '66902', '66903', '66904', '66910', '66911', '66912', '66913', '66914', '66920',
        '66921', '66922', '66923', '66924', '66930', '66932', '66934', '66940', '66941', '66942',
        '66943', '66944', '66950', '66951', '66960', '66961', '66970', '66971', '66980', '66981',
        '66982', '66983', '66984', '66990', '66991', '66992', '66993', '66994', '67000', '67002',
        '67004', '67100', '67101', '67102', '67103', '67104', '67110', '67111', '67112', '67113',
        '67114', '67120', '67121', '67122', '67123', '67124', '67130', '67131', '67133', '67140',
        '67142', '67144', '67150', '67151', '67152', '67153', '67154', '67180', '67181', '67182',
        '67183', '67184', '67190', '67191', '67192', '67193', '67194', '67200', '67202', '67204',
        '67300', '67301', '67302', '67303', '67304', '67310', '67311', '67312', '67313', '67314',
        '67320', '67321', '67322', '67323', '67324', '67330', '67331', '67332', '67333', '67334',
        '67380', '67381', '67382', '67383', '67384', '67400', '67401', '67402', '67403', '67404',
        '67410', '67412', '67414', '67420', '67422', '67424', '67430', '67432', '67434', '67440',
        '67442', '67444', '67450', '67451', '67452', '67453', '67454', '67480', '67482', '67484',
        '67490', '67492', '67494', '67500', '67501', '67502', '67503', '67504', '67510', '67511',
        '67512', '67513', '67514', '67520', '67521', '67522', '67523', '67524', '67580', '67581',
        '67582', '67583', '67584', '67590', '67591', '67592', '67593', '67594', '67600', '67601',
        '67602', '67603', '67604', '67610', '67611', '67612', '67613', '67614', '67620', '67621',
        '67622', '67623', '67624', '67630', '67631', '67632', '67633', '67634', '67640', '67641',
        '67642', '67643', '67644', '67650', '67651', '67652', '67653', '67654', '67660', '67661',
        '67662', '67663', '67664', '67680', '67681', '67682', '67683', '67684', '67690', '67691',
        '67692', '67693', '67694', '677', '67800', '67801', '67803', '67810', '67811', '67813',
        '67900', '67901', '67902', '67903', '67904', '67910', '67911', '67912', '67913', '67914'
    }

    SNOMEDCT = {
        '10058006', '100841000119109', '100941000119100', '10217006', '104011000119109',
        '104851000119103', '10562009', '10573002', '106004004', '106005003', '106010004',
        '106281000119103', '10629511000119102', '10697004', '10741751000119100',
        '10741871000119101', '10742121000119104', '10742471000119108', '10743121000119108',
        '10743741000119103', '10745231000119102', '10745291000119103', '10746341000119109',
        '10749581000119100', '10749641000119106', '10749691000119103', '10749811000119108',
        '10750051000119105', '10750161000119106', '10750411000119102', '10750551000119100',
        '10750951000119106', '10751471000119101', '10751771000119107', '10752251000119103',
        '10752641000119102', '10752771000119100', '10753101000119102', '10753491000119101',
        '10754031000119105', '10754331000119108', '10754701000119100', '10754781000119108',
        '10754881000119104', '10754921000119106', '10755041000119100', '10755671000119100',
        '10756101000119107', '10757401000119104', '10757441000119102', '10757481000119107',
        '10759031000119106', '10759111000119102', '10759151000119101', '10759191000119106',
        '10759311000119104', '10759351000119103', '10759401000119105', '10759761000119100',
        '10759841000119105', '10759881000119100', '10759921000119107', '10759961000119102',
        '10760001000119100', '10760041000119103', '10760081000119108', '10760131000119108',
        '10760261000119106', '10760381000119106', '10760461000119107', '10805641000119102',
        '10806041000119104', '10806241000119108', '10807061000119103', '10808861000119105',
        '10809061000119106', '10809101000119109', '10809641000119100', '10811161000119107',
        '10812041000119103', '10812081000119108', '10812131000119108', '10835571000119102',
        '10835621000119104', '10835701000119102', '10835781000119105', '10835971000119109',
        '10853001', '10884004', '110081000119109', '110091000119107', '11026009', '11109001',
        '111425004', '111431001', '111432008', '111438007', '111451002', '111452009', '111453004',
        '111454005', '111458008', '111459000', '11209007', '1125006', '11373009', '11454006',
        '114881000119108', '11669000', '11687002', '118781000119108', '11942004',
        '119891000119105', '119901000119109', '120001000119107', '12062007', '12095001',
        '12296009', '12394009', '126941005', '127009', '128076000', '128077009', '129597002',
        '129598007', '130959009', '130960004', '13100007', '13384007', '1343000', '13842006',
        '14094001', '14136000', '14331002', '1469007', '1474004', '14918004', '15230009',
        '15394000', '15406009', '15504009', '15511008', '15643101000119103', '15750121000119108',
        '15809008', '15938005', '16083003', '16101000119107', '16111000119105', '1621000119101',
        '16271000119108', '16320551000119109', '16574001', '16714009', '16756008', '16950007',
        '171000119107', '172001', '17263003', '17335003', '17787002', '178280004', '18237006',
        '18260003', '18416000', '18606002', '18613002', '18684002', '18872002', '18894005',
        '18909006', '195005', '19564003', '19569008', '19729005', '19773009', '198332009',
        '198347000', '198609003', '198644001', '198645000', '198646004', '198647008', '198648003',
        '198649006', '198650006', '198655001', '198657009', '198659007', '198660002', '198661003',
        '198663000', '198705001', '198706000', '198707009', '198708004', '198709007', '198710002',
        '198711003', '198743003', '198744009', '198745005', '198746006', '198747002', '198748007',
        '198749004', '198750004', '198903000', '198905007', '198906008', '198910006', '198911005',
        '198912003', '198917009', '198918004', '198920001', '198922009', '198923004', '198925006',
        '198927003', '198928008', '198941007', '198942000', '198944004', '198945003', '198946002',
        '198947006', '198949009', '198951008', '198952001', '198953006', '198954000', '198965005',
        '198966006', '198967002', '198968007', '198983002', '198984008', '198985009', '198986005',
        '198990007', '198991006', '198992004', '198993009', '198997005', '198999008', '199000005',
        '199002002', '199003007', '199005000', '199006004', '199007008', '199022003', '199023008',
        '199025001', '199027009', '199028004', '199063009', '199064003', '199093003', '199095005',
        '199096006', '199099004', '199100007', '199101006', '199102004', '199106001', '199107005',
        '199108000', '199109008', '199110003', '199111004', '199112006', '199117000', '199118005',
        '199127006', '199128001', '199129009', '199130004', '199132007', '199134008', '199135009',
        '199136005', '199137001', '199139003', '199153003', '199154009', '199156006', '199157002',
        '199158007', '199159004', '199161008', '199163006', '199164000', '199165004', '199166003',
        '199175001', '199178004', '199179007', '199180005', '199181009', '199183007', '199185000',
        '199186004', '199187008', '199188003', '199192005', '199193000', '199194006', '199195007',
        '199203001', '199205008', '199225007', '199227004', '199244000', '199245004', '199246003',
        '199247007', '199252002', '199254001', '199266007', '199267003', '199268008', '199269000',
        '199279003', '199281001', '199282008', '199283003', '199284009', '199293005', '199294004',
        '199295003', '199296002', '199305006', '199446000', '199461004', '199463001', '199464007',
        '199466009', '199468005', '199469002', '199470001', '199471002', '199511005', '199512003',
        '199513008', '199514002', '199595002', '199596001', '199597005', '199646006', '199647002',
        '199653002', '199654008', '199677008', '199678003', '199710008', '199711007', '199732004',
        '199745000', '199774009', '199775005', '199783004', '199784005', '199819004', '199821009',
        '199824001', '199825000', '199838008', '199839000', '199847000', '199848005', '199857004',
        '199858009', '199860006', '199862003', '199863008', '199869007', '199870008', '199874004',
        '199875003', '199880007', '199881006', '199889008', '199890004', '199895009', '199896005',
        '199916005', '199917001', '199925004', '199926003', '199930000', '199931001', '199934009',
        '199935005', '199958008', '199960005', '199961009', '199964001', '199965000', '199969006',
        '199970007', '199972004', '199974003', '199975002', '199977005', '199979008', '199980006',
        '199990003', '199991004', '199993001', '199995008', '199997000', '200025008', '200030007',
        '200031006', '200038000', '200046004', '200049006', '200050006', '200051005', '200052003',
        '200054002', '200056000', '200057009', '200058004', '200059007', '200061003', '200063000',
        '200064006', '200065007', '200066008', '200068009', '200069001', '200070000', '200075005',
        '200077002', '200099005', '200100002', '200101003', '200102005', '200105007', '200106008',
        '200107004', '200108009', '200111005', '200112003', '200113008', '200114002', '200118004',
        '200125006', '200164009', '200173001', '200181000', '200182007', '200185009', '200187001',
        '200190007', '200191006', '200195002', '200196001', '200204002', '200206000', '200207009',
        '200208004', '200209007', '200215007', '200216008', '200217004', '200218009', '200222004',
        '200224003', '200226001', '200227005', '200237000', '200238005', '200249004', '200251000',
        '200252007', '200253002', '200254008', '200277008', '200280009', '200281008', '200284000',
        '200286003', '200288002', '200289005', '200290001', '200291002', '200294005', '200295006',
        '200296007', '200297003', '200299000', '200301007', '200302000', '200303005', '200304004',
        '200308001', '200309009', '200310004', '200311000', '200330000', '200331001', '200332008',
        '200333003', '200337002', '200338007', '200342005', '200343000', '200444007', '200446009',
        '200447000', '200448005', '200449002', '20084001', '201134009', '20216003', '20391007',
        '204470001', '20483002', '206057002', '206070006', '206112008', '206113003', '206114009',
        '206115005', '206116006', '206117002', '206118007', '206121009', '206122002', '206123007',
        '206134005', '206137003', '206138008', '206139000', '206146009', '206148005', '206149002',
        '206191000', '206242003', '206244002', '20625004', '206365006', '20753005', '20845005',
        '20932005', '20956009', '21280005', '21360006', '21504004', '21604008', '21987001',
        '22046002', '22271007', '22281000119101', '22399000', '2261009', '22846003', '22966008',
        '23171006', '23332002', '23401002', '234058009', '23431000119106', '23508005', '235888006',
        '23717007', '237186006', '237188007', '237189004', '237190008', '237198001', '237202004',
        '237206001', '237209008', '237227006', '237230004', '237249000', '237250000', '237252008',
        '237260009', '237261008', '237262001', '237270006', '237271005', '237272003', '237273008',
        '237274002', '237275001', '237276000', '237277009', '237279007', '237281009', '237282002',
        '237283007', '237286004', '237305004', '237306003', '237307007', '237309005', '237310000',
        '237321009', '237325000', '237327008', '237328003', '237329006', '237336007', '237337003',
        '237338008', '237342006', '237343001', '237345008', '237346009', '237347000', '237348005',
        '237349002', '237350002', '237351003', '237352005', '237355007', '237357004', '237506002',
        '237507006', '23786008', '238820002', '23885003', '239101008', '239102001', '239103006',
        '239104000', '239105004', '23960006', '240167004', '24042004', '24051007', '24082006',
        '24258008', '24342007', '24699006', '249189006', '249196008', '249218000', '249219008',
        '249220002', '25053000', '25113000', '25404008', '25519006', '25691001', '25725007',
        '25825004', '25922000', '26010008', '26078007', '26158002', '26235008', '26528001',
        '267193004', '267197003', '267199000', '267204006', '267207004', '267257007', '267265005',
        '267266006', '267268007', '267271004', '267272006', '267276009', '267280004', '267282007',
        '267283002', '267284008', '267317007', '267322007', '267340006', '267350007', '26743002',
        '26840006', '26850007', '268809007', '268811003', '268812005', '268813000', '268863005',
        '268864004', '268865003', '27015006', '270500004', '27075004', '27152008', '27169005',
        '27214003', '27215002', '27342004', '27388005', '273982004', '273983009', '274117006',
        '274119009', '274120003', '274126009', '275412000', '275421004', '275429002', '275434003',
        '27552001', '27696007', '2781009', '279225001', '280732008', '28196006', '2858002',
        '28735000', '28773001', '288208001', '288250001', '289311005', '289312003', '290653008',
        '291665000', '29259002', '29583006', '29847008', '2989004', '29908007', '29950007',
        '29995000', '300927001', '30243004', '302644007', '302929008', '302945005', '303063000',
        '3033000', '30479005', '307517001', '307632004', '30806007', '308133005', '308134004',
        '308135003', '308136002', '308137006', '308140006', '308187004', '30850008', '31026002',
        '310592002', '310594001', '313017000', '313291009', '31407004', '31481000', '31516002',
        '31563000', '31801000146106', '3230006', '32801000119106', '32999002', '33046001',
        '33058001', '33128005', '33370009', '33561005', '33627001', '34150001', '34165000',
        '34242002', '34262005', '34270000', '34273003', '34327003', '34614007', '34694006',
        '34701001', '34842007', '34981006', '35208003', '35255008', '35303009', '35347003',
        '35716006', '35882009', '361095003', '361096002', '36323001', '3634007', '36473002',
        '36497006', '36697001', '367390009', '36916008', '371380006', '37139009', '371607000',
        '37292007', '373680009', '373896005', '373901007', '373902000', '37618003', '37787009',
        '38010008', '38176009', '38451000119105', '38534008', '387692004', '387696001',
        '387699008', '387700009', '38784004', '38905006', '39121000119100', '39199000',
        '392280004', '39239006', '39246002', '396544001', '39727004', '39763004', '397752008',
        '397952002', '398019008', '398254007', '398262004', '398276003', '399031001', '400170001',
        '40125005', '40193008', '4026005', '402836009', '403528000', '40405003', '40444006',
        '40500006', '40511000119107', '40521000119100', '405256006', '405733001', '405736009',
        '40609001', '40691000119104', '40791000119105', '40801000119106', '41114007', '413338003',
        '413339006', '413567003', '415105001', '415810004', '416402001', '416669000', '417044008',
        '417150000', '417364008', '417426005', '417570003', '41806003', '41962002', '41991004',
        '42070007', '42170009', '42294002', '42536002', '42537006', '42599006', '427139004',
        '428017002', '428165003', '428230005', '428252001', '428707000', '430881000', '430883002',
        '43306002', '43629001', '43715006', '439107005', '44017002', '44101005', '441697004',
        '44464006', '4451004', '445149007', '44772007', '44814008', '44918005', '449807005',
        '449808000', '449809008', '451881000124101', '451891000124103', '451901000124104',
        '451921000124109', '4576001', '45828008', '46273003', '46311005', '46502006', '46764007',
        '46848006', '46894009', '47236005', '47267007', '47537002', '47780009', '47821001',
        '4783006', '4787007', '48194001', '48200009', '48287005', '48433002', '48552006',
        '48739004', '4907004', '49102001', '49171007', '49177006', '49279000', '49364005',
        '49561003', '49815007', '49964003', '5010004', '50120008', '50258003', '50764006',
        '50770000', '51096002', '51154004', '51495008', '51519001', '51707007', '51953009',
        '51954003', '521000119104', '52342006', '52700006', '52772002', '53024001', '53098006',
        '53183006', '53247006', '53419009', '53443007', '54044001', '54048003', '541000119105',
        '54155004', '54212005', '54213000', '54449002', '54529009', '54679003', '54844002',
        '55472006', '55565007', '55581002', '55589000', '55613002', '55704005', '5577003',
        '55933000', '55976003', '5626004', '56272000', '56313000', '57220000', '5740008',
        '57468008', '57469000', '57734001', '57759005', '57873008', '5792004', '58071009',
        '58703003', '58990004', '59136001', '59204004', '5945005', '59566000', '59733002',
        '59795007', '5984000', '59859005', '60265009', '60401000119104', '60601008', '609441001',
        '609446006', '609447002', '609448007', '609449004', '609450004', '609451000', '609452007',
        '609453002', '609454008', '609455009', '609456005', '609457001', '609458006', '609459003',
        '609460008', '609461007', '609462000', '609463005', '609464004', '609465003', '609466002',
        '609467006', '609468001', '609469009', '609470005', '609471009', '609472002', '609473007',
        '609474001', '609475000', '609476004', '609477008', '609478003', '609479006', '609480009',
        '609482001', '609483006', '609484000', '609485004', '609486003', '609487007', '609489005',
        '609490001', '609491002', '609493004', '609494005', '609496007', '609497003', '609498008',
        '609499000', '609500009', '609501008', '609502001', '609503006', '609504000', '609505004',
        '609506003', '609507007', '609508002', '609510000', '609511001', '609512008', '609513003',
        '609514009', '609515005', '609516006', '609519004', '61007003', '6134000', '61568004',
        '61714007', '61752008', '61810006', '62129004', '62131008', '6234006', '62377009',
        '62410004', '62583006', '62657007', '62698000', '62888008', '63040001', '63287004',
        '63662002', '63795001', '64171002', '64229006', '64646001', '64814003', '64954002',
        '6509007', '65377004', '65402008', '65409004', '6594005', '66119008', '66131005',
        '66294006', '663008', '6636004', '6647006', '66709007', '66844003', '67229002', '67359005',
        '67465009', '67486009', '6802007', '68189005', '682004', '68214002', '6825008', '6891008',
        '69270005', '69344006', '698414000', '698415004', '698497008', '698498003', '698554000',
        '698555004', '698632006', '698638005', '698640000', '698702007', '698708006', '698709003',
        '698710008', '698711007', '698712000', '698713005', '698791008', '698795004', '69897008',
        '69909000', '700038005', '70068004', '702711004', '703309000', '70603007', '707089008',
        '707207004', '70823006', '70964000', '71151000119105', '71216006', '713187004',
        '713191009', '713192002', '713232009', '71362000', '71612002', '716379000', '71639005',
        '7166002', '717816002', '717817006', '717818001', '717819009', '717820003', '717959008',
        '717960003', '71874008', '71909003', '72022006', '721022000', '721153000', '721166000',
        '721177006', '721201001', '72209007', '722570003', '72271000119100', '72301000119103',
        '72321000119107', '72331000119105', '723541004', '723665008', '724484007', '724485008',
        '724486009', '724490006', '724491005', '724492003', '724493008', '724494002', '724496000',
        '724497009', '7245003', '72613009', '7266006', '72860003', '73030000', '73280003',
        '733142005', '733839001', '734857007', '735492001', '737318003', '737320000', '737321001',
        '737322008', '737323003', '737324009', '737325005', '737326006', '737327002', '737329004',
        '737330009', '737331008', '737332001', '737333006', '73790007', '739668007', '73972002',
        '740597009', '74369005', '74955002', '74978008', '75013000', '75022004', '7504005',
        '75150001', '75825001', '75836008', '75933004', '75947000', '76012002', '76472002',
        '765182005', '76751001', '76771005', '76843005', '769087009', '77099001', '77206006',
        '77259008', '77278008', '77563000', '7768008', '77913004', '7809009', '78381004',
        '78408007', '78697003', '78808002', '7910003', '79133008', '79179003', '79222000',
        '79333004', '79355007', '79414005', '79668009', '79748007', '79839005', '80113008',
        '80438008', '8071005', '81448000', '81557008', '81626002', '81677009', '82153002',
        '8218002', '82204006', '82338001', '82771000119102', '83094001', '83916000', '83922009',
        '8393005', '84007008', '84143004', '84216001', '8468007', '84693004', '84939004',
        '85039006', '85331004', '85467007', '85542007', '85632001', '85652000', '85796009',
        '85991008', '86041002', '86081009', '86196005', '86203003', '86256001', '86687009',
        '8670007', '86709000', '86891002', '87038002', '87043009', '87169001', '87383005',
        '8762007', '87621000', '87814002', '87840008', '87967003', '88178009', '88201000119101',
        '88697005', '88887003', '89244003', '89573004', '89672000', '89700002', '8996006',
        '90009001', '90325002', '90450000', '90532005', '90781005', '90968009', '9107002',
        '9111000119104', '91162000', '91217009', '91948008', '91957002', '9293002', '9442009',
        '94631000119100', '9516007', '95605009', '97101000119105', '9901000'
    }


class StableAndUnstableAngina(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the diagnosis of angina.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with stable and unstable angina, pre and post infarction angina, angina decubitus, intermediate coronary syndrome, other unspecified angina or sequelae of myocardial infarction, and other forms of angina pectoris.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1047.47'
    VALUE_SET_NAME = 'Stable and Unstable Angina'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'I200', 'I201', 'I208', 'I209', 'I237'}

    ICD9CM = {'4110', '4111', '4130', '4139', '42979'}

    SNOMEDCT = {'194828000', '233819005', '233821000', '314116003', '4557003', '59021001'}


class CounselingForNutrition(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent nutrition counseling.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with identifying counseling for nutrition, including codes for medical nutrition therapy, dietetics services, education about diet or different types of diets (e.g., low fat diet, high fiber diet
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.195.12.1003'
    VALUE_SET_NAME = 'Counseling for Nutrition'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'97802', '97803', '97804'}

    SNOMEDCT = {
        '11816003', '183059007', '183060002', '183061003', '183062005', '183063000', '183065007',
        '183066008', '183067004', '183070000', '183071001', '226067002', '266724001', '275919002',
        '281085002', '284352003', '305849009', '305850009', '305851008', '306163007', '306164001',
        '306165000', '306626002', '306627006', '306628001', '313210009', '370847001', '386464006',
        '404923009', '408910007', '410171007', '410177006', '410200000', '428461000124101',
        '428691000124107', '429095004', '431482008', '441041000124100', '441201000124108',
        '441231000124100', '441241000124105', '441251000124107', '441261000124109',
        '441271000124102', '441281000124104', '441291000124101', '441301000124100',
        '441311000124102', '441321000124105', '441331000124108', '441341000124103',
        '441351000124101', '443288003', '445291000124103', '445301000124102', '445331000124105',
        '445641000124105', '609104008', '61310001', '698471002', '699827002', '699829004',
        '699830009', '699849008', '700154005', '700258004', '705060005', '710881000'
    }


class SubstanceAbuse(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent substance abuse.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute Principal Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes that identify substance abuse. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1004'
    VALUE_SET_NAME = 'Substance Abuse'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'F1010', 'F1011', 'F10120', 'F10121', 'F10129', 'F1014', 'F10150', 'F10151', 'F10159',
        'F10180', 'F10181', 'F10182', 'F10188', 'F1019', 'F1020', 'F1021', 'F10220', 'F10221',
        'F10229', 'F10230', 'F10231', 'F10232', 'F10239', 'F1024', 'F10250', 'F10251', 'F10259',
        'F1026', 'F1027', 'F10280', 'F10281', 'F10282', 'F10288', 'F1029', 'F10920', 'F10921',
        'F10929', 'F1094', 'F10950', 'F10951', 'F10959', 'F1096', 'F1097', 'F10980', 'F10981',
        'F10982', 'F10988', 'F1099', 'F1110', 'F1111', 'F11120', 'F11121', 'F11122', 'F11129',
        'F1114', 'F11150', 'F11151', 'F11159', 'F11181', 'F11182', 'F11188', 'F1119', 'F1120',
        'F1121', 'F11220', 'F11221', 'F11222', 'F11229', 'F1123', 'F1124', 'F11250', 'F11251',
        'F11259', 'F11281', 'F11282', 'F11288', 'F1129', 'F1190', 'F11920', 'F11921', 'F11922',
        'F11929', 'F1193', 'F1194', 'F11950', 'F11951', 'F11959', 'F11981', 'F11982', 'F11988',
        'F1199', 'F1210', 'F1211', 'F12120', 'F12121', 'F12122', 'F12129', 'F12150', 'F12151',
        'F12159', 'F12180', 'F12188', 'F1219', 'F1220', 'F1221', 'F12220', 'F12221', 'F12222',
        'F12229', 'F12250', 'F12251', 'F12259', 'F12280', 'F12288', 'F1229', 'F1290', 'F12920',
        'F12921', 'F12922', 'F12929', 'F12950', 'F12951', 'F12959', 'F12980', 'F12988', 'F1299',
        'F1310', 'F1311', 'F13120', 'F13121', 'F13129', 'F1314', 'F13150', 'F13151', 'F13159',
        'F13180', 'F13181', 'F13182', 'F13188', 'F1319', 'F1320', 'F1321', 'F13220', 'F13221',
        'F13229', 'F13230', 'F13231', 'F13232', 'F13239', 'F1324', 'F13250', 'F13251', 'F13259',
        'F1326', 'F1327', 'F13280', 'F13281', 'F13282', 'F13288', 'F1329', 'F1390', 'F13920',
        'F13921', 'F13929', 'F13930', 'F13931', 'F13932', 'F13939', 'F1394', 'F13950', 'F13951',
        'F13959', 'F1396', 'F1397', 'F13980', 'F13981', 'F13982', 'F13988', 'F1399', 'F1410',
        'F1411', 'F14120', 'F14121', 'F14122', 'F14129', 'F1414', 'F14150', 'F14151', 'F14159',
        'F14180', 'F14181', 'F14182', 'F14188', 'F1419', 'F1420', 'F1421', 'F14220', 'F14221',
        'F14222', 'F14229', 'F1423', 'F1424', 'F14250', 'F14251', 'F14259', 'F14280', 'F14281',
        'F14282', 'F14288', 'F1429', 'F1490', 'F14920', 'F14921', 'F14922', 'F14929', 'F1494',
        'F14950', 'F14951', 'F14959', 'F14980', 'F14981', 'F14982', 'F14988', 'F1499', 'F1510',
        'F1511', 'F15120', 'F15121', 'F15122', 'F15129', 'F1514', 'F15150', 'F15151', 'F15159',
        'F15180', 'F15181', 'F15182', 'F15188', 'F1519', 'F1520', 'F1521', 'F15220', 'F15221',
        'F15222', 'F15229', 'F1523', 'F1524', 'F15250', 'F15251', 'F15259', 'F15280', 'F15281',
        'F15282', 'F15288', 'F1529', 'F1590', 'F15920', 'F15921', 'F15922', 'F15929', 'F1593',
        'F1594', 'F15950', 'F15951', 'F15959', 'F15980', 'F15981', 'F15982', 'F15988', 'F1599',
        'F1610', 'F1611', 'F16120', 'F16121', 'F16122', 'F16129', 'F1614', 'F16150', 'F16151',
        'F16159', 'F16180', 'F16183', 'F16188', 'F1619', 'F1620', 'F1621', 'F16220', 'F16221',
        'F16229', 'F1624', 'F16250', 'F16251', 'F16259', 'F16280', 'F16283', 'F16288', 'F1629',
        'F1690', 'F16920', 'F16921', 'F16929', 'F1694', 'F16950', 'F16951', 'F16959', 'F16980',
        'F16983', 'F16988', 'F1699', 'F1810', 'F1811', 'F18120', 'F18121', 'F18129', 'F1814',
        'F18150', 'F18151', 'F18159', 'F1817', 'F18180', 'F18188', 'F1819', 'F1820', 'F1821',
        'F18220', 'F18221', 'F18229', 'F1824', 'F18250', 'F18251', 'F18259', 'F1827', 'F18280',
        'F18288', 'F1829', 'F1890', 'F18920', 'F18921', 'F18929', 'F1894', 'F18950', 'F18951',
        'F18959', 'F1897', 'F18980', 'F18988', 'F1899', 'F1910', 'F1911', 'F19120', 'F19121',
        'F19122', 'F19129', 'F1914', 'F19150', 'F19151', 'F19159', 'F1916', 'F1917', 'F19180',
        'F19181', 'F19182', 'F19188', 'F1919', 'F1920', 'F1921', 'F19220', 'F19221', 'F19222',
        'F19229', 'F19230', 'F19231', 'F19232', 'F19239', 'F1924', 'F19250', 'F19251', 'F19259',
        'F1926', 'F1927', 'F19280', 'F19281', 'F19282', 'F19288', 'F1929', 'F1990', 'F19920',
        'F19921', 'F19922', 'F19929', 'F19930', 'F19931', 'F19932', 'F19939', 'F1994', 'F19950',
        'F19951', 'F19959', 'F1996', 'F1997', 'F19980', 'F19981', 'F19982', 'F19988', 'F1999'
    }

    SNOMEDCT = {
        '1081000119105', '110281001', '11047881000119101', '144981000119109', '145101000119102',
        '145841000119107', '1461000119109', '1471000119103', '15167005', '153501000119105',
        '191813001', '191821007', '191827006', '191833002', '191839003', '191851001', '191857002',
        '191869005', '191875001', '191882002', '191883007', '191884001', '191889006', '191891003',
        '191893000', '191894006', '191895007', '191899001', '191900006', '191901005', '191905001',
        '191906000', '191907009', '191909007', '191912005', '191913000', '191914006', '191916008',
        '191918009', '191919001', '191920007', '191924003', '191925002', '191928000', '191930003',
        '191931004', '191932006', '191934007', '191936009', '191937000', '191938005', '231458000',
        '231459008', '231461004', '231462006', '248119008', '26416006', '268645007', '268646008',
        '268647004', '268648009', '280982009', '280983004', '280984005', '280985006', '280986007',
        '284591009', '288281000119100', '304605000', '34111000119108', '37344009', '414874007',
        '425533007', '425841004', '425885002', '426095000', '426590003', '427205009', '427229002',
        '428561000124100', '429001000124103', '429692000', '441527004', '445273005', '49540005',
        '5602001', '64386003', '6525002', '66214007', '70340006', '7071007', '713775002',
        '724694006', '724697004', '724703003', '724712001', '724713006', '737336003', '74851005',
        '762504005', '78267003', '84758004', '91388009', '9769006'
    }


class Dicyclomine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dicyclomine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; dicyclomine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; dicyclomine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1279'
    VALUE_SET_NAME = 'Dicyclomine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'991061', '991065', '991082', '991086'}


class DrospirenoneEstradiol(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent drospirenone / estradiol combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; drospirenone / estradiol (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; drospirenone / estradiol in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1410'
    VALUE_SET_NAME = 'Drospirenone / Estradiol'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1483549', '1483550', '1483552', '1483553'}


class BreastMilk(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent breast milk.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Substance. The intent of this data element is to identify breast milk.
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT codes that identify breast milk.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.30'
    VALUE_SET_NAME = 'Breast Milk'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'226789007', '226790003', '53875002'}


class ComfortMeasures(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent care regimes used to define comfort measure care.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention. The intent of this data element is to identify patients receiving comfort measure care.
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT regime and therapy codes for comfort measures, terminal care, dying care and hospice care.
    Exclusion Criteria: Palliative Care.
    """

    OID = '1.3.6.1.4.1.33895.1.3.0.45'
    VALUE_SET_NAME = 'Comfort Measures'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'133918004', '182964004', '385736008', '385763009'}


class AntithromboticTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent anticoagulant and antiplatelet medications used to reduce stroke mortality and morbidity.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who receive antithrombotic therapy following stroke.
    Inclusion Criteria: Includes only relevant concepts associated with single and multi-ingredient drugs. Oral, rectal, and injectable dose forms should be included. Antithrombotic medications includes only relevant concepts associated with anticoagulants and antiplatelet drugs.
    Exclusion Criteria: Excludes codes for enoxaparin and heparin generally given for VTE prophylaxis.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.201'
    VALUE_SET_NAME = 'Antithrombotic Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1037045', '1037179', '103863', '1092398', '1114198', '1232082', '1232086', '1250907',
        '1291868', '1361574', '1364435', '1364445', '1536467', '1536498', '1536503', '1536675',
        '1536815', '1536833', '1536840', '1537029', '1549682', '1593110', '1599543', '1599551',
        '1599555', '1658717', '1659195', '1659197', '1665356', '1722689', '1723476', '1730187',
        '1804735', '1804737', '1804738', '1811631', '1811632', '198464', '198466', '198467',
        '198471', '198473', '198475', '198479', '198480', '1992427', '199274', '212033', '243670',
        '243685', '243694', '259081', '308278', '308297', '308351', '308363', '308409', '308411',
        '308416', '308417', '309362', '313406', '318272', '359221', '432638', '605252', '692836',
        '702316', '747211', '749196', '763111', '763116', '797050', '827318', '854238', '854241',
        '854245', '854248', '854252', '854255', '855288', '855296', '855302', '855312', '855318',
        '855324', '855332', '855338', '855344', '861356', '861360', '861363', '861365', '863184',
        '863186', '896884', '900528', '978725', '978733', '978736', '978740', '978744', '978746',
        '978755', '978759', '978777', '994430', '994435', '994528', '994535'
    }


class IntravenousOrIntraArterialThrombolyticTpaTherapyPriorToArrival(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnosis codes for intravenous or intra-arterial thrombolytic (t-PA) therapy administered within 24 hours prior to admission.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis. The intent of this data element is to identify administration  intravenous or intra-arterial thrombolytic (t-PA) therapy within 24 hours prior to admission.
    Inclusion Criteria: Includes only relevant concepts associated with administration of intravenous or intra-arterial thrombolytic (t-PA) therapy of within 24 hours prior to admission.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1110.21'
    VALUE_SET_NAME = 'Intravenous or Intra arterial Thrombolytic (tPA) Therapy Prior to Arrival'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z9282'}


class ConjugatedEstrogensMedroxyprogesterone(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent conjugated estrogen / medroxyprogesterone combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; conjugated estrogens / medroxyprogesterone (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; conjugated estrogens / medroxyprogesterone in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1324'
    VALUE_SET_NAME = 'Conjugated Estrogens / Medroxyprogesterone'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1000351', '1000352', '1000355', '1000356'}


class RetinalDetachmentWithRetinalDefect(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of retinal detachment with a retinal defect.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of various types of retinal detachments.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1478'
    VALUE_SET_NAME = 'Retinal Detachment with Retinal Defect'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H33001', 'H33002', 'H33003', 'H33011', 'H33012', 'H33013', 'H33021', 'H33022', 'H33023',
        'H33031', 'H33032', 'H33033', 'H33041', 'H33042', 'H33043', 'H33051', 'H33052', 'H33053',
        'H338'
    }

    ICD9CM = {'36100', '36101', '36102', '36103', '36104', '36105', '36106', '36107'}

    SNOMEDCT = {
        '193319001', '193320007', '193322004', '193323009', '193324003', '193325002', '193326001',
        '193327005', '19620000', '232008001', '232009009', '232010004', '232011000', '232023006',
        '247165009', '314494006', '34711008', '3598000', '38579007', '38599001', '4178006',
        '42059000', '56202001', '7219007'
    }


class AntiHepatitisAIggAntigenTest(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory tests to detect anti hepatitis A immunoglobulin (IgG) antibodies.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Laboratory Test
    Inclusion Criteria: Includes only relevant concepts associated with test codes for IgG antibody to hepatitis A.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1033'
    VALUE_SET_NAME = 'Anti Hepatitis A IgG Antigen Test'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'32018-4', '40724-7', '51913-2'}


class Measles(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent measles infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with measles infections. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1053'
    VALUE_SET_NAME = 'Measles'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'B050', 'B051', 'B052', 'B053', 'B054', 'B0581', 'B0589', 'B059'}

    SNOMEDCT = {
        '105841000119101', '111873003', '14189004', '161419000', '186561002', '186562009',
        '195900001', '240483006', '240484000', '28463004', '371111005', '38921001', '406592004',
        '60013002', '74918002'
    }


class Chlorzoxazone(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorzoxazone medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorzoxazone only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorzoxazone in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1362'
    VALUE_SET_NAME = 'Chlorzoxazone'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1088934', '1088936', '197502'}


class LeftVentricularSystolicDysfunction(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of left ventricular systolic dysfunction.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of left ventricular systolic dysfunction.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1091'
    VALUE_SET_NAME = 'Left Ventricular Systolic Dysfunction'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'134401001'}


class CounselingForPhysicalActivity(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent physical activity counseling.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with identifying counseling or referrals related to physical activity, including codes related to weight management services.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1035'
    VALUE_SET_NAME = 'Counseling for Physical Activity'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '103736005', '183073003', '281090004', '304507003', '304549008', '304558001', '310882002',
        '386291006', '386292004', '386463000', '390864007', '390893007', '398636004', '398752005',
        '408289007', '410200000', '410289001', '410335001', '429778002', '435551000124105',
        '710849009'
    }


class Ambulatory(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent encounters in an ambulatory setting.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with care in an ambulatory setting.
    Exclusion Criteria: Excludes patients who had ambulatory hospice care.
    """

    OID = '2.16.840.1.113883.3.464.1003.122.12.1003'
    VALUE_SET_NAME = 'Ambulatory'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'255327002', '440655000', '722171005'}


class Dysthymia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses related to dysthymia.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnoses for dysthymia, including early and late onset, and primary and secondary dysthymia. This groups ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.67.1.101.1.254'
    VALUE_SET_NAME = 'Dysthymia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'F341'}

    SNOMEDCT = {
        '19694002', '2506003', '3109008', '36170009', '38451003', '67711008', '78667006',
        '83176005', '85080004'
    }


class PatientReasonForAceInhibitorOrArbDecline(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a patient reason for declining angiotensin-converting enzyme (ACE) inhibitor or angiotensin ii receptor blocker (ARB) therapy.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Communication, or may be used as an attribute.
    Inclusion Criteria: Includes only relevant concepts associated with patient reason declining ACE inhibitor or ARB therapy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1140'
    VALUE_SET_NAME = 'Patient Reason for ACE Inhibitor or ARB Decline'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'134397009', '401084003'}


class AllergyToBetaBlockerTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of allergy to beta blocker therapy.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of allergy to beta blocker therapy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1177'
    VALUE_SET_NAME = 'Allergy to Beta Blocker Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '293962009', '293963004', '293964005', '293965006', '293966007', '293967003', '293968008',
        '293969000', '293970004', '293972007', '293973002', '293974008', '293975009', '293976005',
        '293977001', '293978006', '293979003', '293980000', '293981001', '293982008', '293983003',
        '293984009'
    }


class Intussusception(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of intussusception.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of intussusception (a condition of the intestines).
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1056'
    VALUE_SET_NAME = 'Intussusception'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'K561'}

    SNOMEDCT = {
        '111361008', '11578004', '17186003', '197046003', '197047007', '197048002', '197049005',
        '197050005', '197051009', '197052002', '197053007', '197054001', '24610009', '27673007',
        '313326008', '313327004', '38397000', '405558008', '49723003', '721651002', '721676001'
    }


class AdhesionsAndDisruptionsOfIrisAndCiliaryBody(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of adhesions and disruptions of the iris and ciliary body.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of synechiae, iridodialysis, pupillary membranes or abnormalities, and other syndromes of the iris or ciliary body.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1405'
    VALUE_SET_NAME = 'Adhesions and Disruptions of Iris and Ciliary Body'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H2141', 'H2142', 'H2143', 'H21511', 'H21512', 'H21513', 'H21521', 'H21522', 'H21523',
        'H21531', 'H21532', 'H21533', 'H21541', 'H21542', 'H21543', 'H21551', 'H21552', 'H21553',
        'H21561', 'H21562', 'H21563', 'H2181', 'H2182', 'H2189', 'H22'
    }

    ICD9CM = {
        '36470', '36471', '36472', '36473', '36474', '36475', '36476', '36477', '36481', '36482',
        '36489'
    }

    SNOMEDCT = {
        '111512005', '1869002', '193507008', '193525001', '247034002', '247041008', '247043006',
        '251730004', '251731000', '253231007', '253232000', '253233005', '253240006', '267624002',
        '28900006', '302217008', '303019009', '370504007', '404633004', '410556000', '418106004',
        '419237004', '45953007', '55828000', '57286009', '6640008', '70992005', '75895005',
        '78778007', '95710002', '95712005', '95716008'
    }


class PseudoexfoliationSyndrome(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of pseudoexfoliation syndrome.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of pseudoexfoliation of lens or pseudoexfoliation glaucoma.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1435'
    VALUE_SET_NAME = 'Pseudoexfoliation Syndrome'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H401410', 'H401411', 'H401412', 'H401413', 'H401414', 'H401420', 'H401421', 'H401422',
        'H401423', 'H401424', 'H401430', 'H401431', 'H401432', 'H401433', 'H401434'
    }

    ICD9CM = {'36552'}

    SNOMEDCT = {'111514006'}


class FractureLowerBody(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of fracture of a bone in the leg or pelvis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of fracture of the ankle, ilium, acetabulum, pubis, ischium, epiphysis, femur, patella, leg, tibia, fibula, talus, calcaneus, or metatarsal. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes codes that identify pathological or nontraumatic fractures.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1037'
    VALUE_SET_NAME = 'Fracture - Lower Body'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'M8000XA', 'M80051A', 'M80052A', 'M80059A', 'M80061A', 'M80062A', 'M80069A', 'M8008XA',
        'M8080XA', 'M80851A', 'M80852A', 'M80859A', 'M80861A', 'M80862A', 'M80869A', 'M8088XA',
        'M84331A', 'M84332A', 'M84333A', 'M84334A', 'M84339A', 'M84350A', 'M84351A', 'M84352A',
        'M84353A', 'M84359A', 'M84361A', 'M84362A', 'M84363A', 'M84364A', 'M84369A', 'M84371A',
        'M84372A', 'M84373A', 'M8438XA', 'M9701XA', 'M9702XA', 'M9711XA', 'M9712XA', 'M9721XA',
        'M9722XA', 'S32301A', 'S32301B', 'S32301D', 'S32301G', 'S32301K', 'S32301S', 'S32302A',
        'S32302B', 'S32302D', 'S32302G', 'S32302K', 'S32302S', 'S32309A', 'S32309B', 'S32309D',
        'S32309G', 'S32309K', 'S32309S', 'S32311A', 'S32311B', 'S32311D', 'S32311G', 'S32311K',
        'S32311S', 'S32312A', 'S32312B', 'S32312D', 'S32312G', 'S32312K', 'S32312S', 'S32313A',
        'S32313B', 'S32313D', 'S32313G', 'S32313K', 'S32313S', 'S32314A', 'S32314B', 'S32314D',
        'S32314G', 'S32314K', 'S32314S', 'S32315A', 'S32315B', 'S32315D', 'S32315G', 'S32315K',
        'S32315S', 'S32316A', 'S32316B', 'S32316D', 'S32316G', 'S32316K', 'S32316S', 'S32391A',
        'S32391B', 'S32391D', 'S32391G', 'S32391K', 'S32391S', 'S32392A', 'S32392B', 'S32392D',
        'S32392G', 'S32392K', 'S32392S', 'S32399A', 'S32399B', 'S32399D', 'S32399G', 'S32399K',
        'S32399S', 'S32401A', 'S32401B', 'S32401D', 'S32401G', 'S32401K', 'S32401S', 'S32402A',
        'S32402B', 'S32402D', 'S32402G', 'S32402K', 'S32402S', 'S32409A', 'S32409B', 'S32409D',
        'S32409G', 'S32409K', 'S32409S', 'S32411A', 'S32411B', 'S32411D', 'S32411G', 'S32411K',
        'S32411S', 'S32412A', 'S32412B', 'S32412D', 'S32412G', 'S32412K', 'S32412S', 'S32413A',
        'S32413B', 'S32413D', 'S32413G', 'S32413K', 'S32413S', 'S32414A', 'S32414B', 'S32414D',
        'S32414G', 'S32414K', 'S32414S', 'S32415A', 'S32415B', 'S32415D', 'S32415G', 'S32415K',
        'S32415S', 'S32416A', 'S32416B', 'S32416D', 'S32416G', 'S32416K', 'S32416S', 'S32421A',
        'S32421B', 'S32421D', 'S32421G', 'S32421K', 'S32421S', 'S32422A', 'S32422B', 'S32422D',
        'S32422G', 'S32422K', 'S32422S', 'S32423A', 'S32423B', 'S32423D', 'S32423G', 'S32423K',
        'S32423S', 'S32424A', 'S32424B', 'S32424D', 'S32424G', 'S32424K', 'S32424S', 'S32425A',
        'S32425B', 'S32425D', 'S32425G', 'S32425K', 'S32425S', 'S32426A', 'S32426B', 'S32426D',
        'S32426G', 'S32426K', 'S32426S', 'S32431A', 'S32431B', 'S32431D', 'S32431G', 'S32431K',
        'S32431S', 'S32432A', 'S32432B', 'S32432D', 'S32432G', 'S32432K', 'S32432S', 'S32433A',
        'S32433B', 'S32433D', 'S32433G', 'S32433K', 'S32433S', 'S32434A', 'S32434B', 'S32434D',
        'S32434G', 'S32434K', 'S32434S', 'S32435A', 'S32435B', 'S32435D', 'S32435G', 'S32435K',
        'S32435S', 'S32436A', 'S32436B', 'S32436D', 'S32436G', 'S32436K', 'S32436S', 'S32441A',
        'S32441B', 'S32441D', 'S32441G', 'S32441K', 'S32441S', 'S32442A', 'S32442B', 'S32442D',
        'S32442G', 'S32442K', 'S32442S', 'S32443A', 'S32443B', 'S32443D', 'S32443G', 'S32443K',
        'S32443S', 'S32444A', 'S32444B', 'S32444D', 'S32444G', 'S32444K', 'S32444S', 'S32445A',
        'S32445B', 'S32445D', 'S32445G', 'S32445K', 'S32445S', 'S32446A', 'S32446B', 'S32446D',
        'S32446G', 'S32446K', 'S32446S', 'S32451A', 'S32451B', 'S32451D', 'S32451G', 'S32451K',
        'S32451S', 'S32452A', 'S32452B', 'S32452D', 'S32452G', 'S32452K', 'S32452S', 'S32453A',
        'S32453B', 'S32453D', 'S32453G', 'S32453K', 'S32453S', 'S32454A', 'S32454B', 'S32454D',
        'S32454G', 'S32454K', 'S32454S', 'S32455A', 'S32455B', 'S32455D', 'S32455G', 'S32455K',
        'S32455S', 'S32456A', 'S32456B', 'S32456D', 'S32456G', 'S32456K', 'S32456S', 'S32461A',
        'S32461B', 'S32461D', 'S32461G', 'S32461K', 'S32461S', 'S32462A', 'S32462B', 'S32462D',
        'S32462G', 'S32462K', 'S32462S', 'S32463A', 'S32463B', 'S32463D', 'S32463G', 'S32463K',
        'S32463S', 'S32464A', 'S32464B', 'S32464D', 'S32464G', 'S32464K', 'S32464S', 'S32465A',
        'S32465B', 'S32465D', 'S32465G', 'S32465K', 'S32465S', 'S32466A', 'S32466B', 'S32466D',
        'S32466G', 'S32466K', 'S32466S', 'S32471A', 'S32471B', 'S32471D', 'S32471G', 'S32471K',
        'S32471S', 'S32472A', 'S32472B', 'S32472D', 'S32472G', 'S32472K', 'S32472S', 'S32473A',
        'S32473B', 'S32473D', 'S32473G', 'S32473K', 'S32473S', 'S32474A', 'S32474B', 'S32474D',
        'S32474G', 'S32474K', 'S32474S', 'S32475A', 'S32475B', 'S32475D', 'S32475G', 'S32475K',
        'S32475S', 'S32476A', 'S32476B', 'S32476D', 'S32476G', 'S32476K', 'S32476S', 'S32481A',
        'S32481B', 'S32481D', 'S32481G', 'S32481K', 'S32481S', 'S32482A', 'S32482B', 'S32482D',
        'S32482G', 'S32482K', 'S32482S', 'S32483A', 'S32483B', 'S32483D', 'S32483G', 'S32483K',
        'S32483S', 'S32484A', 'S32484B', 'S32484D', 'S32484G', 'S32484K', 'S32484S', 'S32485A',
        'S32485B', 'S32485D', 'S32485G', 'S32485K', 'S32485S', 'S32486A', 'S32486B', 'S32486D',
        'S32486G', 'S32486K', 'S32486S', 'S32491A', 'S32491B', 'S32491D', 'S32491G', 'S32491K',
        'S32491S', 'S32492A', 'S32492B', 'S32492D', 'S32492G', 'S32492K', 'S32492S', 'S32499A',
        'S32499B', 'S32499D', 'S32499G', 'S32499K', 'S32499S', 'S32501A', 'S32501B', 'S32501D',
        'S32501G', 'S32501K', 'S32501S', 'S32502A', 'S32502B', 'S32502D', 'S32502G', 'S32502K',
        'S32502S', 'S32509A', 'S32509B', 'S32509D', 'S32509G', 'S32509K', 'S32509S', 'S32511A',
        'S32511B', 'S32511D', 'S32511G', 'S32511K', 'S32511S', 'S32512A', 'S32512B', 'S32512D',
        'S32512G', 'S32512K', 'S32512S', 'S32519A', 'S32519B', 'S32519D', 'S32519G', 'S32519K',
        'S32519S', 'S32591A', 'S32591B', 'S32591D', 'S32591G', 'S32591K', 'S32591S', 'S32592A',
        'S32592B', 'S32592D', 'S32592G', 'S32592K', 'S32592S', 'S32599A', 'S32599B', 'S32599D',
        'S32599G', 'S32599K', 'S32599S', 'S32601A', 'S32601B', 'S32601D', 'S32601G', 'S32601K',
        'S32601S', 'S32602A', 'S32602B', 'S32602D', 'S32602G', 'S32602K', 'S32602S', 'S32609A',
        'S32609B', 'S32609D', 'S32609G', 'S32609K', 'S32609S', 'S32611A', 'S32611B', 'S32611D',
        'S32611G', 'S32611K', 'S32611S', 'S32612A', 'S32612B', 'S32612D', 'S32612G', 'S32612K',
        'S32612S', 'S32613A', 'S32613B', 'S32613D', 'S32613G', 'S32613K', 'S32613S', 'S32614A',
        'S32614B', 'S32614D', 'S32614G', 'S32614K', 'S32614S', 'S32615A', 'S32615B', 'S32615D',
        'S32615G', 'S32615K', 'S32615S', 'S32616A', 'S32616B', 'S32616D', 'S32616G', 'S32616K',
        'S32616S', 'S32691A', 'S32691B', 'S32691D', 'S32691G', 'S32691K', 'S32691S', 'S32692A',
        'S32692B', 'S32692D', 'S32692G', 'S32692K', 'S32692S', 'S32699A', 'S32699B', 'S32699D',
        'S32699G', 'S32699K', 'S32699S', 'S72001A', 'S72001B', 'S72001C', 'S72001D', 'S72001E',
        'S72001F', 'S72001G', 'S72001H', 'S72001J', 'S72001K', 'S72001M', 'S72001N', 'S72001P',
        'S72001Q', 'S72001R', 'S72001S', 'S72002A', 'S72002B', 'S72002C', 'S72002D', 'S72002E',
        'S72002F', 'S72002G', 'S72002H', 'S72002J', 'S72002K', 'S72002M', 'S72002N', 'S72002P',
        'S72002Q', 'S72002R', 'S72002S', 'S72009A', 'S72009B', 'S72009C', 'S72009D', 'S72009E',
        'S72009F', 'S72009G', 'S72009H', 'S72009J', 'S72009K', 'S72009M', 'S72009N', 'S72009P',
        'S72009Q', 'S72009R', 'S72009S', 'S72011A', 'S72011B', 'S72011C', 'S72011D', 'S72011E',
        'S72011F', 'S72011G', 'S72011H', 'S72011J', 'S72011K', 'S72011M', 'S72011N', 'S72011P',
        'S72011Q', 'S72011R', 'S72011S', 'S72012A', 'S72012B', 'S72012C', 'S72012D', 'S72012E',
        'S72012F', 'S72012G', 'S72012H', 'S72012J', 'S72012K', 'S72012M', 'S72012N', 'S72012P',
        'S72012Q', 'S72012R', 'S72012S', 'S72019A', 'S72019B', 'S72019C', 'S72019D', 'S72019E',
        'S72019F', 'S72019G', 'S72019H', 'S72019J', 'S72019K', 'S72019M', 'S72019N', 'S72019P',
        'S72019Q', 'S72019R', 'S72019S', 'S72021A', 'S72021B', 'S72021C', 'S72021D', 'S72021F',
        'S72021G', 'S72021H', 'S72021J', 'S72021K', 'S72021M', 'S72021N', 'S72021P', 'S72021Q',
        'S72021R', 'S72021S', 'S72022A', 'S72022B', 'S72022C', 'S72022D', 'S72022E', 'S72022F',
        'S72022G', 'S72022H', 'S72022J', 'S72022K', 'S72022M', 'S72022N', 'S72022P', 'S72022Q',
        'S72022R', 'S72022S', 'S72023A', 'S72023B', 'S72023C', 'S72023D', 'S72023E', 'S72023F',
        'S72023G', 'S72023H', 'S72023J', 'S72023K', 'S72023M', 'S72023N', 'S72023P', 'S72023Q',
        'S72023R', 'S72023S', 'S72024A', 'S72024B', 'S72024C', 'S72024D', 'S72024E', 'S72024F',
        'S72024G', 'S72024H', 'S72024J', 'S72024K', 'S72024M', 'S72024N', 'S72024P', 'S72024Q',
        'S72024R', 'S72024S', 'S72025A', 'S72025B', 'S72025C', 'S72025D', 'S72025E', 'S72025F',
        'S72025G', 'S72025H', 'S72025J', 'S72025K', 'S72025M', 'S72025N', 'S72025P', 'S72025Q',
        'S72025R', 'S72025S', 'S72026A', 'S72026B', 'S72026C', 'S72026D', 'S72026E', 'S72026F',
        'S72026G', 'S72026H', 'S72026J', 'S72026K', 'S72026M', 'S72026N', 'S72026P', 'S72026Q',
        'S72026R', 'S72026S', 'S72031A', 'S72031B', 'S72031C', 'S72031D', 'S72031E', 'S72031F',
        'S72031G', 'S72031H', 'S72031J', 'S72031K', 'S72031M', 'S72031N', 'S72031P', 'S72031Q',
        'S72031R', 'S72031S', 'S72032A', 'S72032B', 'S72032C', 'S72032D', 'S72032E', 'S72032F',
        'S72032G', 'S72032H', 'S72032J', 'S72032K', 'S72032M', 'S72032N', 'S72032P', 'S72032Q',
        'S72032R', 'S72032S', 'S72033A', 'S72033B', 'S72033C', 'S72033D', 'S72033E', 'S72033F',
        'S72033G', 'S72033H', 'S72033J', 'S72033K', 'S72033M', 'S72033N', 'S72033P', 'S72033Q',
        'S72033R', 'S72033S', 'S72034A', 'S72034B', 'S72034C', 'S72034D', 'S72034E', 'S72034F',
        'S72034G', 'S72034H', 'S72034J', 'S72034K', 'S72034M', 'S72034N', 'S72034P', 'S72034Q',
        'S72034R', 'S72034S', 'S72035A', 'S72035B', 'S72035C', 'S72035D', 'S72035E', 'S72035F',
        'S72035G', 'S72035H', 'S72035J', 'S72035K', 'S72035M', 'S72035N', 'S72035P', 'S72035Q',
        'S72035R', 'S72035S', 'S72036A', 'S72036B', 'S72036C', 'S72036D', 'S72036E', 'S72036F',
        'S72036G', 'S72036H', 'S72036J', 'S72036K', 'S72036M', 'S72036N', 'S72036P', 'S72036Q',
        'S72036R', 'S72036S', 'S72041A', 'S72041B', 'S72041C', 'S72041D', 'S72041E', 'S72041F',
        'S72041G', 'S72041H', 'S72041J', 'S72041K', 'S72041M', 'S72041N', 'S72041P', 'S72041Q',
        'S72041R', 'S72041S', 'S72042A', 'S72042B', 'S72042C', 'S72042D', 'S72042E', 'S72042F',
        'S72042G', 'S72042H', 'S72042J', 'S72042K', 'S72042M', 'S72042N', 'S72042P', 'S72042Q',
        'S72042R', 'S72042S', 'S72043A', 'S72043B', 'S72043C', 'S72043D', 'S72043E', 'S72043F',
        'S72043G', 'S72043H', 'S72043J', 'S72043K', 'S72043M', 'S72043N', 'S72043P', 'S72043Q',
        'S72043R', 'S72043S', 'S72044A', 'S72044B', 'S72044C', 'S72044D', 'S72044E', 'S72044F',
        'S72044G', 'S72044H', 'S72044J', 'S72044K', 'S72044M', 'S72044N', 'S72044P', 'S72044Q',
        'S72044R', 'S72044S', 'S72045A', 'S72045B', 'S72045C', 'S72045D', 'S72045E', 'S72045F',
        'S72045G', 'S72045H', 'S72045J', 'S72045K', 'S72045M', 'S72045N', 'S72045P', 'S72045Q',
        'S72045R', 'S72045S', 'S72046A', 'S72046B', 'S72046C', 'S72046D', 'S72046E', 'S72046F',
        'S72046G', 'S72046H', 'S72046J', 'S72046K', 'S72046M', 'S72046N', 'S72046P', 'S72046Q',
        'S72046R', 'S72046S', 'S72051A', 'S72051B', 'S72051C', 'S72051D', 'S72051E', 'S72051F',
        'S72051G', 'S72051H', 'S72051J', 'S72051K', 'S72051M', 'S72051N', 'S72051P', 'S72051Q',
        'S72051R', 'S72051S', 'S72052A', 'S72052B', 'S72052C', 'S72052D', 'S72052E', 'S72052F',
        'S72052G', 'S72052H', 'S72052J', 'S72052K', 'S72052M', 'S72052N', 'S72052P', 'S72052Q',
        'S72052R', 'S72052S', 'S72059A', 'S72059B', 'S72059C', 'S72059D', 'S72059E', 'S72059F',
        'S72059G', 'S72059H', 'S72059J', 'S72059K', 'S72059M', 'S72059N', 'S72059P', 'S72059Q',
        'S72059R', 'S72059S', 'S72061A', 'S72061B', 'S72061C', 'S72061D', 'S72061E', 'S72061F',
        'S72061G', 'S72061H', 'S72061J', 'S72061K', 'S72061M', 'S72061N', 'S72061P', 'S72061Q',
        'S72061R', 'S72061S', 'S72062A', 'S72062B', 'S72062C', 'S72062D', 'S72062E', 'S72062F',
        'S72062G', 'S72062H', 'S72062J', 'S72062K', 'S72062M', 'S72062N', 'S72062P', 'S72062Q',
        'S72062R', 'S72062S', 'S72063A', 'S72063B', 'S72063C', 'S72063D', 'S72063E', 'S72063F',
        'S72063G', 'S72063H', 'S72063J', 'S72063K', 'S72063M', 'S72063N', 'S72063P', 'S72063Q',
        'S72063R', 'S72063S', 'S72064A', 'S72064B', 'S72064C', 'S72064D', 'S72064E', 'S72064F',
        'S72064G', 'S72064H', 'S72064J', 'S72064K', 'S72064M', 'S72064N', 'S72064P', 'S72064Q',
        'S72064R', 'S72064S', 'S72065A', 'S72065B', 'S72065C', 'S72065D', 'S72065E', 'S72065F',
        'S72065G', 'S72065H', 'S72065J', 'S72065K', 'S72065M', 'S72065N', 'S72065P', 'S72065Q',
        'S72065R', 'S72065S', 'S72066A', 'S72066B', 'S72066C', 'S72066D', 'S72066E', 'S72066F',
        'S72066G', 'S72066H', 'S72066J', 'S72066K', 'S72066M', 'S72066N', 'S72066P', 'S72066Q',
        'S72066R', 'S72066S', 'S72091A', 'S72091B', 'S72091C', 'S72091D', 'S72091E', 'S72091F',
        'S72091G', 'S72091H', 'S72091J', 'S72091K', 'S72091M', 'S72091N', 'S72091P', 'S72091Q',
        'S72091R', 'S72091S', 'S72092A', 'S72092B', 'S72092C', 'S72092D', 'S72092E', 'S72092F',
        'S72092G', 'S72092H', 'S72092J', 'S72092K', 'S72092M', 'S72092N', 'S72092P', 'S72092Q',
        'S72092R', 'S72092S', 'S72099A', 'S72099B', 'S72099C', 'S72099D', 'S72099E', 'S72099F',
        'S72099G', 'S72099H', 'S72099J', 'S72099K', 'S72099M', 'S72099N', 'S72099P', 'S72099Q',
        'S72099R', 'S72099S', 'S72101A', 'S72101B', 'S72101C', 'S72101D', 'S72101E', 'S72101F',
        'S72101G', 'S72101H', 'S72101J', 'S72101K', 'S72101M', 'S72101N', 'S72101P', 'S72101Q',
        'S72101R', 'S72101S', 'S72102A', 'S72102B', 'S72102C', 'S72102D', 'S72102E', 'S72102F',
        'S72102G', 'S72102H', 'S72102J', 'S72102K', 'S72102M', 'S72102N', 'S72102P', 'S72102Q',
        'S72102R', 'S72102S', 'S72109A', 'S72109B', 'S72109C', 'S72109D', 'S72109E', 'S72109F',
        'S72109G', 'S72109H', 'S72109J', 'S72109K', 'S72109M', 'S72109N', 'S72109P', 'S72109Q',
        'S72109R', 'S72109S', 'S72111A', 'S72111B', 'S72111C', 'S72111D', 'S72111E', 'S72111F',
        'S72111G', 'S72111H', 'S72111J', 'S72111K', 'S72111M', 'S72111N', 'S72111P', 'S72111Q',
        'S72111R', 'S72111S', 'S72112A', 'S72112B', 'S72112C', 'S72112D', 'S72112E', 'S72112F',
        'S72112G', 'S72112H', 'S72112J', 'S72112K', 'S72112M', 'S72112N', 'S72112P', 'S72112Q',
        'S72112R', 'S72112S', 'S72113A', 'S72113B', 'S72113C', 'S72113D', 'S72113E', 'S72113F',
        'S72113G', 'S72113H', 'S72113J', 'S72113K', 'S72113M', 'S72113N', 'S72113P', 'S72113Q',
        'S72113R', 'S72113S', 'S72114A', 'S72114B', 'S72114C', 'S72114D', 'S72114E', 'S72114F',
        'S72114G', 'S72114H', 'S72114J', 'S72114K', 'S72114M', 'S72114N', 'S72114P', 'S72114Q',
        'S72114R', 'S72114S', 'S72115A', 'S72115B', 'S72115C', 'S72115D', 'S72115E', 'S72115F',
        'S72115G', 'S72115H', 'S72115J', 'S72115K', 'S72115M', 'S72115N', 'S72115P', 'S72115Q',
        'S72115R', 'S72115S', 'S72116A', 'S72116B', 'S72116C', 'S72116D', 'S72116E', 'S72116F',
        'S72116G', 'S72116H', 'S72116J', 'S72116K', 'S72116M', 'S72116N', 'S72116P', 'S72116Q',
        'S72116R', 'S72116S', 'S72121A', 'S72121B', 'S72121C', 'S72121D', 'S72121E', 'S72121F',
        'S72121G', 'S72121H', 'S72121J', 'S72121K', 'S72121M', 'S72121N', 'S72121P', 'S72121Q',
        'S72121R', 'S72121S', 'S72122A', 'S72122B', 'S72122C', 'S72122D', 'S72122E', 'S72122F',
        'S72122G', 'S72122H', 'S72122J', 'S72122K', 'S72122M', 'S72122N', 'S72122P', 'S72122Q',
        'S72122R', 'S72122S', 'S72123A', 'S72123B', 'S72123C', 'S72123D', 'S72123E', 'S72123F',
        'S72123G', 'S72123H', 'S72123J', 'S72123K', 'S72123M', 'S72123N', 'S72123P', 'S72123Q',
        'S72123R', 'S72123S', 'S72124A', 'S72124B', 'S72124C', 'S72124D', 'S72124E', 'S72124F',
        'S72124G', 'S72124H', 'S72124J', 'S72124K', 'S72124M', 'S72124N', 'S72124P', 'S72124Q',
        'S72124R', 'S72124S', 'S72125A', 'S72125B', 'S72125C', 'S72125D', 'S72125E', 'S72125F',
        'S72125G', 'S72125H', 'S72125J', 'S72125K', 'S72125M', 'S72125N', 'S72125P', 'S72125Q',
        'S72125R', 'S72125S', 'S72126A', 'S72126B', 'S72126C', 'S72126D', 'S72126E', 'S72126F',
        'S72126G', 'S72126H', 'S72126J', 'S72126K', 'S72126M', 'S72126N', 'S72126P', 'S72126Q',
        'S72126R', 'S72126S', 'S72131A', 'S72131B', 'S72131C', 'S72131D', 'S72131E', 'S72131F',
        'S72131G', 'S72131H', 'S72131J', 'S72131K', 'S72131M', 'S72131N', 'S72131P', 'S72131Q',
        'S72131R', 'S72131S', 'S72132A', 'S72132B', 'S72132C', 'S72132D', 'S72132E', 'S72132F',
        'S72132G', 'S72132H', 'S72132J', 'S72132K', 'S72132M', 'S72132N', 'S72132P', 'S72132Q',
        'S72132R', 'S72132S', 'S72133A', 'S72133B', 'S72133C', 'S72133D', 'S72133E', 'S72133F',
        'S72133G', 'S72133H', 'S72133J', 'S72133K', 'S72133M', 'S72133N', 'S72133P', 'S72133Q',
        'S72133R', 'S72133S', 'S72134A', 'S72134B', 'S72134C', 'S72134D', 'S72134E', 'S72134F',
        'S72134G', 'S72134H', 'S72134J', 'S72134K', 'S72134M', 'S72134N', 'S72134P', 'S72134Q',
        'S72134R', 'S72134S', 'S72135A', 'S72135B', 'S72135C', 'S72135D', 'S72135E', 'S72135F',
        'S72135G', 'S72135H', 'S72135J', 'S72135K', 'S72135M', 'S72135N', 'S72135P', 'S72135Q',
        'S72135R', 'S72135S', 'S72136A', 'S72136B', 'S72136C', 'S72136D', 'S72136E', 'S72136F',
        'S72136G', 'S72136H', 'S72136J', 'S72136K', 'S72136M', 'S72136N', 'S72136P', 'S72136Q',
        'S72136R', 'S72136S', 'S72141A', 'S72141B', 'S72141C', 'S72141D', 'S72141E', 'S72141F',
        'S72141G', 'S72141H', 'S72141J', 'S72141K', 'S72141M', 'S72141N', 'S72141P', 'S72141Q',
        'S72141R', 'S72141S', 'S72142A', 'S72142B', 'S72142C', 'S72142D', 'S72142E', 'S72142F',
        'S72142G', 'S72142H', 'S72142J', 'S72142K', 'S72142M', 'S72142N', 'S72142P', 'S72142Q',
        'S72142R', 'S72142S', 'S72143A', 'S72143B', 'S72143C', 'S72143D', 'S72143E', 'S72143F',
        'S72143G', 'S72143H', 'S72143J', 'S72143K', 'S72143M', 'S72143N', 'S72143P', 'S72143Q',
        'S72143R', 'S72143S', 'S72144A', 'S72144B', 'S72144C', 'S72144D', 'S72144E', 'S72144F',
        'S72144G', 'S72144H', 'S72144J', 'S72144K', 'S72144M', 'S72144N', 'S72144P', 'S72144Q',
        'S72144R', 'S72144S', 'S72145A', 'S72145B', 'S72145C', 'S72145D', 'S72145E', 'S72145F',
        'S72145G', 'S72145H', 'S72145J', 'S72145K', 'S72145M', 'S72145N', 'S72145P', 'S72145Q',
        'S72145R', 'S72145S', 'S72146A', 'S72146B', 'S72146C', 'S72146D', 'S72146E', 'S72146F',
        'S72146G', 'S72146H', 'S72146J', 'S72146K', 'S72146M', 'S72146N', 'S72146P', 'S72146Q',
        'S72146R', 'S72146S', 'S7221XA', 'S7221XB', 'S7221XC', 'S7221XD', 'S7221XE', 'S7221XF',
        'S7221XG', 'S7221XH', 'S7221XJ', 'S7221XK', 'S7221XM', 'S7221XN', 'S7221XP', 'S7221XQ',
        'S7221XR', 'S7221XS', 'S7222XA', 'S7222XB', 'S7222XC', 'S7222XD', 'S7222XE', 'S7222XF',
        'S7222XG', 'S7222XH', 'S7222XJ', 'S7222XK', 'S7222XM', 'S7222XN', 'S7222XP', 'S7222XQ',
        'S7222XR', 'S7222XS', 'S7223XA', 'S7223XB', 'S7223XC', 'S7223XD', 'S7223XE', 'S7223XF',
        'S7223XG', 'S7223XH', 'S7223XJ', 'S7223XK', 'S7223XM', 'S7223XN', 'S7223XP', 'S7223XQ',
        'S7223XR', 'S7223XS', 'S7224XA', 'S7224XB', 'S7224XC', 'S7224XD', 'S7224XE', 'S7224XF',
        'S7224XG', 'S7224XH', 'S7224XJ', 'S7224XK', 'S7224XM', 'S7224XN', 'S7224XP', 'S7224XQ',
        'S7224XR', 'S7224XS', 'S7225XA', 'S7225XB', 'S7225XC', 'S7225XD', 'S7225XE', 'S7225XF',
        'S7225XG', 'S7225XH', 'S7225XJ', 'S7225XK', 'S7225XM', 'S7225XN', 'S7225XP', 'S7225XQ',
        'S7225XR', 'S7225XS', 'S7226XA', 'S7226XB', 'S7226XC', 'S7226XD', 'S7226XE', 'S7226XF',
        'S7226XG', 'S7226XH', 'S7226XJ', 'S7226XK', 'S7226XM', 'S7226XN', 'S7226XP', 'S7226XQ',
        'S7226XR', 'S7226XS', 'S72301A', 'S72301B', 'S72301C', 'S72301D', 'S72301E', 'S72301F',
        'S72301G', 'S72301H', 'S72301J', 'S72301K', 'S72301M', 'S72301N', 'S72301P', 'S72301Q',
        'S72301R', 'S72301S', 'S72302A', 'S72302B', 'S72302C', 'S72302D', 'S72302E', 'S72302F',
        'S72302G', 'S72302H', 'S72302J', 'S72302K', 'S72302M', 'S72302N', 'S72302P', 'S72302Q',
        'S72302R', 'S72302S', 'S72309A', 'S72309B', 'S72309C', 'S72309D', 'S72309E', 'S72309F',
        'S72309G', 'S72309H', 'S72309J', 'S72309K', 'S72309M', 'S72309N', 'S72309P', 'S72309Q',
        'S72309R', 'S72309S', 'S72321A', 'S72321B', 'S72321C', 'S72321D', 'S72321E', 'S72321F',
        'S72321G', 'S72321H', 'S72321J', 'S72321K', 'S72321M', 'S72321N', 'S72321P', 'S72321Q',
        'S72321R', 'S72321S', 'S72322A', 'S72322B', 'S72322C', 'S72322D', 'S72322E', 'S72322F',
        'S72322G', 'S72322H', 'S72322J', 'S72322K', 'S72322M', 'S72322N', 'S72322P', 'S72322Q',
        'S72322R', 'S72322S', 'S72323A', 'S72323B', 'S72323C', 'S72323D', 'S72323E', 'S72323F',
        'S72323G', 'S72323H', 'S72323J', 'S72323K', 'S72323M', 'S72323N', 'S72323P', 'S72323Q',
        'S72323R', 'S72323S', 'S72324A', 'S72324B', 'S72324C', 'S72324D', 'S72324E', 'S72324F',
        'S72324G', 'S72324H', 'S72324J', 'S72324K', 'S72324M', 'S72324N', 'S72324P', 'S72324Q',
        'S72324R', 'S72324S', 'S72325A', 'S72325B', 'S72325C', 'S72325D', 'S72325E', 'S72325F',
        'S72325G', 'S72325H', 'S72325J', 'S72325K', 'S72325M', 'S72325N', 'S72325P', 'S72325Q',
        'S72325R', 'S72325S', 'S72326A', 'S72326B', 'S72326C', 'S72326D', 'S72326E', 'S72326F',
        'S72326G', 'S72326H', 'S72326J', 'S72326K', 'S72326M', 'S72326N', 'S72326P', 'S72326Q',
        'S72326R', 'S72326S', 'S72331A', 'S72331B', 'S72331C', 'S72331D', 'S72331E', 'S72331F',
        'S72331G', 'S72331H', 'S72331J', 'S72331K', 'S72331M', 'S72331N', 'S72331P', 'S72331Q',
        'S72331R', 'S72331S', 'S72332A', 'S72332B', 'S72332C', 'S72332D', 'S72332E', 'S72332F',
        'S72332G', 'S72332H', 'S72332J', 'S72332K', 'S72332M', 'S72332N', 'S72332P', 'S72332Q',
        'S72332R', 'S72332S', 'S72333A', 'S72333B', 'S72333C', 'S72333D', 'S72333E', 'S72333F',
        'S72333G', 'S72333H', 'S72333J', 'S72333K', 'S72333M', 'S72333N', 'S72333P', 'S72333Q',
        'S72333R', 'S72333S', 'S72334A', 'S72334B', 'S72334C', 'S72334D', 'S72334E', 'S72334F',
        'S72334G', 'S72334H', 'S72334J', 'S72334K', 'S72334M', 'S72334N', 'S72334P', 'S72334Q',
        'S72334R', 'S72334S', 'S72335A', 'S72335B', 'S72335C', 'S72335D', 'S72335E', 'S72335F',
        'S72335G', 'S72335H', 'S72335J', 'S72335K', 'S72335M', 'S72335N', 'S72335P', 'S72335Q',
        'S72335R', 'S72335S', 'S72336A', 'S72336B', 'S72336C', 'S72336D', 'S72336E', 'S72336F',
        'S72336G', 'S72336H', 'S72336J', 'S72336K', 'S72336M', 'S72336N', 'S72336P', 'S72336Q',
        'S72336R', 'S72336S', 'S72341A', 'S72341B', 'S72341C', 'S72341D', 'S72341E', 'S72341F',
        'S72341G', 'S72341H', 'S72341J', 'S72341K', 'S72341M', 'S72341N', 'S72341P', 'S72341Q',
        'S72341R', 'S72341S', 'S72342A', 'S72342B', 'S72342C', 'S72342D', 'S72342E', 'S72342F',
        'S72342G', 'S72342H', 'S72342J', 'S72342K', 'S72342M', 'S72342N', 'S72342P', 'S72342Q',
        'S72342R', 'S72342S', 'S72343A', 'S72343B', 'S72343C', 'S72343D', 'S72343E', 'S72343F',
        'S72343G', 'S72343H', 'S72343J', 'S72343K', 'S72343M', 'S72343N', 'S72343P', 'S72343Q',
        'S72343R', 'S72343S', 'S72344A', 'S72344B', 'S72344C', 'S72344D', 'S72344E', 'S72344F',
        'S72344G', 'S72344H', 'S72344J', 'S72344K', 'S72344M', 'S72344N', 'S72344P', 'S72344Q',
        'S72344R', 'S72344S', 'S72345A', 'S72345B', 'S72345C', 'S72345D', 'S72345E', 'S72345F',
        'S72345G', 'S72345H', 'S72345J', 'S72345K', 'S72345M', 'S72345N', 'S72345P', 'S72345Q',
        'S72345R', 'S72345S', 'S72346A', 'S72346B', 'S72346C', 'S72346D', 'S72346E', 'S72346F',
        'S72346G', 'S72346H', 'S72346J', 'S72346K', 'S72346M', 'S72346N', 'S72346P', 'S72346Q',
        'S72346R', 'S72346S', 'S72351A', 'S72351B', 'S72351C', 'S72351D', 'S72351E', 'S72351F',
        'S72351G', 'S72351H', 'S72351J', 'S72351K', 'S72351M', 'S72351N', 'S72351P', 'S72351Q',
        'S72351R', 'S72351S', 'S72352A', 'S72352B', 'S72352C', 'S72352D', 'S72352E', 'S72352F',
        'S72352G', 'S72352H', 'S72352J', 'S72352K', 'S72352M', 'S72352N', 'S72352P', 'S72352Q',
        'S72352R', 'S72352S', 'S72353A', 'S72353B', 'S72353C', 'S72353D', 'S72353E', 'S72353F',
        'S72353G', 'S72353H', 'S72353J', 'S72353K', 'S72353M', 'S72353N', 'S72353P', 'S72353Q',
        'S72353R', 'S72353S', 'S72354A', 'S72354B', 'S72354C', 'S72354D', 'S72354E', 'S72354F',
        'S72354G', 'S72354H', 'S72354J', 'S72354K', 'S72354M', 'S72354N', 'S72354P', 'S72354Q',
        'S72354R', 'S72354S', 'S72355A', 'S72355B', 'S72355C', 'S72355D', 'S72355E', 'S72355F',
        'S72355G', 'S72355H', 'S72355J', 'S72355K', 'S72355M', 'S72355N', 'S72355P', 'S72355Q',
        'S72355R', 'S72355S', 'S72356A', 'S72356B', 'S72356C', 'S72356D', 'S72356E', 'S72356F',
        'S72356G', 'S72356H', 'S72356J', 'S72356K', 'S72356M', 'S72356N', 'S72356P', 'S72356Q',
        'S72356R', 'S72356S', 'S72361A', 'S72361B', 'S72361C', 'S72361D', 'S72361E', 'S72361F',
        'S72361G', 'S72361H', 'S72361J', 'S72361K', 'S72361M', 'S72361N', 'S72361P', 'S72361Q',
        'S72361R', 'S72361S', 'S72362A', 'S72362B', 'S72362C', 'S72362D', 'S72362E', 'S72362F',
        'S72362G', 'S72362H', 'S72362J', 'S72362K', 'S72362M', 'S72362N', 'S72362P', 'S72362Q',
        'S72362R', 'S72362S', 'S72363A', 'S72363B', 'S72363C', 'S72363D', 'S72363E', 'S72363F',
        'S72363G', 'S72363H', 'S72363J', 'S72363K', 'S72363M', 'S72363N', 'S72363P', 'S72363Q',
        'S72363R', 'S72363S', 'S72364A', 'S72364B', 'S72364C', 'S72364D', 'S72364E', 'S72364F',
        'S72364G', 'S72364H', 'S72364J', 'S72364K', 'S72364M', 'S72364N', 'S72364P', 'S72364Q',
        'S72364R', 'S72364S', 'S72365A', 'S72365B', 'S72365C', 'S72365D', 'S72365E', 'S72365F',
        'S72365G', 'S72365H', 'S72365J', 'S72365K', 'S72365M', 'S72365N', 'S72365P', 'S72365Q',
        'S72365R', 'S72365S', 'S72366A', 'S72366B', 'S72366C', 'S72366D', 'S72366E', 'S72366F',
        'S72366G', 'S72366H', 'S72366J', 'S72366K', 'S72366M', 'S72366N', 'S72366P', 'S72366Q',
        'S72366R', 'S72366S', 'S72391A', 'S72391B', 'S72391C', 'S72391D', 'S72391E', 'S72391F',
        'S72391G', 'S72391H', 'S72391J', 'S72391K', 'S72391M', 'S72391N', 'S72391P', 'S72391Q',
        'S72391R', 'S72391S', 'S72392A', 'S72392B', 'S72392C', 'S72392D', 'S72392E', 'S72392F',
        'S72392G', 'S72392H', 'S72392J', 'S72392K', 'S72392M', 'S72392N', 'S72392P', 'S72392Q',
        'S72392R', 'S72392S', 'S72399A', 'S72399B', 'S72399C', 'S72399D', 'S72399E', 'S72399F',
        'S72399G', 'S72399H', 'S72399J', 'S72399K', 'S72399M', 'S72399N', 'S72399P', 'S72399Q',
        'S72399R', 'S72399S', 'S72401A', 'S72401B', 'S72401C', 'S72401D', 'S72401E', 'S72401F',
        'S72401G', 'S72401H', 'S72401J', 'S72401K', 'S72401M', 'S72401N', 'S72401P', 'S72401Q',
        'S72401R', 'S72401S', 'S72402A', 'S72402B', 'S72402C', 'S72402D', 'S72402E', 'S72402F',
        'S72402G', 'S72402H', 'S72402J', 'S72402K', 'S72402M', 'S72402N', 'S72402P', 'S72402Q',
        'S72402R', 'S72402S', 'S72409A', 'S72409B', 'S72409C', 'S72409D', 'S72409E', 'S72409F',
        'S72409G', 'S72409H', 'S72409J', 'S72409K', 'S72409M', 'S72409N', 'S72409P', 'S72409Q',
        'S72409R', 'S72409S', 'S72411A', 'S72411B', 'S72411C', 'S72411D', 'S72411E', 'S72411F',
        'S72411G', 'S72411H', 'S72411J', 'S72411K', 'S72411M', 'S72411N', 'S72411P', 'S72411Q',
        'S72411R', 'S72411S', 'S72412A', 'S72412B', 'S72412C', 'S72412D', 'S72412E', 'S72412F',
        'S72412G', 'S72412H', 'S72412J', 'S72412K', 'S72412M', 'S72412N', 'S72412P', 'S72412Q',
        'S72412R', 'S72412S', 'S72413A', 'S72413B', 'S72413C', 'S72413D', 'S72413E', 'S72413F',
        'S72413G', 'S72413H', 'S72413J', 'S72413K', 'S72413M', 'S72413N', 'S72413P', 'S72413Q',
        'S72413R', 'S72413S', 'S72414A', 'S72414B', 'S72414C', 'S72414D', 'S72414E', 'S72414F',
        'S72414G', 'S72414H', 'S72414J', 'S72414K', 'S72414M', 'S72414N', 'S72414P', 'S72414Q',
        'S72414R', 'S72414S', 'S72415A', 'S72415B', 'S72415C', 'S72415D', 'S72415E', 'S72415F',
        'S72415G', 'S72415H', 'S72415J', 'S72415K', 'S72415M', 'S72415N', 'S72415P', 'S72415Q',
        'S72415R', 'S72415S', 'S72416A', 'S72416B', 'S72416C', 'S72416D', 'S72416E', 'S72416F',
        'S72416G', 'S72416H', 'S72416J', 'S72416K', 'S72416M', 'S72416N', 'S72416P', 'S72416Q',
        'S72416R', 'S72416S', 'S72421A', 'S72421B', 'S72421C', 'S72421D', 'S72421E', 'S72421F',
        'S72421G', 'S72421H', 'S72421J', 'S72421K', 'S72421M', 'S72421N', 'S72421P', 'S72421Q',
        'S72421R', 'S72421S', 'S72422A', 'S72422B', 'S72422C', 'S72422D', 'S72422E', 'S72422F',
        'S72422G', 'S72422H', 'S72422J', 'S72422K', 'S72422M', 'S72422N', 'S72422P', 'S72422Q',
        'S72422R', 'S72422S', 'S72423A', 'S72423B', 'S72423C', 'S72423D', 'S72423E', 'S72423F',
        'S72423G', 'S72423H', 'S72423J', 'S72423K', 'S72423M', 'S72423N', 'S72423P', 'S72423Q',
        'S72423R', 'S72423S', 'S72424A', 'S72424B', 'S72424C', 'S72424D', 'S72424E', 'S72424F',
        'S72424G', 'S72424H', 'S72424J', 'S72424K', 'S72424M', 'S72424N', 'S72424P', 'S72424Q',
        'S72424R', 'S72424S', 'S72425A', 'S72425B', 'S72425C', 'S72425D', 'S72425E', 'S72425F',
        'S72425G', 'S72425H', 'S72425J', 'S72425K', 'S72425M', 'S72425N', 'S72425P', 'S72425Q',
        'S72425R', 'S72425S', 'S72426A', 'S72426B', 'S72426C', 'S72426D', 'S72426E', 'S72426F',
        'S72426G', 'S72426H', 'S72426J', 'S72426K', 'S72426M', 'S72426N', 'S72426P', 'S72426Q',
        'S72426R', 'S72426S', 'S72431A', 'S72431B', 'S72431C', 'S72431D', 'S72431E', 'S72431F',
        'S72431G', 'S72431H', 'S72431J', 'S72431K', 'S72431M', 'S72431N', 'S72431P', 'S72431Q',
        'S72431R', 'S72431S', 'S72432A', 'S72432B', 'S72432C', 'S72432D', 'S72432E', 'S72432F',
        'S72432G', 'S72432H', 'S72432J', 'S72432K', 'S72432M', 'S72432N', 'S72432P', 'S72432Q',
        'S72432R', 'S72432S', 'S72433A', 'S72433B', 'S72433C', 'S72433D', 'S72433E', 'S72433F',
        'S72433G', 'S72433H', 'S72433J', 'S72433K', 'S72433M', 'S72433N', 'S72433P', 'S72433Q',
        'S72433R', 'S72433S', 'S72434A', 'S72434B', 'S72434C', 'S72434D', 'S72434E', 'S72434F',
        'S72434G', 'S72434H', 'S72434J', 'S72434K', 'S72434M', 'S72434N', 'S72434P', 'S72434Q',
        'S72434R', 'S72434S', 'S72435A', 'S72435B', 'S72435C', 'S72435D', 'S72435E', 'S72435F',
        'S72435G', 'S72435H', 'S72435J', 'S72435K', 'S72435M', 'S72435N', 'S72435P', 'S72435Q',
        'S72435R', 'S72435S', 'S72436A', 'S72436B', 'S72436C', 'S72436D', 'S72436E', 'S72436F',
        'S72436G', 'S72436H', 'S72436J', 'S72436K', 'S72436M', 'S72436N', 'S72436P', 'S72436Q',
        'S72436R', 'S72436S', 'S72441A', 'S72441B', 'S72441C', 'S72441D', 'S72441E', 'S72441F',
        'S72441G', 'S72441H', 'S72441J', 'S72441K', 'S72441M', 'S72441N', 'S72441P', 'S72441Q',
        'S72441R', 'S72441S', 'S72442A', 'S72442B', 'S72442C', 'S72442D', 'S72442E', 'S72442F',
        'S72442G', 'S72442H', 'S72442J', 'S72442K', 'S72442M', 'S72442N', 'S72442P', 'S72442Q',
        'S72442R', 'S72442S', 'S72443A', 'S72443B', 'S72443C', 'S72443D', 'S72443E', 'S72443F',
        'S72443G', 'S72443H', 'S72443J', 'S72443K', 'S72443M', 'S72443N', 'S72443P', 'S72443Q',
        'S72443R', 'S72443S', 'S72444A', 'S72444B', 'S72444C', 'S72444D', 'S72444E', 'S72444F',
        'S72444G', 'S72444H', 'S72444J', 'S72444K', 'S72444M', 'S72444N', 'S72444P', 'S72444Q',
        'S72444R', 'S72444S', 'S72445A', 'S72445B', 'S72445C', 'S72445D', 'S72445E', 'S72445F',
        'S72445G', 'S72445H', 'S72445J', 'S72445K', 'S72445M', 'S72445N', 'S72445P', 'S72445Q',
        'S72445R', 'S72445S', 'S72446A', 'S72446B', 'S72446C', 'S72446D', 'S72446E', 'S72446F',
        'S72446G', 'S72446H', 'S72446J', 'S72446K', 'S72446M', 'S72446N', 'S72446P', 'S72446Q',
        'S72446R', 'S72446S', 'S72451A', 'S72451B', 'S72451C', 'S72451D', 'S72451E', 'S72451F',
        'S72451G', 'S72451H', 'S72451J', 'S72451K', 'S72451M', 'S72451N', 'S72451P', 'S72451Q',
        'S72451R', 'S72451S', 'S72452A', 'S72452B', 'S72452C', 'S72452D', 'S72452E', 'S72452F',
        'S72452G', 'S72452H', 'S72452J', 'S72452K', 'S72452M', 'S72452N', 'S72452P', 'S72452Q',
        'S72452R', 'S72452S', 'S72453A', 'S72453B', 'S72453C', 'S72453D', 'S72453E', 'S72453F',
        'S72453G', 'S72453H', 'S72453J', 'S72453K', 'S72453M', 'S72453N', 'S72453P', 'S72453Q',
        'S72453R', 'S72453S', 'S72454A', 'S72454B', 'S72454C', 'S72454D', 'S72454E', 'S72454F',
        'S72454G', 'S72454H', 'S72454J', 'S72454K', 'S72454M', 'S72454N', 'S72454P', 'S72454Q',
        'S72454R', 'S72454S', 'S72455A', 'S72455B', 'S72455C', 'S72455D', 'S72455E', 'S72455F',
        'S72455G', 'S72455H', 'S72455J', 'S72455K', 'S72455M', 'S72455N', 'S72455P', 'S72455Q',
        'S72455R', 'S72455S', 'S72456A', 'S72456B', 'S72456C', 'S72456D', 'S72456E', 'S72456F',
        'S72456G', 'S72456H', 'S72456J', 'S72456K', 'S72456M', 'S72456N', 'S72456P', 'S72456Q',
        'S72456R', 'S72456S', 'S72461A', 'S72461B', 'S72461C', 'S72461D', 'S72461E', 'S72461F',
        'S72461G', 'S72461H', 'S72461J', 'S72461K', 'S72461M', 'S72461N', 'S72461P', 'S72461Q',
        'S72461R', 'S72461S', 'S72462A', 'S72462B', 'S72462C', 'S72462D', 'S72462E', 'S72462F',
        'S72462G', 'S72462H', 'S72462J', 'S72462K', 'S72462M', 'S72462N', 'S72462P', 'S72462Q',
        'S72462R', 'S72462S', 'S72463A', 'S72463B', 'S72463C', 'S72463D', 'S72463E', 'S72463F',
        'S72463G', 'S72463H', 'S72463J', 'S72463K', 'S72463M', 'S72463N', 'S72463P', 'S72463Q',
        'S72463R', 'S72463S', 'S72464A', 'S72464B', 'S72464C', 'S72464D', 'S72464E', 'S72464F',
        'S72464G', 'S72464H', 'S72464J', 'S72464K', 'S72464M', 'S72464N', 'S72464P', 'S72464Q',
        'S72464R', 'S72464S', 'S72465A', 'S72465B', 'S72465C', 'S72465D', 'S72465E', 'S72465F',
        'S72465G', 'S72465H', 'S72465J', 'S72465K', 'S72465M', 'S72465N', 'S72465P', 'S72465Q',
        'S72465R', 'S72465S', 'S72466A', 'S72466B', 'S72466C', 'S72466D', 'S72466E', 'S72466F',
        'S72466G', 'S72466H', 'S72466J', 'S72466K', 'S72466M', 'S72466N', 'S72466P', 'S72466Q',
        'S72466R', 'S72466S', 'S72471A', 'S72471D', 'S72471G', 'S72471K', 'S72471P', 'S72471S',
        'S72472A', 'S72472D', 'S72472G', 'S72472K', 'S72472P', 'S72472S', 'S72479A', 'S72479D',
        'S72479G', 'S72479K', 'S72479P', 'S72479S', 'S72491A', 'S72491B', 'S72491C', 'S72491D',
        'S72491E', 'S72491F', 'S72491G', 'S72491H', 'S72491J', 'S72491K', 'S72491M', 'S72491N',
        'S72491P', 'S72491Q', 'S72491R', 'S72491S', 'S72492A', 'S72492B', 'S72492C', 'S72492D',
        'S72492E', 'S72492F', 'S72492G', 'S72492H', 'S72492J', 'S72492K', 'S72492M', 'S72492N',
        'S72492P', 'S72492Q', 'S72492R', 'S72492S', 'S72499A', 'S72499B', 'S72499C', 'S72499D',
        'S72499E', 'S72499F', 'S72499G', 'S72499H', 'S72499J', 'S72499K', 'S72499M', 'S72499N',
        'S72499P', 'S72499Q', 'S72499R', 'S72499S', 'S728X1A', 'S728X1B', 'S728X1C', 'S728X1D',
        'S728X1E', 'S728X1F', 'S728X1G', 'S728X1H', 'S728X1J', 'S728X1K', 'S728X1M', 'S728X1N',
        'S728X1P', 'S728X1Q', 'S728X1R', 'S728X1S', 'S728X2A', 'S728X2B', 'S728X2C', 'S728X2D',
        'S728X2E', 'S728X2F', 'S728X2G', 'S728X2H', 'S728X2J', 'S728X2K', 'S728X2M', 'S728X2N',
        'S728X2P', 'S728X2Q', 'S728X2R', 'S728X2S', 'S728X9A', 'S728X9B', 'S728X9C', 'S728X9D',
        'S728X9E', 'S728X9F', 'S728X9G', 'S728X9H', 'S728X9J', 'S728X9K', 'S728X9M', 'S728X9N',
        'S728X9P', 'S728X9Q', 'S728X9R', 'S728X9S', 'S7290XA', 'S7290XB', 'S7290XC', 'S7290XD',
        'S7290XE', 'S7290XF', 'S7290XG', 'S7290XH', 'S7290XJ', 'S7290XK', 'S7290XM', 'S7290XN',
        'S7290XP', 'S7290XQ', 'S7290XR', 'S7290XS', 'S7291XA', 'S7291XB', 'S7291XC', 'S7291XD',
        'S7291XE', 'S7291XF', 'S7291XG', 'S7291XH', 'S7291XJ', 'S7291XK', 'S7291XM', 'S7291XN',
        'S7291XP', 'S7291XQ', 'S7291XR', 'S7291XS', 'S7292XA', 'S7292XB', 'S7292XC', 'S7292XD',
        'S7292XE', 'S7292XF', 'S7292XG', 'S7292XH', 'S7292XJ', 'S7292XK', 'S7292XM', 'S7292XN',
        'S7292XP', 'S7292XQ', 'S7292XR', 'S7292XS', 'S79001A', 'S79002A', 'S79009A', 'S79011A',
        'S79012A', 'S79019A', 'S79091A', 'S79092A', 'S79099A', 'S79101A', 'S79102A', 'S79109A',
        'S79111A', 'S79112A', 'S79119A', 'S79121A', 'S79122A', 'S79129A', 'S79131A', 'S79132A',
        'S79139A', 'S79141A', 'S79142A', 'S79149A', 'S79191A', 'S79192A', 'S79199A', 'S82001A',
        'S82001B', 'S82001C', 'S82001D', 'S82001E', 'S82001F', 'S82001G', 'S82001H', 'S82001J',
        'S82001K', 'S82001M', 'S82001N', 'S82001P', 'S82001Q', 'S82001R', 'S82001S', 'S82002A',
        'S82002B', 'S82002C', 'S82002D', 'S82002E', 'S82002F', 'S82002G', 'S82002H', 'S82002J',
        'S82002K', 'S82002M', 'S82002N', 'S82002P', 'S82002Q', 'S82002R', 'S82002S', 'S82009A',
        'S82009B', 'S82009C', 'S82009D', 'S82009E', 'S82009F', 'S82009G', 'S82009H', 'S82009J',
        'S82009K', 'S82009M', 'S82009N', 'S82009P', 'S82009Q', 'S82009R', 'S82009S', 'S82011A',
        'S82011B', 'S82011C', 'S82011D', 'S82011E', 'S82011F', 'S82011G', 'S82011H', 'S82011J',
        'S82011K', 'S82011M', 'S82011N', 'S82011P', 'S82011Q', 'S82011R', 'S82011S', 'S82012A',
        'S82012B', 'S82012C', 'S82012D', 'S82012E', 'S82012F', 'S82012G', 'S82012H', 'S82012J',
        'S82012K', 'S82012M', 'S82012N', 'S82012P', 'S82012Q', 'S82012R', 'S82012S', 'S82013A',
        'S82013B', 'S82013C', 'S82013D', 'S82013E', 'S82013F', 'S82013G', 'S82013H', 'S82013J',
        'S82013K', 'S82013M', 'S82013N', 'S82013P', 'S82013Q', 'S82013R', 'S82013S', 'S82014A',
        'S82014B', 'S82014C', 'S82014D', 'S82014E', 'S82014F', 'S82014G', 'S82014H', 'S82014J',
        'S82014K', 'S82014M', 'S82014N', 'S82014P', 'S82014Q', 'S82014R', 'S82014S', 'S82015A',
        'S82015B', 'S82015C', 'S82015D', 'S82015E', 'S82015F', 'S82015G', 'S82015H', 'S82015J',
        'S82015K', 'S82015M', 'S82015N', 'S82015P', 'S82015Q', 'S82015R', 'S82015S', 'S82016A',
        'S82016B', 'S82016C', 'S82016D', 'S82016E', 'S82016F', 'S82016G', 'S82016H', 'S82016J',
        'S82016K', 'S82016M', 'S82016N', 'S82016P', 'S82016Q', 'S82016R', 'S82016S', 'S82021A',
        'S82021B', 'S82021C', 'S82021D', 'S82021E', 'S82021F', 'S82021G', 'S82021H', 'S82021J',
        'S82021K', 'S82021M', 'S82021N', 'S82021P', 'S82021Q', 'S82021R', 'S82021S', 'S82022A',
        'S82022B', 'S82022C', 'S82022D', 'S82022E', 'S82022F', 'S82022G', 'S82022H', 'S82022J',
        'S82022K', 'S82022M', 'S82022N', 'S82022P', 'S82022Q', 'S82022R', 'S82022S', 'S82023A',
        'S82023B', 'S82023C', 'S82023D', 'S82023E', 'S82023F', 'S82023G', 'S82023H', 'S82023J',
        'S82023K', 'S82023M', 'S82023N', 'S82023P', 'S82023Q', 'S82023R', 'S82023S', 'S82024A',
        'S82024B', 'S82024C', 'S82024D', 'S82024E', 'S82024F', 'S82024G', 'S82024H', 'S82024J',
        'S82024K', 'S82024M', 'S82024N', 'S82024P', 'S82024Q', 'S82024R', 'S82024S', 'S82025A',
        'S82025B', 'S82025C', 'S82025D', 'S82025E', 'S82025F', 'S82025G', 'S82025H', 'S82025J',
        'S82025K', 'S82025M', 'S82025N', 'S82025P', 'S82025Q', 'S82025R', 'S82025S', 'S82026A',
        'S82026B', 'S82026C', 'S82026D', 'S82026E', 'S82026F', 'S82026G', 'S82026H', 'S82026J',
        'S82026K', 'S82026M', 'S82026N', 'S82026P', 'S82026Q', 'S82026R', 'S82026S', 'S82031A',
        'S82031B', 'S82031C', 'S82031D', 'S82031E', 'S82031F', 'S82031G', 'S82031H', 'S82031J',
        'S82031K', 'S82031M', 'S82031N', 'S82031P', 'S82031Q', 'S82031R', 'S82031S', 'S82032A',
        'S82032B', 'S82032C', 'S82032D', 'S82032E', 'S82032F', 'S82032G', 'S82032H', 'S82032J',
        'S82032K', 'S82032M', 'S82032N', 'S82032P', 'S82032Q', 'S82032R', 'S82032S', 'S82033A',
        'S82033B', 'S82033C', 'S82033D', 'S82033E', 'S82033F', 'S82033G', 'S82033H', 'S82033J',
        'S82033K', 'S82033M', 'S82033N', 'S82033P', 'S82033Q', 'S82033R', 'S82033S', 'S82034A',
        'S82034B', 'S82034C', 'S82034D', 'S82034E', 'S82034F', 'S82034G', 'S82034H', 'S82034J',
        'S82034K', 'S82034M', 'S82034N', 'S82034P', 'S82034Q', 'S82034R', 'S82034S', 'S82035A',
        'S82035B', 'S82035C', 'S82035D', 'S82035E', 'S82035F', 'S82035G', 'S82035H', 'S82035J',
        'S82035K', 'S82035M', 'S82035N', 'S82035P', 'S82035Q', 'S82035R', 'S82035S', 'S82036A',
        'S82036B', 'S82036C', 'S82036D', 'S82036E', 'S82036F', 'S82036G', 'S82036H', 'S82036J',
        'S82036K', 'S82036M', 'S82036N', 'S82036P', 'S82036Q', 'S82036R', 'S82036S', 'S82041A',
        'S82041B', 'S82041C', 'S82041D', 'S82041E', 'S82041F', 'S82041G', 'S82041H', 'S82041J',
        'S82041K', 'S82041M', 'S82041N', 'S82041P', 'S82041Q', 'S82041R', 'S82041S', 'S82042A',
        'S82042B', 'S82042C', 'S82042D', 'S82042E', 'S82042F', 'S82042G', 'S82042H', 'S82042J',
        'S82042K', 'S82042M', 'S82042N', 'S82042P', 'S82042Q', 'S82042R', 'S82042S', 'S82043A',
        'S82043B', 'S82043C', 'S82043D', 'S82043E', 'S82043F', 'S82043G', 'S82043H', 'S82043J',
        'S82043K', 'S82043M', 'S82043N', 'S82043P', 'S82043Q', 'S82043R', 'S82043S', 'S82044A',
        'S82044B', 'S82044C', 'S82044D', 'S82044E', 'S82044F', 'S82044G', 'S82044H', 'S82044J',
        'S82044K', 'S82044M', 'S82044N', 'S82044P', 'S82044Q', 'S82044R', 'S82044S', 'S82045A',
        'S82045B', 'S82045C', 'S82045D', 'S82045E', 'S82045F', 'S82045G', 'S82045H', 'S82045J',
        'S82045K', 'S82045M', 'S82045N', 'S82045P', 'S82045Q', 'S82045R', 'S82045S', 'S82046A',
        'S82046B', 'S82046C', 'S82046D', 'S82046E', 'S82046F', 'S82046G', 'S82046H', 'S82046J',
        'S82046K', 'S82046M', 'S82046N', 'S82046P', 'S82046Q', 'S82046R', 'S82046S', 'S82091A',
        'S82091B', 'S82091C', 'S82091D', 'S82091E', 'S82091F', 'S82091G', 'S82091H', 'S82091J',
        'S82091K', 'S82091M', 'S82091N', 'S82091P', 'S82091Q', 'S82091R', 'S82091S', 'S82092A',
        'S82092B', 'S82092C', 'S82092D', 'S82092E', 'S82092F', 'S82092G', 'S82092H', 'S82092J',
        'S82092K', 'S82092M', 'S82092N', 'S82092P', 'S82092Q', 'S82092R', 'S82092S', 'S82099A',
        'S82099B', 'S82099C', 'S82099D', 'S82099E', 'S82099F', 'S82099G', 'S82099H', 'S82099J',
        'S82099K', 'S82099M', 'S82099N', 'S82099P', 'S82099Q', 'S82099R', 'S82099S', 'S82101A',
        'S82101B', 'S82101C', 'S82101D', 'S82101E', 'S82101F', 'S82101G', 'S82101H', 'S82101J',
        'S82101K', 'S82101M', 'S82101N', 'S82101P', 'S82101Q', 'S82101R', 'S82101S', 'S82102A',
        'S82102B', 'S82102C', 'S82102D', 'S82102E', 'S82102F', 'S82102G', 'S82102H', 'S82102J',
        'S82102K', 'S82102M', 'S82102N', 'S82102P', 'S82102Q', 'S82102R', 'S82102S', 'S82109A',
        'S82109B', 'S82109C', 'S82109D', 'S82109E', 'S82109F', 'S82109G', 'S82109H', 'S82109J',
        'S82109K', 'S82109M', 'S82109N', 'S82109P', 'S82109Q', 'S82109R', 'S82109S', 'S82121A',
        'S82121B', 'S82121C', 'S82121D', 'S82121E', 'S82121F', 'S82121G', 'S82121H', 'S82121J',
        'S82121K', 'S82121M', 'S82121N', 'S82121P', 'S82121Q', 'S82121R', 'S82121S', 'S82122A',
        'S82122B', 'S82122C', 'S82122D', 'S82122E', 'S82122F', 'S82122G', 'S82122H', 'S82122J',
        'S82122K', 'S82122M', 'S82122N', 'S82122P', 'S82122Q', 'S82122R', 'S82122S', 'S82123A',
        'S82123B', 'S82123C', 'S82123D', 'S82123E', 'S82123F', 'S82123G', 'S82123H', 'S82123J',
        'S82123K', 'S82123M', 'S82123N', 'S82123P', 'S82123Q', 'S82123R', 'S82123S', 'S82124A',
        'S82124B', 'S82124C', 'S82124D', 'S82124E', 'S82124F', 'S82124G', 'S82124H', 'S82124J',
        'S82124K', 'S82124M', 'S82124N', 'S82124P', 'S82124Q', 'S82124R', 'S82124S', 'S82125A',
        'S82125B', 'S82125C', 'S82125D', 'S82125E', 'S82125F', 'S82125G', 'S82125H', 'S82125J',
        'S82125K', 'S82125M', 'S82125N', 'S82125P', 'S82125Q', 'S82125R', 'S82125S', 'S82126A',
        'S82126B', 'S82126C', 'S82126D', 'S82126E', 'S82126F', 'S82126G', 'S82126H', 'S82126J',
        'S82126K', 'S82126M', 'S82126N', 'S82126P', 'S82126Q', 'S82126R', 'S82126S', 'S82131A',
        'S82131B', 'S82131C', 'S82131D', 'S82131E', 'S82131F', 'S82131G', 'S82131H', 'S82131J',
        'S82131K', 'S82131M', 'S82131N', 'S82131P', 'S82131Q', 'S82131R', 'S82131S', 'S82132A',
        'S82132B', 'S82132C', 'S82132D', 'S82132E', 'S82132F', 'S82132G', 'S82132H', 'S82132J',
        'S82132K', 'S82132M', 'S82132N', 'S82132P', 'S82132Q', 'S82132R', 'S82132S', 'S82133A',
        'S82133B', 'S82133C', 'S82133D', 'S82133E', 'S82133F', 'S82133G', 'S82133H', 'S82133J',
        'S82133K', 'S82133M', 'S82133N', 'S82133P', 'S82133Q', 'S82133R', 'S82133S', 'S82134A',
        'S82134B', 'S82134C', 'S82134D', 'S82134E', 'S82134F', 'S82134G', 'S82134H', 'S82134J',
        'S82134K', 'S82134M', 'S82134N', 'S82134P', 'S82134Q', 'S82134R', 'S82134S', 'S82135A',
        'S82135B', 'S82135C', 'S82135D', 'S82135E', 'S82135F', 'S82135G', 'S82135H', 'S82135J',
        'S82135K', 'S82135M', 'S82135N', 'S82135P', 'S82135Q', 'S82135R', 'S82135S', 'S82136A',
        'S82136B', 'S82136C', 'S82136D', 'S82136E', 'S82136F', 'S82136G', 'S82136H', 'S82136J',
        'S82136K', 'S82136M', 'S82136N', 'S82136P', 'S82136Q', 'S82136R', 'S82136S', 'S82141A',
        'S82141B', 'S82141C', 'S82141D', 'S82141E', 'S82141F', 'S82141G', 'S82141H', 'S82141J',
        'S82141K', 'S82141M', 'S82141N', 'S82141P', 'S82141Q', 'S82141R', 'S82141S', 'S82142A',
        'S82142B', 'S82142C', 'S82142D', 'S82142E', 'S82142F', 'S82142G', 'S82142H', 'S82142J',
        'S82142K', 'S82142M', 'S82142N', 'S82142P', 'S82142Q', 'S82142R', 'S82142S', 'S82143A',
        'S82143B', 'S82143C', 'S82143D', 'S82143E', 'S82143F', 'S82143G', 'S82143H', 'S82143J',
        'S82143K', 'S82143M', 'S82143N', 'S82143P', 'S82143Q', 'S82143R', 'S82143S', 'S82144A',
        'S82144B', 'S82144C', 'S82144D', 'S82144E', 'S82144F', 'S82144G', 'S82144H', 'S82144J',
        'S82144K', 'S82144M', 'S82144N', 'S82144P', 'S82144Q', 'S82144R', 'S82144S', 'S82145A',
        'S82145B', 'S82145C', 'S82145D', 'S82145E', 'S82145F', 'S82145G', 'S82145H', 'S82145J',
        'S82145K', 'S82145M', 'S82145N', 'S82145P', 'S82145Q', 'S82145R', 'S82145S', 'S82146A',
        'S82146B', 'S82146C', 'S82146D', 'S82146E', 'S82146F', 'S82146G', 'S82146H', 'S82146J',
        'S82146K', 'S82146M', 'S82146N', 'S82146P', 'S82146Q', 'S82146R', 'S82146S', 'S82151A',
        'S82151B', 'S82151C', 'S82151D', 'S82151E', 'S82151F', 'S82151G', 'S82151H', 'S82151J',
        'S82151K', 'S82151M', 'S82151N', 'S82151P', 'S82151Q', 'S82151R', 'S82151S', 'S82152A',
        'S82152B', 'S82152C', 'S82152D', 'S82152E', 'S82152F', 'S82152G', 'S82152H', 'S82152J',
        'S82152K', 'S82152M', 'S82152N', 'S82152P', 'S82152Q', 'S82152R', 'S82152S', 'S82153A',
        'S82153B', 'S82153C', 'S82153D', 'S82153E', 'S82153F', 'S82153G', 'S82153H', 'S82153J',
        'S82153K', 'S82153M', 'S82153N', 'S82153P', 'S82153Q', 'S82153R', 'S82153S', 'S82154A',
        'S82154B', 'S82154C', 'S82154D', 'S82154E', 'S82154F', 'S82154G', 'S82154H', 'S82154J',
        'S82154K', 'S82154M', 'S82154N', 'S82154P', 'S82154Q', 'S82154R', 'S82154S', 'S82155A',
        'S82155B', 'S82155C', 'S82155D', 'S82155E', 'S82155F', 'S82155G', 'S82155H', 'S82155J',
        'S82155K', 'S82155M', 'S82155N', 'S82155P', 'S82155Q', 'S82155R', 'S82155S', 'S82156A',
        'S82156B', 'S82156C', 'S82156D', 'S82156E', 'S82156F', 'S82156G', 'S82156H', 'S82156J',
        'S82156K', 'S82156M', 'S82156N', 'S82156P', 'S82156Q', 'S82156R', 'S82156S', 'S82161A',
        'S82161D', 'S82161G', 'S82161K', 'S82161P', 'S82161S', 'S82162A', 'S82162D', 'S82162G',
        'S82162K', 'S82162P', 'S82162S', 'S82169A', 'S82169D', 'S82169G', 'S82169K', 'S82169P',
        'S82169S', 'S82191A', 'S82191B', 'S82191C', 'S82191D', 'S82191E', 'S82191F', 'S82191G',
        'S82191H', 'S82191J', 'S82191K', 'S82191M', 'S82191N', 'S82191P', 'S82191Q', 'S82191R',
        'S82191S', 'S82192A', 'S82192B', 'S82192C', 'S82192D', 'S82192E', 'S82192F', 'S82192G',
        'S82192H', 'S82192J', 'S82192K', 'S82192M', 'S82192N', 'S82192P', 'S82192Q', 'S82192R',
        'S82192S', 'S82199A', 'S82199B', 'S82199C', 'S82199D', 'S82199E', 'S82199F', 'S82199G',
        'S82199H', 'S82199J', 'S82199K', 'S82199M', 'S82199N', 'S82199P', 'S82199Q', 'S82199R',
        'S82199S', 'S82201A', 'S82201B', 'S82201C', 'S82201D', 'S82201E', 'S82201F', 'S82201G',
        'S82201H', 'S82201J', 'S82201K', 'S82201M', 'S82201N', 'S82201P', 'S82201Q', 'S82201R',
        'S82201S', 'S82202A', 'S82202B', 'S82202C', 'S82202D', 'S82202E', 'S82202F', 'S82202G',
        'S82202H', 'S82202J', 'S82202K', 'S82202M', 'S82202N', 'S82202P', 'S82202Q', 'S82202R',
        'S82202S', 'S82209A', 'S82209B', 'S82209C', 'S82209D', 'S82209E', 'S82209F', 'S82209G',
        'S82209H', 'S82209J', 'S82209K', 'S82209M', 'S82209N', 'S82209P', 'S82209Q', 'S82209R',
        'S82209S', 'S82221A', 'S82221B', 'S82221C', 'S82221D', 'S82221E', 'S82221F', 'S82221G',
        'S82221H', 'S82221J', 'S82221K', 'S82221M', 'S82221N', 'S82221P', 'S82221Q', 'S82221R',
        'S82221S', 'S82222A', 'S82222B', 'S82222C', 'S82222D', 'S82222E', 'S82222F', 'S82222G',
        'S82222H', 'S82222J', 'S82222K', 'S82222M', 'S82222N', 'S82222P', 'S82222Q', 'S82222R',
        'S82222S', 'S82223A', 'S82223B', 'S82223C', 'S82223D', 'S82223E', 'S82223F', 'S82223G',
        'S82223H', 'S82223J', 'S82223K', 'S82223M', 'S82223N', 'S82223P', 'S82223Q', 'S82223R',
        'S82223S', 'S82224A', 'S82224B', 'S82224C', 'S82224D', 'S82224E', 'S82224F', 'S82224G',
        'S82224H', 'S82224J', 'S82224K', 'S82224M', 'S82224N', 'S82224P', 'S82224Q', 'S82224R',
        'S82224S', 'S82225A', 'S82225B', 'S82225C', 'S82225D', 'S82225E', 'S82225F', 'S82225G',
        'S82225H', 'S82225J', 'S82225K', 'S82225M', 'S82225N', 'S82225P', 'S82225Q', 'S82225R',
        'S82225S', 'S82226A', 'S82226B', 'S82226C', 'S82226D', 'S82226E', 'S82226F', 'S82226G',
        'S82226H', 'S82226J', 'S82226K', 'S82226M', 'S82226N', 'S82226P', 'S82226Q', 'S82226R',
        'S82226S', 'S82231A', 'S82231B', 'S82231C', 'S82231D', 'S82231E', 'S82231F', 'S82231G',
        'S82231H', 'S82231J', 'S82231K', 'S82231M', 'S82231N', 'S82231P', 'S82231Q', 'S82231R',
        'S82231S', 'S82232A', 'S82232B', 'S82232C', 'S82232D', 'S82232E', 'S82232F', 'S82232G',
        'S82232H', 'S82232J', 'S82232K', 'S82232M', 'S82232N', 'S82232P', 'S82232Q', 'S82232R',
        'S82232S', 'S82233A', 'S82233B', 'S82233C', 'S82233D', 'S82233E', 'S82233F', 'S82233G',
        'S82233H', 'S82233J', 'S82233K', 'S82233M', 'S82233N', 'S82233P', 'S82233Q', 'S82233R',
        'S82233S', 'S82234A', 'S82234B', 'S82234C', 'S82234D', 'S82234E', 'S82234F', 'S82234G',
        'S82234H', 'S82234J', 'S82234K', 'S82234M', 'S82234N', 'S82234P', 'S82234Q', 'S82234R',
        'S82234S', 'S82235A', 'S82235B', 'S82235C', 'S82235D', 'S82235E', 'S82235F', 'S82235G',
        'S82235H', 'S82235J', 'S82235K', 'S82235M', 'S82235N', 'S82235P', 'S82235Q', 'S82235R',
        'S82235S', 'S82236A', 'S82236B', 'S82236C', 'S82236D', 'S82236E', 'S82236F', 'S82236G',
        'S82236H', 'S82236J', 'S82236K', 'S82236M', 'S82236N', 'S82236P', 'S82236Q', 'S82236R',
        'S82236S', 'S82241A', 'S82241B', 'S82241C', 'S82241D', 'S82241E', 'S82241F', 'S82241G',
        'S82241H', 'S82241J', 'S82241K', 'S82241M', 'S82241N', 'S82241P', 'S82241Q', 'S82241R',
        'S82241S', 'S82242A', 'S82242B', 'S82242C', 'S82242D', 'S82242E', 'S82242F', 'S82242G',
        'S82242H', 'S82242J', 'S82242K', 'S82242M', 'S82242N', 'S82242P', 'S82242Q', 'S82242R',
        'S82242S', 'S82243A', 'S82243B', 'S82243C', 'S82243D', 'S82243E', 'S82243F', 'S82243G',
        'S82243H', 'S82243J', 'S82243K', 'S82243M', 'S82243N', 'S82243P', 'S82243Q', 'S82243R',
        'S82243S', 'S82244A', 'S82244B', 'S82244C', 'S82244D', 'S82244E', 'S82244F', 'S82244G',
        'S82244H', 'S82244J', 'S82244K', 'S82244M', 'S82244N', 'S82244P', 'S82244Q', 'S82244R',
        'S82244S', 'S82245A', 'S82245B', 'S82245C', 'S82245D', 'S82245E', 'S82245F', 'S82245G',
        'S82245H', 'S82245J', 'S82245K', 'S82245M', 'S82245N', 'S82245P', 'S82245Q', 'S82245R',
        'S82245S', 'S82246A', 'S82246B', 'S82246C', 'S82246D', 'S82246E', 'S82246F', 'S82246G',
        'S82246H', 'S82246J', 'S82246K', 'S82246M', 'S82246N', 'S82246P', 'S82246Q', 'S82246R',
        'S82246S', 'S82251A', 'S82251B', 'S82251C', 'S82251D', 'S82251E', 'S82251F', 'S82251G',
        'S82251H', 'S82251J', 'S82251K', 'S82251M', 'S82251N', 'S82251P', 'S82251Q', 'S82251R',
        'S82251S', 'S82252A', 'S82252B', 'S82252C', 'S82252D', 'S82252E', 'S82252F', 'S82252G',
        'S82252H', 'S82252J', 'S82252K', 'S82252M', 'S82252N', 'S82252P', 'S82252Q', 'S82252R',
        'S82252S', 'S82253A', 'S82253B', 'S82253C', 'S82253D', 'S82253E', 'S82253F', 'S82253G',
        'S82253H', 'S82253J', 'S82253K', 'S82253M', 'S82253N', 'S82253P', 'S82253Q', 'S82253R',
        'S82253S', 'S82254A', 'S82254B', 'S82254C', 'S82254D', 'S82254E', 'S82254F', 'S82254G',
        'S82254H', 'S82254J', 'S82254K', 'S82254M', 'S82254N', 'S82254P', 'S82254Q', 'S82254R',
        'S82254S', 'S82255A', 'S82255B', 'S82255C', 'S82255D', 'S82255E', 'S82255F', 'S82255G',
        'S82255H', 'S82255J', 'S82255K', 'S82255M', 'S82255N', 'S82255P', 'S82255Q', 'S82255R',
        'S82255S', 'S82256A', 'S82256B', 'S82256C', 'S82256D', 'S82256E', 'S82256F', 'S82256G',
        'S82256H', 'S82256J', 'S82256K', 'S82256M', 'S82256N', 'S82256P', 'S82256Q', 'S82256R',
        'S82256S', 'S82261A', 'S82261B', 'S82261C', 'S82261D', 'S82261E', 'S82261F', 'S82261G',
        'S82261H', 'S82261J', 'S82261K', 'S82261M', 'S82261N', 'S82261P', 'S82261Q', 'S82261R',
        'S82261S', 'S82262A', 'S82262B', 'S82262C', 'S82262D', 'S82262E', 'S82262F', 'S82262G',
        'S82262H', 'S82262J', 'S82262K', 'S82262M', 'S82262N', 'S82262P', 'S82262Q', 'S82262R',
        'S82262S', 'S82263A', 'S82263B', 'S82263C', 'S82263D', 'S82263E', 'S82263F', 'S82263G',
        'S82263H', 'S82263J', 'S82263K', 'S82263M', 'S82263N', 'S82263P', 'S82263Q', 'S82263R',
        'S82263S', 'S82264A', 'S82264B', 'S82264C', 'S82264D', 'S82264E', 'S82264F', 'S82264G',
        'S82264H', 'S82264J', 'S82264K', 'S82264M', 'S82264N', 'S82264P', 'S82264Q', 'S82264R',
        'S82264S', 'S82265A', 'S82265B', 'S82265C', 'S82265D', 'S82265E', 'S82265F', 'S82265G',
        'S82265H', 'S82265J', 'S82265K', 'S82265M', 'S82265N', 'S82265P', 'S82265Q', 'S82265R',
        'S82265S', 'S82266A', 'S82266B', 'S82266C', 'S82266D', 'S82266E', 'S82266F', 'S82266G',
        'S82266H', 'S82266J', 'S82266K', 'S82266M', 'S82266N', 'S82266P', 'S82266Q', 'S82266R',
        'S82266S', 'S82291A', 'S82291B', 'S82291C', 'S82291D', 'S82291E', 'S82291F', 'S82291G',
        'S82291H', 'S82291J', 'S82291K', 'S82291M', 'S82291N', 'S82291P', 'S82291Q', 'S82291R',
        'S82291S', 'S82292A', 'S82292B', 'S82292C', 'S82292D', 'S82292E', 'S82292F', 'S82292G',
        'S82292H', 'S82292J', 'S82292K', 'S82292M', 'S82292N', 'S82292P', 'S82292Q', 'S82292R',
        'S82292S', 'S82299A', 'S82299B', 'S82299C', 'S82299D', 'S82299E', 'S82299F', 'S82299G',
        'S82299H', 'S82299J', 'S82299K', 'S82299M', 'S82299N', 'S82299P', 'S82299Q', 'S82299R',
        'S82299S', 'S82301A', 'S82301B', 'S82301C', 'S82301D', 'S82301E', 'S82301F', 'S82301G',
        'S82301H', 'S82301J', 'S82301K', 'S82301M', 'S82301N', 'S82301P', 'S82301Q', 'S82301R',
        'S82301S', 'S82302A', 'S82302B', 'S82302C', 'S82302D', 'S82302E', 'S82302F', 'S82302G',
        'S82302H', 'S82302J', 'S82302K', 'S82302M', 'S82302N', 'S82302P', 'S82302Q', 'S82302R',
        'S82302S', 'S82309A', 'S82309B', 'S82309C', 'S82309D', 'S82309E', 'S82309F', 'S82309G',
        'S82309H', 'S82309J', 'S82309K', 'S82309M', 'S82309N', 'S82309P', 'S82309Q', 'S82309R',
        'S82309S', 'S82311A', 'S82311D', 'S82311G', 'S82311K', 'S82311P', 'S82311S', 'S82312A',
        'S82312D', 'S82312G', 'S82312K', 'S82312P', 'S82312S', 'S82319A', 'S82319D', 'S82319G',
        'S82319K', 'S82319P', 'S82319S', 'S82391A', 'S82391B', 'S82391C', 'S82391D', 'S82391E',
        'S82391F', 'S82391G', 'S82391H', 'S82391J', 'S82391K', 'S82391M', 'S82391N', 'S82391P',
        'S82391Q', 'S82391R', 'S82391S', 'S82392A', 'S82392B', 'S82392C', 'S82392D', 'S82392E',
        'S82392F', 'S82392G', 'S82392H', 'S82392J', 'S82392K', 'S82392M', 'S82392N', 'S82392P',
        'S82392Q', 'S82392R', 'S82392S', 'S82399A', 'S82399B', 'S82399C', 'S82399D', 'S82399E',
        'S82399F', 'S82399G', 'S82399H', 'S82399J', 'S82399K', 'S82399M', 'S82399N', 'S82399P',
        'S82399Q', 'S82399R', 'S82399S', 'S82401A', 'S82401B', 'S82401C', 'S82401D', 'S82401E',
        'S82401F', 'S82401G', 'S82401H', 'S82401J', 'S82401K', 'S82401M', 'S82401N', 'S82401P',
        'S82401Q', 'S82401R', 'S82401S', 'S82402A', 'S82402B', 'S82402C', 'S82402D', 'S82402E',
        'S82402F', 'S82402G', 'S82402H', 'S82402J', 'S82402K', 'S82402M', 'S82402N', 'S82402P',
        'S82402Q', 'S82402R', 'S82402S', 'S82409A', 'S82409B', 'S82409C', 'S82409D', 'S82409E',
        'S82409F', 'S82409G', 'S82409H', 'S82409J', 'S82409K', 'S82409M', 'S82409N', 'S82409P',
        'S82409Q', 'S82409R', 'S82409S', 'S82421A', 'S82421B', 'S82421C', 'S82421D', 'S82421E',
        'S82421F', 'S82421G', 'S82421H', 'S82421J', 'S82421K', 'S82421M', 'S82421N', 'S82421P',
        'S82421Q', 'S82421R', 'S82421S', 'S82422A', 'S82422B', 'S82422C', 'S82422D', 'S82422E',
        'S82422F', 'S82422G', 'S82422H', 'S82422J', 'S82422K', 'S82422M', 'S82422N', 'S82422P',
        'S82422Q', 'S82422R', 'S82422S', 'S82423A', 'S82423B', 'S82423C', 'S82423D', 'S82423E',
        'S82423F', 'S82423G', 'S82423H', 'S82423J', 'S82423K', 'S82423M', 'S82423N', 'S82423P',
        'S82423Q', 'S82423R', 'S82423S', 'S82424A', 'S82424B', 'S82424C', 'S82424D', 'S82424E',
        'S82424F', 'S82424G', 'S82424H', 'S82424J', 'S82424K', 'S82424M', 'S82424N', 'S82424P',
        'S82424Q', 'S82424R', 'S82424S', 'S82425A', 'S82425B', 'S82425C', 'S82425D', 'S82425E',
        'S82425F', 'S82425G', 'S82425H', 'S82425J', 'S82425K', 'S82425M', 'S82425N', 'S82425P',
        'S82425Q', 'S82425R', 'S82425S', 'S82426A', 'S82426B', 'S82426C', 'S82426D', 'S82426E',
        'S82426F', 'S82426G', 'S82426H', 'S82426J', 'S82426K', 'S82426M', 'S82426N', 'S82426P',
        'S82426Q', 'S82426R', 'S82426S', 'S82431A', 'S82431B', 'S82431C', 'S82431D', 'S82431E',
        'S82431F', 'S82431G', 'S82431H', 'S82431J', 'S82431K', 'S82431M', 'S82431N', 'S82431P',
        'S82431Q', 'S82431R', 'S82431S', 'S82432A', 'S82432B', 'S82432C', 'S82432D', 'S82432E',
        'S82432F', 'S82432G', 'S82432H', 'S82432J', 'S82432K', 'S82432M', 'S82432N', 'S82432P',
        'S82432Q', 'S82432R', 'S82432S', 'S82433A', 'S82433B', 'S82433C', 'S82433D', 'S82433E',
        'S82433F', 'S82433G', 'S82433H', 'S82433J', 'S82433K', 'S82433M', 'S82433N', 'S82433P',
        'S82433Q', 'S82433R', 'S82433S', 'S82434A', 'S82434B', 'S82434C', 'S82434D', 'S82434E',
        'S82434F', 'S82434G', 'S82434H', 'S82434J', 'S82434K', 'S82434M', 'S82434N', 'S82434P',
        'S82434Q', 'S82434R', 'S82434S', 'S82435A', 'S82435B', 'S82435C', 'S82435D', 'S82435E',
        'S82435F', 'S82435G', 'S82435H', 'S82435J', 'S82435K', 'S82435M', 'S82435N', 'S82435P',
        'S82435Q', 'S82435R', 'S82435S', 'S82436A', 'S82436B', 'S82436C', 'S82436D', 'S82436E',
        'S82436F', 'S82436G', 'S82436H', 'S82436J', 'S82436K', 'S82436M', 'S82436N', 'S82436P',
        'S82436Q', 'S82436R', 'S82436S', 'S82441A', 'S82441B', 'S82441C', 'S82441D', 'S82441E',
        'S82441F', 'S82441G', 'S82441H', 'S82441J', 'S82441K', 'S82441M', 'S82441N', 'S82441P',
        'S82441Q', 'S82441R', 'S82441S', 'S82442A', 'S82442B', 'S82442C', 'S82442D', 'S82442E',
        'S82442F', 'S82442G', 'S82442H', 'S82442J', 'S82442K', 'S82442M', 'S82442N', 'S82442P',
        'S82442Q', 'S82442R', 'S82442S', 'S82443A', 'S82443B', 'S82443C', 'S82443D', 'S82443E',
        'S82443F', 'S82443G', 'S82443H', 'S82443J', 'S82443K', 'S82443M', 'S82443N', 'S82443P',
        'S82443Q', 'S82443R', 'S82443S', 'S82444A', 'S82444B', 'S82444C', 'S82444D', 'S82444E',
        'S82444F', 'S82444G', 'S82444H', 'S82444J', 'S82444K', 'S82444M', 'S82444N', 'S82444P',
        'S82444Q', 'S82444R', 'S82444S', 'S82445A', 'S82445B', 'S82445C', 'S82445D', 'S82445E',
        'S82445F', 'S82445G', 'S82445H', 'S82445J', 'S82445K', 'S82445M', 'S82445N', 'S82445P',
        'S82445Q', 'S82445R', 'S82445S', 'S82446A', 'S82446B', 'S82446C', 'S82446D', 'S82446E',
        'S82446F', 'S82446G', 'S82446H', 'S82446J', 'S82446K', 'S82446M', 'S82446N', 'S82446P',
        'S82446Q', 'S82446R', 'S82446S', 'S82451A', 'S82451B', 'S82451C', 'S82451D', 'S82451E',
        'S82451F', 'S82451G', 'S82451H', 'S82451J', 'S82451K', 'S82451M', 'S82451N', 'S82451P',
        'S82451Q', 'S82451R', 'S82451S', 'S82452A', 'S82452B', 'S82452C', 'S82452D', 'S82452E',
        'S82452F', 'S82452G', 'S82452H', 'S82452J', 'S82452K', 'S82452M', 'S82452N', 'S82452P',
        'S82452Q', 'S82452R', 'S82452S', 'S82453A', 'S82453B', 'S82453C', 'S82453D', 'S82453E',
        'S82453F', 'S82453G', 'S82453H', 'S82453J', 'S82453K', 'S82453M', 'S82453N', 'S82453P',
        'S82453Q', 'S82453R', 'S82453S', 'S82454A', 'S82454B', 'S82454C', 'S82454D', 'S82454E',
        'S82454F', 'S82454G', 'S82454H', 'S82454J', 'S82454K', 'S82454M', 'S82454N', 'S82454P',
        'S82454Q', 'S82454R', 'S82454S', 'S82455A', 'S82455B', 'S82455C', 'S82455D', 'S82455E',
        'S82455F', 'S82455G', 'S82455H', 'S82455J', 'S82455K', 'S82455M', 'S82455N', 'S82455P',
        'S82455Q', 'S82455R', 'S82455S', 'S82456A', 'S82456B', 'S82456C', 'S82456D', 'S82456E',
        'S82456F', 'S82456G', 'S82456H', 'S82456J', 'S82456K', 'S82456M', 'S82456N', 'S82456P',
        'S82456Q', 'S82456R', 'S82456S', 'S82461A', 'S82461B', 'S82461C', 'S82461D', 'S82461E',
        'S82461F', 'S82461G', 'S82461H', 'S82461J', 'S82461K', 'S82461M', 'S82461N', 'S82461P',
        'S82461Q', 'S82461R', 'S82461S', 'S82462A', 'S82462B', 'S82462C', 'S82462D', 'S82462E',
        'S82462F', 'S82462G', 'S82462H', 'S82462J', 'S82462K', 'S82462M', 'S82462N', 'S82462P',
        'S82462Q', 'S82462R', 'S82462S', 'S82463A', 'S82463B', 'S82463C', 'S82463D', 'S82463E',
        'S82463F', 'S82463G', 'S82463H', 'S82463J', 'S82463K', 'S82463M', 'S82463N', 'S82463P',
        'S82463Q', 'S82463R', 'S82463S', 'S82464A', 'S82464B', 'S82464C', 'S82464D', 'S82464E',
        'S82464F', 'S82464G', 'S82464H', 'S82464J', 'S82464K', 'S82464M', 'S82464N', 'S82464P',
        'S82464Q', 'S82464R', 'S82464S', 'S82465A', 'S82465B', 'S82465C', 'S82465D', 'S82465E',
        'S82465F', 'S82465G', 'S82465H', 'S82465J', 'S82465K', 'S82465M', 'S82465N', 'S82465P',
        'S82465Q', 'S82465R', 'S82465S', 'S82466A', 'S82466B', 'S82466C', 'S82466D', 'S82466E',
        'S82466F', 'S82466G', 'S82466H', 'S82466J', 'S82466K', 'S82466M', 'S82466N', 'S82466P',
        'S82466Q', 'S82466R', 'S82466S', 'S82491A', 'S82491B', 'S82491C', 'S82491D', 'S82491E',
        'S82491F', 'S82491G', 'S82491H', 'S82491J', 'S82491K', 'S82491M', 'S82491N', 'S82491P',
        'S82491Q', 'S82491R', 'S82491S', 'S82492A', 'S82492B', 'S82492C', 'S82492D', 'S82492E',
        'S82492F', 'S82492G', 'S82492H', 'S82492J', 'S82492K', 'S82492M', 'S82492N', 'S82492P',
        'S82492Q', 'S82492R', 'S82492S', 'S82499A', 'S82499B', 'S82499C', 'S82499D', 'S82499E',
        'S82499F', 'S82499G', 'S82499H', 'S82499J', 'S82499K', 'S82499M', 'S82499N', 'S82499P',
        'S82499Q', 'S82499R', 'S82499S', 'S8251XA', 'S8251XB', 'S8251XC', 'S8252XA', 'S8252XB',
        'S8252XC', 'S8253XA', 'S8253XB', 'S8253XC', 'S8254XA', 'S8254XB', 'S8254XC', 'S8255XA',
        'S8255XB', 'S8255XC', 'S8256XA', 'S8256XB', 'S8256XC', 'S8261XA', 'S8261XB', 'S8261XC',
        'S8262XA', 'S8262XB', 'S8262XC', 'S8263XA', 'S8263XB', 'S8263XC', 'S8264XA', 'S8264XB',
        'S8264XC', 'S8265XA', 'S8265XB', 'S8265XC', 'S8266XA', 'S8266XB', 'S8266XC', 'S82811A',
        'S82812A', 'S82819A', 'S82821A', 'S82822A', 'S82829A', 'S82831A', 'S82831B', 'S82831C',
        'S82832A', 'S82832B', 'S82832C', 'S82839A', 'S82839B', 'S82839C', 'S82841A', 'S82841B',
        'S82841C', 'S82842A', 'S82842B', 'S82842C', 'S82843A', 'S82843B', 'S82843C', 'S82844A',
        'S82844B', 'S82844C', 'S82845A', 'S82845B', 'S82845C', 'S82846A', 'S82846B', 'S82846C',
        'S82851A', 'S82851B', 'S82851C', 'S82852A', 'S82852B', 'S82852C', 'S82853A', 'S82853B',
        'S82853C', 'S82854A', 'S82854B', 'S82854C', 'S82855A', 'S82855B', 'S82855C', 'S82856A',
        'S82856B', 'S82856C', 'S82861A', 'S82861B', 'S82861C', 'S82862A', 'S82862B', 'S82862C',
        'S82863A', 'S82863B', 'S82863C', 'S82864A', 'S82864B', 'S82864C', 'S82865A', 'S82865B',
        'S82865C', 'S82866A', 'S82866B', 'S82866C', 'S82871A', 'S82871B', 'S82871C', 'S82872A',
        'S82872B', 'S82872C', 'S82873A', 'S82873B', 'S82873C', 'S82874A', 'S82874B', 'S82874C',
        'S82875A', 'S82875B', 'S82875C', 'S82876A', 'S82876B', 'S82876C', 'S82891A', 'S82891B',
        'S82891C', 'S82892A', 'S82892B', 'S82892C', 'S82899A', 'S82899B', 'S82899C', 'S8290XA',
        'S8290XB', 'S8290XC', 'S8291XA', 'S8291XB', 'S8291XC', 'S8292XA', 'S8292XB', 'S8292XC',
        'S89001A', 'S89002A', 'S89009A', 'S89011A', 'S89012A', 'S89019A', 'S89021A', 'S89022A',
        'S89029A', 'S89031A', 'S89032A', 'S89039A', 'S89041A', 'S89042A', 'S89049A', 'S89091A',
        'S89092A', 'S89099A', 'S89101A', 'S89102A', 'S89109A', 'S89111A', 'S89112A', 'S89119A',
        'S89121A', 'S89122A', 'S89129A', 'S89131A', 'S89132A', 'S89139A', 'S89141A', 'S89142A',
        'S89149A', 'S89191A', 'S89192A', 'S89199A', 'S89201A', 'S89202A', 'S89209A', 'S89211A',
        'S89212A', 'S89219A', 'S89221A', 'S89222A', 'S89229A', 'S89291A', 'S89292A', 'S89299A',
        'S89301A', 'S89302A', 'S89309A', 'S89311A', 'S89312A', 'S89319A', 'S89321A', 'S89322A',
        'S89329A', 'S89391A', 'S89392A', 'S89399A', 'S92001A', 'S92001B', 'S92002A', 'S92002B',
        'S92009A', 'S92009B', 'S92011A', 'S92011B', 'S92012A', 'S92012B', 'S92013A', 'S92013B',
        'S92014A', 'S92014B', 'S92015A', 'S92015B', 'S92016A', 'S92016B', 'S92021A', 'S92021B',
        'S92022A', 'S92022B', 'S92023A', 'S92023B', 'S92024A', 'S92024B', 'S92025A', 'S92025B',
        'S92026A', 'S92026B', 'S92031A', 'S92031B', 'S92032A', 'S92032B', 'S92033A', 'S92033B',
        'S92034A', 'S92034B', 'S92035A', 'S92035B', 'S92036A', 'S92036B', 'S92041A', 'S92041B',
        'S92042A', 'S92042B', 'S92043A', 'S92043B', 'S92044A', 'S92044B', 'S92045A', 'S92045B',
        'S92046A', 'S92046B', 'S92051A', 'S92051B', 'S92052A', 'S92052B', 'S92053A', 'S92053B',
        'S92054A', 'S92054B', 'S92055A', 'S92055B', 'S92056A', 'S92056B', 'S92061A', 'S92061B',
        'S92062A', 'S92062B', 'S92063A', 'S92063B', 'S92064A', 'S92064B', 'S92065A', 'S92065B',
        'S92066A', 'S92066B', 'S92101A', 'S92101B', 'S92102A', 'S92102B', 'S92109A', 'S92109B',
        'S92111A', 'S92111B', 'S92112A', 'S92112B', 'S92113A', 'S92113B', 'S92114A', 'S92114B',
        'S92115A', 'S92115B', 'S92116A', 'S92116B', 'S92121A', 'S92121B', 'S92122A', 'S92122B',
        'S92123A', 'S92123B', 'S92124A', 'S92124B', 'S92125A', 'S92125B', 'S92126A', 'S92126B',
        'S92131A', 'S92131B', 'S92132A', 'S92132B', 'S92133A', 'S92133B', 'S92134A', 'S92134B',
        'S92135A', 'S92135B', 'S92136A', 'S92136B', 'S92141A', 'S92141B', 'S92142A', 'S92142B',
        'S92143A', 'S92143B', 'S92144A', 'S92144B', 'S92145A', 'S92145B', 'S92146A', 'S92146B',
        'S92151A', 'S92151B', 'S92152A', 'S92152B', 'S92153A', 'S92153B', 'S92154A', 'S92154B',
        'S92155A', 'S92155B', 'S92156A', 'S92156B', 'S92191A', 'S92191B', 'S92192A', 'S92192B',
        'S92199A', 'S92199B', 'S99001A', 'S99001B', 'S99001D', 'S99001G', 'S99001K', 'S99001P',
        'S99001S', 'S99002A', 'S99002B', 'S99002D', 'S99002G', 'S99002K', 'S99002P', 'S99002S',
        'S99009A', 'S99009B', 'S99009D', 'S99009G', 'S99009K', 'S99009P', 'S99009S', 'S99011A',
        'S99011B', 'S99011D', 'S99011G', 'S99011K', 'S99011P', 'S99011S', 'S99012A', 'S99012B',
        'S99012D', 'S99012G', 'S99012K', 'S99012P', 'S99012S', 'S99019A', 'S99019B', 'S99019D',
        'S99019G', 'S99019K', 'S99019P', 'S99019S', 'S99021A', 'S99021B', 'S99021D', 'S99021G',
        'S99021K', 'S99021P', 'S99021S', 'S99022A', 'S99022B', 'S99022D', 'S99022G', 'S99022K',
        'S99022P', 'S99022S', 'S99029A', 'S99029B', 'S99029D', 'S99029G', 'S99029K', 'S99029P',
        'S99029S', 'S99031A', 'S99031B', 'S99031D', 'S99031G', 'S99031K', 'S99031P', 'S99031S',
        'S99032A', 'S99032B', 'S99032D', 'S99032G', 'S99032K', 'S99032P', 'S99032S', 'S99039A',
        'S99039B', 'S99039D', 'S99039G', 'S99039K', 'S99039P', 'S99039S', 'S99041A', 'S99041B',
        'S99041D', 'S99041G', 'S99041K', 'S99041P', 'S99041S', 'S99042A', 'S99042B', 'S99042D',
        'S99042G', 'S99042K', 'S99042P', 'S99042S', 'S99049A', 'S99049B', 'S99049D', 'S99049G',
        'S99049K', 'S99049P', 'S99049S', 'S99091A', 'S99091B', 'S99091D', 'S99091G', 'S99091K',
        'S99091P', 'S99091S', 'S99092A', 'S99092B', 'S99092D', 'S99092G', 'S99092K', 'S99092P',
        'S99092S', 'S99099A', 'S99099B', 'S99099D', 'S99099G', 'S99099K', 'S99099P', 'S99099S',
        'S99101A', 'S99101B', 'S99101D', 'S99101G', 'S99101K', 'S99101P', 'S99101S', 'S99102A',
        'S99102B', 'S99102D', 'S99102G', 'S99102K', 'S99102P', 'S99102S', 'S99109A', 'S99109B',
        'S99109D', 'S99109G', 'S99109K', 'S99109P', 'S99109S', 'S99111A', 'S99111B', 'S99111D',
        'S99111G', 'S99111K', 'S99111P', 'S99111S', 'S99112A', 'S99112B', 'S99112D', 'S99112G',
        'S99112K', 'S99112P', 'S99112S', 'S99119A', 'S99119B', 'S99119D', 'S99119G', 'S99119K',
        'S99119P', 'S99119S', 'S99121A', 'S99121B', 'S99121D', 'S99121G', 'S99121K', 'S99121P',
        'S99121S', 'S99122A', 'S99122B', 'S99122D', 'S99122G', 'S99122K', 'S99122P', 'S99122S',
        'S99129A', 'S99129B', 'S99129D', 'S99129G', 'S99129K', 'S99129P', 'S99129S', 'S99131A',
        'S99131B', 'S99131D', 'S99131G', 'S99131K', 'S99131P', 'S99131S', 'S99132A', 'S99132B',
        'S99132D', 'S99132G', 'S99132K', 'S99132P', 'S99132S', 'S99139A', 'S99139B', 'S99139D',
        'S99139G', 'S99139K', 'S99139P', 'S99139S', 'S99141A', 'S99141B', 'S99141D', 'S99141G',
        'S99141K', 'S99141P', 'S99141S', 'S99142A', 'S99142B', 'S99142D', 'S99142G', 'S99142K',
        'S99142P', 'S99142S', 'S99149A', 'S99149B', 'S99149D', 'S99149G', 'S99149K', 'S99149P',
        'S99149S', 'S99191A', 'S99191B', 'S99191D', 'S99191G', 'S99191K', 'S99191P', 'S99191S',
        'S99192A', 'S99192B', 'S99192D', 'S99192G', 'S99192K', 'S99192P', 'S99192S', 'S99199A',
        'S99199B', 'S99199D', 'S99199G', 'S99199K', 'S99199P', 'S99199S'
    }

    SNOMEDCT = {
        '111643005', '111644004', '111645003', '111646002', '127287001', '12746007', '13695006',
        '15474008', '1705000', '17616007', '19652000', '20100009', '208146001', '208147005',
        '208148000', '208149008', '208150008', '208151007', '208155003', '208156002', '208157006',
        '208158001', '208159009', '208160004', '208164008', '208165009', '208166005', '208168006',
        '208172005', '208173000', '208174006', '208181004', '208182006', '208183001', '208184007',
        '208185008', '208192003', '208193008', '208194002', '208195001', '208197009', '208202002',
        '208204001', '208205000', '208207008', '208521006', '208523009', '208524003', '208526001',
        '208528000', '208529008', '208530003', '208531004', '208536009', '208537000', '208540000',
        '208541001', '208542008', '208543003', '208544009', '208548007', '208550004', '208551000',
        '208552007', '208555009', '208557001', '208558006', '208559003', '208562000', '208578003',
        '208579006', '208580009', '208581008', '208582001', '208587007', '208588002', '208589005',
        '208590001', '208591002', '208596007', '208597003', '208598008', '208600002', '208601003',
        '208602005', '208603000', '208604006', '208605007', '208606008', '208610006', '208611005',
        '208612003', '208613008', '208614002', '208615001', '208619007', '208620001', '208621002',
        '208622009', '208623004', '208624005', '208625006', '208627003', '208629000', '208631009',
        '208632002', '208637008', '208731002', '209335002', '209336001', '209337005', '209338000',
        '209344001', '209345000', '209346004', '209347008', '209390009', '209395004', '209405008',
        '22234005', '22802006', '23900009', '25415003', '263067005', '263096006', '263216001',
        '263220002', '263221003', '263222005', '263225007', '263226008', '263227004', '263228009',
        '263229001', '263231005', '263232003', '263233008', '263234002', '263235001', '263236000',
        '263237009', '263238004', '263239007', '26442006', '26938002', '271963003', '275338001',
        '275339009', '275340006', '275341005', '275342003', '275343008', '28012007', '281533006',
        '28359007', '28576007', '30060003', '301034006', '301757009', '302034009', '30489009',
        '307178006', '307727005', '308153009', '30905007', '33118001', '359817006', '359820003',
        '361118003', '361119006', '36127009', '36417005', '39408006', '41191003', '413876003',
        '413877007', '414942001', '414943006', '426382004', '426679004', '426962008', '427509002',
        '427584009', '427688003', '427826000', '428000009', '428020005', '428232002', '428257007',
        '428357005', '428512002', '428723000', '428797006', '428798001', '429186005', '429342005',
        '429552008', '429766001', '445311003', '445410003', '445733003', '445875009', '445899009',
        '446979005', '446980008', '447017008', '447139008', '447394009', '447395005',
        '447931000124101', '45455009', '46272008', '47848000', '51037009', '52450003', '54441004',
        '5913000', '59556008', '59639009', '59962009', '60214001', '62125005', '64455005',
        '6628008', '66483005', '66926007', '69830008', '71220005', '71620000', '735782008',
        '7687006', '76911006', '77598002', '77803008', '79484004', '79978005', '80756009',
        '82640004', '84320000', '86731008', '87173003', '89820008', '91037003', '9344009'
    }


class OpticDiscExamForStructuralAbnormalities(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent studies specific to looking for structural abnormalities of the optic disc by ophthalmoscopy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnostic Study.
    Inclusion Criteria: Includes only relevant concepts associated with studies using ophthalmoscopy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1334'
    VALUE_SET_NAME = 'Optic Disc Exam for Structural Abnormalities'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'71486-5', '71487-3'}


class Osteopenia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of osteopenia.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes for specified and unspecified disorders of bones and cartilage. Includes only relevant concepts associated with osteopenia of prematurity, drug-induced osteopenia, and senile osteopenia. This is a grouping of ICD-9-CM, ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes diagnosis of arrest of bone development or growth, chondromalacia, or stress fracture of bone.
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1049'
    VALUE_SET_NAME = 'Osteopenia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'M8580', 'M85811', 'M85812', 'M85819', 'M85821', 'M85822', 'M85829', 'M85831', 'M85832',
        'M85839', 'M85841', 'M85842', 'M85849', 'M85851', 'M85852', 'M85859', 'M85861', 'M85862',
        'M85869', 'M85871', 'M85872', 'M85879', 'M8588', 'M8589', 'M898X0', 'M898X1', 'M898X2',
        'M898X3', 'M898X4', 'M898X5', 'M898X6', 'M898X7', 'M898X8', 'M898X9'
    }

    ICD9CM = {'73390', '73399'}

    SNOMEDCT = {
        '276703007', '312894000', '37605006', '40308000', '735613004', '735614005', '735615006',
        '735616007', '78441005'
    }


class ChlorpheniramineHydrocodonePseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorpheniramine / hydrocodone / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorpheniramine / hydrocodone / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorpheniramine / hydrocodone / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1299'
    VALUE_SET_NAME = 'Chlorpheniramine / Hydrocodone / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1112220'}


class ChlamydiaScreening(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent laboratory testing for chlamydia infections.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with tests for chlamydia infection. This is a grouping of LOINC codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1052'
    VALUE_SET_NAME = 'Chlamydia Screening'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '14463-4', '14464-2', '14467-5', '14474-1', '14513-6', '16600-9', '21190-4', '21191-2',
        '21613-5', '23838-6', '31775-0', '31777-6', '36902-5', '36903-3', '42931-6', '43304-5',
        '43404-3', '43405-0', '43406-8', '44806-8', '44807-6', '45068-4', '45069-2', '45075-9',
        '45076-7', '45084-1', '45091-6', '45095-7', '45098-1', '45100-5', '47211-8', '47212-6',
        '49096-1', '4993-2', '50387-0', '53925-4', '53926-2', '557-9', '560-3', '6349-5', '6354-5',
        '6355-2', '6356-0', '6357-8', '80360-1', '80361-9', '80362-7'
    }


class DetoxificationVisit(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent detoxification visits.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying alcohol and drug detoxification. This is a grouping of SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1059'
    VALUE_SET_NAME = 'Detoxification Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '182969009', '20093000', '23915005', '414054004', '414056002', '56876005', '61480009',
        '64297001', '67516001', '87106005'
    }


class KidneyTransplantRecipient(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent recipients of kidney transplants.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying kidney transplant recipients.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1029'
    VALUE_SET_NAME = 'Kidney Transplant Recipient'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'Z940'}

    ICD9CM = {'V420'}

    SNOMEDCT = {'161665007'}


class CerebrovascularDiseaseStrokeTia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent stroke and high risk diagnoses associated with stroke, including transient ischemic attack (TIA) and generalized ischemic cerebrovascular disease, which would indicate a patient has atherosclerotic cardiovascular disease (ASCVD) in relation to a cerebrovascular event.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with ASCVD diagnoses of cerebrovascular origin.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1047.44'
    VALUE_SET_NAME = 'Cerebrovascular disease, Stroke, TIA'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'G450', 'G451', 'G452', 'G458', 'G459', 'G460', 'G461', 'G462', 'G463', 'G464', 'G465',
        'G466', 'G467', 'G468', 'I6300', 'I63011', 'I63012', 'I63013', 'I63019', 'I6302', 'I63031',
        'I63032', 'I63033', 'I63039', 'I6309', 'I6310', 'I63111', 'I63112', 'I63113', 'I63119',
        'I6312', 'I63131', 'I63132', 'I63133', 'I63139', 'I6319', 'I6320', 'I63211', 'I63212',
        'I63213', 'I63219', 'I6322', 'I63231', 'I63232', 'I63233', 'I63239', 'I6329', 'I6330',
        'I63311', 'I63312', 'I63313', 'I63319', 'I63321', 'I63322', 'I63323', 'I63329', 'I63331',
        'I63332', 'I63333', 'I63339', 'I63341', 'I63342', 'I63343', 'I63349', 'I6339', 'I6340',
        'I63411', 'I63412', 'I63413', 'I63419', 'I63421', 'I63422', 'I63423', 'I63429', 'I63431',
        'I63432', 'I63433', 'I63439', 'I63441', 'I63442', 'I63443', 'I63449', 'I6349', 'I6350',
        'I63511', 'I63512', 'I63513', 'I63519', 'I63521', 'I63522', 'I63523', 'I63529', 'I63531',
        'I63532', 'I63533', 'I63539', 'I63541', 'I63542', 'I63543', 'I63549', 'I6359', 'I636',
        'I6381', 'I6389', 'I639', 'I6900', 'I69010', 'I69011', 'I69012', 'I69013', 'I69014',
        'I69015', 'I69018', 'I69019', 'I69020', 'I69021', 'I69022', 'I69023', 'I69028', 'I69031',
        'I69032', 'I69033', 'I69034', 'I69039', 'I69041', 'I69042', 'I69043', 'I69044', 'I69049',
        'I69051', 'I69052', 'I69053', 'I69054', 'I69059', 'I69061', 'I69062', 'I69063', 'I69064',
        'I69065', 'I69069', 'I69090', 'I69091', 'I69092', 'I69093', 'I69098', 'I6910', 'I69110',
        'I69111', 'I69112', 'I69113', 'I69114', 'I69115', 'I69118', 'I69119', 'I69120', 'I69121',
        'I69122', 'I69123', 'I69128', 'I69131', 'I69132', 'I69133', 'I69134', 'I69139', 'I69141',
        'I69142', 'I69143', 'I69144', 'I69149', 'I69151', 'I69152', 'I69153', 'I69154', 'I69159',
        'I69161', 'I69162', 'I69163', 'I69164', 'I69165', 'I69169', 'I69190', 'I69191', 'I69192',
        'I69193', 'I69198', 'I6920', 'I69210', 'I69211', 'I69212', 'I69213', 'I69214', 'I69215',
        'I69218', 'I69219', 'I69220', 'I69221', 'I69222', 'I69223', 'I69228', 'I69231', 'I69232',
        'I69233', 'I69234', 'I69239', 'I69241', 'I69242', 'I69243', 'I69244', 'I69249', 'I69251',
        'I69252', 'I69253', 'I69254', 'I69259', 'I69261', 'I69262', 'I69263', 'I69264', 'I69265',
        'I69269', 'I69290', 'I69291', 'I69292', 'I69293', 'I69298', 'I6930', 'I69310', 'I69311',
        'I69312', 'I69313', 'I69314', 'I69315', 'I69318', 'I69319', 'I69320', 'I69321', 'I69322',
        'I69323', 'I69328', 'I69331', 'I69332', 'I69333', 'I69334', 'I69339', 'I69341', 'I69342',
        'I69343', 'I69344', 'I69349', 'I69351', 'I69352', 'I69353', 'I69354', 'I69359', 'I69361',
        'I69362', 'I69363', 'I69364', 'I69365', 'I69369', 'I69390', 'I69391', 'I69392', 'I69393',
        'I69398', 'I6980', 'I69810', 'I69811', 'I69812', 'I69813', 'I69814', 'I69815', 'I69818',
        'I69819', 'I69820', 'I69821', 'I69822', 'I69831', 'I69832', 'I69833', 'I69834', 'I69839',
        'I69841', 'I69842', 'I69843', 'I69844', 'I69849', 'I69863', 'I69864', 'I69865', 'I69869',
        'I69890', 'I69892', 'I69893', 'I69898', 'I6990', 'I69910', 'I69911', 'I69912', 'I69913',
        'I69914', 'I69915', 'I69918', 'I69919', 'I69920', 'I69921', 'I69922', 'I69923', 'I69928',
        'I69931', 'I69932', 'I69933', 'I69934', 'I69939', 'I69941', 'I69942', 'I69943', 'I69944',
        'I69949', 'I69990', 'I69991', 'I69992', 'I69993', 'I69998', 'Z8673'
    }

    ICD9CM = {
        '43300', '43301', '43310', '43311', '43320', '43321', '43330', '43331', '43380', '43381',
        '43390', '43391', '43400', '43401', '43410', '43411', '43490', '43491', '4350', '4351',
        '4353', '4358', '4359', '436', '4371', '4380', '43810', '43811', '43812', '43813', '43814',
        '43819', '43820', '43821', '43822', '43830', '43831', '43832', '43840', '43841', '43842',
        '43850', '43851', '43852', '43853', '4386', '4387', '43881', '43882', '43883', '43884',
        '43885', '43889', '4389', 'V1254'
    }

    SNOMEDCT = {
        '102831000119104', '103761000119107', '108691000119102', '111297002', '111298007',
        '116288000', '133981000119106', '133991000119109', '134771000119108', '137991000119103',
        '140281000119108', '140911000119109', '140921000119102', '145741000119101',
        '148871000119109', '149821000119103', '161511000', '18761000119108', '192813004',
        '195185009', '195186005', '195189003', '195190007', '195212005', '195213000', '195230003',
        '195239002', '195243003', '20059004', '230690007', '230693009', '230694003', '230695002',
        '230696001', '230698000', '230706003', '230707007', '230708002', '230713003', '230714009',
        '230715005', '230738008', '23671000119107', '25133001', '26021000119107', '266257000',
        '275434003', '275526006', '276219001', '281240008', '288723005', '29941000119105',
        '302909007', '307766002', '307767006', '33301000119105', '33331000119103',
        '34191000119104', '361000119103', '371040005', '371041009', '373606000', '390936003',
        '40161000119102', '413102000', '413758000', '422504002', '425642008', '425882004',
        '426033005', '426788002', '426983002', '427065003', '427296003', '427432001', '428668000',
        '430947007', '430959006', '432504007', '433183000', '433891000124100', '433911000124103',
        '433931000124109', '433941000124104', '433951000124102', '433961000124100',
        '433971000124107', '434141000124103', '434151000124101', '434961000124102',
        '434991000124105', '441526008', '441529001', '441630004', '441735003', '441759008',
        '441887006', '441894009', '441960006', '441991000', '442024001', '442097001', '442181008',
        '442212003', '442617003', '442668000', '442676003', '442733008', '443929000',
        '46421000119102', '48601000119107', '5571000124103', '57981008', '62914000', '703163006',
        '705128004', '705130002', '87551000119101', '91601000119109', '92341000119107', '95457000',
        '9901000119100', '99451000119105'
    }


class RemovalProcedures(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent removal procedures of the eye.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with removal procedures of the eye, including removal of foreign body, implanted material, etc.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1436'
    VALUE_SET_NAME = 'Removal Procedures'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'65235', '65900', '65920', '65930'}

    SNOMEDCT = {
        '13767004', '172426003', '172498005', '172548007', '18752000', '20647004', '21491001',
        '223217009', '224227005', '225184003', '287233001', '287236009', '287242008', '30113009',
        '31530007', '35552007', '360405005', '360411008', '363726008', '37332006', '37958004',
        '417297006', '430833007', '43908008', '444600006', '445023004', '445024005', '4503005',
        '45817009', '48933009', '50737005', '51281007', '53570002', '54085006', '54211003',
        '54362002', '5671007', '58689006', '61220009', '64340000', '66134002', '67546003',
        '72199008', '74948004', '75734004', '78191003', '78290008', '78362007', '84016007',
        '84542000', '85145001', '8813000', '89788006', '89942008', '90997007', '9255007'
    }


class Brompheniramine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent brompheniramine medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; brompheniramine only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; brompheniramine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1427'
    VALUE_SET_NAME = 'Brompheniramine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'700851'}


class Glyburide(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent glyburide medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; glyburide only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; glyburide in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1368'
    VALUE_SET_NAME = 'Glyburide'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197737', '310534', '310536', '310537', '310539', '314000'}


class SalvageTherapy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent salvage therapy procedures.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with salvage therapy procedures.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.399'
    VALUE_SET_NAME = 'Salvage Therapy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'51597', '55860', '55862', '55865'}

    SNOMEDCT = {'236209003', '236211007'}


class MacularExam(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent macular exam of the eye.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnostic Study.
    Inclusion Criteria: Includes only relevant concepts associated with macular exams, where laterality is specified or not.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1251'
    VALUE_SET_NAME = 'Macular Exam'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'32451-7', '79820-7', '79821-5'}


class Estropipate(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent estropipate medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; estropipate only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; estropipate in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1319'
    VALUE_SET_NAME = 'Estropipate'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'310212', '310213', '310215'}


class AboveNormalFollowUp(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent interventions relevant for a follow up for a BMI above normal measurement.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with interventions relevant for a follow-up when BMI is above normal measurement.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1525'
    VALUE_SET_NAME = 'Above Normal Follow-up'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '43644', '43645', '43659', '43770', '43771', '43772', '43773', '43774', '43842', '43843',
        '43845', '43846', '43847', '43848', '43886', '43888', '97802', '97803', '97804', '98960',
        '99078', '99401', '99402'
    }

    HCPCS = {'G0270', 'G0271', 'G0447', 'G0473', 'S9449', 'S9451', 'S9452', 'S9470'}

    ICD10CM = {'Z713', 'Z7182'}

    SNOMEDCT = {
        '304549008', '307818003', '361231003', '370847001', '386291006', '386292004', '386373004',
        '386463000', '386464006', '410177006', '413315001', '418995006', '424753004', '443288003'
    }


class ReferralsWhereWeightAssessmentMayOccur(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent multiple types of providers and settings for weight assessment.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with multiple providers in different settings performing weight assessments.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1527'
    VALUE_SET_NAME = 'Referrals where weight assessment may occur'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '103698003', '103699006', '183515008', '183524004', '183583007', '185359002', '305922005',
        '306136006', '306163007', '306164001', '306165000', '306166004', '306167008', '306168003',
        '306226009', '306227000', '306252003', '306344004', '306353006', '306354000', '308459004',
        '308470006', '308477009', '390864007', '390866009', '390893007', '408289007', '410160006',
        '416790000', '424203006', '91251008'
    }


class PneumococcalConjugateVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent pneumococcal vaccines.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Immunization, Administered.
    Inclusion Criteria: Includes only relevant concepts associated with all pneumococcal vaccine codes. This is a grouping of CVX codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1221'
    VALUE_SET_NAME = 'Pneumococcal Conjugate Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CVX = {'133', '152'}


class UrineProteinTests(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent urine protein tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with identifying urine protein tests, including those that look for albumin, microalbumin, and protein.
    Exclusion Criteria: Excludes codes that identify urine protein tests that would be taken from a fetus.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1024'
    VALUE_SET_NAME = 'Urine Protein Tests'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '11218-5', '12842-1', '13705-9', '13801-6', '13986-5', '13992-3', '14956-7', '14957-5',
        '14958-3', '14959-1', '1753-3', '1754-1', '1755-8', '1757-4', '17819-4', '18373-1',
        '20454-5', '20621-9', '21059-1', '21482-5', '26801-1', '27298-9', '2887-8', '2888-6',
        '2889-4', '2890-2', '29946-1', '30000-4', '30001-2', '30003-8', '32209-9', '32294-1',
        '32551-4', '34366-5', '35663-4', '40486-3', '40662-9', '40663-7', '43605-5', '43606-3',
        '43607-1', '44292-1', '47558-2', '49002-9', '49023-5', '50209-6', '50561-0', '50949-7',
        '51190-7', '53121-0', '53525-2', '53530-2', '53531-0', '53532-8', '56553-1', '57369-1',
        '57735-3', '5804-0', '58448-2', '58992-9', '59159-4', '60678-0', '63474-1', '6941-9',
        '6942-7', '76401-9', '77253-3', '77254-1', '77940-5', '9318-7'
    }


class UnilateralMastectomy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a unilateral mastectomy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying that a unilateral mastectomy was performed. This is a grouping of SNOMED CT and ICD-10-CM codes.
    Exclusion Criteria: Excludes codes that indicate a bilateral mastectomy.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1020'
    VALUE_SET_NAME = 'Unilateral Mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'19180', '19200', '19220', '19240', '19303', '19304', '19305', '19306', '19307'}

    SNOMEDCT = {
        '12275171000119105', '12275221000119100', '172043006', '237367009', '237368004',
        '237385002', '237388000', '274957008', '287653007', '287654001', '303690008', '307995002',
        '318190001', '33129002', '359728003', '359731002', '359734005', '359740003', '384723003',
        '395702000', '406505007', '428564008', '446109005', '446420001', '447135002', '447421006',
        '451201000124106', '451211000124109', '66398006', '70183006', '714111001', '714252004'
    }


class AnomaliesOfPupillaryFunction(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of pupillary function anomalies.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of miosis and constricted pupil.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1406'
    VALUE_SET_NAME = 'Anomalies of Pupillary Function'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H5703'}

    ICD9CM = {'37942'}

    SNOMEDCT = {'247013009', '271608006', '301939004', '419340001', '63251006'}


class ChlorpheniramineHydrocodone(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorpheniramine / hydrocodone combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorpheniramine / hydrocodone (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorpheniramine / hydrocodone in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1330'
    VALUE_SET_NAME = 'Chlorpheniramine / Hydrocodone'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1087459', '1372265', '857510', '857512'}


class ChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent chlorpheniramine / phenylephrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; chlorpheniramine / phenylephrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; chlorpheniramine / phenylephrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1343'
    VALUE_SET_NAME = 'Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1013619', '1086463', '1090443', '1293487', '1367227', '1429345'}


class Disopyramide(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent disopyramide medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; disopyramide only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; disopyramide in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1311'
    VALUE_SET_NAME = 'Disopyramide'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'309958', '309960', '636793', '636794'}


class DialysisEducation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients received dialysis education.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Intervention, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with patients who had dialysis education. This includes only relevant concepts associated with education at home.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1016'
    VALUE_SET_NAME = 'Dialysis Education'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'28812006', '385972005', '59596005', '66402002'}


class Galactosemia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses that represent galactosemia.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis. The intent of this data element is to identify galactosemia.
    Inclusion Criteria: Includes only relevant concepts associated with ICD-10-CM and SNOMED CT codes that identify galactosemia.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.35'
    VALUE_SET_NAME = 'Galactosemia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'E7420', 'E7421', 'E7429'}

    SNOMEDCT = {'124354006', '190745006', '237963003', '297237003', '297238008', '8849004'}


class ObstetricsVte(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a venous thromboembolism related to pregnancy or obstetrics.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter. The intent of this data element is to identify patients who have a venous thromboembolism related to pregnancy or obstetrics.
    Inclusion Criteria: Includes only relevant concepts associated with a venous thromboembolism related to pregnancy or obstetrics.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.264'
    VALUE_SET_NAME = 'Obstetrics VTE'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'O032', 'O0335', 'O037', 'O0385', 'O047', 'O0485', 'O072', 'O0735', 'O082', 'O087',
        'O2230', 'O2231', 'O2232', 'O2233', 'O2250', 'O2251', 'O2252', 'O2253', 'O228X1', 'O228X2',
        'O228X3', 'O228X9', 'O2290', 'O2291', 'O2292', 'O2293', 'O871', 'O873', 'O878', 'O879',
        'O88211', 'O88212', 'O88213', 'O88219', 'O8822', 'O8823'
    }

    SNOMEDCT = {
        '13943000', '19363005', '198876008', '200232006', '200233001', '200237000', '200238005',
        '200284000', '200299000', '200301007', '200302000', '200303005', '200304004', '21604008',
        '267280004', '26743002', '280966008', '37787009', '43306002', '49956009', '51096002',
        '55589000', '55976003', '56272000', '56462001', '57734001', '58123006', '609497003',
        '62583006', '63795001', '663008', '82153002', '84216001'
    }


class IntermittentPneumaticCompressionDevicesIpc(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent intermittent pneumatic compression devices used for venous thromboembolism (VTE) prophylaxis.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Device. The intent of this data element is to represent the application of certain intermittent pneumatic compression devices.
    Inclusion Criteria: Includes only relevant concepts associated with representing different types of intermittent pneumatic compression devices.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.214'
    VALUE_SET_NAME = 'Intermittent pneumatic compression devices (IPC)'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'428411000124104', '428421000124107', '442111003', '469317002', '469365001'}


class LowRisk(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent results of an assessment or other measurement or observation that is "low."
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to assessment. The intent of this data element is to identify patients who have an observation or measurement of an assessment that is "low."
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT codes that specifically represent a qualifier value of "low."
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.400'
    VALUE_SET_NAME = 'Low Risk'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'260362008', '62482003'}


class VenousThromboembolism(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a venous thromboembolism, including a pulmonary embolism.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis. The intent of this data element is to identify patients who have a venous thromboembolism, including those who have a pulmonary embolism.
    Inclusion Criteria: Includes only relevant concepts associated with codes representing pulmonary embolism and proximal venous thromboembolisms, including specific proximal veins: popliteal vein, femoral/superficial femoral vein, deep femoral vein, ileofemoral vein, iliac vein and inferior vena cava.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.279'
    VALUE_SET_NAME = 'Venous Thromboembolism'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'I2602', 'I2609', 'I2692', 'I2699', 'I8010', 'I8011', 'I8012', 'I8013', 'I80201', 'I80202',
        'I80203', 'I80209', 'I80211', 'I80212', 'I80213', 'I80219', 'I80221', 'I80222', 'I80223',
        'I80229', 'I80291', 'I80292', 'I80293', 'I80299', 'I803', 'I809', 'I82220', 'I82290',
        'I82401', 'I82402', 'I82403', 'I82409', 'I82411', 'I82412', 'I82413', 'I82419', 'I82421',
        'I82422', 'I82423', 'I82429', 'I82431', 'I82432', 'I82433', 'I82439', 'I824Y1', 'I824Y2',
        'I824Y3', 'I824Y9', 'I82890', 'I8290'
    }

    SNOMEDCT = {
        '1001000119102', '11029002', '128053003', '128055005', '132251000119101',
        '132291000119106', '132301000119107', '134399007', '16750002', '1748006', '194883006',
        '195394007', '195405004', '195408002', '195410000', '195411001', '195421009', '195422002',
        '195423007', '195425000', '195426004', '195427008', '195437003', '213220000', '233935004',
        '233936003', '234044007', '234049002', '25114006', '266267005', '276494008', '281595001',
        '312584000', '312588002', '31295000', '35979000', '40198004', '404223003', '413956008',
        '427775006', '427776007', '42861008', '429098002', '441746000', '444325005', '46253008',
        '50817002', '52496006', '57834008', '58309001', '59282003', '64662007', '69357003',
        '7387004', '74315008', '77892009', '83727005', '83938003', '95448006', '95449003'
    }


class StatinGrouper(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent statin medications that are prescribed for therapy at hospital discharge.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify patients who are prescribed statin medications at discharge.
    Inclusion Criteria: Includes only relevant concepts associated with single and multiple ingredient prescribable statin medications. Oral dose forms should be included. Generic only.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1110.19'
    VALUE_SET_NAME = 'Statin Grouper'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1790679', '1944264', '197903', '197904', '197905', '198211', '2001254', '2001262',
        '2001266', '200345', '259255', '310404', '310405', '312961', '312962', '314231', '359731',
        '359732', '360507', '404011', '404013', '433849', '476345', '476349', '476350', '476351',
        '597967', '597971', '597974', '597977', '597980', '597984', '597987', '597990', '597993',
        '617310', '617311', '617312', '757702', '757703', '757704', '757705', '859419', '859424',
        '859747', '859751', '861643', '861648', '861652', '904458', '904467', '904475', '904481'
    }


class PreviousReceiptOfInfluenzaVaccine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a patient reporting a previous receipt of an influenza vaccine.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Communication or Assessment.
    Inclusion Criteria: Includes only relevant concepts associated with a patient reporting a previous receipt of an influenza vaccine.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1185'
    VALUE_SET_NAME = 'Previous Receipt of Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'185900003', '185901004', '185902006', '416928007'}


class InfluenzaVaccinationDeclined(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a patient declining an influenza vaccination.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Communication.
    Inclusion Criteria: Includes only relevant concepts associated with a patient declining an influenza vaccination.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1255'
    VALUE_SET_NAME = 'Influenza Vaccination Declined'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'315640000'}


class PregnancyDx(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent diagnoses and disorders that indicate pregnancy, type of pregnancy and termination of pregnancy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attributes related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who were pregnant, termination of pregnancy and type of pregnancy.
    Exclusion Criteria: Excludes previously conceived and past delivered pregnancies.
    """

    OID = '2.16.840.1.113883.3.600.1.1623'
    VALUE_SET_NAME = 'Pregnancy Dx'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A34', 'O0000', 'O0001', 'O00101', 'O00102', 'O00109', 'O00111', 'O00112', 'O00119',
        'O00201', 'O00202', 'O00209', 'O00211', 'O00212', 'O00219', 'O0080', 'O0081', 'O0090',
        'O0091', 'O019', 'O020', 'O021', 'O030', 'O031', 'O032', 'O0330', 'O0331', 'O0332',
        'O0333', 'O0334', 'O0337', 'O0339', 'O034', 'O035', 'O036', 'O037', 'O0380', 'O0381',
        'O0382', 'O0383', 'O0384', 'O0385', 'O0386', 'O0387', 'O0388', 'O0389', 'O039', 'O045',
        'O046', 'O047', 'O0480', 'O0481', 'O0482', 'O0483', 'O0484', 'O0485', 'O0486', 'O0487',
        'O0488', 'O0489', 'O070', 'O071', 'O072', 'O0730', 'O0731', 'O0732', 'O0733', 'O0734',
        'O0735', 'O0736', 'O0737', 'O0738', 'O0739', 'O074', 'O080', 'O081', 'O082', 'O083',
        'O084', 'O085', 'O086', 'O087', 'O0881', 'O0882', 'O0883', 'O0889', 'O089', 'O0900',
        'O0910', 'O0911', 'O0912', 'O0913', 'O09211', 'O09291', 'O0930', 'O0940', 'O0941', 'O0942',
        'O0943', 'O09511', 'O09512', 'O09513', 'O09519', 'O09521', 'O09522', 'O09523', 'O09529',
        'O09611', 'O09621', 'O09819', 'O09821', 'O09822', 'O09823', 'O09829', 'O09891', 'O09892',
        'O09893', 'O09899', 'O0990', 'O0991', 'O0992', 'O0993', 'O09A0', 'O09A1', 'O09A2', 'O09A3',
        'O10011', 'O10012', 'O10013', 'O10019', 'O1003', 'O10111', 'O10112', 'O10113', 'O10119',
        'O1012', 'O1013', 'O10211', 'O10212', 'O10213', 'O10219', 'O1022', 'O1023', 'O10311',
        'O10312', 'O10313', 'O10319', 'O1032', 'O1033', 'O10411', 'O10412', 'O10413', 'O10419',
        'O1042', 'O1043', 'O10911', 'O10912', 'O10913', 'O10919', 'O1092', 'O1093', 'O111', 'O112',
        'O113', 'O114', 'O115', 'O119', 'O1200', 'O1201', 'O1202', 'O1203', 'O1204', 'O1205',
        'O1210', 'O1211', 'O1212', 'O1213', 'O1220', 'O1221', 'O1222', 'O1223', 'O1224', 'O1225',
        'O131', 'O132', 'O133', 'O134', 'O135', 'O139', 'O1400', 'O1402', 'O1403', 'O1404',
        'O1405', 'O1410', 'O1412', 'O1413', 'O1414', 'O1415', 'O1420', 'O1422', 'O1423', 'O1424',
        'O1425', 'O1490', 'O1492', 'O1493', 'O1494', 'O1495', 'O1502', 'O1503', 'O151', 'O152',
        'O161', 'O162', 'O163', 'O164', 'O165', 'O169', 'O200', 'O208', 'O209', 'O210', 'O212',
        'O218', 'O219', 'O2200', 'O2201', 'O2202', 'O2203', 'O2210', 'O2211', 'O2212', 'O2213',
        'O2220', 'O2221', 'O2222', 'O2223', 'O2230', 'O2231', 'O2232', 'O2233', 'O2240', 'O2241',
        'O2242', 'O2243', 'O2250', 'O2251', 'O2252', 'O2253', 'O2290', 'O2291', 'O2292', 'O2293',
        'O2300', 'O2310', 'O2320', 'O2330', 'O2340', 'O2341', 'O2342', 'O2343', 'O23519', 'O23529',
        'O23599', 'O2390', 'O2391', 'O2392', 'O2393', 'O24319', 'O2432', 'O24415', 'O24419',
        'O24425', 'O24429', 'O24435', 'O24439', 'O24911', 'O24912', 'O24913', 'O2492', 'O2493',
        'O2510', 'O2511', 'O2512', 'O2513', 'O252', 'O253', 'O2600', 'O2601', 'O2602', 'O2603',
        'O2611', 'O2612', 'O2613', 'O2620', 'O2621', 'O2622', 'O2623', 'O2641', 'O2642', 'O2643',
        'O2650', 'O2651', 'O2652', 'O2653', 'O26611', 'O26612', 'O26613', 'O26619', 'O2662',
        'O26811', 'O26812', 'O26813', 'O26819', 'O26821', 'O26822', 'O26823', 'O26829', 'O26831',
        'O26832', 'O26833', 'O26839', 'O26841', 'O26842', 'O26843', 'O26849', 'O26851', 'O26852',
        'O26853', 'O26859', 'O26872', 'O26873', 'O26879', 'O26891', 'O26892', 'O26893', 'O26899',
        'O2690', 'O30001', 'O30002', 'O30003', 'O30009', 'O30021', 'O30022', 'O30023', 'O30029',
        'O30101', 'O30102', 'O30103', 'O30109', 'O30201', 'O30202', 'O30203', 'O30209', 'O30801',
        'O30802', 'O30803', 'O30809', 'O3090', 'O3091', 'O3092', 'O3093', 'O330', 'O331', 'O332',
        'O337XX0', 'O337XX1', 'O337XX2', 'O337XX3', 'O337XX4', 'O337XX5', 'O337XX9', 'O338',
        'O339', 'O3400', 'O3401', 'O3402', 'O3403', 'O3410', 'O3411', 'O3412', 'O3413', 'O34211',
        'O34212', 'O34219', 'O3429', 'O3430', 'O3431', 'O3432', 'O3433', 'O3440', 'O3441', 'O3442',
        'O3443', 'O34511', 'O34512', 'O34513', 'O34519', 'O34521', 'O34522', 'O34523', 'O34529',
        'O34531', 'O34532', 'O34533', 'O34539', 'O34591', 'O34592', 'O34593', 'O34599', 'O3460',
        'O3461', 'O3462', 'O3463', 'O3470', 'O3471', 'O3472', 'O3473', 'O3480', 'O3481', 'O3482',
        'O3483', 'O3490', 'O3491', 'O3492', 'O3493', 'O357XX0', 'O357XX1', 'O357XX2', 'O357XX3',
        'O357XX4', 'O357XX5', 'O357XX9', 'O358XX0', 'O358XX1', 'O358XX2', 'O358XX3', 'O358XX4',
        'O358XX5', 'O358XX9', 'O360110', 'O360120', 'O360130', 'O360190', 'O360910', 'O360920',
        'O360930', 'O360990', 'O361110', 'O361120', 'O361130', 'O361190', 'O361910', 'O361920',
        'O361930', 'O361990', 'O365110', 'O365120', 'O365130', 'O365190', 'O365910', 'O365920',
        'O365930', 'O365990', 'O368120', 'O368130', 'O368190', 'O368210', 'O368220', 'O368230',
        'O368290', 'O368910', 'O368920', 'O368930', 'O368990', 'O411010', 'O411020', 'O411030',
        'O411090', 'O411210', 'O411220', 'O411230', 'O411290', 'O411410', 'O411420', 'O411430',
        'O411490', 'O4200', 'O42011', 'O42012', 'O42013', 'O4202', 'O4210', 'O42111', 'O42112',
        'O42113', 'O4212', 'O43011', 'O43019', 'O43101', 'O43102', 'O43103', 'O43199', 'O43211',
        'O43212', 'O43213', 'O43221', 'O43222', 'O43223', 'O43231', 'O43232', 'O43233', 'O43239',
        'O43811', 'O43812', 'O43813', 'O43819', 'O4391', 'O4392', 'O4393', 'O4400', 'O4401',
        'O4402', 'O4403', 'O4410', 'O4411', 'O4412', 'O4413', 'O4420', 'O4421', 'O4422', 'O4423',
        'O4430', 'O4431', 'O4432', 'O4433', 'O4440', 'O4441', 'O4442', 'O4443', 'O4450', 'O4451',
        'O4452', 'O4453', 'O45001', 'O45002', 'O45003', 'O45011', 'O45012', 'O45013', 'O45021',
        'O45022', 'O45023', 'O45091', 'O45092', 'O45093', 'O4591', 'O4592', 'O4593', 'O46001',
        'O46002', 'O46003', 'O46009', 'O46011', 'O46012', 'O46013', 'O46019', 'O46021', 'O46022',
        'O46023', 'O46029', 'O46091', 'O46092', 'O46093', 'O46099', 'O4690', 'O4691', 'O4692',
        'O4693', 'O4700', 'O4702', 'O4703', 'O471', 'O479', 'O480', 'O481', 'O6000', 'O6002',
        'O6003', 'O610', 'O611', 'O619', 'O620', 'O621', 'O622', 'O623', 'O624', 'O629', 'O630',
        'O631', 'O632', 'O639', 'O654', 'O655', 'O659', 'O660', 'O661', 'O6640', 'O665', 'O668',
        'O669', 'O670', 'O678', 'O679', 'O68', 'O700', 'O701', 'O7020', 'O7021', 'O7022', 'O7023',
        'O703', 'O704', 'O709', 'O7100', 'O7102', 'O7103', 'O711', 'O712', 'O713', 'O714', 'O715',
        'O716', 'O717', 'O7182', 'O7189', 'O719', 'O720', 'O721', 'O722', 'O723', 'O730', 'O731',
        'O741', 'O742', 'O743', 'O748', 'O749', 'O750', 'O751', 'O752', 'O753', 'O754', 'O755',
        'O7581', 'O7589', 'O759', 'O76', 'O770', 'O80', 'O82', 'O85', 'O8600', 'O8601', 'O8602',
        'O8603', 'O8604', 'O8609', 'O8611', 'O8612', 'O8613', 'O8619', 'O8620', 'O8621', 'O8622',
        'O8629', 'O864', 'O8681', 'O8689', 'O870', 'O871', 'O872', 'O873', 'O874', 'O878', 'O879',
        'O88011', 'O88012', 'O88013', 'O88019', 'O8802', 'O8803', 'O88111', 'O88112', 'O88113',
        'O88119', 'O8812', 'O8813', 'O88211', 'O88212', 'O88213', 'O88219', 'O8822', 'O8823',
        'O88311', 'O88312', 'O88313', 'O88319', 'O8832', 'O8833', 'O88811', 'O88812', 'O88813',
        'O88819', 'O8882', 'O8883', 'O8909', 'O891', 'O892', 'O898', 'O899', 'O900', 'O901',
        'O902', 'O903', 'O904', 'O905', 'O906', 'O9081', 'O9089', 'O909', 'O91011', 'O91012',
        'O91013', 'O91019', 'O9102', 'O91111', 'O91112', 'O91113', 'O91119', 'O9112', 'O91211',
        'O91212', 'O91213', 'O91219', 'O9122', 'O9123', 'O92011', 'O92012', 'O92013', 'O92019',
        'O9203', 'O92111', 'O92112', 'O92113', 'O92119', 'O9213', 'O9220', 'O9229', 'O923', 'O925',
        'O926', 'O9270', 'O9279', 'O94', 'O98011', 'O98012', 'O98013', 'O98019', 'O9802', 'O9803',
        'O98111', 'O98112', 'O98113', 'O98119', 'O9812', 'O9813', 'O98211', 'O98212', 'O98213',
        'O98219', 'O9822', 'O9823', 'O98311', 'O98312', 'O98313', 'O98319', 'O9832', 'O9833',
        'O9842', 'O9843', 'O98511', 'O98512', 'O98513', 'O98519', 'O9852', 'O9853', 'O98611',
        'O98612', 'O98613', 'O98619', 'O9862', 'O9863', 'O98811', 'O98812', 'O98813', 'O98819',
        'O9882', 'O9883', 'O98911', 'O98912', 'O98913', 'O98919', 'O9892', 'O9893', 'O99011',
        'O99012', 'O99013', 'O99019', 'O9902', 'O9903', 'O99111', 'O99112', 'O99113', 'O99119',
        'O9912', 'O9913', 'O99210', 'O99211', 'O99212', 'O99213', 'O99214', 'O99215', 'O99280',
        'O99281', 'O99282', 'O99283', 'O99284', 'O99285', 'O99320', 'O99321', 'O99322', 'O99323',
        'O99324', 'O99325', 'O99330', 'O99331', 'O99332', 'O99333', 'O99334', 'O99335', 'O99340',
        'O99341', 'O99342', 'O99343', 'O99344', 'O99345', 'O99350', 'O99351', 'O99352', 'O99353',
        'O99354', 'O99355', 'O99411', 'O99412', 'O99413', 'O99419', 'O9942', 'O9943', 'O99810',
        'O99814', 'O99815', 'O99834', 'O99835', 'O99840', 'O99841', 'O99842', 'O99843', 'O99844',
        'O99845', 'O9989', 'Z331', 'Z332', 'Z333', 'Z3400', 'Z3401', 'Z3402', 'Z3403', 'Z3480',
        'Z3481', 'Z3482', 'Z3483', 'Z3490', 'Z3491', 'Z3492', 'Z3493', 'Z360', 'Z361', 'Z362',
        'Z363', 'Z364', 'Z365', 'Z3681', 'Z3682', 'Z3684', 'Z3685', 'Z3686', 'Z3687', 'Z3688',
        'Z3689', 'Z368A', 'Z369'
    }

    SNOMEDCT = {
        '102872000', '102873005', '102875003', '127363001', '14418008', '16356006', '169560008',
        '169561007', '169562000', '169563005', '169564004', '169565003', '169566002', '169567006',
        '169568001', '198624007', '198626009', '198627000', '199715003', '237233002', '237238006',
        '237239003', '237240001', '237241002', '237242009', '237244005', '239101008', '248985009',
        '281307002', '29399001', '314204000', '31601007', '34801009', '38720006', '41587001',
        '41991004', '43990006', '442478007', '44782008', '45307008', '47200007', '57630001',
        '58532003', '59466002', '60000008', '60810003', '64254006', '65147003', '65727000',
        '69532007', '72892002', '77386006', '79290002', '79586000', '80997009', '82661006',
        '83074005', '87605005', '90968009', '9279009', '9899009'
    }


class Amblyopia(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of amblyopia.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of amblyopia, including suspected amblyopia.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1448'
    VALUE_SET_NAME = 'Amblyopia'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H53001', 'H53002', 'H53003', 'H53011', 'H53012', 'H53013', 'H53021', 'H53022', 'H53023',
        'H53031', 'H53032', 'H53033', 'H53041', 'H53042', 'H53043'
    }

    ICD9CM = {'36800', '36801', '36802', '36803'}

    SNOMEDCT = {
        '193638002', '232147001', '336451000119108', '342061000119102', '347241000119107',
        '35600002', '361120000', '387742006', '387743001', '396184003', '410486005', '70701004',
        '75834006', '90927000', '965003'
    }


class FrailtyEncounter(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent nursing care services provided to frail patients.
    Data Element Scope: This value set may use Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with nursing care and home care services provided to frail patients. This is a grouping of CPT, HCPCS, and SNOMEDCT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1088'
    VALUE_SET_NAME = 'Frailty Encounter'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99504', '99509'}

    HCPCS = {
        'G0162', 'G0299', 'G0300', 'G0493', 'G0494', 'S0271', 'S0311', 'S9123', 'S9124', 'T1000',
        'T1001', 'T1002', 'T1003', 'T1004', 'T1005', 'T1019', 'T1020', 'T1021', 'T1022', 'T1030',
        'T1031'
    }

    SNOMEDCT = {'413467001'}


class LiverDisease(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of liver disease.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype or attribute related to Diagnosis. The intent of this value set is to capture liver disease that would indicate that a statin medication may not be appropriate.
    Inclusion Criteria: Includes only relevant concepts associated with acute and chronic liver conditions that may represent the liver is failing. Examples of conditions include concepts associated with, but are not limited to, the following: alcoholic liver damage, cirrhosis, hepatitis C and E, and liver necrosis.
    Exclusion Criteria: Excludes hepatitis A and hepatitis B.
    """

    OID = '2.16.840.1.113762.1.4.1047.42'
    VALUE_SET_NAME = 'Liver Disease'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'B170', 'B1710', 'B1711', 'B172', 'B178', 'B179', 'B182', 'B188', 'B189', 'B190', 'B1920',
        'B1921', 'B199', 'K700', 'K7010', 'K7011', 'K702', 'K7030', 'K7031', 'K7040', 'K7041',
        'K709', 'K710', 'K7110', 'K7111', 'K712', 'K713', 'K714', 'K7150', 'K7151', 'K716', 'K717',
        'K718', 'K719', 'K7200', 'K7201', 'K7210', 'K7211', 'K7290', 'K7291', 'K730', 'K731',
        'K732', 'K738', 'K739', 'K740', 'K741', 'K742', 'K743', 'K744', 'K745', 'K7460', 'K7469',
        'K754', 'O98411', 'O98412', 'O98413', 'O98419'
    }

    ICD9CM = {
        '07041', '07042', '07043', '07044', '07049', '07051', '07052', '07053', '07054', '07059',
        '0706', '07070', '07071', '570', '5710', '5712', '5713', '57140', '57141', '57142',
        '57149', '5715', '5716', '5718', '5719', '5724', '5728'
    }

    SNOMEDCT = {
        '10295004', '10759111000119102', '10759151000119101', '109819003', '111896003',
        '123717006', '128302006', '16069000', '186628001', '186634008', '197268000', '197270009',
        '197271008', '197279005', '197284004', '197286002', '197352008', '197359004', '197360009',
        '197361008', '199203001', '19943007', '206372007', '235865005', '235866006', '235867002',
        '235868007', '235869004', '235870003', '235875008', '235876009', '235889003', '266468003',
        '276668008', '278929008', '307757001', '31005002', '328383001', '347891000119103',
        '370889009', '3738000', '37871000', '397575003', '406584008', '406585009', '408335007',
        '41309000', '41889008', '420054005', '425413006', '435091000124105', '435101000124104',
        '450880008', '4846001', '4896000', '50325005', '50711007', '51292008', '57412004',
        '58282009', '59927004', '60037002', '62216007', '66870002', '702969000', '703866000',
        '707341005', '708198006', '72445008', '76783007', '79720007', '831000119103', '89789003',
        '95556007', '9953008'
    }


class PalliativeOrHospiceCare(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent identifying patients receiving palliative, comfort or hospice care.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Intervention or Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients receiving palliative, comfort or hospice care.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1.1579'
    VALUE_SET_NAME = 'Palliative or Hospice Care'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '103735009', '133918004', '182964004', '305284002', '305381007', '305981001', '306237005',
        '306288008', '385736008', '385763009'
    }


class Methocarbamol(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent methocarbamol medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs (concepts associated with component, form and strength); generic; human use only; prescribable; methocarbamol only.
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; methocarbamol in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1370'
    VALUE_SET_NAME = 'Methocarbamol'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'197943', '197944'}


class Hiv(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent human immunodeficiency virus (HIV) disease.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with HIV and acquired immunodeficiency syndrome. This is a grouping of ICD-10-CM, ICD-9-CM and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.120.12.1003'
    VALUE_SET_NAME = 'HIV'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'B20', 'B9735', 'Z21'}

    ICD9CM = {'042', '07953', 'V08'}

    SNOMEDCT = {
        '10746341000119109', '111880001', '165816005', '186706006', '186707002', '186708007',
        '186709004', '186717007', '186718002', '186719005', '186721000', '186723002', '186725009',
        '186726005', '230180003', '230201009', '230202002', '230598008', '235009000', '235726002',
        '236406007', '240103002', '276665006', '276666007', '315019000', '359791000', '397763006',
        '398329009', '402901009', '402915006', '402916007', '405631006', '406109008', '40780007',
        '414604009', '416729007', '420244003', '420281004', '420302007', '420308006', '420321004',
        '420384005', '420395004', '420403001', '420452002', '420524008', '420543008', '420544002',
        '420549007', '420554003', '420614009', '420658009', '420687005', '420691000', '420718004',
        '420721002', '420764009', '420774007', '420787001', '420801006', '420818005', '420877009',
        '420900006', '420938005', '420945005', '421020000', '421023003', '421047005', '421077004',
        '421102007', '421230000', '421272004', '421283008', '421312009', '421315006', '421394009',
        '421403008', '421415007', '421431004', '421454008', '421460008', '421508002', '421510000',
        '421529006', '421571007', '421597001', '421660003', '421666009', '421671002', '421695000',
        '421706001', '421708000', '421710003', '421766003', '421827003', '421851008', '421874007',
        '421883002', '421929001', '421983003', '421998001', '422003001', '422012004', '422074008',
        '422089004', '422127002', '422136003', '422177004', '422189002', '422194002', '422282000',
        '422337001', '432218001', '442537007', '442662004', '445945000', '48794007', '52079000',
        '5810003', '62246005', '62479008', '697904001', '697965002', '699433000', '700053002',
        '713260006', '713275003', '713278001', '713297001', '713298006', '713299003', '713300006',
        '713316008', '713318009', '713320007', '713325002', '713339002', '713340000', '713341001',
        '713342008', '713349004', '713444005', '713445006', '713446007', '713483007', '713484001',
        '713487008', '713488003', '713489006', '713490002', '713491003', '713497004', '713503007',
        '713504001', '713505000', '713506004', '713507008', '713508003', '713510001', '713511002',
        '713523008', '713526000', '713527009', '713530002', '713531003', '713532005', '713533000',
        '713543002', '713544008', '713545009', '713546005', '713570009', '713571008', '713572001',
        '713695001', '713696000', '713718006', '713722001', '713729005', '713730000', '713731001',
        '713732008', '713733003', '713734009', '713742005', '713844000', '713845004', '713880000',
        '713881001', '713887002', '713897006', '713964006', '713967004', '714083007', '714464009',
        '719522009', '721166000', '722557007', '72621000119104', '733834006', '733835007',
        '735521001', '735522008', '735523003', '735524009', '735525005', '735526006', '735527002',
        '735528007', '76981000119106', '76991000119109', '77070006', '80191000119101',
        '81000119104', '86406008', '87117006', '90681000119107', '90691000119105', '91923005',
        '91947003', '91948008'
    }


class PatientReasonRefused(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a reason for patient refusal.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Negation Rationale.
    Inclusion Criteria: Includes only relevant concepts associated with identifying a patient's reason for refusing treatment.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.791'
    VALUE_SET_NAME = 'Patient Reason refused'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'105480006', '183944003', '183945002', '413310006', '413311005', '413312003'}


class RetrolentalFibroplasias(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of retrolental fibroplasias.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of retrolental fibroplasias, including retinopathy of prematurity.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1438'
    VALUE_SET_NAME = 'Retrolental Fibroplasias'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H35171', 'H35172', 'H35173'}

    ICD9CM = {'36221'}

    SNOMEDCT = {'408847006', '408848001', '408849009', '408850009', '408851008', '415297005'}


class AcetaminophenButalbitalCaffeine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / butalbital / caffeine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / butalbital / caffeine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / butalbital / caffeine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1363'
    VALUE_SET_NAME = 'Acetaminophen / Butalbital / Caffeine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'238153', '238154', '889520'}


class AcetaminophenChlorpheniramineDextromethorphan(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / chlorpheniramine / dextromethorphan combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / chlorpheniramine / dextromethorphan (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / chlorpheniramine / dextromethorphan in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1421'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Dextromethorphan'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1038876', '1086750', '1098496', '1113522'}


class HereditaryCornealDystrophies(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of hereditary corneal dystrophies.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of hereditary corneal dystrophies, including congenital, epithelial/juvenile, granular, lattice or macular corneal dystrophies.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1424'
    VALUE_SET_NAME = 'Hereditary Corneal Dystrophies'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H1850', 'H1851', 'H1852', 'H1853', 'H1854', 'H1855', 'H1859'}

    ICD9CM = {'37150', '37151', '37152', '37153', '37154', '37155', '37156', '37157', '37158'}

    SNOMEDCT = {
        '123670005', '129623003', '1674008', '193837009', '193839007', '231930000', '231931001',
        '231933003', '231934009', '29504002', '361199007', '373426005', '39662004', '397568004',
        '404633004', '416633008', '416960004', '417065002', '417183007', '417395001', '417651000',
        '418054005', '418435001', '418946006', '419039007', '419087002', '419197009', '419395007',
        '419900000', '430888006', '45283008', '5587004', '60258001', '75663006', '77797009',
        '95488001'
    }


class HeartFailure(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of heart failure.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of heart failure.
    Exclusion Criteria: Excludes chronic and acute right-sided heart failure, right heart failure, right ventricular failure, cardiac insufficiency due to prosthesis and following cardiac surgery, or pulmonale.
    """

    OID = '2.16.840.1.113883.3.526.3.376'
    VALUE_SET_NAME = 'Heart Failure'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'I110', 'I130', 'I132', 'I501', 'I5020', 'I5021', 'I5022', 'I5023', 'I5030', 'I5031',
        'I5032', 'I5033', 'I5040', 'I5041', 'I5042', 'I5043', 'I50814', 'I5082', 'I5083', 'I5084',
        'I5089', 'I509'
    }

    ICD9CM = {
        '40201', '40211', '40291', '40401', '40403', '40411', '40413', '40491', '40493', '4280',
        '4281', '42820', '42821', '42822', '42823', '42830', '42831', '42832', '42833', '42840',
        '42841', '42842', '42843', '4289'
    }

    SNOMEDCT = {
        '10091002', '101281000119107', '10633002', '111283005', '120851000119104',
        '120861000119102', '120871000119108', '120881000119106', '120891000119109',
        '120901000119108', '153931000119109', '153941000119100', '153951000119103',
        '15629541000119106', '15629591000119103', '15629641000119107', '15629741000119102',
        '15781000119107', '15964701000119109', '194767001', '194779001', '194781004', '195111005',
        '195112003', '195114002', '206586007', '23341000119109', '233924009', '25544003',
        '314206003', '364006', '410431009', '417996009', '418304008', '42343007', '424404003',
        '426263006', '426611007', '43736008', '44088000', '441481004', '441530006', '44313006',
        '443253003', '443254009', '443343001', '443344007', '46113002', '471880001', '48447003',
        '5148006', '5375005', '56675007', '67431000119105', '67441000119101', '698594003',
        '703272007', '703273002', '703274008', '703275009', '703276005', '717840005',
        '72481000119103', '74960003', '82523003', '83105008', '84114007', '85232009', '88805009',
        '90727007', '92506005'
    }


class MedicalDisabilityExam(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent work related or medical disability examinations.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Encounter, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with work related or medical disability examinations. This is a grouping of CPT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1233'
    VALUE_SET_NAME = 'Medical Disability Exam'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'99455', '99456'}


class ChoroidalDetachment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of choroidal detachment.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis choroidal detachment, or effusion.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1451'
    VALUE_SET_NAME = 'Choroidal Detachment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'H31411', 'H31412', 'H31413'}

    ICD9CM = {'36372'}

    SNOMEDCT = {'19031009', '232000008', '247198004', '27871007', '278805002', '78584008'}


class OtherFemaleReproductiveConditions(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent female reproductive conditions that may be related to sexual activity.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a variety of reproductive conditions that may indicate sexual activity. This is a grouping of ICD-10-CM and SNOMED CT codes.
    Exclusion Criteria: Excludes codes for other reproductive conditions that could indicate sexual activity but that are already described in other value sets.
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1006'
    VALUE_SET_NAME = 'Other Female Reproductive Conditions'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'A630', 'B977', 'G4482', 'N881', 'N883', 'N898', 'N930', 'N970', 'N971', 'N972', 'N978',
        'N979', 'T8331XA', 'T8331XD', 'T8331XS', 'T8332XA', 'T8332XD', 'T8332XS', 'T8339XA',
        'T8339XD', 'T8339XS'
    }

    SNOMEDCT = {
        '103010005', '125157000', '168407000', '168472007', '198445009', '198446005', '198448006',
        '198449003', '198450003', '198452006', '198453001', '198456009', '198457000', '198459002',
        '198460007', '198464003', '198465002', '227561004', '237110007', '237139007', '237141008',
        '237142001', '237800001', '240542006', '266609001', '26899006', '286995008', '30238006',
        '30826006', '3160009', '35308000', '373877006', '391147004', '39446004', '395688005',
        '39591000119109', '399599006', '414238007', '414239004', '415149004', '416030007',
        '416031006', '416033009', '419266001', '426488001', '427547007', '428008002', '428017002',
        '439776006', '439855007', '439856008', '439888000', '439890004', '439891000', '441072002',
        '441086003', '441087007', '441088002', '441094005', '441098008', '441099000', '441114008',
        '441115009', '441219009', '441667007', '4667004', '48880000', '5084002', '52937008',
        '53821008', '58423003', '6303009', '65370002', '65454003', '6738008', '707577004',
        '712584009', '712585005', '74294009', '80330000', '82593008', '84785006', '85078005'
    }


class HpvTest(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent identify high-risk human papilloma virus (HPV) tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Laboratory Test, Performed.
    Inclusion Criteria: Includes only relevant concepts associated with high-risk HPV tests performed on cervical samples. This is a grouping of LOINC codes.
    Exclusion Criteria: Excludes high-risk HPV tests conducted on non-cervical samples. Excludes codes that indicate that this test was ordered only, and not necessarily performed.
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1059'
    VALUE_SET_NAME = 'HPV Test'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {
        '21440-3', '30167-1', '38372-9', '59263-4', '59264-2', '59420-0', '69002-4', '71431-1',
        '75406-9', '75694-0', '77379-6', '77399-4', '77400-0', '82354-2', '82456-5', '82675-0'
    }


class LifestyleRecommendation(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the type of interventions relevant to lifestyle needs.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure or Intervention.
    Inclusion Criteria: Includes only relevant concepts associated with the type of lifestyle education provided.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.600.1508'
    VALUE_SET_NAME = 'Lifestyle Recommendation'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'313204009', '39155009', '443402002'}


class DegenerativeDisordersOfGlobe(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of degenerative disorders of globe.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of degenerative disorders of globe, including degenerative myopia, chalcosis, siderosis, and other degenerative diagnoses.
    Exclusion Criteria: Excludes concepts that pertain to 'unspecified eye.'
    """

    OID = '2.16.840.1.113883.3.526.3.1454'
    VALUE_SET_NAME = 'Degenerative Disorders of Globe'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'H4421', 'H4422', 'H4423', 'H442A1', 'H442A2', 'H442A3', 'H442B1', 'H442B2', 'H442B3',
        'H442C1', 'H442C2', 'H442C3', 'H442D1', 'H442D2', 'H442D3', 'H442E1', 'H442E2', 'H44311',
        'H44312', 'H44313', 'H44321', 'H44322', 'H44323', 'H44391', 'H44392', 'H44393'
    }

    ICD9CM = {'36020', '36021', '36023', '36024', '36029'}

    SNOMEDCT = {
        '111521006', '14046000', '232001007', '232002000', '246877005', '247177004', '247178009',
        '247182006', '247183001', '264008', '264633009', '267611002', '267612009', '267718000',
        '30523006', '314427006', '35545005', '3577000', '37075008', '3712000', '40787005',
        '414173003', '414875008', '417939004', '418871005', '428212003', '54184008', '60189009',
        '61536007', '62585004', '69134001', '71047006', '95695004', '95696003', '95697007',
        '95699005', '95700006'
    }


class CoronaryArteryDiseaseNoMi(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of coronary artery disease without myocardial infarction.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with a diagnosis of coronary artery disease without myocardial infarction.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.369'
    VALUE_SET_NAME = 'Coronary Artery Disease No MI'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'I200', 'I201', 'I208', 'I209', 'I240', 'I241', 'I248', 'I249', 'I2510', 'I25110',
        'I25111', 'I25118', 'I25119', 'I255', 'I256', 'I25700', 'I25701', 'I25708', 'I25709',
        'I25710', 'I25711', 'I25718', 'I25719', 'I25720', 'I25721', 'I25728', 'I25729', 'I25730',
        'I25731', 'I25738', 'I25739', 'I25750', 'I25751', 'I25758', 'I25759', 'I25760', 'I25761',
        'I25768', 'I25769', 'I25790', 'I25791', 'I25798', 'I25799', 'I25810', 'I25811', 'I25812',
        'I2582', 'I2583', 'I2589', 'I259', 'Z951', 'Z955', 'Z9861'
    }

    ICD9CM = {
        '4110', '4111', '41181', '41189', '4130', '4131', '4139', '41400', '41401', '41402',
        '41403', '41404', '41405', '41406', '41407', '4142', '4143', '4148', '4149', 'V4581',
        'V4582'
    }

    SNOMEDCT = {
        '10365005', '123641001', '123642008', '19057007', '194823009', '194828000', '194842008',
        '194843003', '21470009', '233817007', '233819005', '233821000', '233970002', '28248000',
        '29899005', '300995000', '314116003', '315025001', '315348000', '35928006', '371803003',
        '371804009', '371805005', '371806006', '371807002', '371808007', '371809004', '371810009',
        '371811008', '371812001', '398274000', '408546009', '41334000', '420006002', '421327009',
        '427919004', '429245005', '429559004', '443502000', '4557003', '50570003', '53741008',
        '59021001', '61490001', '62207008', '63739005', '67682002', '74218008', '75398000',
        '85284003', '87343002', '89323001', '92517006'
    }


class OverweightOrObese(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent overweight or obese patients.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Diagnosis or Finding.
    Inclusion Criteria: Includes only relevant concepts associated with identifying patients who are currently overweight or obese.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113762.1.4.1047.502'
    VALUE_SET_NAME = 'Overweight or Obese'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'E6601', 'E6609', 'E661', 'E662', 'E663', 'E668', 'E669'}

    SNOMEDCT = {
        '162690006', '162863004', '162864005', '238131007', '238136002', '275947003', '408512008',
        '414915002', '414916001', '415530009', '83911000119104'
    }


class DepressionMedicationsAdolescent(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent medications that are commonly used to treat adolescent depression.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category or attribute related to Medication.
    Inclusion Criteria: Includes only relevant concepts associated with antidepressant medications as well as other recommended depressive management medications, specific to the child and adolescent age group, for depression management.
    Exclusion Criteria: Excludes medications that are not commonly used in the treatment of depression in the child and adolescent age group.
    """

    OID = '2.16.840.1.113883.3.600.469'
    VALUE_SET_NAME = 'Depression medications - adolescent'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {
        '1190110', '199990', '200371', '248097', '248098', '248642', '251200', '283406', '283407',
        '283485', '283672', '309313', '309314', '310384', '310385', '310386', '311725', '311726',
        '312938', '312940', '312941', '313580', '313581', '313582', '313583', '313584', '313585',
        '313586', '313989', '313990', '313995', '314111', '314277', '349332', '351249', '351250',
        '351285', '476809', '596926', '596930', '596934', '616402', '794947', '808744', '808748',
        '808751', '808753', '861064'
    }


class EggSubstance(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent an allergy or intolerance to an egg substance.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Allergy/Intolerance.
    Inclusion Criteria: Includes only relevant concepts associated with an allergy or intolerance to an egg substance.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1537'
    VALUE_SET_NAME = 'Egg Substance'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '102263004', '226881001', '226885005', '229955000', '256442007', '256443002', '286550009',
        '303300008', '414074006'
    }


class MacularEdemaFindingsPresent(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the presence of macular edema.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Communication, or Diagnosis, or as an attribute to represent exam findings.
    Inclusion Criteria: Includes only relevant concepts associated with the presence of macular edema.
    Exclusion Criteria: Concepts that do not indicate macular edema are excluded from this value set.
    """

    OID = '2.16.840.1.113883.3.526.3.1320'
    VALUE_SET_NAME = 'Macular Edema Findings Present'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '193350004', '193387007', '232020009', '312911008', '312912001', '312920004', '312921000',
        '312922007', '314010006', '314011005', '314014002', '314015001', '37231002', '399864000',
        '420486006', '421779007', '432789001'
    }


class Narcolepsy(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a diagnosis of narcolepsy.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with diagnosis codes to identify narcolepsy.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.114.12.1011'
    VALUE_SET_NAME = 'Narcolepsy'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {'G47411', 'G47419', 'G47421', 'G47429'}

    ICD9CM = {'34700', '34701', '34710', '34711'}

    SNOMEDCT = {
        '193042000', '427426006', '434241000124107', '434251000124109', '434261000124106',
        '60380001', '735676003', '91521000119104'
    }


class BehavioralHealthFollowUpVisit(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent patients who have had a behavioral health follow-up visit.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with health and behavior assessment or intervention, or education and training for patient self-management by a physician or other qualified health care professional.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1054'
    VALUE_SET_NAME = 'Behavioral Health Follow-up Visit'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {
        '96150', '96151', '96152', '96153', '96154', '98960', '98961', '98962', '99078', '99510'
    }


class StandardizedPainAssessmentTool(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent pain assessment tools or instruments used to quantify pain intensity.
    Data Element Scope: This value set may use Quality Data Model (QDM) category related to Assessment.
    Inclusion Criteria: Includes only relevant concepts associated with pain assessment tools or instruments used to quantify pain intensity such as 0-10 numerical rating scale, visual analog scale, a categorical scale, pictorial scale, faces pain rating scale, or the Brief Pain Inventory (BPI).
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.526.3.1028'
    VALUE_SET_NAME = 'Standardized Pain Assessment Tool'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'38208-5', '38214-3', '38221-8', '72514-3', '77565-0'}


class HealthAndBehavioralAssessmentReassessment(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent initial visits for health and behavior reassessments for an individual patient.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter.
    Inclusion Criteria: Includes only relevant concepts associated with encounter codes specific to subsequent assessment or reassessment of health and/or behaviors, which involve an individual patient.
    Exclusion Criteria: Excludes encounters for group settings.
    """

    OID = '2.16.840.1.113883.3.526.3.1529'
    VALUE_SET_NAME = 'Health and Behavioral Assessment, Reassessment'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    CPT = {'96151'}


class AcetaminophenChlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent acetaminophen / chlorpheniramine / pseudoephedrine combination medications.
    Data Element Scope: This value set may use the Quality Data Model (QDM) datatype related to Medication, Ordered.
    Inclusion Criteria: Includes only relevant concepts associated with semantic clinical drugs; generic; human use only; prescribable; acetaminophen / chlorpheniramine / pseudoephedrine (combination medication).
    Exclusion Criteria: Excludes branded drugs; components or ingredient only; non-prescribable; acetaminophen / chlorpheniramine / pseudoephedrine in combination with other medications.
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1316'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    RXNORM = {'1293344', '1294201'}


class Hba1CLaboratoryTest(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent hemoglobin A1c laboratory tests.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Laboratory Test.
    Inclusion Criteria: Includes only relevant concepts associated with identifying hemoglobin A1c laboratory tests.
    Exclusion Criteria: Excludes codes that identify hemoglobin A1c laboratory tests that use the International Federation of Clinical Chemistry and Laboratory Medicine (IFCC)   protocol and Japanese Diabetes Society (JDS)/Japanese Society of Clinical Chemistry (JSCC) protocol.
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1013'
    VALUE_SET_NAME = 'HbA1c Laboratory Test'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'17856-6', '4548-4', '4549-2'}


class CtColonography(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent identify a computed tomographic (CT) colonography.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure.
    Inclusion Criteria: Includes only relevant concepts associated with patients that have had a CT colonography. This is a grouping of CPT and SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1038'
    VALUE_SET_NAME = 'CT Colonography'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    LOINC = {'60515-4', '72531-7', '79069-1', '79071-7', '79101-2', '82688-3'}


class Payer(ValueSet):
    """

    Clinical Focus: Categories of types of health care payor entities as defined by the US Public Health Data Consortium SOP code system
    Data Element Scope: @code in CCDA r2.1 template Planned Coverage [act: identifier urn:oid:2.16.840.1.113883.10.20.22.4.129 (open)] DYNAMIC
    Inclusion Criteria: All codes in the code system
    Exclusion Criteria: none
    """

    OID = '2.16.840.1.114222.4.11.3591'
    VALUE_SET_NAME = 'Payer'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SOP = {
        '1', '11', '111', '112', '113', '119', '12', '121', '122', '123', '129', '13', '14', '19',
        '191', '2', '21', '211', '212', '213', '219', '22', '23', '25', '26', '29', '291', '299',
        '3', '31', '311', '3111', '3112', '3113', '3114', '3115', '3116', '3119', '312', '3121',
        '3122', '3123', '313', '32', '321', '3211', '3212', '32121', '32122', '32123', '32124',
        '32125', '32126', '32127', '32128', '322', '3221', '3222', '3223', '3229', '33', '331',
        '332', '333', '334', '34', '341', '342', '343', '349', '35', '36', '361', '362', '369',
        '37', '371', '3711', '3712', '3713', '372', '379', '38', '381', '3811', '3812', '3813',
        '3819', '382', '389', '39', '391', '4', '41', '42', '43', '44', '5', '51', '511', '512',
        '513', '514', '515', '516', '517', '519', '52', '521', '522', '523', '524', '529', '53',
        '54', '55', '56', '561', '562', '59', '6', '61', '611', '612', '613', '614', '619', '62',
        '621', '622', '623', '629', '7', '71', '72', '73', '79', '8', '81', '82', '821', '822',
        '823', '83', '84', '85', '89', '9', '91', '92', '93', '94', '95', '951', '953', '954',
        '959', '96', '97', '98', '99', '9999'
    }


class EncounterInpatient(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the most common inpatient encounter types.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Encounter. The intent of this data element is to identify patients who have had an inpatient encounter.
    Inclusion Criteria: Includes only relevant concepts associated with SNOMED CT codes representing inpatient encounter.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.666.5.307'
    VALUE_SET_NAME = 'Encounter Inpatient'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'183452005', '32485007', '8715000'}


class ParenteralNutrition(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent parenteral infusion procedures.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify parenteral infusion procedures.
    Inclusion Criteria: Includes only relevant concepts associated with ICD-10-PCS and SNOMED CT codes that identify parenteral infusion.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.38'
    VALUE_SET_NAME = 'Parenteral Nutrition'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {'3E0336Z', '3E0436Z', '3E0536Z', '3E0636Z'}

    SNOMEDCT = {'183027000', '225372007', '230114001', '230115000', '25156005', '304055007'}


class GynecologicalSurgery(ValueSet):
    """

    Clinical Focus: This value set grouping contains concepts that represent procedures of gynecologic surgery.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Procedure. The intent of this data element is to identify patients who have a gynecologic surgery procedure.
    Inclusion Criteria: Includes only relevant concepts associated with representing gynecologic surgery procedures.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.257'
    VALUE_SET_NAME = 'Gynecological Surgery'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10PCS = {
        '0U500ZZ', '0U510ZZ', '0U520ZZ', '0U540ZZ', '0U550ZZ', '0U557ZZ', '0U558ZZ', '0U560ZZ',
        '0U567ZZ', '0U568ZZ', '0U570ZZ', '0U577ZZ', '0U578ZZ', '0U800ZZ', '0U810ZZ', '0U820ZZ',
        '0U840ZZ', '0UB00ZZ', '0UB07ZZ', '0UB08ZZ', '0UB10ZZ', '0UB17ZZ', '0UB18ZZ', '0UB20ZZ',
        '0UB27ZZ', '0UB28ZZ', '0UB40ZZ', '0UB47ZZ', '0UB48ZZ', '0UB50ZZ', '0UB57ZZ', '0UB58ZZ',
        '0UB60ZZ', '0UB67ZZ', '0UB68ZZ', '0UB70ZZ', '0UB77ZZ', '0UB78ZZ', '0UT00ZZ', '0UT07ZZ',
        '0UT08ZZ', '0UT10ZZ', '0UT17ZZ', '0UT18ZZ', '0UT20ZZ', '0UT27ZZ', '0UT28ZZ', '0UT40ZZ',
        '0UT47ZZ', '0UT48ZZ', '0UT50ZZ', '0UT57ZZ', '0UT58ZZ', '0UT60ZZ', '0UT67ZZ', '0UT68ZZ',
        '0UT70ZZ', '0UT77ZZ', '0UT78ZZ', '0UT90ZZ', '0UT97ZZ', '0UT98ZZ', '0UTC0ZZ', '0UTC7ZZ',
        '0UTC8ZZ', '10T20ZZ', '10T27ZZ', '10T28ZZ'
    }

    SNOMEDCT = {
        '112918004', '116028008', '116141005', '116142003', '116143008', '116144002', '116167000',
        '116173004', '118865002', '120053002', '120064004', '13254001', '15306005', '1689004',
        '176914002', '176915001', '176916000', '176917009', '177018009', '177019001', '177046006',
        '177055009', '177056005', '214173000', '223306006', '22699007', '23575009', '236889009',
        '236890000', '236932009', '236935006', '236987005', '236988000', '25344002', '25811000',
        '265056007', '27185000', '276189003', '287931008', '287935004', '287945002', '29529008',
        '29672006', '29827000', '300897007', '30160001', '30172007', '302190000', '302191001',
        '302376006', '302377002', '307771009', '309879006', '309880009', '315059002', '315060007',
        '33015000', '35887003', '35955002', '359971002', '359974005', '359977003', '359980002',
        '359983000', '361222003', '361223008', '387739000', '387740003', '387741004', '41058005',
        '41059002', '413144006', '413145007', '41393008', '414575003', '42349006', '431316002',
        '43791001', '441820006', '4443002', '445912000', '44619000', '446446002', '446526009',
        '447771005', '44793005', '448539002', '47045001', '49493009', '54080001', '54490004',
        '60158005', '62692004', '63516002', '63596003', '66169000', '71225000', '75835007',
        '76876009', '77902002', '82269004', '83152002', '83416007', '84093003', '8550006',
        '85855000', '86477000', '87102007', '89325008'
    }


class MentalHealthDiagnoses(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent a mental health diagnoses.
    Data Element Scope: This value set may use the Quality Data Model (QDM) attribute related to Principal Diagnosis.
    Inclusion Criteria: Includes only relevant concepts associated with identifying mental health diagnoses.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.464.1003.105.12.1004'
    VALUE_SET_NAME = 'Mental Health Diagnoses'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    ICD10CM = {
        'F0390', 'F0391', 'F200', 'F201', 'F202', 'F203', 'F205', 'F2081', 'F2089', 'F209', 'F21',
        'F22', 'F23', 'F24', 'F250', 'F251', 'F258', 'F259', 'F28', 'F29', 'F3010', 'F3011',
        'F3012', 'F3013', 'F302', 'F303', 'F304', 'F308', 'F309', 'F310', 'F3110', 'F3111',
        'F3112', 'F3113', 'F312', 'F3130', 'F3131', 'F3132', 'F314', 'F315', 'F3160', 'F3161',
        'F3162', 'F3163', 'F3164', 'F3170', 'F3171', 'F3172', 'F3173', 'F3174', 'F3175', 'F3176',
        'F3177', 'F3178', 'F3181', 'F3189', 'F319', 'F320', 'F321', 'F322', 'F323', 'F324', 'F325',
        'F328', 'F3281', 'F3289', 'F329', 'F330', 'F331', 'F332', 'F333', 'F3340', 'F3341',
        'F3342', 'F338', 'F339', 'F340', 'F341', 'F348', 'F3481', 'F3489', 'F349', 'F39', 'F4000',
        'F4001', 'F4002', 'F4010', 'F4011', 'F40210', 'F40218', 'F40220', 'F40228', 'F40230',
        'F40231', 'F40232', 'F40233', 'F40240', 'F40241', 'F40242', 'F40243', 'F40248', 'F40290',
        'F40291', 'F40298', 'F408', 'F409', 'F410', 'F411', 'F413', 'F418', 'F419', 'F42', 'F422',
        'F423', 'F424', 'F428', 'F429', 'F430', 'F4310', 'F4311', 'F4312', 'F4320', 'F4321',
        'F4322', 'F4323', 'F4324', 'F4325', 'F4329', 'F438', 'F439', 'F440', 'F441', 'F442',
        'F444', 'F445', 'F446', 'F447', 'F4481', 'F4489', 'F449', 'F450', 'F451', 'F4520', 'F4521',
        'F4522', 'F4529', 'F4541', 'F4542', 'F458', 'F459', 'F481', 'F482', 'F488', 'F489',
        'F5000', 'F5001', 'F5002', 'F502', 'F508', 'F5081', 'F5082', 'F5089', 'F509', 'F5101',
        'F5102', 'F5103', 'F5104', 'F5105', 'F5109', 'F5111', 'F5112', 'F5113', 'F5119', 'F513',
        'F514', 'F515', 'F518', 'F519', 'F520', 'F521', 'F5221', 'F5222', 'F5231', 'F5232', 'F524',
        'F525', 'F526', 'F528', 'F529', 'F53', 'F530', 'F531', 'F59', 'F600', 'F601', 'F602',
        'F603', 'F604', 'F605', 'F606', 'F607', 'F6081', 'F6089', 'F609', 'F630', 'F631', 'F632',
        'F633', 'F6381', 'F6389', 'F639', 'F640', 'F641', 'F642', 'F648', 'F649', 'F650', 'F651',
        'F652', 'F653', 'F654', 'F6550', 'F6551', 'F6552', 'F6581', 'F6589', 'F659', 'F66',
        'F6810', 'F6811', 'F6812', 'F6813', 'F688', 'F68A', 'F69', 'F800', 'F801', 'F802', 'F804',
        'F8081', 'F8082', 'F8089', 'F809', 'F810', 'F812', 'F8181', 'F8189', 'F819', 'F82', 'F840',
        'F842', 'F843', 'F845', 'F848', 'F849', 'F88', 'F89', 'F900', 'F901', 'F902', 'F908',
        'F909', 'F910', 'F911', 'F912', 'F913', 'F918', 'F919', 'F930', 'F938', 'F939', 'F940',
        'F941', 'F942', 'F948', 'F949', 'F950', 'F951', 'F952', 'F958', 'F959', 'F980', 'F981',
        'F9821', 'F9829', 'F983', 'F984', 'F985', 'F988', 'F989', 'F99'
    }

    SNOMEDCT = {
        '101421000119107', '10211000132109', '10278007', '10327003', '10349009', '104851000119103',
        '10532003', '105421000119105', '10586006', '106021000119105', '10743001000119103',
        '10760421000119102', '10760461000119107', '10783000', '10811121000119102',
        '10811161000119107', '10835871000119104', '10875004', '109006', '109805003', '10981006',
        '109956006', '111477005', '111480006', '111482003', '111483008', '111484002', '111485001',
        '111486000', '111487009', '111490003', '111491004', '111492006', '1145003', '11806006',
        '11941006', '1196001', '12277671000119109', '12277711000119108', '12348006',
        '12367551000119100', '126943008', '12939007', '129562004', '129602009', '129604005',
        '129605006', '129606007', '12969000', '130121000119104', '133091000119105',
        '133121000119109', '13313007', '133991000119109', '13438001', '13581000', '13601005',
        '13670005', '13746004', '1376001', '1380006', '1383008', '14070001', '14077003',
        '14144000', '14183003', '141991000119109', '142001000119106', '142011000119109',
        '14291003', '14495005', '1499003', '15193003', '153071000119108', '15639000', '15662003',
        '1581000119101', '15840001', '1591000119103', '15921731000119106', '15945005', '15977008',
        '162004', '16219201000119101', '162218007', '162313000', '16265701000119107',
        '16265951000119109', '16266831000119100', '16266991000119108', '162722001',
        '16276361000119109', '16295005', '16506000', '16805009', '1686006', '16966009', '16990005',
        '17155009', '17226007', '17262008', '1740001000004102', '17496003', '17782008', '17961008',
        '18003009', '18085000', '1816003', '18186001', '18193002', '18260003', '18393005',
        '18478005', '1855002', '18573003', '187921002', '18818009', '18941000', '191447007',
        '191449005', '191451009', '191452002', '191454001', '191455000', '191457008', '191458003',
        '191459006', '191461002', '191463004', '191464005', '191465006', '191466007', '191471000',
        '191478006', '191483003', '191484009', '191485005', '191486006', '191493005', '191494004',
        '191495003', '191496002', '191499009', '191519005', '191525009', '191526005', '191527001',
        '191530008', '191531007', '191538001', '191539009', '191542003', '191547009', '191548004',
        '191554003', '191555002', '191559008', '191561004', '191562006', '191563001', '191564007',
        '191565008', '191567000', '191569002', '191570001', '191571002', '191572009', '191574005',
        '191577003', '191583000', '191584006', '191586008', '191588009', '191590005', '191592002',
        '191593007', '191595000', '191597008', '191601008', '191602001', '191604000', '191606003',
        '191610000', '191611001', '191613003', '191615005', '191616006', '191618007', '191620005',
        '191621009', '191623007', '191625000', '191627008', '191629006', '191630001', '191632009',
        '191634005', '191636007', '191638008', '191639000', '191641004', '191643001', '191658009',
        '191659001', '191667009', '191668004', '191670008', '191672000', '191676002', '191677006',
        '191678001', '191680007', '191683009', '191689008', '191690004', '191692007', '191693002',
        '191713008', '191714002', '191722009', '191724005', '191725006', '191726007', '191736004',
        '191737008', '191738003', '191753006', '191765005', '191766006', '191772006', '191773001',
        '191774007', '191787001', '191928000', '191930003', '191931004', '191932006', '191952007',
        '191953002', '191962000', '191965003', '191972002', '191973007', '191980009', '191981008',
        '191990001', '192014006', '192016008', '192017004', '192029008', '192037000', '192038005',
        '192039002', '192041001', '192042008', '192044009', '192046006', '192049004', '192051000',
        '192052007', '192054008', '192056005', '192057001', '192058006', '192061007', '192063005',
        '192064004', '192065003', '192073007', '192079006', '192080009', '192082001', '192092009',
        '192097003', '192099000', '192100008', '192119003', '192122001', '192123006', '192127007',
        '192131001', '192132008', '192136006', '192147004', '192362008', '192527004', '192562009',
        '192575009', '192611004', '192630004', '192631000', '19300006', '19527009', '19694002',
        '1973000', '197480006', '19766004', '19922006', '20010003', '20250007', '20385005',
        '20960007', '21071000119101', '21586000', '21831000119109', '21897009', '21900002',
        '21921000119103', '22121000', '22230001', '22381000119105', '22407005', '22419002',
        '225040001', '22621000119103', '229025005', '229621000', '229622007', '229623002',
        '229625009', '229631007', '229632000', '229683000', '229697008', '229698003', '229699006',
        '229700007', '229701006', '229703009', '229704003', '229705002', '229706001', '229707005',
        '229708000', '229709008', '229712006', '229715008', '229721007', '229733002', '229734008',
        '229736005', '22981000119106', '230265002', '230266001', '230267005', '230268000',
        '230269008', '230280008', '230282000', '230283005', '230285003', '230286002', '230287006',
        '230288001', '230289009', '230334008', '230335009', '230336005', '230338006', '230438007',
        '230455006', '2312009', '231437006', '231438001', '231443008', '231444002', '231445001',
        '231446000', '231449007', '231450007', '231451006', '231452004', '231453009', '231454003',
        '231455002', '231456001', '231458000', '231459008', '23148009', '231485007', '231487004',
        '231489001', '231494001', '231495000', '231496004', '231499006', '231500002', '231504006',
        '231509001', '231515001', '231516000', '231517009', '231518004', '231520001', '231521002',
        '231522009', '231523004', '231524005', '231525006', '231526007', '231527003', '231528008',
        '231530005', '231536004', '231538003', '231540008', '231541007', '231542000', '233690008',
        '23560001', '23645006', '237349002', '237350002', '237351003', '237352005',
        '23741000119105', '23772009', '238961003', '238965007', '238966008', '238972008',
        '238973003', '238974009', '238975005', '238976006', '238977002', '238978007', '238979004',
        '24121004', '2421000119107', '24315006', '247803002', '247804008', '24781009', '248103001',
        '248118000', '249520001', '2506003', '251000119105', '25501002', '25766007', '25772007',
        '25922000', '25971005', '26025008', '261000119107', '2618002', '26203008', '26472000',
        '26516009', '26530004', '26665006', '26852004', '268612007', '268617001', '268619003',
        '268620009', '268621008', '268622001', '268624000', '268633003', '268634009', '268650001',
        '268658008', '268661009', '268662002', '268672004', '268673009', '268674003', '268715000',
        '268724009', '268727002', '268734000', '268738002', '26929004', '270291000119109',
        '27051000119102', '270901009', '270902002', '270903007', '270905000', '271000119101',
        '271428004', '271952001', '27387000', '274948002', '274952002', '274953007', '275271004',
        '27544004', '275473003', '275474009', '276296007', '276297003', '276300008', '27720003',
        '278506006', '278508007', '278852008', '278853003', '278857002', '278920007', '279225001',
        '279611005', '280032002', '280377008', '280378003', '280901000', '280943007', '280945000',
        '280949006', '280982009', '280983004', '280984005', '280986007', '281000119103', '281004',
        '2815001', '28357009', '28475009', '28663008', '28676002', '288271000119103',
        '288281000119100', '288511000119108', '28857002', '288631000119104', '28864000',
        '288751000119101', '28884001', '288851000119106', '288861000119108', '290791000119105',
        '291751000119105', '29599000', '29733004', '29929003', '30059008', '300706003', '30077003',
        '300960003', '300979000', '301643003', '302507002', '30336007', '30491001', '30509009',
        '30520009', '30605009', '30687003', '307417003', '307653008', '30935000', '31027006',
        '310495003', '310496002', '310497006', '31081000119101', '310814007', '3109008',
        '31177006', '31216003', '312214005', '31297008', '312991009', '313182004', '313224008',
        '31358003', '31373002', '31446002', '3158007', '31611000', '31658008', '31781004',
        '317816007', '318784009', '319768000', '320751009', '321717001', '32358001', '32388005',
        '32410009', '32552001', '32721004', '32875003', '32880007', '33078009', '33135002',
        '33323008', '33380008', '33449004', '33693007', '33736005', '34116005', '34315001',
        '34938008', '3503000', '35218008', '35252006', '35253001', '3530005', '35481005',
        '35489007', '35607004', '35722002', '357705009', '35827000', '35846004', '3586005',
        '35919005', '359661001', '36039004', '361275004', '361277007', '36158005', '36170009',
        '36217008', '36262007', '36474008', '36583000', '36622002', '367515004', '368361000119108',
        '36923009', '36943003', '370143000', '371024007', '371026009', '371596008', '371599001',
        '371600003', '371604007', '371631005', '37331004', '373618009', '37739004', '37746008',
        '37868008', '37872007', '37941009', '38295006', '38328002', '38368003', '38451003',
        '38547003', '386537007', '386572005', '386701004', '386810004', '386820009', '386821008',
        '386822001', '386823006', '386824000', '386825004', '38694004', '391099000', '39610001',
        '397795007', '397826007', '397923000', '39809009', '39951000119105', '402732001',
        '402733006', '402735004', '403590001', '403593004', '403595006', '40379007', '40425004',
        '40568001', '406506008', '408856003', '408857007', '408858002', '40926005', '40987004',
        '41021005', '41524005', '41526007', '41552001', '416340002', '416780008', '416975007',
        '41832009', '41836007', '41932008', '420614009', '421023003', '421529006', '424271007',
        '425390006', '425832009', '425914008', '42594001', '426174008', '426578000', '426881004',
        '427145007', '427469003', '427975003', '428051000124108', '42810003', '428351000124105',
        '42868002', '428687006', '429161000124103', '42925002', '429458009', '429571005',
        '429672007', '429998004', '430099007', '4306003', '430744005', '430751001',
        '430771000124100', '430852001', '430909002', '43150009', '432091002', '434451000124105',
        '434971000124109', '435321000124106', '435331000124109', '43568002', '436001000124105',
        '43614003', '43769008', '439960005', '44124003', '441704009', '441711008', '441719005',
        '441833000', '442057004', '442243005', '442245003', '442314000', '442344002', '443735008',
        '44376007', '443853005', '443919007', '4441000', '44433009', '444613000', '446175003',
        '446180007', '44966003', '450714000', '45479006', '45677003', '45924006', '45994004',
        '46023009', '46206005', '46229002', '46244001', '46432001', '46721000', '46762006',
        '472981000', '473452003', '473456000', '473457009', '47372000', '47447001', '47505003',
        '47916000', '48046002', '4817008', '48309007', '48500005', '48589009', '4863002',
        '48826008', '48937005', '4926007', '4932002', '49468007', '4949009', '49512000',
        '49564006', '4997005', '50026000', '50299009', '50705009', '50722006', '50878001',
        '50933003', '5095008', '50983008', '51133006', '51239001', '51493001', '5158005',
        '51637008', '51928006', '52448006', '52824009', '52910006', '52954000', '53049002',
        '53467004', '53607008', '53936005', '53956006', '54417002', '54502004', '54587008',
        '5464005', '54761006', '55009008', '5509004', '5510009', '55341008', '55516002',
        '55668003', '55728007', '55736003', '55967005', '56034001', '56095002', '56267009',
        '56573006', '56576003', '56627002', '5664002', '568005', '56882008', '5703000', '57194009',
        '57715001', '58214004', '58329000', '58349009', '58535001', '58647003', '58703003',
        '58855008', '59174009', '59216005', '59394009', '596004', '59617007', '59645001',
        '59651006', '59923000', '600009', '60099002', '60103007', '60123008', '60401000119104',
        '61157009', '61180001', '61212007', '61403008', '61569007', '61771000119106', '61831009',
        '61901004', '62211000119103', '62221000119105', '62231000119108', '62239001', '62351001',
        '62491004', '62792007', '63181006', '63204009', '63249007', '63393005', '63412003',
        '63649001', '63701002', '63778009', '63835008', '63909006', '63990000', '64060000',
        '64165008', '64731001', '6475002', '64905009', '65042007', '65064003', '65096006',
        '65384007', '65410009', '65438001', '66108005', '66307007', '66344007', '66347000',
        '66381006', '66631006', '66936004', '67002003', '67123006', '67195008', '67227000',
        '672481000119108', '672491000119106', '67711008', '68019004', '68569003', '68618008',
        '68890003', '68963006', '68995007', '69322001', '69361009', '69392006', '69479009',
        '69482004', '698624003', '698625002', '698626001', '698687007', '698689005', '698690001',
        '698692009', '698693004', '698695006', '698696007', '698697003', '698698008', '698699000',
        '698700004', '698701000', '698725008', '698726009', '698781002', '698946008', '698947004',
        '698948009', '698949001', '698951002', '698952009', '698954005', '698955006', '698957003',
        '699241002', '700213005', '70043001', '702356009', '702450004', '7025000', '702528003',
        '702732007', '702815001', '7031000119100', '705001007', '70546001', '70691001', '70747007',
        '70764005', '708037001', '70814008', '70922000', '70936005', '70967007', '710072005',
        '71103003', '712823008', '712824002', '712850003', '712884004', '71294008', '71336009',
        '713488003', '713844000', '715737004', '715924009', '716199000', '717223008', '71787009',
        '71802006', '718393002', '718636001', '719592004', '719593009', '719600006', '71961003',
        '719717006', '71984005', '720451004', '720452006', '720453001', '720454007', '720455008',
        '722287002', '722600006', '722877006', '722959000', '722960005', '722972004', '722973009',
        '722977005', '722978000', '722979008', '722980006', '723122006', '723123001', '723332005',
        '723390000', '72366004', '723899008', '723900003', '723901004', '723903001', '723905008',
        '723912004', '723913009', '723915002', '723917005', '723918000', '723919008', '723920002',
        '723928009', '723929001', '723930006', '723936000', '724544000', '724545004', '724564005',
        '724651001', '724654009', '724655005', '724673008', '724674002', '724675001', '724676000',
        '724677009', '724678004', '724679007', '724680005', '724681009', '724682002', '724683007',
        '724684001', '724689006', '724690002', '724691003', '724692005', '724693000', '724696008',
        '724702008', '724706006', '724707002', '724708007', '724718002', '724719005', '724720004',
        '724721000', '724722007', '724723002', '724729003', '724730008', '724733005', '724734004',
        '724735003', '724736002', '724737006', '724738001', '724739009', '724740006', '724741005',
        '724742003', '724743008', '724744002', '724745001', '724752004', '724755002', '724756001',
        '724757005', '724758000', '724759008', '724760003', '724776007', '724777003', '724818008',
        '724819000', '724992007', '725898002', '726772006', '72861004', '7291006', '733184002',
        '733185001', '733190003', '733191004', '733192006', '733193001', '733194007', '733623005',
        '73462009', '73471000', '73491007', '735541006', '735542004', '735543009', '735544003',
        '735545002', '735546001', '735547005', '735548000', '735549008', '735550008', '735551007',
        '735552000', '735553005', '735625001', '735626000', '735627009', '735628004', '735750005',
        '736313002', '736314008', '736315009', '736316005', '737225007', '737340007', '737341006',
        '73867007', '7397008', '74010007', '74142004', '74266001', '7461003', '74686005',
        '74732009', '74791000', '74850006', '75084000', '75122001', '75360000', '75752004',
        '75837004', '76105009', '76129002', '762317007', '762318002', '762319005', '762320004',
        '762321000', '762322007', '762325009', '762326005', '762327001', '762328006', '762329003',
        '762330008', '762331007', '762332000', '762335003', '762336002', '762337006', '762338001',
        '762339009', '762340006', '762341005', '762342003', '762343008', '762344002', '762345001',
        '762346000', '762347009', '762350007', '762351006', '76236006', '762461003', '762502009',
        '762507003', '762508008', '762509000', '762510005', '762511009', '762512002', '762513007',
        '762514001', '762515000', '762516004', '762522008', '762707000', '76441001', '76566000',
        '76812003', '76868007', '77332003', '77475008', '77486005', '7761000119106', '77675002',
        '77815007', '77911002', '7794004', '78004001', '78269000', '786120041000132108',
        '78640000', '78667006', '79204003', '79298009', '79341000119107', '79524000', '79584002',
        '79842004', '79866005', '80711002', '81319007', '81463002', '8185002', '81903006',
        '82218004', '82339009', '82361000119107', '82371000119101', '82381000119103', '82415003',
        '82494000', '82636008', '82738004', '82959004', '82998009', '83176005', '832007',
        '83225003', '83253003', '83458005', '83482000', '83501007', '83631006', '83746006',
        '83890006', '84002002', '84209002', '84466009', '84760002', '84788008', '84984002',
        '85061001', '85080004', '8511007', '8522006', '85248005', '85861002', '86058007',
        '87203005', '87414006', '87512008', '87798009', '87842000', '87950005', '87991007',
        '88740003', '88845000', '88902008', '88939009', '88975006', '88984006', '89248000',
        '89361000119103', '89381000119107', '89391000119105', '89415002', '89501000119108',
        '89618007', '89948007', '90099008', '90790003', '9083002', '9167000', '92501000119101',
        '9340000', '9345005', '93461009', '94631000119100', '94921000119107', '95636001',
        '95637005', '9674006', '97751000119108'
    }


class SubcutaneousRoute(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent the route by which a medication is administered, in this case a subcutaneous route.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Medication. The intent of this data element is to identify the route by which a medication is administered, in this case a subcutaneous route.
    Inclusion Criteria: Includes only relevant concepts associated with identifying a subcutaneous route for giving a medication. These are SNOMED CT codes.
    Exclusion Criteria: No exclusions.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.223'
    VALUE_SET_NAME = 'Subcutaneous route'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {'34206005'}


class DietaryIntakeOtherThanBreastMilk(ValueSet):
    """

    Clinical Focus: This value set contains concepts that represent dietary intake other than breast milk.
    Data Element Scope: This value set may use the Quality Data Model (QDM) category related to Substance. The intent of this data element is to identify dietary intake other than breast milk.
    Inclusion Criteria: Includes only relevant SNOMED CT concepts associated that identify dietary intake other than breast milk.
    Exclusion Criteria: Excludes codes that represent breast milk.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.27'
    VALUE_SET_NAME = 'Dietary Intake Other than Breast Milk'
    EXPANSION_VERSION = 'eCQM Update 2019-05-10'

    SNOMEDCT = {
        '11713004', '284458003', '284459006', '284461002', '346712003', '386127005', '412413001',
        '412414007', '443141000124102', '443151000124100', '443161000124103', '443171000124105',
        '443181000124108', '443191000124106', '443201000124109', '443211000124107',
        '443221000124104', '443231000124101', '443241000124106', '443251000124108',
        '443261000124105', '443271000124103', '443281000124100', '443291000124102',
        '443301000124101', '443311000124103', '443321000124106', '443331000124109',
        '443341000124104', '443511000124109', '443521000124101', '443531000124103',
        '443541000124108', '443551000124105', '444261000124107', '444281000124102',
        '444311000124100', '67079006'
    }


class CareServicesInLongTermResidentia