# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pick']

package_data = \
{'': ['*']}

extras_require = \
{':sys_platform == "win32"': ['windows-curses>=2.2.0,<3.0.0']}

setup_kwargs = {
    'name': 'pick',
    'version': '2.1.0',
    'description': 'Pick an option in the terminal with a simple GUI',
    'long_description': "# pick\n\n[![image](https://github.com/wong2/pick/actions/workflows/ci.yml/badge.svg)](https://github.com/wong2/pick/actions/workflows/ci.yml)\n[![PyPI](https://img.shields.io/pypi/v/pick.svg)](https://pypi.python.org/pypi/pick)\n[![PyPI](https://img.shields.io/pypi/dm/pick)](https://pypi.python.org/pypi/pick)\n\n**pick** is a small python library to help you create curses based\ninteractive selection list in the terminal.\n\n|         Basic          |         Multiselect          |\n| :--------------------: | :--------------------------: |\n| ![](example/basic.gif) | ![](example/multiselect.gif) |\n\n## Installation\n\n    $ pip install pick\n\n## Usage\n\n**pick** comes with a simple api:\n\n    >>> from pick import pick\n\n    >>> title = 'Please choose your favorite programming language: '\n    >>> options = ['Java', 'JavaScript', 'Python', 'PHP', 'C++', 'Erlang', 'Haskell']\n    >>> option, index = pick(options, title)\n    >>> print(option)\n    >>> print(index)\n\n**outputs**:\n\n    >>> C++\n    >>> 4\n\n**pick** multiselect example:\n\n    >>> from pick import pick\n\n    >>> title = 'Please choose your favorite programming language (press SPACE to mark, ENTER to continue): '\n    >>> options = ['Java', 'JavaScript', 'Python', 'PHP', 'C++', 'Erlang', 'Haskell']\n    >>> selected = pick(options, title, multiselect=True, min_selection_count=1)\n    >>> print(selected)\n\n**outputs**:\n\n    >>> [('Java', 0), ('C++', 4)]\n\n## Options\n\n- `options`: a list of options to choose from\n- `title`: (optional) a title above options list\n- `indicator`: (optional) custom the selection indicator, defaults to `*`\n- `default_index`: (optional) set this if the default selected option\n  is not the first one\n- `multiselect`: (optional), if set to True its possible to select\n  multiple items by hitting SPACE\n- `min_selection_count`: (optional) for multi select feature to\n  dictate a minimum of selected items before continuing\n\n## Community Projects\n\n[pickpack](https://github.com/anafvana/pickpack): A fork of `pick` to select tree data.\n",
    'author': 'wong2',
    'author_email': 'wonderfuly@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/wong2/pick',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
