# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from e_invoice_api import EInvoice, AsyncEInvoice
from e_invoice_api.types import DocumentResponse
from e_invoice_api.types.documents import UblGetResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestUbl:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_create_from_ubl(self, client: EInvoice) -> None:
        ubl = client.documents.ubl.create_from_ubl(
            file=b"raw file contents",
        )
        assert_matches_type(DocumentResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_create_from_ubl(self, client: EInvoice) -> None:
        response = client.documents.ubl.with_raw_response.create_from_ubl(
            file=b"raw file contents",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        ubl = response.parse()
        assert_matches_type(DocumentResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_create_from_ubl(self, client: EInvoice) -> None:
        with client.documents.ubl.with_streaming_response.create_from_ubl(
            file=b"raw file contents",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            ubl = response.parse()
            assert_matches_type(DocumentResponse, ubl, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_get(self, client: EInvoice) -> None:
        ubl = client.documents.ubl.get(
            "document_id",
        )
        assert_matches_type(UblGetResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_get(self, client: EInvoice) -> None:
        response = client.documents.ubl.with_raw_response.get(
            "document_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        ubl = response.parse()
        assert_matches_type(UblGetResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_get(self, client: EInvoice) -> None:
        with client.documents.ubl.with_streaming_response.get(
            "document_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            ubl = response.parse()
            assert_matches_type(UblGetResponse, ubl, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_get(self, client: EInvoice) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `document_id` but received ''"):
            client.documents.ubl.with_raw_response.get(
                "",
            )


class TestAsyncUbl:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_create_from_ubl(self, async_client: AsyncEInvoice) -> None:
        ubl = await async_client.documents.ubl.create_from_ubl(
            file=b"raw file contents",
        )
        assert_matches_type(DocumentResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_create_from_ubl(self, async_client: AsyncEInvoice) -> None:
        response = await async_client.documents.ubl.with_raw_response.create_from_ubl(
            file=b"raw file contents",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        ubl = await response.parse()
        assert_matches_type(DocumentResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_create_from_ubl(self, async_client: AsyncEInvoice) -> None:
        async with async_client.documents.ubl.with_streaming_response.create_from_ubl(
            file=b"raw file contents",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            ubl = await response.parse()
            assert_matches_type(DocumentResponse, ubl, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_get(self, async_client: AsyncEInvoice) -> None:
        ubl = await async_client.documents.ubl.get(
            "document_id",
        )
        assert_matches_type(UblGetResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_get(self, async_client: AsyncEInvoice) -> None:
        response = await async_client.documents.ubl.with_raw_response.get(
            "document_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        ubl = await response.parse()
        assert_matches_type(UblGetResponse, ubl, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_get(self, async_client: AsyncEInvoice) -> None:
        async with async_client.documents.ubl.with_streaming_response.get(
            "document_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            ubl = await response.parse()
            assert_matches_type(UblGetResponse, ubl, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_get(self, async_client: AsyncEInvoice) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `document_id` but received ''"):
            await async_client.documents.ubl.with_raw_response.get(
                "",
            )
