#  Copyright (c) 2019 JD Williams
#
#  This file is part of Firefly, a Python SOA framework built by JD Williams. Firefly is free software; you can
#  redistribute it and/or modify it under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 3 of the License, or (at your option) any later version.
#
#  Firefly is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
#  Public License for more details. You should have received a copy of the GNU Lesser General Public
#  License along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#  You should have received a copy of the GNU General Public License along with Firefly. If not, see
#  <http://www.gnu.org/licenses/>.

"""gypsh output module

gypsh is a GYP shell.  It's not really a generator per se.  All it does is
fire up an interactive Python session with a few local variables set to the
variables passed to the generator.  Like gypd, it's intended as a debugging
aid, to facilitate the exploration of .gyp structures after being processed
by the input module.

The expected usage is "gyp -f gypsh -D OS=desired_os".
"""


import code
import sys


# All of this stuff about generator variables was lovingly ripped from gypd.py.
# That module has a much better description of what's going on and why.
_generator_identity_variables = [
  'EXECUTABLE_PREFIX',
  'EXECUTABLE_SUFFIX',
  'INTERMEDIATE_DIR',
  'PRODUCT_DIR',
  'RULE_INPUT_ROOT',
  'RULE_INPUT_DIRNAME',
  'RULE_INPUT_EXT',
  'RULE_INPUT_NAME',
  'RULE_INPUT_PATH',
  'SHARED_INTERMEDIATE_DIR',
]

generator_default_variables = {
}

for v in _generator_identity_variables:
  generator_default_variables[v] = '<(%s)' % v


def GenerateOutput(target_list, target_dicts, data, params):
  locals = {
        'target_list':  target_list,
        'target_dicts': target_dicts,
        'data':         data,
      }

  # Use a banner that looks like the stock Python one and like what
  # code.interact uses by default, but tack on something to indicate what
  # locals are available, and identify gypsh.
  banner='Python %s on %s\nlocals.keys() = %s\ngypsh' % \
         (sys.version, sys.platform, repr(sorted(locals.keys())))

  code.interact(banner, local=locals)
