/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.xml;

import java.util.BitSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

public final class XmlUtils {
    public static final BitSet ID_START;
    public static final BitSet ID;
    public static final BitSet WHITESPACE;
    public static final BitSet QUOTE;
    public static final BitSet GT;
    public static final BitSet RIGHT_SQ_BRACKET;
    public static final String XML_LANG = "xml:lang";
    public static final String XML_BASE = "xml:base";
    public static final String LANG = "lang";
    private static final String NC_NAME_START_CHAR = "A-Za-z_\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd";
    private static final String NC_NAME_CHAR = "-.0-9\u00b7\u0300-\u036f\u203f-\u2040";
    private static final Pattern XML_NAME_PATTERN;
    private static final String ID_START_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    private static final String ID_OTHER_STR = "-0123456789:";
    private static final String WHITESPACE_STR = " \t\r\n\f\u000b\u001c\u001d\u001e\u00a0\u2007\u202f";
    private static final BitSet ID_START_OR_GT;
    private static final BitSet ID_START_OR_EQUAL;
    private static final BitSet ID_OR_QUOTE_OR_APOS;
    private static final BitSet APOS;
    private static final BitSet LT;

    private XmlUtils() {
    }

    public static boolean isValidNCName(String value) {
        return XML_NAME_PATTERN.matcher(value).matches();
    }

    public static String serializeOpenTag(String nsUri, String qname, Map<String, String> nsMappings, Attributes attrs, boolean optimizeNs) {
        String result = "<" + qname;
        if (nsUri != null && nsUri.length() > 0) {
            int idx = Math.max(qname.indexOf(58), 0);
            nsMappings.put(qname.substring(0, idx), nsUri);
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            result = result + " " + attrs.getQName(i) + "=\"" + attrs.getValue(i) + "\"";
        }
        for (String key : nsMappings.keySet()) {
            if (optimizeNs && XmlUtils.isPrefixIgnorable(key, qname, attrs)) continue;
            if (key.isEmpty()) {
                String value = nsMappings.get(key);
                result = result + " xmlns=\"" + value + "\"";
                continue;
            }
            result = result + " xmlns:" + key + "=\"" + nsMappings.get(key) + "\"";
        }
        result = result + ">";
        return result;
    }

    private static boolean isPrefixIgnorable(String key, String qname, Attributes attrs) {
        boolean usagesFound = key.isEmpty() && qname.indexOf(58) == -1 || key.length() > 0 && qname.startsWith(key + ":");
        for (int i = 0; i < attrs.getLength(); ++i) {
            String aqn = attrs.getQName(i);
            if (aqn.startsWith("xml") || (!key.isEmpty() || aqn.indexOf(58) != -1) && (key.length() <= 0 || !aqn.startsWith(key + ":"))) continue;
            usagesFound = true;
            break;
        }
        return !usagesFound;
    }

    static {
        char c;
        int i;
        ID_START = new BitSet();
        ID = new BitSet();
        WHITESPACE = new BitSet();
        QUOTE = new BitSet();
        GT = new BitSet();
        RIGHT_SQ_BRACKET = new BitSet();
        XML_NAME_PATTERN = Pattern.compile("[A-Za-z_\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd][A-Za-z_\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd-.0-9\u00b7\u0300-\u036f\u203f-\u2040]*");
        ID_START_OR_GT = new BitSet();
        ID_START_OR_EQUAL = new BitSet();
        ID_OR_QUOTE_OR_APOS = new BitSet();
        APOS = new BitSet();
        LT = new BitSet();
        LT.set(60);
        GT.set(62);
        APOS.set(39);
        QUOTE.set(34);
        RIGHT_SQ_BRACKET.set(93);
        for (i = 0; i < ID_START_STR.length(); ++i) {
            c = ID_START_STR.charAt(i);
            ID_START.set(c);
            ID_START_OR_EQUAL.set(c);
            ID_START_OR_GT.set(c);
            ID.set(c);
            ID_OR_QUOTE_OR_APOS.set(c);
        }
        for (i = 0; i < ID_OTHER_STR.length(); ++i) {
            c = ID_OTHER_STR.charAt(i);
            ID.set(c);
            ID_OR_QUOTE_OR_APOS.set(c);
        }
        ID_START_OR_GT.set(62);
        ID_START_OR_EQUAL.set(61);
        ID_OR_QUOTE_OR_APOS.set(39);
        ID_OR_QUOTE_OR_APOS.set(34);
        for (i = 0; i < WHITESPACE_STR.length(); ++i) {
            c = WHITESPACE_STR.charAt(i);
            WHITESPACE.set(c);
        }
    }
}

