/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.utilities;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Interval;
import uk.ac.ox.krr.logmap2.io.LogOutput;

public class Utilities {
    public static final int LOGMAP = 0;
    public static final int LOGMAPMENDUM = 1;
    public static final int LOGMAPLITE = 2;
    public static final int LOGMAPINTERACTIVITY = 3;
    public static final int WEAK_LEVEL1 = 1;
    public static final int WEAK_LEVEL2 = 2;
    public static final int WEAK_LEVEL3 = 3;
    public static final int MAP = 0;
    public static final int ONTO1 = 1;
    public static final int ONTO2 = 2;
    public static final int L2R = 0;
    public static final int R2L = -1;
    public static final int EQ = -2;
    public static final int NoMap = -3;
    public static final int Flagged = -4;
    public static final int CLASSES = 0;
    public static final int DATAPROPERTIES = 1;
    public static final int OBJECTPROPERTIES = 2;
    public static final int INSTANCES = 3;
    public static final int UNKNOWN = 4;
    public static final String CLASSES_STR = "CLS";
    public static final String DATAPROPERTIES_STR = "DPROP";
    public static final String OBJECTPROPERTIES_STR = "OPROP";
    public static final String INSTANCES_STR = "INST";
    public static final int STRUCTURAL_REASONER = 0;
    public static final int HERMIT_REASONER = 1;
    public static final int CONDOR_INPUT = 2;
    public static final int FMA = 0;
    public static final int NCI = 1;
    public static final int SNOMED = 2;
    public static final int Chemo = 3;
    public static final int NCIAn = 4;
    public static final int Mouse = 5;
    public static final int ontoA = 6;
    public static final int ontoB = 7;
    public static final int FMA2NCI = 0;
    public static final int FMA2SNOMED = 1;
    public static final int SNOMED2NCI = 2;
    public static final int SNOMED2LUCADA = 3;
    public static final int OntoA2OntoB = 4;
    public static final int MOUSE2HUMAN = 5;
    public static final int NCIpeque2FMA = 6;
    public static final int NCI2FMApeque = 7;
    public static final int NCI2LUCADA = 8;
    public static final int FMA2LUCADA = 9;
    public static final int LIBRARY = 10;
    public static final int CONFERENCE = 11;
    public static final int INSTANCE = 12;
    public static final int MULTILINGUAL = 13;
    public static final int CONFLICT = 0;
    public static final int DANG_EQUIV = 1;
    public static final int DANG_SUB = 2;
    public static final int NOCONFLICT = 3;
    public static final int DISPARATE = 4;
    public static final int COMPATIBLE = 6;

    public static String getStringRepresentation4Dir(int dir) {
        if (dir == -2) {
            return "=";
        }
        if (dir == 0) {
            return "<";
        }
        return ">";
    }

    public static int getIntegerRepresentation4Dir(String dir) {
        if (dir.equals("=")) {
            return -2;
        }
        if (dir.equals("<")) {
            return 0;
        }
        return -1;
    }

    public static double getRoundValue(double value, int decimals) {
        double aux = Math.pow(10.0, decimals);
        return (double)Math.round(value * aux) / aux;
    }

    public static String serializeIntervals(List<Interval> listIntervals) {
        String intervalsStr = "";
        for (int i = 0; i < listIntervals.size() - 1; ++i) {
            intervalsStr = intervalsStr + listIntervals.get(i).serialize() + ",";
        }
        if (listIntervals.size() > 0) {
            intervalsStr = intervalsStr + listIntervals.get(listIntervals.size() - 1).serialize();
        }
        return intervalsStr;
    }

    public static String serializeIntervals(Set<Interval> setIntervals) {
        String intervalsStr = "";
        Iterator<Interval> it = setIntervals.iterator();
        if (it.hasNext()) {
            intervalsStr = intervalsStr + it.next().serialize();
        }
        while (it.hasNext()) {
            Interval i = it.next();
            intervalsStr = intervalsStr + "," + i.serialize();
        }
        return intervalsStr;
    }

    public static Set<Interval> deserializeIntervals(String intervalsStr) {
        HashSet<Interval> listIntervals = new HashSet<Interval>();
        String[] listIndexes = intervalsStr.split(",");
        for (int i = 0; i < listIndexes.length - 1; i += 2) {
            listIntervals.add(new Interval(Integer.valueOf(listIndexes[i]), Integer.valueOf(listIndexes[i + 1])));
        }
        return listIntervals;
    }

    public static String serializeListIntegers(List<Integer> list) {
        String liststr = "";
        if (list.size() > 0) {
            for (int i = 0; i < list.size() - 1; ++i) {
                liststr = liststr + list.get(i) + ",";
            }
            liststr = liststr + list.get(list.size() - 1);
        }
        return liststr;
    }

    public static String serializeSetIntegers(Set<Integer> set) {
        String setstr = "";
        Iterator<Integer> it = set.iterator();
        if (it.hasNext()) {
            setstr = setstr + it.next();
        }
        while (it.hasNext()) {
            int i = it.next();
            setstr = setstr + "," + i;
        }
        return setstr;
    }

    public static Set<Integer> deserializeListIntegers(String serializedlist) {
        HashSet<Integer> list_int = new HashSet<Integer>();
        if (serializedlist.indexOf(",") > 0) {
            String[] elements = serializedlist.split(",");
            for (int i = 0; i < elements.length; ++i) {
                list_int.add(Integer.valueOf(elements[i]));
            }
        } else {
            list_int.add(Integer.valueOf(serializedlist));
        }
        return list_int;
    }

    public static String serializeListStrings(List<String> list) {
        String liststr = "";
        if (list.size() > 0) {
            for (int i = 0; i < list.size() - 1; ++i) {
                liststr = liststr + list.get(i) + ",";
            }
            liststr = liststr + list.get(list.size() - 1);
        }
        return liststr;
    }

    public static Set<String> deserializeListStrings(String serializedlist) {
        HashSet<String> list_str = new HashSet<String>();
        if (serializedlist.indexOf(",") > 0) {
            String[] elements = serializedlist.split(",");
            for (int i = 0; i < elements.length; ++i) {
                list_str.add(elements[i]);
            }
        } else {
            list_str.add(serializedlist);
        }
        return list_str;
    }

    public static String deserializeListStrings2String(String serializedlist) {
        String str = "";
        if (serializedlist.indexOf(",") > 0) {
            String[] elements = serializedlist.split(",");
            for (int i = 0; i < elements.length; ++i) {
                str = str + elements[i];
            }
        } else {
            str = serializedlist;
        }
        return str;
    }

    public static String getEntityLabelFromURI_original(String uriStr) {
        if (uriStr.indexOf("#") >= 0) {
            return uriStr.split("#")[1];
        }
        return uriStr;
    }

    public static String getEntityLabelFromURI(String uriStr) {
        if (uriStr.indexOf("#") >= 0) {
            if (uriStr.split("#").length > 1) {
                int index = uriStr.indexOf("#");
                return uriStr.substring(index + 1);
            }
            LogOutput.print("Empty label: " + uriStr);
            return "empty" + Calendar.getInstance().getTimeInMillis();
        }
        int index = uriStr.lastIndexOf("/");
        if (index >= 0) {
            return uriStr.substring(index + 1);
        }
        LogOutput.print("Complete URI: " + uriStr);
        return uriStr;
    }

    public static String getNameSpaceFromURI_original(String uriStr) {
        if (uriStr.startsWith("http")) {
            if (uriStr.indexOf("#") >= 0) {
                return uriStr.split("#")[0];
            }
            return uriStr;
        }
        return "";
    }

    public static String getNameSpaceFromURI(String uriStr) {
        if (uriStr.startsWith("http")) {
            if (uriStr.indexOf("#") >= 0) {
                return uriStr.split("#")[0];
            }
            int index = uriStr.lastIndexOf("/");
            if (index >= 0) {
                return uriStr.substring(0, index + 1);
            }
            return uriStr;
        }
        return "";
    }

    public static String[] splitStringByCapitalLetter(String str) {
        str = Utilities.capitalPrepositions(str);
        String pattern = "(?<=[^\\p{Upper}])(?=\\p{Upper})|(?<=[\\p{Lower}])(?=\\d)";
        return str.split(pattern);
    }

    public static String capitalPrepositions(String str) {
        str = str.replaceAll("of(?=\\p{Upper})", "Of");
        str = str.replaceAll("with(?=\\p{Upper})", "With");
        str = str.replaceAll("for(?=\\p{Upper})", "For");
        str = str.replaceAll("and(?=\\p{Upper})", "And");
        str = str.replaceAll("by(?=\\p{Upper})", "By");
        str = str.replaceAll("to(?=\\p{Upper})", "To");
        str = str.replaceAll("on(?=\\p{Upper})", "On");
        str = str.replaceAll("in(?=\\p{Upper})", "In");
        return str;
    }

    public static void main(String[] args) {
        String[] words2;
        for (String w : words2 = Utilities.splitStringByCapitalLetter("SoyBean")) {
            System.out.println(w);
        }
    }
}

