/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.utilities;

public class Timer {
    double pastTime = 0.0;
    boolean active = false;
    long startTime;
    double timeout = -1.0;

    public Timer() {
        this.resume();
    }

    public void resume() {
        if (this.active) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.active = true;
    }

    public double duration() {
        double time = this.pastTime;
        if (this.active) {
            time += (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        }
        return time;
    }

    public double durationMilisecons() {
        double time = this.pastTime;
        if (this.active) {
            time += (double)(System.currentTimeMillis() - this.startTime);
        }
        return time;
    }

    public void pause() {
        if (!this.active) {
            return;
        }
        this.pastTime = this.duration();
        this.active = false;
    }

    public double reset() {
        double ret = this.duration();
        this.pastTime = 0.0;
        this.active = false;
        this.resume();
        return ret;
    }

    public boolean timeOut() {
        if (this.timeout < 0.0) {
            return false;
        }
        return this.duration() > this.timeout;
    }

    public void setTimeout(double timeout) {
        this.timeout = timeout;
    }
}

