/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.utilities;

public enum Relation {
    EQUIVALENCE("="),
    SUBSUMES(">"),
    SUBSUMED_BY("<"),
    UNKNOWN("?");

    private String label;

    private Relation(String l) {
        this.label = l;
    }

    public Relation reverse() {
        switch (this) {
            case EQUIVALENCE: {
                return EQUIVALENCE;
            }
            case SUBSUMES: {
                return SUBSUMED_BY;
            }
            case SUBSUMED_BY: {
                return SUBSUMES;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        return null;
    }

    public static Relation parse(String l) {
        for (Relation r : Relation.values()) {
            if (!l.equals(r.label)) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return this.label;
    }
}

