/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.repair;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.repair.RepairmentPlan;
import uk.ac.ox.krr.logmap2.repair.RepairmentPlanComparator;
import uk.ac.ox.krr.logmap2.repair.hornSAT.DowlingGallierHornSAT;
import uk.ac.ox.krr.logmap2.repair.hornSAT.HornClause;
import uk.ac.ox.krr.logmap2.repair.hornSAT.Link;
import uk.ac.ox.krr.logmap2.utilities.PrecomputeIndexCombination;

public class AnchorAssessment {
    private DowlingGallierHornSAT dgSat;
    private Set<HornClause> hornMappings2Remove;
    private Map<Integer, Set<Link>> ignoreLinks = new HashMap<Integer, Set<Link>>();
    private IndexManager index;
    private MappingManager mapping_extractor;
    private Set<Integer> unSATvisited;
    private Set<Integer> SATvisited;
    private Set<Integer> SAT;
    private Set<Integer> allUNSAT = new HashSet<Integer>();
    private Map<Integer, Boolean> unsatClasses2repaired;
    int hard_cases_still2solve = 0;
    private Map<Integer, Set<HornClause>> unsatClasses2conflictiveMappings;
    private Map<HornClause, Integer> mapping2NumOfConflicts;
    double averageConflictiveMappings = 0.0;
    int maxConflictiveMappings = 0;
    int minConflictiveMappings = 10000;
    double averageRepairMappings = 0.0;
    int maxRepairMappings = 0;
    int minRepairMappings = 10000;
    double averageSizeRepair = 0.0;
    int maxSizeRepair = 0;
    int minSizeRepair = 10000;
    private PrecomputeIndexCombination precomputeIndexCombination = new PrecomputeIndexCombination();
    boolean useProjection = false;
    boolean dealWithHardCases = false;
    boolean repairInstanceMappings = false;
    Set<Integer> allSubClasses = new HashSet<Integer>();

    public AnchorAssessment(IndexManager index, MappingManager mapping_extractor) {
        this.index = index;
        this.mapping_extractor = mapping_extractor;
        this.precomputeIndexCombination.preComputeIdentifierCombination();
    }

    private void initStructures() {
        this.allUNSAT.clear();
        this.unSATvisited = new HashSet<Integer>();
        this.SATvisited = new HashSet<Integer>();
        this.SAT = new HashSet<Integer>();
        this.unsatClasses2conflictiveMappings = new HashMap<Integer, Set<HornClause>>();
        this.hard_cases_still2solve = 0;
        this.hornMappings2Remove = new HashSet<HornClause>();
        this.unsatClasses2repaired = new HashMap<Integer, Boolean>();
        this.ignoreLinks = new HashMap<Integer, Set<Link>>();
    }

    private void setDowlingAndGallier(boolean useProjection, Map<Integer, Set<Integer>> mappings2repair) {
        this.setDowlingAndGallier(useProjection, mappings2repair, false);
    }

    private void setDowlingAndGallier(boolean useProjection, Map<Integer, Set<Integer>> mappings2repair, boolean addClassTypes) {
        HashSet<Integer> mapped_entities = new HashSet<Integer>();
        mapped_entities.addAll(this.mapping_extractor.getFixedMappings().keySet());
        mapped_entities.addAll(mappings2repair.keySet());
        if (useProjection) {
            this.index.setSmallProjection4MappedEntities(mapped_entities);
        }
        this.dgSat = new DowlingGallierHornSAT(this.index.getDirectSubClasses(useProjection), this.index.getEquivalentClasses(), this.index.getDirectDisjointClasses(), this.index.getGeneralHornAxiom(), addClassTypes, this.index.getDirectIndividualClassTypes(), this.mapping_extractor.getFixedMappings(), mappings2repair, this.hornMappings2Remove);
    }

    public void CountSatisfiabilityOfIntegration_DandG(Map<Integer, Set<Integer>> mappings2repair) {
        this.initStructures();
        if (this.mapping2NumOfConflicts == null) {
            this.mapping2NumOfConflicts = new HashMap<HornClause, Integer>();
        } else {
            this.mapping2NumOfConflicts.clear();
        }
        LogOutput.print("\n\nCOUNT SAT ALL ONTOLOGY");
        LogOutput.print("-------------------------");
        this.useProjection = false;
        this.dealWithHardCases = false;
        this.setDowlingAndGallier(this.useProjection, mappings2repair);
        this.CountSatisfiabilityOfIntegration_DandG(this.index.getRootIdentifiers());
        LogOutput.print("\tUNSATifiabilities found with Dowling and Gallier (approximation): " + this.unSATvisited.size());
        this.unSATvisited.clear();
        this.SATvisited.clear();
        for (HornClause mapping : this.mapping2NumOfConflicts.keySet()) {
            LogOutput.printAlways(mapping + ", conflict: " + this.mapping2NumOfConflicts.get(mapping));
        }
    }

    private void getSubclasses4Identifiers(Set<Integer> classes) {
        this.allSubClasses.addAll(classes);
        if (classes.size() < 1) {
            return;
        }
        HashSet<Integer> subClasses = new HashSet<Integer>();
        for (int ide : classes) {
            subClasses.addAll(this.index.getDirectSubClasses4Identifier(ide, false));
        }
        this.getSubclasses4Identifiers(subClasses);
    }

    private void CountSatisfiabilityOfIntegration_DandG(Set<Integer> classes) {
        for (int cls : classes) {
            if (this.unSATvisited.contains(cls) || this.SATvisited.contains(cls)) continue;
            boolean satisfiable = this.dgSat.isSatisfiable(cls);
            if (satisfiable) {
                this.SATvisited.add(cls);
                this.CountSatisfiabilityOfIntegration_DandG(this.index.getDirectSubClasses4Identifier(cls, this.useProjection));
                continue;
            }
            for (HornClause clause : this.dgSat.getMappingsInvolvedInError()) {
                if (this.mapping2NumOfConflicts.containsKey(clause)) {
                    int updatedVal = 1 + this.mapping2NumOfConflicts.get(clause);
                    this.mapping2NumOfConflicts.put(clause, updatedVal);
                    continue;
                }
                this.mapping2NumOfConflicts.put(clause, 1);
            }
            this.unSATvisited.add(cls);
            this.CountSatisfiabilityOfIntegration_DandG(this.index.getDirectSubClasses4Identifier(cls, this.useProjection));
        }
    }

    public void CheckSatisfiabilityOfIntegration_DandG(Map<Integer, Set<Integer>> mappings2repair) {
        long fin1;
        long init1;
        this.averageConflictiveMappings = 0.0;
        this.maxConflictiveMappings = 0;
        this.minConflictiveMappings = 10000;
        this.averageRepairMappings = 0.0;
        this.maxRepairMappings = 0;
        this.minRepairMappings = 10000;
        this.averageSizeRepair = 0.0;
        this.maxSizeRepair = 0;
        this.minSizeRepair = 10000;
        this.initStructures();
        long inittotal = Calendar.getInstance().getTimeInMillis();
        boolean useSmallProjection = true;
        if (useSmallProjection) {
            LogOutput.print("\n\nSMALL PROJECTION");
            LogOutput.print("-------------------------");
            init1 = Calendar.getInstance().getTimeInMillis();
            this.useProjection = true;
            this.dealWithHardCases = false;
            this.setDowlingAndGallier(this.useProjection, mappings2repair);
            this.CheckSatisfiabilityOfIntegration_DandG(this.index.getRootIdentifiers());
            this.SAT.addAll(this.SATvisited);
            LogOutput.print("UNSAT found: " + this.unSATvisited.size());
            this.unSATvisited.clear();
            this.SATvisited.clear();
            LogOutput.print("Remaining hard cases onto from small projection (1 Iter): " + this.hard_cases_still2solve);
            fin1 = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime ckecking satisfiability with D&G (Small projection, simple cases) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
            if (this.hard_cases_still2solve > 0) {
                LogOutput.print("Solving hard cases...");
                this.hard_cases_still2solve = 0;
                this.dealWithHardCases = true;
                init1 = Calendar.getInstance().getTimeInMillis();
                this.CheckSatisfiabilityOfIntegration_DandG(this.index.getRootIdentifiers());
                this.SAT.addAll(this.SATvisited);
                this.unSATvisited.clear();
                this.SATvisited.clear();
                LogOutput.print("Remaining hard cases onto from small projection (2 Iter): " + this.hard_cases_still2solve);
                fin1 = Calendar.getInstance().getTimeInMillis();
                LogOutput.print("\tTime ckecking satisfiability with D&G (Small projection, hard cases) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
            }
        }
        this.SAT.clear();
        LogOutput.print("\n\nALL ONTOLOGY");
        LogOutput.print("-------------------------");
        init1 = Calendar.getInstance().getTimeInMillis();
        this.useProjection = false;
        this.dealWithHardCases = false;
        this.setDowlingAndGallier(this.useProjection, mappings2repair);
        this.CheckSatisfiabilityOfIntegration_DandG(this.index.getRootIdentifiers());
        this.SAT.addAll(this.SATvisited);
        LogOutput.print("UNSAT found: " + this.unSATvisited.size());
        this.unSATvisited.clear();
        this.SATvisited.clear();
        LogOutput.print("Remaining hard cases all onto (1 Iter): " + this.hard_cases_still2solve);
        fin1 = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\tTime ckecking satisfiability with D&G (Big projection, simple cases) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
        if (this.hard_cases_still2solve > 0) {
            LogOutput.print("Solving hard cases...");
            this.hard_cases_still2solve = 0;
            this.dealWithHardCases = true;
            init1 = Calendar.getInstance().getTimeInMillis();
            this.CheckSatisfiabilityOfIntegration_DandG(this.index.getRootIdentifiers());
            this.SAT.addAll(this.SATvisited);
            this.unSATvisited.clear();
            this.SATvisited.clear();
            LogOutput.print("REMAINING HARD CASES for all onto (2 Iter): " + this.hard_cases_still2solve);
            fin1 = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("Time ckecking satisfiability with D&G (Big projection, hard cases) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
        }
        this.remove_weaken_ConflictiveMappings2(mappings2repair);
        LogOutput.print("\nAverage mappings per conflict: " + this.averageConflictiveMappings / (double)this.unsatClasses2conflictiveMappings.size());
        LogOutput.print("Max mappings per conflict: " + this.maxConflictiveMappings);
        LogOutput.print("Min mappings per conflict: " + this.minConflictiveMappings);
        LogOutput.print("Average size of repair: " + this.averageSizeRepair / (double)this.unsatClasses2conflictiveMappings.size());
        LogOutput.print("Max size of repair: " + this.maxSizeRepair);
        LogOutput.print("Min size of repair: " + this.minSizeRepair);
        LogOutput.print("Average mappings in repair: " + this.averageRepairMappings / (double)this.unsatClasses2conflictiveMappings.size());
        LogOutput.print("Max mappings per repair: " + this.maxRepairMappings);
        LogOutput.print("Min mappings per repair: " + this.minRepairMappings);
    }

    private void CheckSatisfiabilityOfIntegration_DandG(Set<Integer> classes) {
        for (int cls : classes) {
            boolean plan_was_found;
            if (this.unSATvisited.contains(cls) || this.SATvisited.contains(cls)) continue;
            boolean satisfiable = this.SAT.contains(cls) || this.unsatClasses2repaired.containsKey(cls) && this.unsatClasses2repaired.get(cls) != false ? true : this.dgSat.isSatisfiable(cls);
            if (satisfiable) {
                this.SATvisited.add(cls);
                this.CheckSatisfiabilityOfIntegration_DandG(this.index.getDirectSubClasses4Identifier(cls, this.useProjection));
                continue;
            }
            this.unSATvisited.add(cls);
            this.allUNSAT.add(cls);
            this.dgSat.setConflictiveMappingsAsInvolvedMappings();
            this.completeSetOfConflictiveMappings(cls, this.dgSat.getConflictiveMappings());
            this.unsatClasses2conflictiveMappings.put(cls, new HashSet<HornClause>(this.dgSat.getConflictiveMappings()));
            this.averageConflictiveMappings += (double)this.dgSat.getConflictiveMappings().size();
            if (this.dgSat.getConflictiveMappings().size() > this.maxConflictiveMappings) {
                this.maxConflictiveMappings = this.dgSat.getConflictiveMappings().size();
            }
            if (this.dgSat.getConflictiveMappings().size() < this.minConflictiveMappings) {
                this.minConflictiveMappings = this.dgSat.getConflictiveMappings().size();
            }
            if (plan_was_found = this.createRepairPlans(cls)) {
                this.CheckSatisfiabilityOfIntegration_DandG(this.index.getDirectSubClasses4Identifier(cls, this.useProjection));
                continue;
            }
            this.unsatClasses2conflictiveMappings.remove(cls);
        }
    }

    public void CheckSatisfiabilityOfIntegration_DandG_Individuals(Map<Integer, Set<Integer>> mappings2repair) {
        this.averageConflictiveMappings = 0.0;
        this.maxConflictiveMappings = 0;
        this.minConflictiveMappings = 10000;
        this.averageRepairMappings = 0.0;
        this.maxRepairMappings = 0;
        this.minRepairMappings = 10000;
        this.averageSizeRepair = 0.0;
        this.maxSizeRepair = 0;
        this.minSizeRepair = 10000;
        this.initStructures();
        long inittotal = Calendar.getInstance().getTimeInMillis();
        this.SAT.clear();
        LogOutput.print("\n\nALL ONTOLOGY");
        LogOutput.print("-------------------------");
        long init1 = Calendar.getInstance().getTimeInMillis();
        this.useProjection = false;
        this.dealWithHardCases = false;
        this.setDowlingAndGallier(this.useProjection, mappings2repair, true);
        this.CheckSatisfiabilityOfIntegration_DandG_Individuals(this.index.getIndividuaIdentifierSet());
        this.SAT.addAll(this.SATvisited);
        LogOutput.print("UNSAT found: " + this.unSATvisited.size());
        this.unSATvisited.clear();
        this.SATvisited.clear();
        LogOutput.print("Remaining hard cases all onto (1 Iter): " + this.hard_cases_still2solve);
        long fin1 = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\tTime ckecking satisfiability with D&G (Big projection, simple cases) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
        if (this.hard_cases_still2solve > 0) {
            LogOutput.print("Solving hard cases...");
            this.hard_cases_still2solve = 0;
            this.dealWithHardCases = true;
            init1 = Calendar.getInstance().getTimeInMillis();
            this.CheckSatisfiabilityOfIntegration_DandG(this.index.getIndividuaIdentifierSet());
            this.SAT.addAll(this.SATvisited);
            this.unSATvisited.clear();
            this.SATvisited.clear();
            LogOutput.print("REMAINING HARD CASES for all onto (2 Iter): " + this.hard_cases_still2solve);
            fin1 = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("Time ckecking satisfiability with D&G (Big projection, hard cases) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
        }
        this.removeConflictiveInstanceMappings(mappings2repair);
        LogOutput.print("\nAverage mappings per conflict: " + this.averageConflictiveMappings / (double)this.unsatClasses2conflictiveMappings.size());
        LogOutput.print("Max mappings per conflict: " + this.maxConflictiveMappings);
        LogOutput.print("Min mappings per conflict: " + this.minConflictiveMappings);
        LogOutput.print("Average size of repair: " + this.averageSizeRepair / (double)this.unsatClasses2conflictiveMappings.size());
        LogOutput.print("Max size of repair: " + this.maxSizeRepair);
        LogOutput.print("Min size of repair: " + this.minSizeRepair);
        LogOutput.print("Average mappings in repair: " + this.averageRepairMappings / (double)this.unsatClasses2conflictiveMappings.size());
        LogOutput.print("Max mappings per repair: " + this.maxRepairMappings);
        LogOutput.print("Min mappings per repair: " + this.minRepairMappings);
    }

    private void CheckSatisfiabilityOfIntegration_DandG_Individuals(Set<Integer> individuals) {
        for (int indiv : individuals) {
            boolean plan_was_found;
            if (this.unSATvisited.contains(indiv) || this.SATvisited.contains(indiv)) continue;
            boolean satisfiable = this.SAT.contains(indiv) || this.unsatClasses2repaired.containsKey(indiv) && this.unsatClasses2repaired.get(indiv) != false ? true : this.dgSat.isSatisfiable(indiv);
            if (satisfiable) {
                this.SATvisited.add(indiv);
                continue;
            }
            this.unSATvisited.add(indiv);
            this.allUNSAT.add(indiv);
            this.dgSat.setConflictiveMappingsAsInvolvedMappings();
            this.completeSetOfConflictiveMappings(indiv, this.dgSat.getConflictiveMappings());
            this.unsatClasses2conflictiveMappings.put(indiv, new HashSet<HornClause>(this.dgSat.getConflictiveMappings()));
            this.averageConflictiveMappings += (double)this.dgSat.getConflictiveMappings().size();
            if (this.dgSat.getConflictiveMappings().size() > this.maxConflictiveMappings) {
                this.maxConflictiveMappings = this.dgSat.getConflictiveMappings().size();
            }
            if (this.dgSat.getConflictiveMappings().size() < this.minConflictiveMappings) {
                this.minConflictiveMappings = this.dgSat.getConflictiveMappings().size();
            }
            if (plan_was_found = this.createRepairPlans(indiv)) continue;
            this.unsatClasses2conflictiveMappings.remove(indiv);
        }
    }

    public int getNumRepairedUnsatClasses() {
        return this.allUNSAT.size();
    }

    public void CheckSatisfiabilityOfConcreteClasses_DandG(Map<Integer, Set<Integer>> mappings2repair, Set<Integer> classes2check) throws Exception {
        LogOutput.print("SAT visited all: " + this.SAT.size());
        LogOutput.print("All UNSAT visited all: " + this.allUNSAT.size());
        LogOutput.print("New classes to check: " + classes2check.size());
        for (int ide : classes2check) {
            if (this.SAT.contains(ide)) {
                LogOutput.print("\t" + ide + " was visited.");
            }
            if (!this.allUNSAT.contains(ide)) continue;
            LogOutput.print("\t" + ide + " was unsat.");
        }
        this.initStructures();
        long inittotal = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\n\nALL ONTOLOGY");
        LogOutput.print("-------------------------");
        long init1 = Calendar.getInstance().getTimeInMillis();
        this.useProjection = false;
        this.dealWithHardCases = false;
        this.setDowlingAndGallier(this.useProjection, mappings2repair);
        this.CheckSatisfiabilityOfIntegration_DandG(classes2check);
        this.SAT.addAll(this.SATvisited);
        LogOutput.print("UNSAT found: " + this.unSATvisited.size());
        LogOutput.print("SAT found: " + this.SATvisited.size());
        this.unSATvisited.clear();
        this.SATvisited.clear();
        LogOutput.print("Remaining hard cases all onto: " + this.hard_cases_still2solve);
        long fin1 = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\tTime ckecking satisfiability with D&G (Small projection, simple cases) (s): " + (double)((float)((double)fin1 - (double)init1)) / 1000.0);
    }

    private void completeSetOfConflictiveMappings(int entity, Set<HornClause> mappings2ignore) {
        try {
            this.ignoreLinks.clear();
            for (HornClause clause : mappings2ignore) {
                if (clause.getDirImplication() == 0) {
                    this.addParticularIgnoreLink(clause.getLeftHS1(), clause.getLabel(), clause.getRightHS());
                    continue;
                }
                this.addParticularIgnoreLink(clause.getRightHS(), clause.getLabel(), clause.getLeftHS1());
            }
            if (!this.dgSat.isSatisfiable(entity, this.ignoreLinks)) {
                LogOutput.print("Case with more erroneous mappings! " + entity + "  " + this.dgSat.getConflictiveMappings().size());
                this.dgSat.incrementConflictiveMappingsWithNewInvolvedMappings();
                LogOutput.print("\t" + this.dgSat.getConflictiveMappings().size());
                if (this.dgSat.getConflictiveMappings().size() != mappings2ignore.size() && this.dgSat.getConflictiveMappings().size() > 0) {
                    this.completeSetOfConflictiveMappings(entity, this.dgSat.getConflictiveMappings());
                } else {
                    LogOutput.print("No mappings detected in inconsistency. The ontology was probably inconsistent before alignment.");
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }

    private void addParticularIgnoreLink(int origin, int label, int target) {
        if (!this.ignoreLinks.containsKey(origin)) {
            this.ignoreLinks.put(origin, new HashSet());
        }
        this.ignoreLinks.get(origin).add(new Link(label, target));
    }

    private boolean createRepairPlans(int entity) {
        this.ignoreLinks.clear();
        this.unsatClasses2repaired.put(entity, false);
        RepairmentPlan selectedPlan = null;
        boolean no_exit = true;
        int size_plan = 1;
        Vector<HornClause> conflictiveMappings = new Vector<HornClause>(this.dgSat.getConflictiveMappings());
        while (selectedPlan == null && no_exit) {
            Set<Set<Integer>> mappingCombinations = conflictiveMappings.size() <= size_plan ? this.precomputeIndexCombination.getMaxCombination(conflictiveMappings.size()) : this.precomputeIndexCombination.getIdentifierCombination(conflictiveMappings.size(), size_plan);
            Queue<RepairmentPlan> plans = this.orderPlans(mappingCombinations, conflictiveMappings);
            LogOutput.print("PLANS of size " + size_plan + " for entity " + entity + ": " + plans.size());
            while (!plans.isEmpty() && selectedPlan == null) {
                RepairmentPlan plan = plans.poll();
                LogOutput.printAlways("Evaluating plan of size: " + plan.getMappings().size() + ", conflict: " + plan.getconflictiveness() + ", confidence: " + plan.getConfidence());
                this.ignoreLinks.clear();
                for (HornClause mapping : plan.getMappings()) {
                    if (mapping.getDirImplication() == 0) {
                        this.addParticularIgnoreLink(mapping.getLeftHS1(), mapping.getLabel(), mapping.getRightHS());
                        continue;
                    }
                    this.addParticularIgnoreLink(mapping.getRightHS(), mapping.getLabel(), mapping.getLeftHS1());
                }
                if (!this.dgSat.isSatisfiable(entity, this.ignoreLinks)) continue;
                selectedPlan = plan;
                LogOutput.printAlways("Plan found!");
            }
            if (selectedPlan != null) {
                this.unsatClasses2repaired.put(entity, true);
                this.hornMappings2Remove.addAll(selectedPlan.getMappings());
                for (HornClause clausemap : selectedPlan.getMappings()) {
                    this.dgSat.addGeneralLink2Ignore(clausemap.getLeftHS1(), clausemap.getLabel(), clausemap.getRightHS());
                    this.dgSat.addGeneralLink2Ignore(clausemap.getRightHS(), clausemap.getLabel(), clausemap.getLeftHS1());
                }
                continue;
            }
            no_exit = this.continueWithNextPlan(entity, size_plan);
            if (!no_exit) continue;
            if (this.dealWithHardCases) {
                size_plan = conflictiveMappings.size();
                continue;
            }
            ++size_plan;
        }
        if (selectedPlan != null) {
            this.averageRepairMappings += (double)selectedPlan.getMappings().size();
            if (selectedPlan.getMappings().size() > this.maxRepairMappings) {
                this.maxRepairMappings = selectedPlan.getMappings().size();
            }
            if (selectedPlan.getMappings().size() < this.minRepairMappings) {
                this.minRepairMappings = selectedPlan.getMappings().size();
            }
            this.averageSizeRepair += (double)size_plan;
            if (size_plan > this.maxSizeRepair) {
                this.maxSizeRepair = size_plan;
            }
            if (size_plan < this.minSizeRepair) {
                this.minSizeRepair = size_plan;
            }
            return true;
        }
        return false;
    }

    private boolean continueWithNextPlan(int entity, int size_plan) {
        if (size_plan >= this.dgSat.getConflictiveMappings().size()) {
            LogOutput.print("NO PLAN!!!  " + entity + "  " + this.dgSat.getConflictiveMappings().size() + "  " + size_plan);
            this.unsatClasses2repaired.remove(entity);
            if (this.dealWithHardCases) {
                ++this.hard_cases_still2solve;
            }
            return false;
        }
        if (!this.dealWithHardCases && (this.dgSat.getConflictiveMappings().size() > 40 && size_plan >= 1 || this.dgSat.getConflictiveMappings().size() > 30 && size_plan >= 2 || this.dgSat.getConflictiveMappings().size() > 20 && size_plan >= 3 || this.dgSat.getConflictiveMappings().size() > 15 && size_plan >= 4)) {
            LogOutput.print("HARD CASE!!!" + entity + "  " + this.dgSat.getConflictiveMappings().size() + "  " + size_plan);
            this.unsatClasses2repaired.remove(entity);
            ++this.hard_cases_still2solve;
            return false;
        }
        if (this.dealWithHardCases && (this.dgSat.getConflictiveMappings().size() > 40 && size_plan >= 2 || this.dgSat.getConflictiveMappings().size() > 30 && size_plan >= 3 || this.dgSat.getConflictiveMappings().size() > 25 && size_plan >= 4 || this.dgSat.getConflictiveMappings().size() > 15 && size_plan >= 5)) {
            LogOutput.print("HARD CASE WITHOUT PLAN!!!" + entity + "  " + this.dgSat.getConflictiveMappings().size() + "  " + size_plan);
            ++this.hard_cases_still2solve;
            return true;
        }
        return true;
    }

    private double getConfidence4Clause(HornClause mapping_clause) {
        return this.mapping_extractor.getConfidence4Mapping(mapping_clause.getLeftHS1(), mapping_clause.getRightHS());
    }

    private double getConflictiness4Clause(HornClause mapping_clause) {
        if (this.mapping2NumOfConflicts != null && this.mapping2NumOfConflicts.containsKey(mapping_clause)) {
            return this.mapping2NumOfConflicts.get(mapping_clause).intValue();
        }
        LogOutput.printAlways("\t" + mapping_clause + " without conflictness");
        return 0.0;
    }

    private Queue<RepairmentPlan> orderPlans(Set<Set<Integer>> mappingCombinations, Vector<HornClause> conflictiveMappings) {
        PriorityQueue<RepairmentPlan> plans = new PriorityQueue<RepairmentPlan>(mappingCombinations.size(), new RepairmentPlanComparator());
        for (Set<Integer> combination : mappingCombinations) {
            HashSet<HornClause> mappings = new HashSet<HornClause>();
            double confidence = 0.0;
            int conflictiveness = 0;
            for (int mappingId : combination) {
                HornClause mapping = conflictiveMappings.get(mappingId);
                mappings.add(mapping);
                confidence += this.getConfidence4Clause(mapping);
                if (!Parameters.extractGlobal_D_G_Info) continue;
                conflictiveness = (int)((double)conflictiveness + this.getConflictiness4Clause(mapping));
            }
            plans.add(new RepairmentPlan(mappings, confidence, conflictiveness));
        }
        return plans;
    }

    private void remove_weaken_ConflictiveMappings2(Map<Integer, Set<Integer>> mappings2repair) {
        int weakened = 0;
        int discarded = 0;
        for (HornClause clause : this.hornMappings2Remove) {
            int target;
            int origin;
            if (clause.getDirImplication() == 0) {
                origin = clause.getLeftHS1();
                target = clause.getRightHS();
            } else {
                origin = clause.getRightHS();
                target = clause.getLeftHS1();
            }
            if (mappings2repair.containsKey(origin)) {
                mappings2repair.get(origin).remove(target);
                if (mappings2repair.get(origin).size() == 0) {
                    mappings2repair.remove(origin);
                }
            }
            this.mapping_extractor.addSubMapping2ConflictiveAnchors(origin, target, true);
            if (this.mapping_extractor.isMappingInConflictiveSet(target, origin) || !this.mapping_extractor.isMappingInAnchors(origin, target)) {
                --weakened;
                ++discarded;
                this.mapping_extractor.removeSubMappingFromWeakenedDandGMappings(origin, target);
                continue;
            }
            ++weakened;
            if (!mappings2repair.containsKey(target) || !mappings2repair.get(target).contains(origin)) continue;
            mappings2repair.get(target).remove(origin);
            if (mappings2repair.get(target).size() == 0) {
                mappings2repair.remove(target);
            }
            this.mapping_extractor.addSubMapping2WeakenedDandGAnchors(target, origin);
        }
        LogOutput.print("\nDISCARDED MAPPINGS: " + discarded + " - ");
        LogOutput.print("WEAKENED MAPPINGS: " + weakened + " - " + this.mapping_extractor.getWeakenedDandGMappings().size());
        LogOutput.print("Clauses 2 ignore: " + this.hornMappings2Remove.size());
    }

    private void removeConflictiveInstanceMappings(Map<Integer, Set<Integer>> mappings2repair) {
        for (HornClause clause : this.hornMappings2Remove) {
            int target;
            int origin;
            if (clause.getDirImplication() == 0) {
                origin = clause.getLeftHS1();
                target = clause.getRightHS();
            } else {
                origin = clause.getRightHS();
                target = clause.getLeftHS1();
            }
            if (mappings2repair.containsKey(origin)) {
                mappings2repair.get(origin).remove(target);
                if (mappings2repair.get(origin).size() == 0) {
                    mappings2repair.remove(origin);
                }
            }
            if (!mappings2repair.containsKey(target)) continue;
            mappings2repair.get(target).remove(origin);
            if (mappings2repair.get(target).size() != 0) continue;
            mappings2repair.remove(target);
        }
    }
}

