/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning.explanation;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.ExplanationGenerator;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.explanation.ExplanationProgressManager;

public class BlackBoxExplanationExtractor {
    BlackBoxExplanation bbexp;
    final ExplanationGenerator debugger;
    OWLDataFactory dataFactory = SynchronizedOWLManager.createOWLDataFactory();
    ExplanationProgressManager monitor;

    public BlackBoxExplanationExtractor(OWLOntology ontology, OWLReasonerFactory reasonerFactory, OWLReasoner reasoner, int maxExplanations) {
        this(ontology, reasonerFactory, reasoner, Collections.EMPTY_SET, maxExplanations);
    }

    public BlackBoxExplanationExtractor(OWLOntology ontology, OWLReasonerFactory reasonerFactory, OWLReasoner reasoner, Set<OWLAxiom> axioms2consider, int maxExplanations) {
        this.bbexp = new BlackBoxExplanation(ontology, reasonerFactory, reasoner);
        HSTExplanationGenerator hstGen = new HSTExplanationGenerator((TransactionAwareSingleExpGen)this.bbexp);
        this.monitor = new ExplanationProgressManager(axioms2consider, maxExplanations);
        hstGen.setProgressMonitor((ExplanationProgressMonitor)this.monitor);
        this.debugger = hstGen;
    }

    public void handleExplanations(OWLAxiom ax) {
        this.monitor.setClearMonitor();
        SatisfiabilityConverter satCon = new SatisfiabilityConverter(this.dataFactory);
        OWLClassExpression desc = satCon.convert(ax);
        this.debugger.getExplanations(desc);
    }

    public Set<Set<OWLAxiom>> getExplanations() {
        return this.monitor.getSetOfExplanantions();
    }

    public int getNumberExplanations() {
        return this.monitor.getNumberExplanations();
    }

    public int getNumberExplanationSearch() {
        return this.monitor.getNumberExplanationSearch();
    }

    public void setMaxExplanations(int maxExp) {
        this.monitor.setMaxExplanations(maxExp);
    }

    public void setMaxExplanationSearch(int maxSearch) {
        this.monitor.setMaxExplanationSearch(maxSearch);
    }

    public void setTimeOut(long miliseconds) {
        this.monitor.setMaxTimeOut(miliseconds);
    }

    public boolean isTimedOut() {
        return this.monitor.isCancelled();
    }
}

