/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerAccess;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerManager;

public class SatisfiabilityIntegration {
    private static int timeoutClassification = 300;
    private static int timeoutClassSatisfiabilityCheck = 10;
    private static int REASONER = ReasonerManager.HERMIT;
    private String rootPath = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/LogMap2_Mappings/";
    private String sufix = "_logmap2_Output/";
    private String module1str = "module1.owl";
    private String module2str = "module2.owl";
    private String mappingstr = "mappings.owl";
    private OWLDataFactory factory;
    private OWLOntologyManager managerOnto1;
    private OWLOntologyManager managerOnto2;
    private OWLOntologyManager managerMappings;
    private OWLOntologyManager managerMerged;
    private OWLOntology moduleonto1;
    private OWLOntology moduleonto2;
    private OWLOntology mergedOntology;
    private OWLOntology mappingsOntology;
    private String mappingsOntologyFile;
    private String moduleonto1file;
    private String moduleonto2file;
    private String pair_str;
    long init;
    long fin;
    ReasonerAccess reasonerAccess;
    int resultClassEval;
    final int SAT = 0;
    final int UNSAT = 1;
    final int UNKNOWN = 2;
    final int KNOWN = 3;
    OWLClass current_cls;
    private int unsat = 0;
    private boolean useTimeOut = true;
    private boolean checkSatisfiabilityIndividually;
    int sat_result = 0;
    int unknown = 0;
    int num_class = 0;

    public SatisfiabilityIntegration(Set<OWLAxiom> o1_ax, Set<OWLAxiom> o2_ax, Set<OWLAxiom> mappings_ax, boolean useTimeout, boolean useFactory) throws Exception {
        this(o1_ax, o2_ax, mappings_ax, false, useTimeout, useFactory);
    }

    public SatisfiabilityIntegration(Set<OWLAxiom> o1_ax, Set<OWLAxiom> o2_ax, Set<OWLAxiom> mappings_ax, boolean checkSatisfiabilityIndividually, boolean useTimeout, boolean useFactory) throws Exception {
        this.checkSatisfiabilityIndividually = checkSatisfiabilityIndividually;
        this.useTimeOut = useTimeout;
        this.init = Calendar.getInstance().getTimeInMillis();
        this.reasonerAccess = this.createMergedReasonerAccess(REASONER, o1_ax, o2_ax, mappings_ax, useFactory);
        this.checkSatisfiabilityIntegration();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.printAlways("Time extracting unsat classes (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
    }

    public SatisfiabilityIntegration(OWLOntology o1, OWLOntology o2, OWLOntology mappings, boolean useTimeout, boolean useFactory) throws Exception {
        this(o1, o2, mappings, false, useTimeout, useFactory);
    }

    public SatisfiabilityIntegration(OWLOntology o1, OWLOntology o2, OWLOntology mappings, boolean checkSatisfiabilityIndividually, boolean useTimeout, boolean useFactory) throws Exception {
        this.moduleonto1 = o1;
        this.moduleonto2 = o2;
        this.mappingsOntology = mappings;
        this.useTimeOut = useTimeout;
        this.checkSatisfiabilityIndividually = checkSatisfiabilityIndividually;
        this.reasonerAccess = this.createMergedReasonerAccess(REASONER, this.moduleonto1, this.moduleonto2, this.mappingsOntology, useFactory);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.checkSatisfiabilityIntegration();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.printAlways("Time extracting unsat classes (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
    }

    public SatisfiabilityIntegration(boolean timeOutClassification) throws Exception {
        this.useTimeOut = timeOutClassification;
        this.setNonFixedOntologies();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.loadOntologies();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.printAlways("Time loading ontologies (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.reasonerAccess = this.createMergedReasonerAccess(REASONER, this.moduleonto1, this.moduleonto2, this.mappingsOntology, true);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.checkSatisfiabilityIntegration();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.printAlways("Time extracting unsat classes (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
    }

    public static void setTimeoutClassification(int timeout_seconds) {
        timeoutClassification = timeout_seconds;
    }

    public static void setTimeoutClassSatisfiabilityCheck(int timeout_seconds) {
        timeoutClassSatisfiabilityCheck = timeout_seconds;
    }

    public static void setReasoner(int reasoner_id) {
        REASONER = reasoner_id;
    }

    public boolean hasUnsatClasses() {
        return this.unsat > 0;
    }

    public int getNumUnsatClasses() {
        return this.unsat;
    }

    private void createMergedOntology(OWLOntology O1, OWLOntology O2, OWLOntology M) throws Exception {
        HashSet axioms = new HashSet();
        axioms.addAll(O1.getAxioms());
        axioms.addAll(O2.getAxioms());
        axioms.addAll(M.getAxioms());
        this.managerMerged = OWLManager.createOWLOntologyManager();
        this.mergedOntology = this.managerMerged.createOntology(axioms, IRI.create((String)"http://krono.act.uji.es/mappings/Integration.owl"));
        LogOutput.printAlways("Number of classes integration: " + this.mergedOntology.getClassesInSignature().size());
    }

    private ReasonerAccess createMergedReasonerAccess(int reasoner_id, OWLOntology O1, OWLOntology O2, OWLOntology M, boolean useFactory) throws Exception {
        return ReasonerManager.getMergedOntologyReasoner(reasoner_id, O1, O2, M, useFactory);
    }

    private ReasonerAccess createMergedReasonerAccess(int reasoner_id, Set<OWLAxiom> O1, Set<OWLAxiom> O2, Set<OWLAxiom> M, boolean useFactory) throws Exception {
        return ReasonerManager.getMergedOntologyReasoner(reasoner_id, O1, O2, M, useFactory);
    }

    private void setNonFixedOntologies() {
        this.setSNOMED2NCI();
        this.mappingsOntologyFile = this.rootPath + this.pair_str + this.sufix + this.mappingstr;
        this.moduleonto1file = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_FMA_whole_ontology.owl";
        this.moduleonto2file = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/snomed20090131_replab.owl.zip";
        this.mappingsOntologyFile = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/OutputAlcomo/oaei2012_FMA2SNMD_repaired_UMLS_mappings_alcomo2.owl";
        String path = "/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/oaei_2013/";
        String irirootpath = "file:" + path;
        this.moduleonto1file = irirootpath + "oaei2013_SNOMED_extended_overlapping_fma_nci.owl";
        this.moduleonto2file = irirootpath + "oaei2013_NCI_whole_ontology.owl";
        this.mappingsOntologyFile = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/LogMap2_Mappings/SNOMED2NCI_logmap2_Output/logmap2_mappings.owl";
    }

    private void setOntologies() {
        this.setSNOMED2NCI();
        this.mappingsOntologyFile = this.rootPath + this.pair_str + this.sufix + this.mappingstr;
        this.moduleonto1file = this.rootPath + this.pair_str + this.sufix + this.module1str;
        this.moduleonto2file = this.rootPath + this.pair_str + this.sufix + this.module2str;
    }

    private void loadOntologies() throws Exception {
        this.managerOnto1 = OWLManager.createOWLOntologyManager();
        this.managerOnto2 = OWLManager.createOWLOntologyManager();
        this.managerMappings = OWLManager.createOWLOntologyManager();
        this.factory = this.managerOnto1.getOWLDataFactory();
        this.mappingsOntology = this.managerMappings.loadOntology(IRI.create((String)this.mappingsOntologyFile));
        this.moduleonto1 = this.managerOnto1.loadOntology(IRI.create((String)this.moduleonto1file));
        this.moduleonto2 = this.managerOnto2.loadOntology(IRI.create((String)this.moduleonto2file));
    }

    public void clear() {
        this.reasonerAccess.clearStructures();
    }

    private void evaluateClassSatisfiabilityTimeOut(OWLClass cls) {
        ++this.num_class;
        this.sat_result = this.reasonerAccess.isSatisfiable_withTimeout((OWLClassExpression)cls, timeoutClassSatisfiabilityCheck);
        if (this.num_class == 100 || this.num_class == 5000 || this.num_class == 10000 || this.num_class == 15000 || this.num_class == 25000 || this.num_class == 50000 || this.num_class == 100000 || this.num_class == 150000 || this.num_class == 200000 || this.num_class == 250000 || this.num_class == 300000 || this.num_class == 350000) {
            LogOutput.print("\t" + cls.getIRI().toString() + "-  Tested: " + this.num_class);
        }
        if (this.sat_result == 1) {
            ++this.unsat;
        } else if (this.sat_result == 2) {
            ++this.unknown;
            LogOutput.print("\t" + cls.getIRI().toString() + "-  UNKNOWN SAT. Test: " + this.num_class);
        }
    }

    private void evaluateClassSatisfiability(OWLClass cls) {
        ++this.num_class;
        if (!this.reasonerAccess.isSatisfiable(cls)) {
            ++this.unsat;
        }
    }

    private void checkSatisfiabilityIntegration() throws Exception {
        if (this.checkSatisfiabilityIndividually) {
            this.unknown = 0;
            this.num_class = 0;
            this.unsat = 0;
            if (this.useTimeOut) {
                LogOutput.printAlways("Checking satisfiability integration: ");
                for (OWLClass cls : this.reasonerAccess.getOntology().getClassesInSignature(true)) {
                    this.evaluateClassSatisfiabilityTimeOut(cls);
                }
                LogOutput.printAlways("\tUNSAT classes: " + this.unsat + " of " + this.num_class);
                LogOutput.printAlways("\tUNKNOWN classes: " + this.unknown + " of " + this.num_class);
            } else {
                for (OWLClass cls : this.moduleonto1.getClassesInSignature(true)) {
                    this.evaluateClassSatisfiability(cls);
                }
                for (OWLClass cls : this.moduleonto2.getClassesInSignature(true)) {
                    this.evaluateClassSatisfiability(cls);
                }
                LogOutput.printAlways("UNSAT classes: " + this.unsat + " of " + this.num_class);
            }
        } else {
            if (this.useTimeOut) {
                this.reasonerAccess.classifyOntology_withTimeout(timeoutClassification);
            } else {
                this.reasonerAccess.classifyOntology();
            }
            if (this.reasonerAccess.isOntologyClassified()) {
                this.unsat = this.reasonerAccess.getUnsatisfiableClasses().size();
                LogOutput.printAlways("UNSAT classes: " + this.unsat);
                if (this.unsat < 10) {
                    for (OWLClass cls : this.reasonerAccess.getUnsatisfiableClasses()) {
                        LogOutput.printAlways("\t" + cls.getIRI().toString());
                    }
                }
            } else {
                LogOutput.printAlways("Timeout or error classigying ontology.");
            }
        }
    }

    private void setFMA2NCI() {
        this.pair_str = "FMA2NCI";
    }

    private void setFMA2SNOMED() {
        this.pair_str = "FMA2SNOMED";
    }

    private void setSNOMED2NCI() {
        this.pair_str = "SNOMED2NCI";
    }

    private void setNCI2LUCADA() {
        this.pair_str = "NCI2LUCADA";
    }

    private void setSNOMED2LUCADA() {
        this.pair_str = "SNOMED2LUCADA";
    }

    public static void main(String[] args) {
        try {
            new SatisfiabilityIntegration(false);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

