/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.overlapping;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import uk.ac.manchester.syntactic_locality.OntologyModuleExtractor;
import uk.ac.ox.krr.logmap2.OntologyLoader;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.overlapping.OntologyProcessing4Overlapping;
import uk.ac.ox.krr.logmap2.overlapping.OverlappingExtractor;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.statistics.StatisticsTimeMappings;

public class LexicalOverlappingExtractor
extends OverlappingExtractor {
    long init;
    long fin;
    private String iri_str1;
    private String iri_str2;
    private OWLOntology onto1;
    private OWLOntology onto2;
    Set<OWLEntity> entities1 = new HashSet<OWLEntity>();
    Set<OWLEntity> entities2 = new HashSet<OWLEntity>();
    private long size_onto1;
    private long size_onto2;
    boolean full_overlapping;
    private LexicalUtilities lexicalUtilities;

    public LexicalOverlappingExtractor(LexicalUtilities lexicalUtilities, boolean full_overlapping) {
        this.lexicalUtilities = lexicalUtilities;
        this.full_overlapping = full_overlapping;
    }

    public LexicalOverlappingExtractor(LexicalUtilities lexicalUtilities) {
        this(lexicalUtilities, false);
    }

    public long getSizeClassesOnto1() {
        return this.size_onto1;
    }

    public long getSizeClassesOnto2() {
        return this.size_onto2;
    }

    @Override
    public void createOverlapping(String iri_str1, String iri_str2) throws OWLOntologyCreationException, Exception {
        this.iri_str1 = iri_str1;
        this.iri_str2 = iri_str2;
        this.createOverlapping(true);
    }

    @Override
    public void createOverlapping(OWLOntology onto1, OWLOntology onto2) throws OWLOntologyCreationException, Exception {
        this.onto1 = onto1;
        this.onto2 = onto2;
        this.createOverlapping(false);
    }

    private void createOverlapping(boolean fromIRIs) throws OWLOntologyCreationException, Exception {
        boolean is_overlapping_onto1 = true;
        boolean is_overlapping_onto2 = true;
        double loading_time = 0.0;
        double overlapping_time = 0.0;
        this.init = Calendar.getInstance().getTimeInMillis();
        OntologyLoader onto_loader1 = fromIRIs ? new OntologyLoader(this.iri_str1) : new OntologyLoader(this.onto1);
        this.size_onto1 = onto_loader1.getClassesInSignatureSize();
        if (onto_loader1.getSignatureSize() < Parameters.min_size_overlapping) {
            is_overlapping_onto1 = false;
        }
        loading_time = StatisticsTimeMappings.getRunningTime(this.init);
        StatisticsTimeMappings.addParsing_time(loading_time);
        LogOutput.print("\tTime loading ontology 1 (s): " + loading_time);
        LogOutput.print("\tOntology 1 Axioms (s): " + onto_loader1.getOWLOntology().getAxiomCount());
        this.init = Calendar.getInstance().getTimeInMillis();
        OntologyProcessing4Overlapping overlapping1 = new OntologyProcessing4Overlapping(onto_loader1.getOWLOntology(), this.lexicalUtilities, this.full_overlapping, false);
        overlapping1.processOntologyClassLabels();
        overlapping1.setInvertedFile4Overlapping();
        if (is_overlapping_onto1) {
            onto_loader1.createAxiomSet();
            onto_loader1.clearOntology();
            overlapping1.clearOntoloy();
        }
        overlapping_time = StatisticsTimeMappings.getRunningTime(this.init);
        StatisticsTimeMappings.addOverlapping_time(overlapping_time);
        LogOutput.print("\tTime processing ontology 1 (s): " + overlapping_time);
        this.init = Calendar.getInstance().getTimeInMillis();
        OntologyLoader onto_loader2 = fromIRIs ? new OntologyLoader(this.iri_str2) : new OntologyLoader(this.onto2);
        this.size_onto2 = onto_loader2.getClassesInSignatureSize();
        if (onto_loader2.getSignatureSize() < Parameters.min_size_overlapping) {
            is_overlapping_onto2 = false;
        }
        loading_time = StatisticsTimeMappings.getRunningTime(this.init);
        StatisticsTimeMappings.addParsing_time(loading_time);
        LogOutput.print("\tTime loading ontology 2 (s): " + loading_time);
        LogOutput.print("\tOntology 2 Axioms (s): " + onto_loader2.getOWLOntology().getAxiomCount());
        this.init = Calendar.getInstance().getTimeInMillis();
        OntologyProcessing4Overlapping overlapping2 = new OntologyProcessing4Overlapping(onto_loader2.getOWLOntology(), this.lexicalUtilities, this.full_overlapping, false);
        overlapping2.processOntologyClassLabels();
        overlapping2.setInvertedFile4Overlapping();
        if (is_overlapping_onto2) {
            onto_loader2.createAxiomSet();
            onto_loader2.clearOntology();
            overlapping2.clearOntoloy();
        }
        overlapping_time = StatisticsTimeMappings.getRunningTime(this.init);
        StatisticsTimeMappings.addOverlapping_time(overlapping_time);
        LogOutput.print("\tTime processing ontology 2 (s): " + overlapping_time);
        LogOutput.printAlways("LogMap 2 Total Loading Time (s): " + StatisticsTimeMappings.getParsing_time());
        this.init = Calendar.getInstance().getTimeInMillis();
        Set<Set<String>> if_weak_intersect = overlapping1.getWeakInvertedFile().keySet();
        if_weak_intersect.retainAll(overlapping2.getWeakInvertedFile().keySet());
        overlapping2.getWeakInvertedFile().keySet().retainAll(if_weak_intersect);
        LogOutput.print("\tSize IF intersected: " + if_weak_intersect.size());
        overlapping_time = StatisticsTimeMappings.getRunningTime(this.init);
        StatisticsTimeMappings.addOverlapping_time(overlapping_time);
        LogOutput.print("\tTime intersecting IF weak (s): " + overlapping_time);
        this.init = Calendar.getInstance().getTimeInMillis();
        for (Set<String> str_set : if_weak_intersect) {
            for (int ide1 : overlapping1.getWeakInvertedFile().get(str_set)) {
                this.entities1.add((OWLEntity)overlapping1.getClass4identifier(ide1));
            }
            for (int ide2 : overlapping2.getWeakInvertedFile().get(str_set)) {
                this.entities2.add((OWLEntity)overlapping2.getClass4identifier(ide2));
            }
        }
        LogOutput.print("\tSize entities 1: " + this.entities1.size());
        LogOutput.print("\tSize entities 2: " + this.entities2.size());
        overlapping1.clearStructures();
        overlapping2.clearStructures();
        overlapping_time = StatisticsTimeMappings.getRunningTime(this.init);
        StatisticsTimeMappings.addOverlapping_time(overlapping_time);
        LogOutput.print("\tTime extracting entities4modules (s): " + overlapping_time);
        this.init = Calendar.getInstance().getTimeInMillis();
        if (is_overlapping_onto1) {
            OntologyModuleExtractor module_extractor1 = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), onto_loader1.getAxiomSet(), true, false, true);
            this.module1 = module_extractor1.extractAsOntology(this.entities1, IRI.create((String)onto_loader1.getOntologyIRIStr()));
            module_extractor1.clearStrutures();
            onto_loader1.clearAxiomSet();
        } else {
            this.module1 = onto_loader1.getOWLOntology();
        }
        this.entities1.clear();
        if (is_overlapping_onto2) {
            OntologyModuleExtractor module_extractor2 = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), onto_loader2.getAxiomSet(), true, false, true);
            this.module2 = module_extractor2.extractAsOntology(this.entities2, IRI.create((String)onto_loader2.getOntologyIRIStr()));
            module_extractor2.clearStrutures();
            onto_loader2.clearAxiomSet();
        } else {
            this.module2 = onto_loader2.getOWLOntology();
        }
        this.entities2.clear();
        overlapping_time = StatisticsTimeMappings.getRunningTime(this.init);
        StatisticsTimeMappings.addOverlapping_time(overlapping_time);
        LogOutput.print("\tSize module 1: " + this.module1.getAxiomCount());
        LogOutput.print("\tSize module 2: " + this.module2.getAxiomCount());
        LogOutput.print("\tSize classes module 1: " + this.module1.getClassesInSignature().size() + "  " + onto_loader1.getClassesInSignatureSize());
        LogOutput.print("\tSize classes module 2: " + this.module2.getClassesInSignature().size() + "  " + onto_loader2.getClassesInSignatureSize());
        LogOutput.print("\tTime extracting modules (s): " + overlapping_time);
    }

    @Override
    public Set<OWLEntity> getBaseOverlappedEntities1() {
        return this.entities1;
    }

    @Override
    public Set<OWLEntity> getBaseOverlappedEntities2() {
        return this.entities2;
    }
}

