/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReader;

public class RDFAlignReader
extends MappingsReader {
    public static final String CELL = "Cell";
    private static final String ALIGNMENTENTITY1 = "alignmententity1";
    private static final String ALIGNMENTENTITY2 = "alignmententity2";
    private static final String ALIGNMENTRELATION = "alignmentrelation";
    private static final String ALIGNMENTMEASURE = "alignmentmeasure";

    public RDFAlignReader(URL url_rdf_alignment_file) throws Exception {
        this(url_rdf_alignment_file.openStream());
    }

    public RDFAlignReader(String rdf_alignment_file) throws Exception {
        this(new FileInputStream(new File(rdf_alignment_file)));
    }

    public RDFAlignReader(InputStream is) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(is);
        this.mappings.clear();
        String iri_str1 = "";
        String iri_str2 = "";
        String relation = "";
        double confidence = 0.0;
        while (reader.hasNext()) {
            if (reader.getEventType() == 1) {
                if (reader.hasName()) {
                    if (reader.getLocalName().equals(CELL)) {
                        iri_str1 = "";
                        iri_str2 = "";
                        relation = "";
                        confidence = 0.0;
                    } else if (reader.getLocalName().equals("entity1") || reader.getLocalName().equals(ALIGNMENTENTITY1)) {
                        if (reader.getAttributeCount() > 0) {
                            iri_str1 = reader.getAttributeValue(0);
                        }
                    } else if (reader.getLocalName().equals("entity2") || reader.getLocalName().equals(ALIGNMENTENTITY2)) {
                        if (reader.getAttributeCount() > 0) {
                            iri_str2 = reader.getAttributeValue(0);
                        }
                    } else if (reader.getLocalName().equals("relation") || reader.getLocalName().equals(ALIGNMENTRELATION)) {
                        relation = reader.getElementText();
                    } else if (reader.getLocalName().equals("measure") || reader.getLocalName().equals(ALIGNMENTMEASURE)) {
                        confidence = Double.valueOf(reader.getElementText());
                    }
                }
            } else if (reader.getEventType() == 2 && reader.hasName() && reader.getLocalName().equals(CELL)) {
                int dir_relation = relation.equals(">") ? -1 : (relation.equals("<") ? 0 : (relation.equals("?") ? -4 : -2));
                this.mappings.add(new MappingObjectStr(iri_str1, iri_str2, confidence, dir_relation));
            }
            reader.next();
        }
        LogOutput.print("Read RDF Align mapping objects: " + this.getMappingObjectsSize());
    }
}

