/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei.reader;

import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.OAEIRDFAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReader;

public class FlatAlignmentReader
extends MappingsReader {
    public FlatAlignmentReader(String text_alignment_file) throws Exception {
        ReadFile reader = new ReadFile(text_alignment_file);
        String line = reader.readLine();
        while (line != null) {
            try {
                if (line.startsWith("#") || line.indexOf("|") < 0 && line.indexOf(",") < 0 && line.indexOf("\t") < 0) {
                    line = reader.readLine();
                    continue;
                }
                String[] elements = line.indexOf("|") > 0 ? line.split("\\|") : (line.indexOf(",") > 0 ? line.split("\\,") : line.split("\\t"));
                if (elements.length == 2) {
                    this.mappings.add(new MappingObjectStr(elements[0], elements[1], 1.0, -2));
                } else {
                    int dir = elements[2].equals(">") ? -1 : (elements[2].equals("<") ? 0 : -2);
                    if (elements.length == 4) {
                        this.mappings.add(new MappingObjectStr(elements[0], elements[1], Double.valueOf(elements[3]), dir));
                    } else if (elements.length == 5) {
                        int type = elements[4].equals("CLS") ? 0 : (elements[4].equals("DPROP") ? 1 : (elements[4].equals("OPROP") ? 2 : (elements[4].equals("INST") ? 3 : 4)));
                        this.mappings.add(new MappingObjectStr(elements[0], elements[1], Double.valueOf(elements[3]), dir, type));
                    }
                }
                line = reader.readLine();
            }
            catch (Exception e) {
                System.err.println("Error reading TXT mappings file. Line: " + line + ".\n" + e.getMessage());
                line = reader.readLine();
            }
        }
        reader.closeBuffer();
        LogOutput.print("Read TXT mapping objects: " + this.getMappingObjectsSize());
    }

    public static void main(String[] args) {
        String mappings_path = "/home/ejimenez-ruiz/Documents/OAEI_2018/Tracks/KER-game-im/v2/";
        try {
            FlatAlignmentReader reader = new FlatAlignmentReader(mappings_path + "alignment.csv");
            OAEIRDFAlignmentFormat writer = new OAEIRDFAlignmentFormat(mappings_path + "alignment.rdf", "http://islab.di.unimi.it/content/gamesonto", "http://islab.di.unimi.it/content/gamesonto");
            for (MappingObjectStr mapping : reader.getMappingObjects()) {
                writer.addInstanceMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
            }
            writer.saveOutputFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

