/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.multilingual;

import com.google.api.GoogleAPI;
import com.google.api.GoogleAPIException;
import com.google.api.translate.Language;
import com.google.api.translate.Translate;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.multilingual.Translator;

public class GoogleBasedTranslator
extends Translator {
    public static final Map<String, Language> LanguageMap = new HashMap<String, Language>(){
        {
            for (Language lang : Language.values()) {
                if (lang.toString().length() != 2) continue;
                this.put(lang.toString(), lang);
            }
            this.put("zh", Language.CHINESE_SIMPLIFIED);
            this.put("cn", Language.CHINESE_SIMPLIFIED);
            this.put("cz", Language.CZECH);
        }
    };

    @Override
    public String getToolAPITranslation(String label, String originLang, String targetLang) throws Exception {
        return this.getGoogleTranslation(label, originLang, targetLang);
    }

    private String getGoogleTranslation(String text, String originLangStr, String targetLangStr) throws GoogleAPIException {
        if (text.equals("") || text.equals(" ")) {
            return "";
        }
        String translatedText = text;
        if (this.isInLocalDictionary(text)) {
            return this.getLocalTranslation(text);
        }
        if (Parameters.call_online_translator) {
            GoogleAPI.setHttpReferrer((String)"https://code.google.com/p/logmap-matcher/");
            GoogleAPI.setKey((String)"AIzaSyCOXm6fqYcqJtpFSrlMsgAy1VPkgNcrD2k");
            Language originLang = LanguageMap.get(originLangStr);
            Language targetLang = LanguageMap.get(targetLangStr);
            this.num_tranlated_characters += text.length();
            ++this.num_calls;
            LogOutput.printAlways("Translating: '" + text + "' from " + originLangStr + " to " + targetLangStr + " using Google API. Num chars translated so far: " + this.num_tranlated_characters);
            if (!Parameters.is_test_mode_multilingual) {
                try {
                    translatedText = Translate.DEFAULT.execute(text, originLang, targetLang);
                }
                catch (Exception e) {
                    LogOutput.printError("Error Translating: '" + text + "' from " + originLangStr + " to " + targetLangStr + " using Google API. " + e.getMessage());
                    e.printStackTrace();
                    return "";
                }
            } else {
                translatedText = text + "_" + this.num_tranlated_characters + "_g";
            }
            this.addTranslation2Map(text, translatedText);
        }
        return translatedText;
    }

    @Override
    public String getTranslatorName() {
        return "google";
    }

    public static void main(String[] args) {
        GoogleBasedTranslator translator = new GoogleBasedTranslator();
        System.out.println("'" + translator.getTranslation("MedicoCabecera", "es", "ar") + "'");
    }
}

