/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.mappings;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.interactive.objects.MappingObjectInteractivity;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.I_Sub;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;

public abstract class MappingManager {
    long init;
    long fin;
    protected IndexManager index;
    protected Map<Integer, Set<Integer>> GSMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> anchorMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> logmapMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> mappings2Review = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> candidateMappings2askLogMap1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> candidateMappings2askUser1N = new HashMap<Integer, Set<Integer>>();
    protected Set<MappingObjectInteractivity> listMappings2askUser1N = new HashSet<MappingObjectInteractivity>();
    protected Map<Integer, Set<Integer>> weakenedDandG_Mappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> discardedMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> hardDiscardedMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> interactiveProcessMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> conflictiveMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> conflictiveMappings1N_D_G = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> weakCandidateMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> allWeakMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Integer> dataPropertyMappings = new HashMap<Integer, Integer>();
    protected Map<Integer, Integer> objPropertyMappings = new HashMap<Integer, Integer>();
    protected Map<Integer, Double> dataPropertyMappings2confidence = new HashMap<Integer, Double>();
    protected Map<Integer, Double> objPropertyMappings2confidence = new HashMap<Integer, Double>();
    private Map<Integer, Map<Integer, Double>> anchor2scopeAll = new HashMap<Integer, Map<Integer, Double>>();
    private Map<Integer, Map<Integer, Double>> anchor2scopeAnchors = new HashMap<Integer, Map<Integer, Double>>();
    private Map<Integer, Map<Integer, Double>> anchor2isub = new HashMap<Integer, Map<Integer, Double>>();
    private Map<Integer, Map<Integer, Double>> anchor2isub_avg = new HashMap<Integer, Map<Integer, Double>>();
    private Map<Integer, Map<Integer, Double>> anchor2sim_weak = new HashMap<Integer, Map<Integer, Double>>();
    private Map<Integer, Set<Integer>> anchor2addedByUser = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> instanceMappings1N = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> instanceMappings1N_inverted = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Map<Integer, Double>> instanceMappings2isub = new HashMap<Integer, Map<Integer, Double>>();
    protected Map<Integer, Map<Integer, Double>> instanceMappings2compfactor = new HashMap<Integer, Map<Integer, Double>>();
    protected Map<Integer, Map<Integer, Double>> instanceMappings2scope = new HashMap<Integer, Map<Integer, Double>>();
    protected Map<Integer, Set<Integer>> instanceMappings1N_not_allowed_output = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Set<Integer>> instanceMappings1N_ambiguity = new HashMap<Integer, Set<Integer>>();
    protected Map<Integer, Map<Integer, Integer>> instanceMappings2outputtype = new HashMap<Integer, Map<Integer, Integer>>();
    protected Set<MappingObjectStr> discarded_candidates = new HashSet<MappingObjectStr>();
    protected Set<MappingObjectStr> mappings_candidates_Str = new HashSet<MappingObjectStr>();
    protected Set<MappingObjectStr> mappings_GS_Str = new HashSet<MappingObjectStr>();
    protected Map<String, Set<String>> category_mappings = new HashMap<String, Set<String>>();
    double weightIsub = 0.5;
    double weightIsub_avg = 0.0;
    double weightScope = 0.3;
    double weightScopeAnchors = 0.2;
    I_Sub isub = new I_Sub();
    private boolean areExactFixed = false;
    private boolean filterWithHeuristicsInteractivity = true;
    protected int goodAmb4 = 0;
    protected int badAmb4 = 0;
    protected int goodDangEquiv = 0;
    protected int badDangEquiv = 0;
    protected int goodAmbigExact = 0;
    protected int badAmbigExact = 0;
    protected int goodConfidence = 0;
    protected int badConfidence = 0;
    int num_discarded = 0;

    protected void isHardMappingInGS(int ide1, int ide2, int type) {
        if (this.isMappingInGoldStandard(ide1, ide2)) {
            switch (type) {
                case 0: {
                    ++this.goodAmb4;
                    break;
                }
                case 1: {
                    ++this.goodDangEquiv;
                    break;
                }
                case 2: {
                    ++this.goodAmbigExact;
                    break;
                }
                case 3: {
                    ++this.goodConfidence;
                }
            }
        } else {
            switch (type) {
                case 0: {
                    ++this.badAmb4;
                    break;
                }
                case 1: {
                    ++this.badDangEquiv;
                    break;
                }
                case 2: {
                    ++this.badAmbigExact;
                    break;
                }
                case 3: {
                    ++this.badConfidence;
                }
            }
        }
    }

    public void printHarDiscardedStatistics() {
        LogOutput.print("Good Amb 4: " + this.goodAmb4);
        LogOutput.print("Bad Amb 4: " + this.badAmb4);
        LogOutput.print("Good DangEqui: " + this.goodDangEquiv);
        LogOutput.print("Bad DangEqui: " + this.badDangEquiv);
        LogOutput.print("Good AmbigExact: " + this.goodAmbigExact);
        LogOutput.print("Bad AmbigExact: " + this.badAmbigExact);
        LogOutput.print("Good Confidence: " + this.goodConfidence);
        LogOutput.print("Bad Confidence: " + this.badConfidence);
    }

    public boolean isFilterWithHeuristicsSecondLevelMappings() {
        return this.filterWithHeuristicsInteractivity;
    }

    public void setFilterWithHeuristicsSecondLevelMappings(boolean filterWithHeuristicsInteractivity) {
        this.filterWithHeuristicsInteractivity = filterWithHeuristicsInteractivity;
    }

    public void intersectInvertedFiles() {
    }

    public abstract void processInputMappings(Set<MappingObjectStr> var1);

    public void assesWeakenedMappingsDandG2(boolean removeAfterwards, boolean add2Anchors) {
    }

    public void assessMappings2AskUser() {
    }

    public abstract void createAnchors();

    public abstract void createCandidates();

    public abstract void createDataPropertyAnchors();

    public abstract void createObjectPropertyAnchors();

    public abstract void createInstanceAnchors();

    public abstract void extractAllWeakMappings();

    public abstract void extractCandidatesSubsetFromWeakMappings();

    public int getEntityAmbiguity_LogMapMappings(int ide) {
        int amb = 0;
        if (this.getLogMapMappings().containsKey(ide)) {
            amb += this.getLogMapMappings().get(ide).size();
        }
        if (this.getToAskLogMapMappings().containsKey(ide)) {
            amb += this.getToAskLogMapMappings().get(ide).size();
        }
        return amb;
    }

    public int getEntityAmbiguity_UserMappings(int ide) {
        int amb = 0;
        if (this.getLogMapMappings().containsKey(ide)) {
            amb += this.getLogMapMappings().get(ide).size();
        }
        if (this.getToAskUserMappings().containsKey(ide)) {
            amb += this.getToAskUserMappings().get(ide).size();
        }
        return amb;
    }

    public boolean isEntityAlreadyMapped(int index) {
        return this.logmapMappings1N.containsKey(index);
    }

    public boolean isEntityInCandidates2AskUser(int index) {
        return this.candidateMappings2askUser1N.containsKey(index);
    }

    public boolean isEntityInCandidates2AskLogMap(int index) {
        return this.candidateMappings2askLogMap1N.containsKey(index);
    }

    public int getTargetEntity4Index(int index) {
        Iterator<Integer> iterator;
        if (this.logmapMappings1N.containsKey(index) && (iterator = this.logmapMappings1N.get(index).iterator()).hasNext()) {
            int ide2 = iterator.next();
            return ide2;
        }
        return -1;
    }

    public Set<Integer> getTargetEntities4Index(int index) {
        if (this.logmapMappings1N.containsKey(index)) {
            return this.logmapMappings1N.get(index);
        }
        return Collections.emptySet();
    }

    public void removeSubMappingFromStructure(int ide1, int ide2) {
        if (this.logmapMappings1N.containsKey(ide1)) {
            this.logmapMappings1N.get(ide1).remove(ide2);
            if (this.logmapMappings1N.get(ide1).size() == 0) {
                this.logmapMappings1N.remove(ide1);
            }
        }
    }

    public void removeSubMappingFromMappings2Review(int ide1, int ide2) {
        if (this.mappings2Review.containsKey(ide1)) {
            this.mappings2Review.get(ide1).remove(ide2);
            if (this.mappings2Review.get(ide1).size() == 0) {
                this.mappings2Review.remove(ide1);
            }
        }
    }

    public void removeSubMappingFromConflictive_D_G(int ide1, int ide2) {
        if (this.conflictiveMappings1N_D_G.containsKey(ide1)) {
            this.conflictiveMappings1N_D_G.get(ide1).remove(ide2);
            if (this.conflictiveMappings1N_D_G.get(ide1).size() == 0) {
                this.conflictiveMappings1N_D_G.remove(ide1);
            }
        }
    }

    public void removeSubMappingFromWeakenedDandGMappings(int ide1, int ide2) {
        if (this.weakenedDandG_Mappings1N.containsKey(ide1)) {
            this.weakenedDandG_Mappings1N.get(ide1).remove(ide2);
            if (this.weakenedDandG_Mappings1N.get(ide1).size() == 0) {
                this.weakenedDandG_Mappings1N.remove(ide1);
            }
        }
    }

    public void removeSubMappingFromDiscarded(int ide1, int ide2) {
        if (this.discardedMappings1N.containsKey(ide1)) {
            this.discardedMappings1N.get(ide1).remove(ide2);
            if (this.discardedMappings1N.get(ide1).size() == 0) {
                this.discardedMappings1N.remove(ide1);
            }
        }
    }

    protected void removeAmbiguousFullMappingFromStructure(int ide1, int ide2, double min_average_isub) {
        this.removeSubMappingFromStructure(ide1, ide2);
        this.removeSubMappingFromStructure(ide2, ide1);
        if (this.extractISUBAverage4Mapping(ide1, ide2) < min_average_isub) {
            this.addEquivMapping2DiscardedAnchors(ide1, ide2);
        } else {
            this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
        }
    }

    protected void moveMapping2ReviewList(int ide1, int ide2) {
        this.removeSubMappingFromStructure(ide1, ide2);
        this.removeSubMappingFromStructure(ide2, ide1);
        this.addSubMapping2Mappings2Review(ide1, ide2);
    }

    public void saveAnchors() {
        this.anchorMappings1N.putAll(this.logmapMappings1N);
    }

    public void setExactAsFixed(boolean set) {
        this.areExactFixed = set;
    }

    public Map<Integer, Set<Integer>> getFixedMappings() {
        if (this.areExactFixed) {
            return this.logmapMappings1N;
        }
        return Collections.EMPTY_MAP;
    }

    public Map<Integer, Set<Integer>> getAnchors() {
        return this.anchorMappings1N;
    }

    public Map<Integer, Set<Integer>> getLogMapMappings() {
        return this.logmapMappings1N;
    }

    public int getDirMapping(int ide1, int ide2) {
        if (this.isId1SmallerThanId2(ide1, ide2)) {
            if (this.isMappingAlreadyInList(ide2, ide1)) {
                return -2;
            }
            return 0;
        }
        if (this.isMappingAlreadyInList(ide2, ide1)) {
            return -3;
        }
        return -1;
    }

    public Map<Integer, Set<Integer>> getMappings2Review() {
        return this.mappings2Review;
    }

    public Map<Integer, Set<Integer>> getToAskUserMappings() {
        return this.candidateMappings2askUser1N;
    }

    public Set<MappingObjectInteractivity> getListOfMappingsToAskUser() {
        return this.listMappings2askUser1N;
    }

    public void addMappingObject2AskUserList(int index1, int index2) {
        this.listMappings2askUser1N.add(new MappingObjectInteractivity(index1, index2, -2, this.extractScopeAll4Mapping(index1, index2), this.extractISUB4Mapping(index1, index2)));
    }

    public void addMappingObject2AskUserList(int index1, int index2, int diMapping) {
        this.listMappings2askUser1N.add(new MappingObjectInteractivity(index1, index2, diMapping, this.extractScopeAll4Mapping(index1, index2), this.extractISUB4Mapping(index1, index2)));
    }

    public Map<Integer, Set<Integer>> getToAskLogMapMappings() {
        return this.candidateMappings2askLogMap1N;
    }

    public Map<Integer, Set<Integer>> getWeakAnchors() {
        return this.allWeakMappings1N;
    }

    public Map<Integer, Set<Integer>> getWeakCandidateAnchors() {
        return this.weakCandidateMappings1N;
    }

    public void clearWeakCandidateAnchors() {
        this.weakCandidateMappings1N.clear();
    }

    public Map<Integer, Integer> getDataPropertyAnchors() {
        return this.dataPropertyMappings;
    }

    public Map<Integer, Integer> getObjectPropertyAnchors() {
        return this.objPropertyMappings;
    }

    public Map<Integer, Set<Integer>> getInstanceMappings() {
        return this.instanceMappings1N;
    }

    public Map<Integer, Map<Integer, Integer>> getInstanceMappings4OutputType() {
        return this.instanceMappings2outputtype;
    }

    public void addDataPropertyAnchor(int ide1, int ide2) {
        this.dataPropertyMappings.put(ide1, ide2);
    }

    public void addObjectPropertyAnchor(int ide1, int ide2) {
        this.objPropertyMappings.put(ide1, ide2);
    }

    public void addDataPropertyAnchorConfidence(int ide1, double conf) {
        this.dataPropertyMappings2confidence.put(ide1, conf);
    }

    public void addObjectPropertyAnchorConfidence(int ide1, double conf) {
        this.objPropertyMappings2confidence.put(ide1, conf);
    }

    public void addInstanceAnchorConfidence(int ide1, int ide2, double conf) {
        this.addIsub4Indivual(ide1, ide2, conf);
        this.addIsub4Indivual(ide2, ide1, conf);
    }

    public Map<Integer, Set<Integer>> getInstanceMappings_inverted() {
        return this.instanceMappings1N_inverted;
    }

    public int getSizeOfInstanceMappings() {
        int num = 0;
        for (int ide1 : this.instanceMappings1N.keySet()) {
            num += this.instanceMappings1N.get(ide1).size();
        }
        return num;
    }

    public boolean isIndividualAlreadyMapped(int ide) {
        return this.instanceMappings1N.containsKey(ide) || this.instanceMappings1N_inverted.containsKey(ide) || this.instanceMappings1N_not_allowed_output.containsKey(ide) || this.instanceMappings1N_ambiguity.containsKey(ide);
    }

    public double getConfidence4DataPropertyAnchor(int ident1, int ident2) {
        if (this.dataPropertyMappings2confidence.containsKey(ident1)) {
            return this.dataPropertyMappings2confidence.get(ident1);
        }
        return 0.8;
    }

    public double getConfidence4ObjectPropertyAnchor(int ident1, int ident2) {
        if (this.objPropertyMappings2confidence.containsKey(ident1)) {
            return this.objPropertyMappings2confidence.get(ident1);
        }
        return 0.8;
    }

    public double getConfidence4InstanceMapping(int ident1, int ident2) {
        if (this.instanceMappings2isub.containsKey(ident1) && this.instanceMappings2isub.get(ident1).containsKey(ident2)) {
            return this.instanceMappings2isub.get(ident1).get(ident2);
        }
        return 0.7;
    }

    public double getISUB4InstanceMapping(int ident1, int ident2) {
        if (this.instanceMappings2isub.containsKey(ident1) && this.instanceMappings2isub.get(ident1).containsKey(ident2)) {
            return this.instanceMappings2isub.get(ident1).get(ident2);
        }
        return 0.7;
    }

    public double getCompFactor4InstanceMapping(int ident1, int ident2) {
        if (this.instanceMappings2compfactor.containsKey(ident1) && this.instanceMappings2compfactor.get(ident1).containsKey(ident2)) {
            return this.instanceMappings2compfactor.get(ident1).get(ident2);
        }
        return 0.5;
    }

    public double getScope4InstanceMapping(int ident1, int ident2) {
        if (this.instanceMappings2scope.containsKey(ident1) && this.instanceMappings2scope.get(ident1).containsKey(ident2)) {
            return this.instanceMappings2scope.get(ident1).get(ident2);
        }
        return 0.5;
    }

    public double getOutputType4InstanceMapping(int ident1, int ident2) {
        if (this.instanceMappings2outputtype.containsKey(ident1) && this.instanceMappings2outputtype.get(ident1).containsKey(ident2)) {
            return this.instanceMappings2outputtype.get(ident1).get(ident2).intValue();
        }
        return 0.0;
    }

    public Set<MappingObjectStr> getStringLogMapMappings() {
        return this.mappings_candidates_Str;
    }

    public Set<MappingObjectStr> getStringGoldStandardAnchors() {
        return this.mappings_GS_Str;
    }

    public Map<Integer, Set<Integer>> getDiscardedMappings() {
        return this.discardedMappings1N;
    }

    public Map<Integer, Set<Integer>> getHardDiscardedMappings() {
        return this.hardDiscardedMappings1N;
    }

    public Map<Integer, Set<Integer>> getMappingsInteractiveProcess() {
        return this.interactiveProcessMappings1N;
    }

    public Map<Integer, Set<Integer>> getConflictiveMappings() {
        return this.conflictiveMappings1N;
    }

    public Map<Integer, Set<Integer>> getWeakenedDandGMappings() {
        return this.weakenedDandG_Mappings1N;
    }

    public Set<MappingObjectStr> getDiscardedMappingsStr() {
        return this.discarded_candidates;
    }

    public void addSubMapping2ListOfAnchors(int index1, int index2) {
        if (!this.logmapMappings1N.containsKey(index1)) {
            this.logmapMappings1N.put(index1, new HashSet());
        }
        this.logmapMappings1N.get(index1).add(index2);
    }

    public void addInstanceMapping(int index1, int index2) {
        this.addInstanceMapping(index1, index2, false);
    }

    private boolean hasAllowedType(Set<Integer> types) {
        if (!Parameters.isRestrictInstanceTypesActive() || this.index.getAllowedInstanceTypes().isEmpty()) {
            return true;
        }
        for (int itype : types) {
            if (this.index.getAllowedInstanceTypes().contains(itype)) {
                return true;
            }
            for (int atype : this.index.getAllowedInstanceTypes()) {
                if (!this.index.isSubClassOf(itype, atype)) continue;
                return true;
            }
        }
        return false;
    }

    public void addInstanceMapping(int index1, int index2, boolean ambiguity) {
        if (!this.hasAllowedType(this.index.getIdentifier2IndividualIndexMap().get(index1).getClassTypes()) || !this.hasAllowedType(this.index.getIdentifier2IndividualIndexMap().get(index2).getClassTypes())) {
            if (!this.instanceMappings1N_not_allowed_output.containsKey(index1)) {
                this.instanceMappings1N_not_allowed_output.put(index1, new HashSet());
            }
            this.instanceMappings1N_not_allowed_output.get(index1).add(index2);
            return;
        }
        if (ambiguity) {
            if (!this.instanceMappings1N_ambiguity.containsKey(index1)) {
                this.instanceMappings1N_ambiguity.put(index1, new HashSet());
            }
            this.instanceMappings1N_ambiguity.get(index1).add(index2);
            return;
        }
        if (!this.instanceMappings1N.containsKey(index1)) {
            this.instanceMappings1N.put(index1, new HashSet());
        }
        this.instanceMappings1N.get(index1).add(index2);
        if (!this.instanceMappings1N_inverted.containsKey(index2)) {
            this.instanceMappings1N_inverted.put(index2, new HashSet());
        }
        this.instanceMappings1N_inverted.get(index2).add(index1);
    }

    public void removeInstanceMappings(int index1, int index2) {
        if (this.instanceMappings1N.containsKey(index1)) {
            this.instanceMappings1N.get(index1).remove(index2);
            if (this.instanceMappings1N.get(index1).size() == 0) {
                this.instanceMappings1N.remove(index1);
            }
        }
    }

    public void addSubMapping2Mappings2Review(int index1, int index2) {
        if (!this.mappings2Review.containsKey(index1)) {
            this.mappings2Review.put(index1, new HashSet());
        }
        this.mappings2Review.get(index1).add(index2);
    }

    public void moveMappingsToReview2AnchorList() {
        for (int ide1 : this.mappings2Review.keySet()) {
            for (int ide2 : this.mappings2Review.get(ide1)) {
                this.addSubMapping2ListOfAnchors(ide1, ide2);
            }
        }
    }

    public void addMapping2ListOfAnchors2AskLogMap(int index1, int index2) {
        if (!this.candidateMappings2askLogMap1N.containsKey(index1)) {
            this.candidateMappings2askLogMap1N.put(index1, new HashSet());
        }
        this.candidateMappings2askLogMap1N.get(index1).add(index2);
        if (!this.candidateMappings2askLogMap1N.containsKey(index2)) {
            this.candidateMappings2askLogMap1N.put(index2, new HashSet());
        }
        this.candidateMappings2askLogMap1N.get(index2).add(index1);
    }

    public void addEquivMapping2ListOfAnchors2AskUser(int index1, int index2) {
        if (!this.candidateMappings2askUser1N.containsKey(index1)) {
            this.candidateMappings2askUser1N.put(index1, new HashSet());
        }
        this.candidateMappings2askUser1N.get(index1).add(index2);
        if (!this.candidateMappings2askUser1N.containsKey(index2)) {
            this.candidateMappings2askUser1N.put(index2, new HashSet());
        }
        this.candidateMappings2askUser1N.get(index2).add(index1);
    }

    public void removeEquivMappingFromListOfAnchors2AskUser(int index1, int index2) {
        if (this.candidateMappings2askUser1N.containsKey(index1)) {
            this.candidateMappings2askUser1N.get(index1).remove(index2);
            if (this.candidateMappings2askUser1N.get(index1).size() == 0) {
                this.candidateMappings2askUser1N.remove(index1);
            }
        }
    }

    public void removeEquivMappingFromListOfAnchors2AskUser(int index1, int index2, boolean add2conflictive) {
        if (this.candidateMappings2askUser1N.containsKey(index1)) {
            this.candidateMappings2askUser1N.get(index1).remove(index2);
            if (this.candidateMappings2askUser1N.get(index1).size() == 0) {
                this.candidateMappings2askUser1N.remove(index1);
            }
        }
        if (add2conflictive) {
            this.addSubMapping2ConflictiveAnchors(index1, index2);
            this.addSubMapping2ConflictiveAnchors(index2, index1);
        } else {
            this.addEquivMapping2DiscardedAnchors(index1, index2);
            this.addEquivMapping2DiscardedAnchors(index2, index1);
        }
    }

    public void addEquivMapping2DiscardedAnchors(int index1, int index2) {
        if (!this.discardedMappings1N.containsKey(index1)) {
            this.discardedMappings1N.put(index1, new HashSet());
        }
        if (!this.discardedMappings1N.get(index1).contains(index2)) {
            ++this.num_discarded;
            this.discardedMappings1N.get(index1).add(index2);
        }
    }

    public int getNumDiscardedMappings() {
        return this.num_discarded;
    }

    public void addEquivMapping2HardDiscardedAnchors(int index1, int index2) {
        if (!this.hardDiscardedMappings1N.containsKey(index1)) {
            this.hardDiscardedMappings1N.put(index1, new HashSet());
        }
        this.hardDiscardedMappings1N.get(index1).add(index2);
    }

    public void addEquivMapping2InteractiveMappings(int index1, int index2) {
        if (!this.interactiveProcessMappings1N.containsKey(index1)) {
            this.interactiveProcessMappings1N.put(index1, new HashSet());
        }
        this.interactiveProcessMappings1N.get(index1).add(index2);
    }

    public void addSubMapping2ConflictiveAnchors(int index1, int index2) {
        this.addSubMapping2ConflictiveAnchors(index1, index2, false);
    }

    public void addSubMapping2ConflictiveAnchors(int index1, int index2, boolean fromDG) {
        if (!this.conflictiveMappings1N.containsKey(index1)) {
            this.conflictiveMappings1N.put(index1, new HashSet());
        }
        this.conflictiveMappings1N.get(index1).add(index2);
        if (fromDG) {
            if (!this.conflictiveMappings1N_D_G.containsKey(index1)) {
                this.conflictiveMappings1N_D_G.put(index1, new HashSet());
            }
            this.conflictiveMappings1N_D_G.get(index1).add(index2);
        }
    }

    public Map<Integer, Set<Integer>> getConflictiveMappings_D_G() {
        return this.conflictiveMappings1N_D_G;
    }

    public void addSubMapping2WeakenedDandGAnchors(int index1, int index2) {
        if (!this.weakenedDandG_Mappings1N.containsKey(index1)) {
            this.weakenedDandG_Mappings1N.put(index1, new HashSet());
        }
        this.weakenedDandG_Mappings1N.get(index1).add(index2);
    }

    public void addMapping2GoldStandardAnchors(int index1, int index2) {
        if (!this.GSMappings1N.containsKey(index1)) {
            this.GSMappings1N.put(index1, new HashSet());
        }
        this.GSMappings1N.get(index1).add(index2);
    }

    public Map<Integer, Set<Integer>> getGoldStandardMappings() {
        return this.GSMappings1N;
    }

    public boolean isMappingInGoldStandard(int index1, int index2) {
        return this.GSMappings1N.containsKey(index1) && this.GSMappings1N.get(index1).contains(index2);
    }

    public boolean isMappingAlreadyInList(int index1, int index2) {
        return this.logmapMappings1N.containsKey(index1) && this.logmapMappings1N.get(index1).contains(index2);
    }

    public boolean isMappingInList2Review(int index1, int index2) {
        return this.mappings2Review.containsKey(index1) && this.mappings2Review.get(index1).contains(index2);
    }

    public boolean isMappingInAnchors2AskLogMap(int index1, int index2) {
        return this.candidateMappings2askLogMap1N.containsKey(index1) && this.candidateMappings2askLogMap1N.get(index1).contains(index2);
    }

    public boolean isMappingInAnchors2AskUser(int index1, int index2) {
        return this.candidateMappings2askUser1N.containsKey(index1) && this.candidateMappings2askUser1N.get(index1).contains(index2);
    }

    public boolean isMappingInDiscardedSet(int index1, int index2) {
        return this.discardedMappings1N.containsKey(index1) && this.discardedMappings1N.get(index1).contains(index2);
    }

    public boolean isMappingInHardDiscardedSet(int index1, int index2) {
        return this.hardDiscardedMappings1N.containsKey(index1) && this.hardDiscardedMappings1N.get(index1).contains(index2);
    }

    public boolean isMappingInConflictiveSet(int index1, int index2) {
        return this.conflictiveMappings1N.containsKey(index1) && this.conflictiveMappings1N.get(index1).contains(index2);
    }

    public boolean isMappingWeakenedDandG(int index1, int index2) {
        return this.weakenedDandG_Mappings1N.containsKey(index1) && this.weakenedDandG_Mappings1N.get(index1).contains(index2);
    }

    public boolean isMappingInAnchors(int index1, int index2) {
        return this.isMappingAlreadyInList(index1, index2) || this.isMappingAlreadyInList(index2, index1);
    }

    public boolean isMappingAlreadyConsidered(int index1, int index2) {
        if (this.isMappingAlreadyInList(index1, index2) || this.isMappingAlreadyInList(index2, index1)) {
            return true;
        }
        if (this.isMappingInList2Review(index1, index2) || this.isMappingInList2Review(index2, index1)) {
            return true;
        }
        if (this.isMappingInDiscardedSet(index1, index2) || this.isMappingInDiscardedSet(index2, index1)) {
            return true;
        }
        if (this.isMappingInHardDiscardedSet(index1, index2) || this.isMappingInHardDiscardedSet(index2, index1)) {
            return true;
        }
        if (this.isMappingInConflictiveSet(index1, index2) || this.isMappingInDiscardedSet(index2, index1)) {
            return true;
        }
        if (this.isMappingWeakenedDandG(index1, index2) || this.isMappingWeakenedDandG(index2, index1)) {
            return true;
        }
        return this.isMappingInAnchors2AskLogMap(index1, index2) || this.isMappingInAnchors2AskLogMap(index2, index1);
    }

    public void addEquivMapping2ListOfWeakAnchors(int index1, int index2) {
        if (!this.allWeakMappings1N.containsKey(index1)) {
            this.allWeakMappings1N.put(index1, new HashSet());
        }
        this.allWeakMappings1N.get(index1).add(index2);
    }

    public void addEquivMapping2ListOfWeakCandidateAnchors(int index1, int index2) {
        if (!this.weakCandidateMappings1N.containsKey(index1)) {
            this.weakCandidateMappings1N.put(index1, new HashSet());
        }
        this.weakCandidateMappings1N.get(index1).add(index2);
    }

    public void setStringAnchors() {
        this.setStringAnchors(true, true, true);
    }

    public void setStringAnchors(boolean out_class_map, boolean out_prop_map, boolean out_inst_map) {
        block12: {
            this.mappings_candidates_Str.clear();
            if (out_class_map) {
                for (int ide1 : this.logmapMappings1N.keySet()) {
                    for (int ide2 : this.logmapMappings1N.get(ide1)) {
                        this.addStringAnchor(ide1, ide2);
                    }
                }
            }
            if (out_prop_map) {
                for (int ident1 : this.getDataPropertyAnchors().keySet()) {
                    this.addStringAnchorDataProp(ident1, this.getDataPropertyAnchors().get(ident1));
                }
                for (int ident1 : this.getObjectPropertyAnchors().keySet()) {
                    this.addStringAnchorObjProp(ident1, this.getObjectPropertyAnchors().get(ident1));
                }
            }
            if (!out_inst_map) break block12;
            if (Parameters.output_instance_mapping_files) {
                for (int ide1 : this.getInstanceMappings4OutputType().keySet()) {
                    for (int ide2 : this.getInstanceMappings4OutputType().get(ide1).keySet()) {
                        int type = this.getInstanceMappings4OutputType().get(ide1).get(ide2);
                        if (type > 1) continue;
                        this.addStringMappingIndividual(ide1, ide2);
                    }
                }
            } else {
                for (int ide1 : this.getInstanceMappings().keySet()) {
                    for (int ide2 : this.getInstanceMappings().get(ide1)) {
                        this.addStringMappingIndividual(ide1, ide2);
                    }
                }
            }
        }
    }

    public void setDiscardedStringAnchors() {
        this.discarded_candidates.clear();
        for (int ide1 : this.getDiscardedMappings().keySet()) {
            for (int ide2 : this.getDiscardedMappings().get(ide1)) {
                this.addDiscardedStringMappingsAnchor(ide1, ide2);
            }
        }
    }

    public void addStringAnchor(int ide1, int ide2) {
        String iri2;
        String iri1;
        if (this.isId1SmallerThanId2(ide1, ide2)) {
            iri1 = this.index.getIRIStr4ConceptIndex(ide1);
            iri2 = this.index.getIRIStr4ConceptIndex(ide2);
        } else {
            iri2 = this.index.getIRIStr4ConceptIndex(ide1);
            iri1 = this.index.getIRIStr4ConceptIndex(ide2);
        }
        this.mappings_candidates_Str.add(new MappingObjectStr(iri1, iri2, this.getConfidence4Mapping(ide1, ide2)));
    }

    public void addDiscardedStringMappingsAnchor(int ide1, int ide2) {
        String iri2;
        String iri1;
        if (this.isId1SmallerThanId2(ide1, ide2)) {
            iri1 = this.index.getIRIStr4ConceptIndex(ide1);
            iri2 = this.index.getIRIStr4ConceptIndex(ide2);
        } else {
            iri2 = this.index.getIRIStr4ConceptIndex(ide1);
            iri1 = this.index.getIRIStr4ConceptIndex(ide2);
        }
        this.discarded_candidates.add(new MappingObjectStr(iri1, iri2, this.getConfidence4Mapping(ide1, ide2)));
    }

    public void addStringAnchorDataProp(int ide1, int ide2) {
        this.mappings_candidates_Str.add(new MappingObjectStr(this.index.getIRIStr4DataPropIndex(ide1), this.index.getIRIStr4DataPropIndex(ide2), this.getConfidence4DataPropertyAnchor(ide1, ide2)));
    }

    public void addStringAnchorObjProp(int ide1, int ide2) {
        this.mappings_candidates_Str.add(new MappingObjectStr(this.index.getIRIStr4ObjPropIndex(ide1), this.index.getIRIStr4ObjPropIndex(ide2), this.getConfidence4ObjectPropertyAnchor(ide1, ide2)));
    }

    public void addStringMappingIndividual(int ide1, int ide2) {
        this.mappings_candidates_Str.add(new MappingObjectStr(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), this.getConfidence4InstanceMapping(ide1, ide2)));
    }

    protected void addScopeAll2Structure(int ide1, int ide2, double conf) {
        if (!this.anchor2scopeAll.containsKey(ide1)) {
            this.anchor2scopeAll.put(ide1, new HashMap());
        }
        this.anchor2scopeAll.get(ide1).put(ide2, conf);
    }

    private void addScopeAnchors2Structure(int ide1, int ide2, double conf) {
        if (!this.anchor2scopeAnchors.containsKey(ide1)) {
            this.anchor2scopeAnchors.put(ide1, new HashMap());
        }
        this.anchor2scopeAnchors.get(ide1).put(ide2, conf);
    }

    public void addIsub2Structure(int ide1, int ide2, double conf) {
        if (!this.anchor2isub.containsKey(ide1)) {
            this.anchor2isub.put(ide1, new HashMap());
        }
        this.anchor2isub.get(ide1).put(ide2, conf);
    }

    public void addIsub4Indivual(int ide1, int ide2, double conf) {
        if (!this.instanceMappings2isub.containsKey(ide1)) {
            this.instanceMappings2isub.put(ide1, new HashMap());
        }
        this.instanceMappings2isub.get(ide1).put(ide2, conf);
    }

    public void addOutputType4Indivual(int ide1, int ide2, int conf) {
        if (!this.instanceMappings2outputtype.containsKey(ide1)) {
            this.instanceMappings2outputtype.put(ide1, new HashMap());
        }
        this.instanceMappings2outputtype.get(ide1).put(ide2, conf);
    }

    public void addCompFactor4Indivual(int ide1, int ide2, double conf) {
        if (!this.instanceMappings2compfactor.containsKey(ide1)) {
            this.instanceMappings2compfactor.put(ide1, new HashMap());
        }
        this.instanceMappings2compfactor.get(ide1).put(ide2, conf);
    }

    public void addScope4Indivual(int ide1, int ide2, double conf) {
        if (!this.instanceMappings2scope.containsKey(ide1)) {
            this.instanceMappings2scope.put(ide1, new HashMap());
        }
        this.instanceMappings2scope.get(ide1).put(ide2, conf);
    }

    protected void addIsubAverage2Structure(int ide1, int ide2, double conf) {
        if (!this.anchor2isub_avg.containsKey(ide1)) {
            this.anchor2isub_avg.put(ide1, new HashMap());
        }
        this.anchor2isub_avg.get(ide1).put(ide2, conf);
    }

    protected void addSimWeak2Structure(int ide1, int ide2, double conf) {
        if (!this.anchor2sim_weak.containsKey(ide1)) {
            this.anchor2sim_weak.put(ide1, new HashMap());
        }
        this.anchor2sim_weak.get(ide1).put(ide2, conf);
    }

    public void addMappingAddedByUser2Structure(int ide1, int ide2) {
        if (!this.anchor2addedByUser.containsKey(ide1)) {
            this.anchor2addedByUser.put(ide1, new HashSet());
        }
        this.anchor2addedByUser.get(ide1).add(ide2);
    }

    public boolean isMappingAddedByUser(int ide1, int ide2) {
        if (!this.anchor2addedByUser.containsKey(ide1)) {
            return false;
        }
        return this.anchor2addedByUser.get(ide1).contains(ide2);
    }

    private double getISUB4Mapping(int ide1, int ide2) {
        if (!this.anchor2isub.containsKey(ide1)) {
            return 0.7;
        }
        if (!this.anchor2isub.get(ide1).containsKey(ide2)) {
            return 0.7;
        }
        return this.anchor2isub.get(ide1).get(ide2);
    }

    private double getISUBAverage4Mapping(int ide1, int ide2) {
        if (!this.anchor2isub_avg.containsKey(ide1)) {
            return 0.7;
        }
        if (!this.anchor2isub_avg.get(ide1).containsKey(ide2)) {
            return 0.7;
        }
        return this.anchor2isub_avg.get(ide1).get(ide2);
    }

    public boolean hasWeakMappingSim(int ide1, int ide2) {
        if (!this.anchor2sim_weak.containsKey(ide1)) {
            return false;
        }
        return this.anchor2sim_weak.get(ide1).containsKey(ide2);
    }

    public double getSimWeak4Mapping2(int ide1, int ide2) {
        if (this.anchor2sim_weak.containsKey(ide1) && this.anchor2sim_weak.get(ide1).containsKey(ide2)) {
            return this.anchor2sim_weak.get(ide1).get(ide2);
        }
        return -1.0;
    }

    public double getSimWeak4Mapping(int ide1, int ide2) {
        if (this.anchor2sim_weak.containsKey(ide1) && this.anchor2sim_weak.get(ide1).containsKey(ide2)) {
            return this.anchor2sim_weak.get(ide1).get(ide2);
        }
        return this.getISUB4Mapping(ide1, ide2) / 9.0;
    }

    private double getScopeAll4Mapping(int ide1, int ide2) {
        if (!this.anchor2scopeAll.containsKey(ide1)) {
            return this.getISUB4Mapping(ide1, ide2);
        }
        if (!this.anchor2scopeAll.get(ide1).containsKey(ide2)) {
            return this.getISUB4Mapping(ide1, ide2);
        }
        return this.anchor2scopeAll.get(ide1).get(ide2);
    }

    private double getScopeAnchors4Mapping(int ide1, int ide2) {
        if (!this.anchor2scopeAnchors.containsKey(ide1)) {
            return this.getISUB4Mapping(ide1, ide2);
        }
        if (!this.anchor2scopeAnchors.get(ide1).containsKey(ide2)) {
            return this.getISUB4Mapping(ide1, ide2);
        }
        return this.anchor2scopeAnchors.get(ide1).get(ide2);
    }

    public double getLexicalScore(int ide1, int ide2) {
        return this.getISUB4Mapping(ide1, ide2);
    }

    public double getStructuralScore(int ide1, int ide2) {
        return this.getScopeAnchors4Mapping(ide1, ide2);
    }

    public double getConfidence4Mapping(int ide1, int ide2) {
        if (this.isMappingAddedByUser(ide1, ide2)) {
            return 1.0;
        }
        double conf = this.weightIsub * this.getISUB4Mapping(ide1, ide2) + this.weightIsub_avg * this.getISUBAverage4Mapping(ide1, ide2) + this.weightScope * this.getScopeAll4Mapping(ide1, ide2) + this.weightScopeAnchors * this.getScopeAnchors4Mapping(ide1, ide2);
        if (this.hasWeakMappingSim(ide1, ide2)) {
            return conf + 0.1;
        }
        return conf;
    }

    public double extractISUB4Mapping(int ide1, int ide2) {
        if (this.anchor2isub.containsKey(ide1) && this.anchor2isub.get(ide1).containsKey(ide2)) {
            return this.anchor2isub.get(ide1).get(ide2);
        }
        double isub_score = this.getIsubScore4ConceptsLabels(ide1, ide2);
        this.addIsub2Structure(ide1, ide2, isub_score);
        this.addIsub2Structure(ide2, ide1, isub_score);
        return isub_score;
    }

    public double extractISUB4InstanceMapping(int ide1, int ide2) {
        if (this.instanceMappings2isub.containsKey(ide1) && this.instanceMappings2isub.get(ide1).containsKey(ide2)) {
            return this.instanceMappings2isub.get(ide1).get(ide2);
        }
        double isub_score = this.getIsubScore4IndividualLabels(ide1, ide2);
        this.addIsub4Indivual(ide1, ide2, isub_score);
        this.addIsub4Indivual(ide2, ide1, isub_score);
        return isub_score;
    }

    public double extractScope4InstanceMapping(int ide1, int ide2) {
        if (this.instanceMappings2scope.containsKey(ide1) && this.instanceMappings2scope.get(ide1).containsKey(ide2)) {
            return this.instanceMappings2scope.get(ide1).get(ide2);
        }
        double scope_score = this.getScopeScore4Individuals(ide1, ide2);
        this.addScope4Indivual(ide1, ide2, scope_score);
        this.addScope4Indivual(ide2, ide1, scope_score);
        return scope_score;
    }

    public double extractISUBAverage4Mapping(int ide1, int ide2) {
        if (this.anchor2isub_avg.containsKey(ide1) && this.anchor2isub_avg.get(ide1).containsKey(ide2)) {
            return this.anchor2isub_avg.get(ide1).get(ide2);
        }
        double isub_score = this.getIsubAverageScore4ConceptsLabels(ide1, ide2);
        this.addIsubAverage2Structure(ide1, ide2, isub_score);
        this.addIsubAverage2Structure(ide2, ide1, isub_score);
        return isub_score;
    }

    public double extractScopeAll4Mapping(int ide1, int ide2) {
        if (this.anchor2scopeAll.containsKey(ide1) && this.anchor2scopeAll.get(ide1).containsKey(ide2)) {
            return this.anchor2scopeAll.get(ide1).get(ide2);
        }
        double scope_score = this.getScopeScoreAll4Neighbourhood(ide1, ide2);
        this.addScopeAll2Structure(ide1, ide2, scope_score);
        this.addScopeAll2Structure(ide2, ide1, scope_score);
        return scope_score;
    }

    public double extractScopeAnchors4Mapping(int ide1, int ide2) {
        if (this.anchor2scopeAnchors.containsKey(ide1) && this.anchor2scopeAnchors.get(ide1).containsKey(ide2)) {
            return this.anchor2scopeAnchors.get(ide1).get(ide2);
        }
        double scope_score = this.getScopeScoreAnchors4Neighbourhood(ide1, ide2);
        this.addScopeAnchors2Structure(ide1, ide2, scope_score);
        this.addScopeAnchors2Structure(ide2, ide1, scope_score);
        return scope_score;
    }

    public double getIsubScore4DataPropertyLabels(int ide1, int ide2) {
        return this.getIsubScore4DataPropertyLabels(ide1, ide2, true);
    }

    public double getIsubScore4DataPropertyLabels(int ide1, int ide2, boolean useAlternatives) {
        if (useAlternatives) {
            double max_score = -10.0;
            for (String str1 : this.index.getAlternativeLabels4DataPropertyIndex(ide1)) {
                for (String str2 : this.index.getAlternativeLabels4DataPropertyIndex(ide2)) {
                    double isub_score = this.isub.score(str1, str2);
                    if (isub_score < 0.0) {
                        isub_score = 0.0;
                    }
                    if (!(isub_score > max_score)) continue;
                    max_score = isub_score;
                }
            }
            return max_score;
        }
        return this.isub.score(this.index.getLabel4DataPropIndex(ide1), this.index.getLabel4DataPropIndex(ide2));
    }

    public double getIsubScore4ObjectPropertyLabels(int ide1, int ide2) {
        return this.getIsubScore4ObjectPropertyLabels(ide1, ide2, true);
    }

    public double getIsubScore4ObjectPropertyLabels(int ide1, int ide2, boolean useAlternativeLabels) {
        if (useAlternativeLabels) {
            double max_score = -10.0;
            for (String str1 : this.index.getAlternativeLabels4ObjectPropertyIndex(ide1)) {
                for (String str2 : this.index.getAlternativeLabels4ObjectPropertyIndex(ide2)) {
                    double isub_score = this.isub.score(str1, str2);
                    if (isub_score < 0.0) {
                        isub_score = 0.0;
                    }
                    if (!(isub_score > max_score)) continue;
                    max_score = isub_score;
                }
            }
            return max_score;
        }
        return this.isub.score(this.index.getLabel4ObjPropIndex(ide1), this.index.getLabel4ObjPropIndex(ide2));
    }

    public double getIsubScore4ConceptsLabels(int ide1, int ide2) {
        return this.getIsubScore4ConceptsLabels(ide1, ide2, 0.99);
    }

    protected double getIsubScore4ConceptsLabels(int ide1, int ide2, double enough_score) {
        double max_score = -10.0;
        for (String str1 : this.index.getAlternativeLabels4ConceptIndex(ide1)) {
            for (String str2 : this.index.getAlternativeLabels4ConceptIndex(ide2)) {
                double isub_score = this.isub.score(str1, str2);
                if (isub_score < 0.0) {
                    isub_score = 0.0;
                }
                if (isub_score > max_score) {
                    max_score = isub_score;
                }
                if (!(max_score > enough_score)) continue;
                return max_score;
            }
        }
        return max_score;
    }

    public double getIsubScore4IndividualLabels(int ide1, int ide2) {
        return this.getIsubScore4IndividualLabels(ide1, ide2, 0.99);
    }

    protected double getIsubScore4IndividualLabels(int ide1, int ide2, double enough_score) {
        double max_score = -10.0;
        for (String str1 : this.index.getAlternativeLabels4IndividualIndex(ide1)) {
            for (String str2 : this.index.getAlternativeLabels4IndividualIndex(ide2)) {
                double isub_score = this.isub.score(str1, str2);
                if (isub_score < 0.0) {
                    isub_score = 0.0;
                }
                if (isub_score > max_score) {
                    max_score = isub_score;
                }
                if (!(max_score > enough_score)) continue;
                return max_score;
            }
        }
        if (max_score == 0.0) {
            max_score = 0.5;
        }
        return max_score;
    }

    private double getIsubAverageScore4ConceptsLabels(int ide1, int ide2) {
        int num_matchings = 0;
        double isub_avg = 0.0;
        for (String str1 : this.index.getAlternativeLabels4ConceptIndex(ide1)) {
            for (String str2 : this.index.getAlternativeLabels4ConceptIndex(ide2)) {
                ++num_matchings;
                double isub_score = this.isub.score(str1, str2);
                if (isub_score < 0.0) {
                    isub_score = 0.0;
                }
                isub_avg += isub_score;
            }
        }
        if (num_matchings == 0) {
            return 0.0;
        }
        return isub_avg / (double)num_matchings;
    }

    private double getScopeScoreAll4Neighbourhood(int ide1, int ide2) {
        double score;
        Set<Integer> module1 = this.index.getScope4Identifier_Condifence(ide1);
        Set<Integer> module2 = this.index.getScope4Identifier_Condifence(ide2);
        if (module1.size() == 0 && module2.size() > 0 || module2.size() == 0 && module1.size() > 0) {
            return 0.01;
        }
        if (module1.size() == 0 || module2.size() == 0) {
            return 0.01;
        }
        int unionSize = module1.size() + module2.size();
        double weightedIntersection = 0.0;
        double max_score = -1.0;
        for (int ent1 : module1) {
            boolean mapped = false;
            if (this.logmapMappings1N.containsKey(ent1)) {
                for (int ent2 : this.logmapMappings1N.get(ent1)) {
                    if (!module2.contains(ent2)) continue;
                    weightedIntersection += 1.0;
                    mapped = true;
                    break;
                }
            }
            if (mapped) continue;
            if (this.allWeakMappings1N.containsKey(ent1)) {
                max_score = -1.0;
                for (int ent2 : this.allWeakMappings1N.get(ent1)) {
                    if (!module2.contains(ent2) || !((score = this.getIsubScore4ConceptsLabels(ent1, ent2)) > max_score)) continue;
                    max_score = score;
                }
            }
            if (!(max_score > 0.0)) continue;
            weightedIntersection += max_score;
            mapped = true;
        }
        if (weightedIntersection <= 0.0) {
            if (this.areMappedEntitiesSharingScope(ide1, ide2)) {
                return 0.1;
            }
            block3: for (int ent1 : module1) {
                for (int ent2 : module2) {
                    score = this.getIsubScore4ConceptsLabels(ent1, ent2, 0.65);
                    if (!(score > 0.65)) continue;
                    weightedIntersection += score;
                    continue block3;
                }
            }
        }
        if (weightedIntersection < 0.5) {
            return 0.0;
        }
        double scopeScore = (double)Math.round(2.0 * weightedIntersection / (double)unionSize * 100.0) / 100.0;
        return scopeScore;
    }

    private double getScopeScoreAnchors4Neighbourhood(int ide1, int ide2) {
        Set<Integer> module1 = this.index.getScope4Identifier_Condifence(ide1);
        Set<Integer> module2 = this.index.getScope4Identifier_Condifence(ide2);
        if (module1.size() == 0 && module2.size() > 0 || module2.size() == 0 && module1.size() > 0) {
            return 0.01;
        }
        if (module1.size() == 0 || module2.size() == 0) {
            return 0.01;
        }
        int unionSize = module1.size() + module2.size();
        int num_mappings = 0;
        block0: for (int ent1 : module1) {
            if (!this.logmapMappings1N.containsKey(ent1)) continue;
            for (int ent2 : this.logmapMappings1N.get(ent1)) {
                if (!module2.contains(ent2)) continue;
                ++num_mappings;
                continue block0;
            }
        }
        if (num_mappings < 1) {
            return 0.0;
        }
        double scopeScore = (double)Math.round(2.0 * (double)num_mappings / (double)unionSize * 100.0) / 100.0;
        return scopeScore;
    }

    public double getScopeISUB4Neighbourhood(int ide1, int ide2) {
        Set<Integer> module1 = this.index.getScope4Identifier_Condifence(ide1);
        Set<Integer> module2 = this.index.getScope4Identifier_Condifence(ide2);
        if (module1.size() == 0 && module2.size() > 0 || module2.size() == 0 && module1.size() > 0) {
            return 0.01;
        }
        if (module1.size() == 0 || module2.size() == 0) {
            return 0.01;
        }
        int unionSize = module1.size() + module2.size();
        double weightedIntersection = 0.0;
        block0: for (int ent1 : module1) {
            for (int ent2 : module2) {
                double score = this.getIsubScore4ConceptsLabels(ent1, ent2, 0.75);
                if (!(score > 0.75)) continue;
                weightedIntersection += score;
                continue block0;
            }
        }
        double scopeScore = (double)Math.round(2.0 * weightedIntersection / (double)unionSize * 100.0) / 100.0;
        return scopeScore;
    }

    public double getScopeScore4Individuals(int ide1, int ide2) {
        Set<Integer> types1 = this.index.getIndividualClassTypes4Identifier(ide1);
        Set<Integer> types2 = this.index.getIndividualClassTypes4Identifier(ide2);
        if (types1.isEmpty() || types2.isEmpty()) {
            return 0.0;
        }
        double max_scope = -1.0;
        for (int cls1 : types1) {
            for (int cls2 : types2) {
                double scope = this.getScopeAll4Mapping(cls1, cls2);
                if (scope > 0.9) {
                    return scope;
                }
                if (!(scope > max_scope)) continue;
                max_scope = scope;
            }
        }
        return max_scope;
    }

    private boolean areMappedEntitiesSharingScope(int ide1, int ide2) {
        Set<Integer> module1 = this.index.getScope4Identifier_Big(ide1);
        Set<Integer> module2 = this.index.getScope4Identifier_Big(ide2);
        if (module1.size() == 0 && module2.size() > 0 || module2.size() == 0 && module1.size() > 0) {
            return true;
        }
        if (module1.size() == 0 || module2.size() == 0) {
            return true;
        }
        for (int ent1 : module1) {
            if (!this.allWeakMappings1N.containsKey(ent1)) continue;
            for (int ent2 : this.allWeakMappings1N.get(ent1)) {
                if (!module2.contains(ent2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMappingInConflictWithFixedMappings(int ident1, int ident2) {
        return this.isMappingInConflictWithFixedMappings_includes_descendants(ident1, ident2);
    }

    public boolean isMappingInConflictWithFixedMappings_direct_disjointness(int ident1, int ident2) {
        return this.index.areDisjoint(ident1, ident2) || this.index.areDisjoint(ident2, ident1);
    }

    public boolean isMappingInConflictWithFixedMappings_includes_descendants(int ident1, int ident2) {
        if (this.index.areDisjoint(ident1, ident2) || this.index.areDisjoint(ident2, ident1)) {
            return true;
        }
        return this.index.isDisjointWithDescendants(ident1, ident2) || this.index.isDisjointWithDescendants(ident2, ident1);
    }

    public boolean areMappingsInConflict(int ideA, int ideB, int ideAA, int ideBB) {
        boolean AequivAA = false;
        boolean BequivBB = false;
        boolean AcontAA = false;
        boolean AAcontA = false;
        boolean BcontBB = false;
        boolean BBcontB = false;
        boolean AdisjAA = false;
        boolean BdisjBB = false;
        boolean conflict = false;
        AequivAA = this.index.areEquivalentClasses(ideA, ideAA);
        BequivBB = this.index.areEquivalentClasses(ideB, ideBB);
        AcontAA = AequivAA || this.index.isSubClassOf(ideA, ideAA);
        AAcontA = AequivAA || this.index.isSubClassOf(ideAA, ideA);
        BcontBB = BequivBB || this.index.isSubClassOf(ideB, ideBB);
        BBcontB = BequivBB || this.index.isSubClassOf(ideBB, ideB);
        AdisjAA = !AcontAA && !AAcontA && this.index.areDisjoint(ideA, ideAA);
        BdisjBB = !BcontBB && !BBcontB && this.index.areDisjoint(ideB, ideBB);
        conflict = (AcontAA || AAcontA) && BdisjBB || (BcontBB || BBcontB) && AdisjAA;
        return conflict;
    }

    public boolean isMappingDangerousEquiv(int ident1, int ident2) {
        return (this.index.isSubClassOf(ident1, ident2) || this.index.isSubClassOf(ident2, ident1)) && !this.isEntityAlreadyMapped(ident1) && !this.isEntityAlreadyMapped(ident2);
    }

    public boolean isMappingInferred(int ident1, int ident2) {
        return this.index.isSubClassOf(ident1, ident2);
    }

    public Map<String, Set<String>> getCategoryMappings() {
        return this.category_mappings;
    }

    public void setCategoryMappings(Map<String, Set<String>> mappings) {
        this.category_mappings = mappings;
    }

    public boolean hasCategoryMappings(String uri) {
        return this.category_mappings.containsKey(uri);
    }

    public Set<String> getMappings4Category(String uri) {
        return this.category_mappings.get(uri);
    }

    public Set<String> getMappings4CategoryWithCheck(String uri) {
        if (this.category_mappings.containsKey(uri)) {
            return this.category_mappings.get(uri);
        }
        return new HashSet<String>();
    }

    public void printStatisticsMappingEvaluation() {
        int ide1;
        LogOutput.print("");
        int mappings = 0;
        int good = 0;
        Iterator<Object> iterator = this.logmapMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            ide1 = iterator.next();
            for (int ide2 : this.logmapMappings1N.get(ide1)) {
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                ++mappings;
                if (!this.isMappingInGoldStandard(ide1, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Anchors IF exact: " + mappings);
        LogOutput.print("Good Anchors in GS: " + good);
        mappings = 0;
        good = 0;
        iterator = this.mappings2Review.keySet().iterator();
        while (iterator.hasNext()) {
            ide1 = iterator.next();
            for (int ide2 : this.mappings2Review.get(ide1)) {
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                ++mappings;
                if (!this.isMappingInGoldStandard(ide1, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Mappings 2 review: " + mappings);
        LogOutput.print("Good mappings 2 review in GS: " + good);
        mappings = 0;
        good = 0;
        iterator = this.candidateMappings2askLogMap1N.keySet().iterator();
        while (iterator.hasNext()) {
            ide1 = iterator.next();
            for (int ide2 : this.candidateMappings2askLogMap1N.get(ide1)) {
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                ++mappings;
                if (!this.isMappingInGoldStandard(ide1, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Mappings 2 ask logmap: " + mappings);
        LogOutput.print("Good mappings 2 ask logmap in GS: " + good);
        mappings = 0;
        good = 0;
        iterator = this.candidateMappings2askUser1N.keySet().iterator();
        while (iterator.hasNext()) {
            ide1 = iterator.next();
            for (int ide2 : this.candidateMappings2askUser1N.get(ide1)) {
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                ++mappings;
                if (!this.isMappingInGoldStandard(ide1, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Mappings 2 ask user: " + mappings);
        LogOutput.print("Good mappings 2 ask user in GS: " + good);
        mappings = 0;
        good = 0;
        for (MappingObjectInteractivity mapping : this.listMappings2askUser1N) {
            ++mappings;
            if (!this.isMappingInGoldStandard(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2())) continue;
            ++good;
        }
        LogOutput.print("Mappings 2 ask user (filtered list): " + mappings);
        LogOutput.print("Good mappings 2 ask user in GS (filtered list): " + good);
        mappings = 0;
        good = 0;
        iterator = this.weakenedDandG_Mappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide12 = (Integer)iterator.next();
            for (int ide2 : this.weakenedDandG_Mappings1N.get(ide12)) {
                ++mappings;
                if (!this.isMappingInGoldStandard(ide12, ide2) && !this.isMappingInGoldStandard(ide2, ide12)) continue;
                ++good;
            }
        }
        LogOutput.print("Weakened DG anchors: " + mappings);
        LogOutput.print("Good weakened DG anchors in GS: " + good);
        mappings = 0;
        good = 0;
        iterator = this.discardedMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide13 = (Integer)iterator.next();
            for (int ide2 : this.discardedMappings1N.get(ide13)) {
                if (!this.isId1SmallerThanId2(ide13, ide2)) continue;
                ++mappings;
                if (!this.isMappingInGoldStandard(ide13, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Mappings Discarded: " + mappings);
        LogOutput.print("Good mappings Discarded: " + good);
        mappings = 0;
        good = 0;
        iterator = this.hardDiscardedMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide14 = (Integer)iterator.next();
            for (int ide2 : this.hardDiscardedMappings1N.get(ide14)) {
                if (!this.isId1SmallerThanId2(ide14, ide2)) continue;
                ++mappings;
                if (!this.isMappingInGoldStandard(ide14, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Mappings Hard Discarded: " + mappings);
        LogOutput.print("Good mappings Hard Discarded: " + good);
        mappings = 0;
        good = 0;
        iterator = this.conflictiveMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide15 = (Integer)iterator.next();
            for (int ide2 : this.conflictiveMappings1N.get(ide15)) {
                if (!this.isId1SmallerThanId2(ide15, ide2) && this.conflictiveMappings1N.containsKey(ide2) && this.conflictiveMappings1N.get(ide2).contains(ide15)) continue;
                ++mappings;
                if (!this.isMappingInGoldStandard(ide15, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Mappings Conflictive: " + mappings);
        LogOutput.print("Good mappings Conflictive: " + good);
        mappings = 0;
        good = 0;
        iterator = this.weakCandidateMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide16 = (Integer)iterator.next();
            for (int ide2 : this.weakCandidateMappings1N.get(ide16)) {
                ++mappings;
                if (!this.isMappingInGoldStandard(ide16, ide2)) continue;
                ++good;
            }
        }
        LogOutput.print("Mappings Weak: " + mappings);
        LogOutput.print("Good mappings Weak: " + good);
    }

    public boolean isId1SmallerThanId2(int ide1, int ide2) {
        return ide1 < ide2;
    }

    public void createAnchors(boolean are_input_mapping_validated) {
    }
}

