/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.mappings;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.SIAssessment.DataPropertyMappingAssessment;
import uk.ac.ox.krr.logmap2.SIAssessment.InstanceMatchingAssessment;
import uk.ac.ox.krr.logmap2.SIAssessment.ObjectPropertyMappingAssessment;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.indexing.OntologyProcessing;
import uk.ac.ox.krr.logmap2.indexing.entities.ClassIndex;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.mappings.WeakCandidate;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectIdentifiers;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.oracle.OracleManager;
import uk.ac.ox.krr.logmap2.statistics.StatisticsManager;
import uk.ac.ox.krr.logmap2.utilities.Lib;

public class CandidateMappingManager
extends MappingManager {
    private OntologyProcessing onto_process1;
    private OntologyProcessing onto_process2;
    private Set<Set<String>> if_exact_intersection;
    private Set<Set<String>> if_stemming_intersection;
    private Set<Set<String>> if_weak_intersection;
    private Set<Set<String>> if_exact_intersection4data_prop;
    private Set<Set<String>> if_exact_intersection4obj_prop;
    private Set<Set<String>> if_exact_intersection4individuals;
    private Set<String> if_weak_intersection4individuals;
    private Set<String> if_roleassertions_intersection4individuals;
    private Set<MappingObjectIdentifiers> input_mappings = new HashSet<MappingObjectIdentifiers>();
    private int IF_VALIDATED = 0;
    private int IF_EXACT = 1;
    private int IF_STEMMING = 2;
    private int IF_WEAK = 3;
    private Map<Integer, Set<Integer>> visitedScopeMappings = new HashMap<Integer, Set<Integer>>();

    public CandidateMappingManager(IndexManager index, OntologyProcessing onto_process1, OntologyProcessing onto_process2) {
        this.index = index;
        this.onto_process1 = onto_process1;
        this.onto_process2 = onto_process2;
    }

    public void clearIntersectedInvertedFilesExact() {
        this.if_exact_intersection.clear();
    }

    public void clearIntersectedInvertedFilesStemmingAndWeak() {
        this.if_stemming_intersection.clear();
        this.if_weak_intersection.clear();
    }

    public void clearIntersectedInvertedFiles4Properties() {
        this.if_exact_intersection4data_prop.clear();
        this.if_exact_intersection4obj_prop.clear();
    }

    @Override
    public void intersectInvertedFiles() {
        this.if_exact_intersection4data_prop = this.onto_process1.getInvertedFileExactMatching4DataProp().keySet();
        this.if_exact_intersection4data_prop.retainAll(this.onto_process2.getInvertedFileExactMatching4DataProp().keySet());
        this.onto_process2.getInvertedFileExactMatching4DataProp().keySet().retainAll(this.if_exact_intersection4data_prop);
        this.if_exact_intersection4obj_prop = this.onto_process1.getInvertedFileExactMatching4ObjProp().keySet();
        this.if_exact_intersection4obj_prop.retainAll(this.onto_process2.getInvertedFileExactMatching4ObjProp().keySet());
        this.onto_process2.getInvertedFileExactMatching4ObjProp().keySet().retainAll(this.if_exact_intersection4obj_prop);
        this.if_exact_intersection4individuals = this.onto_process1.getInvertedFileMatching4Individuals().keySet();
        this.if_exact_intersection4individuals.retainAll(this.onto_process2.getInvertedFileMatching4Individuals().keySet());
        this.onto_process2.getInvertedFileMatching4Individuals().keySet().retainAll(this.if_exact_intersection4individuals);
        this.if_weak_intersection4individuals = this.onto_process1.getInvertedFileWeakMatching4Individuals().keySet();
        this.if_weak_intersection4individuals.retainAll(this.onto_process2.getInvertedFileWeakMatching4Individuals().keySet());
        this.onto_process2.getInvertedFileWeakMatching4Individuals().keySet().retainAll(this.if_weak_intersection4individuals);
        this.if_roleassertions_intersection4individuals = this.onto_process1.getInvertedFileRoleAssertions().keySet();
        this.if_roleassertions_intersection4individuals.retainAll(this.onto_process2.getInvertedFileRoleAssertions().keySet());
        this.onto_process2.getInvertedFileRoleAssertions().keySet().retainAll(this.if_roleassertions_intersection4individuals);
        LogOutput.print("IF Exact 1: " + this.onto_process1.getInvertedFileExactMatching().size());
        LogOutput.print("IF Exact 2: " + this.onto_process2.getInvertedFileExactMatching().size());
        this.if_exact_intersection = this.onto_process1.getInvertedFileExactMatching().keySet();
        this.if_exact_intersection.retainAll(this.onto_process2.getInvertedFileExactMatching().keySet());
        this.onto_process2.getInvertedFileExactMatching().keySet().retainAll(this.if_exact_intersection);
        LogOutput.print("Intersection IF Exact: " + this.if_exact_intersection.size());
        LogOutput.print("IF Stemming 1: " + this.onto_process1.getInvertedFileWeakLabelsStemming().size());
        LogOutput.print("IF Stemming 2: " + this.onto_process2.getInvertedFileWeakLabelsStemming().size());
        this.if_stemming_intersection = new HashSet<Set<String>>(this.onto_process1.getInvertedFileWeakLabelsStemming().keySet());
        this.if_stemming_intersection.retainAll(this.onto_process2.getInvertedFileWeakLabelsStemming().keySet());
        LogOutput.print("Intersection IF Stemming: " + this.if_stemming_intersection.size());
        HashMap<Set<String>, Set<Integer>> if_difference1 = new HashMap<Set<String>, Set<Integer>>(this.onto_process1.getInvertedFileWeakLabelsStemming());
        this.onto_process1.getInvertedFileWeakLabelsStemming().keySet().retainAll(this.if_stemming_intersection);
        if_difference1.keySet().removeAll(this.if_stemming_intersection);
        this.onto_process1.addEntries2InvertedFileWeakLabels(if_difference1);
        if_difference1.clear();
        LogOutput.print("Entries in Weak IF from Setemming: " + this.onto_process1.getInvertedFileWeakLabels().size());
        HashMap<Set<String>, Set<Integer>> if_difference2 = new HashMap<Set<String>, Set<Integer>>(this.onto_process2.getInvertedFileWeakLabelsStemming());
        this.onto_process2.getInvertedFileWeakLabelsStemming().keySet().retainAll(this.if_stemming_intersection);
        if_difference2.keySet().removeAll(this.if_stemming_intersection);
        this.onto_process2.addEntries2InvertedFileWeakLabels(if_difference2);
        if_difference2.clear();
        LogOutput.print("Entries in Weak IF from Setemming: " + this.onto_process2.getInvertedFileWeakLabels().size());
        this.onto_process1.setInvertedFileWeakLabels();
        this.onto_process2.setInvertedFileWeakLabels();
        LogOutput.print("IF Weak 1: " + this.onto_process1.getInvertedFileWeakLabels().size());
        LogOutput.print("IF Weak 2: " + this.onto_process2.getInvertedFileWeakLabels().size());
        this.if_weak_intersection = this.onto_process1.getInvertedFileWeakLabels().keySet();
        this.if_weak_intersection.retainAll(this.onto_process2.getInvertedFileWeakLabels().keySet());
        this.onto_process2.getInvertedFileWeakLabels().keySet().retainAll(this.if_weak_intersection);
        LogOutput.print("Intersection IF Weak: " + this.if_weak_intersection.size());
    }

    @Override
    public void extractAllWeakMappings() {
        for (Set<String> set_str : this.if_exact_intersection) {
            for (int ide1 : this.onto_process1.getInvertedFileExactMatching().get(set_str)) {
                for (int ide2 : this.onto_process2.getInvertedFileExactMatching().get(set_str)) {
                    this.addEquivMapping2ListOfWeakAnchors(ide1, ide2);
                }
            }
        }
        if (Parameters.use_stemming) {
            for (Set<String> set_str : this.if_stemming_intersection) {
                for (int ide1 : this.onto_process1.getInvertedFileWeakLabelsStemming().get(set_str)) {
                    for (int ide2 : this.onto_process2.getInvertedFileWeakLabelsStemming().get(set_str)) {
                        this.addEquivMapping2ListOfWeakAnchors(ide1, ide2);
                    }
                }
            }
        }
        for (Set<String> set_str : this.if_weak_intersection) {
            for (int ide1 : this.onto_process1.getInvertedFileWeakLabels().get(set_str)) {
                for (int ide2 : this.onto_process2.getInvertedFileWeakLabels().get(set_str)) {
                    this.addEquivMapping2ListOfWeakAnchors(ide1, ide2);
                }
            }
        }
        int weak_anchors = 0;
        Iterator iterator = this.allWeakMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide1 = (Integer)iterator.next();
            weak_anchors += ((Set)this.allWeakMappings1N.get(ide1)).size();
        }
        LogOutput.print("WEAK ANCHORS: " + weak_anchors);
    }

    @Override
    public void extractCandidatesSubsetFromWeakMappings() {
        this.extractSubsetFromWeakMapping();
        this.extractSubsetFromWeakMappingFrequency();
        this.onto_process1.clearInvertedFileWeak();
        this.onto_process2.clearInvertedFileWeak();
        this.if_weak_intersection.clear();
    }

    @Override
    public void createAnchors() {
        this.createAnchors(false);
    }

    @Override
    public void createAnchors(boolean are_input_mapping_validated) {
        try {
            this.createCandidatesFromInputMappings(are_input_mapping_validated);
            this.createCandidatesFromExactIF();
            this.onto_process1.clearInvertedFilesExact();
            this.onto_process2.clearInvertedFilesExact();
            this.clearIntersectedInvertedFilesExact();
        }
        catch (Exception e) {
            System.err.println("Error extracting anchors: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void createCandidates() {
        try {
            LogOutput.print("assessAnchors2Review()");
            this.assessAnchors2Review();
            LogOutput.print("createCandidates4StemmingLikeAnchors()");
            this.createCandidates4StemmingLikeAnchors();
            this.onto_process1.clearInvertedFileStemming();
            this.onto_process2.clearInvertedFileStemming();
            this.if_stemming_intersection.clear();
            LogOutput.print("createCandidates4WeakAnchors()");
            this.createCandidates4WeakAnchors();
            this.weakCandidateMappings1N.clear();
            LogOutput.print("createMappings2AskUser()");
            this.createMappings2AskUser();
        }
        catch (Exception e) {
            System.err.println("Error extracting anchors: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void processInputMappings(Set<MappingObjectStr> mappings) {
        for (MappingObjectStr mapping : mappings) {
            if (!mapping.isClassMapping()) continue;
            int ide1 = this.onto_process1.getIdentifier4ConceptIRI(mapping.getIRIStrEnt1());
            int ide2 = this.onto_process2.getIdentifier4ConceptIRI(mapping.getIRIStrEnt2());
            if (ide1 >= 0 && ide2 >= 0) {
                this.input_mappings.add(new MappingObjectIdentifiers(this.onto_process1.getIdentifier4ConceptIRI(mapping.getIRIStrEnt1()), this.onto_process2.getIdentifier4ConceptIRI(mapping.getIRIStrEnt2())));
                continue;
            }
            System.err.println("Mapping with no direct correspondence to ids: " + mapping);
        }
    }

    private void createCandidatesFromInputMappings(boolean are_input_mapping_validated) throws Exception {
        for (MappingObjectIdentifiers mapping : this.input_mappings) {
            if (this.onto_process1.getDangerousClasses().contains(mapping.getIdentifierOnto1()) || this.onto_process2.getDangerousClasses().contains(mapping.getIdentifierOnto2())) continue;
            if (are_input_mapping_validated) {
                this.evaluateCandidateMapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2(), this.IF_VALIDATED);
                continue;
            }
            this.evaluateCandidateMapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2(), this.IF_EXACT);
        }
    }

    private void createCandidatesFromExactIF() throws Exception {
        int candidates = 0;
        for (Set<String> set_str : this.if_exact_intersection) {
            if (set_str.isEmpty()) {
                LogOutput.print("EMPTY SET IN EXACT IF: " + this.onto_process1.getInvertedFileExactMatching().get(set_str).size() + " - " + this.onto_process2.getInvertedFileExactMatching().get(set_str).size());
                continue;
            }
            for (int ide1 : this.onto_process1.getInvertedFileExactMatching().get(set_str)) {
                if (this.onto_process1.getDangerousClasses().contains(ide1)) continue;
                for (int ide2 : this.onto_process2.getInvertedFileExactMatching().get(set_str)) {
                    if (this.onto_process2.getDangerousClasses().contains(ide2)) continue;
                    this.evaluateCandidateMapping(ide1, ide2, this.IF_EXACT);
                    ++candidates;
                }
            }
        }
    }

    private void evaluateCandidateMapping(int ide1, int ide2, int origin) {
        if (origin == this.IF_VALIDATED) {
            this.evaluateCandidateMappingIFValidated(ide1, ide2);
        } else if (origin == this.IF_EXACT) {
            this.evaluateCandidateMappingIFExact(ide1, ide2);
        } else if (origin == this.IF_STEMMING) {
            this.evaluateCandidateMappingIFStemming(ide1, ide2);
        } else if (origin == this.IF_WEAK) {
            this.evaluateCandidateMappingIFWeak(ide1, ide2);
        }
    }

    private void evaluateCandidateMappingIFValidated(int ide1, int ide2) {
        if (this.isMappingAlreadyConsidered(ide1, ide2)) {
            return;
        }
        StatisticsManager.addStatisticsMappingsAll(ide1, ide2);
        this.extractISUB4Mapping(ide1, ide2);
        this.extractISUBAverage4Mapping(ide1, ide2);
        this.extractScopeAll4Mapping(ide1, ide2);
        this.getConfidence4Mapping(ide1, ide2);
        this.addSubMapping2ListOfAnchors(ide1, ide2);
        this.addSubMapping2ListOfAnchors(ide2, ide1);
    }

    private void evaluateCandidateMappingIFExact(int ide1, int ide2) {
        if (this.isMappingAlreadyConsidered(ide1, ide2)) {
            return;
        }
        StatisticsManager.addStatisticsMappingsAll(ide1, ide2);
        double scoreISUB = this.extractISUB4Mapping(ide1, ide2);
        double scoreISUB_avg = this.extractISUBAverage4Mapping(ide1, ide2);
        double scoreScope = this.extractScopeAll4Mapping(ide1, ide2);
        double conf = this.getConfidence4Mapping(ide1, ide2);
        if (scoreISUB < Parameters.good_isub_anchors || scoreISUB_avg < 0.35 || scoreScope <= Parameters.bad_score_scope) {
            this.addSubMapping2Mappings2Review(ide1, ide2);
            return;
        }
        boolean ambiguous = false;
        if (this.isEntityAlreadyMapped(ide1) && this.isEntityAlreadyMapped(ide2)) {
            int ide2a = this.getTargetEntity4Index(ide1);
            int ide1a = this.getTargetEntity4Index(ide2);
            double conf1 = this.getConfidence4Mapping(ide1, ide2a);
            double conf2 = this.getConfidence4Mapping(ide1a, ide2);
            if (conf > conf1 && conf > conf2) {
                this.moveMapping2ReviewList(ide1, ide2a);
                this.moveMapping2ReviewList(ide1a, ide2);
            } else {
                ambiguous = true;
            }
        } else if (this.isEntityAlreadyMapped(ide1)) {
            int ide2a = this.getTargetEntity4Index(ide1);
            double conf1 = this.getConfidence4Mapping(ide1, ide2a);
            if (conf > conf1) {
                this.moveMapping2ReviewList(ide1, ide2a);
            } else {
                ambiguous = true;
            }
        } else if (this.isEntityAlreadyMapped(ide2)) {
            int ide1a = this.getTargetEntity4Index(ide2);
            double conf1 = this.getConfidence4Mapping(ide1a, ide2);
            if (conf > conf1) {
                this.moveMapping2ReviewList(ide1a, ide2);
            } else {
                ambiguous = true;
            }
        }
        if (ambiguous) {
            this.addSubMapping2Mappings2Review(ide1, ide2);
            return;
        }
        this.addSubMapping2ListOfAnchors(ide1, ide2);
        this.addSubMapping2ListOfAnchors(ide2, ide1);
    }

    private void assessAnchors2Review() {
        Iterator iterator = this.mappings2Review.keySet().iterator();
        while (iterator.hasNext()) {
            int ide1 = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.mappings2Review.get(ide1)).iterator();
            while (iterator2.hasNext()) {
                int ide2 = (Integer)iterator2.next();
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                this.evaluateAnchor2Review(ide1, ide2);
            }
        }
        this.mappings2Review.clear();
    }

    private void evaluateAnchor2Review(int ide1, int ide2) {
        if (this.isMappingInConflictWithFixedMappings(ide1, ide2)) {
            this.addSubMapping2ConflictiveAnchors(ide1, ide2);
            this.addSubMapping2ConflictiveAnchors(ide2, ide1);
            return;
        }
        if (this.isMappingDangerousEquiv(ide1, ide2)) {
            this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
            this.isHardMappingInGS(ide1, ide2, 1);
            return;
        }
        this.extractScopeAnchors4Mapping(ide1, ide2);
        double scoreScope = this.extractScopeAll4Mapping(ide1, ide2);
        if (scoreScope <= Parameters.bad_score_scope && (this.isEntityAlreadyMapped(ide1) || this.isEntityAlreadyMapped(ide2))) {
            this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
            this.isHardMappingInGS(ide1, ide2, 2);
            return;
        }
        this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
    }

    private void createCandidates4StemmingLikeAnchors() throws Exception {
        int candidates = 0;
        for (Set<String> set_str : this.if_stemming_intersection) {
            int size2;
            if (set_str.isEmpty()) {
                LogOutput.print("EMPTY SET IN STEMMING IF: " + this.onto_process1.getInvertedFileWeakLabelsStemming().get(set_str).size() + " - " + this.onto_process2.getInvertedFileWeakLabelsStemming().get(set_str).size());
                continue;
            }
            int size1 = this.onto_process1.getInvertedFileWeakLabelsStemming().get(set_str).size();
            int ambiguity = size1 * (size2 = this.onto_process2.getInvertedFileWeakLabelsStemming().get(set_str).size());
            if (ambiguity >= 7 || size1 >= 4 || size2 >= 4) {
                if (ambiguity <= 20) continue;
                LogOutput.print("High ambiguity stemming: " + ambiguity);
                continue;
            }
            for (int ide1 : this.onto_process1.getInvertedFileWeakLabelsStemming().get(set_str)) {
                if (this.onto_process1.getDangerousClasses().contains(ide1)) continue;
                for (int ide2 : this.onto_process2.getInvertedFileWeakLabelsStemming().get(set_str)) {
                    if (this.onto_process2.getDangerousClasses().contains(ide2)) continue;
                    this.evaluateCandidateMapping(ide1, ide2, this.IF_STEMMING);
                    ++candidates;
                }
            }
        }
        LogOutput.print("Candidates STEMING: " + candidates);
    }

    private void evaluateCandidateMappingIFStemming(int ide1, int ide2) {
        if (this.isMappingAlreadyConsidered(ide1, ide2)) {
            return;
        }
        StatisticsManager.addStatisticsMappingsAll(ide1, ide2);
        if (this.isMappingInConflictWithFixedMappings(ide1, ide2)) {
            this.addSubMapping2ConflictiveAnchors(ide1, ide2);
            this.addSubMapping2ConflictiveAnchors(ide2, ide1);
            return;
        }
        if (this.isMappingDangerousEquiv(ide1, ide2)) {
            this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
            this.isHardMappingInGS(ide1, ide2, 1);
            return;
        }
        if (this.isEntityAlreadyMapped(ide1) || this.isEntityAlreadyMapped(ide2)) {
            this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
            this.isHardMappingInGS(ide1, ide2, 2);
            return;
        }
        this.extractScopeAnchors4Mapping(ide1, ide2);
        double scoreScope = this.extractScopeAll4Mapping(ide1, ide2);
        double scoreISUB = this.extractISUB4Mapping(ide1, ide2);
        double confidence = this.getConfidence4Mapping(ide1, ide2);
        if (scoreScope <= Parameters.bad_score_scope || scoreISUB < Parameters.good_isub_candidates) {
            if (scoreISUB > 0.7 && confidence > 0.45) {
                this.addEquivMapping2DiscardedAnchors(ide1, ide2);
            } else {
                this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
                this.isHardMappingInGS(ide1, ide2, 3);
            }
            return;
        }
        this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
    }

    private boolean evaluateCandidateMappingExpansion(int ide1, int ide2) {
        if (this.isMappingAlreadyConsidered(ide1, ide2)) {
            return false;
        }
        double scoreISUB = this.extractISUB4Mapping(ide1, ide2);
        if (scoreISUB < 0.95) {
            return false;
        }
        if (this.isMappingInConflictWithFixedMappings(ide1, ide2)) {
            this.addSubMapping2ConflictiveAnchors(ide1, ide2);
            this.addSubMapping2ConflictiveAnchors(ide2, ide1);
            return false;
        }
        if (this.isMappingDangerousEquiv(ide1, ide2)) {
            this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
            return false;
        }
        if (this.isEntityAlreadyMapped(ide1) || this.isEntityAlreadyMapped(ide2) || scoreISUB < 0.98) {
            return false;
        }
        this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
        return true;
    }

    private void createCandidates4WeakAnchors() {
        int candidates = 0;
        Iterator iterator = this.weakCandidateMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide1 = (Integer)iterator.next();
            if (this.onto_process1.getDangerousClasses().contains(ide1)) continue;
            Iterator iterator2 = ((Set)this.weakCandidateMappings1N.get(ide1)).iterator();
            while (iterator2.hasNext()) {
                int ide2 = (Integer)iterator2.next();
                if (this.onto_process2.getDangerousClasses().contains(ide2) || !this.isId1SmallerThanId2(ide1, ide2)) continue;
                this.evaluateCandidateMappingIFWeak(ide1, ide2);
                ++candidates;
            }
        }
    }

    private void evaluateCandidateMappingIFWeak(int ide1, int ide2) {
        if (this.isMappingAlreadyInList(ide1, ide2) || this.isMappingInAnchors2AskLogMap(ide1, ide2) || this.isMappingInConflictiveSet(ide1, ide2)) {
            return;
        }
        if (this.isMappingAlreadyConsidered(ide1, ide2) && !this.hasWeakMappingSim(ide1, ide2)) {
            return;
        }
        if (!this.isMappingAlreadyConsidered(ide1, ide2)) {
            StatisticsManager.addStatisticsMappingsAll(ide1, ide2);
        }
        if (this.isMappingInConflictWithFixedMappings(ide1, ide2)) {
            this.addSubMapping2ConflictiveAnchors(ide1, ide2);
            this.addSubMapping2ConflictiveAnchors(ide2, ide1);
            return;
        }
        if (this.isMappingDangerousEquiv(ide1, ide2)) {
            this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
            this.isHardMappingInGS(ide1, ide2, 1);
            return;
        }
        if (this.isEntityAlreadyMapped(ide1) || this.isEntityAlreadyMapped(ide2)) {
            this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
            this.isHardMappingInGS(ide1, ide2, 2);
            return;
        }
        double scoreScope = this.extractScopeAll4Mapping(ide1, ide2);
        double scoreISUB = this.extractISUB4Mapping(ide1, ide2);
        double confidence = this.getConfidence4Mapping(ide1, ide2);
        double scoreScopeAnc = this.extractScopeAnchors4Mapping(ide1, ide2);
        if (!this.hasWeakMappingSim(ide1, ide2)) {
            if (scoreISUB < Parameters.good_isub_candidates && scoreScope <= Parameters.bad_score_scope) {
                this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
                return;
            }
            if (scoreISUB < Parameters.good_isub_candidates) {
                if (scoreISUB > 0.83 && confidence > 0.45) {
                    this.addEquivMapping2DiscardedAnchors(ide1, ide2);
                } else {
                    this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
                }
                return;
            }
        } else {
            if (scoreISUB >= Parameters.good_isub_candidates && scoreScope > Parameters.bad_score_scope) {
                this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
                return;
            }
            if (this.getSimWeak4Mapping2(ide1, ide2) >= Parameters.good_sim_coocurrence && scoreScope > Parameters.bad_score_scope) {
                this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
                return;
            }
            if (scoreISUB < 0.65) {
                this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
                return;
            }
            if (scoreISUB > 0.89 || scoreISUB > 0.8 && confidence > Parameters.good_confidence && scoreScope > Parameters.bad_score_scope || confidence > 0.8) {
                this.addEquivMapping2DiscardedAnchors(ide1, ide2);
            } else {
                this.addEquivMapping2HardDiscardedAnchors(ide1, ide2);
                this.isHardMappingInGS(ide1, ide2, 3);
            }
            return;
        }
        this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
    }

    private void extractSubsetFromWeakMapping() {
        for (Set<String> set_str : this.if_weak_intersection) {
            int size2;
            if (set_str.isEmpty()) {
                LogOutput.print("EMPTY SET IN WEAK IF: " + this.onto_process1.getInvertedFileWeakLabels().get(set_str).size() + " - " + this.onto_process2.getInvertedFileWeakLabels().get(set_str).size());
                continue;
            }
            int size1 = this.onto_process1.getInvertedFileWeakLabels().get(set_str).size();
            int ambiguity = size1 * (size2 = this.onto_process2.getInvertedFileWeakLabels().get(set_str).size());
            if (ambiguity >= 13 && size1 >= 5 && size2 >= 5) continue;
            for (int ide1 : this.onto_process1.getInvertedFileWeakLabels().get(set_str)) {
                if (this.onto_process1.getDangerousClasses().contains(ide1)) continue;
                for (int ide2 : this.onto_process2.getInvertedFileWeakLabels().get(set_str)) {
                    if (this.onto_process2.getDangerousClasses().contains(ide2)) continue;
                    this.addEquivMapping2ListOfWeakCandidateAnchors(ide1, ide2);
                }
            }
        }
        int weak_anchors = 0;
        Iterator iterator = this.weakCandidateMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide1 = (Integer)iterator.next();
            weak_anchors += ((Set)this.weakCandidateMappings1N.get(ide1)).size();
        }
    }

    private void extractSubsetFromWeakMappingFrequency() {
        HashSet<String> words1 = new HashSet<String>();
        HashSet<String> words2 = new HashSet<String>();
        WeakCandidate[] picked = new WeakCandidate[3];
        ClassIndex class1 = null;
        ClassIndex class2 = null;
        for (Set<String> set_str : this.if_weak_intersection) {
            int f_key;
            Set<Integer> set2;
            int size2;
            Set<Integer> set1 = this.onto_process1.getInvertedFileWeakLabels().get(set_str);
            int size1 = set1.size();
            if (size1 > 5 & (size2 = (set2 = this.onto_process2.getInvertedFileWeakLabels().get(set_str)).size()) > 5 && size1 * size2 > 100) continue;
            try {
                f_key = this.index.getCooccurrenceOfWords(set_str).size();
            }
            catch (NullPointerException e) {
                LogOutput.print("NullPointerException   " + set_str.toString());
                continue;
            }
            for (int ide1 : set1) {
                class1 = this.index.getClassIndex(ide1);
                String label1 = class1.findStemmedAltLabel(set_str);
                if (label1 == null) continue;
                for (String word : label1.split("_")) {
                    words1.add(word);
                }
                Iterator<Integer> iterator = set2.iterator();
                while (iterator.hasNext()) {
                    int ide2 = (Integer)iterator.next();
                    class2 = this.index.getClassIndex(ide2);
                    String label2 = class2.findStemmedAltLabel(set_str);
                    if (label2 == null) continue;
                    if (!words2.isEmpty()) {
                        words2.clear();
                    }
                    for (String word : label2.split("_")) {
                        words2.add(word);
                    }
                    if (!this.hasCommonWords(words2, words1, set_str)) continue;
                    WeakCandidate cand = new WeakCandidate(set_str, ide1, ide2, label1, label2, this.index, f_key);
                    this.insertCandidate(picked, cand);
                }
                for (int i = 0; i < picked.length && picked[i] != null; ++i) {
                    int id1 = (Integer)picked[i].getKey();
                    int id2 = (Integer)picked[i].getValue();
                    this.addEquivMapping2ListOfWeakCandidateAnchors(id1, id2);
                    double sim = picked[i].getScore();
                    this.addSimWeak2Structure(id1, id2, sim);
                    this.addSimWeak2Structure(id2, id1, sim);
                    picked[i] = null;
                }
                words1.clear();
            }
        }
    }

    private boolean hasCommonWords(Set<String> a, Set<String> b, Set<String> c) {
        for (String word : a) {
            if (!b.contains(word) || c.contains(word)) continue;
            return false;
        }
        return true;
    }

    private void insertCandidate(WeakCandidate[] picked, WeakCandidate cand) {
        if (Lib.dcmp(cand.getScore() - 0.0) <= 0) {
            return;
        }
        for (int i = 0; i < picked.length; ++i) {
            if (picked[i] != null && cand.compareTo(picked[i]) <= 0) continue;
            for (int j = picked.length - 1; j > i; --j) {
                picked[j] = picked[j - 1];
            }
            picked[i] = cand;
            break;
        }
    }

    private void createMappings2AskUser() {
        int side1_amb_logmap = 0;
        int side2_amb_logmap = 0;
        int both_amb_logmap = 0;
        this.mappings2Review.clear();
        if (this.getNumDiscardedMappings() < this.getLogMapMappings().size() / Parameters.ratio_second_chance_discarded) {
            LogOutput.print("Second chance to discarded mappings.");
            this.setFilterWithHeuristicsSecondLevelMappings(false);
            for (int ide1 : this.getDiscardedMappings().keySet()) {
                for (int ide2 : this.getDiscardedMappings().get(ide1)) {
                    this.addMapping2ListOfAnchors2AskLogMap(ide1, ide2);
                }
            }
            this.getDiscardedMappings().clear();
        }
        for (int ide1 : this.getToAskLogMapMappings().keySet()) {
            side1_amb_logmap = this.getEntityAmbiguity_LogMapMappings(ide1);
            for (int ide2 : this.getToAskLogMapMappings().get(ide1)) {
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                side2_amb_logmap = this.getEntityAmbiguity_LogMapMappings(ide2);
                both_amb_logmap = side1_amb_logmap + side2_amb_logmap;
                if (both_amb_logmap > Parameters.max_ambiguity) {
                    this.isHardMappingInGS(ide1, ide2, 0);
                    this.addEquivMapping2DiscardedAnchors(ide1, ide2);
                    continue;
                }
                if (both_amb_logmap <= Parameters.good_ambiguity && (this.extractISUB4Mapping(ide1, ide2) > Parameters.good_isub_anchors || this.hasWeakMappingSim(ide1, ide2) && this.getSimWeak4Mapping2(ide1, ide2) >= Parameters.good_sim_coocurrence)) {
                    if (OracleManager.isActive()) {
                        this.addEquivMapping2ListOfAnchors2AskUser(ide1, ide2);
                        LogOutput.printAlways("New Added 2 ask: " + this.index.getIRIStr4ConceptIndex(ide1) + "  " + this.index.getIRIStr4ConceptIndex(ide2));
                        continue;
                    }
                    this.addSubMapping2Mappings2Review(ide1, ide2);
                    this.addSubMapping2Mappings2Review(ide2, ide1);
                    continue;
                }
                this.addEquivMapping2ListOfAnchors2AskUser(ide1, ide2);
            }
        }
        boolean side1_amb_user = false;
        boolean side2_amb_user = false;
        boolean both_amb_user = false;
    }

    @Override
    public void assessMappings2AskUser() {
        int ide2;
        Iterator iterator;
        int ide1;
        LogOutput.print("Assessing mappings to ask user.");
        Iterator iterator2 = this.candidateMappings2askUser1N.keySet().iterator();
        while (iterator2.hasNext()) {
            ide1 = (Integer)iterator2.next();
            iterator = ((Set)this.candidateMappings2askUser1N.get(ide1)).iterator();
            while (iterator.hasNext()) {
                ide2 = (Integer)iterator.next();
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                if (this.isMappingInConflictWithFixedMappings(ide1, ide2)) {
                    this.addSubMapping2ConflictiveAnchors(ide1, ide2);
                    this.addSubMapping2ConflictiveAnchors(ide2, ide1);
                    continue;
                }
                if (this.isMappingDangerousEquiv(ide1, ide2)) {
                    this.addEquivMapping2DiscardedAnchors(ide1, ide2);
                    continue;
                }
                this.addMappingObject2AskUserList(ide1, ide2);
            }
        }
        iterator2 = this.weakenedDandG_Mappings1N.keySet().iterator();
        while (iterator2.hasNext()) {
            ide1 = (Integer)iterator2.next();
            iterator = ((Set)this.weakenedDandG_Mappings1N.get(ide1)).iterator();
            while (iterator.hasNext()) {
                ide2 = (Integer)iterator.next();
                if (this.isMappingInConflictWithFixedMappings(ide1, ide2)) {
                    this.addSubMapping2ConflictiveAnchors(ide1, ide2);
                    continue;
                }
                if (this.isMappingInferred(ide1, ide2)) continue;
                StatisticsManager.addStatisticsSplitMapping(ide1, ide2);
                if (this.isId1SmallerThanId2(ide1, ide2)) {
                    this.addMappingObject2AskUserList(ide1, ide2, 0);
                    continue;
                }
                this.addMappingObject2AskUserList(ide2, ide1, -1);
            }
        }
        this.weakenedDandG_Mappings1N.clear();
        StatisticsManager.extractStatisticsMappings2Ask();
        StatisticsManager.extracStatisticsDiscardedMappings();
        StatisticsManager.extracStatisticsHardDiscardedMappings();
        StatisticsManager.extracStatisticsConflictiveMappings();
        StatisticsManager.extracStatisticsConflictiveMappings_D_G();
    }

    public void assessConflictiveMappings() {
        for (int ident1 : this.getConflictiveMappings().keySet()) {
            for (int ident2 : this.getConflictiveMappings().get(ident1)) {
                if (!this.isMappingInConflictWithFixedMappings(ident1, ident2)) continue;
            }
        }
    }

    @Override
    public void assesWeakenedMappingsDandG2(boolean removeAfterwards, boolean add2Anchors) {
        LogOutput.print("Assessing weakened mappings by Dowling and Gallier.");
        Iterator iterator = this.weakenedDandG_Mappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide1 = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.weakenedDandG_Mappings1N.get(ide1)).iterator();
            while (iterator2.hasNext()) {
                int ide2 = (Integer)iterator2.next();
                if (this.isMappingInConflictWithFixedMappings(ide1, ide2)) {
                    this.addSubMapping2ConflictiveAnchors(ide1, ide2);
                    continue;
                }
                if (this.isMappingInferred(ide1, ide2)) continue;
                if (add2Anchors) {
                    this.addSubMapping2ListOfAnchors(ide1, ide2);
                    continue;
                }
                this.addSubMapping2Mappings2Review(ide1, ide2);
            }
        }
        if (removeAfterwards) {
            this.weakenedDandG_Mappings1N.clear();
        }
    }

    @Override
    public void createInstanceAnchors() {
        double confidence;
        int type_output;
        double compatibility_factor;
        double required_confidence;
        boolean ambiguity;
        InstanceMatchingAssessment instanceMappingAssessment = new InstanceMatchingAssessment(this.index, this);
        int num_incompatible_instances = 0;
        LogOutput.print("Size IF intersection exact: " + this.if_exact_intersection4individuals.size());
        for (Set<String> set : this.if_exact_intersection4individuals) {
            ambiguity = false;
            if (this.onto_process1.getInvertedFileMatching4Individuals().get(set).size() > 1 || this.onto_process2.getInvertedFileMatching4Individuals().get(set).size() > 1) {
                ambiguity = true;
            }
            for (int ident1 : this.onto_process1.getInvertedFileMatching4Individuals().get(set)) {
                for (int ident2 : this.onto_process2.getInvertedFileMatching4Individuals().get(set)) {
                    required_confidence = instanceMappingAssessment.getConfidence4Compatibility(ident1, ident2);
                    compatibility_factor = instanceMappingAssessment.getCompatibilityFactor(ident1, ident2);
                    if (!instanceMappingAssessment.haveInstancesCompatibleCategories(ident1, ident2) && ambiguity) {
                        required_confidence = 3.0;
                    }
                    if (required_confidence > 1.0) {
                        ++num_incompatible_instances;
                        type_output = 3;
                    } else {
                        confidence = this.extractISUB4InstanceMapping(ident1, ident2);
                        if (confidence >= required_confidence) {
                            this.addInstanceMapping(ident1, ident2, ambiguity);
                            type_output = 0;
                        } else {
                            type_output = 1;
                        }
                    }
                    if (!Parameters.output_instance_mapping_files) continue;
                    this.addOutputType4Indivual(ident1, ident2, type_output);
                    this.extractISUB4InstanceMapping(ident1, ident2);
                    this.addCompFactor4Indivual(ident1, ident2, compatibility_factor);
                    this.extractScope4InstanceMapping(ident1, ident2);
                }
            }
        }
        LogOutput.print("\nNUmber of Instance mappings exact IF: " + this.getInstanceMappings().keySet().size() + " - " + this.getSizeOfInstanceMappings());
        LogOutput.print("NUM INCOMPATIBLE INDIV MAPPINGS: " + num_incompatible_instances + "\n");
        this.if_exact_intersection4individuals.clear();
        num_incompatible_instances = 0;
        LogOutput.print("Sife IF intersection weak: " + this.if_weak_intersection4individuals.size());
        for (String string : this.if_weak_intersection4individuals) {
            ambiguity = false;
            if (this.onto_process1.getInvertedFileWeakMatching4Individuals().get(string).size() > 1 || this.onto_process2.getInvertedFileWeakMatching4Individuals().get(string).size() > 1) {
                ambiguity = true;
            }
            for (int ident1 : this.onto_process1.getInvertedFileWeakMatching4Individuals().get(string)) {
                if (this.isIndividualAlreadyMapped(ident1)) continue;
                for (int ident2 : this.onto_process2.getInvertedFileWeakMatching4Individuals().get(string)) {
                    if (this.isIndividualAlreadyMapped(ident2)) continue;
                    required_confidence = instanceMappingAssessment.getConfidence4Compatibility(ident1, ident2);
                    compatibility_factor = instanceMappingAssessment.getCompatibilityFactor(ident1, ident2);
                    if (!instanceMappingAssessment.haveInstancesCompatibleCategories(ident1, ident2) & ambiguity) {
                        required_confidence = 3.0;
                    }
                    if (required_confidence > 1.0) {
                        ++num_incompatible_instances;
                        type_output = 3;
                    } else {
                        confidence = this.extractISUB4InstanceMapping(ident1, ident2);
                        if (confidence >= required_confidence) {
                            this.addInstanceMapping(ident1, ident2, ambiguity);
                            type_output = 0;
                        } else {
                            type_output = confidence > 0.65 ? 1 : 2;
                        }
                    }
                    if (!Parameters.output_instance_mapping_files) continue;
                    this.addOutputType4Indivual(ident1, ident2, type_output);
                    this.extractISUB4InstanceMapping(ident1, ident2);
                    this.addCompFactor4Indivual(ident1, ident2, compatibility_factor);
                    this.extractScope4InstanceMapping(ident1, ident2);
                }
            }
        }
        LogOutput.print("\nNUmber of Instance mappings exact+weak IF: " + this.getInstanceMappings().keySet().size() + " - " + this.getSizeOfInstanceMappings());
        LogOutput.print("NUM INCOMPATIBLE INDIV MAPPINGS: " + num_incompatible_instances);
        this.if_weak_intersection4individuals.clear();
        LogOutput.print("Size role assetions: " + this.if_roleassertions_intersection4individuals.size());
        int max_amb = 2;
        for (String if_entry : this.if_roleassertions_intersection4individuals) {
            if (this.onto_process1.getInvertedFileRoleAssertions().get(if_entry).size() > max_amb || this.onto_process2.getInvertedFileRoleAssertions().get(if_entry).size() > max_amb) continue;
            for (int ident1 : this.onto_process1.getInvertedFileRoleAssertions().get(if_entry)) {
                if (this.isIndividualAlreadyMapped(ident1)) continue;
                for (int ident2 : this.onto_process2.getInvertedFileRoleAssertions().get(if_entry)) {
                    if (this.isIndividualAlreadyMapped(ident2)) continue;
                    required_confidence = instanceMappingAssessment.getConfidence4Compatibility(ident1, ident2);
                    compatibility_factor = instanceMappingAssessment.getCompatibilityFactor(ident1, ident2);
                    if (!instanceMappingAssessment.haveInstancesCompatibleCategories(ident1, ident2)) {
                        required_confidence = 3.0;
                    }
                    if (required_confidence > 1.0) {
                        ++num_incompatible_instances;
                        type_output = 3;
                    } else {
                        confidence = this.extractISUB4InstanceMapping(ident1, ident2);
                        this.addInstanceMapping(ident1, ident2, true);
                        type_output = 0;
                    }
                    if (!Parameters.output_instance_mapping_files) continue;
                    this.addOutputType4Indivual(ident1, ident2, type_output);
                    this.extractISUB4InstanceMapping(ident1, ident2);
                    this.addCompFactor4Indivual(ident1, ident2, compatibility_factor);
                    this.extractScope4InstanceMapping(ident1, ident2);
                }
            }
        }
        LogOutput.print("\nNUmber of Instance mappings exact+weak+roleass IF: " + this.getInstanceMappings().keySet().size() + " - " + this.getSizeOfInstanceMappings());
        LogOutput.print("NUM INCOMPATIBLE INDIV MAPPINGS: " + num_incompatible_instances);
        this.if_roleassertions_intersection4individuals.clear();
        LogOutput.print("Instances: " + this.instanceMappings1N.size());
        LogOutput.print("Instances ambiguity: " + this.instanceMappings1N_ambiguity.size());
        LogOutput.print("Instances not in output: " + this.instanceMappings1N_not_allowed_output.size());
        Iterator iterator = this.instanceMappings1N_ambiguity.keySet().iterator();
        while (iterator.hasNext()) {
            int index1 = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.instanceMappings1N_ambiguity.get(index1)).iterator();
            while (iterator2.hasNext()) {
                int index2 = (Integer)iterator2.next();
                double sim = this.getSimilarityReferredInstances(index1, index2);
                double d = 0.2;
                if (this.getISUB4InstanceMapping(index1, index2) > 0.9) {
                    d = 0.1;
                }
                if (sim > d) {
                    this.addInstanceMapping(index1, index2);
                }
                if (!this.haveIndividualsSameCharacteristics(index1, index2)) continue;
                this.addInstanceMapping(index1, index2);
            }
        }
    }

    private double getSimilarityReferredInstances(int index1, int index2) {
        HashSet referred1_2 = new HashSet();
        Set<Integer> referred1 = this.index.getReferencedIndividuals4Individual(index1);
        for (int ref_indiv1 : referred1) {
            if (this.instanceMappings1N.containsKey(ref_indiv1)) {
                referred1_2.addAll((Collection)this.instanceMappings1N.get(ref_indiv1));
            }
            if (this.instanceMappings1N_ambiguity.containsKey(ref_indiv1)) {
                referred1_2.addAll((Collection)this.instanceMappings1N_ambiguity.get(ref_indiv1));
            }
            if (!this.instanceMappings1N_not_allowed_output.containsKey(ref_indiv1)) continue;
            referred1_2.addAll((Collection)this.instanceMappings1N_not_allowed_output.get(ref_indiv1));
        }
        Set<Integer> referred2 = this.index.getReferencedIndividuals4Individual(index2);
        int size_union = referred2.size() + referred1_2.size();
        referred1_2.retainAll(referred2);
        return (double)referred1_2.size() / (double)size_union;
    }

    private boolean haveIndividualsSameCharacteristics(int index1, int index2) {
        List<Integer> charact1 = this.index.getCharactersitics4Individual(index1);
        List<Integer> charact2 = this.index.getCharactersitics4Individual(index2);
        if (charact1.size() != charact2.size()) {
            return false;
        }
        for (int i = 0; i < charact1.size(); ++i) {
            if (charact1.get(i).equals(charact2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean areReferredInstancesInContainmentRelationship(int index1, int index2) {
        HashSet referred1_2 = new HashSet();
        Set<Integer> referred1 = this.index.getReferencedIndividuals4Individual(index1);
        for (int ref_indiv1 : referred1) {
            if (this.instanceMappings1N.containsKey(ref_indiv1)) {
                referred1_2.addAll((Collection)this.instanceMappings1N.get(ref_indiv1));
            }
            if (this.instanceMappings1N_ambiguity.containsKey(ref_indiv1)) {
                referred1_2.addAll((Collection)this.instanceMappings1N_ambiguity.get(ref_indiv1));
            }
            if (!this.instanceMappings1N_not_allowed_output.containsKey(ref_indiv1)) continue;
            referred1_2.addAll((Collection)this.instanceMappings1N_not_allowed_output.get(ref_indiv1));
        }
        Set<Integer> referred2 = this.index.getReferencedIndividuals4Individual(index2);
        if (referred2.containsAll(referred1_2) || referred1_2.containsAll(referred2)) {
            System.out.println("Containment");
            return true;
        }
        return false;
    }

    public void evaluateCompatibilityInstanceMappings() {
        InstanceMatchingAssessment instanceMappingAssessment = new InstanceMatchingAssessment(this.index, this);
        HashMap<Integer, Set<Integer>> todelete = new HashMap<Integer, Set<Integer>>();
        int num_incompatible_instances = 0;
        for (int ident1 : this.getInstanceMappings().keySet()) {
            for (int ident2 : this.getInstanceMappings().get(ident1)) {
                double required_confidence = instanceMappingAssessment.getConfidence4Compatibility(ident1, ident2);
                if (!(required_confidence > 1.0)) continue;
                LogOutput.print("Incompatible individuals: " + ident1 + " " + ident2);
                LogOutput.print("\t" + this.index.getName4IndividualIndex(ident1) + " " + this.index.getAlternativeLabels4IndividualIndex(ident1));
                LogOutput.print("\t" + this.index.getName4IndividualIndex(ident2) + " " + this.index.getAlternativeLabels4IndividualIndex(ident2));
                ++num_incompatible_instances;
                if (!todelete.containsKey(ident1)) {
                    todelete.put(ident1, new HashSet());
                }
                ((Set)todelete.get(ident1)).add(ident2);
            }
        }
        this.deleteIncompatibleInstanceMappings(todelete);
        LogOutput.print("NUM INCOMPATIBLE INDIV MAPPINGS: " + num_incompatible_instances);
        todelete.clear();
    }

    private void deleteIncompatibleInstanceMappings(Map<Integer, Set<Integer>> todelete) {
        for (int ident1 : todelete.keySet()) {
            for (int ident2 : todelete.get(ident1)) {
                this.getInstanceMappings().get(ident1).remove(ident2);
                if (this.getInstanceMappings().get(ident1).size() != 0) continue;
                this.getInstanceMappings().remove(ident1);
            }
        }
    }

    @Override
    public void createDataPropertyAnchors() {
        for (Set<String> if_entry : this.if_exact_intersection4data_prop) {
            this.dataPropertyMappings.put(this.onto_process1.getInvertedFileExactMatching4DataProp().get(if_entry), this.onto_process2.getInvertedFileExactMatching4DataProp().get(if_entry));
            this.dataPropertyMappings2confidence.put(this.onto_process1.getInvertedFileExactMatching4DataProp().get(if_entry), 1.0);
        }
        this.if_exact_intersection4data_prop.clear();
        double maxconf = -10.0;
        int identmax = -1;
        for (int ident1 : this.index.getDataPropIdentifierSet()) {
            maxconf = -10.0;
            identmax = -1;
            if (this.dataPropertyMappings.containsKey(ident1)) continue;
            for (int ident2 : this.index.getDataPropIdentifierSet()) {
                double score;
                if (this.dataPropertyMappings.containsValue(ident2) || ident1 >= ident2 || this.index.getDataPropertyIndex(ident1).getOntologyId() == this.index.getDataPropertyIndex(ident2).getOntologyId() || !((score = this.getIsubScore4DataPropertyLabels(ident1, ident2)) > maxconf)) continue;
                maxconf = score;
                identmax = ident2;
            }
            if (!(maxconf > 0.75)) continue;
            this.dataPropertyMappings.put(ident1, identmax);
            this.dataPropertyMappings2confidence.put(ident1, maxconf);
        }
        LogOutput.printAlways("Dirty anchors Data Prop: " + this.dataPropertyMappings.size());
        this.evaluateCompatibilityDataPropertyMappings();
    }

    public void evaluateCompatibilityDataPropertyMappings() {
        DataPropertyMappingAssessment propertyMappingAssessment = new DataPropertyMappingAssessment(this.index, this);
        HashSet<Integer> todelete = new HashSet<Integer>();
        Iterator iterator = this.dataPropertyMappings.keySet().iterator();
        while (iterator.hasNext()) {
            double isub_labels;
            int ident1 = (Integer)iterator.next();
            double required_confidence = propertyMappingAssessment.getConfidence4Compatibility(ident1, (Integer)this.dataPropertyMappings.get(ident1));
            double confidence_mapping = this.getConfidence4DataPropertyAnchor(ident1, (Integer)this.dataPropertyMappings.get(ident1));
            if (confidence_mapping < required_confidence) {
                LogOutput.printAlways(required_confidence + "   " + this.dataPropertyMappings2confidence.get(ident1));
                if (required_confidence > 1.5) {
                    LogOutput.printAlways("Incompatible data properties");
                    LogOutput.printAlways("\t" + this.index.getName4DataPropIndex(ident1));
                    LogOutput.printAlways("\t" + this.index.getName4DataPropIndex((Integer)this.dataPropertyMappings.get(ident1)));
                } else if (OracleManager.isActive() && confidence_mapping >= Parameters.min_conf_pro_map) {
                    if (OracleManager.isMappingValid(this.index.getIRIStr4DataPropIndex(ident1), this.index.getIRIStr4DataPropIndex((Integer)this.dataPropertyMappings.get(ident1)))) {
                        LogOutput.printAlways("Data property mapping in Oracle");
                        LogOutput.printAlways("\t" + this.index.getName4DataPropIndex(ident1));
                        LogOutput.printAlways("\t" + this.index.getName4DataPropIndex((Integer)this.dataPropertyMappings.get(ident1)));
                        continue;
                    }
                    LogOutput.printAlways("Data property mapping NOT in Oracle");
                    LogOutput.printAlways("\t" + this.index.getName4DataPropIndex(ident1));
                    LogOutput.printAlways("\t" + this.index.getName4DataPropIndex((Integer)this.dataPropertyMappings.get(ident1)));
                }
                todelete.add(ident1);
                continue;
            }
            if (!OracleManager.isActive() || this.index.getAlternativeLabels4DataPropertyIndex(ident1).size() <= 1 && this.index.getAlternativeLabels4DataPropertyIndex((Integer)this.dataPropertyMappings.get(ident1)).size() <= 1 || !((isub_labels = this.getIsubScore4DataPropertyLabels(ident1, (Integer)this.dataPropertyMappings.get(ident1), false)) < Parameters.min_conf_pro_map)) continue;
            LogOutput.printAlways(required_confidence + "   " + isub_labels);
            if (!OracleManager.isMappingValid(this.index.getIRIStr4DataPropIndex(ident1), this.index.getIRIStr4DataPropIndex((Integer)this.dataPropertyMappings.get(ident1)))) {
                LogOutput.printAlways("Good Confidence Data property mapping NOT in Oracle");
                LogOutput.printAlways("\t" + this.index.getName4DataPropIndex(ident1));
                LogOutput.printAlways("\t" + this.index.getName4DataPropIndex((Integer)this.dataPropertyMappings.get(ident1)));
                todelete.add(ident1);
                continue;
            }
            LogOutput.printAlways("Good Confidence Data property mapping In Oracle");
            LogOutput.printAlways("\t" + this.index.getName4DataPropIndex(ident1));
            LogOutput.printAlways("\t" + this.index.getName4DataPropIndex((Integer)this.dataPropertyMappings.get(ident1)));
        }
        this.deleteDataPropertyAnchors(todelete);
        LogOutput.printAlways("\tAssessing Data Property mappings: " + this.dataPropertyMappings.size() + ", to delete: " + todelete.size());
        todelete.clear();
    }

    @Override
    public void createObjectPropertyAnchors() {
        for (Set<String> set_str : this.if_exact_intersection4obj_prop) {
            this.objPropertyMappings.put(this.onto_process1.getInvertedFileExactMatching4ObjProp().get(set_str), this.onto_process2.getInvertedFileExactMatching4ObjProp().get(set_str));
            this.objPropertyMappings2confidence.put(this.onto_process1.getInvertedFileExactMatching4ObjProp().get(set_str), 1.0);
        }
        this.if_exact_intersection4obj_prop.clear();
        double maxconf = -10.0;
        int identmax = -1;
        for (int ident1 : this.index.getObjectPropIdentifierSet()) {
            maxconf = -10.0;
            identmax = -1;
            if (this.objPropertyMappings.containsKey(ident1)) continue;
            for (int ident2 : this.index.getObjectPropIdentifierSet()) {
                double score;
                if (this.objPropertyMappings.containsValue(ident2) || ident1 >= ident2 || this.index.getObjectPropertyIndex(ident1).getOntologyId() == this.index.getObjectPropertyIndex(ident2).getOntologyId() || !((score = this.getIsubScore4ObjectPropertyLabels(ident1, ident2)) > maxconf)) continue;
                maxconf = score;
                identmax = ident2;
            }
            if (!(maxconf > 0.75)) continue;
            this.objPropertyMappings.put(ident1, identmax);
            this.objPropertyMappings2confidence.put(ident1, maxconf);
        }
        LogOutput.printAlways("Dirty anchors Object Prop: " + this.objPropertyMappings.size());
        this.evaluateCompatibilityObjectPropertyMappings();
    }

    public void evaluateCompatibilityObjectPropertyMappings() {
        ObjectPropertyMappingAssessment propertyMappingAssessment = new ObjectPropertyMappingAssessment(this.index, this);
        HashSet<Integer> todelete = new HashSet<Integer>();
        Iterator iterator = this.objPropertyMappings.keySet().iterator();
        while (iterator.hasNext()) {
            double isub_labels;
            int ident1 = (Integer)iterator.next();
            double required_confidence = propertyMappingAssessment.getConfidence4Compatibility(ident1, (Integer)this.objPropertyMappings.get(ident1));
            double confidence_mapping = this.getConfidence4ObjectPropertyAnchor(ident1, (Integer)this.objPropertyMappings.get(ident1));
            if (confidence_mapping < required_confidence) {
                LogOutput.printAlways(required_confidence + "   " + this.objPropertyMappings2confidence.get(ident1));
                if (required_confidence > 1.5) {
                    LogOutput.printAlways("Incompatible object properties");
                    LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex(ident1));
                    LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex((Integer)this.objPropertyMappings.get(ident1)));
                } else if (OracleManager.isActive() && confidence_mapping >= Parameters.min_conf_pro_map) {
                    if (OracleManager.isMappingValid(this.index.getIRIStr4ObjPropIndex(ident1), this.index.getIRIStr4ObjPropIndex((Integer)this.objPropertyMappings.get(ident1)))) {
                        LogOutput.printAlways("Object property mapping in Oracle");
                        LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex(ident1));
                        LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex((Integer)this.objPropertyMappings.get(ident1)));
                        continue;
                    }
                    LogOutput.printAlways("Object property mapping NOT in Oracle");
                    LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex(ident1));
                    LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex((Integer)this.objPropertyMappings.get(ident1)));
                }
                todelete.add(ident1);
                continue;
            }
            if (!OracleManager.isActive() || this.index.getAlternativeLabels4ObjectPropertyIndex(ident1).size() <= 1 && this.index.getAlternativeLabels4ObjectPropertyIndex((Integer)this.objPropertyMappings.get(ident1)).size() <= 1 || !((isub_labels = this.getIsubScore4ObjectPropertyLabels(ident1, (Integer)this.objPropertyMappings.get(ident1), false)) < Parameters.min_conf_pro_map)) continue;
            LogOutput.printAlways(required_confidence + "   " + isub_labels);
            if (!OracleManager.isMappingValid(this.index.getIRIStr4ObjPropIndex(ident1), this.index.getIRIStr4ObjPropIndex((Integer)this.objPropertyMappings.get(ident1)))) {
                todelete.add(ident1);
                LogOutput.printAlways("Good Confidence Object property mapping NOT in Oracle");
                LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex(ident1));
                LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex((Integer)this.objPropertyMappings.get(ident1)));
                continue;
            }
            LogOutput.printAlways("Good Confidence Object property mapping In Oracle");
            LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex(ident1));
            LogOutput.printAlways(this.index.getIRIStr4ObjPropIndex((Integer)this.objPropertyMappings.get(ident1)));
        }
        this.deleteObjectPropertyAnchors(todelete);
        LogOutput.printAlways("\tAssessing Object Property mappings: " + this.objPropertyMappings.size() + ", to delete: " + todelete.size());
        todelete.clear();
    }

    private void askOraculoAboutDomains4DataPropertyMappings(int ident1, int ident2) {
        Set<Integer> domain1 = this.index.getDomainDataProp4Identifier(ident1);
        Set<Integer> domain2 = this.index.getDomainDataProp4Identifier(ident2);
    }

    private void askOraculoAboutDomainsAndRange4ObjectPropertyMappings(int ident1, int ident2) {
        Set<Integer> domain1 = this.index.getDomainObjProp4Identifier(ident1);
        Set<Integer> domain2 = this.index.getDomainObjProp4Identifier(ident2);
        Set<Integer> ranges1 = this.index.getRangeObjProp4Identifier(ident1);
        Set<Integer> ranges2 = this.index.getRangeObjProp4Identifier(ident2);
    }

    private void askOraculoAboutPossibleMappings(Set<Integer> classes1, Set<Integer> classes2) {
        for (int cls1 : classes1) {
            for (int cls2 : classes2) {
                if (!(this.isMappingInConflictiveSet(cls1, cls2) || this.isMappingAlreadyInList(cls1, cls2) || this.isMappingInConflictiveSet(cls2, cls1) || this.isMappingAlreadyInList(cls2, cls1) || this.isMappingInConflictWithFixedMappings(cls1, cls2))) {
                    if (OracleManager.isMappingValid(this.index.getIRIStr4ConceptIndex(cls1), this.index.getIRIStr4ConceptIndex(cls2))) {
                        LogOutput.printAlways("Added new mapping: " + this.index.getIRIStr4ConceptIndex(cls1) + "  " + this.index.getIRIStr4ConceptIndex(cls2));
                        this.addSubMapping2ListOfAnchors(cls1, cls2);
                        this.addSubMapping2ListOfAnchors(cls2, cls1);
                        continue;
                    }
                    LogOutput.printAlways("NOT Added new mapping: " + this.index.getIRIStr4ConceptIndex(cls1) + "  " + this.index.getIRIStr4ConceptIndex(cls2));
                    continue;
                }
                if (!this.isMappingInConflictWithFixedMappings(cls1, cls2)) continue;
                LogOutput.printAlways("In Conflict new mapping: " + this.index.getIRIStr4ConceptIndex(cls1) + "  " + this.index.getIRIStr4ConceptIndex(cls2));
            }
        }
    }

    private void deleteDataPropertyAnchors(Set<Integer> todelete) {
        this.dataPropertyMappings.keySet().removeAll(todelete);
        this.dataPropertyMappings2confidence.keySet().removeAll(todelete);
    }

    private void deleteObjectPropertyAnchors(Set<Integer> todelete) {
        this.objPropertyMappings.keySet().removeAll(todelete);
        this.objPropertyMappings2confidence.keySet().removeAll(todelete);
    }

    private boolean isaVisitedScopeMapping(int index1, int index2) {
        return this.visitedScopeMappings.containsKey(index1) && this.visitedScopeMappings.get(index1).contains(index2);
    }

    private void addVisistedScopeMapping(int index1, int index2) {
        if (!this.visitedScopeMappings.containsKey(index1)) {
            this.visitedScopeMappings.put(index1, new HashSet());
        }
        this.visitedScopeMappings.get(index1).add(index2);
    }

    protected void createAnchorsExpansion() {
        LinkedList<MappingObjectIdentifiers> list_mappings = new LinkedList<MappingObjectIdentifiers>();
        Iterator iterator = this.logmapMappings1N.keySet().iterator();
        while (iterator.hasNext()) {
            int ide1 = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.logmapMappings1N.get(ide1)).iterator();
            while (iterator2.hasNext()) {
                int ide2 = (Integer)iterator2.next();
                if (!this.isId1SmallerThanId2(ide1, ide2)) continue;
                list_mappings.add(new MappingObjectIdentifiers(ide1, ide2));
            }
        }
        int newIn = 0;
        int newCons = 0;
        LogOutput.print("Mappings 2 EXPAND: " + list_mappings.size());
        while (!list_mappings.isEmpty()) {
            MappingObjectIdentifiers head_mapping = (MappingObjectIdentifiers)list_mappings.poll();
            Set<Integer> module1 = this.index.getScope4Identifier_Expansion(head_mapping.getIdentifierOnto1());
            Set<Integer> module2 = this.index.getScope4Identifier_Expansion(head_mapping.getIdentifierOnto2());
            for (int ide1 : module1) {
                for (int ide2 : module2) {
                    if (!this.isId1SmallerThanId2(ide1, ide2) || this.isaVisitedScopeMapping(ide1, ide2)) continue;
                    this.addVisistedScopeMapping(ide1, ide2);
                    ++newCons;
                    if (!this.evaluateCandidateMappingExpansion(ide1, ide2)) continue;
                    list_mappings.add(new MappingObjectIdentifiers(ide1, ide2));
                    ++newIn;
                }
            }
        }
        list_mappings.clear();
        LogOutput.print("Considered: " + newCons);
        LogOutput.print("New mappings expansion: " + newIn);
    }
}

