/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.lexicon.stemming;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.TreeSet;
import uk.ac.ox.krr.logmap2.lexicon.stemming.LovinsIterStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.LovinsStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.PaiceStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.PorterStemmerBridge;
import uk.ac.ox.krr.logmap2.lexicon.stemming.Stemmer;

public class StemmerTester {
    public static final String PATH = "./files/test/";
    public static final String FILE_NAME = "voc.txt";

    public static void main(String[] args) {
        Stemmer[] stemmers = new Stemmer[]{new PorterStemmerBridge(), new LovinsStemmerBridge(), new LovinsIterStemmerBridge(), new PaiceStemmerBridge(false), new PaiceStemmerBridge(true)};
        PrintWriter[] outs = new PrintWriter[stemmers.length];
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader("./files/test/voc.txt"));
            for (i = 0; i < outs.length; ++i) {
                outs[i] = new PrintWriter("./files/test/stemmed_voc_" + i + ".txt");
            }
            PrintWriter diffOut = new PrintWriter("./files/test/stemming_diff.txt");
            while (in.ready()) {
                String line = in.readLine();
                String[] stemmedVersions = new String[stemmers.length];
                TreeSet<String> stemmedVersionsSet = new TreeSet<String>();
                for (int i2 = 0; i2 < stemmers.length; ++i2) {
                    stemmedVersions[i2] = stemmers[i2].stem(line);
                    stemmedVersionsSet.add(stemmedVersions[i2]);
                    outs[i2].println(stemmedVersions[i2]);
                }
                if (stemmedVersionsSet.size() <= 1) continue;
                diffOut.print(line + "\t|");
                for (String version : stemmedVersions) {
                    diffOut.print(" " + version);
                }
                diffOut.println();
            }
            for (i = 0; i < outs.length; ++i) {
                outs[i].close();
            }
            diffOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

