/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.ox.krr.logmap2.io.OutputMappingsFormat;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;

public class OWLAlignmentFormat
extends OutputMappingsFormat {
    List<OWLOntologyChange> listAxioms2Add = new ArrayList<OWLOntologyChange>();
    OWLOntologyManager managerMappingsOnto;
    OWLOntology mappingsOnto;
    OWLDataFactory factory;
    String logical_iri = "http://www.cs.ox.ac.uk/isg/projects/LogMap/mappings.owl";
    Set<OWLNamedIndividual> indivSet = new HashSet<OWLNamedIndividual>();
    Set<OWLAnnotation> annSet = new HashSet<OWLAnnotation>();
    String iri_measure_str = this.logical_iri + "#measure";
    String iri_entity1_str = this.logical_iri + "#entity1";
    String iri_entity2_str = this.logical_iri + "#entity2";
    String iri_relation_str = this.logical_iri + "#relation";

    public OWLAlignmentFormat(String output_file_str) throws Exception {
        super(output_file_str);
        this.setOutput();
    }

    @Override
    protected void setOutput() throws Exception {
        this.managerMappingsOnto = SynchronizedOWLManager.createOWLOntologyManager();
        this.mappingsOnto = this.managerMappingsOnto.createOntology(IRI.create((String)this.logical_iri));
        this.factory = this.managerMappingsOnto.getOWLDataFactory();
    }

    private OWLAxiom createEquivalenceMapping(OWLClass cls1, OWLClass cls2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLEquivalentClassesAxiom((OWLClassExpression)cls1, (OWLClassExpression)cls2, annotations);
    }

    private OWLAxiom createDataPropertyEquivalenceMapping(OWLDataProperty dprop1, OWLDataProperty dprop2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)dprop1, (OWLDataPropertyExpression)dprop2, annotations);
    }

    private OWLAxiom createObjectPropertyEquivalenceMapping(OWLObjectProperty oprop1, OWLObjectProperty oprop2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)oprop1, (OWLObjectPropertyExpression)oprop2, annotations);
    }

    private OWLAxiom createSubClassOfMapping(OWLClass cls1, OWLClass cls2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls1, (OWLClassExpression)cls2, annotations);
    }

    private OWLAxiom createSubDataPropertyMapping(OWLDataProperty dprop1, OWLDataProperty dprop2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)dprop1, (OWLDataPropertyExpression)dprop2, annotations);
    }

    private OWLAxiom createSubObjectPropertyMapping(OWLObjectProperty oprop1, OWLObjectProperty oprop2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)oprop1, (OWLObjectPropertyExpression)oprop2, annotations);
    }

    private OWLAxiom createSuperClassOfMapping(OWLClass cls1, OWLClass cls2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls2, (OWLClassExpression)cls1, annotations);
    }

    private OWLAxiom createSuperDataPropertyMapping(OWLDataProperty dprop1, OWLDataProperty dprop2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)dprop2, (OWLDataPropertyExpression)dprop1, annotations);
    }

    private OWLAxiom createSuperObjectPropertyMapping(OWLObjectProperty oprop1, OWLObjectProperty oprop2, Set<OWLAnnotation> annotations) {
        return this.factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)oprop2, (OWLObjectPropertyExpression)oprop1, annotations);
    }

    private OWLAxiom createSameIndividualMapping(OWLNamedIndividual indiv1, OWLNamedIndividual indiv2, Set<OWLAnnotation> annotations) {
        this.indivSet.clear();
        this.indivSet.add(indiv1);
        this.indivSet.add(indiv2);
        return this.factory.getOWLSameIndividualAxiom(this.indivSet, annotations);
    }

    private Set<OWLAnnotation> getAnnotations4Axiom(String iri1, String iri2, double confidence, String relation) {
        OWLAnnotationProperty ann_property = this.factory.getOWLAnnotationProperty(IRI.create((String)this.iri_measure_str));
        OWLLiteral confidence_literal = this.factory.getOWLLiteral(confidence);
        OWLAnnotation ann_measure = this.factory.getOWLAnnotation(ann_property, (OWLAnnotationValue)confidence_literal);
        OWLAnnotationProperty ann_property_ent1 = this.factory.getOWLAnnotationProperty(IRI.create((String)this.iri_entity1_str));
        OWLLiteral ent1_literal = this.factory.getOWLLiteral(iri1);
        OWLAnnotation ann_ent1 = this.factory.getOWLAnnotation(ann_property_ent1, (OWLAnnotationValue)ent1_literal);
        OWLAnnotationProperty ann_property_ent2 = this.factory.getOWLAnnotationProperty(IRI.create((String)this.iri_entity2_str));
        OWLLiteral ent2_literal = this.factory.getOWLLiteral(iri2);
        OWLAnnotation ann_ent2 = this.factory.getOWLAnnotation(ann_property_ent2, (OWLAnnotationValue)ent2_literal);
        OWLAnnotationProperty ann_property_relation = this.factory.getOWLAnnotationProperty(IRI.create((String)this.iri_relation_str));
        OWLLiteral relation_literal = this.factory.getOWLLiteral(relation);
        OWLAnnotation ann_relation = this.factory.getOWLAnnotation(ann_property_relation, (OWLAnnotationValue)relation_literal);
        this.annSet.clear();
        this.annSet.add(ann_measure);
        this.annSet.add(ann_ent1);
        this.annSet.add(ann_ent2);
        this.annSet.add(ann_relation);
        return this.annSet;
    }

    @Override
    public void addClassMapping2Output(String iri1, String iri2, int dir_mapping, double conf) {
        if (dir_mapping == -2) {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createEquivalenceMapping(this.factory.getOWLClass(IRI.create((String)iri1)), this.factory.getOWLClass(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, "="))));
        } else if (dir_mapping == 0) {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createSubClassOfMapping(this.factory.getOWLClass(IRI.create((String)iri1)), this.factory.getOWLClass(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, "<"))));
        } else {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createSuperClassOfMapping(this.factory.getOWLClass(IRI.create((String)iri1)), this.factory.getOWLClass(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, ">"))));
        }
    }

    @Override
    public void addDataPropMapping2Output(String iri1, String iri2, int dir_mapping, double conf) {
        if (dir_mapping == -2) {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createDataPropertyEquivalenceMapping(this.factory.getOWLDataProperty(IRI.create((String)iri1)), this.factory.getOWLDataProperty(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, "="))));
        } else if (dir_mapping == 0) {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createSubDataPropertyMapping(this.factory.getOWLDataProperty(IRI.create((String)iri1)), this.factory.getOWLDataProperty(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, "<"))));
        } else {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createSuperDataPropertyMapping(this.factory.getOWLDataProperty(IRI.create((String)iri1)), this.factory.getOWLDataProperty(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, ">"))));
        }
    }

    @Override
    public void addObjPropMapping2Output(String iri1, String iri2, int dir_mapping, double conf) {
        if (dir_mapping == -2) {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createObjectPropertyEquivalenceMapping(this.factory.getOWLObjectProperty(IRI.create((String)iri1)), this.factory.getOWLObjectProperty(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, "="))));
        } else if (dir_mapping == 0) {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createSubObjectPropertyMapping(this.factory.getOWLObjectProperty(IRI.create((String)iri1)), this.factory.getOWLObjectProperty(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, "<"))));
        } else {
            this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createSuperObjectPropertyMapping(this.factory.getOWLObjectProperty(IRI.create((String)iri1)), this.factory.getOWLObjectProperty(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, ">"))));
        }
    }

    @Override
    public void addInstanceMapping2Output(String iri1, String iri2, double conf) throws Exception {
        this.listAxioms2Add.add((OWLOntologyChange)new AddAxiom(this.mappingsOnto, this.createSameIndividualMapping(this.factory.getOWLNamedIndividual(IRI.create((String)iri1)), this.factory.getOWLNamedIndividual(IRI.create((String)iri2)), this.getAnnotations4Axiom(iri1, iri2, conf, "="))));
    }

    @Override
    public void saveOutputFile() throws Exception {
        this.managerMappingsOnto.applyChanges(this.listAxioms2Add);
        this.managerMappingsOnto.saveOntology(this.mappingsOnto, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)this.output_file));
    }

    public OWLOntology getOWLOntology() throws Exception {
        this.managerMappingsOnto.applyChanges(this.listAxioms2Add);
        return this.mappingsOnto;
    }
}

