/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.labelling_schema;

import java.util.HashMap;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.IntervalLabelledHierarchy;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Node;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.PreNode;
import uk.ac.ox.krr.logmap2.io.LogOutput;

public class PreIntervalLabelledHierarchy
extends IntervalLabelledHierarchy {
    public static final int BASE_INDEX = 0;
    public static final int INDEX_INCREMENT = 1;

    public PreIntervalLabelledHierarchy(HashMap<Integer, Set<Integer>> ontoHierarchy, boolean clearStructures) {
        super(ontoHierarchy, clearStructures);
    }

    public PreIntervalLabelledHierarchy(HashMap<Integer, Set<Integer>> ontoHierarchy) {
        super(ontoHierarchy);
    }

    @Override
    protected Node createNode(int classId) {
        return new PreNode(classId);
    }

    @Override
    protected void walkDescendant() {
        this.walkDescNode(this.root, 0);
    }

    private int walkDescNode(Node node, int orderIndex) {
        node.setDescOrder(++orderIndex);
        for (Node child : node.getDescTreeChildren()) {
            if (node.equals(child)) {
                LogOutput.print("Same node as children: walkDescNode");
                continue;
            }
            orderIndex = this.walkDescNode(child, orderIndex);
        }
        node.setDescChildOrder(orderIndex);
        return orderIndex;
    }

    @Override
    protected void walkAscendant() {
        this.walkAscNode(this.leaf, 0);
    }

    private int walkAscNode(Node node, int orderIndex) {
        node.setAscOrder(++orderIndex);
        for (Node child : node.getAscTreeChildren()) {
            if (node.equals(child)) {
                LogOutput.print("Same node as children: walkAscNode");
                continue;
            }
            orderIndex = this.walkAscNode(child, orderIndex);
        }
        node.setAscChildOrder(orderIndex);
        return orderIndex;
    }
}

