/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.labelling_schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Interval;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Node;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.TopologicalSorting;
import uk.ac.ox.krr.logmap2.io.LogOutput;

public abstract class IntervalLabelledHierarchy {
    public static final int ROOT_LABEL = -100;
    public static final int LEAF_LABEL = -99;
    protected HashMap<Integer, Set<Integer>> ontoHierarchy;
    protected HashMap<Integer, Node> classesToNodesMap;
    protected Node root;
    protected Node leaf;
    protected List<Node> topoSortedNodes;

    public IntervalLabelledHierarchy(HashMap<Integer, Set<Integer>> ontoHierarchy, boolean clearStructures) {
        this.ontoHierarchy = ontoHierarchy;
        this.createClassesToNodesMap();
        this.createHierarchy();
        this.obtainRoot();
        this.obtainLeaf();
        if (this.leaf.getClassId().equals(-99)) {
            this.leaf.unattach();
        }
        this.obtainDescSpanningTree();
        this.walkDescendant();
        this.computeDescIntervals();
        if (this.root.getClassId().equals(-100)) {
            this.root.unattach();
        }
        if (this.leaf.getClassId().equals(-99)) {
            this.leaf.reattach();
        }
        this.obtainAscSpanningTree();
        this.walkAscendant();
        this.computeAscIntervals();
        if (this.leaf.getClassId().equals(-99)) {
            this.leaf.unattach();
        }
        if (clearStructures) {
            this.clearNodeStructures();
        }
    }

    public IntervalLabelledHierarchy(HashMap<Integer, Set<Integer>> ontoHierarchy) {
        this(ontoHierarchy, true);
    }

    protected abstract Node createNode(int var1);

    protected abstract void walkDescendant();

    protected abstract void walkAscendant();

    public Map<Integer, Node> getClassesToNodesMap() {
        return this.classesToNodesMap;
    }

    public boolean hasDescendant(int parentClassId, int childClassId) {
        Node parent = this.classesToNodesMap.get(parentClassId);
        Node child = this.classesToNodesMap.get(childClassId);
        if (parent == null) {
            throw new IllegalArgumentException("Parent class not found");
        }
        if (child == null) {
            throw new IllegalArgumentException("Child class not found");
        }
        int index = child.getDescOrder();
        for (Interval interval : parent.getDescIntervals()) {
            if (!interval.containsIndex(index)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAncestor(int childClassId, int parentClassId) {
        Node child = this.classesToNodesMap.get(childClassId);
        Node parent = this.classesToNodesMap.get(parentClassId);
        if (parent == null) {
            throw new IllegalArgumentException("Parent class not found");
        }
        if (child == null) {
            throw new IllegalArgumentException("Child class not found");
        }
        int index = parent.getAscOrder();
        for (Interval interval : child.getAscIntervals()) {
            if (!interval.containsIndex(index)) continue;
            return true;
        }
        return false;
    }

    private void createClassesToNodesMap() {
        this.classesToNodesMap = new HashMap();
        assert (this.ontoHierarchy != null);
        Iterator<Object> iterator = this.ontoHierarchy.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.classesToNodesMap.put(n, this.createNode(n));
        }
        for (Set set : this.ontoHierarchy.values()) {
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                int childId = (Integer)iterator2.next();
                if (this.classesToNodesMap.containsKey(childId)) continue;
                this.classesToNodesMap.put(childId, this.createNode(childId));
            }
        }
    }

    private void createHierarchy() {
        for (Map.Entry<Integer, Set<Integer>> entry : this.ontoHierarchy.entrySet()) {
            int classId = entry.getKey();
            Set<Integer> childrenIds = entry.getValue();
            Node node = this.classesToNodesMap.get(classId);
            for (int childId : childrenIds) {
                Node child = this.classesToNodesMap.get(childId);
                assert (child != null);
                node.addChild(child);
            }
        }
    }

    private void obtainRoot() {
        HashSet<Node> roots = new HashSet<Node>();
        for (Node node : this.classesToNodesMap.values()) {
            if (!node.isRoot()) continue;
            roots.add(node);
        }
        if (roots.size() > 1) {
            this.root = this.createNode(-100);
            for (Node node : roots) {
                this.root.addChild(node);
            }
        } else {
            this.root = (Node)roots.iterator().next();
        }
    }

    private void obtainLeaf() {
        HashSet<Node> leaves = new HashSet<Node>();
        for (Node node : this.classesToNodesMap.values()) {
            if (!node.isLeaf()) continue;
            leaves.add(node);
        }
        if (leaves.size() > 1) {
            this.leaf = this.createNode(-99);
            for (Node node : leaves) {
                node.addChild(this.leaf);
            }
        } else {
            this.leaf = (Node)leaves.iterator().next();
        }
    }

    private void obtainDescSpanningTree() {
        this.doTopologicalSort();
        for (Node node : this.topoSortedNodes) {
            Node maxPredsParent = null;
            int maxPreds = -1;
            for (Node parent : node.getParents()) {
                if (parent.getParents().size() <= maxPreds) continue;
                maxPredsParent = parent;
                maxPreds = parent.getParents().size();
            }
            node.setDescTreeParent(maxPredsParent);
        }
    }

    private void obtainAscSpanningTree() {
        this.doTopologicalSort();
        ListIterator<Node> iter = this.topoSortedNodes.listIterator(this.topoSortedNodes.size());
        while (iter.hasPrevious()) {
            Node node = iter.previous();
            Node maxPredsParent = null;
            int maxPreds = -1;
            for (Node parent : node.getChildren()) {
                if (parent.getChildren().size() <= maxPreds) continue;
                maxPredsParent = parent;
                maxPreds = parent.getChildren().size();
            }
            node.setAscTreeParent(maxPredsParent);
        }
    }

    private void computeDescIntervals() {
        this.doTopologicalSort();
        ListIterator<Node> iter = this.topoSortedNodes.listIterator(this.topoSortedNodes.size());
        while (iter.hasPrevious()) {
            Node node = iter.previous();
            for (Node child : node.getChildren()) {
                if (node.equals(child)) {
                    LogOutput.print("Same node as children: computeDescIntervals");
                    continue;
                }
                for (Interval interval : child.getDescIntervals()) {
                    node.addDescInterval(interval);
                }
            }
        }
    }

    private void computeAscIntervals() {
        this.doTopologicalSort();
        for (Node node : this.topoSortedNodes) {
            for (Node child : node.getParents()) {
                if (node.equals(child)) {
                    LogOutput.print("Same node as children: computeAscIntervals");
                    continue;
                }
                for (Interval interval : child.getAscIntervals()) {
                    node.addAscInterval(interval);
                }
            }
        }
    }

    private void clearNodeStructures() {
        for (Node node : this.classesToNodesMap.values()) {
            node.clearAuxiliarStructures();
        }
        this.ontoHierarchy.clear();
        this.ontoHierarchy = null;
    }

    protected void doTopologicalSort() {
        if (this.topoSortedNodes == null) {
            this.topoSortedNodes = new TopologicalSorting().sort(this.root);
        }
    }
}

