/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.entities;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.entities.EntityIndex;

public abstract class PropertyIndex
extends EntityIndex {
    public static int DATAPROPERTY = 0;
    public static int OBJECTPROPERTY = 1;
    protected int type_property;
    protected Set<Integer> domain = new HashSet<Integer>();
    private Set<String> alternativeLabels;

    public PropertyIndex(int i, int atype) {
        this.index = i;
        this.type_property = atype;
    }

    public int getPropertyType() {
        return this.type_property;
    }

    public boolean isObjectProperty() {
        return this.type_property == OBJECTPROPERTY;
    }

    public boolean isDataProperty() {
        return this.type_property == DATAPROPERTY;
    }

    public Set<Integer> getDomainClassIndexes() {
        return this.domain;
    }

    public void addDomainClassIndex(int icls) {
        this.domain.add(icls);
    }

    public void addAlternativeLabel(String altLabel) {
        if (this.alternativeLabels == null) {
            this.alternativeLabels = new HashSet<String>();
        }
        this.alternativeLabels.add(altLabel);
    }

    public void setAlternativeLabels(Set<String> altLabels) {
        this.alternativeLabels = new HashSet<String>(altLabels);
    }

    public void setEmptyAlternativeLabels() {
        this.alternativeLabels = new HashSet<String>();
    }

    public Set<String> getAlternativeLabels() {
        if (this.alternativeLabels == null) {
            return Collections.emptySet();
        }
        return this.alternativeLabels;
    }

    public boolean hasAlternativeLabels() {
        return this.alternativeLabels != null;
    }
}

