/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LightTarjan
implements Serializable {
    private static final long serialVersionUID = -3317618668787472814L;
    private int index = 0;
    private ArrayList<Integer> stack = new ArrayList();
    private Map<Integer, Set<Integer>> SCCs = new HashMap<Integer, Set<Integer>>();
    private int[] idx;
    private int[] lowlink;

    private Map<Integer, Set<Integer>> tarjan(Integer v, HashMap<Integer, Set<Integer>> graph) {
        this.idx[v.intValue()] = this.index;
        this.lowlink[v.intValue()] = this.index++;
        this.stack.add(0, v);
        if (graph.containsKey(v)) {
            for (Integer n : graph.get(v)) {
                if (this.idx[n] == -1) {
                    this.tarjan(n, graph);
                    this.lowlink[v.intValue()] = Math.min(this.lowlink[v], this.lowlink[n]);
                    continue;
                }
                if (!this.stack.contains(n)) continue;
                this.lowlink[v.intValue()] = Math.min(this.lowlink[v], this.idx[n]);
            }
        }
        if (this.lowlink[v] == this.idx[v]) {
            Integer n;
            HashSet<Integer> component = new HashSet<Integer>();
            do {
                n = this.stack.remove(0);
                component.add(n);
            } while (n != v);
            for (Integer i : component) {
                this.SCCs.put(i, component);
            }
        }
        return this.SCCs;
    }

    public Map<Integer, Set<Integer>> executeTarjan(HashMap<Integer, Set<Integer>> graph) {
        this.SCCs.clear();
        this.index = 0;
        this.stack.clear();
        assert (graph != null && !graph.isEmpty());
        HashSet<Integer> nodeList = new HashSet<Integer>(graph.keySet());
        for (Set<Integer> children : graph.values()) {
            nodeList.addAll(children);
        }
        assert (!nodeList.isEmpty());
        int maxId = nodeList.isEmpty() ? 0 : Collections.max(nodeList) + 1;
        this.idx = new int[maxId];
        Arrays.fill(this.idx, -1);
        this.lowlink = new int[maxId];
        Arrays.fill(this.lowlink, -1);
        for (Integer node : nodeList) {
            if (this.idx[node] != -1) continue;
            this.tarjan(node, graph);
        }
        return this.SCCs;
    }
}

