/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.division;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import uk.ac.ox.krr.logmap2.division.AbstractDivision;
import uk.ac.ox.krr.logmap2.division.BasicDivision;
import uk.ac.ox.krr.logmap2.division.MatchingTask;
import uk.ac.ox.krr.logmap2.division.OntologyAlignmentDivision;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.statistics.StatisticsTimeMappings;

public class BasicDivisionPredictor
extends AbstractDivision
implements OntologyAlignmentDivision {
    int required_module_size;
    int max_number_tasks = 500;
    int predicted_number_tasks = -1;
    boolean strict_requirement = false;
    List<Integer> number_tasks_list = new ArrayList<Integer>();

    public BasicDivisionPredictor(int required_module_size, boolean strict_requirement) {
        this.required_module_size = required_module_size;
        this.strict_requirement = strict_requirement;
    }

    public void setMaxNumbertasks(int max_number_tasks) {
        this.max_number_tasks = max_number_tasks;
    }

    @Override
    public List<MatchingTask> createPartitionedMatchingTasks(OWLOntology source, OWLOntology target) throws OWLOntologyCreationException, Exception {
        StatisticsTimeMappings.setInitGlobalTime();
        List<MatchingTask> tasks = null;
        this.predicted_number_tasks = -1;
        this.createTaskSizesList();
        for (int n_tasks : this.number_tasks_list) {
            BasicDivision partitioning = new BasicDivision(n_tasks);
            partitioning.setNumTask2Outout(1);
            tasks = partitioning.createPartitionedMatchingTasks(source, target);
            if ((tasks.get(0).getSignatureSourceOntology().size() > this.required_module_size || tasks.get(0).getSignatureTargetOntology().size() > this.required_module_size) && (this.strict_requirement || tasks.get(0).getSignatureSourceOntology().size() > this.required_module_size && tasks.get(0).getSignatureTargetOntology().size() > this.required_module_size)) continue;
            this.predicted_number_tasks = n_tasks;
            LogOutput.print("\tPREDICTED NUMBER TASKS: " + this.predicted_number_tasks);
            break;
        }
        if (this.predicted_number_tasks < 0) {
            System.err.println("The required module size is too small for the maximun number of tasks set to '" + this.max_number_tasks + "'. The current maximum number of tasks leads to modules of size (approximately): " + tasks.get(0).getSignatureSourceOntology().size() + " in the source ontoology, and " + tasks.get(0).getSignatureTargetOntology().size() + " in the target ontology.");
            tasks = new ArrayList<MatchingTask>();
        } else {
            BasicDivision partitioning = new BasicDivision(this.predicted_number_tasks);
            tasks = partitioning.createPartitionedMatchingTasks(source, target);
        }
        this.total_time = StatisticsTimeMappings.getTotalRunningTime();
        LogOutput.print("Total time (s): " + this.total_time);
        return tasks;
    }

    private void createTaskSizesList() {
        this.number_tasks_list.add(1);
        this.number_tasks_list.add(2);
        this.number_tasks_list.add(5);
        this.number_tasks_list.add(10);
        this.number_tasks_list.add(20);
        this.number_tasks_list.add(30);
        int size = 50;
        int i = 1;
        while (i * size < this.max_number_tasks) {
            this.number_tasks_list.add(i * size);
            ++i;
        }
    }

    @Override
    public List<MatchingTask> createPartitionedMatchingTasks(String sourceIRIStr, String targetIRIStr) throws OWLOntologyCreationException, Exception {
        return this.createPartitionedMatchingTasks(this.loadOWLOntology(sourceIRIStr), this.loadOWLOntology(targetIRIStr));
    }
}

