/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.division;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.syntactic_locality.OntologyModuleExtractor;
import uk.ac.ox.krr.logmap2.division.MatchingTask;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.overlapping.OntologyProcessing4Overlapping;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;

public abstract class AbstractDivision {
    protected OntologyProcessing4Overlapping source_processing;
    protected OntologyProcessing4Overlapping target_processing;
    protected boolean use_full_overlapping = true;
    protected Set<Set<String>> if_intersection;
    protected Set<OWLAxiom> overlapping_source;
    protected Set<OWLAxiom> overlapping_target;
    protected Set<OWLEntity> entities_source = new HashSet<OWLEntity>();
    protected Set<OWLEntity> entities_target = new HashSet<OWLEntity>();
    protected OntologyModuleExtractor module_extractor_source;
    protected OntologyModuleExtractor module_extractor_target;
    protected double total_time = 0.0;
    protected long size_source_ontology;
    protected long size_target_ontology;

    protected OWLOntology loadOWLOntology(String phy_iri_onto) throws OWLOntologyCreationException {
        try {
            OWLOntologyManager managerOnto = SynchronizedOWLManager.createOWLOntologyManager();
            OWLOntologyLoaderConfiguration conf = new OWLOntologyLoaderConfiguration();
            conf.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
            return managerOnto.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new IRIDocumentSource(IRI.create((String)phy_iri_onto)), conf);
        }
        catch (Exception e) {
            System.err.println("Error loading OWL ontology: " + e.getMessage());
            throw new OWLOntologyCreationException();
        }
    }

    public double getComputationTime() {
        return this.total_time;
    }

    public long getSizeSourceOntology() {
        return this.size_source_ontology;
    }

    public long getSizeTargetOntology() {
        return this.size_target_ontology;
    }

    public void clear() {
        try {
            this.source_processing.clearStructures();
            this.target_processing.clearStructures();
            this.source_processing.clearClass2Identifier();
            this.target_processing.clearClass2Identifier();
            this.if_intersection.clear();
            this.entities_source.clear();
            this.entities_target.clear();
            this.module_extractor_source.clearStrutures();
            this.module_extractor_target.clearStrutures();
            this.overlapping_source.clear();
            this.overlapping_target.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setUpModuleExtractors(Set<OWLAxiom> source_ax, Set<OWLAxiom> target_ax) {
        this.module_extractor_source = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), source_ax, true, false, true);
        this.module_extractor_target = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), target_ax, true, false, true);
    }

    protected MatchingTask createMatchingTask(String uri_source, String uri_target, List<Set<String>> list_if_entries, int n_task, int size_groups) throws OWLOntologyCreationException {
        int lower_bound = n_task * size_groups;
        int upper_bound = (n_task + 1) * size_groups;
        if (upper_bound > list_if_entries.size()) {
            upper_bound = list_if_entries.size();
        }
        this.entities_source.clear();
        this.entities_target.clear();
        for (int i = lower_bound; i < upper_bound; ++i) {
            Set<String> set_words = list_if_entries.get(i);
            for (int ide1 : this.source_processing.getWeakInvertedFile().get(set_words)) {
                this.entities_source.add((OWLEntity)this.source_processing.getClass4identifier(ide1));
            }
            for (int ide2 : this.target_processing.getWeakInvertedFile().get(set_words)) {
                this.entities_target.add((OWLEntity)this.target_processing.getClass4identifier(ide2));
            }
        }
        return new MatchingTask(this.module_extractor_source.extractAsOntology(this.entities_source, IRI.create((String)(uri_source + "-Task-" + n_task))), this.module_extractor_target.extractAsOntology(this.entities_target, IRI.create((String)(uri_target + "-Task-" + n_task))));
    }

    protected MatchingTask createMatchingTask(String uri_source, String uri_target, Set<Set<String>> set_if_entries, int n_task, int max_ambiguity, boolean change_ontology_uri) throws OWLOntologyCreationException {
        this.entities_source.clear();
        this.entities_target.clear();
        for (Set<String> set_words : set_if_entries) {
            int num_ids2;
            int num_ids1;
            if (!this.source_processing.getWeakInvertedFile().containsKey(set_words) || !this.target_processing.getWeakInvertedFile().containsKey(set_words) || (num_ids1 = this.source_processing.getWeakInvertedFile().get(set_words).size()) + (num_ids2 = this.target_processing.getWeakInvertedFile().get(set_words).size()) > max_ambiguity) continue;
            try {
                for (int ide1 : this.source_processing.getWeakInvertedFile().get(set_words)) {
                    this.entities_source.add((OWLEntity)this.source_processing.getClass4identifier(ide1));
                }
                for (int ide2 : this.target_processing.getWeakInvertedFile().get(set_words)) {
                    this.entities_target.add((OWLEntity)this.target_processing.getClass4identifier(ide2));
                }
            }
            catch (Exception e) {
            }
        }
        if (change_ontology_uri) {
            return new MatchingTask(this.module_extractor_source.extractAsOntology(this.entities_source, IRI.create((String)(uri_source + "-Task-" + n_task))), this.module_extractor_target.extractAsOntology(this.entities_target, IRI.create((String)(uri_target + "-Task-" + n_task))));
        }
        return new MatchingTask(this.module_extractor_source.extractAsOntology(this.entities_source, IRI.create((String)uri_source)), this.module_extractor_target.extractAsOntology(this.entities_target, IRI.create((String)uri_target)));
    }

    protected MatchingTask createMatchingTask(String uri_source, String uri_target, int n_task, Set<Integer> concept_ids) throws OWLOntologyCreationException {
        this.entities_source.clear();
        this.entities_target.clear();
        for (int concept_id : concept_ids) {
            try {
                if (concept_id <= this.source_processing.getLastidentifier()) {
                    this.entities_source.add((OWLEntity)this.source_processing.getClass4identifier(concept_id));
                    continue;
                }
                this.entities_target.add((OWLEntity)this.target_processing.getClass4identifier(concept_id));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new MatchingTask(this.module_extractor_source.extractAsOntology(this.entities_source, IRI.create((String)(uri_source + "-Task-" + n_task))), this.module_extractor_target.extractAsOntology(this.entities_target, IRI.create((String)(uri_target + "-Task-" + n_task))));
    }

    protected OntologyProcessing4Overlapping createInvertedFile(OWLOntology ontology, LexicalUtilities lexicalUtilities, boolean use_full_overlapping, int init_index) {
        OntologyProcessing4Overlapping ontology_processing = new OntologyProcessing4Overlapping(ontology, lexicalUtilities, use_full_overlapping, true, init_index);
        ontology_processing.processOntologyClassLabels();
        ontology_processing.setInvertedFile4Overlapping();
        return ontology_processing;
    }

    protected Set<OWLAxiom> createOverlappingEstimation(OWLOntology ontology, Set<OWLEntity> entities) {
        OntologyModuleExtractor module_extractor = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), ontology.getAxioms(), true, false, true);
        HashSet<OWLAxiom> overlapping = new HashSet<OWLAxiom>();
        overlapping.addAll(module_extractor.extract(entities));
        module_extractor.clearStrutures();
        entities.clear();
        return overlapping;
    }

    protected OWLOntology createOverlappingEstimationAsOntology(OWLOntology ontology, Set<OWLEntity> entities, String uri) throws OWLOntologyCreationException {
        OntologyModuleExtractor module_extractor = new OntologyModuleExtractor(SynchronizedOWLManager.createOWLOntologyManager(), ontology.getAxioms(), true, false, true);
        OWLOntology overlapping = module_extractor.extractAsOntology(entities, IRI.create((String)uri));
        module_extractor.clearStrutures();
        entities.clear();
        return overlapping;
    }
}

