/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.bioportal;

import uk.ac.ox.krr.logmap2.bioportal.BioPortalOntologyInfo;

public class CandidateMediatingOntology {
    private BioPortalOntologyInfo bioportal_ontology;
    private int positive_hits = 1;
    private int num_sysnonyms;
    private final int MAX_SIZE_ONTOLOGY = 100000;
    private final int MIN_SIZE_ONTOLOGY = 10;

    public CandidateMediatingOntology(BioPortalOntologyInfo bio_onto, int syn_size) {
        this.num_sysnonyms = syn_size;
        this.bioportal_ontology = bio_onto;
    }

    public void increasePositiveHits() {
        ++this.positive_hits;
    }

    public void increaseNumberOfProvidedSynonyms(int syn_size) {
        this.num_sysnonyms += syn_size;
    }

    public int getPositiveHits() {
        return this.positive_hits;
    }

    public int getNumberOfProvidedSynonyms() {
        return this.num_sysnonyms;
    }

    public int getNumberOfClasses() {
        return this.bioportal_ontology.getNumberOfClasses();
    }

    public String getOntologyLanguage() {
        return this.bioportal_ontology.getOntologyLanguage();
    }

    public int getSuitabilityValue() {
        if (this.bioportal_ontology.getNumberOfClasses() > 100000 || this.bioportal_ontology.getNumberOfClasses() < 10) {
            return -1;
        }
        if (!this.bioportal_ontology.getOntologyLanguage().equals("OWL") && !this.bioportal_ontology.getOntologyLanguage().equals("OBO")) {
            return -1;
        }
        return this.positive_hits;
    }

    public String getOntologyAcronym() {
        return this.bioportal_ontology.getAcronym();
    }

    public int hashCode() {
        return 30 * this.getOntologyAcronym().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CandidateMediatingOntology) {
            return this.equals((CandidateMediatingOntology)obj);
        }
        return false;
    }

    public boolean equals(CandidateMediatingOntology mo) {
        return this.getOntologyAcronym().equals(mo.getOntologyAcronym());
    }
}

