/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.ox.krr.logmap2.LogMap2_RepairFacility;
import uk.ac.ox.krr.logmap2.OntologyLoader;
import uk.ac.ox.krr.logmap2.indexing.JointIndexManager;
import uk.ac.ox.krr.logmap2.indexing.OntologyProcessing;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OutPutFilesManager;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.mappings.CandidateMappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReaderManager;
import uk.ac.ox.krr.logmap2.overlapping.OverlappingExtractor4Mappings;
import uk.ac.ox.krr.logmap2.reasoning.SatisfiabilityIntegration;
import uk.ac.ox.krr.logmap2.repair.AnchorAssessment;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class LogMap3_RepairFacility {
    private long init_global;
    private long init;
    private long fin;
    private OntologyProcessing onto_process1;
    private OntologyProcessing onto_process2;
    private JointIndexManager index;
    private CandidateMappingManager mapping_manager;
    private AnchorAssessment mapping_assessment;
    private OWLOntology onto1;
    private OWLOntology onto2;
    private Set<MappingObjectStr> fixed_mappings;
    private Set<MappingObjectStr> mappings2review;
    private boolean overlapping;
    Set<MappingObjectStr> input_mappings = new HashSet<MappingObjectStr>();
    private Set<MappingObjectStr> clean_mappings = new HashSet<MappingObjectStr>();
    int num_anchors = 0;
    int num_mappings2review = 0;

    public LogMap3_RepairFacility(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> fixed_mappings, Set<MappingObjectStr> mappings2review) {
        this.onto1 = onto1;
        this.onto2 = onto2;
        this.fixed_mappings = fixed_mappings;
        this.overlapping = false;
        this.mappings2review = mappings2review;
        this.input_mappings.addAll(fixed_mappings);
        this.input_mappings.addAll(mappings2review);
        try {
            this.init_global = this.init = Calendar.getInstance().getTimeInMillis();
            this.setUpStructures();
            this.assessMappings();
            this.keepRepairedMappings();
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.printAlways("TOTAL REPAIR TIME (s): " + (double)((float)((double)this.fin - (double)this.init_global)) / 1000.0);
        }
        catch (Exception e) {
            System.out.println("Error repairing mappings using LogMap repair module: " + e.getMessage());
        }
    }

    private void addMapping2Structures() {
        for (MappingObjectStr map : this.fixed_mappings) {
            if (map.getTypeOfMapping() == 0) {
                this.addClassMapping(map, true);
                continue;
            }
            if (map.getTypeOfMapping() == 2) {
                this.addObjectPropertyMapping(map);
                continue;
            }
            if (map.getTypeOfMapping() == 1) {
                this.addDataPropertyMapping(map);
                continue;
            }
            if (map.getTypeOfMapping() != 3) continue;
            this.addInstanceMapping(map);
        }
        for (MappingObjectStr map : this.mappings2review) {
            if (map.getTypeOfMapping() == 0) {
                this.addClassMapping(map, false);
                continue;
            }
            if (map.getTypeOfMapping() == 2) {
                this.addObjectPropertyMapping(map);
                continue;
            }
            if (map.getTypeOfMapping() == 1) {
                this.addDataPropertyMapping(map);
                continue;
            }
            if (map.getTypeOfMapping() != 3) continue;
            this.addInstanceMapping(map);
        }
    }

    private void setUpStructures() throws Exception {
        LogOutput.showOutpuLog(false);
        this.index = new JointIndexManager();
        if (this.overlapping) {
            OverlappingExtractor4Mappings overlapping = new OverlappingExtractor4Mappings();
            overlapping.createOverlapping(this.onto1, this.onto2, this.input_mappings);
            this.onto_process1 = new OntologyProcessing(overlapping.getOverlappingOnto1(), this.index, new LexicalUtilities());
            this.onto_process2 = new OntologyProcessing(overlapping.getOverlappingOnto2(), this.index, new LexicalUtilities());
        } else {
            this.onto_process1 = new OntologyProcessing(this.onto1, this.index, new LexicalUtilities());
            this.onto_process2 = new OntologyProcessing(this.onto2, this.index, new LexicalUtilities());
        }
        this.mapping_manager = new CandidateMappingManager(this.index, this.onto_process1, this.onto_process2);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.precessLexicon(false);
        this.onto_process2.precessLexicon(false);
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time indexing entities (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.setTaxonomicData();
        this.onto_process2.setTaxonomicData();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time extracting structural information (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.addMapping2Structures();
        this.onto_process1.clearReasoner();
        this.onto_process1.getClass2Identifier().clear();
        this.onto_process2.clearReasoner();
        this.onto_process2.getClass2Identifier().clear();
    }

    private void assessMappings() {
        this.assessClassMappings(this.mapping_manager.getMappings2Review());
        if (this.mapping_manager.getDataPropertyAnchors().size() > 0 || this.mapping_manager.getObjectPropertyAnchors().size() > 0) {
            this.init = Calendar.getInstance().getTimeInMillis();
            this.mapping_manager.evaluateCompatibilityDataPropertyMappings();
            this.mapping_manager.evaluateCompatibilityObjectPropertyMappings();
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime assessing property mappings (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        }
        if (this.mapping_manager.getInstanceMappings().size() > 0) {
            this.init = Calendar.getInstance().getTimeInMillis();
            this.mapping_manager.evaluateCompatibilityInstanceMappings();
            if (this.mapping_manager.getInstanceMappings().size() > 0) {
                this.init = Calendar.getInstance().getTimeInMillis();
                this.mapping_assessment.CheckSatisfiabilityOfIntegration_DandG_Individuals(this.mapping_manager.getInstanceMappings());
                this.fin = Calendar.getInstance().getTimeInMillis();
                LogOutput.print("Time cleaning instance mappings D&G (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
            }
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime assessing instance mappings (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        }
    }

    private void assessClassMappings(Map<Integer, Set<Integer>> mappings) {
        this.mapping_manager.setExactAsFixed(true);
        this.mapping_assessment = new AnchorAssessment(this.index, this.mapping_manager);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.mapping_assessment.CheckSatisfiabilityOfIntegration_DandG(mappings);
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\tTime cleaning class mappings Dowling and Gallier (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        LogOutput.print("\tRepaired Root Unsat using Dowling and Gallier (aproximation): " + this.mapping_assessment.getNumRepairedUnsatClasses());
        this.mapping_manager.moveMappingsToReview2AnchorList();
        try {
            this.init = Calendar.getInstance().getTimeInMillis();
            this.index.setIntervalLabellingIndex(this.mapping_manager.getLogMapMappings());
            this.index.clearAuxStructuresforLabellingSchema();
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime indexing hierarchy + anchors (ILS) (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        }
        catch (Exception e) {
            System.out.println("Error creating Interval Labelling index: " + e.getMessage());
            e.printStackTrace();
        }
        for (int ide1 : this.mapping_manager.getWeakenedDandGMappings().keySet()) {
            for (int ide2 : this.mapping_manager.getWeakenedDandGMappings().get(ide1)) {
                if (this.mapping_manager.isMappingInConflictWithFixedMappings(ide1, ide2)) continue;
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
            }
        }
    }

    private void addClassMapping(MappingObjectStr map, boolean fixed) {
        int ide1 = this.onto_process1.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Classes not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addIsub2Structure(ide1, ide2, map.getConfidence());
        this.mapping_manager.addIsub2Structure(ide2, ide1, map.getConfidence());
        if (fixed) {
            if (map.getMappingDirection() == -2) {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
                this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
            } else if (map.getMappingDirection() == 0) {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
            } else {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
            }
        } else if (map.getMappingDirection() == -2) {
            this.mapping_manager.addSubMapping2Mappings2Review(ide1, ide2);
            this.mapping_manager.addSubMapping2Mappings2Review(ide2, ide1);
        } else if (map.getMappingDirection() == 0) {
            this.mapping_manager.addSubMapping2Mappings2Review(ide1, ide2);
        } else {
            this.mapping_manager.addSubMapping2Mappings2Review(ide2, ide1);
        }
    }

    private void addObjectPropertyMapping(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4ObjectPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4ObjectPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Object properties not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addObjectPropertyAnchor(ide1, ide2);
        this.mapping_manager.addObjectPropertyAnchorConfidence(ide1, map.getConfidence());
    }

    private void addDataPropertyMapping(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4DataPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4DataPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Data properties not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addDataPropertyAnchor(ide1, ide2);
        this.mapping_manager.addDataPropertyAnchorConfidence(ide1, map.getConfidence());
    }

    private void addInstanceMapping(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4InstanceName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4InstanceName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Individuals not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addInstanceMapping(ide1, ide2);
        this.mapping_manager.addInstanceAnchorConfidence(ide1, ide2, map.getConfidence());
    }

    public void saveRepairedMappings(String outPutFileName) {
        this.saveRepairedMappings(outPutFileName, 4);
    }

    public void saveRepairedMappings(String outPutFileName, int format) {
        OutPutFilesManager outPutFilesManager = new OutPutFilesManager();
        int num_clean_mappings = 0;
        int num_clean_class_mappings = 0;
        int num_clean_dprop_mappings = 0;
        int num_clean_oprop_mappings = 0;
        int num_clean_instance_mappings = 0;
        try {
            outPutFilesManager.createOutFiles(outPutFileName, format, this.onto_process1.getOntoIRI(), this.onto_process1.getOntoIRI());
            for (int idea : this.mapping_manager.getLogMapMappings().keySet()) {
                for (int ideb : this.mapping_manager.getLogMapMappings().get(idea)) {
                    if (this.mapping_manager.isId1SmallerThanId2(idea, ideb)) {
                        int dirMapping = this.mapping_manager.isMappingAlreadyInList(ideb, idea) ? -2 : 0;
                        ++num_clean_mappings;
                        ++num_clean_class_mappings;
                        outPutFilesManager.addClassMapping2Files(this.index.getIRIStr4ConceptIndex(idea), this.index.getIRIStr4ConceptIndex(ideb), dirMapping, this.mapping_manager.getConfidence4Mapping(idea, ideb));
                        continue;
                    }
                    if (this.mapping_manager.isMappingAlreadyInList(ideb, idea)) continue;
                    ++num_clean_mappings;
                    ++num_clean_class_mappings;
                    outPutFilesManager.addClassMapping2Files(this.index.getIRIStr4ConceptIndex(ideb), this.index.getIRIStr4ConceptIndex(idea), -1, this.mapping_manager.getConfidence4Mapping(idea, ideb));
                }
            }
            for (int ide1 : this.mapping_manager.getDataPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_dprop_mappings;
                outPutFilesManager.addDataPropMapping2Files(this.index.getIRIStr4DataPropIndex(ide1), this.index.getIRIStr4DataPropIndex(this.mapping_manager.getDataPropertyAnchors().get(ide1)), -2, this.mapping_manager.getConfidence4DataPropertyAnchor(ide1, this.mapping_manager.getDataPropertyAnchors().get(ide1)));
            }
            for (int ide1 : this.mapping_manager.getObjectPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_oprop_mappings;
                outPutFilesManager.addObjPropMapping2Files(this.index.getIRIStr4ObjPropIndex(ide1), this.index.getIRIStr4ObjPropIndex(this.mapping_manager.getObjectPropertyAnchors().get(ide1)), -2, this.mapping_manager.getConfidence4ObjectPropertyAnchor(ide1, this.mapping_manager.getObjectPropertyAnchors().get(ide1)));
            }
            for (int ide1 : this.mapping_manager.getInstanceMappings().keySet()) {
                for (int ide2 : this.mapping_manager.getInstanceMappings().get(ide1)) {
                    ++num_clean_mappings;
                    ++num_clean_instance_mappings;
                    outPutFilesManager.addInstanceMapping2Files(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), this.mapping_manager.getConfidence4InstanceMapping(ide1, ide2));
                }
            }
            LogOutput.printAlways("Num repaired mappings: " + num_clean_mappings);
            LogOutput.print("\tNum repaired class mappings: " + num_clean_class_mappings);
            LogOutput.print("\tNum repaired object property mappings: " + num_clean_oprop_mappings);
            LogOutput.print("\tNum repaired data property mappings: " + num_clean_dprop_mappings);
            LogOutput.print("\tNum repaired instance mappings: " + num_clean_instance_mappings);
            outPutFilesManager.closeAndSaveFiles();
        }
        catch (Exception e) {
            System.err.println("Error saving mappings...");
            e.printStackTrace();
        }
    }

    public Set<MappingObjectStr> getCleanMappings() {
        return this.clean_mappings;
    }

    public Set<MappingObjectStr> getInputMappings() {
        return this.input_mappings;
    }

    public int getSizeOfRepair() {
        int clauses = 0;
        for (int ide1 : this.mapping_manager.getConflictiveMappings().keySet()) {
            clauses += this.mapping_manager.getConflictiveMappings().get(ide1).size();
        }
        return clauses;
    }

    public void checkSatisfiabilityInputMappings() throws Exception {
        this.checkSatisfiabilityMappings(this.input_mappings);
    }

    public void checkSatisfiabilityCleanMappings() throws Exception {
        this.checkSatisfiabilityMappings(this.clean_mappings);
    }

    public void checkSatisfiabilityMappings(Set<MappingObjectStr> mappings) throws Exception {
        OWLOntology mappins_owl_onto = this.getOWLOntology4GivenMappings(mappings);
        SatisfiabilityIntegration.setTimeoutClassSatisfiabilityCheck(60);
        SatisfiabilityIntegration sat_checker = new SatisfiabilityIntegration(this.onto1, this.onto2, mappins_owl_onto, true, true, false);
        LogOutput.print("Num unsat classes lead by repaired mappings using LogMap: " + sat_checker.getNumUnsatClasses());
    }

    public OWLOntology getOWLOntology4CleanMappings() throws Exception {
        return this.getOWLOntology4GivenMappings(this.clean_mappings);
    }

    public OWLOntology getOWLOntology4GivenMappings(Set<MappingObjectStr> mappings) throws Exception {
        OWLAlignmentFormat owlformat = new OWLAlignmentFormat("");
        for (MappingObjectStr mapping : mappings) {
            if (mapping.getTypeOfMapping() == 12) {
                owlformat.addInstanceMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() == 0) {
                owlformat.addClassMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() == 2) {
                owlformat.addObjPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() != 1) continue;
            owlformat.addDataPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
        }
        return owlformat.getOWLOntology();
    }

    private void keepRepairedMappings() {
        int num_clean_mappings = 0;
        int num_clean_class_mappings = 0;
        int num_clean_dprop_mappings = 0;
        int num_clean_oprop_mappings = 0;
        int num_clean_instance_mappings = 0;
        this.clean_mappings.clear();
        try {
            for (int idea : this.mapping_manager.getLogMapMappings().keySet()) {
                for (int ideb : this.mapping_manager.getLogMapMappings().get(idea)) {
                    if (this.mapping_manager.isId1SmallerThanId2(idea, ideb)) {
                        int dirMapping = this.mapping_manager.isMappingAlreadyInList(ideb, idea) ? -2 : 0;
                        ++num_clean_mappings;
                        ++num_clean_class_mappings;
                        this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ConceptIndex(idea), this.index.getIRIStr4ConceptIndex(ideb), this.mapping_manager.getConfidence4Mapping(idea, ideb), dirMapping, 0));
                        continue;
                    }
                    if (this.mapping_manager.isMappingAlreadyInList(ideb, idea)) continue;
                    ++num_clean_mappings;
                    ++num_clean_class_mappings;
                    this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ConceptIndex(ideb), this.index.getIRIStr4ConceptIndex(idea), this.mapping_manager.getConfidence4Mapping(idea, ideb), -1, 0));
                }
            }
            for (int ide1 : this.mapping_manager.getDataPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_dprop_mappings;
                this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ConceptIndex(ide1), this.index.getIRIStr4DataPropIndex(this.mapping_manager.getDataPropertyAnchors().get(ide1)), this.mapping_manager.getConfidence4DataPropertyAnchor(ide1, this.mapping_manager.getDataPropertyAnchors().get(ide1)), -2, 1));
            }
            for (int ide1 : this.mapping_manager.getObjectPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_oprop_mappings;
                this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ObjPropIndex(ide1), this.index.getIRIStr4ObjPropIndex(this.mapping_manager.getObjectPropertyAnchors().get(ide1)), this.mapping_manager.getConfidence4ObjectPropertyAnchor(ide1, this.mapping_manager.getObjectPropertyAnchors().get(ide1)), -2, 2));
            }
            for (int ide1 : this.mapping_manager.getInstanceMappings().keySet()) {
                for (int ide2 : this.mapping_manager.getInstanceMappings().get(ide1)) {
                    ++num_clean_mappings;
                    ++num_clean_instance_mappings;
                    this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), this.mapping_manager.getConfidence4InstanceMapping(ide1, ide2), -2, 3));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error keeping mappings...");
            e.printStackTrace();
        }
    }

    private static Set<MappingObjectStr> emptyMappings() throws Exception {
        HashSet<MappingObjectStr> mappings = new HashSet<MappingObjectStr>();
        mappings.add(new MappingObjectStr("http://csu6325.cs.ox.ac.uk/ontologies/matching_21_05_2012/emptyOntology.owl#lala", "http://csu6325.cs.ox.ac.uk/ontologies/matching_31_05_2012/ontology_31_05_2012__18_53_50_221#lala", 1.0, -2));
        return mappings;
    }

    private static Set<MappingObjectStr> readMappings(String file) throws Exception {
        HashSet<MappingObjectStr> mappings = new HashSet<MappingObjectStr>();
        ReadFile reader = new ReadFile(file);
        String line = reader.readLine();
        while (line != null) {
            if (line.indexOf("|") < 0) {
                line = reader.readLine();
                continue;
            }
            String[] elements = line.split("\\|");
            if (elements.length < 4) continue;
            int dir = elements[2].equals(">") ? -1 : (elements[2].equals("<") ? 0 : -2);
            mappings.add(new MappingObjectStr(elements[0], elements[1], Double.valueOf(elements[3]), dir));
            line = reader.readLine();
        }
        reader.closeBuffer();
        return mappings;
    }

    private static String getHelpMessage() {
        return "LogMap's repair facility requires 7 parameters:\n\t1. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t2. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t3. Format mappings e.g.: OWL  or  RDF  or  TXT\n\t4. Full IRI or full Path:\n\t\ta. Full IRI of input mappings if OWL format. e.g.: file:/C://mymappings.owl  or  file:/usr/local/mymappings.owl  or http://mymappings.owl\n\t\tb. Full path of input mappings if formats RDF or TXT. e.g.: C://mymappings.rdf  or  /usr/local/mymappings.txt\n\t5. Full output path for the repaired mappings: e.g. /usr/local/output_path or C://output_path\n\t6. Extract modules for repair?: true or false\n\t7. Check satisfiability after repair using HermiT? true or false\n";
    }

    public static void main(String[] args) {
        try {
            if (args.length != 7) {
                System.out.println(LogMap3_RepairFacility.getHelpMessage());
                return;
            }
            String iri_onto1 = args[0];
            String iri_onto2 = args[1];
            String format_mappings = args[2];
            String input_mappings_path = args[3];
            String output_path = args[4];
            boolean overlapping = Boolean.valueOf(args[5]);
            boolean satisfiability_check = Boolean.valueOf(args[6]);
            LogOutput.printAlways("Loading ontologies...");
            OntologyLoader loader1 = new OntologyLoader(iri_onto1);
            OntologyLoader loader2 = new OntologyLoader(iri_onto2);
            LogOutput.printAlways("...Done");
            MappingsReaderManager readermanager = new MappingsReaderManager(input_mappings_path, format_mappings);
            new LogMap2_RepairFacility(loader1.getOWLOntology(), loader2.getOWLOntology(), readermanager.getMappingObjects(), overlapping, false, satisfiability_check, output_path + "/mappings_repaired_with_LogMap");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MappingComparator
    implements Comparator<MappingObjectStr> {
        private MappingComparator() {
        }

        @Override
        public int compare(MappingObjectStr m1, MappingObjectStr m2) {
            if (m1.getConfidence() < m2.getConfidence()) {
                return -1;
            }
            return 1;
        }
    }
}

