/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.modularity.OntologySegmenter;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.search.EntitySearcher;
import uk.ac.manchester.syntactic_locality.SyntacticLocalityChecker;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;

public class OntologyModuleExtractor
implements OntologySegmenter {
    private OWLOntologyManager ontologyManager;
    private OWLDataFactory dataFactory;
    private Set<OWLAxiom> ontologyAxioms;
    private Map<OWLEntity, Set<OWLAxiom>> entity2Axioms = new HashMap<OWLEntity, Set<OWLAxiom>>();
    private SyntacticLocalityChecker localityChecker;
    private boolean considerAnnotations = false;
    private boolean ignoreAssertions = false;
    private Set<OWLAxiom> moduleAxioms = new HashSet<OWLAxiom>();
    private Set<OWLEntity> moduleSignature = new HashSet<OWLEntity>();
    private Set<OWLEntity> inputSignature = new HashSet<OWLEntity>();
    private List<OWLEntity> newMembers = new ArrayList<OWLEntity>();
    private boolean useOptimization;
    private boolean includeDeclarationAxioms = false;
    private TYPEMODULE typeModule = TYPEMODULE.BOTTOM_LOCALITY;
    private Set<OWLAxiom> axiomsIterations = new HashSet<OWLAxiom>();

    public OntologyModuleExtractor(OWLOntology ontology) {
        this(ontology, true, false, false, false);
    }

    public OntologyModuleExtractor(OWLOntology ontology, boolean considerImportsClosure, boolean considerEntityAnnotations, boolean ignoreAssertions, boolean useOptimization) {
        this(OntologyModuleExtractor.getAxioms(ontology, considerImportsClosure, considerEntityAnnotations, ignoreAssertions), considerEntityAnnotations, ignoreAssertions, useOptimization);
    }

    public OntologyModuleExtractor(Set<OWLAxiom> ontoAxioms) {
        this(ontoAxioms, false, false, false);
    }

    public OntologyModuleExtractor(OWLOntologyManager manager, OWLOntology ontology, TYPEMODULE typeModule) {
        this.ontologyManager = manager;
        this.ontologyAxioms = ontology.getAxioms();
        this.typeModule = typeModule;
        this.considerAnnotations = false;
        this.ignoreAssertions = false;
        this.useOptimization = true;
        this.indexEntities();
    }

    public OntologyModuleExtractor(Set<OWLAxiom> ontoAxioms, boolean considerEntityAnnotations, boolean ignoreAssertions, boolean useOptimization) {
        this.ontologyAxioms = ontoAxioms;
        this.considerAnnotations = considerEntityAnnotations;
        this.ignoreAssertions = ignoreAssertions;
        this.useOptimization = useOptimization;
        if (useOptimization) {
            this.indexEntities();
        }
    }

    public OntologyModuleExtractor(OWLOntologyManager manager, Set<OWLAxiom> ontoAxioms, boolean considerEntityAnnotations, boolean ignoreAssertions, boolean useOptimization) {
        this.ontologyManager = manager;
        this.ontologyAxioms = ontoAxioms;
        this.considerAnnotations = considerEntityAnnotations;
        this.ignoreAssertions = ignoreAssertions;
        this.useOptimization = useOptimization;
        if (useOptimization) {
            this.indexEntities();
        }
    }

    public void clearStrutures() {
        this.ontologyAxioms.clear();
        this.moduleAxioms.clear();
        this.moduleSignature.clear();
        this.newMembers.clear();
        this.entity2Axioms.clear();
        this.inputSignature.clear();
    }

    private void indexEntities() {
        for (OWLAxiom ax : this.ontologyAxioms) {
            for (OWLEntity ent : ax.getSignature()) {
                if (!this.entity2Axioms.containsKey(ent)) {
                    this.entity2Axioms.put(ent, new HashSet());
                }
                this.entity2Axioms.get(ent).add(ax);
            }
        }
    }

    public Set<OWLAxiom> getModuleAxioms() {
        return this.moduleAxioms;
    }

    public Set<OWLEntity> getModuleEntities() {
        return this.moduleSignature;
    }

    public OWLOntology getModuleOntology() throws OWLOntologyCreationException {
        return this.getModuleOntology("http://krono.act.uji.es/ontologies/module.owl");
    }

    public OWLOntology getModuleOntology(String iri_str) throws OWLOntologyCreationException {
        return this.ontologyManager.createOntology(this.moduleAxioms, IRI.create((String)iri_str));
    }

    private Set<OWLAxiom> getOntologyAxioms() {
        return this.ontologyAxioms;
    }

    private static Set<OWLAxiom> getAxioms(OWLOntology ontology, boolean considerImportsClosure, boolean considerEntityAnnotations, boolean ignoreAssertions) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        Imports imports = considerImportsClosure ? Imports.INCLUDED : Imports.EXCLUDED;
        axioms.addAll(ontology.getTBoxAxioms(imports));
        axioms.addAll(ontology.getRBoxAxioms(imports));
        if (!ignoreAssertions) {
            axioms.addAll(ontology.getABoxAxioms(imports));
        }
        if (considerEntityAnnotations) {
            for (OWLClass cls : ontology.getClassesInSignature(imports)) {
                axioms.addAll(EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)ontology));
            }
            for (OWLObjectProperty oprop : ontology.getObjectPropertiesInSignature(imports)) {
                axioms.addAll(EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)oprop, (OWLOntology)ontology));
            }
            for (OWLDataProperty dprop : ontology.getDataPropertiesInSignature(imports)) {
                axioms.addAll(EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)dprop, (OWLOntology)ontology));
            }
            for (OWLAnnotationProperty aprop : ontology.getAnnotationPropertiesInSignature()) {
                axioms.addAll(EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)aprop, (OWLOntology)ontology));
            }
            if (!ignoreAssertions) {
                for (OWLNamedIndividual indiv : ontology.getIndividualsInSignature(imports)) {
                    axioms.addAll(EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)indiv, (OWLOntology)ontology));
                }
            }
        }
        return axioms;
    }

    public Set<OWLAxiom> extract(Set<OWLEntity> signature) {
        if (this.ontologyManager != null) {
            return this.extractModule4Entities(signature, this.typeModule, this.ontologyManager);
        }
        return this.extractModule4Entities(signature, this.typeModule);
    }

    public Set<OWLAxiom> extract(Set<OWLEntity> arg0, int arg1, int arg2, OWLReasoner arg3) {
        return null;
    }

    public OWLOntology extractAsOntology(OWLOntologyManager manager, Set<OWLEntity> signature, IRI iri, TYPEMODULE typeModule) throws OWLOntologyCreationException {
        return manager.createOntology(this.extractModule4Entities(signature, typeModule, manager), iri);
    }

    public OWLOntology extractAsOntology(OWLOntologyManager manager, Set<OWLEntity> signature, IRI iri) throws OWLOntologyCreationException {
        return manager.createOntology(this.extractModule4Entities(signature, TYPEMODULE.BOTTOM_LOCALITY, manager), iri);
    }

    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri) throws OWLOntologyCreationException {
        OWLOntologyManager manager = this.ontologyManager != null ? this.ontologyManager : SynchronizedOWLManager.createOWLOntologyManager();
        return manager.createOntology(this.extractModule4Entities(signature, this.typeModule, manager), iri);
    }

    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI arg1, int arg2, int arg3, OWLReasoner arg4) throws OWLOntologyCreationException {
        return null;
    }

    public Set<OWLAxiom> extractModule4Entity(OWLEntity entity, TYPEMODULE typeModule) {
        return this.extractModule4Entity(entity, typeModule, SynchronizedOWLManager.createOWLOntologyManager());
    }

    public Set<OWLAxiom> extractModule4Entity(OWLEntity entity, TYPEMODULE typeModule, OWLOntologyManager ontologyManager) {
        this.ontologyManager = ontologyManager;
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.inputSignature.clear();
        this.inputSignature.add(entity);
        this.extractModule(typeModule);
        return this.moduleAxioms;
    }

    public Set<OWLAxiom> extractModule4Entities(Set<OWLEntity> signature, TYPEMODULE typeModule) {
        return this.extractModule4Entities(signature, typeModule, SynchronizedOWLManager.createOWLOntologyManager());
    }

    public Set<OWLAxiom> extractModule4Entities(Set<OWLEntity> signature, TYPEMODULE typeModule, OWLOntologyManager ontologyManager) {
        this.ontologyManager = ontologyManager;
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.inputSignature.clear();
        this.inputSignature.addAll(signature);
        this.extractModule(typeModule);
        return this.moduleAxioms;
    }

    private void extractModule(TYPEMODULE typeModule) {
        switch (typeModule) {
            case BOTTOM_LOCALITY: {
                this.extractModule(false, false);
                break;
            }
            case TOP_LOCALITY: {
                this.extractModule(true, true);
                break;
            }
            case BOTTOM_TOP_LOCALITY: {
                this.extractStarModule(this.ontologyAxioms, 2);
                break;
            }
            case STAR: {
                this.extractStarModule(this.ontologyAxioms, 1000);
                break;
            }
            default: {
                this.extractModule(false, false);
            }
        }
    }

    public void setIncludeDeclarationAxioms(boolean includeDeclarationAxioms) {
        this.includeDeclarationAxioms = includeDeclarationAxioms;
    }

    private void extractModule(boolean dualConcepts, boolean dualRoles) {
        this.extractModule(this.ontologyAxioms, dualConcepts, dualRoles);
    }

    private void extractModule(Set<OWLAxiom> axioms, boolean dualConcepts, boolean dualRoles) {
        this.localityChecker = new SyntacticLocalityChecker(dualConcepts, dualRoles, this.considerAnnotations, this.ignoreAssertions, this.dataFactory);
        this.moduleAxioms.clear();
        this.moduleSignature.clear();
        this.moduleSignature.addAll(this.inputSignature);
        int previousSize = 0;
        if (this.includeDeclarationAxioms) {
            for (OWLEntity ent : this.moduleSignature) {
                this.moduleAxioms.add((OWLAxiom)this.dataFactory.getOWLDeclarationAxiom(ent));
            }
        }
        if (this.useOptimization) {
            while (this.moduleSignature.size() != previousSize) {
                previousSize = this.moduleSignature.size();
                for (OWLEntity ent : this.moduleSignature) {
                    try {
                        for (OWLAxiom ax : this.entity2Axioms.get(ent)) {
                            if (!axioms.contains(ax) || this.moduleAxioms.contains(ax) || this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                            this.moduleAxioms.add(ax);
                            for (OWLEntity newEnt : ax.getSignature()) {
                                if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.dataFactory.getOWLThing())) continue;
                                this.newMembers.add(newEnt);
                            }
                        }
                    }
                    catch (Exception e) {
                    }
                }
                this.moduleSignature.addAll(this.newMembers);
                this.newMembers.clear();
            }
        }
        previousSize = 0;
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : axioms) {
                if (this.moduleAxioms.contains(ax) || this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                this.moduleAxioms.add(ax);
                for (OWLEntity newEnt : ax.getSignature()) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.dataFactory.getOWLThing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
    }

    private void extractStarModule(Set<OWLAxiom> axioms, int iterations) {
        boolean type = iterations % 2 == 0;
        this.extractModule(axioms, type, type);
        if (!type && this.axiomsIterations.size() == this.getModuleAxioms().size()) {
            return;
        }
        if (--iterations <= 0) {
            return;
        }
        this.axiomsIterations.clear();
        this.axiomsIterations.addAll(this.getModuleAxioms());
        this.extractStarModule(this.axiomsIterations, iterations);
    }

    public void saveExtractedModule(OWLOntologyManager manager, OWLOntology module, String physicalModuleURI) {
        try {
            manager.saveOntology(module, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)physicalModuleURI));
        }
        catch (Exception e) {
            System.err.println("Error saving module\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public static enum TYPEMODULE {
        BOTTOM_LOCALITY,
        TOP_LOCALITY,
        BOTTOM_TOP_LOCALITY,
        STAR;

    }
}

