/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.logging;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semanticweb.elk.util.hashing.HashGenerator;

public class ElkMessage {
    private static final Pattern PATTERN_ = Pattern.compile("\\[(.+)\\](.*)");
    protected final String message;
    protected final String messageType;

    public ElkMessage(String message, String messageType) {
        this.message = message;
        this.messageType = messageType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String toString() {
        return this.message;
    }

    public int hashCode() {
        return HashGenerator.combinedHashCode((Object[])new Object[]{this.message, this.messageType});
    }

    public static ElkMessage deserialize(String message) {
        Matcher matcher = PATTERN_.matcher(message);
        if (matcher.find()) {
            String type = matcher.group(1);
            String body = matcher.group(2);
            return new ElkMessage(body, type);
        }
        return null;
    }

    public static String serialize(String type, String message) {
        return String.format("[%s]%s", type, message);
    }
}

