/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderDatatypeDefinition
extends BaseBuilder<OWLDatatypeDefinitionAxiom, BuilderDatatypeDefinition> {
    @Nullable
    private OWLDataRange range = null;
    @Nullable
    private OWLDatatype type = null;

    public BuilderDatatypeDefinition(@Nonnull OWLDatatypeDefinitionAxiom expected, OWLDataFactory df) {
        this(df);
        this.with(expected.getDatatype()).withType(expected.getDataRange()).withAnnotations(expected.getAnnotations());
    }

    @Inject
    public BuilderDatatypeDefinition(OWLDataFactory df) {
        super(df);
    }

    @Nonnull
    public BuilderDatatypeDefinition withType(OWLDataRange arg) {
        this.range = arg;
        return this;
    }

    @Nonnull
    public BuilderDatatypeDefinition with(OWLDatatype arg) {
        this.type = arg;
        return this;
    }

    @Override
    public OWLDatatypeDefinitionAxiom buildObject() {
        return this.df.getOWLDatatypeDefinitionAxiom(this.getType(), this.getRange(), this.annotations);
    }

    @Nonnull
    public OWLDataRange getRange() {
        return (OWLDataRange)OWLAPIPreconditions.verifyNotNull((Object)this.range);
    }

    @Nonnull
    public OWLDatatype getType() {
        return (OWLDatatype)OWLAPIPreconditions.verifyNotNull((Object)this.type);
    }
}

