/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.AbstractConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ModifiableLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.HashSetMultimap;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.Multimap;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class ForwardLink
extends AbstractConclusion {
    private static final Logger LOGGER_ = Logger.getLogger(ForwardLink.class);
    private final IndexedPropertyChain relation_;
    private final Context target_;

    public ForwardLink(IndexedPropertyChain relation, Context target) {
        this.relation_ = relation;
        this.target_ = target;
    }

    public IndexedPropertyChain getRelation() {
        return this.relation_;
    }

    public Context getTarget() {
        return this.target_;
    }

    public void apply(BasicSaturationStateWriter engine, Context context) {
        Multimap<IndexedPropertyChain, IndexedPropertyChain> comps = this.relation_.getSaturated().getCompositionsByLeftSubProperty();
        Multimap<IndexedPropertyChain, Context> backLinks = context.getBackwardLinksByObjectProperty();
        for (IndexedPropertyChain backwardRelation : new LazySetIntersection(comps.keySet(), backLinks.keySet())) {
            Collection compositions = comps.get((Object)backwardRelation);
            Collection sources = backLinks.get((Object)backwardRelation);
            for (IndexedPropertyChain composition : compositions) {
                for (Context source : sources) {
                    engine.produce(this.target_, new BackwardLink(source, composition));
                }
            }
        }
    }

    @Override
    public <R> R accept(ConclusionVisitor<R> visitor, Context context) {
        return visitor.visit(this, context);
    }

    public boolean addToContextBackwardLinkRule(Context context) {
        return ((ThisBackwardLinkRule)context.getBackwardLinkRuleChain().getCreate(ThisBackwardLinkRule.MATCHER_, ThisBackwardLinkRule.FACTORY_)).addForwardLink(this);
    }

    public boolean removeFromContextBackwardLinkRule(Context context) {
        ThisBackwardLinkRule rule = (ThisBackwardLinkRule)context.getBackwardLinkRuleChain().find(ThisBackwardLinkRule.MATCHER_);
        return rule != null ? rule.removeForwardLink(this) : false;
    }

    public boolean containsBackwardLinkRule(Context context) {
        ThisBackwardLinkRule rule = (ThisBackwardLinkRule)context.getBackwardLinkRuleChain().find(ThisBackwardLinkRule.MATCHER_);
        return rule != null ? rule.containsForwardLink(this) : false;
    }

    public String toString() {
        return this.relation_ + "->" + this.target_.getRoot();
    }

    public static class ThisBackwardLinkRule
    extends ModifiableLinkImpl<ModifiableLinkRule<BackwardLink>>
    implements ModifiableLinkRule<BackwardLink> {
        private static final String NAME = "ForwardLink BackwardLink Composition";
        private final Multimap<IndexedPropertyChain, Context> forwardLinksByObjectProperty_ = new HashSetMultimap(3);
        private static Matcher<ModifiableLinkRule<BackwardLink>, ThisBackwardLinkRule> MATCHER_ = new SimpleTypeBasedMatcher(ThisBackwardLinkRule.class);
        private static ReferenceFactory<ModifiableLinkRule<BackwardLink>, ThisBackwardLinkRule> FACTORY_ = new ReferenceFactory<ModifiableLinkRule<BackwardLink>, ThisBackwardLinkRule>(){

            public ThisBackwardLinkRule create(ModifiableLinkRule<BackwardLink> tail) {
                return new ThisBackwardLinkRule(tail);
            }
        };

        ThisBackwardLinkRule(ModifiableLinkRule<BackwardLink> tail) {
            super(tail);
        }

        public Multimap<IndexedPropertyChain, Context> getForwardLinksByObjectProperty() {
            return this.forwardLinksByObjectProperty_;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter engine, BackwardLink link) {
            Multimap<IndexedPropertyChain, IndexedPropertyChain> comps;
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying ForwardLink BackwardLink Composition to " + link));
            }
            if ((comps = link.getRelation().getSaturated().getCompositionsByRightSubProperty()) == null) {
                return;
            }
            Context source = link.getSource();
            for (IndexedPropertyChain forwardRelation : new LazySetIntersection(comps.keySet(), this.forwardLinksByObjectProperty_.keySet())) {
                Collection compositions = comps.get((Object)forwardRelation);
                Collection forwardTargets = this.forwardLinksByObjectProperty_.get((Object)forwardRelation);
                for (IndexedPropertyChain composition : compositions) {
                    for (Context forwardTarget : forwardTargets) {
                        engine.produce(forwardTarget, new BackwardLink(source, composition));
                    }
                }
            }
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, BackwardLink backwardLink) {
            visitor.visit(this, writer, backwardLink);
        }

        private boolean addForwardLink(ForwardLink link) {
            return this.forwardLinksByObjectProperty_.add((Object)link.relation_, (Object)link.target_);
        }

        private boolean removeForwardLink(ForwardLink link) {
            return this.forwardLinksByObjectProperty_.remove((Object)link.relation_, (Object)link.target_);
        }

        private boolean containsForwardLink(ForwardLink link) {
            return this.forwardLinksByObjectProperty_.contains((Object)link.relation_, (Object)link.target_);
        }
    }
}

