/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions;

import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.LinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;

public class BackwardLink
implements Conclusion {
    private final Context source_;
    private final IndexedPropertyChain relation_;

    public BackwardLink(Context source, IndexedPropertyChain relation) {
        this.relation_ = relation;
        this.source_ = source;
    }

    public IndexedPropertyChain getRelation() {
        return this.relation_;
    }

    public Context getSource() {
        return this.source_;
    }

    public void apply(BasicSaturationStateWriter writer, Context context, RuleApplicationVisitor ruleAppVisitor) {
        if (context.getBackwardLinksByObjectProperty().get((Object)this.relation_).size() == 1) {
            IndexedObjectSomeValuesFrom.generatePropagations(writer, this.relation_, context);
        }
        for (LinkRule backLinkRule = context.getBackwardLinkRuleHead(); backLinkRule != null; backLinkRule = (LinkRule)backLinkRule.next()) {
            backLinkRule.accept(ruleAppVisitor, writer, (BackwardLink)this);
        }
        if (!this.relation_.getSaturated().getCompositionsByLeftSubProperty().isEmpty()) {
            writer.produce(this.source_, new ForwardLink(this.relation_, context));
        }
    }

    @Override
    public Context getSourceContext(Context contextWhereStored) {
        return this.source_;
    }

    public String toString() {
        return this.relation_ + "<-" + this.source_;
    }

    @Override
    public <R> R accept(ConclusionVisitor<R> visitor, Context context) {
        return visitor.visit(this, context);
    }
}

