/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedAxiomVisitor;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.PositiveSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class IndexedSubClassOfAxiom
extends IndexedAxiom {
    private static final Logger LOGGER_ = Logger.getLogger(IndexedSubClassOfAxiom.class);
    private final IndexedClassExpression subClass_;
    private final IndexedClassExpression superClass_;

    protected IndexedSubClassOfAxiom(IndexedClassExpression subClass, IndexedClassExpression superClass) {
        this.subClass_ = subClass;
        this.superClass_ = superClass;
    }

    public IndexedClassExpression getSubClass() {
        return this.subClass_;
    }

    public IndexedClassExpression getSuperClass() {
        return this.superClass_;
    }

    @Override
    public boolean occurs() {
        return false;
    }

    @Override
    public String toStringStructural() {
        return "SubClassOf(" + this.subClass_ + ' ' + this.superClass_ + ')';
    }

    @Override
    public <O> O accept(IndexedAxiomVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected void updateOccurrenceNumbers(ModifiableOntologyIndex index, int increment) {
        if (increment > 0) {
            index.add(this.subClass_, new ThisCompositionRule(this.superClass_));
        } else {
            index.remove(this.subClass_, new ThisCompositionRule(this.superClass_));
        }
    }

    public static class ThisCompositionRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        private static final String NAME = "SubClassOf Expansion";
        private final List<IndexedClassExpression> toldSuperClassExpressions_ = new ArrayList<IndexedClassExpression>(1);
        private static final Matcher<ChainableRule<Context>, ThisCompositionRule> MATCHER_ = new SimpleTypeBasedMatcher(ThisCompositionRule.class);
        private static final ReferenceFactory<ChainableRule<Context>, ThisCompositionRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ThisCompositionRule>(){

            public ThisCompositionRule create(ChainableRule<Context> tail) {
                return new ThisCompositionRule(tail);
            }
        };

        ThisCompositionRule(ChainableRule<Context> tail) {
            super(tail);
        }

        ThisCompositionRule(IndexedClassExpression ice) {
            super(null);
            this.toldSuperClassExpressions_.add(ice);
        }

        public Collection<IndexedClassExpression> getToldSuperclasses() {
            return this.toldSuperClassExpressions_;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying " + this.toString() + " to " + context));
            }
            for (IndexedClassExpression implied : this.toldSuperClassExpressions_) {
                writer.produce(context, new PositiveSubsumer(implied));
            }
        }

        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = (ThisCompositionRule)ruleChain.getCreate(MATCHER_, FACTORY_);
            boolean changed = false;
            for (IndexedClassExpression ice : this.toldSuperClassExpressions_) {
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)("Adding " + ice.toString() + " to " + NAME));
                }
                changed |= rule.addToldSuperClassExpression(ice);
            }
            return changed;
        }

        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = (ThisCompositionRule)ruleChain.find(MATCHER_);
            boolean changed = false;
            if (rule != null) {
                for (IndexedClassExpression ice : this.toldSuperClassExpressions_) {
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)("Removing " + ice.toString() + " from " + NAME));
                    }
                    changed |= rule.removeToldSuperClassExpression(ice);
                }
                if (rule.isEmpty()) {
                    ruleChain.remove(MATCHER_);
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)"SubClassOf Expansion: removed");
                    }
                    return true;
                }
            }
            return changed;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }

        protected boolean addToldSuperClassExpression(IndexedClassExpression superClassExpression) {
            return this.toldSuperClassExpressions_.add(superClassExpression);
        }

        protected boolean removeToldSuperClassExpression(IndexedClassExpression superClassExpression) {
            return this.toldSuperClassExpressions_.remove(superClassExpression);
        }

        private boolean isEmpty() {
            return this.toldSuperClassExpressions_.isEmpty();
        }

        public String toString() {
            return this.getName() + ": " + this.toldSuperClassExpressions_;
        }
    }
}

