/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.semanticweb.elk.io.FileUtils;

public class IOUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void closeQuietly(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[2048];
        BufferedInputStream in = new BufferedInputStream(input, 2048);
        BufferedOutputStream out = new BufferedOutputStream(output, 2048);
        int count = 0;
        int n = 0;
        try {
            while ((n = in.read(buffer, 0, 2048)) != -1) {
                out.write(buffer, 0, n);
                count += n;
            }
            out.flush();
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
        return count;
    }

    public static List<String> getResourceNamesFromDir(File dir, String extension) {
        ArrayList<String> testResources = new ArrayList<String>();
        for (String fileName : dir.list(FileUtils.getExtBasedFilenameFilter(extension))) {
            testResources.add(dir.getName() + "/" + fileName);
        }
        return testResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResourceNamesFromJAR(String path, String extension, Class<?> clazz) throws IOException {
        ZipInputStream zip;
        ArrayList<String> testResources;
        block4: {
            block3: {
                CodeSource src = clazz.getProtectionDomain().getCodeSource();
                testResources = new ArrayList<String>();
                zip = null;
                if (src == null) break block3;
                URL jar = src.getLocation();
                ZipEntry ze = null;
                try {
                    zip = new ZipInputStream(jar.openStream());
                    while ((ze = zip.getNextEntry()) != null) {
                        String entryName = ze.getName();
                        if (!entryName.startsWith(path) || !entryName.endsWith("." + extension)) continue;
                        testResources.add(entryName);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zip);
                    throw throwable;
                }
                break block4;
            }
            throw new IOException("Unable to get code source for " + clazz.getSimpleName());
        }
        IOUtils.closeQuietly(zip);
        return testResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readInteger(URL src, int radix) throws IOException {
        String line = null;
        InputStream stream = null;
        try {
            stream = src.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            line = reader.readLine();
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        return Integer.parseInt(line, radix);
    }
}

