/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.collect.Iterables;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.util.collections.SmallSet;

public class MapPointer<K, V extends OWLAxiom> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INITIAL_CAPACITY = 5;
    @Nullable
    private final AxiomType<?> type;
    @Nullable
    private final OWLAxiomVisitorEx<?> visitor;
    private boolean initialized;
    @Nonnull
    protected final Internals i;
    private SoftReference<Set<IRI>> iris;
    private int size = 0;
    private final THashMap<K, Collection<V>> map = new THashMap(17, 0.75f);
    private boolean neverTrimmed = true;
    private static AtomicLong totalInUse = new AtomicLong(0L);
    private static AtomicLong totalAllocated = new AtomicLong(0L);

    public MapPointer(@Nullable AxiomType<?> t, @Nullable OWLAxiomVisitorEx<?> v, boolean initialized, @Nonnull Internals i) {
        this.type = t;
        this.visitor = v;
        this.initialized = initialized;
        this.i = (Internals)OWLAPIPreconditions.checkNotNull((Object)i, (String)"i cannot be null");
    }

    public synchronized boolean containsReference(OWLEntity e) {
        return this.map.containsKey((Object)e);
    }

    public synchronized boolean containsReference(IRI e) {
        Set<IRI> set = null;
        if (this.iris != null) {
            set = this.iris.get();
        }
        if (set == null) {
            set = this.initSet();
        }
        return set.contains(e);
    }

    private Set<IRI> initSet() {
        Set set = CollectionFactory.createSet();
        for (Object k : this.map.keySet()) {
            if (k instanceof OWLEntity) {
                set.add(((OWLEntity)k).getIRI());
                continue;
            }
            if (!(k instanceof IRI)) continue;
            set.add((IRI)k);
        }
        this.iris = new SoftReference<Set>(set);
        return set;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized MapPointer<K, V> init() {
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        if (this.visitor == null) {
            return this;
        }
        if (this.visitor instanceof InitVisitorFactory.InitVisitor) {
            for (OWLAxiom ax : this.i.getAxiomsByType().getValues(this.type)) {
                Object key = ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitVisitor)this.visitor));
                if (key == null) continue;
                this.putInternal(key, ax);
            }
        } else {
            for (OWLAxiom ax : this.i.getAxiomsByType().getValues(this.type)) {
                Collection keys = (Collection)ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitCollectionVisitor)this.visitor));
                for (Object key : keys) {
                    this.putInternal(key, ax);
                }
            }
        }
        return this;
    }

    @Nonnull
    public synchronized String toString() {
        return this.initialized + this.map.toString();
    }

    @Nonnull
    public synchronized Iterable<K> keySet() {
        this.init();
        Set keySet = this.map.keySet();
        assert (keySet != null);
        return keySet;
    }

    @Nonnull
    public synchronized List<V> getValues(K key) {
        this.init();
        return this.get(key);
    }

    @Nonnull
    public synchronized <T> Collection<OWLAxiom> filterAxioms(@Nonnull OWLAxiomSearchFilter filter, @Nonnull T key) {
        this.init();
        ArrayList<OWLAxiom> toReturn = new ArrayList<OWLAxiom>();
        for (AxiomType at : filter.getAxiomTypes()) {
            Collection collection = (Collection)this.map.get((Object)at);
            if (collection == null) continue;
            for (OWLAxiom ax : collection) {
                assert (ax != null);
                if (!filter.pass(ax, key)) continue;
                toReturn.add(ax);
            }
        }
        return toReturn;
    }

    public synchronized boolean hasValues(K key) {
        this.init();
        return this.map.containsKey(key);
    }

    public synchronized boolean put(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.putInternal(key, value);
    }

    public synchronized boolean remove(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.removeInternal(key, value);
    }

    @Nonnull
    public synchronized Boolean containsKey(K key) {
        this.init();
        return this.map.containsKey(key);
    }

    public synchronized boolean contains(K key, V value) {
        this.init();
        return this.containsEntry(key, value);
    }

    @Nonnull
    public synchronized Iterable<V> getAllValues() {
        this.init();
        return this.values();
    }

    public synchronized int size() {
        this.init();
        if (this.neverTrimmed) {
            this.trimToSize();
        }
        return this.size;
    }

    public synchronized boolean isEmpty() {
        this.init();
        return this.size == 0;
    }

    private boolean putInternal(K k, V v) {
        Collection<V> set = (Set<V>)this.map.get(k);
        if (set == null) {
            set = Collections.singleton(v);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        if (set.size() == 1) {
            if (set.contains(v)) {
                return false;
            }
            set = new SmallSet<V>(set);
            this.map.put(k, set);
        } else if (set.size() == 3) {
            if (set.contains(v)) {
                return false;
            }
            set = this.makeSet(set, v);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        boolean added = set.add(v);
        if (added) {
            ++this.size;
        }
        return added;
    }

    private boolean containsEntry(K k, V v) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return false;
        }
        return t.contains(v);
    }

    private boolean removeInternal(K k, V v) {
        Collection t;
        if (this.neverTrimmed) {
            this.trimToSize();
        }
        if ((t = (Collection)this.map.get(k)) == null) {
            return false;
        }
        if (t.size() == 1) {
            if (t.contains(v)) {
                this.map.remove(k);
                --this.size;
                return true;
            }
            return false;
        }
        boolean removed = t.remove(v);
        if (removed) {
            --this.size;
        }
        if (t.isEmpty()) {
            this.map.remove(k);
        }
        return removed;
    }

    private Collection<V> makeSet(Collection<V> collection, V extra) {
        if (this.neverTrimmed) {
            ArrayList<V> list = new ArrayList<V>(collection);
            list.add(extra);
            return list;
        }
        return new THashSetForSet<V>(collection, extra, 5, 0.75f);
    }

    @Nonnull
    private Iterable<V> values() {
        return Iterables.concat((Iterable)this.map.values());
    }

    @Nonnull
    private List<V> get(K k) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return CollectionFactory.emptyList();
        }
        return new ArrayList(t);
    }

    public synchronized void trimToSize() {
        if (this.initialized) {
            this.map.trimToSize();
            this.neverTrimmed = false;
            for (Map.Entry entry : this.map.entrySet()) {
                Collection set = (Collection)entry.getValue();
                if (set instanceof ArrayList) {
                    THashSet value = new THashSet(5, 0.75f);
                    value.addAll(set);
                    entry.setValue(value);
                    this.size = this.size - set.size() + value.size();
                    value.trimToSize();
                    continue;
                }
                if (set instanceof THashSet) {
                    THashSet vs = (THashSet)set;
                    vs.trimToSize();
                    totalInUse.addAndGet(set.size());
                    totalAllocated.addAndGet(vs.capacity());
                    continue;
                }
                if (set instanceof SmallSet) {
                    totalInUse.addAndGet(set.size());
                    totalAllocated.addAndGet(3L);
                    continue;
                }
                totalInUse.addAndGet(1L);
                totalAllocated.addAndGet(1L);
            }
        }
    }

    static void resetCounts() {
        totalAllocated.set(0L);
        totalInUse.set(0L);
    }

    static long getTotalInUse() {
        return totalInUse.get();
    }

    static long getTotalAllocated() {
        return totalAllocated.get();
    }

    private static class THashSetForSet<E>
    extends THashSet<E> {
        private boolean constructing = true;

        public THashSetForSet(Collection<E> set, E toAdd, int capacity, float load) {
            super(capacity, load);
            for (E e : set) {
                this.add(e);
            }
            this.add(toAdd);
            this.constructing = false;
        }

        protected boolean equals(Object notnull, Object two) {
            if (this.constructing) {
                return notnull == two;
            }
            return super.equals(notnull, two);
        }
    }
}

