/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriter;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public class RDFXMLWriter {
    @Nonnull
    private static final IRI RDF_RDF = IRI.create((String)Namespaces.RDF.getPrefixIRI(), (String)"RDF");
    @Nonnull
    private static final IRI RDF_RESOURCE = IRI.create((String)Namespaces.RDF.getPrefixIRI(), (String)"resource");
    @Nonnull
    private static final String XML_LANG = "xml:lang";
    @Nonnull
    private static final IRI RDF_NODEID = IRI.create((String)Namespaces.RDF.getPrefixIRI(), (String)"nodeID");
    @Nonnull
    private static final IRI RDF_ABOUT = IRI.create((String)Namespaces.RDF.getPrefixIRI(), (String)"about");
    @Nonnull
    private static final IRI RDF_DATATYPE = IRI.create((String)Namespaces.RDF.getPrefixIRI(), (String)"datatype");
    @Nonnull
    private static final IRI PARSETYPE_IRI = IRI.create((String)Namespaces.RDF.getPrefixIRI(), (String)"parseType");
    private final XMLWriter writer;

    protected RDFXMLWriter(@Nonnull XMLWriter writer) {
        this.writer = (XMLWriter)OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null");
    }

    public void writeStartElement(@Nonnull IRI elementName) throws IOException {
        this.writer.writeStartElement((IRI)OWLAPIPreconditions.checkNotNull((Object)elementName, (String)"elementName cannot be null"));
    }

    public void writeParseTypeAttribute() throws IOException {
        this.writer.writeAttribute(PARSETYPE_IRI, "Collection");
    }

    public void writeDatatypeAttribute(@Nonnull IRI datatypeIRI) throws IOException {
        OWLAPIPreconditions.checkNotNull((Object)datatypeIRI, (String)"datatypeIRI cannot be null");
        this.writer.writeAttribute(RDF_DATATYPE, datatypeIRI.toString());
    }

    public void writeTextContent(@Nonnull String text) throws IOException {
        this.writer.writeTextContent(text);
    }

    public void writeLangAttribute(@Nonnull String lang) throws IOException {
        this.writer.writeAttribute(XML_LANG, lang);
    }

    public void writeEndElement() throws IOException {
        this.writer.writeEndElement();
    }

    public void writeAboutAttribute(@Nonnull IRI value) throws IOException {
        this.writeAttribute(RDF_ABOUT, value);
    }

    public void writeNodeIDAttribute(@Nonnull RDFResourceBlankNode node) throws IOException {
        this.writer.writeAttribute(RDF_NODEID, node.toString());
    }

    public void writeAttribute(@Nonnull IRI attributeName, @Nonnull IRI value) throws IOException {
        this.writer.writeAttribute(attributeName, ((IRI)OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null")).toString());
    }

    public void writeOWLObject(OWLObject owlObject) {
    }

    public void writeResourceAttribute(@Nonnull IRI value) throws IOException {
        this.writeAttribute(RDF_RESOURCE, value);
    }

    public void startDocument() throws IOException {
        this.writer.startDocument(RDF_RDF);
    }

    public void endDocument() throws IOException {
        this.writer.endDocument();
    }

    public void writeComment(@Nonnull String comment) throws IOException {
        this.writer.writeComment(comment);
    }
}

