/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.krss2.renderer.KRSS2Vocabulary;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class KRSS2OWLObjectRenderer
extends OWLObjectVisitorAdapter {
    @Nonnull
    private final Writer writer;

    public KRSS2OWLObjectRenderer(@Nonnull Writer writer) {
        this.writer = (Writer)OWLAPIPreconditions.checkNotNull((Object)writer);
    }

    private void writeOpenBracket() {
        try {
            this.writer.write("(");
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void writeCloseBracket() {
        try {
            this.writer.write(")");
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(int i) {
        try {
            this.writer.write(" " + i);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(@Nonnull IRI iri) {
        try {
            this.writer.write(iri.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void writeAttribute(KRSS2Vocabulary v) {
        try {
            this.writeSpace();
            this.writer.write(":");
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(KRSS2Vocabulary v) {
        try {
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void writeSpace() {
        try {
            this.writer.write(" ");
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void writeln() {
        try {
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(OWLClassExpression obj) {
        this.writeSpace();
        obj.accept((OWLObjectVisitor)this);
    }

    private void write(OWLIndividual ind) {
        this.writeSpace();
        ind.accept((OWLObjectVisitor)this);
    }

    private void write(OWLPropertyExpression obj) {
        this.writeSpace();
        obj.accept((OWLObjectVisitor)this);
    }

    private void write(OWLDataRange obj) {
        this.writeSpace();
        obj.accept((OWLObjectVisitor)this);
    }

    private void flatten(Collection<OWLClassExpression> inputClassExpressions) {
        ArrayList<OWLClassExpression> classExpressions = inputClassExpressions instanceof List ? (ArrayList<OWLClassExpression>)inputClassExpressions : new ArrayList<OWLClassExpression>(inputClassExpressions);
        if (classExpressions.isEmpty()) {
            return;
        }
        OWLClassExpression desc = (OWLClassExpression)classExpressions.iterator().next();
        if (classExpressions.size() == 1) {
            this.write(desc);
            return;
        }
        classExpressions.remove(0);
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        this.write(desc);
        this.flatten(classExpressions);
        this.writeCloseBracket();
    }

    public void visit(OWLOntology ontology) {
        for (OWLClass eachClass : ontology.getClassesInSignature()) {
            boolean primitive;
            assert (eachClass != null);
            boolean bl = primitive = !EntitySearcher.isDefined((OWLClass)eachClass, (OWLOntology)ontology);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write((OWLClassExpression)eachClass);
                this.writeSpace();
                Collection axioms = ontology.filterAxioms(Filters.subClassWithSub, (Object)eachClass, Imports.INCLUDED);
                Collection superClasses = Searcher.sup((Collection)axioms, OWLClassExpression.class);
                this.flatten(superClasses);
                this.writeCloseBracket();
                this.writeln();
                Collection classes = Searcher.equivalent((Collection)ontology.getEquivalentClassesAxioms(eachClass), OWLClassExpression.class);
                for (OWLClassExpression classExpression : classes) {
                    this.writeOpenBracket();
                    this.write((OWLClassExpression)eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.writeSpace();
                    classExpression.accept((OWLObjectVisitor)this);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write((OWLClassExpression)eachClass);
            Collection classes = Searcher.equivalent((Collection)ontology.getEquivalentClassesAxioms(eachClass), OWLClassExpression.class);
            if (classes.isEmpty()) {
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            if (classes.size() == 1) {
                this.write((OWLClassExpression)classes.iterator().next());
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            Iterator iter = classes.iterator();
            this.write((OWLClassExpression)iter.next());
            this.writeCloseBracket();
            this.writeln();
            while (iter.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.EQUIVALENT);
                this.write((OWLClassExpression)eachClass);
                this.writeSpace();
                ((OWLClassExpression)iter.next()).accept((OWLObjectVisitor)this);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLClassAxiom axiom : ontology.getGeneralClassAxioms()) {
            axiom.accept((OWLObjectVisitor)this);
        }
        for (OWLObjectProperty property : ontology.getObjectPropertiesInSignature()) {
            Collection axioms;
            Collection superProperties;
            Collection ranges;
            Collection domains;
            assert (property != null);
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
            this.write((OWLPropertyExpression)property);
            if (EntitySearcher.isTransitive((OWLObjectPropertyExpression)property, (OWLOntology)ontology)) {
                this.writeAttribute(KRSS2Vocabulary.TRANSITIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (EntitySearcher.isSymmetric((OWLObjectPropertyExpression)property, (OWLOntology)ontology)) {
                this.writeAttribute(KRSS2Vocabulary.SYMMETRIC_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (!(domains = Searcher.domain((Collection)ontology.getObjectPropertyDomainAxioms((OWLObjectPropertyExpression)property))).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.DOMAIN);
                this.flatten(domains);
            }
            if (!(ranges = Searcher.range((Collection)ontology.getObjectPropertyRangeAxioms((OWLObjectPropertyExpression)property))).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.RANGE_ATTR);
                this.flatten(ranges);
            }
            if (!(superProperties = Searcher.sup((Collection)(axioms = ontology.filterAxioms(Filters.subObjectPropertyWithSub, (Object)property, Imports.INCLUDED)), OWLObjectPropertyExpression.class)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.PARENTS_ATTR);
                this.writeOpenBracket();
                for (OWLObjectPropertyExpression express : superProperties) {
                    this.write((OWLPropertyExpression)express);
                }
                this.writeCloseBracket();
            }
            this.writeCloseBracket();
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            throw new OWLRuntimeException((Throwable)io);
        }
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.IMPLIES);
        this.write(axiom.getSubClass());
        this.write(axiom.getSuperClass());
        this.writeCloseBracket();
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.writeOpenBracket();
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            this.write(desc);
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write((OWLIndividual)axiom.getObject());
        this.write(axiom.getProperty());
        this.writeln();
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.INSTANCE);
        this.write(axiom.getIndividual());
        this.write(axiom.getClassExpression());
        this.writeln();
    }

    public void visit(OWLClass ce) {
        this.write(ce.getIRI());
    }

    public void visit(OWLObjectIntersectionOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        for (OWLClassExpression des : ce.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectUnionOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.OR);
        for (OWLClassExpression des : ce.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectComplementOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.NOT);
        this.write(ce.getOperand());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write((OWLPropertyExpression)ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write((OWLPropertyExpression)ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write((OWLPropertyExpression)ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write((OWLPropertyExpression)ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write((OWLPropertyExpression)ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write((OWLPropertyExpression)ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLDataAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write((OWLPropertyExpression)ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLDataMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write((OWLPropertyExpression)ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLDataExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write((OWLPropertyExpression)ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLDataMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write((OWLPropertyExpression)ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    public void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INVERSE);
        this.writeSpace();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLDataProperty property) {
        this.write(property.getIRI());
    }

    public void visit(OWLNamedIndividual individual) {
        this.write(individual.getIRI());
    }
}

