# generated by datamodel-codegen:
#   filename:  well_known_types.yaml

from __future__ import annotations

from enum import Enum
from typing import Any, Union

from pydantic import BaseModel, Field, constr


class Model(BaseModel):
    __root__: Any


class String(BaseModel):
    __root__: str = Field(..., description='Arbitrary text')


class BinaryData(BaseModel):
    __root__: constr(
        regex=r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$'
    ) = Field(
        ...,
        description='Arbitrary binary data. Represented as base64-encoded strings in the JSON transport. In the future, if we support other transports, may be encoded differently.\n',
    )


class Date(BaseModel):
    __root__: constr(regex=r'^\d{4}-\d{2}-\d{2}( BC)?$') = Field(
        ..., description="RFC 3339§5.6's full-date format, extended with BC era support"
    )


class TimestampWithTimezone(BaseModel):
    __root__: constr(
        regex=r'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[+\-]\d{1,2}:\d{2})( BC)?$'
    ) = Field(
        ...,
        description='An instant in time. Frequently simply referred to as just a timestamp, or timestamptz. Uses RFC 3339§5.6\'s date-time format, requiring a "T" separator, and extended with BC era support. Note that we do _not_ accept Unix epochs here.\n',
    )


class TimestampWithoutTimezone(BaseModel):
    __root__: constr(
        regex=r'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?( BC)?$'
    ) = Field(
        ...,
        description='Also known as a localdatetime, or just datetime. Under RFC 3339§5.6, this would be represented as `full-date "T" partial-time`, extended with BC era support.\n',
    )


class TimeWithTimezone(BaseModel):
    __root__: constr(
        regex=r'^\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[+\-]\d{1,2}:\d{2})$'
    ) = Field(..., description='An RFC 3339§5.6 full-time')


class TimeWithoutTimezone(BaseModel):
    __root__: constr(regex=r'^\d{2}:\d{2}:\d{2}(\.\d+)?$') = Field(
        ..., description='An RFC 3339§5.6 partial-time'
    )


class NumberEnum(Enum):
    Infinity = 'Infinity'
    _Infinity = '-Infinity'
    NaN = 'NaN'


class Number(BaseModel):
    __root__: Union[Any, NumberEnum] = Field(
        ...,
        description='Note the mix of regex validation for normal numbers, and enum validation for special values.',
    )


class IntegerEnum(Enum):
    Infinity = 'Infinity'
    _Infinity = '-Infinity'
    NaN = 'NaN'


class Integer(BaseModel):
    __root__: Union[Any, IntegerEnum]


class Boolean(BaseModel):
    __root__: bool = Field(
        ...,
        description="Note the direct usage of a primitive boolean rather than string. Unlike Numbers and Integers, we don't expect unusual values  here.",
    )
