# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-07-06 06:54
from __future__ import unicode_literals

from django.db import migrations


def setup_relationships(apps, schema):
    PageModule = apps.get_model('pages', 'PageModule')

    feeds_module = PageModule.objects.get(slug='feeds')
    feeds_module.related_model = 'feeds.Feed'
    feeds_module.save(update_fields=['related_model'])

    shop_module = PageModule.objects.get(slug='shop')
    shop_module.related_model = 'shop.ProductCategory'
    shop_module.save(update_fields=['related_model'])


def drop_relationships(apps, schema):
    PageModule = apps.get_model('pages', 'PageModule')

    PageModule.objects.all().update(related_model=None)


class Migration(migrations.Migration):
    dependencies = [
        ('pages', '0004_insert_pagemodules'),
    ]

    operations = [
        migrations.RunPython(setup_relationships, drop_relationships)
    ]
