# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-05-20 02:26
from __future__ import unicode_literals

from django.db import migrations
from django.utils.translation import gettext_lazy as _
from django.utils import translation


MODULE_GROUPS = [
    {
        'sort': 1,
        'description': '',
        'fa': 'fa-flag',
        'slug': 'admin',
        'name': _('Administration'),
        'modules': [
            {
                'sort': 1,
                'is_enabled': True,
                'name': _('CMS Users'),
                'slug': 'cms-users',
                'description': ''
            }
        ]
    },
    {
        'sort': 2,
        'description': '',
        'fa': 'fa-file',
        'slug': 'content',
        'name': _('Content'),
        'modules': [
            {
                'sort': 1,
                'is_enabled': True,
                'name': _('Site Structure'),
                'slug': 'sitemap',
                'description': ''
            },
            {
                'sort': 2,
                'is_enabled': True,
                'name': _('Feeds'),
                'slug': 'feeds',
                'description': ''
            }
        ]
    },
    {
        'sort': 3,
        'description': '',
        'fa': 'fa-cog',
        'slug': 'service',
        'name': _('Services')
    }
]


def insert_modules(apps, schema):
    from django.conf import settings
    translation.activate(settings.LANGUAGE_CODE)

    ModuleGroup = apps.get_model('modules', 'ModuleGroup')
    Module = apps.get_model('modules', 'Module')

    for group in MODULE_GROUPS:
        group_modules = group.pop('modules', [])
        group = ModuleGroup.objects.create(**group)
        for module in group_modules:
            module['group'] = group
            Module.objects.create(**module)

    translation.deactivate()


def delete_modules(apps, schema):
    ModuleGroup = apps.get_model('modules', 'ModuleGroup')
    for group in MODULE_GROUPS:
        ModuleGroup.objects.get(slug=group['slug']).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('modules', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(insert_modules, delete_modules)
    ]

