# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-07-05 02:34
from __future__ import unicode_literals

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Ad',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_from', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Start Date')),
                ('date_to', models.DateTimeField(default=django.utils.timezone.now, verbose_name='End Date')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('title', models.TextField(blank=True, default=b'', verbose_name='Ad Text')),
                ('link', models.URLField(blank=True, default=b'', verbose_name='Ad Link')),
                ('code', models.TextField(blank=True, default=b'', verbose_name='Embed Code')),
                ('bg', models.CharField(blank=True, default=b'', max_length=255, verbose_name='Background Color')),
                ('views', models.IntegerField(default=0, verbose_name='Views')),
                ('picture', models.FileField(blank=True, null=True, upload_to=b'b/%Y/%m/%d', verbose_name='Picture')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Is Enabled')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_changed', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['name'],
                'abstract': False,
                'verbose_name': 'ad',
                'verbose_name_plural': 'ads',
            },
        ),
        migrations.CreateModel(
            name='AdPlace',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('slug', models.SlugField(unique=True)),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Is Enabled')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'ad place',
                'verbose_name_plural': 'ad places',
            },
        ),
        migrations.CreateModel(
            name='AdSection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Is Enabled')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'ad section',
                'verbose_name_plural': 'ad sections',
            },
        ),
        migrations.AddField(
            model_name='ad',
            name='place',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ads_ad_related', to='ads.AdPlace', verbose_name='Ad Place'),
        ),
        migrations.AddField(
            model_name='ad',
            name='section',
            field=models.ManyToManyField(related_name='ads_ad_related', to='ads.AdSection', verbose_name='Section'),
        ),
    ]
