# Vane 2.0: A web application vulnerability assessment tool.
# Copyright (C) 2017-  Delve Labs inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


import copy


class VulnerabilityLister:

    def __init__(self):
        pass

    def list_vulnerabilities(self, version, vulnerability_list, no_version_match_all=False):
        if version is None:
            if no_version_match_all:
                return vulnerability_list.vulnerabilities
            else:
                return []
        applicable_vulnerability_list = []
        for vulnerability in vulnerability_list.vulnerabilities:
            if vulnerability.applies_to(version):
                if len(vulnerability.affected_versions) > 1:
                    vuln = copy.copy(vulnerability)
                    applicable_range = [versions for versions in vuln.affected_versions if versions.contains(version)]
                    vuln.affected_versions = applicable_range
                    applicable_vulnerability_list.append(vuln)
                else:
                    applicable_vulnerability_list.append(vulnerability)
        return applicable_vulnerability_list
