# general-conversors
general-conversors is a library for convert N-level dictionaries to one-level dictionaries

[![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/goldenm-software/general-conversors/blob/master/LICENSE)
[![pypi version](https://badge.fury.io/py/general-conversions.svg)](https://www.pypi.com/project/general-conversors)


## Installation
Use the package manager [pip](https://pypi.org/) to install general-conversions.

```bash
pip3 install general-conversions
```

## Usage
To 1-Level dictionary
```python
from conversor.dict import ToOneLevel

source = {
  'error': False,
  'result': {
    'executed': True,
    'payload': 'Hello world',
    'code': 200
  }
}

conversor = ToOneLevel(source=source)
result = conversor.convert()
print('Result:', result)
# Result: {'error': False, 'result.executed': True, 'result.payload': 'Hello world', 'result.code': 200}
```
To N-level level dictionary
```python
from conversor.dict import ToMultiLevel

source = {
  'error': False,
  'result.executed': True,
  'result.payload': 'Hello world',
  'result.code': 200
}

conversor = ToMultiLevel(source=source)
result = conversor.convert()
print('Result:', result)
# Result: {'error': False, 'result': {'executed': True, 'payload': 'Hello world', 'code': 200}}
```

## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

Please make sure to update tests as appropriate.

## License
[MIT](https://choosealicense.com/licenses/mit/)